

#include TI-85.h


dust         =201
laser        =50
laser_boum   =51
torp         =30
bullet       =20
bullet_boum  =21
onde         =60
mine         =40
beam         =65
arc          =70
spec2        =71
asteroid1    =211
asteroid2    =212
asteroid3    =213
asteroid4    =214
saucer1      =220
inter1       =221
inter2       =222
duck         =223
bee          =224
saucer_boss  =250  ; 250 and over:not destroyed when EE or player die
bb_rear      =251
bb1          =252
bb2          =253
pb_giver     =226
hunter       =227
turret       =228
bb_gun       =229
foe_laser    =231
homing       =232
ball         =233
fmd_laser    =234
bbg_shot     =235
dots8        =181
star1        =182
star1_plein  =183
star2        =184
star3        =185
star3b       =186
star4        =187
star4b       =188
star5        =189
star5b       =190
bigstar      =191
quasar1      =171
quasar2      =172
quasar3      =173
quasar4      =174
quasar5      =175
quasar6      =176
quasar5b     =177
h_bonus      =3
e_bonus      =4
p_bonus      =5
o_bonus      =6
torp_bonus   =7



player_data = TEXT_MEM2

player_y       = player_data  +0 ; ord1
player_x       = player_data  +1 ; ord1 ; ord mean it must follow that order
player_health  = player_data  +2
engine         = player_data  +3
game_done      = player_data  +4
weapon         = player_data  +5  ; type of gun or last firing direction
gun_power      = player_data  +6  ; pour apres la fin ; bit 0 to 3 = gun_power ; bit 7 = rear gun
gun_direction  = player_data  +7  ; pour apres la fin
n_torp         = player_data  +8
c_torp         = player_data  +9
c_bubble       = player_data +10
c_player_fire  = player_data +11
c_player_move  = player_data +12
player_thingy  = player_data +13 ; 2 bytes long ; unused
player_bits    = player_data +15 ; bit 5 = auto fire
player_flame   = player_data +16


npd = 17     ; number of bytes taken by player_data (because there's a player_data+0 it's 17 and not 16)



zwar_data = TEXT_MEM2 +npd+npd+npd   ; to let enough space for three player_data (current player, player 1, player 2)


global_time    = zwar_data  +1     ; 2 or 3 bytes long
foe_num        = zwar_data  +4     ; laisser un 0 apres
foe_addr       = zwar_data  +6     ; 2 bytes long
niv_time       = zwar_data  +8     ; 2 or 3 bytes long
c_niv          = zwar_data +11     ; 2 bytes long
rand_addr      = zwar_data +13     ; 2 bytes long
niv_num        = zwar_data +15     ; level number (niv=niveau=level)
num_niv        = niv_num
data1          = zwar_data +16    ; 2 bytes long ; unused
data2          = zwar_data +18    ; 2 bytes long ; unused
data3          = zwar_data +20    ; 2 bytes long ; unused
ftp_health     = zwar_data +22    ; 2 bytes long
ftp_type       = zwar_data +24
ftp_data       = zwar_data +25    ; 2 bytes long
ftp_xy         = zwar_data +27    ; 2 bytes long ; unused
rand_addr_max  = zwar_data +29    ; 2 bytes long
souv_shot_addr = zwar_data +31    ; 2 bytes long
souv_ftp_addr  = zwar_data +33    ; 2 bytes long
score          = zwar_data +35    ; 2 bytes long
damage         = zwar_data +37    ; 2 bytes long
key_pressed    = zwar_data +39
xmin           = zwar_data +40
xmax           = zwar_data +41
ymin           = zwar_data +42
ymax           = zwar_data +43
c_key          = zwar_data +44
c_message      = zwar_data +45
message_addr   = zwar_data +46   ; 2 bytes long
num_chars      = zwar_data +48   ; 3 bytes long
souv_h_addr    = zwar_data +52   ; 2 bytes long
shot_boum      = zwar_data +54
souv_xy_cracks = zwar_data +55   ; 2 bytes long
player_num     = zwar_data +57   ; (0 if one player)
souv_key       = zwar_data +58
allow_cheat    = zwar_data +59
temp_gun_power = zwar_data +60
souv_arc_DE    = zwar_data +61   ; 2 bytes long
souv_first_dir = zwar_data +63
souv_vat_addr  = zwar_data +64   ; 2 bytes long
save_game_addr = zwar_data +66   ; 2 bytes long
zwar_prgm_addr = zwar_data +68   ; 2 bytes long
error_byte     = zwar_data +70
trigo_center_y = zwar_data +71 ; ord2
trigo_center_x = zwar_data +72 ; ord2
trigo_angle    = zwar_data +73
trigo_dist     = zwar_data +74
scroll_type    = zwar_data +75
scroll_y       = zwar_data +76 ; ord3
scroll_x       = zwar_data +77 ; ord3
foe_angle      = zwar_data +78
fa_xy          = zwar_data +80 ; 2 bytes long
fa_step        = zwar_data +82
fa_angle       = zwar_data +84
fa_min_dist    = zwar_data +86
c_draw_bb = trigo_dist
souv_bb_xy = trigo_center_y ; 2 bytes long


foe_type         = GRAPH_MEM
foe_shot_type    = GRAPH_MEM+50
player_shot_type = GRAPH_MEM+150

foe_x            = GRAPH_MEM+250
foe_shot_x       = GRAPH_MEM+300
player_shot_x    = GRAPH_MEM+400

foe_y            = GRAPH_MEM+500
foe_shot_y       = GRAPH_MEM+550
player_shot_y    = GRAPH_MEM+650

foe_health       = GRAPH_MEM+750
foe_data         = GRAPH_MEM+850


#define noir CALL_(NOIRCIR)
#define blanc CALL_(BLANCHIR)
#define fnoir CALL_(four_noircir)
#define enoir CALL_(eight_noircir)
#define snoir CALL_(sym_noircir)
#define dim(addr)   ld A,(addr) \ CALL_(diminuer) \ ld (addr),A

nbb1  = 2
nbb2  = 3
nbbg1 = 4
nbbg2 = 5
nbbg3 = 6
nbbg4 = 7
nbbr1 = 8
nbbr2 = 9
nbb1t = 10
nbb2t = 17

    ;  beginning of real program

.org 0
.db "a game by Antoine RICHARD",0



   ld IY,33606  ; normaly IY=33606=$8346 is already true

   res 1,(IY+05) ; menu text only 6 row (not 7)   (j' ai essay et a marche)
   res 3,(IY+05) ; text black on white            (verifi aussi)
                 ; and menu text printed over current screen  (verifi aussi)
                 ; (la ligne au dessus est toujours blanche, pour la ligne du dessous on peut choisir)
   res 1,(IY+0D) ; don't alter text memory


   ld A,4
   out (5),A       ; set memory page to 4 for FIND_PIXEL


   ld A,(ZS_BITS)
   set 0,A         ; checksum again when coming back to ZShell
   ld (ZS_BITS),A


   ld HL,(PROGRAM_ADDR)
   ld (rand_addr),HL
   ld DE,9555        ; this value should be a little bit lower than the program size
   add HL,DE
   ld (rand_addr_max),HL


   ld HL,TEXT_MEM2
   ld B,160         ; il y a 168 bytes dans TEXT_MEM2
vider_TEXT_MEM2:
   ld (HL),0
   inc HL
   DJNZ vider_TEXT_MEM2


  CALL_(set_new_game)
  JUMP_(boucle1)


set_new_game:

;debut vider GRAPH_MEM
   ROM_CALL(CLEARLCD)
   ld HL,VIDEO_MEM     ; source
   ld DE,GRAPH_MEM     ; destination
   ld BC,1024          ; il y a 1024 bytes dans GRAPH_MEM
   LDIR                ; Transfer data between memory until byte counter is zero, increment destination and source addresses
;fin vider GRAPH_MEM

   ld A,100
   ld (player_health),A
   ld (player_health+npd),A
   ld (player_health+npd+npd),A


   ld A,4
   ld (n_torp),A
   ld (n_torp+npd),A
   ld (n_torp+npd+npd),A
   
   ld A,42
   ld (player_x),A
   ld (player_x+npd),A
   dec A
   ld (player_x+npd+npd),A

   ld A,32
   ld (player_y),A
   ld A,19
   ld (player_y+npd),A
   ld A,45
   ld (player_y+npd+npd),A

   ld A,1
   ld (engine),A
   ld (engine+npd),A
   ld (engine+npd+npd),A

   ld A,0
   ld (c_bubble),A
   ld (c_bubble+npd),A
   ld (c_bubble+npd+npd),A


   ld A,101
   ld (num_niv),A



   ret ; fin set_new_game


boucle1:

   ld A,(player_num)
   or A
   CALL_Z(boucle1_player)
   ld A,(player_num)
   or A
   CALL_NZ(boucle1_player12)

   dim(c_key)
   dim(c_message)

   CALL_(calc)
   CALL_(prise_key)
   CALL_(drawings)
   JUMP_(boucle1)    ; fin boucle_1


boucle1_player:
     ld A,(player_health)
     cp 0
     JUMP_Z(player_is_dead)
       ld DE,(global_time)
       inc DE
       ld  (global_time),DE
to_jump_if_dead:
   dim(c_torp)
   dim(c_bubble)
   dim(c_player_move)
   dim(c_player_fire)
   ret



boucle1_player12:


 ld HL,player_data+npd+npd
 ld DE,player_data
 ld BC,npd
 ldir
 CALL_(boucle1_player)
 ld HL,player_data
 ld DE,player_data+npd+npd
 ld BC,npd
 ldir

 ld HL,player_data+npd
 ld DE,player_data
 ld BC,npd
 ldir
 CALL_(boucle1_player)
 ld HL,player_data
 ld DE,player_data+npd
 ld BC,npd
 ldir

  ld A,(player_health+npd)
  or A
  ret z

  ld A,(player_health+npd+npd)
  or A
  ret z

  ld BC,(global_time)
  dec BC
  ld (global_time),BC

 ret


diminuer:
   dec A
   cp 255
   ret nz
   inc A
   ret



NOIRCIR:
   ld A,127
   cp B
   ret c
   ld A,63
   cp C
   ret c
   ROM_CALL(FIND_PIXEL)
   ld DE,VIDEO_MEM
   add HL,DE
   or (HL)
   ld (HL),A
   ret


BLANCHIR:
   ld A,127
   cp B
   ret c
   ld A,63
   cp C
   ret c
   ROM_CALL(FIND_PIXEL)
   ld DE,VIDEO_MEM
   add HL,DE
   xor 255
   and (HL)
   ld (HL),A
   ret


SAVOIR:
   ld A,127
   cp B
   ret c
   ld A,63
   cp C
   ret c
   ROM_CALL(FIND_PIXEL)
   ld DE,VIDEO_MEM
   add HL,DE
   and (HL)
   ret


eight_noircir:
  ld A,D
  ld D,E
  ld E,A
  CALL_(four_noircir)
  ld A,D
  ld D,E
  ld E,A
            ; continue sur four_noircir

four_noircir:

   push BC
   push DE
   ld A,B
   add A,D
   ld B,A
   ld A,C
   add A,E
   ld C,A
   CALL_(NOIRCIR)
   pop DE
   pop BC

   push BC
   push DE
   ld A,B
   add A,E
   ld B,A
   ld A,C
   sub D
   ld C,A
   CALL_(NOIRCIR)
   pop DE
   pop BC

   push BC
   push DE
   ld A,B
   sub E
   ld B,A
   ld A,C
   add A,D
   ld C,A
   CALL_(NOIRCIR)
   pop DE
   pop BC

   push BC
   push DE
   ld A,B
   sub D
   ld B,A
   ld A,C
   sub E
   ld C,A
   CALL_(NOIRCIR)
   pop DE
   pop BC

   ret   ; fin four_noircir

sym_noircir:
   push DE
   push BC
   ld A,C
   add A,E
   ld C,A
   CALL_(NOIRCIR)
   pop BC
   pop DE
   
   push DE
   push BC
   ld A,C
   sub E
   ld C,A
   CALL_(NOIRCIR)
   pop BC
   pop DE

   ret   ; fin sym_noircir



do_trigo:
  CALL_(trigo_make_BC)
  ld A,(trigo_center_x)
  add A,B
  ld B,A
  ld A,(trigo_center_y)
  add A,C
  ld C,A
  ret


trigo_make_BC:
   ld A,(trigo_dist)
   cp 0
   ld BC,0
   ret z
   ld A,(trigo_angle)
   cp 64
   JUMP_C(angle_0_63)
   cp 128
   JUMP_C(angle_64_127)
   cp 192
   JUMP_C(angle_128_191)
   JUMP_(angle_192_255)



angle_0_63:
   ld A,64
   ld HL,trigo_angle
   sub (HL)
   CALL_(trigo_mult1)
   ld C,H

   ld A,(trigo_angle)
   CALL_(trigo_mult1)
   ld B,H
   ret


angle_64_127:
   ld A,(trigo_angle)
   and 63
   CALL_(trigo_mult1)
   ld C,H

   ld A,128
   ld HL,trigo_angle
   sub (HL)
   CALL_(trigo_mult2)
   ld B,H
   ret


angle_128_191:
   ld A,192
   ld HL,trigo_angle
   sub (HL)
   CALL_(trigo_mult2)
   ld C,H

   ld A,(trigo_angle)
   and 63
   CALL_(trigo_mult2)
   ld B,H
   ret


angle_192_255:
   ld A,(trigo_angle)
   and 63
   CALL_(trigo_mult2)
   ld C,H

   ld A,0
   ld HL,trigo_angle
   sub (HL)
   CALL_(trigo_mult1)
   ld B,H
   ret


trigo_mult1:
     cp 65
     JUMP_NC(find_bug)
     ld HL,(PROGRAM_ADDR)
     ld DE,trigo_data
     add HL,DE
     ld D,0
     ld E,A
     add HL,DE
     ld D,0
     ld E,(HL)
       ld HL,128  ; 128 or 0 or ... ?
     ld A,(trigo_dist)
     ld B,A
trigo_mult1_loop:
   add HL,DE
   djnz trigo_mult1_loop
   ret

trigo_mult2:
     cp 65
     JUMP_NC(find_bug)
     ld HL,(PROGRAM_ADDR)
     ld DE,trigo_data
     add HL,DE
     ld D,0
     ld E,A
     add HL,DE
     ld D,0
     ld E,(HL)
       ld HL,128  ; 128 or 0 or ... ?
     ld A,(trigo_dist)
     ld B,A
trigo_mult2_loop:
   cp 0
   sbc HL,DE
   djnz trigo_mult2_loop
   ret


trigo_data:
   ;  0   1   2   3   4   5   6   7
.db 255,255,255,254,254,253,252,251
   ;  8   9  10  11  12  13  14  15
.db 250,249,247,246,244,242,240,238
   ; 16  17  18  19  20  21  22  23
.db 236,233,231,228,225,222,219,215
   ; 24  25  26  27  28  29  30  31
.db 212,208,205,201,197,193,189,185
   ; 32  33  34  35  36  37  38  39
.db 182,176,174,167,162,157,152,147
   ; 40  41  42  43  44  45  46  47
.db 142,136,131,126,120,115,109,103
   ; 48  49  50  51  52  53  54  55
.db  98, 92, 86, 80, 74, 68, 62, 56
   ; 56  57  58  59  60  61  62  63  64
.db  50, 44, 37, 31, 25, 19, 13,  6,  0


find_p_angle:
  CALL_(get_a_player_xy)
  ld HL,(foe_num)
  ld DE,foe_x
  add HL,DE
  ld A,B
  sub (HL)
  add A,128
  ld B,A
    ld HL,(foe_num)
    ld DE,foe_y
    add HL,DE
    ld A,C
    sub (HL)
    add A,128
    ld C,A
find_angle:
    ld (fa_xy),BC
  ld DE,$8080  ; 128,128
  ld (trigo_center_y),DE
    ld A,60
    ld (trigo_dist),A
  ld A,128
  ld (fa_step),A
    ld HL,$FFFF
    ld (fa_min_dist),HL
  ld B,255

   ld A,0
   ld (trigo_angle),A
   CALL_(do_trigo)
   CALL_(find_dist)
   ld A,128
   ld (trigo_angle),A
   CALL_(do_trigo)
   CALL_(find_dist)
   ld A,64
find_angle_loop:
   ld (trigo_angle),A
  CALL_(do_trigo)
  CALL_(find_dist)
    ld A,(trigo_angle)
    ld HL,fa_step
    add A,(HL)
    ld (trigo_angle),A
  CALL_(do_trigo)
  CALL_(find_dist)
    ld A,(fa_step)
    rrca ; div A by 2
    ld (fa_step),A
     bit 7,A
     ret nz
       rrca
       res 7,A
       ld B,A
      ld A,(fa_angle)
      sub B
    jr find_angle_loop







find_dist:

  ld DE,(fa_xy)

  ld A,B
  sub D
  jr nc,find_dist2
  ld A,D
  sub B
find_dist2:
  ld B,A

  ld A,C
  sub E
  jr nc,find_dist3
  ld A,E
  sub C
find_dist3:
  ld C,A

;  push BC
  ld HL,0
  ld D,0
  ld E,B
fad_square1:
  add HL,DE
; JUMP_C(find_bug)
; djnz fad_square1
;  pop BC
;  push BC
  ld D,0
  ld E,C
; ld B,C
fad_square2:
  add HL,DE
; JUMP_C(find_bug)
; djnz fad_square2
;  pop BC


  ld DE,(fa_min_dist)
  ld A,D
  cp H
  ret c
  ld A,E
  cp L
  ret c
  ld A,(trigo_angle)
  ld (fa_angle),A
  ld (fa_min_dist),HL

  ret







lstn:      ; draw a list (of address DE) of point (angle and dist) and their sym by foe_angle
  ld (trigo_center_y),BC
  ld HL,(PROGRAM_ADDR)
  add HL,DE
lstn_loop:
  ld A,(HL)
  cp 255
  ld BC,(trigo_center_y)
  ret z
  ld (trigo_dist),A
  inc HL
    ld A,(foe_angle)
    add A,(HL)
    ld (trigo_angle),A
    push HL
    CALL_(do_trigo)
    noir
    pop HL
  ld A,(foe_angle)
  sub (HL)
  ld (trigo_angle),A
  push HL
  CALL_(do_trigo)
  noir
  pop HL
  inc HL
  jr lstn_loop

player_is_dead:
  ld A,160
  ld (player_y),A
  ld A,20
  ld (c_player_fire),A
  ld (c_player_move),A
  ld (c_torp),A
  ld A,0
  ld (n_torp),A
  JUMP_(to_jump_if_dead)
  ; fin player_is_dead


prise_key:

 ld A,(player_num)
 or A
 CALL_Z(prise_key_p1)
 ld A,(player_num)
 or A
 ret z


 ld HL,player_data+npd+npd
 ld DE,player_data
 ld BC,npd
 ldir
 CALL_(prise_key_p2)
 ld HL,player_data
 ld DE,player_data+npd+npd
 ld BC,npd
 ldir

 ld HL,player_data+npd
 ld DE,player_data
 ld BC,npd
 ldir
 CALL_(prise_key_p1)
 ld HL,player_data
 ld DE,player_data+npd
 ld BC,npd
 ldir

 ret


prise_key_p1:

  ld A,255
  ld (player_flame),A


   ld A,63     ; masks all but F1,F2,F3,F4,F5,2nd,MORE
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 7,A               ; key MORE
   CALL_Z(key_pause)



   ld A,125    ; masks all but ENTER,+,-,*,/,^,CLEAR
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A
   CALL_Z(key_plus)
   ld A,(key_pressed)
   bit 2,A
   CALL_Z(key_moins)
   ld A,(key_pressed)
   bit 5,A
   CALL_Z(key_puiss)
   ld A,(key_pressed)
   bit 4,A                ; key /
   CALL_Z(key_full_health)

   ld A,95    ; masks all but  STO , x^2 LN LOG GRAPH ALPHA
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 7,A
   CALL_Z(key_alpha)
   ld A,(key_pressed)
   bit 2,A              ; key P=,
   CALL_Z(key_pause)
   ld A,(key_pressed)
   bit 5,A
   CALL_Z(key_log)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(key_x2)
   ld A,(key_pressed)
   bit 1,A
   CALL_Z(key_sto)

   ld A,123     ; masks all but (-) 3 6 9 ) TAN CUSTOM
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 0,A
   CALL_Z(key_grey_moins)
   ld A,(key_pressed)
   bit 1,A
   CALL_Z(go_niv3)
   ld A,(key_pressed)
   bit 2,A
   CALL_Z(go_niv6)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(go_niv9)
   ld A,(key_pressed)
   bit 4,A
   CALL_Z(key_close_par)
   ld A,(key_pressed)
   bit 5,A
   CALL_Z(key_tan)


   ld A,111    ; masks all but 0,1,4,7,EE,sin,STAT,x-VAR
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 6,A
   CALL_Z(disp_stat)
   ld A,(key_pressed)
   bit 7,A
   CALL_Z(key_xvar)
   ld A,(key_pressed)
   bit 4,A
   CALL_Z(key_EE)
   ld A,(key_pressed)
   bit 5,A
   CALL_Z(key_sin)
   ld A,(key_pressed)
   bit 0,A
   CALL_Z(go_niv0)
   ld A,(key_pressed)
   bit 1,A
   CALL_Z(go_niv1)
   ld A,(key_pressed)
   bit 2,A
   CALL_Z(go_niv4)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(go_niv7)


   ld A,119  ; masks all but . 2 5 8 ( cos prgm del
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A
   CALL_Z(go_niv2)
   ld A,(key_pressed)
   bit 2,A
   CALL_Z(go_niv5)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(go_niv8)
   ld A,(key_pressed)
   bit 5,A
   CALL_Z(key_cos)
   ld A,(key_pressed)
   bit 0,A
   CALL_Z(key_point)
   ld A,(key_pressed)
   bit 4,A
   CALL_Z(key_open_par)
   ld A,(key_pressed)
   bit 7,A
   JUMP_Z(key_del)
   ld A,(key_pressed)
   bit 6,A
   CALL_Z(key_prgm)


   ld A,126    ; masks all but arrows
   out (1),A   ; should I set bit 7 or not ? 126 or 126+2^7=254 ?
   in A,(1)
   ld (key_pressed),A
   bit 2,A
   CALL_Z(key_right)
   ld A,(key_pressed)
   bit 1,A
   CALL_Z(key_left)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(key_up)
   ld A,(key_pressed)
   bit 0,A
   CALL_Z(key_down)



   ld A,63     ; masks all but F1,F2,F3,F4,F5,2nd,MORE
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 6,A
   JUMP_Z(exit_game)
   ld A,(key_pressed)
   xor 32
   ld HL,player_bits
   xor (HL)
   bit 5,A
   CALL_NZ(key_2nd)
   ld A,(key_pressed)
   bit 4,A
   CALL_Z(key_F1)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(key_F2)
   ld A,(key_pressed)
   bit 2,A
   CALL_Z(key_F3)
   ld A,(key_pressed)
   bit 1,A
   CALL_Z(key_F4)
   ld A,(key_pressed)
   bit 0,A
   CALL_Z(key_F5)


   ret   ;  fin prise_key_p1





prise_key_p2:

  ld A,255
  ld (player_flame),A



   ld A,111    ; masks all but 0,1,4,7,EE,sin,STAT,x-VAR
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 0,A
   CALL_Z(key_0)
   ld A,(key_pressed)
   bit 1,A             ; key 1
   CALL_Z(key_left)
   ld A,(key_pressed)
   bit 2,A             ; key 4
   CALL_Z(key_left)
   ld A,(key_pressed)
   bit 3,A             ; key 7
   CALL_Z(key_left)
   ld A,(key_pressed)
   bit 3,A             ; key 7
   CALL_Z(key_up)
   ld A,(key_pressed)
   bit 1,A             ; key 1
   CALL_Z(key_down)


   ld A,119  ; masks all but . 2 5 8 ( cos prgm del
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A             ; key 2
   CALL_Z(key_down)
   ld A,(key_pressed)
   bit 3,A
   CALL_Z(key_up)      ; key 8
   ld A,(key_pressed)
   bit 0,A             ; key grey point
   CALL_Z(key_xvar)    ; lay mine key


   ld A,123     ; masks all but (-) 3 6 9 ) TAN CUSTOM
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A             ; key 3
   CALL_Z(key_right)
   ld A,(key_pressed)
   bit 2,A             ; key 6
   CALL_Z(key_right)
   ld A,(key_pressed)
   bit 3,A             ; key 9
   CALL_Z(key_right)
   ld A,(key_pressed)
   bit 3,A             ; key 9
   CALL_Z(key_up)
   ld A,(key_pressed)
   bit 1,A             ; key 3
   CALL_Z(key_down)
   ld A,(key_pressed)
   bit 0,A             ; key (-)
   CALL_Z(key_alpha)   ; fire torpedo key
   ld A,(key_pressed)
   bit 4,A              ; key )
   CALL_Z(key_par_cheat)


   ld A,125    ; masks all but ENTER,+,-,*,/,^,CLEAR
   out (1),A
   in A,(1)
   ld (key_pressed),A
   rlca
   rlca
   rlca       ; turn bit 0 (key enter) into bit 5
   rlca
   rlca
   xor 32
   ld HL,player_bits
   xor (HL)
   bit 5,A
   CALL_NZ(key_2nd)    ; fire_with_guns key


   ret  ; fin prise_key_p2



key_right:
     ld A,4
     CALL_(p_wanna_move)
  ld A,(player_x)
  add A,B
  cp 123            ; si trop a droite
  ret nc            ; n'avance pas
  ld (player_x),A
   ;ld A,0                  ; inutile
   ;ld (c_player_move),A    ; inutile
  ret


key_left:
     ld A,2
     CALL_(p_wanna_move)
  ld A,(player_x)
  sub B
  cp 5              ; si trop a gauche
  ret c             ; ne recule pas
   cp 192           ; si sorti par la gauche
   ret nc           ; non plus
  ld (player_x),A
   ;ld A,0                  ; inutile
   ;ld (c_player_move),A    ; inutile
  ret


key_up:
     ld A,8
     CALL_(p_wanna_move)
  ld A,(player_y)
  add A,C
  cp 61              ; si trop haut
  ret nc             ; ne monte pas
  ld (player_y),A
   ;ld A,0                ; inutile
   ;ld (c_player_move),A  ; inutile
  ret

key_down:
     ld A,1
     CALL_(p_wanna_move)
  ld A,(player_y)
  sub C
  cp 3               ; si trop bas
  ret c              ; ne descend pas
   cp 170            ; si sorti par le bas
   ret nc            ; non plus
  ld (player_y),A
   ;ld A,0                  ; inutile
   ;ld (c_player_move),A    ; inutile
  ret



p_wanna_move:   ; put in B=x and C=y his speed
    pop DE
    ld B,A
    ld HL,player_flame
    and (HL)
    ret z   ; return twice (because of pop DE)
    ld A,B
    xor 255
    and (HL)
    ld (HL),A
      ld A,(c_player_move)
      or A
      ret nz   ; return twice (because of pop DE)
      push DE
   ld A,(engine)
   inc A
   inc A
   ld B,A
   ld C,A
   ld A,(game_done)
   and 3
   ret z
   cp 1
   jr z,ps2_speed
   cp 2
   jr z,ps3_speed
ps4_speed:
   inc B
   dec C
   ret
ps3_speed:
   dec B
   dec C
   ret
ps2_speed:
   inc C
   ret

key_2nd:
  ld HL,player_flame
  res 4,(HL)
  ld A,(c_player_fire)
  or A
  ret nz

  ld A,(game_done)
  and 12         ; only bit 3 and 4 remains
  cp 4
  JUMP_Z(fire_arc)
  cp 8
  JUMP_Z(fire_spec_2)
  cp 12
  JUMP_Z(fire_arc)

  ld A,(weapon)
  cp bullet
  JUMP_Z(fire_bullet)
  cp onde
  JUMP_Z(fire_onde)
  cp beam
  JUMP_Z(fire_beam)

    ld A,laser
    ld BC,$0F03
    JUMP_(fire_p_gun)

   ; fin key 2nd


fire_bullet:
    ld A,bullet
    ld (ftp_type),A
  ld A,(player_x)
  add A,5
  ld B,A
  ld A,(game_done)
  and 3
  cp 1
  jr z,fire_bullet_2
  cp 3
  jr nz,fire_bullet_1
  inc B
  inc B
fire_bullet_1
  ld A,(player_y)
  ld C,A
  CALL_(put_player_shot)
    ld A,(game_done)
    and 3
    cp 2
    ret nz
      ld A,(global_time)
      bit 0,A
      ret nz
        ld A,B
        add A,4
        ld B,A
        JUMP_(put_player_shot)

fire_bullet_2:
  ld BC,$0401  ; B=4 C=1
  ld DE,0
  JUMP_(fire_p_gun_n2)


fire_onde:
   ld A,2
   ld (c_player_move),A
   ld A,onde
   ld BC,$0A03       ; B=10 C=3
   JUMP_(fire_p_gun)

fire_beam:
   ld A,beam
   ld BC,$0403
   JUMP_(fire_p_gun)


fire_p_gun:
   ld (ftp_type),A
   ld DE,0
   ld A,(game_done)   ;  =0  normaly
   and 3
   cp 1
   jr z,fire_p_gun_s2
   cp 2
   jr z,fire_p_gun_s3
   cp 3
   jr z,fire_p_gun_s4
fire_p_gun_n2:
 push BC
 push DE
   ld A,(player_x)
   add A,B
   add A,D
   ld B,A
     ld A,(player_y)
     add A,C
     add A,E
     ld C,A
       ld A,(ftp_type)
       cp beam
       jr nz,fire_p_gun_nb
       inc C
fire_p_gun_nb:
   CALL_(put_player_shot)
 pop DE
 pop BC
   ld A,(player_x)
   add A,B
   add A,D
   ld B,A
     ld A,(player_y)
     sub C
     sub E
     ld C,A
   JUMP_(put_player_shot)

fire_p_gun_s2:
     ld DE,$FD00   ; D=-3 E=0
     ld A,(ftp_type)
     cp laser
     jr nz,fire_p_gun_s2_2
     push BC
     ld DE,0
   CALL_(fire_p_gun_n2)
     pop BC
     ld DE,$FC03   ; D=-4 E=3
     jr fire_p_gun_n2

fire_p_gun_s2_2:
   ld DE,$FE00  ; D=-2 E=0
   push BC
   CALL_(fire_p_gun_n2)
   pop BC
   ld DE,$FE03        ; D=-2 E=+3
   jr fire_p_gun_n2

fire_p_gun_s4:
   ld DE,$03FF   ; D=3 E=-1
   jr fire_p_gun_n2

fire_p_gun_s3:
     push BC
   ld DE,1
   CALL_(fire_p_gun_n2)
     pop BC
   ld A,(player_x)
   add A,B
   add A,3
   ld B,A
   ld A,(player_y)
   ld C,A
   ld A,(ftp_type)
   cp beam
   jr nz,fire_p_gun_s3_nb
   ld A,(global_time)
   bit 2,A
   jr nz,fire_p_gun_s3_nb
   inc C
fire_p_gun_s3_nb:
   JUMP_(put_player_shot)




fire_arc:
  ld A,arc
  ld (ftp_type),A
  JUMP_(fire_special)

fire_spec_2:
  ld A,spec2
  ld (ftp_type),A
  JUMP_(fire_special)


fire_special:


  ld A,(gun_power)
  and 128
  ld HL,gun_direction
  or (HL)
  ret z     ; return if not any direction on


  ld A,0
  ld (souv_first_dir),A

  ld A,(gun_power)
  and 15
  ld (temp_gun_power),A

fire_spec_loop:
  ld A,(player_x)
  add A,2
  and 252    ; reset bit 0 and bit 1
  ld B,A
    ld A,(player_y)
    add A,2
    and 252    ; reset bit 0 and bit 1
    ld C,A

    
    ld A,(souv_first_dir)
    inc A
    cp 17   ; so it doesn't do more than one turn ; (17 et pas 16 ou 15)
    ret z
    ld (souv_first_dir),A


    ld A,(weapon)
    inc A
    and 15
    ld (weapon),A
  rlca      ; double A
  ld D,0
  ld E,A
  ld HL,(PROGRAM_ADDR)
  add HL,DE
  ld DE,fire_spec_index
  add HL,DE
  ld E,(HL)
  inc HL
  ld D,(HL)
  ld HL,(PROGRAM_ADDR)
  add HL,DE
  jp (HL)


fire_spec_index:
.dw   fire_spec1,fire_spec2,fire_spec3,fire_spec4
.dw   fire_spec5,fire_spec6,fire_spec7,fire_spec8
.dw   fire_spec9,fire_spec10,fire_spec11,fire_spec12
.dw   fire_spec13,fire_spec14,fire_spec15,fire_spec16


fire_spec1:
  ld A,B
  add A,16+0
  ld B,A
  ld A,C
  add A,0+0
  ld C,A
  ld A,1
  JUMP_(fire_spec_all)

fire_spec2:
  ld A,B
  add A,16+0
  ld B,A
  ld A,C
  add A,4+1
  ld C,A
  ld A,2
  JUMP_(fire_spec_all)

fire_spec3:
  ld A,B
  add A,16+0
  ld B,A
  ld A,C
  add A,8+2
  ld C,A
  ld A,4
  JUMP_(fire_spec_all)

fire_spec4:
  ld A,B
  add A,8+0
  ld B,A
  ld A,C
  add A,8+3
  ld C,A
  ld A,8
  JUMP_(fire_spec_all)

fire_spec5:
  ld A,B
  add A,0+1
  ld B,A
  ld A,C
  add A,8+0
  ld C,A
  ld A,16
  JUMP_(fire_spec_all)

fire_spec6:
  ld A,B
  add A,-8+1
  ld B,A
  ld A,C
  add A,8+1
  ld C,A
  ld A,32
  JUMP_(fire_spec_all)

fire_spec7:
  ld A,B
  add A,-16+1
  ld B,A
  ld A,C
  add A,8+2
  ld C,A
  ld A,64
  JUMP_(fire_spec_all)

fire_spec8:
  ld A,B
  add A,-16+1
  ld B,A
  ld A,C
  add A,4+3
  ld C,A
  ld A,128
  JUMP_(fire_spec_all)

fire_spec9:
  ld A,B
  add A,-16+2
  ld B,A
  ld A,C
  add A,0+0
  ld C,A
  ld A,0
  JUMP_(fire_spec_all)

fire_spec10:
  ld A,B
  add A,-16+2
  ld B,A
  ld A,C
  add A,-4+1
  ld C,A
  ld A,128
  JUMP_(fire_spec_all)

fire_spec11:
  ld A,B
  add A,-16+2
  ld B,A
  ld A,C
  add A,-8+2
  ld C,A
  ld A,64
  JUMP_(fire_spec_all)

fire_spec12:
  ld A,B
  add A,-8+2
  ld B,A
  ld A,C
  add A,-8+3
  ld C,A
  ld A,32
  JUMP_(fire_spec_all)

fire_spec13:
  ld A,B
  add A,0+3
  ld B,A
  ld A,C
  add A,-8+0
  ld C,A
  ld A,16
  JUMP_(fire_spec_all)

fire_spec14:
  ld A,B
  add A,8+3
  ld B,A
  ld A,C
  add A,-8+1
  ld C,A
  ld A,8
  JUMP_(fire_spec_all)

fire_spec15:
  ld A,B
  add A,16+3
  ld B,A
  ld A,C
  add A,-8+2
  ld C,A
  ld A,4
  JUMP_(fire_spec_all)

fire_spec16:
  ld A,B
  add A,16+3
  ld B,A
  ld A,C
  add A,-4+3
  ld C,A
  ld A,2
  JUMP_(fire_spec_all)



fire_spec_all:
   cp 0
   jr z,test_fire_spec9
   ld HL,gun_direction
   and (HL)
fire_spec_suite2:
   JUMP_Z(fire_spec_loop)
   CALL_(put_player_shot)
   ld A,(temp_gun_power)
   cp 0
   ret z
   dec A
   ld (temp_gun_power),A
   JUMP_(fire_spec_loop)

test_fire_spec9:
  ld A,(gun_power)
  and 128
  jr fire_spec_suite2


put_player_shot:
  ld HL,player_shot_type
  ld DE,player_shot_type+100
fpls1:
     inc HL
     call CP_HL_DE
     JUMP_Z(find_mem_full)
     ld A,(HL)
     or A           ; check if there is already something
    jr nz,fpls1
  ld DE,250
  ld A,(ftp_type)
  ld (HL),A
  ADD HL,DE
  ld A,B
  ld (HL),A
  ADD HL,DE
  ld A,C
  ld (HL),A
  ret


key_alpha:
   ld A,(c_torp)
   or A
   ld A,2
   ld (c_torp),A
   ret nz

   ld A,(n_torp)
   or A
   ret z
   dec A
   ld (n_torp),A

   ld A,(player_x)
   add A,9
   ld B,A
   ld A,(player_y)
   ld C,A
   ld A,torp             
   ld (ftp_type),A
   JUMP_(put_player_shot)
   ; fin key_alpha

key_xvar:
   ld A,(c_torp)
   or A
   ld A,2
   ld (c_torp),A
   ret nz

   ld A,(n_torp)
   or A
   ret z
   dec A
   ld (n_torp),A

   ld BC,(player_y)
   ld A,mine
   ld (ftp_type),A
   JUMP_(put_player_shot)
   ; fin key_xvar


key_plus:
   ld A,(CONTRAST)  ; CONTRAST=$8007
   cp 31            ; CONTRAST can't be higher than $1F=31
   ret z
   inc A
   ld (CONTRAST),A ; save contrast
   out (2),A       ; send contrast
   ret

key_moins:
   ld A,(CONTRAST) ; CONTRAST=$8007
   cp 0            ; CONTRAST can'be lower than 0
   ret z
   dec A
   ld (CONTRAST),A ; save contrast
   out (2),A       ; send contrast
   ret


key_grey_moins:
  CALL_(this_is_cheating)
  CALL_(grey_cheat)
  CALL_(do_c_key)
   ld A,(player_bits)
   xor 1               ; invert bit 0
   ld (player_bits),A
   ret

key_EE:
  CALL_(this_is_cheating)
  CALL_(do_c_key)
key_EE_sans_test:
  ld HL,foe_type
  ld DE,foe_type+250
key_EE_loop1:
     inc HL
     ld A,(HL)
     or A
     CALL_NZ(key_EE_sub1)
     call CP_HL_DE
     jr nz,key_EE_loop1
     ret
key_EE_sub1:
  cp 250
  ret nc
  ld (HL),star3b
  ret



key_F1:
  CALL_(ch_gun_dir)
  ld A,laser
  ld (weapon),A
  ret

key_F2:
  CALL_(ch_gun_dir)
  ld A,bullet
  ld (weapon),A
  ret

key_F3:
  CALL_(ch_gun_dir)
  ld A,onde
  ld (weapon),A
  ret


key_F4:
  CALL_(ch_gun_dir)
  ld A,beam
  ld (weapon),A
  ret

key_F5:
  CALL_(do_c_key)
  ld A,(player_bits)
  xor 32
  ld (player_bits),A
  ret


ch_gun_dir:
   ld A,(game_done)
   and 12
   ret z


   ld A,(key_pressed)
    bit 4,A              ; key F1
     ld B,73  ; bits 0,3,6
      CALL_Z(ch_gun_dir_fl)
   ld A,(key_pressed)
    bit 3,A              ; key F2
     ld B,146 ; bits 1,4,7
      CALL_Z(ch_gun_dir_fl)
   ld A,(key_pressed)
    bit 2,A              ; key F3
      ld B,36  ; bits 2,5
       CALL_Z(ch_gun_dir_fl)

    pop HL      ; return further ; don't change weapon
   ret




ch_gun_dir_fl:
   ld A,126    ; masks all but arrows
   out (1),A
   in A,(1)
   and 15
   cp 15
   ret z
   ld (souv_key),A

  CALL_(do_c_key)

   ld A,(souv_key)
    bit 2,A
     ld A,7
      CALL_Z(ch_gun_dir_afl)
   ld A,(souv_key)
    bit 1,A
     CALL_Z(ch_gun_dir_fl_l)
   ld A,(souv_key)
     bit 3,A
      ld A,56
       CALL_Z(ch_gun_dir_afl)
   ld A,(souv_key)
     bit 0,A
      ld A,56
       CALL_Z(ch_gun_dir_afl)
   ret



ch_gun_dir_fl_l:
   ld A,B
   and 36
   jr z,no_ch_gun_dir_9
     ld A,(gun_power)
     xor 128
     ld (gun_power),A
no_ch_gun_dir_9:
   ld A,192    ; bits 6,7
                              ; continue

ch_gun_dir_afl:
  and B
  ld HL,gun_direction
  xor (HL)
  ld (gun_direction),A
  ret





key_0:


  ld A,0                 ; so player can't move
  ld (player_flame),A


   ld A,111    ; masks all but 0,1,4,7,EE,sin,STAT,x-VAR
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A             ; key 1
   CALL_Z(key_F1)
   ld A,(key_pressed)
   bit 2,A             ; key 4
   CALL_Z(key_F4)

   ld A,119  ; masks all but . 2 5 8 ( cos prgm del
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A             ; key 2
   CALL_Z(key_F2)
   ld A,(key_pressed)
   bit 2,A
   CALL_Z(key_F5)      ; key 5


   ld A,123     ; masks all but (-) 3 6 9 ) TAN CUSTOM
   out (1),A
   in A,(1)
   ld (key_pressed),A
   bit 1,A             ; key 3
   CALL_Z(key_F3)

   ret  ; fin key_0


go_niv0
  ld A,100
  jr go_niv
go_niv1
  ld A,101
  jr go_niv
go_niv2
  ld A,102
  jr go_niv
go_niv3
  ld A,103
  jr go_niv
go_niv4
  ld A,104
  jr go_niv
go_niv5
  ld A,105
  jr go_niv
go_niv6
  ld A,106
  jr go_niv
go_niv7
  ld A,107
  jr go_niv
go_niv8
  ld A,108
  jr go_niv
go_niv9
  ld A,109
  jr go_niv
go_niv

    ld (souv_key),A

  CALL_(this_is_cheating)
  CALL_(grey_cheat)
  CALL_(do_c_key)

  ld A,(souv_key)
  ld (num_niv),A
  ret

key_puiss
  CALL_(this_is_cheating)
  ld A,5
  ld (n_torp),A
  ld (n_torp+npd),A
  ld (n_torp+npd+npd),A
  ret

key_full_health:
   CALL_(this_is_cheating)
   ld A,100
   ld (player_health),A
   ld (player_health+npd),A
   ld (player_health+npd+npd),A
   ret

key_point:
   CALL_(this_is_cheating)
   CALL_(grey_cheat)
cheat_engine:
    CALL_(do_c_key)
   ld A,(engine)
   inc A
   ld (engine),A
   cp 4
   ret c
   ld A,1
   ld (engine),A
   ret


key_tan:
   CALL_(this_is_cheating)
   CALL_(do_c_key)
   ld A,(scroll_type)
   and 3
   dec A
   and 3
   ld (scroll_type),A
   ret



key_cos:
   CALL_(this_is_cheating)
   ld A,0
   ld (score),A
   ld BC,(niv_time)
   ld (global_time),BC
   ret


key_sin:
  
  ld A,0
  ld (allow_cheat),A

  
   ld A,111    ; masks all but 0,1,4,7,EE,sin,STAT,x-VAR
   out (1),A
   in A,(1)
   xor 255     ; invert A
   res 5,A     ; bit of key sin
   or A
   ret nz

   ld A,123     ; masks all but (-) 3 6 9 ) TAN CUSTOM
   out (1),A
   in A,(1)
   bit 4,A
   ret nz
   xor 255     ; invert A
   res 4,A     ; bit of key )
   or A
   ret nz

   ld A,119  ; masks all but . 2 5 8 ( cos prgm del
   out (1),A
   in A,(1)
   bit 4,A
   ret nz
   xor 255     ; invert A
   res 4,A     ; bit of key (
   or A
   ret nz

   ld A,1
   ld (allow_cheat),A

  ret     ; fin key_sin



do_c_key:
   ld A,(c_key)
   or A
   ld A,2
   ld (c_key),A
    pop HL
   ret nz
    push HL
   ret

this_is_cheating:
   ld A,(allow_cheat)
   cp 0
   ret nz
   pop HL ; so it will return further
   ret

grey_cheat:
   ld A,(player_num)
   cp 0
   ret z
   pop HL ; so it will return further
   ret


key_close_par:
  CALL_(grey_cheat)
key_open_par:
key_par_cheat:
  CALL_(this_is_cheating)
   ld A,(c_player_move)
   inc A
   ld (c_player_move),A
  ld A,(c_player_move+npd)
  inc A
  ld (c_player_move+npd),A
       ld A,254  ; masks all but arrows
       out (1),A
       in A,(1)
       ld (souv_key),A  ;;;;;;;;;;;;;;;;2=right  1=left  3=up   0=down
       bit 0,A
       CALL_Z(cheat_spec_w)
       ld A,(souv_key)
       bit 2,A
       CALL_Z(cheat_engine)
       ld A,(souv_key)
       bit 1,A
       CALL_Z(cheat_ship_type)
       ld A,(souv_key)
       bit 3,A
       CALL_Z(inc_gun_power)
       ret


cheat_spec_w:
    CALL_(do_c_key)
  ld A,(game_done)
  ld B,A
  res 2,B
  res 3,B
  and 12
  add A,4
  and 12
  or B
  ld (game_done),A
    ld A,0
    ld (gun_power),A
    ld A,2
    ld (gun_direction),A
  ret

cheat_ship_type:
    CALL_(do_c_key)
  ld A,(game_done)
  ld B,A
  res 0,B
  res 1,B
  and 3
  inc A
  and 3
  or B
  ld (game_done),A
  ret





key_log:
      CALL_(do_c_key)
    ld A,(ZS_BITS)
    set 0,A         ; checksum again when coming back to ZShell
    ld (ZS_BITS),A
      ld DE,text_langue2
      ld HL,(PROGRAM_ADDR)
      add HL,DE
       push HL
       pop BC
      ld DE,text_langue1
      ld HL,(PROGRAM_ADDR)
      add HL,DE
       push BC
       pop DE
loop_change_langue:     ; HL se balade sur langue1 , BC se balade sur langue2 ,DE est la fin de langue1 (=le debut de langue2)
    push DE
      ld A,(BC)
      ld D,(HL)
       ld (HL),A
       ld A,D
       ld (BC),A
     inc HL
     inc BC
   pop DE
     call CP_HL_DE
     jr nz,loop_change_langue
   ret



key_sto:
    CALL_(do_c_key)
save_game:
  ld HL,(PROGRAM_ADDR)
  ld (zwar_prgm_addr),HL
  CALL_(search_savegame)
  ld HL,GRAPH_MEM
  ld BC,1024
  ldir  ; transfer BC data bytes from (HL) to (DE) 
  ld HL,TEXT_MEM2
  ld BC,168
  ldir
  ld HL,text_game_saved
  ld (message_addr),HL
  ret

key_prgm:
  CALL_(do_c_key)
load_game:
  CALL_(search_savegame)
  ld DE,GRAPH_MEM
  ld BC,1024
  ldir  ; transfer BC data bytes from (HL) to (DE) 
  ld DE,TEXT_MEM2
  ld BC,168
  ldir
  ld HL,text_game_loaded
  ld (message_addr),HL
     ld HL,(rand_addr)
     ld DE,(zwar_prgm_addr)  ; old prgm_addr
     cp 0
     sbc HL,DE
     ld DE,(PROGRAM_ADDR)  ; new prgm_addr
     add HL,DE
     ld (rand_addr),HL
  ld HL,(rand_addr_max)
  ld DE,(zwar_prgm_addr)  ; old prgm_addr
  cp 0
  sbc HL,DE
  ld DE,(PROGRAM_ADDR)  ; new prgm_addr
  add HL,DE
  ld (rand_addr_max),HL
    ret


search_savegame:   ; make BC=HL=DE=address of start of savegame (after the size)
   ld A,7
   ld (c_message),A
   ld HL,text_no_savegame
   ld (message_addr),HL
   ld HL,VAT_START         ;  VAT_START = $FA6F = 64111
search_sg_loop:
   ld (souv_vat_addr),HL
   CALL_(check_savegame)
   ld HL,(souv_vat_addr)
   dec HL
   dec HL
   dec HL
   ld E,(HL)  ; (HL)=number of letter of variable name
   ld D,0
   cp 0 ; reset carry flag (for sbc)
   sbc HL,DE
   dec HL
   ld DE,(VAT_END)   ;  (VAT_END)=($8BEB)=(35819)=where is stored the address of the end of the VAT
   call CP_HL_DE
   pop DE  ; return further
   ret z
   push DE
   jr search_sg_loop


check_savegame:  ; put in BC the address of the beginning of the savegame variable (just after the size)
   ld A,(HL)
   cp 12     ; type of the variable (12=string)
   ret nz
   dec HL
   ld A,(HL)
   ld C,A    ; address of the variable (ecrite a l'envers)
   dec HL
   ld A,(HL)
   ld B,A    ; address of the variable
   dec HL
   ld A,(HL)
   cp 7     ; number of character of the name of the variable  (ZWarSav : 7 letters)
   ret nz
   dec HL
   ld A,(HL)
   cp 90 ;"Z"
   ret nz
   dec HL
   ld A,(HL)
   cp 87 ;"W"
   ret nz
   dec HL
   ld A,(HL)
   cp 97 ;"a"
   ret nz
   dec HL
   ld A,(HL)
   cp 114 ;"r"
   ret nz
   dec HL
   ld A,(HL)
   cp 83 ;"S"
   ret nz
   dec HL
   ld A,(HL)
   cp 97 ;"a"
   ret nz
   dec HL
   ld A,(HL)
   cp 118 ;"v"
   ret nz
   ld A,(BC) ; first byte of size of variable
   cp 169
   ret nz
   inc BC
   ld A,(BC)
   cp 4      ; second byte of size of variable
   ret nz
   inc BC
   inc BC  ; skip first savegame byte
   pop HL ; so it return directly to key_sto or key_prgm
   ld D,B
   ld E,C
   ld H,B
   ld L,C
   ret


key_x2:

  CALL_(do_c_key)

  ld A,(player_num)
  or A
  jr nz,key_x2_back

  ld HL,player_data
  ld DE,player_data+npd
  ld BC,npd
  ldir
  ld HL,player_data
  ld DE,player_data+npd+npd
  ld BC,npd
  ldir

   ld A,(player_x+npd+npd)
   sub 3
   ld (player_x+npd+npd),A
   ld A,(player_y+npd+npd)
   add A,2
   ld (player_y+npd+npd),A

  ld A,1
  ld (player_num),A
  ret

key_x2_back:
  ld HL,player_data+npd
  ld DE,player_data
  ld BC,npd
  ldir
  ld A,0
  ld (player_num),A
  ret


key_del:
  CALL_(save_game)
   ld HL,VIDEO_MEM     ; source
   ld DE,GRAPH_MEM     ; destination
   ld BC,1024          ; nombre de fois que l'on repete (1024 certain)
   LDIR                ; Transfer data between memory until byte counter is zero, increment destination and source addresses
  ROM_CALL(CLEARLCD)
  ld HL,ZS_BITS
  set 1,(HL)   ; exit ZShell without screen
  pop HL
  pop HL
  ret   ; quit the game

key_pause:
  CALL_(wait_til_no_key)
  JUMP_(wait_til_key)
  ;fin key_pause

wait_til_no_key:
    ld HL,0
    ld DE,0
    ld BC,2000         ; temps a perdre
    LDIR               ; perd du temps
  ld A,0
  out (1),A
  in A,(1)
  sub $FF                ; if no key are pressed, all 8 bits are set
  or A
  jr nz,wait_til_no_key ; loop until no key are pressed
  ret

wait_til_key:
    ld HL,0
    ld DE,0
    ld BC,2000         ; temps a perdre
    LDIR               ; perd du temps
  ld A,0
  out (1),A
  in A,(1)
  sub 255
  or A
  jr z,wait_til_key  ; loop until a key is pressed
  ret



disp_stat:
   ROM_CALL(CLEARLCD)
   ld DE,(PROGRAM_ADDR)
   ld BC,$0F01        ; pour afficher a colonne=x=15 ligne=y=1
   ld (CURSOR_ROW),BC
   ld HL,(score)
   ROM_CALL(D_HL_DECI)
   ld BC,$0F03        ; pour afficher a colonne=x=15 ligne=y=3
   ld (CURSOR_ROW),BC
   ld HL,(niv_num)
   ld H,0             ; because niv_num is only 1 byte long
   ROM_CALL(D_HL_DECI)
   ld BC,$0F05        ; pour afficher a colonne=x=15 ligne=y=5
   ld (CURSOR_ROW),BC
   ld HL,(global_time)
   ROM_CALL(D_HL_DECI)

   ld DE,(PROGRAM_ADDR)
   ld BC,$0201
   ld (CURSOR_ROW),BC
   ld HL,text_score
   add HL,DE
   ROM_CALL(D_ZT_STR)

   ld DE,(PROGRAM_ADDR)
   ld BC,$0203
   ld (CURSOR_ROW),BC
   ld HL,text_niv
   add HL,DE
   ROM_CALL(D_ZT_STR)

   ld DE,(PROGRAM_ADDR)
   ld BC,$0205
   ld (CURSOR_ROW),BC
   ld HL,text_time
   add HL,DE
   ROM_CALL(D_ZT_STR)

   CALL_(key_pause)
   ret

exit_game
; debut recopie ecran dans graph ecran
   ld HL,VIDEO_MEM     ; source
   ld DE,GRAPH_MEM     ; destination
   ld BC,1024          ; nombre de fois que l'on repete (1024 certain)
   LDIR                ; Transfer data between memory until byte counter is zero, increment destination and source addresses
; fin recopie ecran
   pop HL   ; because prise_key_p1 was called
   pop HL   ; because prise_key was called
  CALL_(disp_stat)
  ret   ; exit the game



calc:

  ld BC,(niv_time)
  inc BC
  ld  (niv_time),BC

  ld A,(num_niv)  ; niv=niveau=level
  cp 99
  CALL_NC(new_niv)
  ld A,(num_niv)
  cp 1
  CALL_Z(niv1)
  ld A,(num_niv)
  cp 2
  CALL_Z(niv2)
  ld A,(num_niv)
  cp 3
  CALL_Z(niv3)
  ;;ld A,(num_niv)
  ;;cp 4
  ;;CALL_Z(niv4)

  CALL_(try_put_pb_giver)


  ld A,1
calc_loop:
   ld (foe_num),A
   CALL_(calc_all)
   ld A,(foe_num)
   inc A
   cp 251   ; last thing +1
   jr nz,calc_loop
  ret                ; fin calc


new_niv:
   sub 100
   ld (num_niv),A
      ld HL,(PROGRAM_ADDR)
      ld (rand_addr),HL
    ld BC,0
    ld (c_niv),BC    ; j'espere que c_niv fait 2 octets
    ld (niv_time),BC
      ld A,0
      ld (gun_power),A
      ld (gun_power+npd),A
      ld (gun_power+npd+npd),A
       ld A,2
       ld (gun_direction),A
       ld (gun_direction+npd),A
       ld (gun_direction+npd+npd),A
    ld A,0
    ld (scroll_type),A
   ld A,(num_niv)
   cp 1
   JUMP_Z(niv101)
   cp 4
   JUMP_Z(niv104)
   cp 8
   JUMP_Z(niv108)
   ret

niv101: 
   ld HL,(PROGRAM_ADDR)
   ld  DE,data_niv1
   add HL,DE
   ld  (rand_addr),HL
   ret

niv104:
   ld B,3           ; number of inter1 at the beginning of level 4 (can't be 0)
inter1_niv104:
   push BC
   CALL_(put_inter1)
   pop BC
   djnz inter1_niv104

   ld A,saucer_boss
   ld (ftp_type),A
   ld DE,0
   ld (ftp_data),DE
   ld HL,$2400               ; $2400 = 9216 = 9*4*256 = 4* $900
   ld (ftp_health),HL
   ld B,200
   ld C,32
   CALL_(put_foe)
   ret


niv108:
  ld BC,19
  ld HL,niv108_f_type
  ld DE,(PROGRAM_ADDR)
  add HL,DE
  ld DE,foe_type
  ldir ; copy BC bytes from (HL) to (DE)

  ld BC,19
  ld HL,niv108_f_x
  ld DE,(PROGRAM_ADDR)
  add HL,DE
  ld DE,foe_x
  ldir ; copy BC bytes from (HL) to (DE)

  ld BC,19
  ld HL,niv108_f_y
  ld DE,(PROGRAM_ADDR)
  add HL,DE
  ld DE,foe_y
  ldir ; copy BC bytes from (HL) to (DE)

  ld BC,19+19
  ld HL,niv108_f_health
  ld DE,(PROGRAM_ADDR)
  add HL,DE
  ld DE,foe_health
  ldir ; copy BC bytes from (HL) to (DE)

  ld BC,19+19
  ld HL,niv108_f_data
  ld DE,(PROGRAM_ADDR)
  add HL,DE
  ld DE,foe_data
  ldir ; copy BC bytes from (HL) to (DE)

  ld A,3
  ld (scroll_type),A
  ld (engine),A
  ld (engine+npd),A
  ld (engine+npd+npd),A

  ret



niv108_f_type:
.db 0,0,bb1,bb2
.db bb_gun,bb_gun,bb_gun,bb_gun
.db bb_rear,bb_rear
.db turret,turret,turret,turret,turret,turret,turret
.db turret,turret

niv108_f_x:
.db 0,0,160,32
.db 160+61,160+61,32+16,32+16
.db 160+64+22,32+16+22
.db 160+12,160-9,160-9,160+44,160+44,160+63,160+63
.db 32+18,32+18

niv108_f_y:
.db 0,0,32,160
.db 32+35,32-35,160+14,160-14
.db 32,160
.db 32,32+10,32-10,32-6,32+6,32+10,32-10
.db 160+8,160-8

niv108_f_health:
.dw 999,999,15360,8192    ; 15360=15*1024=health of big boss 1 , 8192=8*1024=health of big boss 2
.dw 1400,1400,1400,1400   ; health of big guns
.dw 900,600
.dw 500,500,500,500,500,500,500
.dw 500,500

niv108_f_data:
.db 0,0 ,0,0 ,0,0 ,0,0
.db 0,0 ,0,0 ,0,0 ,9,0
.db 0,0 ,0,0
; first, time before first turret shot (=15), then turret angle ->
.db 15,0 ,15,98 ,15,158 ,15,142 ,15,110 ,15,110 ,15,142
.db 15,128 ,15,128



niv1:
  ld A,(niv_time+1)
  or A
  jr nz,no_m_help_niv1
    ld A,(niv_time)
    cp 10
    CALL_Z(put_m_help1)
    cp 50
    CALL_Z(put_m_help2)
    cp 90
    CALL_Z(put_m_help3)
    cp 130
    CALL_Z(put_m_help4)
    cp 170
    CALL_Z(put_m_help5)
    cp 210
    CALL_Z(put_m_help6)
no_m_help_niv1:
  ld DE,(niv_time)
  ld HL,850
  call CP_HL_DE
  JUMP_Z(next_niv)
  ld HL,700
  call CP_HL_DE
  jr c,no_saucer1_niv1
  ld A,(niv_time)
  and 127
  cp 127
  JUMP_Z(put_saucer1)
no_saucer1_niv1:
  ld A,(niv_time)
  and 1  ; only bit 0 remains
  cp 0
  ret nz    ; continue une fois sur 2 (et non plus 16)

  CALL_(get_rand)
  set 7,A         ; Acc is now higher than 127
  ld B,A          ; x

  CALL_(get_rand)
  res 7,A
  res 6,A        ; Acc is now between 0 and 63
  ld C,A         ; y

  CALL_(get_rand)
  res 7,A
  res 6,A
  res 5,A
  res 4,A
  res 3,A
  res 2,A        ; Acc is now between 0 and 3
  inc A
  cp 1
  JUMP_Z(put_asteroid1)
  cp 2
  JUMP_Z(put_asteroid2)
  cp 3
  JUMP_Z(put_asteroid3)
  cp 4
  JUMP_Z(put_asteroid4)
  JUMP_(find_bug)
  ret

data_niv1:    ; won't work with the new get_rand
   .db  140,32,1,140,20,2,140,40,3,140,40,4,140,25,1,140,55,2,140,45,3,140,10,4 



put_m_help1:
  ld DE,text_help1
  jr put_m_help1234
put_m_help2:
  ld DE,text_help2
  jr put_m_help1234
put_m_help3:
  ld DE,text_help3
  jr put_m_help1234
put_m_help4:
  ld DE,text_help4
  jr put_m_help1234
put_m_help5:
  ld DE,text_help5
  jr put_m_help1234
put_m_help6:
  ld DE,text_help6
  jr put_m_help1234
put_m_help1234:
   ld A,(game_done)
   ld HL,game_done+npd
   or (HL)
   ld HL,game_done+npd+npd
   or (HL)
   jr nz,put_m_help_ae
  ld A,32
put_m_help_ae_l:
  ld (c_message),A
  ld (message_addr),DE
  ld A,0
  ret

put_m_help_ae:
  and 12
  ld A,0
  ret z
  ld A,(niv_time)
  cp 40
  ret nc
  ld DE,text_help_ae1
  ld A,70
  jr put_m_help_ae_l



niv2:
   ld A,(niv_time)
   and 31
   ret nz
   ld A,(niv_time)
   and 127
   JUMP_Z(put_inter1)   ; tout les 64  (1/4)
   JUMP_(put_inter2)    ; tout les 16 restant (3/4)
   ; fin niv2


niv3:
  ld A,(niv_time)
  and 31
  ret nz
  ld A,(niv_time)
  bit 5,A
  JUMP_Z(put_inter2)
  ld A,(niv_time)
  bit 6,A
  JUMP_Z(put_bee)
  JUMP_(put_duck)

  

next_niv:
next_level:
   ld A,(niv_num)
   add A,101
   ld (num_niv),A
   ret


calc_all:
   ld DE,(foe_num)

   ld HL,foe_x
   ADD HL,DE
   ld B,(HL)

   ld HL,foe_y
   ADD HL,DE
   ld C,(HL)

   ld HL,foe_type
   ADD HL,DE
   ld A,(HL)
   ld (foe_addr),HL

   cp laser
   JUMP_Z(calc_p_laser)
   cp bullet
   JUMP_Z(calc_p_bullet)
   cp onde
   JUMP_Z(calc_p_onde)
   cp foe_laser
   JUMP_Z(calc_foe_laser)
   cp ball
   JUMP_Z(calc_ball)
   cp asteroid1
   JUMP_Z(calc_asteroid1)
   cp asteroid2
   JUMP_Z(calc_asteroid2)
   cp asteroid3
   JUMP_Z(calc_asteroid3)
   cp asteroid4
   JUMP_Z(calc_asteroid4)
   cp torp
   JUMP_Z(calc_torp)
   cp arc
   JUMP_Z(calc_arc)
   cp spec2
   JUMP_Z(calc_spec2)
   cp saucer1
   JUMP_Z(calc_saucer1)
   cp inter1
   JUMP_Z(calc_inter1)
   cp inter2
   JUMP_Z(calc_inter2)
   cp duck
   JUMP_Z(calc_duck)
   cp bee
   JUMP_Z(calc_bee)
   cp pb_giver
   JUMP_Z(calc_pb_giver)
   cp saucer_boss
   JUMP_Z(calc_saucer_boss)
   cp h_bonus
   JUMP_Z(calc_h_bonus)
   cp e_bonus
   JUMP_Z(calc_e_bonus)
   cp p_bonus
   JUMP_Z(calc_p_bonus)
   cp o_bonus
   JUMP_Z(calc_o_bonus)
   cp torp_bonus
   JUMP_Z(calc_torp_bonus)
   cp hunter
   JUMP_Z(calc_hunter)
   cp turret
   JUMP_Z(calc_turret)
   cp homing
   JUMP_Z(calc_homing)
   cp fmd_laser
   JUMP_Z(calc_fmd_laser)
   cp bbg_shot
   JUMP_Z(calc_bbg_shot)
   cp beam
   JUMP_Z(calc_beam)
   cp bb_gun
   JUMP_Z(calc_bb_gun)
   cp bb_rear
   JUMP_Z(calc_bb_rear)
   cp bb1
   JUMP_Z(calc_bb1)
   cp bb2
   JUMP_Z(calc_bb2)
   ret



player_collision:
   ld (damage),A

   ; update xmin,xmax,ymin,ymax
     ld A,128
     sub D
     ld (xmin),A
   ld A,128
   add A,D
   ld (xmax),A
     ld A,128
     sub E
     ld (ymin),A
   ld A,128
   add A,E
           inc A     ; so it has the same size on each side
   ld (ymax),A
   ; end update xmin,xmax,ymin,ymax

    
   ld A,(player_num)
   or A
   CALL_Z(cur_player_col)
    ld A,(player_num)
    or A
    ret z

   ld HL,player_data+npd
   ld DE,player_data
   ld BC,npd
   ldir
   CALL_(cur_player_col)
   ld HL,player_data
   ld DE,player_data+npd
   ld BC,npd
   ldir

   ld HL,player_data+npd+npd
   ld DE,player_data
   ld BC,npd
   ldir
   CALL_(cur_player_col)
   ld HL,player_data
   ld DE,player_data+npd+npd
   ld BC,npd
   ldir

   ret

cur_player_col:    
    
    ld HL,(foe_addr)
    ld DE,250
    add HL,DE
    ld B,(HL)
    add HL,DE
    ld C,(HL)


   ld A,(player_x)
   sub B                ; B is foe x
   add A,128
   ld HL,xmin
   cp (HL)
   ret c
   ld HL,xmax
   cp (HL)
   ret nc
   ld A,(player_y)
   sub C                ; C is foe y
   add A,128
   ld HL,ymin
   cp (HL)
   ret c
   ld HL,ymax
   cp (HL)
   ret nc

   ld A,(player_health)
   cp 0
   ret z

   ld HL,(foe_addr)
   ld A,(HL)
   cp h_bonus
   JUMP_Z(get_h_bonus)
   cp e_bonus
   JUMP_Z(get_e_bonus)
   cp p_bonus
   JUMP_Z(get_p_bonus)
   cp o_bonus
   JUMP_Z(get_o_bonus)
   cp torp_bonus
   JUMP_Z(get_torp_bonus)

   ld A,15
   ld (c_bubble),A
   ld A,(player_health)
   ld HL,damage
   sub (HL)
   ld (player_health),A
   jr z,last_player_col
   jr c,last_player_col
   ld HL,(foe_addr)
   ld (HL),star3b
   ret

last_player_col:
  ld A,0
  ld (player_health),A
  JUMP_(key_EE_sans_test)


shot_collision:
     ld HL,(foe_addr)
     ld DE,250
     add HL,DE
     ld B,(HL)
     add HL,DE
     ld C,(HL)
  ld HL,player_shot_type
  ld DE,player_shot_type+100
next_shot_col:
c_c_p_s_f_l:
     inc HL
     call CP_HL_DE
     ret z
     ld A,(HL)
     or A           ; check if there is a player shot
     jr z,c_c_p_s_f_l
       push HL
       push DE
       CALL_(shot_col1)
       pop DE
       pop HL
    jr next_shot_col



shot_col1:
    cp torp
    jr z,hit_torp
    cp mine
    jr z,hit_mine
    cp laser
    jr z,hit_laser
    cp bullet
    jr z,hit_bullet
    cp onde
    jr z,hit_onde
    cp beam
    jr z,hit_beam
    cp arc
    jr z,hit_arc
    cp spec2
    jr z,hit_spec2
    cp quasar6
    JUMP_Z(shot_col3)
    ret

hit_laser:
   ld DE,5          ; damage dealt by a laser shot
   ld A,laser_boum  ; what the laser shot become
   jr shot_col2

hit_bullet:
   ld DE,9          ; damage dealt by a bullet
   ld A,bullet_boum ; what the bullet becomes
   jr shot_col2

hit_onde:
   ld DE,7          ; damage dealt by a blasting ray shot
   ld A,star1_plein ; what it becomes
   jr shot_col2

hit_beam:
   ld DE,6          ; damage dealt by a beam shot
   ld A,dots8       ; what it becomes
   jr shot_col2

hit_arc:            
  ld DE,3           ; damage dealt by a multi directional bow shot
  ld A,dots8        ; what it becomes
  jr shot_col2

hit_spec2:            
  ld DE,4           ; damage dealt by a multi directional star shot
  ld A,bullet_boum  ; what it becomes
  jr shot_col2


hit_torp:
hit_mine:
   ld DE,0          ; damage dealt by a mine or a torp (it doesn't do any damage, it's the explosion it creates that damage foes)
   ld A,quasar5b    ; what the mine or the torp become
   jr z,shot_col2


shot_col2:
   ld (damage),DE
   ld (shot_boum),A
   ld (souv_shot_addr),HL
   ld DE,250
   add HL,DE
   ld A,(HL)
   sub B                ; B is foe x
   add A,128
   ld HL,xmin
   cp (HL)
   ret c
   ld HL,xmax
   cp (HL)
   ret nc

   ld HL,(souv_shot_addr)
   ld DE,500
   add HL,DE
   ld A,(HL)
   sub C                ; C is foe y
   add A,128
   ld HL,ymin
   cp (HL)
   ret c
   ld HL,ymax
   cp (HL)
   ret nc

   ld HL,(souv_shot_addr)
   ld A,(shot_boum)
   ld (HL),A

col2_no_test:
   ld HL,(foe_num)
   ld DE,(foe_num)
   add HL,DE
   ld DE,foe_health
   add HL,DE
   ld (souv_h_addr),HL     ; save the address of the health of the foe

   ld E,(HL)
   inc HL
   ld D,(HL)
   push DE
   pop HL

   ld DE,(damage)
   cp 0               ; reset carry flag
   sbc HL,DE
   jr c,foe_destroyed
   jr z,foe_destroyed
   ex DE,HL
   ld HL,(souv_h_addr)
   ld (HL),E
   inc HL
   ld (HL),D
   ret

foe_destroyed:
   ld HL,(foe_addr)
    ld A,(HL)     ;
    cp star3b     ;
    ret z         ; so it doesn't increase the score if the foe has already been destroyed
   ld (HL),star3b
   ld DE,(score)
   inc DE
   ld (score),DE
   ret





shot_col3:

   ld (souv_shot_addr),HL
   
   ld DE,250
   add HL,DE            ; (HL) is now player shot x
   ld A,(HL)
   sub B                ; B is foe x
   add A,128
      add A,9
   ld HL,xmin
   cp (HL)
   ret c
      sub 18
   ld HL,xmax
   cp (HL)
   ret nc

   ld HL,(souv_shot_addr)
   ld DE,500
   add HL,DE            ; (HL) is now player shot y
   ld A,(HL)
   sub C                ; C is foe y
   add A,128
      add A,9
   ld HL,ymin
   cp (HL)
   ret c
      sub 18
   ld HL,ymax
   cp (HL)
   ret nc

   ld DE,500   ; damage dealt by a torp or a mine
   ld (damage),DE

   JUMP_(col2_no_test)





calc_laser:
calc_p_laser:
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   add A,17
   ld (HL),A
       cp 130
       ret c
       ld HL,(foe_addr)
       ld (HL),0
   ret


calc_bullet:
calc_p_bullet:
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   add A,8
   ld (HL),A
       cp 130
       ret c
       ld HL,(foe_addr)
       ld (HL),0
   ret

calc_onde:
calc_p_onde:
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   add A,6
   ld (HL),A
       cp 130
       ret c
       ld HL,(foe_addr)
       ld (HL),0
   ret


calc_beam:
delete_foe:
  ld HL,(foe_addr)
  ld (HL),0
  ret


calc_arc:
calc_spec2:
  ld HL,(foe_addr)
  ld DE,250
  add HL,DE
  ld A,(HL)
  and 3
  rlca
  rlca
  ld B,A
  add HL,DE
  ld A,(HL)
  and 3
  or B
  ld B,A
  ld C,A
  cp 14
  CALL_Z(arc_go_right16)
  cp 15
  CALL_Z(arc_go_right16)
  cp 0
  CALL_Z(arc_go_right16)
  cp 1
  CALL_Z(arc_go_right16)
  cp 2
  CALL_Z(arc_go_right16)
  cp 3
  CALL_Z(arc_go_right8)
  cp 13
  CALL_Z(arc_go_right8)
  cp 5
  CALL_Z(arc_go_left8)
  cp 11
  CALL_Z(arc_go_left8)
  cp 6
  CALL_Z(arc_go_left16)
  cp 7
  CALL_Z(arc_go_left16)
  cp 8
  CALL_Z(arc_go_left16)
  cp 9
  CALL_Z(arc_go_left16)
  cp 10
  CALL_Z(arc_go_left16)
  cp 6
  CALL_Z(arc_go_up8)
  cp 5
  CALL_Z(arc_go_up8)
  cp 4
  CALL_Z(arc_go_up8)
  cp 3
  CALL_Z(arc_go_up8)
  cp 2
  CALL_Z(arc_go_up8)
  cp 7
  CALL_Z(arc_go_up4)
  cp 1
  CALL_Z(arc_go_up4)
  cp 9
  CALL_Z(arc_go_down4)
  cp 15
  CALL_Z(arc_go_down4)
  cp 10
  CALL_Z(arc_go_down8)
  cp 11
  CALL_Z(arc_go_down8)
  cp 12
  CALL_Z(arc_go_down8)
  cp 13
  CALL_Z(arc_go_down8)
  cp 14
  CALL_Z(arc_go_down8)
  ret

arc_go_right16:
  ld HL,(foe_num)
  ld DE,foe_x
  add HL,DE
  ld A,(HL)
  add A,16
  cp 128
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret

arc_go_right8:
  ld HL,(foe_num)
  ld DE,foe_x
  add HL,DE
  ld A,(HL)
  add A,8
  cp 128
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret

arc_go_left8:
  ld HL,(foe_num)
  ld DE,foe_x
  add HL,DE
  ld A,(HL)
  sub 8
  cp 128
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret

arc_go_left16:
  ld HL,(foe_num)
  ld DE,foe_x
  add HL,DE
  ld A,(HL)
  sub 16
  cp 128
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret

arc_go_up8:
  ld HL,(foe_num)
  ld DE,foe_y
  add HL,DE
  ld A,(HL)
  add A,8
  cp 64
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret

arc_go_up4:
  ld HL,(foe_num)
  ld DE,foe_y
  add HL,DE
  ld A,(HL)
  add A,4
  cp 64
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret


arc_go_down8:
  ld HL,(foe_num)
  ld DE,foe_y
  add HL,DE
  ld A,(HL)
  sub 8
  cp 64
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret

arc_go_down4:
  ld HL,(foe_num)
  ld DE,foe_y
  add HL,DE
  ld A,(HL)
  sub 4
  cp 64
  JUMP_NC(delete_foe)
  ld (HL),A
  ld A,B
  ret



calc_torp:
     ;ld A,(niv_time)
     ;and 3     ; only bit 2 and 3 remains
     ;cp 0
     ;ret z     ; retour une fois sur 4
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   add A,5       ; avance de 5  (de 1 tous les 3/4 normalement)
   ld (HL),A
       cp 130
       ret c
       ld HL,(foe_addr)
       ld (HL),0
   ret


calc_foe_laser:
  ld A,5
  ld DE,$0A06
  CALL_(player_collision)
  ld HL,(foe_addr)
  ld A,(HL)
  cp foe_laser
  ld (HL),star1_plein
  ret nz
  ld (HL),foe_laser
  ld DE,250
  add HL,DE
  ld A,(HL)
  sub 12       ; speed of the foe_laser
  ld (HL),A
   CALL_(check_left2)
  ret


calc_fmd_laser:
  ld A,5
  ld DE,$0A0A
  CALL_(player_collision)
  ld HL,(foe_addr)
  ld A,(HL)
  cp fmd_laser
  ld (HL),star1_plein
  ret nz
  ld (HL),fmd_laser

  CALL_(get_data)
  ld A,D
  ld (trigo_angle),A
  CALL_(get_foe_xy)
  ld (trigo_center_y),BC
  ld A,10  ; speed of the foe multi directionnal laser
  ld (trigo_dist),A
  CALL_(do_trigo)

  ld HL,(foe_addr)
  ld DE,250
  add HL,DE
  ld (HL),B
  add HL,DE
  ld (HL),C
  JUMP_(check_4d)



calc_homing:
  ld A,15
  ld DE,$0A08
  CALL_(player_collision)
  ld HL,(foe_addr)
  ld A,(HL)
  cp homing
  ld (HL),quasar4
  ret nz
  ld (HL),homing
  ld DE,250
  add HL,DE
  ld A,(HL)
  sub 10       ; speed of the homing
  ld (HL),A
  CALL_(check_left2)
  CALL_(get_a_player_xy)
  CALL_(up_or_down1)
  CALL_(up_or_down1)
  ret



calc_ball:
  ld A,3             ; damage to player
  ld DE,$0A06        ; size
  CALL_(player_collision)
  ld HL,(foe_addr)
  ld A,(HL)
  cp ball
  ld (HL),bullet_boum
  ret nz
  ld (HL),ball
  ld A,(foe_num)
  cp 50
  JUMP_C(calc_fmd_ball)
  ld DE,250
  add HL,DE
  ld A,(HL)
  sub 4       ; speed of the ball
  ld (HL),A
   CALL_(check_left2)
  ret

calc_fmd_ball:
  CALL_(get_data)
  ld A,D
  ld (trigo_angle),A
  CALL_(get_foe_xy)
  ld (trigo_center_y),BC
  ld A,4  ; speed of the foe multi directionnal ball shot
  ld (trigo_dist),A
  CALL_(do_trigo)

  ld HL,(foe_addr)
  ld DE,250
  add HL,DE
  ld (HL),B
  add HL,DE
  ld (HL),C
  JUMP_(check_4d)


calc_bbg_shot:
  ld A,10
  ld DE,$1906   ; x_size=$19=25 ; y_size=6
  CALL_(player_collision)
  ld HL,(foe_addr)
  ld (HL),bbg_shot
  ld DE,250
  add HL,DE
  ld A,(HL)
  sub 20       ; speed of the bbg_shot
  ld (HL),A
   CALL_(check_left2)
  ret

calc_asteroid1:
calc_asteroid2:
calc_asteroid3:
calc_asteroid4:
   ld A,20                      ; damage to player if hit
   ld DE,$0D07                  ; D=x_size  E=y_size
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   CALL_(shot_collision)
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   sub 8
   ld (HL),A
       cp 243    ; point ou les asteroids sont detruit car trop a gauche
       ret c
       ld HL,(foe_addr)
       ld (HL),0
   ret


calc_saucer1:
   ld A,5                       ; damage to player if hit
   ld DE,$0F0D                  ; D=x_size  E=y_size
   CALL_(player_collision)
    ld HL,(foe_addr)
    ld (HL),saucer1           ; so it doesn't explode when it hits the player
   CALL_(shot_collision)      ; always call shot_collision after player_collision
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   dec A
   ld (HL),A
   cp 233    ; point ou detruit car trop a gauche
   ld HL,(foe_addr)
   ld A,(HL)
   ld (HL),0
   ret nc
   ld (HL),A

   CALL_(get_a_player_xy)
   ld A,B
   ld HL,(foe_num)
   ld DE,foe_x
   add HL,DE
   cp (HL)
   jr nc,saucer_left
   ld A,(niv_time)
   bit 0,A
   ld A,C                ; C is player y
   CALL_Z(up_or_down1)
   ret

saucer_left:
   ld DE,(foe_num)
   ld HL,foe_x
   add HL,DE
   ld A,(HL)
   sub 8       ; recule de 8+1=9
   ld (HL),A

   ld DE,(foe_num)
   ld HL,(foe_num)
   add HL,DE
   ld DE,foe_data
   add HL,DE
   ld E,(HL)
   inc HL
   ld D,(HL)
   ld A,D
   set 7,D
   set 6,D
   ld (HL),D
   dec HL
   ld (HL),E

   ret




calc_inter1:
     ld A,20                      ; damage if it hits the player
     ld DE,$0E08                  ; D=x_size  E=y_size
     CALL_(player_collision)
     CALL_(shot_collision)        ; always call shot_collision after player_collision
       ld A,h_bonus
       ld (ftp_type),A
       ld HL,(foe_addr)
       ld A,(HL)
       cp inter1
       JUMP_NZ(put_bonus)
    ld DE,(foe_num)                               ;
    ld HL,foe_x                                   ;
    add HL,DE                                     ; move forward
    ld A,(HL)                                     ;
    sub 3    ; horizontal speed of the inter1     ;
    ld (HL),A                                     ;
   JUMP_(check_left)
   ret



calc_inter2:
   ld A,20                      ; damage if it hits the player
   ld DE,$0E08                  ; D=x_size  E=y_size
   CALL_(player_collision)
   CALL_(shot_collision)        ; always call shot_collision after player_collision
       push BC                ; save x y of foe
       CALL_(get_a_player_xy)
       ld A,(niv_time)
       bit 0,A
       ld A,C                 ; put player y in Acc
       pop BC      ; restore x y of foe
       CALL_Z(up_or_down1)
      CALL_(up_or_down1) 
   ld HL,(foe_addr)
   ld A,(HL)
   cp inter2
   JUMP_NZ(inter2_dead)
   ld DE,250
   add HL,DE
   ld A,(HL)
   sub 3    ; horizontal speed of the inter2
   ld (HL),A
   CALL_(check_left)
     ld A,(niv_time)
     add A,23
     and 15           ; pour tirer tous les 16
   ret nz
fire_inter2:
     ld A,foe_laser
     ld (ftp_type),A
     ld HL,(foe_addr)
     ld DE,250
     add HL,DE
     ld A,(HL)
     cp 127
     ret nc
     add A,12
     ld B,A
     add HL,DE
     ld A,(HL)
     sub 6
     ld C,A
     CALL_(put_foe_shot)
     ld A,C
     add A,12
     ld C,A
     CALL_(put_foe_shot)
   ret

inter2_dead:
    ld A,(niv_num)
    cp 2
    ret nz
    ld HL,c_niv
    inc (HL)
    ld A,(HL)
    cp 20      ; number of inter2 to kill to go to level 3 (si on veut changer, changer aussi dans status)
    ret nz
     CALL_(next_niv)
     ld A,e_bonus
     ld (ftp_type),A
     CALL_(put_bonus)
   ret


calc_duck:
   ld A,5                      ; damage if it hits the player
   ld DE,$0C10                  ; D=x_size  E=y_size
   CALL_(player_collision)
    ld HL,(foe_addr)
    ld (HL),duck           ; so it doesn't explode when it hits the player
   CALL_(shot_collision)        ; always call shot_collision after player_collision
        ld HL,(foe_addr)
        ld A,(HL)
        cp duck
        JUMP_NZ(duck_dead)
      ld DE,(foe_num)
      ld HL,foe_x
      add HL,DE
      ld A,(HL)
      sub 1        ; horizontal speed of a duck
      ld (HL),A
      CALL_(check_left)
      
        ld HL,(foe_num)
        ld DE,foe_y
        add HL,DE
        ld A,(HL)
        ld C,A

      ld DE,(foe_num)
      ld HL,(foe_num)
      add HL,DE
      ex DE,HL
      ld HL,foe_data
      add HL,DE
      ld A,(HL)
      cp 0
      jr z,pas_bouge_duck
      cp C
      CALL_Z(next_point_duck)
      CALL_(up_or_down1)
pas_bouge_duck:
      ld A,(niv_time)
      add A,47
      and 15
      CALL_Z(fire_inter2)
      ret

duck_dead:
   ld A,(niv_num)
   cp 3
   ret nz
   ld A,(c_niv)
   inc A
   ld (c_niv),A
   cp 10
   ret nz
   JUMP_(next_niv)

next_point_duck:
   cp 32
   ld A,55
   ld (HL),A
   ret c
   ld A,8
   ld (HL),A
   ret


calc_bee:   
   ld A,30                      ; damage to player if hit
   ld DE,$0E08                  ; D=x_size  E=y_size
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   CALL_(shot_collision)
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld A,(HL)
   sub 2
   ld (HL),A
   cp 60
   push HL
   CALL_C(fire_mis1)
   pop HL
   ld A,(HL)
   cp 94
   CALL_C(fire_mis2)
   CALL_(check_left)
   ret


fire_mis2:
    ld HL,(foe_num)
    ld DE,(foe_num)
    add HL,DE
    ld DE,foe_data
    add HL,DE
    inc HL
    ld A,(HL)
    cp 2
    ret nz
    ld (HL),1
    ld HL,(foe_addr)
    ld DE,250
    add HL,DE
    ld A,(HL)
    add A,6
    ld B,A
    add HL,DE
    ld C,(HL)
    ld A,homing
    ld (ftp_type),A
    JUMP_(put_foe_shot)

fire_mis1:
    ld HL,(foe_num)
    ld DE,(foe_num)
    add HL,DE
    ld DE,foe_data
    add HL,DE
    inc HL
    ld A,(HL)
    cp 1
    ret nz
    ld (HL),0
    ld HL,(foe_addr)
    ld DE,250
    add HL,DE
    ld A,(HL)
    add A,6
    ld B,A
    add HL,DE
    ld C,(HL)
    ld A,homing
    ld (ftp_type),A
    JUMP_(put_foe_shot)


fire_mis:
    ld HL,(foe_addr)
    ld DE,250
    add HL,DE
    ld A,(HL)
    add A,10
    ld B,A
    add HL,DE
    ld C,(HL)
    ld A,homing
    ld (ftp_type),A
    JUMP_(put_foe_shot)



calc_saucer_boss:
   ld A,5                       ; damage to player if hit
   ld DE,$0F0D                  ; D=x_size  E=y_size
   CALL_(player_collision)
    ld HL,(foe_addr)
    ld (HL),saucer_boss       ; so it doesn't explode when it hits the player
   CALL_(shot_collision)      ; always call shot_collision after player_collision
      ld HL,(foe_addr)
      ld A,(HL)
      cp saucer_boss
      JUMP_NZ(saucer_boss_dead)
      ld DE,250
      add HL,DE
      ld A,(HL)
      cp 90
      jr c,saucerbossnoleft
       ld A,(HL)
       dec A
       ld (HL),A
         ret           ; don't do any other thing if still moving left
saucerbossnoleft:
   CALL_(get_a_player_xy)
   CALL_(up_or_down1)
   CALL_(up_or_down1)
   ld A,(niv_time)
   add A,20
   and 31
   CALL_Z(fire_mis)        ; fire a homing missile every 32
      ld HL,(foe_num)
      ld DE,(foe_num)
      add HL,DE
      ld DE,foe_data
      add HL,DE
      ld A,(HL)
      or A
      jr z,saucer_boss_fire
      dec A
      ld (HL),A
      ret

saucer_boss_fire:
      ld HL,(foe_num)
      ld DE,(foe_num)
      add HL,DE
      ld DE,foe_data
      add HL,DE
      ld (HL),4          ; pour que saucer_boss tire tous les 4+1=5
   ld HL,(foe_addr)
   ld DE,250
   add HL,DE
   ld B,(HL)
   add HL,DE
   ld C,(HL)
     push HL
     push BC
     CALL_(get_a_player_xy)
     pop BC
     pop HL
   sub (HL)
   cp 253                   ; 253=-3
   JUMP_NC(saucerbossball)
   cp 4                     ; 4 et pas 3 car _C et pas _NC
   JUMP_C(saucerbossball)
     ld A,foe_laser
     ld (ftp_type),A
       ld A,B
       add A,8
       ld B,A
    ld A,C
    add A,10
    ld C,A
      CALL_(put_foe_shot)
    ld A,C
    sub 20
    ld C,A
      CALL_(put_foe_shot)
  ret

saucerbossball:
   ld A,ball
   ld (ftp_type),A
   ld A,B
   sub 6
   ld B,A
   ld A,(niv_time)
   and 1
   add A,A
   add A,A
   add A,C
   sub 2
   ld C,A     ; tantot en haut tantot en bas
   JUMP_(put_foe_shot)


saucer_boss_dead:
   ld A,7
   ld (num_niv),A
   CALL_(get_foe_xy)
   ld B,89
   ld A,o_bonus
   ld (ftp_type),A
   CALL_(put_bonus)
   ld A,torp_bonus
   ld (ftp_type),A
   ld A,C
   add A,10
   ld C,A
   ld B,103
   CALL_(put_bonus)
   ld B,75
   CALL_(put_bonus)
   ld A,C
   sub 20
   ld C,A
   CALL_(put_bonus)
   ld B,103
   CALL_(put_bonus)
   ret

calc_pb_giver:
   ld A,20                      ; damage to player if hit
   ld DE,$0B07                  ; B=x_size  E=y_size
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   CALL_(shot_collision)
       ld A,p_bonus
       ld (ftp_type),A
     CALL_(get_foe_xy)
     ld HL,(foe_addr)
     ld A,(HL)
     cp pb_giver
     JUMP_NZ(put_bonus)
      ld DE,(foe_num)
      ld HL,(foe_num)
      add HL,DE
      ex DE,HL
      ld HL,foe_data
      add HL,DE
      ld A,(HL)
      cp 0
      jr z,pb_giver_sort
      cp B
      jr nc,pb_giver_sort
      ld HL,(foe_num)
      ld DE,foe_x
      add HL,DE
      ld A,(HL)
      sub 2
      ld (HL),A
      ret
pb_giver_sort:
      ld A,0
      ld (HL),A
      ld HL,(foe_num)
      ld DE,foe_x
      add HL,DE
      ld A,(HL)
      inc A
      ld (HL),A
      cp 135
      JUMP_NC(delete_foe)
      ret

calc_hunter:
  ld A,20
  ld DE,$0D0D
  CALL_(player_collision)
  CALL_(shot_collision)
  CALL_(find_p_angle)
  CALL_(get_data)
  ld A,(fa_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(change_angle)
  CALL_(put_data)
  ld A,D
  ld (trigo_angle),A
  CALL_(get_foe_xy)
  ld (trigo_center_y),BC
  ld A,5  ; speed
  ld (trigo_dist),A
  CALL_(do_trigo)
  ld HL,(foe_addr)
  ld DE,250
  add HL,DE
  ld (HL),B
  add HL,DE
  ld (HL),C
  ret




calc_turret:
     CALL_(get_foe_xy)
     ld A,127
     cp B
     ret c
     ld A,63
     cp C
     ret c
   ld A,20                      ; damage to player if hit
   ld DE,$0906                  ; D=x_size  E=y_size
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   CALL_(shot_collision)
    CALL_(get_data)
    dec E
      push DE
      CALL_(find_p_angle)
      pop DE
    ld A,(fa_angle)
    ld D,A
    CALL_(put_data)
    ld A,E
    cp 255
    ret nz
    ld E,4   ;  tire tout les 4+1=5
    CALL_(put_data)
fire_fmd_laser:
    CALL_(get_foe_xy)
    ld A,fmd_laser
    ld (ftp_type),A
    ld HL,$FFFF
    ld (ftp_health),HL
    ld (ftp_data),DE  ; same DE as turret
    JUMP_(put_foe)


calc_bb_gun:
   ld A,5                       ; damage to player if hit
   ld DE,$0C04                  ; D=x_size  E=y_size
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   ld HL,(foe_addr) ;
   ld (HL),bb_gun   ; not destroyed if hit by player ship
   CALL_(shot_collision)
   CALL_(get_data)
   ld A,E
   dec E
   CALL_(put_data)
   cp 0
   ret nz
   ld E,17 ; tire tous les 17+1=18
   CALL_(put_data)
   CALL_(get_foe_xy)
   ld A,B
   sub 13
   ld B,A
   ld A,bbg_shot
   ld (ftp_type),A
   JUMP_(put_foe_shot)




calc_bb1:
   ld A,(foe_type+nbbg1)
   cp bb_gun
   ret z
   ld A,(foe_type+nbbg2)
   cp bb_gun
   ret z
   ld A,(foe_type+nbb1t+0)
   cp turret
   ret z
   ld A,(foe_type+nbb1t+1)
   cp turret
   ret z
   ld A,(foe_type+nbb1t+2)
   cp turret
   ret z
   ld A,(foe_type+nbb1t+3)
   cp turret
   ret z
   ld A,(foe_type+nbb1t+4)
   cp turret
   ret z
   ld A,(foe_type+nbb1t+5)
   cp turret
   ret z
   ld A,(foe_type+nbb1t+6)
   cp turret
   ret z
   ld A,2                       ; damage to player if hit
   ld DE,$1616                  ; D=x_size  E=y_size =$16=22
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   ld HL,(foe_addr) ;
   ld (HL),bb1      ; not destroyed if hit by player ship
   CALL_(shot_collision)
   ld HL,(foe_addr)
   ld A,(HL)
   cp bb1
   JUMP_NZ(bb1_dead)
   ld A,(foe_health+nbb1+nbb1+1)
   cp 8*4
   JUMP_C(bb1_firing_ball)
   cp 10*4
   JUMP_C(bb1_firing_mis)
   JUMP_(bb_launch_ship)

bb1_firing_ball:
   CALL_(bb1_fire_mis_2)
   CALL_(get_data)
   ld A,0
   cp E
   jr z,bb1_firing_b1
   dec E
   JUMP_(put_data)
bb1_firing_b1:
    ld E,22  ;  tire tous les 22+1=23
    ld A,(foe_health+nbb1+nbb1+1)
    cp 2*4
    jr nc,bb1_firing_b2
     ld E,6  ;  tire tous les 6+1=7
bb1_firing_b2:
   CALL_(put_data)
   ld A,ball
   ld (ftp_type),A
   CALL_(find_p_angle)
   ld A,(fa_angle)
   ld D,A
   ld (ftp_data),DE
   ld A,7   ; number of shot
   ld (c_draw_bb),A
   CALL_(get_foe_xy)
   ld A,B
   sub 16
   ld B,A
   ld A,C
   sub 16
   ld C,A
   ld (souv_bb_xy),BC
bb1_fire_loop:
  ld BC,(souv_bb_xy)
  CALL_(get_rand)
  and 31
  add A,B
  ld B,A
  CALL_(get_rand)
  and 31
  add A,C
  ld C,A
  CALL_(put_foe)
 ld A,(c_draw_bb)
 dec A
 ld (c_draw_bb),A
 jr nz,bb1_fire_loop
 ret

bb1_firing_mis:
   ld DE,0
   ld (foe_data+nbb1+nbb1),DE
bb1_fire_mis_2:
   ld A,(niv_time)
   and 7
   ret nz
   CALL_(get_rand)
   and 31
   sub 16
   ld HL,foe_y+nbb1
   add A,(HL)
   ld C,A
   ld A,(foe_x+nbb1)
   add A,14
   ld B,A
   ld A,homing
   ld (ftp_type),A
   JUMP_(put_foe_shot)



calc_bb2:
   ld A,(foe_type+nbbg3)
   cp bb_gun
   ret z
   ld A,(foe_type+nbbg4)
   cp bb_gun
   ret z
   ld A,(foe_type+nbb2t+0)
   cp turret
   ret z
   ld A,(foe_type+nbb2t+1)
   cp turret
   ret z
   ld A,2                       ; damage to player if hit
   ld DE,$190B                  ; D=$19=25=x_size  E=$0B=11=y_size
   CALL_(player_collision)      ; always put player_collision before shot_collision because only player_collision update xmin,xmax,ymin and ymax
   ld HL,(foe_addr) ;
   ld (HL),bb2      ; not destroyed if hit by player ship
   CALL_(shot_collision)
   ld HL,(foe_addr)
   ld A,(HL)
   cp bb2
   JUMP_NZ(bb2_dead)
   ld A,(foe_health+nbb2+nbb2+1)
   cp 3*4
   JUMP_C(bb2_fire_laser_2)
   cp 6*4
   JUMP_C(bb2_fire_laser_1))
   JUMP_(bb_launch_ship)

bb2_fire_laser_1:
  ld A,(niv_time)
  and 24
  ret z
  ld A,(niv_time)
  bit 6,A
  jr nz,bb2_fl1s
  add A,8
bb2_fl1s:
  and 31
  rla
  rla
  rla
  rla
  ld (trigo_angle),A
  ld A,13
  ld (trigo_dist),A
  ld A,(foe_x+nbb2)
  ld (trigo_center_x),A
  ld A,(foe_y+nbb2)
  ld (trigo_center_y),A
  CALL_(do_trigo)
  ld A,(foe_x+nbb2)
  add A,28
  ld B,A
  ld A,foe_laser
  ld (ftp_type),A
  JUMP_(put_foe_shot)

bb2_fire_laser_2:
    ld A,(niv_time)
    bit 4,A
    ret z
    ld A,fmd_laser
    ld (ftp_type),A
    CALL_(find_p_angle)
    ld A,(fa_angle)
    ld D,A
    ld (ftp_data),DE
    CALL_(get_foe_xy)
    JUMP_(put_foe)

bb_launch_ship:
   CALL_(get_data)
   ld A,E
   dec E
   CALL_(put_data)
   cp 0
   ret nz
bb_launch_ship2:
   ld A,D
   inc A
   cp 6
   jr nz,bb_l_l_ship
   ld A,0
bb_l_l_ship
   ld D,A
   add A,D
   add A,D
   add A,D
   add A,D
   add A,D
   ld H,0
   ld L,A
     push DE
   ld DE,bb2_launch_data
   add HL,DE
   ld DE,(PROGRAM_ADDR)
   add HL,DE
     pop DE
   ld E,(HL)
   CALL_(put_data)
   inc HL
   ld A,(HL)
   ld (ftp_type),A
   inc HL
   ld E,(HL)
   inc HL
   ld D,(HL)
   ld (ftp_health),DE
   inc HL
   ld E,(HL)
   inc HL
   ld D,(HL)
   ld (ftp_data),DE
   CALL_(get_foe_xy)
   JUMP_(put_foe)


bb2_launch_data:  ; time before next,type,health(2bytes),data(2bytes)
.db 60,saucer1,132,3 ,0,0
.db 20,hunter,200 ,0 ,0,127
.db 70,duck  , 88 ,2 ,32,1
.db 40,inter2,200 ,0 ,0,1
.db 30,inter1,200 ,0 ,0,1
.db 40,bee   ,44  ,1 ,0,2


calc_bb_rear:
  ld A,5                       ; damage to player if hit
  ld DE,$0D0C                  ; D=x_size  E=y_size
  CALL_(player_collision)
  ld HL,(foe_addr)
  ld (HL),bb_rear
  ret

bb1_dead:
  CALL_(get_foe_xy)
  ld A,B
  sub 32
  ld B,A
  ld A,C
  sub 32
  ld C,A
  ld (souv_bb_xy),BC
  ld DE,$7F3F ; D=127 E=63
  ld (souv_xy_cracks),DE
  ld A,saucer1
  ld (foe_type+nbbr1),A
  ld A,(foe_type+nbbr2)
  JUMP_(bb_dead)

bb2_dead:
  CALL_(get_foe_xy)
  ld A,B
  sub 40
  ld B,A
  ld A,C
  sub 8
  ld C,A
  ld (souv_bb_xy),BC
  ld DE,$3F0F ; D=63 E=15
  ld (souv_xy_cracks),DE
  ld A,duck
  ld (foe_type+nbbr2),A
  ld A,(foe_type+nbbr1)
  JUMP_(bb_dead)



bb_dead:
  cp bb_rear
  jr z,bb_dead_sui
   CALL_(get_foe_xy)
   ld A,o_bonus
   ld (ftp_type),A
   CALL_(put_bonus)
   jr bb_dead_no_bo
bb_dead_sui
  ld A,7
  ld (c_draw_bb),A
  ld A,h_bonus
  ld (ftp_type),A
  CALL_(bb_dead_loop)
  
  ld A,4
  ld (c_draw_bb),A
  ld A,torp_bonus
  ld (ftp_type),A
  CALL_(bb_dead_loop)
bb_dead_no_bo:
  ld A,12
  ld (c_draw_bb),A
  ld A,star3b
  ld (ftp_type),A
  CALL_(bb_dead_loop)
  
  ld A,7
  ld (c_draw_bb),A
  ld A,bigstar
  ld (ftp_type),A
  CALL_(bb_dead_loop)

  ld A,5
  ld (c_draw_bb),A
  ld A,quasar5b
  ld (ftp_type),A
  CALL_(bb_dead_loop)

  ret

bb_dead_loop:
  ld BC,(souv_bb_xy)
  CALL_(get_rand)
  ld HL,(souv_xy_cracks)
  and H
  add A,B
  ld B,A
  CALL_(get_rand)
  ld HL,(souv_xy_cracks)
  and L
  add A,C
  ld C,A
  CALL_(put_foe_shot)
 ld A,(c_draw_bb)
 dec A
 ld (c_draw_bb),A
 jr nz,bb_dead_loop


get_foe_xy:
  push AF
  push DE
  push HL
   ld HL,(foe_addr)
   ld DE,250
   add HL,DE
   ld A,(HL)
   ld B,A
   add HL,DE
   ld A,(HL)
   ld C,A
  pop HL
  pop DE
  pop AF
   ret

get_data:
  push AF
  push BC
  push HL
  ld HL,foe_data
  ld BC,(foe_num)
  add HL,BC
  add HL,BC
  ld E,(HL)
  inc HL
  ld D,(HL)
  pop HL
  pop BC
  pop AF
  ret


put_data:
  push AF
  push BC
  push HL
  ld HL,foe_data
  ld BC,(foe_num)
  add HL,BC
  add HL,BC
  ld (HL),E
  inc HL
  ld (HL),D
  pop HL
  pop BC
  pop AF
  ret



get_a_player_xy:         ; choose a player , make B=x of the player , A=C=y of the player
   ld A,(player_num)
   or A
   jr z,get_player0_xy
       ld A,(player_health+npd)
       ld HL,player_health+npd+npd
       or (HL)
       jr z,get_no_player_xy
     ld A,(foe_num)
     bit 0,A
     jr z,get_player1_xy
     jr get_player2_xy


get_player0_xy:
  ld A,(player_health)
  cp 0
  jr z,get_no_player_xy
  ld BC,(player_y)
  ld A,C
  ret

get_no_player_xy:
   ld B,64
   ld HL,(foe_num)
   ld DE,foe_y
   add HL,DE
   ld A,(HL)
   ld C,A
   ret

get_player1_xy:
  ld A,(player_health+npd)
  or A
  jr z,get_player2_xy
    ld BC,(player_y+npd)
    ld A,C
    ret

get_player2_xy:
  ld A,(player_health+npd+npd)
  or A
  jr z,get_player1_xy
    ld BC,(player_y+npd+npd)
    ld A,C
    ret


up_or_down1:     ; try to match the height of A
   ld HL,foe_y
   ld DE,(foe_num)
   add HL,DE
   ld C,(HL)
   cp C
   ret z
 push AF
   sub C
   cp 128
   jr c,foe_going_up
   dec C
   dec C
foe_going_up:
   inc C
   ld (HL),C
 pop AF
   ret

left_or_right1:     ; try to match x=A
   ld HL,foe_x
   ld DE,(foe_num)
   add HL,DE
   ld B,(HL)
   cp B
   ret z
 push AF
   sub B
   cp 128
   jr c,foe_going_right
   dec B
   dec B
foe_going_right:
   inc B
   ld (HL),B
 pop AF
   ret

change_angle:     ; inc D or dec D to make D=A
   cp D
   ret z
 push AF
   sub D
   cp 128
   jr c,foe_going_id
   dec D
   dec D
foe_going_id:
   inc D
 pop AF
   ret

calc_o_bonus:
   ld A,3
   ld (c_player_fire),A
   ld (c_player_fire+npd),A
   ld (c_player_fire+npd+npd),A
   ld (c_torp),A
   ld (c_torp+npd),A
   ld (c_torp+npd+npd),A
calc_h_bonus:
calc_e_bonus:
calc_p_bonus:
calc_torp_bonus:
calc_bonus:
    CALL_(try_attract)
   ld DE,$0707  ; size of object
   ld A,0       ; damage to player if hit
   JUMP_(player_collision)

get_h_bonus:
   ld HL,(foe_addr)
   ld (HL),0  ; so the h_bonus doesn't explode when it is taken
   ld A,(player_health)
   add A,10
   ld (player_health),A
   cp 100
   ld A,11
   ld (c_message),A
   ld HL,text_h_bonus
   ld (message_addr),HL
   ret c
   ld A,100
   ld (player_health),A
   ret



get_e_bonus:
   ld HL,(foe_addr)
   ld (HL),0  ; so the e_bonus doesn't explode when it is taken
   ld A,(engine+npd)
   inc A
   ld (engine+npd),A
    ld A,(engine+npd+npd)
    inc A
    ld (engine+npd+npd),A
  ld A,(engine)
  inc A
  ld (engine),A
  cp 4
  ret nc
   ld A,25
   ld (c_message),A
   ld HL,text_e_bonus
   ld (message_addr),HL
   ret


get_p_bonus:
   ld A,(game_done)
   and 12
   ret z               ; so it can't be taken if ...
     ld HL,(foe_addr)
     ld (HL),0  ; delete the p_bonus
inc_gun_power:
  ld A,(gun_power)
  and 15
  inc A
  and 15
  ret z
  ld B,A
  ld A,(gun_power)
  and 112            ; keep only bits 6,5,4  (reset bits 7,3,2,1,0)
  or B
  ld (gun_power),A

  ld A,0
  sra B                ; divide B<128 by two
  inc B
inc_gun_power_loop:
    rlca
    or 1
    djnz inc_gun_power_loop
     or 2
     ld (gun_direction),A
      ld A,(gun_power)
      and 15
      cp 15
      ret nz
      ld A,(gun_power)
      set 7,A
      ld (gun_power),A
      ret


get_o_bonus:
   ld HL,(foe_addr)
   ld (HL),0
 ld A,(num_niv)
 cp 8
 jr z,get_o_bonus2
    ld A,100
    ld (player_health),A
    ld (player_health+npd),A
    ld (player_health+npd+npd),A
   ld A,15
   ld (c_message),A
   ld HL,text_o_bonus
   ld (message_addr),HL
   JUMP_(next_niv)
get_o_bonus2:
   ld A,(game_done)
   inc A
   ld (game_done),A
   ld A,0
   ld (c_message),A
   JUMP_(set_new_game)

get_torp_bonus:
   ld HL,(foe_addr)
   ld (HL),0
   ld A,(n_torp)
   inc A
   ld (n_torp),A
   ld A,13
   ld (c_message),A
   ld HL,text_torp_bonus
   ld (message_addr),HL
   ret


check_left:         ; delete the foe if it has gone out of screen left
  ld HL,foe_x
  ld DE,(foe_num)
  add HL,DE
  ld A,(HL)
  cp 225
  ret c
  cp 240  ; point ou detruit car trop a gauche
  ret nc
  ld HL,(foe_addr)
  ld (HL),0
  ret

check_left2: ; delete the foe if A is from 210 to 240
  cp 209
  ret c
  cp 240  ; point ou detruit car trop a gauche
  ret nc
  push HL
  ld HL,(foe_addr)
  ld (HL),0
  pop HL
  ret

check_4d:
  ld HL,(foe_num)
  ld DE,foe_x
  add HL,DE
  ld B,(HL)
  ld A,32
  add A,B
  cp 192
  CALL_NC(delete_foe)
  ld HL,foe_y
  ld DE,(foe_num)
  add HL,DE
  ld C,(HL)
  ld A,32
  add A,C
  cp 128
  CALL_NC(delete_foe)
  ret

try_attract:
   ld A,(player_flame)
   and 31
   cp 31
   ret nz
   ld A,(c_player_move)
   or A
   ret nz
   ld A,(player_x)
   CALL_(left_or_right1)
   ld A,(player_y)
   CALL_(up_or_down1)
   ret



get_rand:                ; used to get a "random" number in A ( en fait ca prend les octets du programme les uns apres les autres )
  push DE                ; modify only AF
  push HL
    ld HL,(rand_addr)
    inc HL
    ld (rand_addr),HL

    ld A,(game_done)
    ld DE,79
    add A,(HL)
      rlca     ; avec rlca ca revient par l'autre bout, mais pas avec rla
      rlca
    add HL,DE
    add A,(HL)
      rlca     ; avec rlca ca revient par l'autre bout, mais pas avec rla
      rlca
       push HL
       ld HL,game_done
       add A,(HL)
       pop HL
    add HL,DE
    add A,(HL)
      rlca
      rlca
    add HL,DE
    add A,(HL)
       ld DE,(rand_addr_max)
       call CP_HL_DE
  pop HL
  pop DE
  ret nz
    push HL
    ld HL,(PROGRAM_ADDR)
    ld (rand_addr),HL
    pop HL
    ret


put_bonus:
put_foe_shot:          ; put a foe shot of position=BC of type=(ftp_type)
  ld HL,foe_shot_type
  ld DE,foe_shot_type+100
pfsl1:
     inc HL
     call CP_HL_DE
     JUMP_Z(find_mem_full)
     ld A,(HL)
     or A           ; check if there is already something
    jr nz,pfsl1
  ld DE,250
  ld A,(ftp_type)
  ld (HL),A
  ADD HL,DE
  ld A,B
  ld (HL),A
  ADD HL,DE
  ld A,C
  ld (HL),A
  ret




put_foe:              ; put a foe of type=(ftp_type) (1 byte)   of health=(ftp_health) (2 bytes)   of data=(ftp_data) (2 bytes)   of position=BC
  ld HL,foe_type
  ld DE,foe_type+50
pfl1:
     inc HL
     call CP_HL_DE
     JUMP_Z(find_mem_full)
     ld A,(HL)
     or A           ; check if there is already something
    jr nz,pfl1

  ld (souv_ftp_addr),HL

  ld A,(ftp_type)
  ld (HL),A

  ld DE,250

  ADD HL,DE
  ld A,B
  ld (HL),A

  ADD HL,DE
  ld A,C
  ld (HL),A

  ld HL,(souv_ftp_addr)
  ld DE,foe_type
  cp 0           ; reset carry flag so sbc won't substract one more if ...
  sbc HL,DE  ; HL should now be foe num
  ld E,L
  ld D,H
  add HL,DE
  ex DE,HL   ; DE should now be 2*(foe num)

  ld HL,foe_health
  add HL,DE
  ld BC,(ftp_health)
  ld (HL),C
  inc HL
  ld (HL),B

  ld HL,foe_data
  add HL,DE
  ld BC,(ftp_data)
  ld (HL),C
  inc HL
  ld (HL),B

  ret



put_rand_xy_foe:
   CALL_(get_rand)
   res 5,A  ; 2^5=32
   or 144   ; 144=128+16      ; Acc is now 144 to 223  (because " or 144" set bit 7 and 4)
   ld B,A
   CALL_(get_rand)
   and 63                ; Acc is now 0 to 63  because 63 is 111111 in binary, so " and 63" means "keep only the first six bits" or "reset bit 6 and 7" .
                         ; After " and 63" , Acc can be any number from 0 to 63, but after " and 64" , Acc could only be 0 or 64.
   ld C,A
   JUMP_(put_foe)



put_asteroid1:
   ld A,asteroid1
   JUMP_(put_asteroid1234)
put_asteroid2:
   ld A,asteroid2
   jr put_asteroid1234
put_asteroid3:
   ld A,asteroid3
   jr put_asteroid1234
put_asteroid4:
   ld A,asteroid4
   jr put_asteroid1234



put_asteroid1234:
   ld HL,ftp_type
   ld (HL),A
   ld HL,45           ; health of an asteroid
   ld (ftp_health),HL
   ld HL,0
   ld (ftp_data),HL
   ld A,243
   cp B
   CALL_NC(put_foe)
   ret



put_saucer1:
   ld HL,ftp_type
   ld (HL),saucer1
   ld HL,900           ; health of a saucer1
   ld (ftp_health),HL
   ld HL,0
   ld (ftp_data),HL
   ld B,211
   ld C,32
   CALL_(put_foe)
   ret


put_inter1:
   ld A,inter1
   jr put_inter1_and_2
put_inter2:
   ld A,inter2
put_inter1_and_2:
   ld (ftp_type),A
   ld HL,200           ; health of the inter2
   ld (ftp_health),HL
   ld HL,0
   ld (ftp_data),HL
   JUMP_(put_rand_xy_foe)



put_bee:
   ld A,bee
   ld (ftp_type),A
   ld HL,300           ; health of the bee
   ld (ftp_health),HL
   ld DE,$0200         ; 2=2 missile
   ld (ftp_data),DE
   JUMP_(put_rand_xy_foe)


put_duck:     ; sometime it is destroyed by check_left just after
  ld A,duck
  ld (ftp_type),A
  ld HL,600
  ld (ftp_health),HL
  CALL_(get_rand)
  and 63               ; Acc is now from 0 to 63 ( because only the six first bits are kept (" and 64" would not made Acc be from 0 to 64, it would have made Acc be 0 or 64))
  inc A                ; so it is not 0 ( because first data byte =0 means don't go up and down (for this ship) )
   ld C,A
   ld E,C
   ld D,0
   ld (ftp_data),DE   ; first data byte = height to match
  CALL_(get_rand)
  res 4,A
  or 132             ; set bit 7 and 2
  ld B,A             ; 132 to 239
  JUMP_(put_foe)
  ; fin put_duck



t_p_pb_g_2p:
  ld A,(gun_power+npd)
  ld HL,gun_power+npd+npd
  cp (HL)
  jr nc,t_pb_g_2p_m
  ld A,(HL)
t_pb_g_2p_m:
  ld (temp_gun_power),A
  ld A,(game_done+npd)
  ld HL,game_done+npd+npd
  or (HL)
  jr t_p_pb_g_2p_f

try_put_pb_giver:
   ld A,(niv_time)
   res 7,A
   cp 37
   ret nz
    ld A,(player_num)
    or A
        ld A,(gun_power)
        ld (temp_gun_power),A
      ld A,(game_done)
    jr nz,t_p_pb_g_2p
t_p_pb_g_2p_f:
      and 12
      ret z
put_pb_giver:
   ld A,pb_giver
   ld (ftp_type),A
     ld B,140
    CALL_(get_rand)
    and 63
    ld C,A
      CALL_(get_rand)
      and 31
      add A,60
      ld E,A
    ld D,0
   ld (ftp_data),DE
       ld HL,90
       ld A,(temp_gun_power)
       cp 0
       jr z,p_pb_g_h
       ld HL,160
       cp 1
       jr z,p_pb_g_h
       ld HL,230
p_pb_g_h:
       ld (ftp_health),HL
   JUMP_(put_foe)


drawings:
   
   ROM_CALL(CLEARLCD)

   ld DE,0
   ld (scroll_y),DE
 ld A,(scroll_type)
 and 3
 JUMP_Z(no_scroll)
  ld A,(player_num)
  or A
  jr nz,calc_scroll_p2
  ld A,(player_health)
  or A
  JUMP_Z(no_scroll)
  ld BC,(player_y)
  ld A,42 ; x_center if 1 player
  jr calc_scroll
calc_scroll_p2:
   ld A,(player_health+npd)
   ld HL,player_health+npd+npd
   or (HL)
   jr z,no_scroll
 ld BC,(player_y+npd)
 ld A,(player_health+npd+npd)
 or A
 ld A,42 ; x_center if player 2 dead
 jr z,calc_scroll
  ld BC,(player_y+npd+npd)
  ld A,(player_health+npd)
  or A
  ld A,42 ; x_center if player 1 dead
  jr z,calc_scroll
     ld A,(player_x+npd)
     ld HL,player_x+npd+npd
     add A,(HL)
     res 0,A ;
     rrca    ; divide A by two
     ld B,A
     ld A,(player_y+npd)
     ld HL,player_y+npd+npd
     add A,(HL)
     res 0,A ;
     rrca    ; divide A by two
     ld C,A
     ld A,64 ; x_center if two players alive
calc_scroll:
     sub B
     ld B,A
      ld A,32
      sub C
      ld C,A
 ld A,(scroll_type)
 bit 0,A
 jr nz,yes_x_scroll
 ld B,0
yes_x_scroll:
  ld A,(scroll_type)
  bit 1,A
  jr nz,yes_y_scroll
  ld C,0
yes_y_scroll:
    ld (scroll_y),BC
 ld A,(player_x)
 add A,B
 ld (player_x),A
 ld A,(player_y)
 add A,C
 ld (player_y),A
  ld A,(player_x+npd)
  add A,B
  ld (player_x+npd),A
  ld A,(player_y+npd)
  add A,C
  ld (player_y+npd),A
   ld A,(player_x+npd+npd)
   add A,B
   ld (player_x+npd+npd),A
   ld A,(player_y+npd+npd)
   add A,C
   ld (player_y+npd+npd),A
no_scroll:



   CALL_(draw_player012)

   ld A,1
draw_loop:
   ld (foe_num),A
   CALL_(draw_all)
   ld A,(foe_num)
   inc A
   cp 251   ; last thing +1
   jr nz,draw_loop
  CALL_(draw_status)
  ret                ; fin drawings



draw_all:
   ld D,0
   ld E,A
   ld HL,foe_type
   ADD HL,DE
   ld (foe_addr),HL
   ld A,(HL)
   or A
   ret Z

    push HL
   ld HL,foe_x
   ADD HL,DE
   ld A,(scroll_x)
   add A,(HL)
   ld (HL),A
   ld B,A
   ld HL,foe_y
   add HL,DE
   ld A,(scroll_y)
   add A,(HL)
   ld (HL),A
   ld C,A
    pop HL
    ld A,(HL)

   cp laser
   JUMP_Z(draw_p_laser)
     cp foe_laser
     JUMP_Z(draw_p_laser)
   cp asteroid1
   JUMP_Z(draw_asteroid1)
   cp asteroid2
   JUMP_Z(draw_asteroid2)
   cp asteroid3
   JUMP_Z(draw_asteroid3)
   cp asteroid4
   JUMP_Z(draw_asteroid4)
   cp dust
   JUMP_Z(NOIRCIR)
   cp saucer1
   JUMP_Z(draw_saucer1)
   cp inter1
   JUMP_Z(draw_inter1)
   cp inter2
   JUMP_Z(draw_inter2)
   cp duck
   JUMP_Z(draw_duck)
   cp bee
   JUMP_Z(draw_bee)
   cp pb_giver
   JUMP_Z(draw_pb_giver)
   cp saucer_boss
   JUMP_Z(draw_saucer_boss)
   cp hunter
   JUMP_Z(draw_hunter)
   cp turret
   JUMP_Z(draw_turret)
   cp torp
   JUMP_Z(draw_torp)
   cp bullet
   JUMP_Z(NOIRCIR)
   cp ball
   JUMP_Z(draw_ball)
   cp mine
   JUMP_Z(draw_mine)
   cp h_bonus
   JUMP_Z(draw_h_bonus)
   cp e_bonus
   JUMP_Z(draw_e_bonus)
   cp p_bonus
   JUMP_Z(draw_p_bonus)
   cp o_bonus
   JUMP_Z(draw_o_bonus)
   cp torp_bonus
   JUMP_Z(draw_torp_bonus)
   cp onde
   JUMP_Z(draw_onde)
   cp homing
   JUMP_Z(draw_homing)
   cp arc
   JUMP_Z(draw_arc)
   cp spec2
   JUMP_Z(draw_spec2)
   cp fmd_laser
   JUMP_Z(draw_fmd_laser)
   cp laser_boum
   JUMP_Z(draw_laser_boum)
   cp bullet_boum
   JUMP_Z(draw_bullet_b)
   cp dots8
   JUMP_Z(draw_dots8)
   cp star1
   JUMP_Z(draw_star1)
   cp star1_plein
   JUMP_Z(draw_star1_plein)
   cp star2
   JUMP_Z(draw_star2)
   cp star3
   JUMP_Z(draw_star3)
   cp star3b
   JUMP_Z(draw_star3b)
   cp star4
   JUMP_Z(draw_star4)
   cp star4b
   JUMP_Z(draw_star4b)
   cp star5
   JUMP_Z(draw_star5)
   cp star5b
   JUMP_Z(draw_star5b)
   cp bigstar
   JUMP_Z(draw_bigstar)
   cp quasar1
   JUMP_Z(draw_quasar1)
   cp quasar2
   JUMP_Z(draw_quasar2)
   cp quasar3
   JUMP_Z(draw_quasar3)
   cp quasar4
   JUMP_Z(draw_quasar4)
   cp quasar5
   JUMP_Z(draw_quasar5)
   cp quasar6
   JUMP_Z(draw_quasar6)
   cp quasar5b
   JUMP_Z(draw_quasar5b)
   cp beam
   JUMP_Z(draw_beam)
   cp bb_gun
   JUMP_Z(draw_bb_gun)
   cp bbg_shot
   JUMP_Z(draw_bbg_shot)
   cp bb1
   JUMP_Z(draw_bb1)
   cp bb2
   JUMP_Z(draw_bb2)
   cp bb_rear
   JUMP_Z(draw_bb_rear)
   JUMP_(find_bug)     ; if unknown foe
   ret



draw_status:



   ld A,(niv_time+1)
   cp 0
   jr nz,no_disp_new_niv
   ld A,(niv_time)
   cp 22
   jr nc,no_disp_new_niv
   ld BC,$1530         ; $30=48=x   $15=21=y a partir du haut
   ld (CURSOR_X),BC
   ld HL,text_niv
   ld DE,(PROGRAM_ADDR)
   add HL,DE
   ld B,6
   ROM_CALL(D_LM_STR)  ; display in menu style a string of address HL, of length B
   ld A,71
   ld (CURSOR_X),A
   ld A,(num_niv)
   cp 100                  ; so it doesn't show level 100,101,102,103,104,..
   jr c,no_m100_disp_niv ;
   sub 100                ;
no_m100_disp_niv:         ;
   CALL_(disp_menu_num)
no_disp_new_niv:



   ld A,(c_message)
   or A
   jr z,no_message
    ld HL,(message_addr)
    ld DE,(PROGRAM_ADDR)
    add HL,DE
    ld C,(HL)
    inc HL
    ld B,(HL)
    inc HL
    ld (CURSOR_X),BC
next_mess_line:
    push BC
    ROM_CALL(D_ZM_STR)  ; Display Zero terminated STRing in Menu style
    pop BC
    ld A,(HL)
    cp 1
    jr nz,no_message
    inc HL
    ld A,B
    add A,8
    ld B,A
    ld (CURSOR_X),BC
    jr next_mess_line
no_message:



   ld A,(num_niv)
   cp 2
   jr nz,no_status_niv2
   ld HL,c_niv
   ld A,20
   sub (HL)
   ld BC,0         ; pour afficher en haut a gauche
   ld (CURSOR_X),BC
   CALL_(disp_menu_num)
no_status_niv2:


   ld A,(num_niv)
   cp 3
   jr nz,no_status_niv3
   ld HL,c_niv
   ld A,10
   sub (HL)
   ld BC,$3300         ; pour afficher en bas a gauche
   ld (CURSOR_X),BC
   CALL_(disp_menu_num)
no_status_niv3:


   ld A,(error_byte)
   bit 1,A
   jr z,no_disp_mf
    ld B,48
d_m_f_l:              ; Display "Memory Full" Loop
    ld HL,$0403        ; pour afficher a colonne=x=4 ligne=y=3
    ld (CURSOR_ROW),HL
    ld HL,(PROGRAM_ADDR)
    ld DE,text_mem_full
    add HL,DE             ; hl is now the address of what to print
    ROM_CALL(D_ZT_STR)    ; Display Zero terminated Text STRing
    djnz d_m_f_l
no_disp_mf:
   ld A,(error_byte)
   bit 0,A
   jr z,no_disp_bug
    ld B,48
d_b_l:                ; Display "Bug" Loop
    ld HL,$0403        ; pour afficher a colonne=x=4 ligne=y=3
    ld (CURSOR_ROW),HL
    ld HL,(PROGRAM_ADDR)
    ld DE,text_bug
    add HL,DE
    ROM_CALL(D_ZT_STR)
    djnz d_b_l
no_disp_bug:
    ld A,0
    ld (error_byte),A


  ld A,(player_num)
  or A
  JUMP_Z(draw_status_p0)
  JUMP_(draw_status_p12)

draw_status_p0:
  ld C,2
  CALL_(draw_status_heal)
  ld BC,$0202
  CALL_(draw_status_torp)
  ld HL,$152C         ; $2C=44=x   $15=21=y a partir du haut
  JUMP_(draw_status_over)


draw_status_p12:
  ld C,2
  ld A,(player_health+npd)
  ld (player_health),A
  CALL_(draw_status_heal)
  ld BC,$0202
  ld A,(n_torp+npd)
  ld (n_torp),A
  CALL_(draw_status_torp)
  ld HL,$392C         ; $2C=44=x   $39=57=y a partir du haut
  CALL_(draw_status_over)

  ld C,60
  ld A,(player_health+npd+npd)
  ld (player_health),A
  CALL_(draw_status_heal)
  ld BC,$4E38              ; $4E=78=x    $38=56=y a partir du bas
  ld A,(n_torp+npd+npd)
  ld (n_torp),A
  CALL_(draw_status_torp)
  ld HL,$002C         ; $2C=44=x   $00=00=y a partir du haut
  JUMP_(draw_status_over)


draw_status_torp:
; debut dessine torp en reserve
   ld A,(n_torp)
   ld E,0
d_t_bar_l:
   ld A,(n_torp)
   cp E
   jr z,end_t_bar
  push DE
   noir
   inc C
   noir
   inc C
   noir
   inc B
   noir
   dec C
   noir
   dec C
   noir
   inc B
   inc B
   inc B
   inc E
  pop DE
   inc E
   jr d_t_bar_l
end_t_bar:
; fin dessine torp en reserve
  ret


draw_status_heal:
;debut dessine barre de sante
   ld A,(player_health)
   sra A                ; divide A by two
   add A,75+2
   ld B,A
d_h_bar_l:
   ld A,B
   cp 76+2         ; 76 and not 75 so it doesn't draw if health=0
   jr c,end_h_bar
   noir
   inc C
   noir
   dec C
   dec B
   jr d_h_bar_l
end_h_bar:
;fin dessine barre de sante
   ret


draw_status_over:       ; at position HL
   ld A,(player_health)
   or A
   ret nz
   ld (CURSOR_X),HL
   ld HL,(PROGRAM_ADDR)
   ld DE,text_game_over
   add HL,DE
   ROM_CALL(D_ZM_STR)  ; Display Zero terminated STRing in Menu style
   ret


draw_player012:
  ld A,(player_num)
  or A
  JUMP_Z(draw_player)
  ld HL,player_data+npd
  ld DE,player_data
  ld BC,npd
  ldir
  CALL_(draw_player)
  ld HL,player_data+npd+npd
  ld DE,player_data
  ld BC,npd
  ldir
  JUMP_(draw_player_noir)



draw_player_noir
   CALL_(draw_player)
  ld BC,(player_y)
    ld A,B
    add A,5
    ld B,A
      ld A,(game_done)
      and 3
      cp 2
      JUMP_Z(draw_p_n_ship3)
      cp 3
      JUMP_Z(draw_p_n_ship4)
  noir
  dec B
  noir
  dec B
  blanc
  dec B
  blanc
  dec B
  noir
  dec B
  noir
  dec B
  noir
  dec B
  noir
  ld E,1
  snoir
  dec B
  snoir
  ld E,2
  snoir
  noir
  dec B
  noir
  ld E,1
  snoir
    ld A,(game_done)
    and 3
    cp 1
    ret nz
  dec B
  noir
  inc B
  ld E,5
  snoir
  dec E
  snoir
  dec E
  snoir
  dec E
  snoir
  dec B
  ld E,1
  snoir
  ret

draw_p_n_ship3:
   dec B
   noir
   dec B
   noir
   dec B
   noir
   ld E,1
   snoir
   dec B
   blanc
   ld E,1
   snoir
   dec B
   blanc
   inc C
   blanc
   dec C
   dec C
   blanc
   inc C
   ld E,2
   snoir
   dec B
   snoir
   ld E,3
   snoir
   ld E,1
   snoir
   blanc
   dec B
   noir
   ld E,2
   snoir
   ld E,1
   snoir
   dec B
   noir
   ret


draw_p_n_ship4:
  ld A,(player_x)
  add A,3
  ld B,A
  noir
  inc B
  ;;blanc
  inc B
  blanc
  inc B
  noir
  ld A,B
  sub 7
  ld B,A
  noir
  dec B
  noir
  ld E,1
  snoir
  dec B
  snoir
  inc E
  snoir
  noir
  dec B
  noir
  ld E,1
  snoir
  inc E
  snoir
  dec B
  snoir
  dec E
  snoir
  noir
  dec B
  noir
  ret


draw_player:
  ld BC,(player_y)

   ld A,(c_bubble)
   or A
   jr z,after_draw_bub
   cp 12
   JUMP_NC(draw_bubble1)
   bit 1,A
   JUMP_Z(draw_bubble2)
   JUMP_(draw_bubble3)
after_draw_bub:

  ld A,(player_bits)
  bit 0,A
  JUMP_NZ(draw_ugly_player)

  ld A,(game_done)
  and 3
  cp 1
  JUMP_Z(draw_p_ship2)
  cp 2
  JUMP_Z(draw_p_ship3)
  cp 3
  JUMP_Z(draw_p_ship4)

  inc B
  inc B
  noir
  inc B
  noir
  inc B
  inc B
  noir
  dec B
  ld E,1
  snoir
  dec B
  snoir
  dec B
  snoir
  dec B
  snoir
  dec B
  snoir
  dec B
  snoir
  dec B
  inc E
  snoir
  dec B
  inc E
  snoir
  inc B
  snoir
  inc B
  snoir
  inc B
  snoir
  inc B
  snoir
  inc B
  snoir    ; pointe gun
  
  ld A,(player_x)
  sub 4
  ld B,A
  ld E,1
  snoir   ; noicir le blanc engine2

  JUMP_(draw_player_rear)



draw_p_ship2:
   ld A,B
   add A,6
   ld B,A
   noir
   dec B
   ld E,1
   snoir
   dec B
   snoir
   dec B
   snoir
   noir
   dec B
   noir
   ld E,1
   snoir
   dec B
   snoir
   dec B
   snoir
   ld E,3
   snoir
   dec B
   snoir
   ld E,1
   snoir
   ld E,6
   snoir
   dec B
   ld E,2
   snoir
   ld E,3
   snoir
   ld E,6
   snoir
   dec B
   snoir
   dec E
   snoir
   dec E
   snoir
   dec E
   snoir
   dec B
   ld E,6
   snoir
   dec B
   dec E
   snoir
   dec E
   snoir
   dec E
   snoir
   JUMP_(draw_player_rear)





draw_p_ship3:
   ld A,(player_x)
   add A,5
   ld B,A
   noir
   dec B
   ld E,1
   snoir
   dec B
   snoir
   ld E,2
   dec B
   snoir
   dec B
   snoir
   noir
   dec B
   noir
   ld E,1
   snoir
   dec B
   snoir
   inc B
   ld E,3
   snoir
   ld E,4
     ld A,(game_done)
     and 12
     jr nz,draw_p_ship3_ng
     ld E,4
     snoir
     inc B
     snoir
     inc B
     snoir
     dec B
     dec B
draw_p_ship3_ng:
   dec B
   snoir
   dec B
   snoir
   dec E
   snoir
   dec B
   ld E,1
   snoir
   JUMP_(draw_player_rear)


draw_p_ship4:
   noir
   ld E,2
   snoir
   inc B
   snoir
   noir
   inc B
   noir
   inc B
   ld E,1
   snoir
   inc B
   snoir
   noir
   inc B
   noir
   ld E,1
   snoir
   inc B
   snoir
   inc B
   noir
   ld A,B
   sub 8
   ld B,A
   ld E,1
   snoir
   inc E
   snoir
   dec B
   snoir
   dec B
   inc E
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   ld E,1
   snoir
   JUMP_(draw_player_rear)


draw_player_rear:
   ld E,2
   snoir
   ld A,(engine)
   cp 1
   JUMP_Z(draw_engine1)
   cp 2
   JUMP_Z(draw_engine2)
   cp 3
   JUMP_Z(draw_engine3)
   ld E,1
   snoir
   noir
   ld A,3
   ld (engine),A
   ret

key_for_flame:
 pop HL                ; so it return further
    ld A,(global_time)
    bit 0,A
    ret z              ; retour 1 fois sur 2

   ;;;;ld A,254  ; masks all but arrows
   ;;;;out (1),A
   ;;;;in A,(1)
       ld A,(player_flame)
    bit 1,A  ; is player going backward ?
    ret z
 push HL
     ld E,A  ; save A
     and 9   ; only bit 0 (down) and 3 (up) remain
     ld A,E  ; restore A
     ret nz  ; continue if up and down are pressed in the same time
     or 9    ; so it will believe that up and down aren't pressed
     ret

draw_engine1:
   ld E,1
   snoir
   dec B
   noir
     dec B
     dec B
    CALL_(key_for_flame)
    bit 3,A                   ; is player going up ?
    JUMP_Z(player_flame2)
    bit 0,A                   ; is player going down ?
    JUMP_Z(player_flame3)
    bit 2,A                   ; is player going forward ?
    JUMP_Z(player_flame1)
    ret





draw_engine2:
   noir
   ld E,1
   dec B
   snoir
     dec B
     dec B
    CALL_(key_for_flame)
    bit 2,A                   ; is player going forward ?
    JUMP_Z(player_e2_flame1)
    bit 0,A                   ; is player going down ?
    JUMP_Z(player_e2_flame3)
    bit 3,A                   ; is player going up ?
    JUMP_Z(player_e2_flame2)
    ret




player_e2_flame1:
   push BC
   inc C
   CALL_(player_flame1)
   pop BC
   dec C
   JUMP_(player_flame1)


player_e2_flame2:
   push BC
   inc C
   inc C
   CALL_(player_flame2)
   pop BC
   dec C
   dec C
   JUMP_(player_flame2)

player_e2_flame3:
   push BC
   inc C
   inc C
   CALL_(player_flame3)
   pop BC
   dec C
   dec C
   JUMP_(player_flame3)



draw_engine3:
   ld E,1
   snoir
   ld E,2
   dec B
   snoir
   noir
     dec B
     dec B
    CALL_(key_for_flame)
    bit 2,A                   ; is player going forward ?
    JUMP_Z(player_e3_flame1)
    bit 3,A                   ; is player going up ?
    JUMP_Z(player_e3_flame2)
    bit 0,A                   ; is player going down ?
    JUMP_Z(player_e3_flame3)
    ret


player_e3_flame1:
     push BC
     CALL_(player_flame1)
     pop BC
   push BC
   inc C
   inc C
   CALL_(player_flame1)
   pop BC
     dec C
     dec C
     JUMP_(player_flame1)


player_e3_flame2:
  dec C
  noir
  dec B
  noir
  inc C
  noir
  dec B
  noir
  inc C
  noir
  dec B
  noir
  dec C
  dec B
  noir
  dec C
  dec B
  noir
  dec C
  dec B
  noir
  inc B
  inc B
  inc C
  noir
  inc B
  noir
  dec C
  noir
  dec C
  dec B
  noir
  dec C
  dec B
  noir
  inc B
  inc B
  dec C
  noir
  inc B
  inc C
  noir
  inc C
  noir
  inc B
  noir
  inc B
  inc C
  noir
  dec B
  dec B
  noir
  ret


player_e3_flame3:
  inc C
  noir
  dec B
  noir
  dec C
  noir
  dec B
  noir
  dec C
  noir
  dec B
  noir
  inc C
  dec B
  noir
  inc C
  dec B
  noir
  inc C
  dec B
  noir
  inc B
  inc B
  dec C
  noir
  inc B
  noir
  inc C
  noir
  inc C
  dec B
  noir
  inc C
  dec B
  noir
  inc B
  inc B
  inc C
  noir
  inc B
  dec C
  noir
  dec C
  noir
  inc B
  noir
  inc B
  dec C
  noir
  dec B
  dec B
  noir
  ret


player_flame1:
  noir
  dec B
  inc C
  noir
  dec B
  noir
  dec B
  dec C
  noir
  dec B
  noir
  dec B
  noir
  inc B
  inc B
  inc B
  dec C
  noir
  inc B
  noir
  ret



player_flame2:
  noir
  dec B
  noir
  dec B
  dec C
  noir
  dec C
  noir
  dec B
  dec C
  noir
  inc B
  inc C
  inc B
  noir
  inc B
  inc C
  noir
  ret


player_flame3:
  noir
  dec B
  noir
  dec B
  inc C
  noir
  inc C
  noir
  dec B
  inc C
  noir
  inc B
  dec C
  inc B
  noir
  inc B
  dec C
  noir
  ret









draw_ugly_player
   dec B
   dec B
  dec B
  noir
  dec C
  noir
  inc B
  noir
  inc C
  noir
  inc B
  noir
  dec C
  noir
  inc B
  noir
  inc C
  noir
  inc B
  noir
  dec C
  noir
  inc B
  noir
  inc C
  noir
  inc B
  noir
  dec C
  noir
  dec C
  dec C
  dec B
  noir
  dec B
  noir
  dec B
  noir
  dec B
  noir
  dec B
  noir
  inc C
  noir
  inc B
  noir
  inc C
  inc C
  inc C
  noir
  dec B
  noir
  inc C
  noir
  inc B
  noir
  inc B
  noir
  inc B
  noir
  inc B
  noir
  ret     ;  fin draw_player



draw_p_laser:
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   ret   ; fin draw_p_laser


draw_laser_boum:
   CALL_(draw_p_laser)
   ld A,B
   add A,10
   ld B,A
   CALL_(draw_star1_plein)
   ld HL,(foe_addr)
   ld (HL),star1_plein
   ret

draw_onde:
   noir
   dec B
   inc C
   noir
   dec B
   noir
   dec B
   dec C
   noir
   dec B
   dec C
   noir
   dec B
   noir
   inc C
   dec B
   noir
   ret


draw_beam:
  noir
  dec C
  noir
  inc B
  inc B
  noir
  inc C
  noir
  inc B
  inc B          ; first two ones are drawn withouth checking if pixel on (because of bubble)
draw_beam_loop:
  CALL_(SAVOIR)
  jr nz,fin_draw_beam
  noir
  dec C
  CALL_(SAVOIR)
  jr nz,fin_draw_beam
  noir
  inc B
  CALL_(SAVOIR)
  jr nz,fin_draw_beam
  inc C
  CALL_(SAVOIR)
  jr nz,fin_draw_beam
  inc B
  ld A,B
  cp 128
  jr nc,fin_draw_beam
  jr draw_beam_loop
fin_draw_beam:
  ld HL,(foe_addr)
  ld DE,250
  add HL,DE
  ld A,B
  add A,4    ; so it goes further than it appears
  ld (HL),A  ; store new x poisition
  ret



draw_mine:
  ld A,(player_bits)
  bit 0,A
  JUMP_NZ(draw_ugly_mine)
  ld A,(niv_time)
  bit 1,A
  CALL_Z(NOIRCIR)     ; 2 fois sur 4
  ld DE,$0102
  enoir
  ld A,(niv_time)
  bit 2,A
  ret z               ; 4 fois sur 8
  ld DE,$0101
  fnoir
  ret

draw_ugly_mine:
   noir
   ld DE,1
   fnoir
   inc D
   fnoir
   ld DE,2
   fnoir
   ld A,(niv_time)
   bit 2,A
   ret z
   ld DE,3
   fnoir
   ret



draw_bullet_b:
   ld DE,$0202
   fnoir
   ld DE,$0101
   fnoir
   ld HL,(foe_addr)
   ld (HL),0
   ret


draw_torp:
  ld A,(player_bits)
  bit 0,A
  JUMP_NZ(draw_ugly_torp)
  noir
  inc B
  noir
  inc B
  noir
  dec B
  dec B
  inc C
  noir
  dec B
  noir
  dec B
  noir
  dec C
  inc B
  noir
  dec C
  dec B
  noir
  inc B
  noir
  inc B
  noir
  ret

draw_ugly_torp:
  noir
  inc B
  noir
  dec C
  noir
  dec B
  noir
  dec B
  noir
  inc C
  noir
  ret


draw_spec2:
  noir
  inc C
  noir
  dec B
  dec C
  noir
  dec B
  noir
  dec C
  inc B
  noir
  dec C
  noir
  inc B
  inc C
  noir
  inc B
  noir
  ret

draw_arc:
     ld BC,(scroll_y)
     ld HL,(foe_addr)
     ld DE,250
     add HL,DE
     ld A,(HL)
     sub B
     ld (HL),A
     ld B,A
     add HL,DE
     ld A,(HL)
     sub C
     ld (HL),A
     ld C,A
   ld A,B
   and 3
   cp 0
   CALL_Z(draw_arc_DE_0)
   cp 1
   CALL_Z(draw_arc_DE_1)
   cp 2
   CALL_Z(draw_arc_DE_2)
   cp 3
   CALL_Z(draw_arc_DE_3)
   ld (souv_arc_DE),DE
     ld A,B
     and 252
     dec A
     dec A
     ld B,A
      ld A,C
      ld H,A
      and 252
      dec C
      dec C
      ld C,A
   ld A,H
   and 3
   cp 0
   JUMP_Z(draw_arc0)
   cp 1
   JUMP_Z(draw_arc1)
   cp 2
   JUMP_Z(draw_arc2)
   cp 3
   JUMP_Z(draw_arc3)
   ret

draw_arc_DE_0:
  ld DE,$0100
  ret

draw_arc_DE_1:
  ld DE,$0001
  ret

draw_arc_DE_2:
  ld DE,$FF00
  ret

draw_arc_DE_3:
  ld DE,$00FF
  ret


draw_arc0:
    push BC
  noir
  CALL_(draw_arc_inc_y)
  noir
  CALL_(draw_arc_inc_y)
  CALL_(draw_arc_dec_x)
  noir
    pop BC
  CALL_(draw_arc_dec_y)
  noir
  CALL_(draw_arc_dec_y)
  CALL_(draw_arc_dec_x)
  noir
  ret

draw_arc1:
    push BC
  noir
  CALL_(draw_arc_dec_y)
  noir
  CALL_(draw_arc_dec_y)
  noir
    pop BC
  CALL_(draw_arc_inc_y)
  CALL_(draw_arc_dec_x)
  noir
  CALL_(draw_arc_inc_y)
  CALL_(draw_arc_dec_x)
  noir
  ret

draw_arc2:
   push BC
  noir
  CALL_(draw_arc_inc_y)
  CALL_(draw_arc_dec_x)
  noir
  CALL_(draw_arc_dec_x)
  noir
    pop BC
  CALL_(draw_arc_dec_y)
  CALL_(draw_arc_inc_x)
  noir
  CALL_(draw_arc_dec_y)
  noir
  ret

draw_arc3:
    push BC
  noir
  CALL_(draw_arc_dec_x)
  noir
  CALL_(draw_arc_dec_x)
  noir
    pop BC
  CALL_(draw_arc_inc_x)
  CALL_(draw_arc_dec_y)
  noir
  CALL_(draw_arc_inc_x)
  CALL_(draw_arc_dec_y)
  noir
  ret


draw_arc_inc_x:
  ld DE,(souv_arc_DE)
  ld A,B
  add A,D
  ld B,A
  ld A,C
  add A,E
  ld C,A
  ret
  
draw_arc_dec_x:
  ld DE,(souv_arc_DE)
  ld A,B
  sub D
  ld B,A
  ld A,C
  sub E
  ld C,A
  ret

draw_arc_inc_y:
  ld DE,(souv_arc_DE)
  ld A,C
  add A,D
  ld C,A
  ld A,B
  sub E
  ld B,A
  ret

draw_arc_dec_y:
  ld DE,(souv_arc_DE)
  ld A,C
  sub D
  ld C,A
  ld A,B
  add A,E
  ld B,A
  ret


draw_h_bonus:
   noir
   dec B
   noir
   inc C
   noir
   inc C
   noir
   dec C
   dec C
   dec C
   noir
   dec C
   noir
   inc C
   inc C
   inc B
   inc B
   noir
   inc B
   noir
   inc C
   noir
   inc C
   noir
   dec C
   dec C
   dec C
   noir
   dec C
   noir
   ret


draw_e_bonus:
   inc B
   noir
   dec B
   noir
   dec B
   noir
   ld E,1
   snoir
   inc E
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   ret


draw_p_bonus:
   push BC
  noir
  inc B
  noir
  inc B
  inc C
  noir
  inc C
  dec B
  noir
  dec B
  noir
    pop BC
  dec B
  noir
  ld E,1
  snoir
  inc E
  snoir
  ret


draw_o_bonus:
  ld E,1
  snoir
  ld E,2
  dec B
  snoir
  dec B
  ld E,1
  snoir
  noir
  inc B
  inc B
  inc B
  ld E,2
  snoir
  inc B
  ld E,1
  snoir
  noir
  ret

draw_torp_bonus:
  noir
  inc C
  noir
  dec B
  dec C
  noir
  dec C
  noir
  inc B
  noir
  dec C
  noir
  inc C
  inc B
  noir
  inc C
  noir
  ret

draw_asteroid1:
   inc C
   noir
   inc C
   dec B
   noir
   dec B
   noir
   dec B
   dec C
   noir
   dec B
   dec C
   noir
   dec C
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   dec B
   inc C
   noir
   inc B
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   noir
   dec B
   dec C
   noir
   ret    ; fin draw_asteroid1


draw_asteroid2:
   inc C
   inc C
   noir
   dec B
   noir
   dec B
   noir
   dec C
   dec B
   noir
   dec B
   dec C
   noir
   inc B
   dec C
   noir
   dec B
   dec C
   noir
   inc B
   dec C
   noir
   dec B
   inc C
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   inc C
   noir
   inc B
   dec C
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   noir
   ret     ; fin draw_asteroid2

draw_asteroid3
   inc B
   inc C
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   dec C
   noir
   dec B
   noir
   dec C
   noir
   dec B
   dec C
   noir
   inc B
   dec C
   noir
   dec B
   dec C
   noir
   dec C
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   inc C
   noir
   inc B
   dec C
   noir
   dec C
   noir
   inc B
   noir
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   inc C
   noir
   dec B
   inc C
   noir
   inc C
   noir
   dec B
   inc C
   noir
   ret    ; fin draw_asteroid3


draw_asteroid4:
   dec B
   dec C
   dec C
   noir
   dec C
   noir
   inc B
   dec C
   noir
   inc B
   inc C
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc C
   noir
   inc B
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   inc C
   noir
   inc C
   noir
   inc C
   noir
   dec B
   inc C
   noir
   inc C
   noir
   dec B
   inc C
   noir
   dec B
   dec C
   noir
   dec B
   dec C
   noir
   dec B
   noir
   dec B
   inc C
   noir
   dec B
   noir
   dec B
   dec C
   noir
   dec C
   noir
   dec B
   dec C
   noir
   dec B
   dec C
   noir
   inc B
   dec C
   noir
   inc B
   noir
   inc B
   noir
   inc B
   inc C
   noir
   ret       ; fin draw_asteroid4


draw_dots8:
   inc B
   inc B
   inc B
   noir
   dec B
   inc C
   inc C
   noir
   dec B
   dec B
   inc C
   noir
   dec B
   dec B
   dec C
   noir
   dec B
   dec C
   dec C
   noir
   inc B
   dec C
   dec C
   noir
   inc B
   inc B
   dec C
   noir
   inc B
   inc B
   inc C
   noir
   inc B
   inc C
   inc C
   noir
   ld HL,(foe_addr)
   ld (HL),0        ; efface les dots8 apres avoir affiche
   ret              ; fin draw_dots8


draw_star1:
   inc B
   inc C
   noir
   inc B
   inc C
   noir
   dec B
   dec B
   noir
   inc C
   noir
   dec B
   dec C
   dec C
   noir
   dec B
   inc C
   noir
   dec C
   dec C
   noir
   dec B
   noir     ; pointe gauche
   inc B
   inc B
   dec C
   noir
   dec B
   dec C
   noir
   inc B
   inc B
   noir
   dec C
   noir
   inc B
   inc C
   inc C
   noir
   inc B
   dec C
   noir
   inc C
   inc C
   noir
   inc B
   noir
   ld HL,(foe_addr)
   ld (HL),dots8
   ret             ; fin draw_star1


draw_star1_plein:
   noir
   inc C
   noir
   dec C
   dec C
   noir
   inc C
   dec B
   noir
   inc B
   inc B
   noir
   dec B
   CALL_(draw_star1)
   ld HL,(foe_addr)
   ld (HL),star1
   ret               ; fin draw_star1_plein

draw_star2:
   inc C
   inc B
   inc C
   noir
   inc B
   inc C  ; pointe haut droite
   dec B
   dec C
   noir
   dec B
   inc C
   noir
   inc C
   noir  ; pointe haut
   dec B
   dec C
   dec C
   noir
   dec B
   noir
   dec B
   inc C
   noir  ; pointe haut gauche
   inc B
   dec C
   dec C
   noir
   dec B
   dec C
   noir
   dec B
   noir  ; pointe gauche
   inc B
   inc B
   dec C
   noir
   dec C
   noir
   dec B
   dec C
   noir
   inc B
   inc B
   inc C
   noir
   inc B
   dec C
   noir
   dec C
   noir  ; pointe bas
   inc B
   inc C
   inc C
   noir
   inc B
   noir
   inc B
   dec C
   noir  ; pointe bas droite
   dec B
   inc C
   inc C
   noir
   inc B
   inc C
   noir
   inc B
   noir  ; pointe droite
   dec B
   dec B
   inc C
   noir
   inc C
   noir
   inc B
   inc C
   noir
   ld HL,(foe_addr)
   ld (HL),star1_plein
   ret                  ; fin draw_star2

draw_base_star:
   ld DE,0
   inc D
   inc E
   inc E
   enoir
   inc E
   enoir
   inc D
   enoir
   inc D
   inc E
   enoir
   inc D
   enoir
   inc D
   inc E
   ret    ; fin draw_base_star

draw_star3:
   CALL_(draw_base_star)
   ld DE,$0400
   enoir
   inc D
   enoir
   ld HL,(foe_addr)
   ld (HL),star2
   ret   ; fin draw_star3

draw_star4:
   CALL_(draw_base_star)
   ld DE,4
   inc D
   enoir
   dec D
   inc E
   enoir
   inc E
   enoir
   ld HL,(foe_addr)
   ld (HL),star3
   ret     ; fin draw_star4

draw_star5:
   CALL_(draw_base_star)
   enoir
   ld DE,$0401
   enoir
   dec E
   inc D
   enoir
   inc D
   enoir
   inc D
   enoir
   ld HL,(foe_addr)
   ld (HL),star4
   ret     ; fin draw_star5

draw_star3b
  CALL_(draw_star3)
  ld (HL),star4b
  ret

draw_star4b
  CALL_(draw_star4)
  ld (HL),star5b
  ret

draw_star5b
  CALL_(draw_star5)
  ld (HL),bigstar
  ret

draw_bigstar:
   ld DE,$0900
   enoir
   dec D
   enoir
   dec D
   enoir
   dec D
   inc E
   enoir
   dec D
   enoir
   dec D
   inc E
   enoir
   inc E
   enoir
   inc D
   inc E
   enoir
   inc E
   enoir
   inc D
   inc E
   enoir
   ld HL,(foe_addr)
   ld (HL),star5
   ret               ; fin draw_bigstar

draw_quasar1:
   ld DE,1
   fnoir
   inc E
   fnoir
   ld HL,(foe_addr)
   ld (HL),0
   ret               ; fin draw_quasar1

draw_quasar2:
   ld DE,3
   fnoir
   dec E
   fnoir
   dec E
   inc D
   fnoir
   ld HL,(foe_addr)
   ld (HL),quasar1
   ret               ; fin draw_quasar2

draw_quasar3:
   ld DE,$0201
   enoir
   inc D
   enoir
   inc D
   dec E
   enoir
   inc D
   enoir
   ld HL,(foe_addr)
   ld (HL),quasar2
   ret               ; fin draw_quasar3

draw_quasar4:
   ld DE,$0202
   enoir
   dec D
   inc E
   enoir
   inc E
   enoir
   dec D
   inc E
   enoir
   inc E
   enoir
   inc E
   enoir
   ld HL,(foe_addr)
   ld (HL),quasar3
   ret               ; fin draw_quasar4



draw_quasar5:
   ld DE,10
   fnoir
   dec E
   fnoir
   dec E
   fnoir
   dec E
   inc D
   enoir
   dec E
   enoir
   dec E
   enoir
   dec E
   inc D
   enoir
   dec E
   enoir
   ld HL,(foe_addr)
   ld (HL),quasar4
   ret               ; fin draw_quasar5


draw_quasar6:
   ld DE,12
   fnoir
   dec E
   fnoir
   dec E
   fnoir
   dec E
   fnoir
   dec E
   inc D
   enoir
   dec E
   enoir
   dec E
   enoir
   dec E
   inc D
   enoir
   dec E
   enoir
   dec E
   inc D
   fnoir
   ld HL,(foe_addr)
   ld (HL),quasar5
   ret               ; fin draw_quasar6

draw_quasar5b
  CALL_(draw_quasar5)
  ld (HL),quasar6
  ret

draw_spir1:
   noir
   ld DE,0
   inc E
   fnoir
   inc D
   inc E
   fnoir
   inc D
   fnoir
   inc D
   dec E
   fnoir
   ret

draw_spir2:
   noir
   ld DE,$0101
   fnoir
   inc D
   fnoir
   ld DE,3
   fnoir
   inc D
   fnoir
   ret

draw_bubble1:
   ld DE,$0700
   fnoir
   inc E
   enoir
   inc E
   enoir
   inc E
   dec D
   enoir
   inc E
   enoir
   inc E
   dec D
   fnoir
   JUMP_(after_draw_bub) ; fin draw_bubble1

draw_bubble2:
   ld DE,$0700
   fnoir
   ld DE,$0702
   enoir
   ld DE,$0604
   enoir
   ld DE,$0406
   fnoir
   JUMP_(after_draw_bub) ; fin draw_bubble2

draw_bubble3:
   ld DE,$0701
   enoir
   ld DE,$0603
   enoir
   ld DE,$0505
   fnoir
   JUMP_(after_draw_bub) ; fin draw_bubble3


draw_base_saucer:
   ld E,0
   ld A,B
   sub 8
   ld B,A
   noir
   inc B
   noir
   inc B
   noir
   inc B
   inc E
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir  ; fin du cockpit
   inc E
   inc B
   snoir
   inc E
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   inc E
   snoir
   inc E
   snoir
   inc E
   inc B
   snoir
   inc E
   snoir
   inc E
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   dec E
   inc B
   snoir
   inc B
   snoir
   dec E
   inc B
   snoir
   dec E
   inc B
   snoir
   dec E
   snoir
   dec E
   inc B
   snoir
   dec E
   snoir
   dec E
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir ; fin aile
   dec E
   dec E
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc E
   inc B
   snoir ; deuxieme point d'attache
   inc B
   dec E
   snoir
   inc B
   snoir
   inc B
   snoir
   dec E
   snoir
   dec B
   snoir
   dec E
   noir
   ret

draw_saucer1:
   CALL_(draw_base_saucer)
   ld A,(niv_time)
   and 1
   ret z
   inc B
   inc B
   inc B
   ld DE,(foe_num)
   ld HL,(foe_num)
   add HL,DE
   ld DE,foe_data
   add HL,DE
   ld E,(HL)
   inc HL
   ld D,(HL)
   ld A,D
   and 192
   cp 192
   JUMP_Z(draw_flame_d2)
   inc C
   inc C
   inc B
   CALL_(draw_flame_s1)
   dec C
   dec C
   dec C
   dec C
   CALL_(draw_flame_s1)
   ret


draw_base_inter:
   ld E,2
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   ld E,1
   snoir
   dec B
   snoir
   noir
   ld E,2
   snoir
   dec B
   snoir
   noir      ; noir modify DE
   ld E,2
   dec B
   snoir
   dec E
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   dec B
   noir
   dec B
   noir
   ret



draw_inter1:
   push BC
   inc B
   inc B
   inc B
   CALL_(draw_base_inter)
   dec B
   noir     ; pointe avant
   pop BC
   ld E,3
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
     ld E,2
     snoir
     ld E,5
   snoir
   inc B
   snoir
     ld E,2
     snoir
     ld E,6
   inc B
   snoir
     ld E,2
     snoir
     ld E,6
   inc B
   snoir
     ld E,2
     snoir
     ld E,6
   inc B
   snoir
     ld E,2
     snoir
     ld E,6
   inc B
   snoir
    dec E
    snoir
    dec E
    snoir
     ld E,2
     snoir
     ld E,5
   snoir
   dec E
   snoir
   dec E
   snoir
   dec E
   snoir
   inc B
   snoir
   inc B
   dec E
   snoir
   dec B
   noir
   ld A,(niv_time)
   bit 0,A
   ret z
   ld A,B
   add A,4
   ld B,A
   JUMP_(draw_flame_d1)
                        ; fin draw_inter1



draw_inter2:
   inc B
     push BC
     CALL_(draw_base_inter)
     pop BC
   inc B
   ld E,3
   snoir
   inc B
   snoir
     push BC
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   inc E
   snoir
     pop BC
   ld E,6
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   dec E
   inc B
   snoir
   dec E
   snoir
   dec E
   snoir
   inc B
   dec E
   snoir
   inc B
   dec E
   snoir
   dec B
   noir
    ld A,(niv_time)
    bit 0,A
    ret z
     ld A,B
     add A,4
     ld B,A
     JUMP_(draw_flame_d1)
                          ; fin draw_inter2


draw_duck:
   ld A,B
   sub 11
   ld B,A
   noir
   inc B
   ld E,1
   snoir
   inc B
   noir
   ld E,2
   snoir
   inc B
   noir
   ld E,1
   snoir
   ld E,3
   snoir
   inc B
   snoir
   ld E,1
   snoir
   noir
   inc B
   ld E,3
   snoir
   dec E
   snoir
   inc B
   dec E  ; debut pont
   snoir
   inc B
   snoir
   inc B
   inc E
   snoir
   inc B
   snoir
   inc B
   inc E
   snoir
   inc B
   snoir
   inc B
   inc E
   snoir
   inc B
   inc E
   snoir
   inc B
   inc E
   snoir  ; attache gun
   dec B
   snoir
   dec B
   snoir
   dec B
   snoir
   ld A,B
   add A,4
   ld B,A
   inc E
   snoir
   inc B
   inc E
   snoir
   inc B
   snoir
   inc B
   snoir ; bout arriere aile
   dec E
   snoir
   dec E
   snoir
   dec E
   snoir
   dec E
   snoir
   inc B
   dec E
   snoir
   inc B
   dec E
   snoir
   inc B
   snoir
   dec E
   snoir
   dec B
   snoir
   noir
   ld A,(niv_time)
   and 1
   ret z
   inc B
   inc B
   inc B
   push BC
   inc C
   inc C
   CALL_(draw_flame_s4)
   pop BC
   dec C
   dec C
   CALL_(draw_flame_s4)
   ret                     ; fin draw_duck


draw_bee:
 push BC
   ld A,B
   sub 11
   ld B,A
   ld E,1
   snoir
   inc B
   snoir
   inc B
   snoir
   noir
   inc B
   ld E,2
   snoir
   inc B
   snoir
   noir
   inc B
   noir
   ld E,1
   snoir
   ld E,3
   snoir
   inc B
   snoir
   noir
   ld E,1
   snoir
   inc B
   snoir
   ld E,3
   snoir
   inc B
   snoir
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   dec E
   inc B
   snoir
   dec E
   snoir
   dec E
   inc B
   snoir
   dec E
   snoir
   inc B
   snoir
   dec E
   snoir
   dec B
   snoir
   noir
    CALL_(draw_t_2flame_s1)
 pop BC
   inc B
   inc B
   inc B
   ld HL,(foe_num)
   ld DE,(foe_num)
   add HL,DE
   ex DE,HL
   ld HL,foe_data
   add HL,DE
   inc HL
   ld A,(HL)
   cp 0
   ret z
   push BC
   dec C
   dec C
   push HL
   CALL_(draw_homing)
   pop HL
   pop BC
   ld A,(HL)
   cp 2
   ret nz
   inc C
   inc C
   JUMP_(draw_homing)
                        ; fin draw_bee


draw_pb_giver:
   ld E,1
   snoir
   ld E,3
   snoir
   dec B
   snoir
   ld E,1
   snoir
   noir
   dec B
   noir
   ld E,3
   snoir
   dec E
   dec B
   snoir
   dec B
   snoir
   dec E
   dec B
   snoir
   noir
   ld A,B
   add A,6
   ld B,A
   ld E,3
   snoir
   inc B
   snoir
   inc B
   snoir
   dec E
   snoir
   inc B
   snoir
   dec E
   dec B
   dec B
   snoir
   inc B
   noir
    ld A,(niv_time)
    bit 0,A
    ret z
     inc B
     inc B
     JUMP_(draw_flame_s1) 




draw_saucer_boss:
   push BC
   CALL_(draw_base_saucer)
   CALL_(draw_t_2flame_s1)
   pop BC
      push BC
       ld E,10
       ld A,B
       sub 6
       ld B,A
       snoir
       dec B
       snoir
       dec B
       snoir
      pop BC

  ld HL,(foe_num)
  ld DE,(foe_num)
  add HL,DE
  ld DE,foe_health
  add HL,DE
  inc HL
  ld A,(HL)
    sra A      ; divide A by two
    sra A      ; again
saucer_cracks:
  ld (souv_xy_cracks),BC
  cp 0
  JUMP_Z(saucer_crack8)
  cp 1
  JUMP_Z(saucer_crack7)
  cp 2
  JUMP_Z(saucer_crack6)
  cp 3
  JUMP_Z(saucer_crack5)
  cp 4
  JUMP_Z(saucer_crack4)
  cp 5
  JUMP_Z(saucer_crack3)
  cp 6
  JUMP_Z(saucer_crack2)
  cp 7
  JUMP_Z(saucer_crack1)
  ret

saucer_crack8:
  ld BC,(souv_xy_cracks)
   dec B
   noir
   inc C
   noir
saucer_crack7:
  ld BC,(souv_xy_cracks)
   ld A,C
   sub 7
   ld C,A
   inc B
   noir
   inc B
   noir
   inc B
   inc C
   noir
   inc B
   noir
saucer_crack6:
  ld BC,(souv_xy_cracks)
   ld A,C
   add A,5
   ld C,A
   dec B
   dec B
   noir
   inc C
   dec B
   noir
   inc C
   dec B
   noir
saucer_crack5:
   ld BC,(souv_xy_cracks)
    ld A,C
    sub 9
    ld C,A
    dec B
    noir
    dec C
    noir
saucer_crack4:
  ld BC,(souv_xy_cracks)
   inc B
   inc B
   noir
   dec C
   dec B
   noir
saucer_crack3:
  ld BC,(souv_xy_cracks)
   ld A,B
   add A,4
   ld B,A
   ld A,C
   add A,7
   ld C,A
   noir
   inc B
   inc C
   noir
saucer_crack2:
  ld BC,(souv_xy_cracks)
   ld A,B
   sub 4
   ld B,A
   ld A,C
   sub 6
   ld C,A
   noir
   dec B
   noir
   dec B
   dec C
   noir
saucer_crack1:
   ld BC,(souv_xy_cracks)
   ld A,C
   add A,7
   ld C,A
   noir
   inc C
   noir
   dec B
   inc C
   noir
   inc C
   noir

   ret    ; fin cracks



draw_turret:
  ld DE,$0202
  fnoir
  ld DE,3
  fnoir
  ld DE,$0103
  enoir
  ld (trigo_center_y),BC
  CALL_(get_data)
  ld A,D
  ld (trigo_angle),A
  ld A,4
  ld (trigo_dist),A
  CALL_(do_trigo)
  noir
  dec B
  noir
  dec C
  noir
  inc B
  noir
  ld A,6
  ld (trigo_dist),A
  CALL_(do_trigo)
  noir
  dec B
  noir
  dec C
  noir
  inc B
  noir
  ld A,8
  ld (trigo_dist),A
  CALL_(do_trigo)
  noir
  dec B
  noir
  dec C
  noir
  inc B
  noir
  ret

draw_fmd_laser:
   ld (trigo_center_y),BC
   CALL_(get_data)
   ld A,D
   ld (trigo_angle),A
   ld B,10
d_fmd_laser_l:
   push BC
   ld A,B
   ld (trigo_dist),A
   CALL_(do_trigo)
   noir
   pop BC
   djnz d_fmd_laser_l
   ret

draw_hunter:
  CALL_(get_data)
  ld A,D
   and 63      ;;;;
   ld A,D         ;
   jr nz,d_h_na0  ; just because angle 0,64,128,192 aren't drawn well
   dec D          ;
   ld A,(niv_time);
   and 1          ;
   rlca           ;
   add A,D        ;
d_h_na0:       ;;;;
  xor 128
  ld (foe_angle),A
  ld DE,list_hunter
  JUMP_(lstn)
list_hunter:
.db 12,126
.db 11,123
.db 10,122
.db 9,121
.db 9,126
.db 8,120
.db 8,125
.db 7,119
.db 7,125
.db 6,118
.db 5,116
.db 4,113
.db 4,100
.db 3,92
.db 3,79
.db 9,2
.db 8,8
.db 8,12
.db 8,19
.db 7,26
.db 7,30
.db 6,34
.db 5,40
.db 4,43
.db 4,53
.db 4,64
.db 4,75
.db 4,85
.db 5,93
.db 5,99
.db 6,103
.db 7,106
.db 8,109
.db $FF,$FF





draw_homing:
   ld A,B
   sub 4
   ld B,A
   noir
   inc B
   noir
   inc B
   noir
   inc B
   noir
   inc B
   noir
   inc B
   noir
   ld E,1
   snoir
   inc B
   snoir
   noir
   inc B
   noir
   ld E,1
   snoir
   ld E,2
   snoir
   inc B
   snoir
   ld E,1
   snoir
   noir
   inc B
   noir
   ret

draw_ball:
   ld DE,1
   fnoir
   ret

draw_t_2flame_s1
   ld A,(niv_time)
   bit 0,A
   ret z
   inc B
   inc B
   inc B
   push BC
   inc C
   inc C
   CALL_(draw_flame_s1)
   pop BC
   dec C
   dec C
   JUMP_(draw_flame_s1)


draw_flame_s1:
   noir
   inc B
   inc C
   noir
   inc B
   noir
   inc B
   dec C
   noir
   inc B
   noir
   dec B
   dec B
   dec C
   noir
   dec B
   noir
   dec B
   inc C
   ret   ; fin draw_flame_s1

draw_flame_s4
   noir
   inc B
   ld E,1
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   noir
   inc B
   noir
   inc B
   noir
   inc B
   noir
   ret    ; fin draw_flame_s4

draw_flame_d1:
   noir
   ld E,1
   dec B
   snoir
   inc B
   inc E
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   dec E
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   noir
   inc B
   noir
   inc B
   noir
   ret   ; fin draw flame_d1   


draw_flame_d2:
   inc B
   noir
   dec B
   ld E,0
   inc E
   snoir
   inc E
   snoir
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   dec E
   snoir
   inc B
   snoir
   inc B
   dec E
   snoir
   inc B
   snoir
   inc B
   snoir
   inc B
   dec E
   noir
   inc B
   noir
   inc B
   noir
   ret   ; fin draw_flame_d2



draw_bb_gun:
  ;;noir
  ld A,B
  sub 7
  ld B,A
  sub 44   ; lenght of a big boss gun
  ld (c_draw_bb),A
  ld E,2
  snoir
  ld E,1
draw_bb_gun_loop:
  dec B
  snoir
  ld A,(c_draw_bb)
  cp B
  jr nz,draw_bb_gun_loop
 noir
 CALL_(get_data)
 ld A,E
 cp 4
 ret nc
 dec B
 dec B
 ld E,2
 snoir
 dec B
 dec B
 dec B
 ld E,1
 snoir
 ret

draw_bbg_shot:
   ld A,C
   add A,2
   cp 68
   ret nc
  ld A,B
  add A,25
  ld B,A
  ld E,1
  snoir
  dec B
  dec B
  ld A,B
  sub 48
  ld (c_draw_bb),A
  ld E,2
draw_bbg_shot_l:
  snoir
  ld A,B
  sub 4
  ld B,A
  ld A,(c_draw_bb)
  cp B
  jr nz,draw_bbg_shot_l
  inc B
  ld E,1
  snoir
  ret

draw_bbgd:  ; destroyed big boss gun
  dec B
  noir
  dec B
  dec C
  noir
  dec B
  dec C
  noir
  dec B
  noir
  dec B
  inc C
  noir
  inc C
  dec B
  noir
  dec B
  noir
  dec B
  noir
  dec C
  noir
  dec C
  noir
  dec B
  dec C
  noir
  inc C
  dec B
  noir
  dec B
  noir
  inc C
  noir
  inc C
  dec B
  noir
  dec B
  noir
  dec C
  noir
  dec B
  dec C
  noir
  ret

draw_bb1:
   ld A,C
   add A,37
   cp 138
   ret nc
   ld (trigo_center_y),BC
   ld A,20
   ld (trigo_dist),A
   ld B,0
d_bb1_rond_loop:
   ld A,B
   ld (trigo_angle),A
     CALL_(do_trigo)
     noir
   ld A,(trigo_angle)
   ld B,A
   dec B
   djnz d_bb1_rond_loop

   ld BC,(trigo_center_y)
   ld A,B
   add A,18
   ld B,A
   add A,16
   ld (c_draw_bb),A
   ld E,9
draw_bb1_loop1:
   inc B
   snoir
   inc B
   snoir
   ld A,(c_draw_bb)
   cp B
   jr nz,draw_bb1_loop1

   add A,24
   ld (c_draw_bb),A
draw_bb1_loop2:
   inc E
   inc B
   snoir
   inc B
   snoir
   inc B
   snoir
   ld A,(c_draw_bb)
   cp B
   jr nz,draw_bb1_loop2

   inc B
   CALL_(draw_bb1_loop3)

   ld BC,(trigo_center_y)
   ld A,B
   add A,73
   ld B,A
   ld E,11
   CALL_(draw_bb1_loop3)

   inc B
   ld (souv_bb_xy),BC
   ld A,C
   add A,33
   ld C,A
   noir
  ld A,(foe_type+nbbg1)
  cp bb_gun
  jr z,yes_draw_bbg1
   push AF
   inc C
   inc B
  CALL_(draw_bbgd)
   pop AF
  jr nz,no_draw_bbg1
yes_draw_bbg1:
  inc B
  inc C
  noir
  inc C
  noir
  inc C
  noir
  inc C
  CALL_(line_14_left)
no_draw_bbg1:

   ld BC,(souv_bb_xy)
   ld A,C
   sub 33
   ld C,A
  ld A,(foe_type+nbbg2)
  cp bb_gun
  jr z,yes_draw_bbg2
   inc B
   JUMP_(draw_bbgd)
yes_draw_bbg2:
  noir
  inc B
  dec C
  noir
  dec C
  noir
  dec C
  noir
  dec C
  JUMP_(line_14_left)


draw_bb1_loop3:
   inc E
   snoir
   inc E
   snoir
   inc E
   snoir
   dec B
   ld A,32
   cp E
   jr nz,draw_bb1_loop3
   ret



draw_bb2:
   ld A,C
   add A,16
   cp 96
   ret nc
   ;;ld DE,2
   ;;fnoir
   ld A,B
   sub 34
   ld B,A
     add A,12
     ld (c_draw_bb),A
   noir
   ld E,1
   snoir
   inc E
   snoir
   inc E
   snoir
   inc E
   snoir
draw_bb2_loop1:
   inc E
   inc B
   snoir
   inc B
   snoir
   ld A,(c_draw_bb)
   cp B
   jr nz,draw_bb2_loop1
   add A,31
   ld (c_draw_bb),A
draw_bb2_loop2:
   inc B
   snoir
   ld A,(c_draw_bb)
   cp B
   jr nz,draw_bb2_loop2
   inc B
   inc E
   snoir
 ld A,B
 add A,15
 ld B,A
 push BC
  ld A,C
  add A,14
  ld C,A
  ld A,(foe_type+nbbg3)
  cp bb_gun
  push AF
  CALL_NZ(draw_bbgd)
  pop AF
  JUMP_NZ(no_d_bbg3)
   noir
   inc C
   dec B
   noir
   inc C
   CALL_(line_14_left)
no_d_bbg3:
   pop BC

  ld A,C
  sub 14-3
  ld C,A
  ld A,(foe_type+nbbg4)
  cp bb_gun
  push AF
  CALL_NZ(draw_bbgd)
  pop AF
  JUMP_NZ(no_d_bbg4)
  dec C
  dec C
  dec C
   noir
   dec C
   dec B
   noir
   dec C
   JUMP_(line_14_left)
no_d_bbg4:
   inc C
   dec B
   noir
   ret

line_14_left:   
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   dec B
   noir
   ret

draw_bb_rear:
  ld A,B
  sub 10
  ld B,A
  push BC
   CALL_(draw_bb_engine)
  pop BC
  push BC
   ld A,C
   add A,8
   ld C,A
   CALL_(draw_bb_engine)
  pop BC
  push BC
   ld A,C
   sub 8
   ld C,A
   CALL_(draw_bb_engine)
  pop BC
  dec B
  ld E,12
  snoir
  ld E,4
  snoir
  dec B
  snoir
  ld E,12
  snoir
  dec B
  snoir
  inc E
  snoir
  ret

draw_bb_engine:
  ld E,3
  snoir
  inc B
  snoir
  ld E,2
  inc B
  snoir
  inc B
  snoir
  ld E,1
  snoir
  noir
  ld A,(niv_time)
  bit 0,A
  ret z
  inc B
  inc B
  inc B
  noir
  ld E,1
  snoir
  inc B
  ld E,2
  snoir
  inc B
  snoir
  inc B
  snoir
  inc B
  snoir
  ld E,1
  inc B
  snoir
  inc B
  snoir
  inc B
  snoir
  inc B
  snoir
  inc B
  noir
  inc B
  noir
  inc B
  noir
  inc B
  noir
  ret

find_bug:
  push HL
  ld HL,error_byte
  set 0,(HL)
  pop HL
  ret

find_mem_full:
  push HL
  ld HL,error_byte
  set 1,(HL)
  pop HL
  ret



disp_hl:
disp_HL:
   push AF
   push BC
   push DE
   push HL
   ld BC,$0702
   ld (CURSOR_ROW),BC
   ROM_CALL(D_HL_DECI)
   CALL_(key_pause)
   pop HL
   pop DE
   pop BC
   pop AF
   ret

disp_acc:
   push AF
   push BC
   push DE
   push HL
   ld BC,$0703
   ld (CURSOR_ROW),BC
   ld L,A
   ld H,0
   ROM_CALL(D_HL_DECI)
   CALL_(key_pause)
   pop HL
   pop DE
   pop BC
   pop AF
   ret

disp_menu_num:        ; display the number in acc in menu style (position must be set before)
     ld HL,num_chars
    ld (HL),32   ; 32=space
    inc HL
    ld (HL),32
    inc HL
    ld (HL),32
  ld C,A
num_higher_10:
  sub 10
  jr nc,num_higher_10
   add A,10
   ld B,A
   add A,48   ; 0 is the character number 48
   ld (HL),A
   dec HL
   ld A,C
   sub B
   CALL_(div_10)
   cp 0
   ld C,A
   jr nz,num_higher_10
   ld B,3
   ld HL,num_chars
   ROM_CALL(D_LM_STR)
   ret


div_10:     ; divide A by ten (if A is divisible by ten, or else...)
  ld E,A
  ld D,0
div_10_loop1:
  ld A,0
  ld B,10
div_10_loop2:
  add A,D
  djnz div_10_loop2
  cp E
  ld A,D
  ret z
  inc D
  jr div_10_loop1




text_langue1:

text_mem_full:
.db "Memory  full !",0
text_bug:
.db "Bug detected !",0
text_game_over:
.db "GAME  OVER",0
text_time:
.db "Time =",0
text_score:
.db "Score=",0
text_niv:
.db "Level =",0

text_h_bonus:
.db 50,28,"Health",0,1,"  bonus",0    ; x,y,text
text_e_bonus:
.db 22,28
.db "You  get  an  extra  engine  !",0
text_o_bonus:
.db 45,12
.db "Full Health",0
text_torp_bonus:
.db 38,28
.db "Got torpedo/mine",0

text_help1:
.db  0,0,"Key used:",0,1
.db  "LOG:Fran",179,"ais",0,1   ;179=c cedille
.db  "Arrows :  move",0
text_help2:
.db  0,0,"2nd,F5: fire",0,1
.db  "F1",206,"F4:select  gun",0     ; 206="..."
text_help3:
.db  0,0,"ALPHA:launch torpedo",0,1
.db  "x-VAR:lay mine",0
text_help4:
.db  0,0,"MORE,P=,:pause",0,1
.db  "+and-:contrast",0,1
.db  "STAT:",206,0      ; 206="..." 
text_help5:
.db  0,0,"x",18,": two players",0,1
.db  "0+1,2",206,": like F1,F2",206,0
text_help6:
.db 0,0,"STO,DEL: save",0,1
.db "PRGM : load",0
text_no_savegame:
.db 33,28,"Savegame  missing",0
text_game_saved:
.db 43,28,"Game saved",0
text_game_loaded:
.db 40,28,"Game loaded",0
text_help_ae1:
.db 0,0,"F1,F2,F3+arrows:"
.db "firing direction",0




text_langue2:
.db "Memoire pleine",0
.db "Bug  detect",150," !",0    ; 150=e accent aigu
.db "GAME  OVER",0
.db "Temps=",0
.db "Score=",0
.db "Niveau=",0
.db 42,28,"Bonus sante +10",0    ; x,y,text
.db 22,28
.db "Un    moteur    en    plus   !",0
.db 45,12
.db "Sant",150," max !",0
.db 38,28
.db "Torpille ou mine",0
.db  0,0,"Touches :",0,1
.db  "LOG: English",0,1
.db  "Fl",152,"ches:bouger",0
.db  0,0,"2nd,F5:tirer",0,1
.db  "F1",206,"F4:choix canon",0        ; 206="..."
.db  0,0,"ALPHA:tirer torpille",0,1
.db  "x-VAR:    mine",0
.db  0,0,"MORE",38,"P=,:pause",0,1   ; 38= et
.db  "+et-:contraste",0,1
.db  "STAT:",206,0      ; 206="..."
.db  0,0,"x",18,":deux joueurs",0,1
.db  "0+1,2",206,":comme F1,F2",206,0
.db 0,0,"STO,DEL:sauve",0,1
.db "PRGM:charge",0
.db 33,28,"Pas de sauvegarde",0
.db 43,28,"Sauvegarde",0
.db 40,28," Chargement",0
.db 0,0,"F1,F2,F3+fl",152,"ches"
.db ": direction tirs",0


.db "X"     ; pressing LOG shouldn't change it

.end    ; put an ENTER after

