#include "asm86.h"
#include "ti86abs.inc"
#include "ti86asm.inc"
#include "ti86ops.inc"

#define adjust $d746 - code

.org _asm_exec_ram

        res 5,(iy)
        call $49dc
        call _clrscrn
        call _homeup
        ld hl,name
        call _puts
        bit 6,(iy+$24)
        jr z,install_it
        ld hl,removed
        call _puts
        call _newline
        ld hl,$5a92
        rst 20h
        rst 10h
        call _delvar
        res 6,(iy+$24)
        jp $409c
install_it:
        call _puts
        call _newline
        ld hl,$5a92
        rst 20h
        rst 10h
        jr c,install
        call _delvar
install:
        ld hl,code_end-code
        push hl
        call _createprog
        ld a,b
        ex de,hl
        call $4c3f              ;AHL+=2
        call _SET_ABS_DEST_ADDR
        xor a
        pop hl
        call _SET_MM_NUM_BYTES
        ld hl,code
        call _SET_ABS_SRC_ADDR
        call _mm_ldir
        set 6,(iy+$24)
        jp $409c

name    .db "TI-86 Status Bar v0.1"
        .db "written by Kirk Meyer"
        .db "has been ",0
active  .db "installed!",0
removed .db "removed!",0      

code:
        .db $8e,$28          
        call $479f      ;pop op1
        bit 0,(iy+$20)
        jr nz,code_exit
        ld a,($c1b4)
        cp $01
        jr nz,code_exit
        ld a,($d13e)
        cp 8
        jr c,is_it_shown
        ld a,7
        ld ($d13e),a
        call redraw
is_it_shown:
        ld a,($c21e)
        or a
        jr nz,code_exit
        ld a,(_asm_reg_a)
        cp K_CLEAR
        jr nz,not_clear

not_clear:
        cp K_F1
        call z,degrad
        cp K_F2
        call z,normscieng
        cp K_F4
        call z,fixminus
        cp K_F5
        call z,fixplus
        cp K_F3
        call z,decbinocthex
        inc a
        call z,redraw
code_exit:
        ld a,(_asm_reg_a)
        cp a
        ret

byte_ext:
byte_int = $ + adjust
        .db 0

degrad = $ + adjust
        ld a,255
        bit 2,(iy)
        jr z,degrad_a
        res 2,(iy)
        ret
degrad_a:
        set 2,(iy)
        ret

normscieng = $ + adjust
        ld a,255
        bit 0,(iy+10)
        jr z,normscieng_a
        bit 1,(iy+10)
        jr z,normscieng_b
        res 0,(iy+10)
        res 1,(iy+10)
        ret
normscieng_a:
        set 0,(iy+10)
        ret
normscieng_b:
        set 1,(iy+10)
        ret

fixminus = $ + adjust
        ld hl,$d148)
        ld a,(hl)
        dec a
        cp 254
        jr nz,fixminus_a
        ld a,11
fixminus_a:
        ld (hl),a
        ld a,255
        ret

fixplus = $ + adjust
        ld hl,$d148)
        ld a,(hl)
        inc a
        cp 12
        jr nz,fixplus_a
        ld a,255
fixplus_a:
        ld (hl),a
        ld a,255
        ret

decbinocthex = $ + adjust
        ld a,(iy+10)
        rrca
        rrca
        rrca
        ld c,a
        ld a,255
        jr c,decbinocthex_a
        rrc c
        jr c,decbinocthex_b
        rrc c
        jr c,decbinocthex_c
        set 4,(iy+10)
        ret
decbinocthex_a:
        res 2,(iy+10)
        ret
decbinocthex_b:
        res 3,(iy+10)
        set 2,(iy+10)
        ret
decbinocthex_c:
        res 4,(iy+10)
        set 3,(iy+10)
        ret


redraw = $ + adjust
        ld a,$39
        ld (_penRow),a

        ld hl,$ff80
        ld de,$ff81
        ld bc,$000f
        ld (hl),%10101010
        ldir
        inc hl
        inc de
        ld bc,$006f
        ld (hl),$00
        ldir

        ld hl,rad_string
        bit 2,(iy)
        jr z,is_radians
        ld hl,deg_string
is_radians:
        call _vputss

        ld hl,norm_string
        bit 0,(iy+10)
        jr z,is_norm
        ld hl,sci_string
        bit 1,(iy+10)
        jr z,is_norm
        ld hl,eng_string
is_norm:
        call _vputss

        ld a,(iy+10)
        rrca
        rrca
        ld hl,hex_string
        rrca
        jr c,is_base
        ld hl,oct_string
        rrca
        jr c,is_base
        ld hl,bin_string
        rrca
        jr c,is_base
        ld hl,dec_string
is_base:
        call _vputss

        ld a,92
        ld (_penCol),a
        ld a,$cf
        call _vputmap
        ld a,123
        ld (_penCol),a
        ld a,5
        call _vputmap
        
        ld a,($d148)
        inc a
        jr z,is_float
        ld c,102
        dec a
        cp 10
        jr c,ten_okay
        ld c,102-2
ten_okay:
        push af
        ld a,c
        ld (_penCol),a
        ld hl,fix_string
        call _vputs
        pop af
        jr c,okay_ten
        push af
        ld a,'1'
        call _vputmap
        pop af
        sub 10
okay_ten:        
        add a,'0'
        jp _vputmap
is_float:
        ld hl,float_string

_vputss = $ + adjust
        ld a,(hl)
        ld (_penCol),a
        inc hl
        jp _vputs

deg_string = $ + adjust
        .db 0,"Deg",0
rad_string = $ + adjust
        .db 0,"Rad",0
norm_string = $ + adjust
        .db 25,"Norm",0
sci_string = $ + adjust
        .db 29,"Sci",0
eng_string = $ + adjust
        .db 28,"Eng",0
dec_string = $ + adjust
        .db 58,"Dec",0
bin_string = $ + adjust
        .db 59,"Bin",0
oct_string = $ + adjust
        .db 58,"Oct",0
hex_string = $ + adjust
        .db 58,"Hex",0
float_string = $ + adjust
        .db 101,"Float",0
fix_string = $ + adjust
        .db "Fix ",0
code_end:

.end

