#define  need_FIND_PIXEL
#define  need_DIV_A_HL
#define  need_MUL_A_DE
#define  need_D_HL_DECI

         .include "ti-86.h"

score    =$c0f9         ; the score!
edgedata =$c101
v        =$c137
destroy  =$c138
x        =$c13a
marker   =$c0fb

prog_code:
 ; -------------- LOAD / UNLOAD ---------------------------------------------
         call     _clrLCD
         ld       hl,0
         ld       ($c00f),hl
         ld       hl,title_message
         call     _puts
         ld       hl,$3017
         ld       (CURSOR_X),hl
         ld       hl,prog_name
         call     _vputs       

loopttl: call     _getkey
         cp       kF1
         jr       z,speed_1
         cp       kF2
         jr       z,speed_2
         cp       kF3
         jr       z,speed_3
         cp       kF4
         jr       z,speed_4
         cp       kF5
         jr       z,speed_5
         cp       kExit
         jr       nz,loopttl
         ret
title_message:                 
         .db      "Z-Kart 3D        v3.1"
         .db      " by Patrick Davidson "
         .db      "  (ariwsi@juno.com)  "
         .db      "Choose Speed : F1-F5",0
speed_1: ld       hl,0
         ld       de,500
         jr       start
speed_2: ld       hl,50
         ld       de,400
         jr       start
speed_3: ld       hl,100
         ld       de,300
         jr       start
speed_4: ld       hl,150
         ld       de,200
         jr       start
speed_5: ld       hl,200
         ld       de,100
start:   ld       (score),hl
         ld       (loop+1),de
 ; -------------- ACTUAL GAME ----------------------------------------------
         call     _clrLCD
         ld       hl,$0007
         ld       ($c00f),hl
         ld       hl,message
         call     _puts
         ld       hl,edgedata
         ld       b,54
lced:    ld       (hl),45
         inc      hl
         djnz     lced
         LD       A,4
         ld       (marker),a
 ; -------------- MAIN LOOP ------------------------------------------------
loop:    ld       bc,0
wait:    dec      bc
         ld       a,b
         or       c
         jr       nz,wait
 ; -------------- CLEAR TEMPORARY BUFFER ----------------------------------
         ld       hl,$ac00
         ld       b,128
lclr:    ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         djnz     lclr
 ; -------------- RENDER THE TRACK -----------------------------------------
         ld       a,(marker)
         dec      a
         jr       nz,n0
         ld       a,9
n0:      ld       (marker),a
         ld       hl,$ac00
         ld       (destroy),hl
         LD       HL,edgedata
         ld       b,9
         ld       c,-1
render_far_away:
         call     linedrw
         inc      hl
         djnz     render_far_away
         ld       b,9
render_middle_distance:
         call     linedrw
         dec      hl
         call     linedrw
         inc      hl
         djnz     render_middle_distance
         ld       b,9
render_near:
         call     linedrw
         dec      hl
         call     linedrw
         dec      hl
         call     linedrw
         inc      hl
         djnz     render_near
         ld       b,63
 ; -------------- UPDATE SCORE ----------------------------------------------
         LD       HL,$1007
         ld       ($c00f),hl
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         call     D_HL_DECI
 ; -------------- MOVE UP THE LANDSCAPE -------------------------------------
         ld       a,r
         cp       8
         jr       NC,nocc
         ld       hl,dirs
         and      7
         ld       e,a
         ld       d,0
         ADD      hl,de
         ld       a,(hl)
         ld       (v),a
nocc:    ld       de,edgedata+53
         ld       hl,edgedata+51
         ld       bc,52
         lddr
         inc      hl
         inc      de
         ld       a,(v)
         ld       d,a
         ld       a,(hl)
         cp       60
         jr       nz,nle
         ld       d,1
nle:     inc      hl
         ld       a,(hl)
         cp       60
         jr       nz,nre
         ld       d,-1
nre:     ld       a,d
         ld       (v),a
         ld       a,(hl)
         add      a,d
         ld       (hl),a
         dec      hl
         ld       a,(hl)
         sub      d
         ld       (hl),a
         LD       A,(score)
         and      15
         jr       nz,ntts
         dec      (hl)
         inc      hl
         dec      (hl)
         ld       hl,(loop+1)
         dec      hl
         ld       a,h
         or       l
         jr       z,ntts
         ld       (loop+1),hl
ntts:
 ; -------------- MOVE YOUR CAR ---------------------------------------------
         ld       a,%01111110
         out      (1),a
         ld       hl,x
         in       a,(1)
         rra
         rra
         jr       c,noleft
         dec      (hl)
         dec      (hl)
noleft:  rra
         jr       c,noright
         inc      (hl)
         inc      (hl)
noright: ld       a,(hl)
         ld       c,53
         call     pton
         ld       a,(hl)
         dec      a
         call     pton
         ld       a,(hl)
         inc      a
         call     pton
         ld       a,(hl)
         inc      a
         inc      a
         call     pton
         ld       a,(hl)
         dec      a
         dec      a
         call     pton
         dec      c
         ld       a,(hl)
         call     pton
         ld       a,(hl)
         dec      a
         call     pton
         ld       a,(hl)
         inc      a
         call     pton
         ld       a,(hl)
         dec      c
         call     pton
         ld       a,%00111111
         out      (1),a
         in       a,(1)
         bit      6,a
         ret      z
 ; -------------- DISPLAY THE SCREEN ---------------------------------------
         ld       de,$fc00
         ld       hl,$ac00
         ld       bc,896
         ldir
 ; -------------- SEE IF YOU LOSE ------------------------------------------
         ld       a,(x)
         ld       hl,edgedata+53
         add      a,2
         sub      (hl)
         jp       p,lose
         dec      hl
         ld       a,(x)
         sub      2
         add      a,(hl)
         jp       p,loop
 ; -------------- GAME OVER ------------------------------------------------
lose:
         ld       hl,(best)
         ld       de,(score)
         CALL     CP_HL_DE
         jr       c,hisc
         ld       hl,0
         ld       ($800c),hl
         ld       hl,lose_
         ROM_CALL(D_ZT_STR)
lwk:     call     GET_KEY
         cp       9
         jr       nz,lwk
         ret
hisc:
         ld       de,(score)
         ld       (best),de
         ld       de,digits+3
         ld       hl,(score)
         ld       b,4
p_l:     CALL     UNPACK_HL
         add      a,'0'
         ld       (de),a
         dec      de
         djnz     p_l
         ld       hl,0
         ld       (CURSOR_ROW),hl
         ld       hl,hi_msg
         ROM_CALL(D_ZT_STR)
         ld       hl,$b00
         ld       (CURSOR_ROW),hl
         ld       hl, name
         push     hl
         ld       b,9
space_loop:
         ld       (hl), ' '
         inc      hl
         djnz     space_loop
         pop      ix
         ld       b,0
enter_name_loop:
         push     bc
         CALL     GET_KEY
         pop      bc
         or       A
         jr       z,enter_name_loop
         cp       32
         jr       z,backup
         SUB      9
         jr       z,nomore
         dec      a
         bit      7,a
         jr       c,enter_name_loop
         ld       hl,chartable
         ld       e,a
         ld       d,0
         add      hl,de
         ld       a,9
         cp       b
         jr       z,enter_name_loop
         ld       a,(hl)
         or       a
         jr       z,enter_name_loop
         ld       (ix),a
         ROM_CALL(TX_CHARPUT)
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  xor      a
         cp       b
         jr       z,too_far
         dec      b
         dec      ix
         ld       a,'_'

         ld       (ix),a
         ld       hl,CURSOR_COL
         dec      (hl)
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:  ret
 ; -------------- DATA / SUBROUTINES ----------------------------------------
hi_msg:  .db      "Highscore! _________ ",0
lose_:   .db      "LOSER!!!  Press ENTER",0
message: .db      "Z-Kart 3D Score:"
         .db      0

linedrw: inc      c
         ld       a,(marker)
         cp       b
         jr       nz,nad
         inc      hl
         ld       a,(hl)
         dec      hl
         sub      (hl)
         sra      a
         call     DoConvSide
         call     pton        
nad:     ld       a,(hl)
         inc      hl
         call     DoConvSide
         neg                        ;Flip to left side
         add      a,63
         push     hl
         ld       hl,(destroy)
lfil:    sub      8
         jp       m,done
         ld       (hl),255
         inc      hl
         jp       lfil
done:    and      7
         ld       d,0
         ld       e,a
         push     hl
         ld       hl,offsets_left
         add      hl,de
         ld       a,(hl)
         pop      hl
         or       (hl)
         ld       (hl),a
         pop      hl
         LD       A,(HL)            ;read right edge coordinate
         call     DoConvSide
         neg
         add      a,63
         push     hl
         ld       hl,(destroy)
         ld       de,16
         add      hl,de
         ld       (destroy),hl
lfir:    dec      hl
         sub      8
         jp       m,done2
         ld       (hl),255
         jp       lfir
done2:   and      7
         ld       d,0
         ld       e,a
         push     hl
         ld       hl,offsets_right
         add      hl,de
         ld       a,(hl)
         pop      hl
         or       (hl)
         ld       (hl),a
         pop      hl
         ret

pton:    push     hl
         push     bc
         add      a,63
         ld       b,a
         call     FIND_PIXEL          ;Get the pixel offset
         ld       hl,$aC00
         add      hl,de             ;Point into the graphics memory
         or       (HL)              ;A now contains the modified screen byte
         ld       (HL),A            ;Write back to screen to update
         pop      bc
         pop      hl
         ret
DoConvSide:
         push     hl
         ld       hl,clab1
         bit      7,a
         jr       nz,dcs_neg
         ld       (hl),$c9
dcs_c:   LD       DE,20

         call     MUL_A_DE

         ld       a,74
         sub      c             
         call     DIV_A_HL+2    
         ld       a,l
         pop      hl
clab1:   neg
         ret
dcs_neg: neg
         ld       (hl),$ed
         jp       dcs_c
chartable:
         .db      "XTOJE",0
         .db      0," WSNID!",0,"ZVRMHC?"
         .db      0,"YUQLGB#x~+PKFA|"
         .db      "@54321.~+"
         RET                        
dirs:    .db      1,0,-1,1,-1,1,0,-1
best:    .dw      0
offsets_left:
         .db      %00000000
         .db      %10000000
         .db      %11000000
         .db      %11100000
         .db      %11110000
         .DB      %11111000
         .DB      %11111100
         .DB      %11111110
offsets_right:
         .db      %00000000
         .db      %00000001
         .db      %00000011
         .db      %00000111
         .db      %00001111              
         .db      %00011111
         .db      %00111111
         .db      %01111111

prog_name:
         .db      "High : "
digits:  .db      "0000"
         .db      " by "
name:    .db      "PATRICK D",0

end:     .end
