;##################################################################
;
;   Usgard simulation for TI-86
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 6, 2000.

;############## Definitions of system calls

LD_HL_MHL       =$4010              ; _ldHLind
CP_HL_DE        =$403C              ; _cphlde
UNPACK_HL       =$4044              ; _divHLby10
M_CHARPUT       =$4AA1              ; _vputmap
TX_CHARPUT      =$4A2B              ; _putc
D_ZT_STR        =$4A37              ; _puts
CLEARLCD        =$4A7E              ; _clrLCD
D_ZM_STR        =$4AA5              ; _vputs
BUSY_OFF        =$4AB1              ; _runindicoff

;############## Definitions of memory areas

CONTRAST        =$C008              
CURSOR_ROW      =$C00F              ; _curRow
CURSOR_COL      =$C010              ; _curCol
TEXT_MEM        =$C0F9              ; _textShadow
CURSOR_X        =$C37C              ; _penCol
CURSOR_Y        =$C37D              ; _penRow
GRAPH_MEM       =$C9FA              ; _plotSScreen

_asm_exec_ram   =$D748

DELC_LEN        =$F000              ; not real address, but safe to use

;############## Definitions of GET_KEY values

K_MORE          =$38
K_EXIT          =$37
K_F1            =$35
K_F2            =$34
K_F3            =$33
K_F4            =$32
K_F5            =$31
K_7             =$24
K_DEL           =$20
K_CLEAR         =$0F
K_MINUS         =$0B
K_PLUS          =$0A
K_ENTER         =$09
K_UP            =$04
K_DOWN          =$01

;############## TI-86 program header (for YAS, etc.)

        .org    _asm_exec_ram
        nop
        jp      startup
        .dw     0
        .dw     title

;############## Initialization

startup:
        call    $49DC                   ; _flushAllMenus
        call    BUSY_OFF
        di
        ld      (OTH_EXIT+1),sp
        call    GET_KEY
        call    GET_KEY
        ld      hl,TEXT_MEM
        ld      bc,167
        call    OTH_CLEAR
        call    main

OTH_EXIT:
        ld      sp,0
        ei

        ld      hl,variable_name
        call    $46CB                   ; _FINDSYM; BDE -> start of program
        ld      hl,permanent_data_start+4-_asm_exec_ram
        ld      a,b
        add     hl,de
        adc     a,0                     ; AHL -> perm storage in variable
        call    $5285                   ; _SET_ABS_DEST_ADDR
        ld      a,0
        ld      hl,permanent_data_start
        call    $4647                   ; _SET_ABS_SRC_ADDR
        ld      a,0
        ld      hl,permanent_data_end-permanent_data_start
        call    $464f                   ; _SET_MM_NUM_BYTES
        call    $52ed                   ; _mm_ldir

        ld      hl,TEXT_MEM
        ld      (hl),' '
        ld      bc,167
        call    OTH_FILL
        call    CLEARLCD
        ld      hl,0
        ld      (CURSOR_ROW),hl
        ld      (iy+13),6
        ret

variable_name:
        .db     "zkart3d",0

;############## Simulation of Usgard functions

OTH_CLEAR:
        ld      (hl),0
OTH_FILL:
        ld      d,h
        ld      e,l
        inc     de
        ldir
        ret

OTH_ARROW:
        ld      a,%00111111
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        or      %00001111
        ld      b,a
        ld      a,%01111110
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        and     b
        ret

;############## GET_KEY replacement

GET_KEY:
        push    hl
        push    de
        push    bc
        ld      e,0                     ; E = GET_KEY result
        ld      hl,getkeylastdata       ; HL = ptr to last read's table
        ld      a,$fe                   ; A = key port mask
        ld      d,1                     ; D = individual key's mask
        ld      c,0                     ; C = key number counter
gkol:   out     (1),a
        ld      b,8                         
        push    af
gkl:    inc     c
        in      a,(1)
        and     d
        jr      nz,nokey
        ld      a,(hl)
        and     d
        jr      z,nokey
        ld      e,c
nokey:  rlc     d
        djnz    gkl
        in      a,(1)
        ld      (hl),a
        pop     af
        inc     hl
        rlca     
        cp      $7F
        jr      nz,gkol
        ld      a,e
        pop     bc
        pop     de
        pop     hl
        ret

getkeylastdata:
        .db     $ff,$ff,$ff,$ff,$ff,$ff,$ff

;############## OTH_PAUSE replacement

OTH_PAUSE:
        call    GET_KEY
        cp      K_ENTER
        ret     z
        jr      OTH_PAUSE

;############## FIND_PIXEL replacement


offsets_table:
        .db     128,64,32,16,8,4,2,1

FIND_PIXEL:
        ld      a,b
        and     7
        ld      hl,offsets_table
        ld      e,a
        ld      d,0
        add     hl,de
        ld      a,(hl)

        push    af
        ld      h,0
        ld      a,63
        sub     c
        add     a,a
        add     a,a
        add     a,a
        rl      h
        add     a,a
        rl      h
        ld      c,b
        srl     c
        srl     c
        srl     c
        or      c
        ld      l,a
        pop     af

        ret

;############## D_HL_DECI replacement

D_HL_DECI:
        push    bc
        ld      de,up_data+4
        ld      b,5
ldhld:  call    UNPACK_HL
        add     a,48
        ld      (de),a
        dec     de
        djnz    ldhld
        ld      hl,up_data
        ld      b,4
lis:    ld      a,(hl)
        cp      48
        jr      nz,dis
        ld      (hl),32
        inc     hl
        djnz    lis
dis:    ld      hl,up_data
        call    D_ZT_STR
        pop     bc
        ret

up_data:
        .db     "PAD98",0               ; Because this was coded in 1998!
