         .include  "ti-86.h"

score    =TEXT_MEM
edgedata =TEXT_MEM+2
v        =TEXT_MEM+57
destroy  =TEXT_MEM+58
x        =TEXT_MEM+60
winscore =TEXT_MEM+62

 ;--------------- TITLE SCREEN ----------------------------------------------

permanent_data_start:
title_message:                 
         .db      "Z-Kart 3D        v9.0"
         .db      " Release 7-Sept-2000 "
         .db      " by Patrick Davidson "
         .db      "E-Mail : pad@calc.org"
         .db      "Choose Speed : F1-F5 "

title:   .db      "HS: "
digits:  .db      "0000"
         .db      " by "
name:    .db      "PATRICK D",0

permanent_data_end:

main:    call     CLEARLCD
         ld       (iy+13),0
         ld       (CURSOR_ROW),de
         ld       hl,title_message
         call     D_ZT_STR

loopttl:
         call     GET_KEY
         cp       K_EXIT
         ret      z
         sub      K_F5
         jr       c,loopttl
         ld       (loop+1),a
         cp       5
         jr       nc,loopttl

start:   cpl
         add      a,7
         add      a,a
         add      a,a
         add      a,a
         ld       b,a
         add      a,a
         add      a,a
         add      a,b

         ld       l,a
         ld       h,0
         ld       (score),hl
         ld       de,715
         add      hl,de
         ld       (winscore),hl

 ; -------------- ACTUAL GAME -----------------------------------------------

         ld       hl,$0007
         ld       (CURSOR_ROW),hl
         ld       hl,message
         call     D_ZT_STR 
         ld       hl,edgedata
         ld       b,54
lced:    ld       (hl),45
         inc      hl
         djnz     lced

 ; -------------- MAIN LOOP -------------------------------------------------
loop:         
         ld       a,0
         or       a
         jr       z,no_wait
         ld       b,a
wait:    ei
         halt
         di          
         djnz     wait

 ; -------------- RENDER THE TRACK ------------------------------------------

no_wait:
         call     GET_KEY
         cp       K_ENTER
         call     z,OTH_PAUSE

marker   =$+1
         ld       a,1
         dec      a
         jr       nz,n0
         ld       a,9
n0:      ld       (marker),a
         ld       hl,$fc00
         ld       (destroy),hl
         LD       HL,edgedata
         ld       b,9
         ld       c,-1
render_far_away:
         call     linedrw
         inc      hl
         djnz     render_far_away
         ld       b,9
render_middle_distance:
         call     linedrw
         dec      hl
         call     linedrw
         inc      hl
         djnz     render_middle_distance
         ld       b,9
render_near:
         call     linedrw
         dec      hl
         call     linedrw
         dec      hl
         call     linedrw
         inc      hl
         djnz     render_near

         call     _update_score

 ; -------------- MOVE UP THE LANDSCAPE -------------------------------------

         ld       a,r
         cp       8
         jr       NC,nocc
         ld       hl,dirs
         and      7
         ld       e,a
         ld       d,0
         ADD      hl,de
         ld       a,(hl)
         ld       (v),a
nocc:    ld       de,edgedata+53
         ld       hl,edgedata+51
         ld       bc,52
         lddr
         inc      hl
         inc      de
         ld       a,(v)
         ld       d,a
         ld       a,(hl)
         cp       62
         jr       nz,nle
         ld       d,1
nle:     inc      hl
         ld       a,(hl)
         cp       62
         jr       nz,nre
         ld       d,-1
nre:     ld       a,d
         ld       (v),a
         ld       a,(hl)
         add      a,d
         ld       (hl),a
         dec      hl
         ld       a,(hl)
         sub      d
         ld       (hl),a
         LD       A,(score)
         and      15
         jr       nz,ntts
         dec      (hl)
         inc      hl
         dec      (hl)
ntts:
 ; -------------- MOVE YOUR CAR ---------------------------------------------

         call     OTH_ARROW
         ld       hl,x
         rra
         rra
         jr       c,noleft
         dec      (hl)
         dec      (hl)
noleft:  rra
         jr       c,noright
         inc      (hl)
         inc      (hl)
noright: ld       a,(hl)
         ld       c,53
         call     pton_t
         ld       a,(hl)
         dec      a
         call     pton_t
         ld       a,(hl)
         inc      a
         call     pton_t
         ld       a,(hl)
         inc      a
         inc      a
         call     pton_t
         ld       a,(hl)
         dec      a
         dec      a
         call     pton_t
         dec      c
         ld       a,(hl)
         call     pton_t
         ld       a,(hl)
         dec      a
         call     pton_t
         ld       a,(hl)
         inc      a
         call     pton_t
         ld       a,(hl)
         dec      c
         call     pton_t

         call     OTH_ARROW

         bit      6,a
         ret      z

         jp       loop

pton_t:  push     hl
         push     bc
         add      a,63
         ld       b,a
         ld       a,63
         sub      c
         ld       c,a
         call     FIND_PIXEL        ;Get the pixel offset
         ld       de,$FC00
         add      hl,de             ;Point into the graphics memory
         ld       b,(hl)
         ld       c,a
         or       b                 ;A now contains the modified screen byte
         ld       (HL),A            ;Write back to screen to update
         ld       a,c
         and      b
         pop      bc
         pop      hl
         jr       nz,you_lose
         ret

 ; -------------- UPDATE SCORE ----------------------------------------------

_update_score:
         LD       HL,$1007
         ld       (CURSOR_ROW),hl
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         call     D_HL_DECI
         ret

you_lose:
         inc      sp
         inc      sp

 ; -------------- GAME OVER -------------------------------------------------
lose:

         ld       hl,(score)
         ld       de,(winscore)
         call     CP_HL_DE
         jr       nz,no_win
         ld       de,50
         add      hl,de
         ld       (score),hl
         call     _update_score
         ld       hl,1
         ld       (CURSOR_ROW),hl
         ld       hl,wingame
         call     D_ZT_STR
no_win:

         ld       hl,$7
         ld       (CURSOR_ROW),hl
         ld       hl,lose_
         call     D_ZT_STR
         ld       hl,(best)
         ld       de,(score)
         CALL     CP_HL_DE
         jr       c,hisc
lwk:     jp       OTH_PAUSE

hisc:
         ld       de,(score)
         ld       (best),de
         ld       de,digits+3
         ld       hl,(score)
         ld       b,4
p_l:     CALL     UNPACK_HL
         add      a,'0'
         ld       (de),a
         dec      de
         djnz     p_l
         ld       hl,0
         ld       (CURSOR_ROW),hl
         ld       hl,hi_msg
         call     D_ZT_STR 
         ld       hl,$b00
         ld       (CURSOR_ROW),hl
         ld       hl,name
         push     hl
         ld       b,9
space_loop:
         ld       (hl), ' '
         inc      hl
         djnz     space_loop
         pop      de

enter_name_loop:
         CALL     GET_KEY
         or       A
         jr       z,enter_name_loop
         cp       32
         jr       z,backup
         SUB      9
         ret      z
         dec      a
         jr       c,enter_name_loop
         ld       hl,chartable
         push     de
         ld       e,a
         ld       d,0
         add      hl,de
         pop      de
         ld       a,9
         cp       b
         jr       z,enter_name_loop
         ld       a,(hl)
         or       a
         jr       z,enter_name_loop
         ld       (de),a
         call     TX_CHARPUT 
         inc      b
         inc      de
         jr       enter_name_loop
backup:  xor      a
         cp       b
         jr       z,enter_name_loop
         dec      b
         dec      de
         ld       a,'_'

         ld       (de),a
         ld       hl,CURSOR_COL
         dec      (hl)
         call     TX_CHARPUT 
         dec      (hl)
         jr       enter_name_loop

 ; -------------- DATA / SUBROUTINES ----------------------------------------

wingame: .db      "You Win!",0
hi_msg:  .db      "Highscore! _________ ",0
lose_:   .db      "    Final",0
message: .db      "Z-Kart 3D Score:",0

linedrw:
         inc      c
         push     hl                ;save coordinate pointer
         push     bc
         ld       bc,15
         ld       HL,(destroy)
         ld       (hl),0
         ld       de,(destroy)
         inc      de
         ldir
         ld       (destroy),de
         pop      bc
         pop      hl
         ld       a,(marker)
         cp       b
         jr       nz,nad
         ld       a,50
         cp       c
         jr       c,nad
         inc      hl
         ld       a,(hl)
         dec      hl
         sub      (hl)
         sra      a
         call     DoConvSide
         dec      a

         call     pton        
nad:     ld       a,(hl)
         inc      hl
         call     DoConvSide

         cpl                        ;Flip to left side
         add      a,64
         push     hl
         ld       hl,(destroy)
         ld       de,-16
         add      hl,de
         ld       e,8
lfil:    sub      e
         jr       c,done
         ld       (hl),255
         inc      hl
         jr       lfil
done:    and      7
         ld       d,0
         ld       e,a
         push     hl
         ld       hl,offsets_left
         add      hl,de
         ld       a,(hl)
         pop      hl
         or       (hl)
         ld       (hl),a
         pop      hl
         LD       A,(HL)            ;read right edge coordinate
         call     DoConvSide
         cpl
         add      a,66
         push     hl
         ld       hl,(destroy)
         ld       e,8
lfir:    dec      hl
         sub      e
         jr       c,done2
         ld       (hl),255
         jr       lfir
done2:   and      7
         ld       d,0
         ld       e,a
         push     hl
         ld       hl,offsets_right
         add      hl,de
         ld       a,(hl)
         pop      hl
         or       (hl)
         ld       (hl),a
         pop      hl
         ret

pton:    push     hl
         push     bc
         add      a,63
         ld       b,a
         ld       a,63
         sub      c
         ld       c,a
         call     FIND_PIXEL        ;Get the pixel offset
         ld       de,$FC00
         add      hl,de             ;Point into the graphics memory
         or       (HL)              ;A now contains the modified screen byte
         ld       (HL),A            ;Write back to screen to update
         pop      bc
         pop      hl
         ret

DoConvSide:
         push     hl
         ld       hl,clab1
         bit      7,a
         jr       nz,dcs_neg
         ld       (hl),$c9
dcs_c:

         ld       d,0               ;HL=A*20
         ld       e,a
         add      a,a
         add      a,a
         ld       h,0
         ld       l,a
         add      hl,de
         add      hl,hl
         add      HL,HL

         ld       a,73
         sub      c             
         call     $4048             ;_divHLbyA (=UNPACK_HL+2 on TI-85)
         ld       a,l
         pop      hl
clab1:   neg
         ret
dcs_neg: neg
         ld       (hl),$ed
         jr       dcs_c
chartable:
         .db      "XTOJE",0
         .db      0," WSNID!",0,"ZVRMHC?"
         .db      0,"YUQLGB#x~+PKFA|"
         .db      "@54321.~+"    
dirs:    .db      1,0,-1,1,-1,1,0,-1
best:    .dw      0
offsets_left:
         .db      %00000000
         .db      %10000000
         .db      %11000000
         .db      %11100000
         .db      %11110000
         .DB      %11111000
         .DB      %11111100
         .DB      %11111110
offsets_right:
         .db      %00000000
         .db      %00000001
         .db      %00000011
         .db      %00000111
         .db      %00001111              
         .db      %00011111
         .db      %00111111
         .db      %01111111
end:
         .end

