;86 Gray Scale routine by Dux Gregis
;super fast and with less flicker than any other routine

OpenGray:
 ld hl,int_start			;copy interrupt to where it'll exec
 ld de,$8f8f
 ld bc,int_end-int_start
 ldir
 di

 exx				;put counters etc into shadow registers
 ld b,$3c
 ld c,0
 ld d,3
 ld e,%110110
 ld hl,UserCounter
 exx

 ld hl,$8e00		;make 256 byte vector table pointing to int
 ld (hl),$8F
 ld bc,256
 ld d,h
 ld e,l
 inc e
 ldir

 ld a,$8E
 ld i,a			;load interrupt register with vector table
 im 2				;set interrupt mode
 ei				;start the interrupt
 ret

CloseGray:
 im 1					;reset interrupt mode for OS
 ld a,$3C				;make sure video mem is active
 out (0),a
clrMem:				;clear video mem and graph mem
 call _clrLCD
clrGrf:				;clear graph mem
 ld hl,_plotSScreen+6
 ld d,h
 ld e,l
 inc de
 ld (hl), 0
 ld bc,1024
 ldir
 ret


int_start:		;this is what is exec when user int is triggered
 ex af,af'
 exx			;use saved counters etc
 in a,(3)
 bit 1,a
 jr z,leave_int		;skip when LCD is updating
 inc (hl)			;inc user counter
 out (c),b
 dec d			
 call z,reset_int_counter
 ld a,d
 cp 1
 call z,change_pages	;flip pages every once and a while
leave_int:
 in a,(3)			;this stuff must be done or calc crashes
 rra				;mysterious stuff from the ROM
 ld a,c
 adc a,9
 out (3),a
 ld a,$0B
 out (3),a
 ex af,af'
 exx
 ei
 reti
int_end:

reset_int_counter:	;reset int counter d when it is 0
 ld d,3
change_pages:
 ld a,e
 xor b			;toggle memories
 ld b,a
 ret


;use this when you need a counter

UserCounter		equ		$8f8e

.end
