;Yugi2 by Dux Gregis		<assets@eden.rutgers.edu>
;optimized/commented by Jonah Cohen		<ComAsYuAre@aol.com>
;---------------------------------------
;new in this version:
;	smaller code
;	contrast change when reset-all
;	completely commented source
;---------------------------------------
;Yugi2 is a program which will prevent memory deletion
;by capturing keycodes specific to resetting memory
;or deleting files.  If you want to delete a file,
;use Cosine instead of Enter.  If you want to remove
;Yugi2, simply run the included program unlock.
;---------------------------------------
;if any changes are made, send a copy to Dux Gregis at the above
;e-mail address.  do not release a modified version without
;permission.




#include "asm86.h"
#include "ti86abs.inc"
#include "ti86asm.inc"
#include "Ram86.inc"

.org _asm_exec_ram

 ld hl,$5a92			;points to [sqrt]key name in memory
 rst 20h                ;[sqrt]KEY -> OP1
 rst 10h				;_findsym
 call nc,_delvar		;if prog already exists, delete it
 ld hl, code_end - code_start	;prog length
 call _CREATEPROG		;make program. name already in OP1
 ld a,b					;copy bde
 ex de,hl				;to ahl
 call $4c3f				;ahl += 2
 call _SET_ABS_DEST_ADDR	;set ahl as destination
 xor a					;clear a since ahl is size
 ld hl,code_end - code_start	;size of prog
 call _SET_MM_NUM_BYTES		;set ahl as length
 ld hl,code				;hl points to code (a is already 0)
 call _SET_ABS_SRC_ADDR		;set ahl as source
 call _mm_ldir			;24 bit ldir
 set 6,(iy+$24)			;enables program
 ret					;quit

code:
.org _asm_exec_ram-2
code_start:
.db $8e,$28				;define asm token as first prog bytes
 call $479f				;pop op1 (the calling prog push it)
 ld a,(_asm_reg_a)		;get saved a register
 push af				;save keycode
 ld a,(_CXCURAPP)		;load calc state

check_delete:
 cp $23					;check if in delete state
 jr nz,check_reset_all	;if not, check other states
 pop af					;retrieve keycode
 cp K_ENTER				;check for enter press
 jr nz,check_cos		;if not enter, check for cosine
clear_key_then_leave:
 xor a					;clear keycode
check_cos:				;secret key is cosine
 cp K_COS
 jr nz,skip_key			;if not cosine, leave
 ld a,K_ENTER			;tell system it was enter instead

skip_key:
 cp a					;set zero flag
 ret					;quit [sqrt]key

skip_and_pop:
 pop af					;remove top variable from stack
 jr skip_key			;leave

check_reset_all:
 cp $1f					;checks if state is reset all
 jr nz,check_reset_mem	;if not, check other states
 pop af					;retrieve keycode
 cp K_F4				;check for [f4]
 jr nz,skip_key			;if not, leave
 call _clrScrn			;clear screen
 ld bc,$0503
 ld (_curRow),bc		;move cursor
 ld hl,jm				;point to message
 call _puts				;display first part of message
 ld bc,$0504
 ld (_curRow),bc		;move cursor
 ld a,10				;ten is default contrast
 out (2),a				;reset contrast
 ld (_contrast),a		;save in ram for system use
 jr display_and_leave	;display message, then leave

check_reset_mem:
 cp $1d					;check if reset mem screen
 jr nz,check_self_test	;if not, check self test
 pop af					;retrieve keycode
 cp K_F4				;check for [f4]
 jr nz,skip_key			;if not, leave
 call _clrScrn			;clear screen
 ld bc,$0503
 ld (_curRow),bc		;move cursor
 ld hl,jm				;point to message
display_and_leave:
 call _puts				;display message
 call _homeup			;move cursor to upper left
 call $4ab5				;clear text
 ld a,K_F5				;system goes to home screen
 jr skip_key			;leave


check_self_test:
 cp $21					;check if self test screen
 jr nz,skip_and_pop		;if not, leave
 pop af					;retrieve keycode
 cp K_ALPHA				;check for Alpha
 jr nz,skip_key			;if not, leave
 jr clear_key_then_leave	;duh!


jm:
.db "Mem cleared",0
.db "Defaults set",0

code_end:

.end
END
