; Wak-A-Goomba v2.1
; Written by Kurt Tucker
; Last updated Oct. 23, 1998

_dispAHL = $4a33
_cphlde = $403c

#include "asm86.h"			; ASM86 include file
#include "ti86asm.inc"			; TI's standard include file

goombax = _textShadow			; 1 byte - Goomba x-coord
goombay = _textShadow+1			; 1 byte - Goomba y-coord
score = _textShadow+2			; 2 bytes - Player's total score
time = _textShadow+4			; 1 byte - Total time remaining
goombasq = _textShadow+5		; 1 byte - Goomba's square
playersq = _textShadow+6		; 1 byte - Player's square (key)
goombasc = _textShadow+7		; 1 byte - Current goomba score
temp = _textShadow+8			; 1 byte - PutSprite temp variable
delay = _textShadow+9			; 2 bytes - Delay variable
temp2 = _textShadow+11			; 1 byte - Temp. variable for time
HiScoreTemp = _textShadow+30		; 2 bytes - High score temp. var.

.org _asm_exec_ram			; Starting point for all ASM progs

; ----- AShell description -----

	nop
	jp DoThisFirst
.dw $0000
.dw Title

DoThisFirst:
	call _runindicoff		; Turn off busy indicator
	res appTextSave,(iy+appflags)	; Don't overwrite variables

TitleScreen:
	call _clrLCD			; Clear the screen
	set textInverse,(iy+textflags)	; Turn on inverse text
	ld de,$0000			; Load $0000 into HL
	ld hl,Header1			; Load Header1 into HL
      	call DTX			; Display text in HL (normal font)
	res textInverse,(iy+textflags)	; Turn off inverse text
	ld b,3 \ ld c,16
	ld hl,goomba_left_1		; Load goomba_left_1 into HL
	call PutSprite			; Display image in HL
	ld b,107
	call PutSprite
	ld b,11
	ld hl,goomba_left_2
	call PutSprite
	ld b,115
	call PutSprite
	ld de,$1219
	ld hl,TitleMsg1
     	call DMX			; Display text in HL (graph font)
	ld de,$181E
	call DMX

	ld de,$0005
	call DTX
	ld de,$0007
	call DTX

	ld de,$0D05
      	ld hl,HiScoreName
      	call DTX

	ld hl,$1005
	ld (_curRow),hl
	ld hl,(HiScore)
	ld a,0
	call _dispAHL

TitleKeyLoop:
	call GET_KEY			; Get the last key pressed
	cp K_ENTER			; If ENTER was pressed
	jp z,StartGame			; then goto StartGame
	cp K_EXIT
	jp z,Exit
	jp TitleKeyLoop

Exit:					; Exit the game
 	ld hl,ProgName			; Stuff to save high score data
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	ld de,HiScoreName-$D748+4
	add hl,de
	adc a,0
	ld de,HiScoreName
	ld b,9
RepCopy:
	push bc
	push af
	push hl
	push de
	call $46C3
	pop de
	ld a,(de)
	ld (hl),a
	pop hl
	pop af
	push de
	call $4637
	pop de
	inc de
	pop bc
	djnz RepCopy

	set 1,(iy+$0D)
	call _clrScrn
	ld hl,0				; Reset cursor position to top-left
	ld ($C00F),hl
	ret				; Return to TI-OS or shell

StartGame:				; Setup actual game screen
	call DisplayGameScreen	
	ld hl,$0000 \ ld (score),hl	; Set score to 0
	ld bc,$FFFF \ ld (delay),bc	; Set delay time to $FFFF (0.5 sec)
	ld a,60 \ ld (time),a		; Set total time to 60
	ld a,48 \ ld (temp2),a		; Set temp. time variable to 48

	ld de,$0B04			; Display "Ready...Set...GO!"
	ld hl,ReadyMessage
	call DTX
	call Delay \ call Delay
	ld de,$0B05
	call DTX
	call Delay \ call Delay
	ld de,$0C06
	call DTX
	call Delay \ call Delay

	ld de,$0C06
    	ld hl,Blank
	call DTX
	jp MainLoop

DisplayGameScreen:			; Display main game screen
	call _clrScrn
	set textInverse,(iy+textflags)
	ld de,$0B00
	ld hl,Header2
	call DTX
	ld de,$0B01
	call DTX
	res textInverse,(iy+textflags)
	ld h,1
	ld bc,$0015 \ ld de,$3F15
	call _ILine
	ld bc,$002A \ ld de,$3F2A
	call _ILine
	ld bc,$0000 \ ld de,$003F
	call _ILine
	ld bc,$1500 \ ld de,$153F
	call _ILine
	ld bc,$2A00 \ ld de,$2A3F
	call _ILine
	ld bc,$3F00 \ ld de,$3F3F
	call _ILine
	ld a,$FF
	ld ($fff0),a \ ld ($fff1),a
	ld ($fff2),a \ ld ($fff3),a
	ld ($fff4),a \ ld ($fff5),a
	ld ($fff6),a \ ld ($fff7),a
	ld ($fc00),a \ ld ($fc01),a
	ld ($fc02),a \ ld ($fc03),a
	ld ($fc04),a \ ld ($fc05),a
	ld ($fc06),a \ ld ($fc07),a
	ret

MainLoop:				; The actual game!
	ld bc,$1112 \ ld (delay),bc	; Set delay to $1112 (0.0333 sec)
	ld a,30 \ ld (goombasc),a	; Set cur. goomba score to 30
	call UpdateStats
	ld a,(time)
	cp 0
	jp z,TimeUp
	ld a,9
	call Random			; Get rand. # between 0 and 8
	inc a				; Rand. # is now between 1 and 9
	ld (goombasq),a
	call SquareToCoord
	call DrawGoomba

PlayKeyLoop1:
	call GET_KEY
	cp K_EXIT \ jp z,CheckHighScore
	cp K_MORE \ jp z,PauseGame
	cp K_1 \ jp z,Square7
	cp K_2 \ jp z,Square8
	cp K_3 \ jp z,Square9
	cp K_4 \ jp z,Square4
	cp K_5 \ jp z,Square5
	cp K_6 \ jp z,Square6
	cp K_7 \ jp z,Square1
	cp K_8 \ jp z,Square2
	cp K_9 \ jp z,Square3
PlayKeyLoop2:
	call DoTime
	ld a,(goombasc)
	call Delay
	dec a
	ld (goombasc),a
	cp 0 \ call z,ClearGoomba
	cp 0 \ jp z,MainLoop
	jr PlayKeyLoop1

PauseGame:				; Pauses the game
	call _clrLCD
	set textInverse,(iy+textflags)
	ld de,$0000
	ld hl,Header1
	call DTX
	res textInverse,(iy+textflags)
	ld de,$0604
	ld hl,PauseMessage
	call DTX
PauseKeyLoop:
	call GET_KEY
	cp K_ENTER
	call z,DisplayGameScreen
	call z,UpdateStats
	call z,DrawGoomba
	jr z,PlayKeyLoop2
	cp K_EXIT
	jp z,CheckHighScore
	jr PauseKeyLoop

UpdateStats:				; Update score and time remaining
	ld de,$0B04			; Display "Score" and "Time"
	ld hl,ScoreCounter
      	call DTX
	ld de,$0B05
	call DTX
	ld hl,$1004
	ld (_curRow),hl
	ld hl,(score) \ ld a,0
	call _dispAHL
	ld hl,$1005
	ld (_curRow),hl
	ld a,(time)
	ld l,a \ ld h,0 \ ld a,0
	call _dispAHL
	ret

SquareToCoord:				; Convert goomba sq. to x/y coord.
	ld a,(goombasq)
	cp 1 \ jr z,SetCoord1
	cp 2 \ jr z,SetCoord2
	cp 3 \ jr z,SetCoord3
	cp 4 \ jr z,SetCoord4
	cp 5 \ jr z,SetCoord5
	cp 6 \ jr z,SetCoord6
	cp 7 \ jr z,SetCoord7
	cp 8 \ jr z,SetCoord8
	jr SetCoord9

SetCoord1:
	ld a,3 \ ld (goombax),a
	ld a,3 \ ld (goombay),a
	ret
SetCoord2:
	ld a,24 \ ld (goombax),a
	ld a,3 \ ld (goombay),a
	ret
SetCoord3:
	ld a,45 \ ld (goombax),a
	ld a,3 \ ld (goombay),a
	ret
SetCoord4:
	ld a,3 \ ld (goombax),a
	ld a,24 \ ld (goombay),a
	ret
SetCoord5:
	ld a,24 \ ld (goombax),a
	ld a,24 \ ld (goombay),a
	ret
SetCoord6:
	ld a,45 \ ld (goombax),a
	ld a,24 \ ld (goombay),a
	ret
SetCoord7:
	ld a,3 \ ld (goombax),a
	ld a,45 \ ld (goombay),a
	ret
SetCoord8:
	ld a,24 \ ld (goombax),a
	ld a,45 \ ld (goombay),a
	ret
SetCoord9:
	ld a,45 \ ld (goombax),a
	ld a,45 \ ld (goombay),a
	ret	

DrawGoomba:				; Draw goomba at (goombax,goombay)
	ld a,(goombax) \ ld b,a
	ld a,(goombay) \ ld c,a
	ld hl,goomba_left_1
	call PutSprite
	ld a,b \ add a,8 \ ld b,a	; B = B + 8
	ld hl,goomba_left_2
	call PutSprite
	ret
	
Square1:
	ld a,1 \ jr CheckSquare
Square2:
	ld a,2 \ jr CheckSquare
Square3:
	ld a,3 \ jr CheckSquare
Square4:
	ld a,4 \ jr CheckSquare
Square5:
	ld a,5 \ jr CheckSquare
Square6:
	ld a,6 \ jr CheckSquare
Square7:
	ld a,7 \ jr CheckSquare
Square8:
	ld a,8 \ jr CheckSquare
Square9:
	ld a,9 \ jr CheckSquare

CheckSquare:				; Check player's square for goomba
	ld (playersq),a
	ld a,(goombasq) \ ld b,a
	ld a,(playersq)
	cp b
	jp nz,PlayKeyLoop2

WhackGoomba:				; Whack goomba at (goombax,goombay)
	ld a,(goombax) \ ld b,a
	ld a,(goombay) \ ld c,a
	ld hl,goomba_squash_1
	call PutSprite
	ld a,b \ add a,8 \ ld b,a	; B = B + 8
	ld hl,goomba_squash_2
	call PutSprite
	ld e,1 \ call WhackDelay
	ld a,(goombasc)			; Increase player's score
	ld d,0 \ ld e,a
	ld hl,(score)
	add hl,de
	ld (score),hl
	call ClearGoomba
	jp MainLoop
WhackDelay:
	call Delay 
	call DoTime
	inc e
	ld a,e
	cp 8
	ret z
	jp WhackDelay

ClearGoomba:				; Clear goomba at (goombax,goombay)
	ld a,(goombax) \ ld b,a
	ld a,(goombay) \ ld c,a
	ld hl,blank
	call PutSprite
	ld a,b \ add a,8 \ ld b,a	; B = B + 8
	ld hl,blank
	call PutSprite
	ld a,0
	ret

DoTime:					; Deduct time remaining
	ld a,(temp2)
	dec a
	ld (temp2),a
	cp 0				; Is temp2 equal to 0?
	jp z,SubtractOneSecond		; If so, goto SubtractOneSecond
	ret				; Else return
SubtractOneSecond:			; Subtract one second from time
	ld a,(time)
	dec a
	ld (time),a
	ld a,30 \ ld (temp2),a		; Reset temp2
	call UpdateStats
	ret

TimeUp:					; Time's up!
	ld de,$0C07
	ld hl,TimeUpMessage
      	call DTX
TimeUpKeyLoop:
	call GET_KEY
	cp K_ENTER
	jr z,CheckHighScore
	jr TimeUpKeyLoop

CheckHighScore:				; Check if player beat high score
	call _clrLCD
	ld hl, HiScore
	call LD_HL_MHL
	ld de,(score)
	ld (HiScoreTemp),de
	call CP_HL_DE
	ret nc
	ld hl,HiScore
	ex de,hl
	ld hl,HiScoreTemp
	ld c,2
	ldi
	ldi
	ld hl,$0300
	ld (_curRow),hl
	ld hl,HiScr
	call _puts
	ld de,$0A1F
	ld (_penCol),de
	call  _vputs
	ld hl, $0903
	ld (_curRow),hl
	ld hl,HiScoreName
	ld c,3
	push hl
	ld d,$41
	ld a,(_curCol)
	ld e,a
	ld b,0
	jr InvLet
WaitKey:
	push bc
	push de
	push hl
	call GET_KEY
	pop hl
	pop de
	pop bc
	cp K_UP
	jr z,LetUp
	cp K_DOWN
	jr z,LetDown
	cp K_SECOND
	jr nz,WaitKey
	ld (hl),d
	inc hl
	ld a,d
	call _putc
	inc e
	inc b
	ld a,c
	cp b
	jr nz,InvLet
	ld (hl),0
	pop hl
	jp Exit
LetUp:
 	inc d
	ld a,d
	cp $5B
	jr nz,InvLet
	ld d,$41
	jr InvLet
LetDown:
	dec d
	ld a,d
	cp $40
	jr nz,InvLet
	ld d,$5A
InvLet:
	set 3,(iy+$05)
	ld a,d
	call _putc
	ld a,e
	ld (_curCol),a
	res 3,(iy+$05)
	jr WaitKey


; ----- Subroutines -----

PutSprite: 			; Puts a sprite stored at (HL) at B,C
      ld a,b        		; **
      cp 0          		; **
      jp m,PS_Minus 		; **
      jr PS_NotMinus		; **
PS_Minus:
      add a,128      		; **
      ld b,a        		; **
PS_NotMinus:
      ld (temp),a 		; **
      push bc         		; save BC
      push de         		; save DE
      push hl			; save HL
      push hl			; save HL
      ld e,b
      ld d,c
      call FindPixel
      ld de,$FC00		; DE points to VID MEM
      ex de,hl                  ; DE = VID MEM + PIXEL LOC
      pop hl                    ; HL = PIC LOC
      ld b,(hl)                 ; get first byte from PIC LOC (width)
      inc hl                    ; HL = next byte in PIC LOCATION
      ld c,(hl)                 ; get second byte from PIC LOC (height)
      inc hl                    ; HL = START OF PIC
      push hl                   ; save HL
      pop ix			; IX = START OF PIC
      ex de,hl                  ; HL = VID MEM + PIXEK LOC DE = START OF PIC
PS_NewRow:
      push bc                   ; save BC
      ld d,(ix)			; D = next byte of PIC
      inc ix			; IX points to next byte
      push af                   ; save AF
      push hl			; save HL
PS_NewCol:
      rl d			; Rotate Left D
      ld e,a			; e = a
      jr nc,PS_NoPixel        	; if No Carry then goto NoPixel
      ;************ can be OR or XOR *********************
      or (hl)                   ; a = a or (hl)
      ;***************************************************
      ld (hl),a                 ; hl = hl or a (basically)
      jr PS_NextPixel
PS_NoPixel:
      cpl 
      and (hl)
      ld (hl),a
PS_NextPixel:
      ld a,e                    ; get A back
      rrca                      ; rotate right circular
      jr nc,PS_SameByte         ; if no carry then same byte
      inc hl                    ; else HL points to next byte in PIC
      push af           	; **
      ld a,(temp)       	; **
      add a,8           	; **
      cp 128            	; **
      jp p,PSWrap       	; **
      jr PSEndWrap      	; **
PSWrap:
      push bc			; .
      ld bc,$fff0		; .
      add hl,bc			; .
      pop bc        		; HL=HL-15
PSEndWrap:
      pop af
PS_SameByte:
      djnz PS_NewCol            ; go to next column
      pop hl
      pop af      
      ld de,16
      add hl,de
      pop bc
      dec c
      jr nz,PS_NewRow
      pop hl
      pop de
      pop bc
      ret

FindPixel:
        ld a,e
        and $07         	; a = bit offset
        ld b,0
        ld c,a
        ld hl,FP_Bits
        add hl,bc
        ld b,(hl)       	; b = bitmask for (hl)
;56 t-states up to this point
        ld a,d
        rlca            	; multiply y by 4
        rlca
        ld l,a
        ld h,0
        add hl,hl       	; multiply y by 4 again
        add hl,hl       	; because there are 16 bytes in a pixel row
        ld a,e
        rrca            	; divide x by 8 (8 pixels/byte)
        rrca
        rrca
        and $0F
        ld c,a
        ld a,b          	; now a = bitmask for (hl)
        ld b,$FC
        add hl,bc       	; hl -> byte in LCD memory
;150 t-states up to this point
        ret
FP_Bits: .db $80,$40,$20,$10,$08,$04,$02,$01

Random: 	       		; Creates a random number 0 <= x < A
 	push bc
 	push de
 	push hl
 	ld b,a
 	ld a,r
 	add a,a
 	ld hl,0
 	ld d,0
 	ld e,a
RMul:
 	add hl,de
 	djnz RMul
 	ld a,h
 	pop hl
 	pop de
 	pop bc
 	ret

Delay:
	push af
	push bc
	ld bc,(delay)
DelayLoop:
	dec bc
	ld a,b
	or c
	jr nz,DelayLoop
	pop bc
	pop af
	ret

; ----- Sprites -----

goomba_left_1:
	.db 8,16
	.db 00000011b
	.db 00001100b
	.db 00011110b
	.db 00001010b
	.db 00010001b
	.db 01100010b
	.db 10000010b
	.db 10000000b
	.db 10001111b
	.db 01000000b
	.db 00111111b
	.db 00000100b
	.db 01111000b
	.db 10111100b
	.db 11111100b
	.db 11111111b
goomba_left_2:
	.db 8,16
	.db 11000000b
	.db 00110000b
	.db 01111000b
	.db 01010000b
	.db 10001000b
	.db 01000110b
	.db 01000001b
	.db 00000001b
	.db 11110001b
	.db 00000010b
	.db 11111100b
	.db 00010000b
	.db 00001000b
	.db 00011110b
	.db 00111101b
	.db 11111111b

goomba_squash_1:
	.db 8,16
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000011b
	.db 00011100b
	.db 01111111b
	.db 10000110b
	.db 10000000b
	.db 01111111b
	.db 00100000b
	.db 01111111b
	.db 11111111b
goomba_squash_2:
	.db 8,16
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 11000000b
	.db 00111000b
	.db 11111110b
	.db 01100001b
	.db 00000001b
	.db 11111110b
	.db 00000100b
	.db 11111110b
	.db 11111111b

blank:
	.db 8,16
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b

; ----- Text Strings and Other Data -----


ProgName:	.db $12,8,"wakagmba"

Title:		.db "Wak-A-Goomba v2.1",0
Header1:	.db "Wak-A-Goomba     v2.1",0
Header2:	.db " Wak-A-   ",0
Header3:	.db "   Goomba ",0

TitleMsg1:	.db "Written by Kurt Tucker",0
TitleMsg2:	.db "yosterisle@aol.com",0
TitleMsg3:	.db "High Score:",0
TitleMsg4:	.db " Press ENTER to play",0

ReadyMessage:	.db " Ready... ",0
SetMessage:	.db " Set...   ",0
GoMessage:	.db "GO!",0

PauseMessage:	.db "* PAUSE *",0

ScoreCounter:	.db "Score     ",0
TimeCounter:	.db "Time      ",0
TimeUpMessage:	.db "TIME UP!",0



Blank:		.db "      ",0

DTX:
 	ld (_curRow),de
	jp _puts			; Display text in HL (normal font)
DMX:
 	ld (_penCol),de
	jp _vputs			; Display text in HL (graph font)

HiScoreName:
 .db 45,45,45,"   ",0
HiScore:
 .dw 0
HiScr:	    .db "NEW HIGH SCORE!",0
EnterInit:  .db "ENTER YOUR INITIALS:",0
.end
END