#include "ti86asm.inc"
#include "ti86und.inc"
#include "asm86.h"

;__________________________________________________________________________;
;______________________________VARIABLES___________________________________;
;__________________________________________________________________________;

#define PAGE1_BPL1         $3C
#define PAGE1_BPL2         $37

_user_int_ram EQU $d2fd

VideoDraw = $F300
GrayDraw1 = $FC00
GrayDraw2 = $F700

which_plain = _textShadow
old_plain = _textShadow + 1
which_box = _textShadow + 2
old_box = _textShadow + 3
X1select = _textShadow + 4
Y1select = _textShadow + 5
X2select = _textShadow + 6
Y2select = _textShadow + 7
X3select = _textShadow + 8
Y3select = _textShadow + 9
X4select = _textShadow + 10
Y4select = _textShadow + 11
which_player = _textShadow +12
play_table = _textShadow + 13
how_many = _textShadow + 40
where = _textShadow + 41
do_point = _textShadow +43
pointplayer2 = _textShadow +44
pointplayer1 = _textShadow +45
mode = _textShadow +46
TI_numb = _textShadow +47
which_test = _textShadow +48
ever_play = _textShadow +49
where_poss = _textShadow +50
possible = _textShadow +52


;__________________________________________________________________________;
;_________________________________MENU_____________________________________;
;__________________________________________________________________________;

start:

.org _asm_exec_ram

	call _runindicoff
	call _flushallmenus
	call OpenGray

menu:
	call ClearPage
	call _homeup
	ld hl,title
	set textInverse,(iy+textflags)
	call _puts
	res textInverse,(iy+textflags)
	ld de,$3A00
	ld	(_penCol),de
	call _vputs
	ld de,$0502
	ld	(_curRow),de
	inc e
	call _puts
	ld	(_curRow),de
	inc e
	call _puts
	ld d,$08
	ld	(_curRow),de
	inc e
	call _puts
	ld	(_curRow),de
	call _puts
	ld bc,1024
	ld hl,$FC00
	ld de,$F700
	ldir
	ld hl,go_to
	push hl
	ld c,5
DoMenuFirst:
	ld b,2
DoMenuBar:
	call DoMenuInvBar
DoMenuL:
	call $4068
	cp K_UP
	jr z,DoMenuUp
	cp K_DOWN
	jr z,DoMenuDown
	cp K_PLUS
	call z,inc_contrast
	cp K_MINUS
	call z,dec_contrast
	cp K_SECOND
	jr z,DoMenuSelect
	cp K_ENTER
	jr nz,DoMenuL
DoMenuSelect:
	pop hl
	ld d,0
	ld e,b
	dec e
	sla e
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	jp (hl)
DoMenuUp:
	call DoMenuInvBar
	dec b
	ld a,b
	cp 1
	jr nz,DoMenuBar
	ld b,c
	jr DoMenuBar
DoMenuDown:
	call DoMenuInvBar
	ld a,c
	cp b
	jr z,DoMenuFirst
	inc b
	jr DoMenuBar
DoMenuInvBar:
	push hl
	push bc
	ld h,b
	ld l,128
	call 4547h
	ld de,$fc00
	add hl,de
	ex de,hl
	call DoMenuInv
	pop bc
	pop hl
	ret
DoMenuInv:
	ld b,8*16
	push de
	push de
DoMenuIL:
	ld a,(de)
	cpl
	ld (de),a
	inc de
	djnz DoMenuIL
	pop hl
	ld de,$500
	sbc hl,de
	pop de
	ld b,8*16
domenuil:
	ld a,(de)
	or (hl)
	ld (de),a
	inc de
	inc hl
	djnz domenuil 
	ret

;__________________________________________________________________________;
;_________________________________GAME_____________________________________;
;__________________________________________________________________________;

;-------------------------prepare_the_background---------------------------;

one_player:
	call ClearPage
	ld hl,_textShadow
	ld b,168
	call _ldhlz
	ld a,1
	ld (mode),a
	ld a,2
	ld (TI_numb),a
	call game2
	ld de,$F70E
	ld b,40
	ld hl,spriTI
	call disp_number
	jp variable_init

game:
	call ClearPage
	ld hl,_textShadow
	ld b,168
	call _ldhlz
	call game2
	jp variable_init
game2:
	ld hl,$C9FA
	ld de,$C9FB
	ld (hl),0
	ld bc,1023
	ldir
	ld hl,$F300
	ld de,$F301
	ld (hl),0
	ld bc,1023
	ldir
	call background
	ld bc,1024
	ld hl,$FC00
	ld de,$F700
	ldir
	ld bc,$FC00
	ld de,$0202
	ld hl,$4C02
	call FLine
	ld de,$233D
	ld hl,$6D3D
	call FLine
	ld de,$0238
	ld hl,$4C38
	call FLine
	ld bc,$F700
	ld de,$6D07
	ld hl,$2307
	call FLine
	ld b,41
	ld a,%11111111
	ld hl,$FC0E
	ld de,$000F
	call name_bkg
	ld b,20
	ld hl,$F99E
	call name_bkg
	inc b
	ld hl,$FF2E
	call name_bkg
	ld b,3
	ld hl,$FFDE
	call name_bkg
	inc b
	xor a
	ld hl,$FA2E
	call name_bkg
	ld de,$F70E
	call disp_players
	ld de,$F70F
	call disp_players
	ld b,8
	ld de,$F90E
	ld hl,number2
	call disp_number
	ld b,8
	ld de,$F90F
	ld hl,number1
	call disp_number
	ret

;---------------------------initialise_variable----------------------------;

variable_init:
	ld bc,$F700
	ld h,$33
	ld a,h
	ld (X1select),a
	ld l,$17
	ld a,l
	ld (Y1select),a
	ld d,$33
	ld a,d
	ld (X2select),a
	ld e,$27
	ld a,e
	ld (Y2select),a
	call FLine2
	ld h,$3C
	ld a,h
	ld (X3select),a
	ld l,$18
	ld a,l
	ld (Y3select),a
	ld d,$3C
	ld a,d
	ld (X4select),a
	ld e,$28
	ld a,e
	ld (Y4select),a
	call FLine2
	ld a,2
	ld (which_player),a
	ld (which_plain),a
	xor a
	ld (how_many),a
	ld a,5
	ld (which_box),a
	call select
	jp test_end

;--------------------------key_loop_of_the_game----------------------------;

mainloop:
	call disp_select
	call _getky
	cp K_6
	jr z,up
	cp K_4
	jr z,down
	cp K_8
	jp z,left
	cp K_2
	jp z,right
	cp K_ENTER
	jp z,disp_ball
	cp K_PLUS
	call z,inc_contrast
	cp K_MINUS
	call z,dec_contrast
	cp K_MORE
	call z,pause
	cp K_EXIT
	jp z,menu
	cp K_RIGHTPAR
	jr z,plain3
	cp K_LEFTPAR
	jr z,plain2
	cp K_EE
	jr nz,mainloop

;----------------------------selector_movement-----------------------------;

plain1:
	ld a,(old_plain)
	dec a
	jr z,mainloop
	ld a,1
	ld (which_plain),a
	call select
	jr mainloop
plain2:
	ld a,(old_plain)
	cp 2
	jr z,mainloop
	ld a,2
	ld (which_plain),a
	call select
	jr mainloop
plain3:
	ld a,(old_plain)
	cp 3
	jr z,mainloop
	ld a,3
	ld (which_plain),a
	call select
	jr mainloop
up:
	ld a,(which_box)
	add a,3
	sub 10
	jr z,mainloop
	jr nc,mainloop
	ld a,(which_box)
	ld (old_box),a
	add a,3
	ld (which_box),a
	call select
	jp mainloop
down:
	ld a,(which_box)
	sub 3
	jp z,mainloop
	jp c,mainloop
	ld a,(which_box)
	ld (old_box),a
	sub 3
	ld (which_box),a
	call select
	jp mainloop
left:
	ld a,(which_box)
	dec a
	jp z,mainloop
	ld a,(which_box)
	ld (old_box),a
	dec a
	ld (which_box),a
	call select
	jp mainloop
right:
	ld a,(which_box)
	inc a
	cp 10
	jp z,mainloop
	ld a,(which_box)
	ld (old_box),a
	inc a
	ld (which_box),a
	call select
	jp mainloop

;--------------------------put_the_ball_and_test---------------------------;

disp_ball:
	ld a,(which_box)
	ld b,a
	ld hl,play_table-1
selecthole:
	inc hl
	djnz selecthole
	ld a,(which_plain)
	dec a
	jr z,selecthole2
	dec a
	jp z,changehole2
	jp changehole3
selecthole2:
	ld a,(hl)
	or a
	jp nz,mainloop

selecthole2b:

	ld a,(which_player)
	ld (hl),a
	ld (where),hl
	call test
	ld a,(do_point)
	or a
	jp z,test_end
	ld hl,(where)
	ld (hl),a
	xor a
	ld (do_point),a
test_end:
	ld hl,(pointplayer2)
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld de,point0
	add hl,de
	ld de,$FEAE
	ld b,8
	call disp_number
	ld hl,(pointplayer1)
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld de,point0
	add hl,de
	ld de,$FEAF
	ld b,8
	call disp_number
	call disp1
	ld a,(which_player)
	inc a
	cp 3
	jr z,change_player
selecthole3:
	ld (which_player),a
	call which_p_p
	ld a,(how_many)
	inc a
	cp 28
	jp z,which_player_win
	ld (how_many),a
	ld a,(mode)
	dec a
	jr z,TIplay

selecthole4:	
	jp mainloop

changehole3:
	ld de,$0009
	add hl,de
changehole2:
	ld de,$0009
	add hl,de
	jp selecthole2

change_player:
	ld a,1
	jr selecthole3


TIplay:
	xor a
	ld (ever_play),a
	ld a,(which_player)
	ld b,a
	ld a,(TI_numb)
	cp b
	jr nz,selecthole4
	dec a
	or a
	jr nz,TIplay2
	ld a,2
TIplay2:
	ld (which_test),a
	call test
	ld a,(ever_play)
	or a
	jr nz,TIplayed
	ld a,(TI_numb)
	ld (which_test),a
	call test
	ld a,(ever_play)
	or a
	jr nz,TIplayed
TIplay3:
	ld a,(UserCounter)
	or a
	jr z,TIplay3
	cp 27
	jr nc,TIplay3
	ld hl,play_table
	ld d,0
	ld e,a
	add hl,de
	ld a,(hl)
	or a
	jr nz,TIplay3
	ld (where_poss),hl

TIplayed:
	xor a
	ld (which_test),a
	ld hl,(where_poss)
	jp selecthole2b

	
;-----------------------------disp the ball--------------------------------;

disp1:
	ld a,27
	ld bc,play_loc
	ld hl,play_table
disp2:
	push hl
	push af
	push bc
	push bc
	ld b,(hl)
	inc b
	ld hl,spriteB0-24
	ld de,$0018
disp3:
	add hl,de
	djnz disp3
	pop bc
	push hl
	ld h,b
	ld l,c
	ld b,(hl)
	inc hl
	ld c,(hl)
	pop hl
	call GraySprite
	pop bc
	pop af
	pop hl
	inc hl
	inc bc
	inc bc
	dec a
	cp 0
	jr nz,disp2
	ret

;---------------------------disp_the_selector------------------------------;

select:
clear_select:
	ld a,(old_box)
	ld b,a
	ld hl,clear_selectloc-8
	ld de,$0008
clear_select_box:
	add hl,de
	djnz clear_select_box
	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld e,(hl)
	inc hl
	push hl
	ld a,(old_plain)
	dec a
	jr z,clear_select2
	dec a
	call z,clear_changeplain2
	ld a,(old_plain)
	cp 3
	call z,clear_changeplain3
clear_select2:
	ld h,0
	call _ILine
	pop hl
	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld e,(hl)
	ld a,(old_plain)
	dec a
	jr z,clear_select3
	dec a
	call z,clear_changeplain2
	ld a,(old_plain)
	cp 3
	call z,clear_changeplain3
clear_select3:
	ld h,0
	call _ILine
	ld a,(which_box)
	ld (old_box),a
	ld a,(which_plain)
	ld (old_plain),a
	ld bc,$F700
	call lineF7
	ld a,(which_box)
	ld b,a
	ld hl,selectloc-2
selectbox:
	inc hl
	inc hl
	djnz selectbox
	ld b,(hl)
	inc hl
	ld c,(hl)
	ld a,(which_plain)
	dec a
	jr z,select2
	dec a
	jp z,changeplain2
	jp changeplain3
select2:
	ld d,1
	ld a,9
select3:
	call _IPoint
	dec c
	dec c
	dec a
	jr nz,select3
	ld a,b
	add a,$09
	ld b,a
	ld d,1
	ld a,9
select4:
	call _IPoint
	inc c
	inc c
	dec a
	jr nz,select4
loc_select:
	ld a,(which_box)
	ld b,a
	ld hl,loc_selectloc-8
	ld de,$0008
loc_select_box:
	add hl,de
	djnz loc_select_box
	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld e,(hl)
	inc hl
	push hl
	ld a,(which_plain)
	dec a
	jr z,loc_select2
	dec a
	call z,clear_changeplain2
	ld a,(which_plain)
	cp 3
	call z,clear_changeplain3
loc_select2:
	ld a,b
	ld (X1select),a
	ld a,c
	ld (Y1select),a
	ld a,d
	ld (X2select),a
	ld a,e
	ld (Y2select),a
	pop hl
	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld e,(hl)
	ld a,(which_plain)
	dec a
	jr z,loc_select3
	dec a
	call z,clear_changeplain2
	ld a,(which_plain)
	cp 3
	call z,clear_changeplain3
loc_select3:
	ld a,b
	ld (X3select),a
	ld a,c
	ld (Y3select),a
	ld a,d
	ld (X4select),a
	ld a,e
	ld (Y4select),a
	call disp1
	call background
	ld bc,$FC00
	ld de,$0238
	ld hl,$4C38
	call FLine
	ld bc,$F700
	call lineF7
	ret 

changeplain3:
	ld a,b
	add a,$25
	ld b,a
changeplain2:
	ld a,b
	add a,$25
	ld b,a
	jp select2

clear_changeplain3:
	ld a,b
	add a,$25
	ld b,a
	ld a,d
	add a,$25
	ld d,a
clear_changeplain2:
	ld a,b
	add a,$25
	ld b,a
	ld a,d
	add a,$25
	ld d,a
	ret

;----------------------------which_player_win------------------------------;

which_player_win:
	xor a
	ld b,64
	ld hl,$FC06
	call name_bkg
	ld a,$ff
	ld b,64
	ld hl,$F706
	call name_bkg
	ld a,(pointplayer2)
	ld b,a
	ld a,(pointplayer1)
	sub b
	jr z,no_winner
	jr nc,player1_wins
	jr c,player2_wins

player1_wins:
	ld hl,number1
	push hl
	jr wins


player2_wins:
	ld a,(mode)
	dec a
	jr z,TI_wins
	ld hl,number2
	push hl
	jr wins

TI_wins:
	ld de,$FD47
	ld b,25
	ld hl,spriTI
	call disp_number
	jr winsA

no_winner:
	ld de,$FCD7
	call disp_players
	ld a,(mode)
	dec a
	jr nz,no_winner2
	ld b,8
	ld de,$FEC7
	ld hl,number1
	call disp_number
	jr no_winner1	

no_winner2:
	ld b,8
	ld de,$FEC7
	ld hl,spriteS
	call disp_number
no_winner1:
	ld b,24
	ld de,$FD46
	ld hl,spriteTIE
	call disp_number
	jr winsB

wins:
	ld de,$FCD7
	call disp_players
	ld b,8
	ld de,$FED7
	pop hl
	call disp_number
winsA:
	ld b,32
	ld de,$FD06
	ld hl,spriteWIN
	call disp_number
winsB:
	call _getky
	cp K_ENTER
	jp z,menu
	jr winsB

;---------------------------------pause-----------------------------------;

pause:
	res 2,(iy+$23)
	ld a,1
	out (3),a
	halt
	ld a,11
	out (3),a        
	res onInterrupt,(iy+onflags)
	set 2,(iy+$23)
	ret

;__________________________________________________________________________;
;__________________________________HELP____________________________________;
;__________________________________________________________________________;

help:
	call ClearPage
	res 2,(iy+$23)
	call _homeup
	ld hl,t_help
	set textInverse,(iy+textflags)
	call _puts
	res textInverse,(iy+textflags)
	ld b,9
	ld de,$0200
help2:
	ld a,6
	add a,d
	ld d,a
	ld	(_penCol),de
	call _vputs
	djnz help2
	ld bc,1024
	ld hl,$FC00
	ld de,$F700
	ldir
helploop:
	call _getky
	cp K_PLUS
	call z,inc_contrast
	cp K_MINUS
	call z,dec_contrast
	cp K_EXIT
	jr nz,helploop
	set 2,(iy+$23)
	jp menu

;__________________________________________________________________________;
;__________________________________EXIT____________________________________;
;__________________________________________________________________________;

exit:
	call CloseGray
	ld hl,$C9FA
	ld de,$C9FB
	ld (hl),0
	ld bc,1023
	ldir
	call _clrScrn
	call _homeup
	ret

;__________________________________________________________________________;
;________________________________ROUTINES__________________________________;
;__________________________________________________________________________;

;-------------------------------which_p_p----------------------------------;

which_p_p:
	ld a,(which_player)
	dec a
	jr z,which_p_p1
	ld b,120
	ld c,52
	ld hl,spritempty
	call GraySprite
	ld b,112
	ld c,52
	ld hl,spriteB2
	call GraySprite
	ret

which_p_p1:
	ld b,120
	ld c,52
	ld hl,spriteB1
	call GraySprite
	ld b,112
	ld c,52
	ld hl,spritempty
	call GraySprite
	ret

;-----------------------------disp_select----------------------------------;

disp_select:
	ld a,(UserCounter)
	cp 40
	ret nz
	ld bc,$FC00
lineF7:
	ld a,(X1select)
	ld h,a
	ld a,(Y1select)
	ld l,a
	ld a,(X2select)
	ld d,a
	ld a,(Y2select)
	ld e,a
	call FLine2
	ld a,(X3select)
	ld h,a
	ld a,(Y3select)
	ld l,a
	ld a,(X4select)
	ld d,a
	ld a,(Y4select)
	ld e,a
	call FLine2
	ret

;------------------------------disp_players--------------------------------;

disp_players:
	ld b,32
	ld hl,players
disp_number:
	ldi
	push hl
	ld hl,$000F
	add hl,de
	ld d,h
	ld e,l
	pop hl
	djnz disp_number
	ret

;----------------------------------test------------------------------------;

test:
	ld hl,play_table
	ld bc,play_table+9
	ld de,play_table+18
	call all_test
	ld hl,play_table+1
	ld bc,play_table+10
	ld de,play_table+19
	call all_test
	ld hl,play_table+2
	ld bc,play_table+11
	ld de,play_table+20
	call all_test
	ld hl,play_table+3
	ld bc,play_table+12
	ld de,play_table+21
	call all_test
	ld hl,play_table+4
	ld bc,play_table+13
	ld de,play_table+22
	call all_test
	ld hl,play_table+5
	ld bc,play_table+14
	ld de,play_table+23
	call all_test
	ld hl,play_table+6
	ld bc,play_table+15
	ld de,play_table+24
	call all_test
	ld hl,play_table+7
	ld bc,play_table+16
	ld de,play_table+25
	call all_test
	ld hl,play_table+8
	ld bc,play_table+17
	ld de,play_table+26
	call all_test
	ld hl,play_table
	ld bc,play_table+12
	ld de,play_table+24
	call all_test
	ld hl,play_table+1
	ld bc,play_table+13
	ld de,play_table+25
	call all_test
	ld hl,play_table+2
	ld bc,play_table+14
	ld de,play_table+26
	call all_test
	ld hl,play_table+6
	ld bc,play_table+12
	ld de,play_table+18
	call all_test
	ld hl,play_table+7
	ld bc,play_table+13
	ld de,play_table+19
	call all_test
	ld hl,play_table+8
	ld bc,play_table+14
	ld de,play_table+20
	call all_test
	ld hl,play_table
	ld bc,play_table+10
	ld de,play_table+20
	call all_test
	ld hl,play_table+3
	ld bc,play_table+13
	ld de,play_table+23
	call all_test
	ld hl,play_table+6
	ld bc,play_table+16
	ld de,play_table+26
	call all_test
	ld hl,play_table+2
	ld bc,play_table+10
	ld de,play_table+18
	call all_test
	ld hl,play_table+5
	ld bc,play_table+13
	ld de,play_table+21
	call all_test
	ld hl,play_table+8
	ld bc,play_table+16
	ld de,play_table+24
	call all_test
	ld hl,play_table
	ld bc,play_table+1
	ld de,play_table+2
	call all_test
	ld hl,play_table+3
	ld bc,play_table+4
	ld de,play_table+5
	call all_test
	ld hl,play_table+6
	ld bc,play_table+7
	ld de,play_table+8
	call all_test
	ld hl,play_table+9
	ld bc,play_table+10
	ld de,play_table+11
	call all_test
	ld hl,play_table+12
	ld bc,play_table+13
	ld de,play_table+14
	call all_test
	ld hl,play_table+15
	ld bc,play_table+16
	ld de,play_table+17
	call all_test
	ld hl,play_table+18
	ld bc,play_table+19
	ld de,play_table+20
	call all_test
	ld hl,play_table+21
	ld bc,play_table+22
	ld de,play_table+23
	call all_test
	ld hl,play_table+24
	ld bc,play_table+25
	ld de,play_table+26
	call all_test
	ld hl,play_table
	ld bc,play_table+3
	ld de,play_table+6
	call all_test
	ld hl,play_table+1
	ld bc,play_table+4
	ld de,play_table+7
	call all_test
	ld hl,play_table+2
	ld bc,play_table+5
	ld de,play_table+8
	call all_test
	ld hl,play_table+9
	ld bc,play_table+12
	ld de,play_table+15
	call all_test
	ld hl,play_table+10
	ld bc,play_table+13
	ld de,play_table+16
	call all_test
	ld hl,play_table+11
	ld bc,play_table+14
	ld de,play_table+17
	call all_test
	ld hl,play_table+18
	ld bc,play_table+21
	ld de,play_table+24
	call all_test
	ld hl,play_table+19
	ld bc,play_table+22
	ld de,play_table+25
	call all_test
	ld hl,play_table+20
	ld bc,play_table+23
	ld de,play_table+26
	call all_test
	ld hl,play_table
	ld bc,play_table+4
	ld de,play_table+8
	call all_test
	ld hl,play_table+2
	ld bc,play_table+4
	ld de,play_table+6
	call all_test
	ld hl,play_table+9
	ld bc,play_table+13
	ld de,play_table+17
	call all_test
	ld hl,play_table+11
	ld bc,play_table+13
	ld de,play_table+15
	call all_test
	ld hl,play_table+18
	ld bc,play_table+22
	ld de,play_table+26
	call all_test
	ld hl,play_table+20
	ld bc,play_table+22
	ld de,play_table+24
	call all_test
	ld hl,play_table
	ld bc,play_table+13
	ld de,play_table+26
	call all_test
	ld hl,play_table+8
	ld bc,play_table+13
	ld de,play_table+18
	call all_test
	ld hl,play_table+2
	ld bc,play_table+13
	ld de,play_table+24
	call all_test
	ld hl,play_table+6
	ld bc,play_table+13
	ld de,play_table+20
	call all_test
	ret

;--------------------------------all_test----------------------------------;

all_test:
	ld a,(which_test)
	or a
	jr nz,TItest
	ld a,(which_player)
	cp (hl)
	ret nz
	push hl
	ld h,d
	ld l,e
	cp (hl)
	pop hl
	ret nz
	push hl
	ld h,b
	ld l,c
	cp (hl)
	pop hl
	ret nz
	inc a
	inc a
	ld (do_point),a
	ld (hl),a
	ld h,d
	ld l,e
	ld (hl),a
	ld h,b
	ld l,c
	ld (hl),a
	ld a,(which_player)
	ld hl,(where)
	ld (hl),a
	dec a
	jr z,point_player1
point_player2:
	ld a,(pointplayer2)
	inc a
	ld (pointplayer2),a
	ret
point_player1:
	ld a,(pointplayer1)
	inc a
	ld (pointplayer1),a
	ret

TItest:
	ld a,(ever_play)
	or a
	ret nz
	xor a
	ld (possible),a
	ld a,(which_test)
	push hl
	cp (hl)
	call z,there_one
	ld h,b
	ld l,c
	cp (hl)
	call z,there_one
	ld h,d
	ld l,e
	cp (hl)
	call z,there_one
	pop hl
	ld a,(possible)
	cp 2
	ret nz
	xor a
	cp (hl)
	jr z,TItest2
	ld h,b
	ld l,c
	cp (hl)
	jr z,TItest2
	ld h,d
	ld l,e
	cp (hl)
	ret nz

TItest2:
	inc a
	ld (ever_play),a
	ld (where_poss),hl
	ret

there_one:
	push af
	ld a,(possible)
	inc a
	ld (possible),a
	pop af
	ret


;-------------------------------contrast-----------------------------------;

inc_contrast:
	push af
	ld a,($C008)
	cp 30
	jr z,end_contrast
	inc a
	ld ($C008),a
	out (2),a
	jr end_contrast

dec_contrast:
	push af
	ld a,($C008)
	or a
	jr z,end_contrast
	dec a
	ld ($C008),a
	out (2),a
	jr end_contrast

end_contrast:
	pop af
	ret

;--------------------------------FLine-------------------------------------;

FLine2:
	ld a,(change_xor)
	ld (ch1),a
	ld (ch2),a
	ld (ch3),a
	ld (ch4),a
	ld (ch5),a
	jr FLine3
FLine:
	ld a,(change_or)
	ld (ch1),a
	ld (ch2),a
	ld (ch3),a
	ld (ch4),a
	ld (ch5),a

FLine3:
	push bc
	push de
	push hl
	push bc
	ld a,h
	cp d
	jr nc,DXpos
	ex de,hl
DXpos:
	ld b,d
	ld c,e
	pop de
	push hl
	call FindPixel
	add hl,de
	ex (sp),hl
	ld e,c
	ld c,a
	ld a,h
	sub b
	ld b,a
	ld a,l
	sub e
	ld de,16
	jr nc,DYpos
	neg
	ld de,-16
DYpos:
	push af
	sub b
	jr nc,DY_Greater
	add a,a
	neg
	ld (x_ai+1),a
	pop af
	add a,a
	ld (XDNeg+1),a
	sub b
	pop hl
	push af
	ld a,c
ch1:
	or (hl)
	ld (hl),a
	pop af
	bit 7,a
	jr nz,XDNeg
XNewRow:
	add hl,de
x_ai:
	sub 0
	push af
	rrc c
	jr nc,XNoWrap1
	inc hl
XNoWrap1:
	ld a,c
ch2:
	or (hl)
	ld (hl),a
	pop af
	dec b
	jr z,LineDone
	jr nc,XNewRow
XDNeg:
	add a,0
	push af
	rrc c
	jr nc,XNoWrap2
	inc hl
XNoWrap2:
	ld a,c
ch3:
	or (hl)
	ld (hl),a
	pop af
	dec b
	jr z,LineDone
	jr c,XNewRow
	jr XDNeg
DY_Greater:
	neg
	add a,a
	ld (YNoWrap+1),a
	ld a,b
	add a,a
	ld (YDNeg+1),a
	pop hl
	sub h
	ld b,h
	pop hl
	push af
	ld a,c
ch4:
	or (hl)
	ld (hl),a
	pop af
YRepeat:
	bit 7,a
	jr nz,YDNeg
	rrc c
	jr nc,YNoWrap
	inc hl
YNoWrap:
	add a,0
	jr YPlot
YDNeg:
	add a,0
YPlot:
	add hl,de
	push af
	ld a,c
ch5:
	or (hl)
	ld (hl),a
	pop af
	djnz YRepeat
LineDone:
	pop hl
	pop de
	pop bc
	ret

change_xor:
	xor (hl)
change_or:
	or (hl)

FindPixel:
	push bc
	push de
	ld hl,ExpTable
	ld d,0
	ld a,b
	and $07
	ld e,a
	add hl,de
	ld e,(hl)
	ld h,d
	srl b
	srl b
	srl b
	ld a,c
	add a,a
	add a,a
	ld l,a
	add hl,hl
	add hl,hl
	ld a,e
	ld e,b
	add hl,de
	pop de
	pop bc
	ret

ExpTable:
	.db $80,$40,$20,$10,$08,$04,$02,$01

;------------------------------background----------------------------------;

background:
	ld bc,$FC00
	ld de,$0202
	ld hl,$0238
	call FLine
	ld de,$0D04
	ld hl,$0D3A
	call FLine
	ld de,$1805
	ld hl,$183B
	call FLine
	ld de,$2307
	ld hl,$233D
	call FLine
	ld de,$0202
	ld hl,$2307
	call FLine
	ld de,$0214
	ld hl,$2319
	call FLine
	ld de,$0226
	ld hl,$232B
	call FLine
	ld de,$0238
	ld hl,$233D
	call FLine
	ld de,$2702
	ld hl,$2738
	call FLine
	ld de,$3204
	ld hl,$323A
	call FLine
	ld de,$3D05
	ld hl,$3D3B
	call FLine
	ld de,$4807
	ld hl,$483D
	call FLine
	ld de,$2702
	ld hl,$4807
	call FLine
	ld de,$2714
	ld hl,$4819
	call FLine
	ld de,$2726
	ld hl,$482B
	call FLine
	ld de,$2738
	ld hl,$483D
	call FLine
	ld de,$4C02
	ld hl,$4C38
	call FLine
	ld de,$5704
	ld hl,$573A
	call FLine
	ld de,$6205
	ld hl,$623B
	call FLine
	ld de,$6D07
	ld hl,$6D3D
	call FLine
	ld de,$4C02
	ld hl,$6D07
	call FLine
	ld de,$4C14
	ld hl,$6D19
	call FLine
	ld de,$4C26
	ld hl,$6D2B
	call FLine
	ld de,$4C38
	ld hl,$6D3D
	call FLine
	ret

name_bkg:
	ld (hl),a
	inc hl
	ld (hl),a
	add hl,de
	djnz name_bkg
	ret

;----------------------------grayscale-------------------------------------;

OpenGray:
	res 2,(iy+$23)
	ld hl,IntRoutine
	ld de,_user_int_ram+1
	ld bc,InterruptMemEnd-IntRoutine
	ldir
	ld a,(_user_int_ram+1)
	ld hl,_user_int_ram+($28*1)
	add a,(hl)
	ld hl,_user_int_ram+($28*2)
	add a,(hl)
	ld hl,_user_int_ram+($28*3)
	add a,(hl)
	ld hl,_user_int_ram+($28*4)
 	add a,(hl)
	ld hl,_user_int_ram+($28*5)
	add a,(hl)
	ld (_user_int_ram),a
	xor a
	ld (IntCounter), a
	ld (UserCounter), a
	ld de, IntData
	ld hl, SourceIntData
	ld bc, 2
	ldir
	set 2,(iy+$23)
	ret

CloseGray:
	res 2, (iy+$23)
	ld a, $3C
	out (0), a
	call ClearPage
	ret

ClearPage:
	ld hl, (Pages)
	call Clear1024
	ld hl, (Pages+2)
	call Clear1024
	ret
Clear1024:
	ld d, h
	ld e, l
	inc de
	ld (hl), 0
	ld bc, 1024
	ldir
	ret

IntRoutine:
	push af
	ld a,($C1B4)   ;_CXCURAPP
	cp $1D
	jr c,DownLeft_check
	cp $20
	jr nc,DownLeft_check
	jr DownLeft_OK
DownLeft_check:
	in a,($03)
	bit 3,a
	jr z,DownLeft_OK
	res 0,a
	out ($03),a
DownLeft_OK:
	push hl
	in a,(3)
	bit 1,a
	jr z,EndIntRoutine
	ld hl, UserCounter
	inc (hl)
	ld hl, IntData
	ld a,(IntCounter)
	cp 5
	jr z,DisplayLast
	cp 3
	jr c,DisplayBpl1
	jr DisplayBpl2

DisplayBpl1:
	inc a
	ld (IntCounter),a
	ld a, (hl)
	out (0),a
	jr EndIntRoutine

DisplayBpl2:
	inc a
	ld (IntCounter),a
	inc hl
	ld a, (hl)
	out (0),a
	jr EndIntRoutine

DisplayLast:
	ld a, (hl)
	out (0), a
	xor a
	ld (IntCounter),a

EndIntRoutine:
	ld a,(UserCounter)
	cp 41
	jr z,EndIntRoutine2
	pop hl
	pop af
	ret
EndIntRoutine2:
	xor a
	ld (UserCounter),a
	pop hl
	pop af
	ret

InterruptMemEnd:

;--------------------------------------------------------------------------;

GraySprite:
	push hl
	pop ix
	call FindAddress
GraySpriteE:
	push hl
	push ix
	ld de,GrayDraw1
	add hl,de
	ld a,16
	ld (RenderSpriteM),a
	call RenderSprite
	ld a,8
	ld (RenderSpriteM),a
	pop ix
	pop hl
	ld de,GrayDraw2
	add hl,de
	ld de,$0008
	add ix,de

RenderSprite:
RenderSpriteCV = $+1
	ld b,8
RenderSpriteL:
	push bc
	ld a,(ix+8)
RenderSpriteM = $-1
	cpl
	ld b,a
	ld d,(ix)
	inc ix
	ld a,c
	ld c,$ff
	ld e,0
	or a
	jr z,RenderSpriteD
RenderSpriteS:
	srl d
	rr e
	scf
	rr b
	rr c
	dec a
	jr nz,RenderSpriteS
RenderSpriteD:
RenderSpriteCL =$
	ld a,b
	and (hl)
	or d
	ld (hl),a
	inc hl
RenderSpriteCR =$
	ld a,c
	and (hl)
	or e
	ld (hl),a
	ld de,15
	add hl,de
	pop bc
	djnz RenderSpriteL
	ret

FindAddress:
	ld a,c
	add a,a
	add a,a
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	ld a,b
	and %11111000
	rra
	rra
	rra
	or l
	ld l,a
	ld a,b
	and %00000111
	ld c,a
	ret

;__________________________________________________________________________;
;_________________________________TEXTS____________________________________;
;__________________________________________________________________________;

title:
	.db "   Tic-Tac-Toe  3D   ",0
	.db "Programmed by Etienne Mansot",0
	.db "One Player",0
	.db "Two Players",0
	.db "Help",0
	.db "Quit",0

t_help:
	.db "        HELP         ",0
	.db "KEYS:",0
	.db "    . 8,2,6,4      ",28," left,right,up,down",0
	.db "    . EE, ( , )        ",28," select a plane",0
	.db "    . Enter            ",28," put a ball",0
	.db "    . More             ",28," pause",0
	.db "    . Exit                  ",28," back to menu",0
	.db "    . +,-                    ",28," contrast",0
	.db "GOAL:",0
	.db "    Make lines of 3 identicals balls",0

;__________________________________________________________________________;
;________________________________TABLES____________________________________;
;__________________________________________________________________________;

IntCounter              equ _user_int_ram+InterruptMemEnd-IntRoutine+2
IntData                 equ _user_int_ram+InterruptMemEnd-IntRoutine+3
UserCounter             equ _user_int_ram+InterruptMemEnd-IntRoutine+5

SourceIntData:
.db PAGE1_BPL1, PAGE1_BPL2

Pages:
.dw $FC00, $F700

go_to:
	.dw exit,one_player,game,help,exit

selectloc:
	.db $03,$3C,$03,$2A,$03,$18
	.db $0E,$3A,$0E,$28,$0E,$16
	.db $19,$39,$19,$27,$19,$15

clear_selectloc:
	.db $03,$3C,$03,$2C,$0C,$3A,$0C,$2A
	.db $03,$2A,$03,$1A,$0C,$28,$0C,$18
	.db $03,$18,$03,$08,$0C,$16,$0C,$06
	.db $0E,$3A,$0E,$2A,$17,$39,$17,$29
	.db $0E,$28,$0E,$18,$17,$27,$17,$17
	.db $0E,$16,$0E,$06,$17,$15,$17,$05
	.db $19,$39,$19,$29,$22,$37,$22,$27
	.db $19,$27,$19,$17,$22,$25,$22,$15
	.db $19,$15,$19,$05,$22,$13,$22,$03

loc_selectloc:
	.db $03,$03,$03,$13,$0C,$05,$0C,$15
	.db $03,$15,$03,$25,$0C,$17,$0C,$27
	.db $03,$27,$03,$37,$0C,$29,$0C,$39
	.db $0E,$05,$0E,$15,$17,$06,$17,$16
	.db $0E,$17,$0E,$27,$17,$18,$17,$28
	.db $0E,$29,$0E,$39,$17,$2A,$17,$3A
	.db $19,$06,$19,$16,$22,$08,$22,$18
	.db $19,$18,$19,$28,$22,$1A,$22,$2A
	.db $19,$2A,$19,$3A,$22,$2C,$22,$3C

play_loc:
	.db $04,8,04,26,04,44
	.db	15,10,15,28,15,46
	.db	26,12,26,30,26,48
	.db	41,8,41,26,41,44
	.db 52,10,52,28,52,46
	.db 63,12,63,30,63,48
	.db 78,8,78,26,78,44
	.db 89,10,89,28,89,46
	.db 100,12,100,30,100,48
;__________________________________________________________________________;
;_________________________________SPRITES__________________________________;
;__________________________________________________________________________;


spriTI:
	;.db 8, 40
	.db %00000000
	.db %00000010
	.db %00000010
	.db %01111110
	.db %00000010
	.db %00000010
	.db %00000000
	.db %01000010
	.db %01000010
	.db %01111110
	.db %01000010
	.db %01000010
	.db %00000000
	.db %00110100
	.db %01001010
	.db %01001010
	.db %00110100
	.db %00000000
	.db %00111100
	.db %01001010
	.db %01001010
	.db %00110000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01101100
	.db %00000000

players:
;	.db 08,32
	.db %00000000
	.db %01111110
	.db %00010010
	.db %00010010
	.db %00001100
	.db %00000000
	.db %01111110
	.db %01000000
	.db %01000000
	.db %00000000
	.db %01100000
	.db %00011100
	.db %00010010
	.db %00011100
	.db %01100000
	.db %00000000
	.db %00000110
	.db %01001000
	.db %00110000
	.db %00001110
	.db %00000000
	.db %01111110
	.db %01001010
	.db %01001010
	.db %01000010
	.db %00000000
	.db %01111110
	.db %00010010
	.db %00010010
	.db %01101100
	.db %00000000
	.db %00000000

number1:
	;.db 8, 8
	.db %00000000
	.db %01000100
	.db %01111110
	.db %01000000
	.db %00000000
	.db %00000000
	.db %01101100
	.db %00000000

number2:
;	.db 08,08
	.db %00101100
	.db %01010010
	.db %01001010
	.db %01000100
	.db %00000000
	.db %00000000
	.db %01101100
	.db %00000000

spriteB0:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

spriteB1:
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111011
	.db %11110011
	.db %01111110
	.db %00111100
	.db %00111100
	.db %01000010
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %01000010
	.db %00111100
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100

spriteB2:
	.db %00111100
	.db %01000010
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %01000010
	.db %00111100
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111011
	.db %11110011
	.db %01111110
	.db %00111100
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100

spriteB3:
	.db %10111101
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111011
	.db %11110111
	.db %01111110
	.db %10111101
	.db %10111101
	.db %01000010
	.db %10100101
	.db %10011001
	.db %10011001
	.db %10100101
	.db %01000010
	.db %10111101
	.db %10111101
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %01111110
	.db %10111101

spriteB4:
	.db %10111101
	.db %01000010
	.db %10100101
	.db %10011001
	.db %10011001
	.db %10100101
	.db %01000010
	.db %10111101
	.db %10111101
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111011
	.db %11110111
	.db %01111110
	.db %10111101
	.db %10111101
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %01111110
	.db %10111101

spritempty:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

point0:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000

point1:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %01001000
	.db %01111100
	.db %01000000
	.db %00000000

point2:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %01100100
	.db %01010100
	.db %01001000
	.db %00000000

point3:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %01000100
	.db %01010100
	.db %00101000
	.db %00000000

point4:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %00011100
	.db %00010000
	.db %01111000
	.db %00000000

point5:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %01011100
	.db %01010100
	.db %00100100
	.db %00000000

point6:
	.db %00111000
	.db %01000100
	.db %00111000
	.db %00000000
	.db %01111000
	.db %01010100
	.db %01110100
	.db %00000000

spriteS:
	;.db 8, 8
	.db %01000100
	.db %01001010
	.db %01001010
	.db %00110010
	.db %00000000
	.db %00000000
	.db %01101100
	.db %00000000

spriteWIN:
	;.db 8, 32
	.db %00000001
	.db %00011111
	.db %00100001
	.db %01000000
	.db %00100000
	.db %00011110
	.db %00100000
	.db %01000000
	.db %00100001
	.db %00011111
	.db %00000001
	.db %00000000
	.db %01000001
	.db %01000001
	.db %01111111
	.db %01000001
	.db %01000001
	.db %00000000
	.db %01111111
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010000
	.db %01111111
	.db %00000000
	.db %01000110
	.db %01001001
	.db %01001001
	.db %01001001
	.db %00110001
	.db %00000000
	.db %01011111

spriteTIE:
	;.db 8, 24
	.db %00000001
	.db %00000001
	.db %01111111
	.db %00000001
	.db %00000001
	.db %00000000
	.db %01000001
	.db %01000001
	.db %01111111
	.db %01000001
	.db %01000001
	.db %00000000
	.db %01111111
	.db %01001001
	.db %01001001
	.db %01000001
	.db %01000001
	.db %00000000
	.db %01011111
	.db %00000000
	.db %01011111
	.db %00000000
	.db %01011111
	.db %00000000

.end
