#include "ti86asm.inc"

#define TopEdge 35
#define ncaves 16
#define CaveMax 60
#define ShrinkFact 10
#define CaveCMax 6
#define BallCMax 3
#define NBallCMax 250
#define MaxBalls	6
#define StartingBalls	2

#define source _plotSScreen
#define dest $fc00
#define DelayTime 15

#define x ix+0
#define y ix+1
#define ax ix+2
#define ay ix+3
#define structsize 4


.org _asm_exec_ram

	nop
	jp ProgStart
	.dw 0
	.dw ShellTitle

ShellTitle:
	.db "Stalactites",0

px: .db 64
py: .db 64-8
BallCounter: .db 0
nballs: .db StartingBalls
NBallCounter: .db 0
score: .dw 0000

NewBall:
	ld a,(NBallCounter)
	inc a
	ld (NBallCounter),a
	cp NBallCMax
	ret nz
	xor a
	ld (NBallCounter),a
	ld a,(nballs)
	cp MaxBalls
	ret z
	ld b,a
	ld de,structsize
	ld ix,balldata
mulloop:
	add ix,de
	djnz mulloop
	inc a
	ld (nballs),a

	ld a,125
	call Random
	ld (x),a
	ld a,32
	call Random
	ld (y),a
	ld a,2
	call Random
	inc a
	ld (ax),a
	ld a,2
	call Random
	inc a	;ax and ay are 1,or 2
	ld (ay),a
	ret

SetUpBalls:
	ld a,(nballs)
	ld b,a
	ld ix,balldata
SetUpLoop:
	ld a,125
	call Random
	ld (x),a
	ld a,32	;ball starts in top half of screen so user has chance to react
	call Random
	ld (y),a
	ld a,2
	call Random
	inc a
	ld (ax),a
	ld a,2
	call Random
	inc a
	ld (ay),a
	
	ld de,structsize
	add ix,de

	djnz SetUpLoop
	ret


ClearBuffer:
	ld hl,vbuffer
	ld de,vbuffer+1
	ld (hl),0
	ld bc,1024
	ldir
	ret

Flip:
	ld hl,vbuffer
	ld de,$fc00
	ld bc,1024
	ldir
	ret

SetUpCaves:
	ld b,ncaves
	ld hl,cavedata
suloop:
	ld (hl),10
	inc hl
	djnz suloop	;set up cave hight to zero
	ret

any:
	.db "Press any key!!",0

bytext:
	.db " by ",0
option:
	.db "F1: About         F5: Play the game!",0

aboutinfo:	;dont ask about the 1's its for a custom _vputs routine	
	.db "Stalactites was made by ",1 ;1 means newline in my loop
	.db "Matt da Cracker",1
	.db "Email: <snoborder420@yahoo.com>",1
	.db "Web: <junkworld.cjb.net>",1
	.db "This is a clone of a PC-DOS game",1
	.db "You can get that from www.plbm.com",1
	.db "Press any key",0	

About:;
	call ClearBuffer
	call Flip
	ld hl,$0101
	ld (_penCol),hl
	ld hl,aboutinfo
aboutloop:
	ld a,(hl)
	inc hl
	or a
	jp z,doneshowing
	cp 1
	jp z,mynewline
	call _vputmap
	jp aboutloop
mynewline:
	ld a,(_penRow)
	add a,8
	ld (_penRow),a
	xor a
	ld (_penCol),a
	jp aboutloop

doneshowing:
	call _get_key
	or a
	jp z,doneshowing
	call ClearBuffer
	call Flip	;clear the buf and lcd
;	jp ProgStart	;show title again!
ProgStart:
	ei ;you never know if they could be turned off
	call _flushallmenus
	call _runindicoff
	call _clrScrn
	ld hl,_plotSScreen
	ld de,_plotSScreen+1
	ld bc,1023
	ld (hl),0
	ldir
	
	ld hl,introscreen
	ld de,_plotSScreen+(16*10) ;i cut out all the leading zeros from my pic so its not 124 bytes
	ld bc,introscreen_end-introscreen
	ldir
	set textwrite,(iy+new_grf_flgs)
	ld hl,_penCol
	ld (hl),2
	inc hl
	ld (hl),1
	ld hl,gotext2
	call _vputs
	ld hl,_penCol
	ld hl,(highscore)
	call DisplayHLSmallFont
	ld hl,bytext
	call _vputs
	ld hl,name
	call _vputs

	ld hl,_penCol
	ld (hl),1
	inc hl
	ld (hl),64-8
	ld hl,option
	call _vputs

	call FadeRightIntro
	res textwrite,(iy+new_grf_flgs)
waitforkey1:
	halt
	call _get_key
	or a
	jp z,waitforkey1
	cp K_F1	;do they care about info??
	jp z,About
	cp K_EXIT
	jp z,_clrScrn
	cp K_F5
	jp nz,waitforkey1
	call _clrScrn
	call ClearBuffer

	ld hl,_plotSScreen
	ld (hl),0
	ld de,_plotSScreen+1
	ld bc,1023
	ldir
	call SetUpCaves
	call SetUpBalls
	call DrawCaves
	call Flip
	di ;fix the down left bug! (the cheap way of disabling inturrepts and reading from the ports :)
main:
;	ld b,2
delay:
;	halt
;	djnz delay
;draw the player
	ld a,(px)
	ld d,a
	ld a,(py)
	ld e,a
	ld hl,paddle
	call PutSprite	

	call UpdateCaves

	call DrawCaves
	call DrawBalls
	call NewBall
	call UpDateBalls
	call CheckBallHit
	call Flip
	call ClearBuffer

	ld a,%01111110
	out (1),a
	nop
	nop
	in a,(1)
;	bit 0,a
;	call z,IncPy
;	bit 1,a
;	call z,DecPx
;	bit 2,a
;	call z,IncPx
;	bit 3,a
;	call z,DecPy
	;dlru
;	xor a	
	rra	
	call nc,IncPy
	rra
	call nc,DecPx
	rra
	call nc,IncPx
	rra
	call nc,DecPy

	ld a,%00111111
	out (1),a
	nop
	nop
	in a,(1)

	rla 
	jp nc,pauseit
	rla
	jp nc,quitter
	rla
	jp nc,turnoff
	rla
	jp nc,QuickTeacherOut
	rla
	call nc,ScreenShot

;	bit 4,a
;	jp z,QuickTeacherOut
;	bit 5,a
;	jp z,turnoff
;	bit 6,a
;	jp z,quitter
;	bit 7,a
;	call z,pauseit
	jp main

ScreenShot:
	ld de,_plotSScreen	
	ld hl,$fc00
	ld bc,1024
	ldir
	ret
turnoff:
	ei
	ld a,1
	out (3),a
	halt
	ld a,11
	out (3),a        
	res onInterrupt,(iy+onflags)
	di
	jp main
QuickTeacherOut:
	ei ;turn ints back on
	call _clrScrn	;clear the screen
	jp _jforcecmdnochar	;restore stack and go to home screen

pauseit:
	ei
wfk:
	halt
	call _getky
	or a	;cp 0	
	jp z,wfk
	di
	jp main
;	ret



;;;;;;;;;;;;
UpDateBalls:
	ld a,(BallCounter)
	inc a
	ld (BallCounter),a
	cp BallCMax
	ret nz
	;ld a,0
	xor a
	ld (BallCounter),a

	ld a,(nballs)
	ld b,a
	ld ix,balldata
Ballloop:
	push bc
	ld a,(ax)
	add a,(x)
	ld (x),a ;updated x coord
	ld a,(ay)
	add a,(y)
	ld (y),a ;updated y coord
	
	ld a,(x)
;	cp 0
	or a
	jp nc,CheckX2

	ld a,(ax)
	neg
	ld (ax),a

	jp CheckY
CheckX2:
	cp 127
	jp c,CheckY
	ld a,(ax)
	neg
	ld (ax),a
CheckY:
	ld a,(y)
;	cp 0
	or a
	jp nc,CheckY2

	ld a,(ay)
	neg
	ld (ay),a

	jp DrawIt
CheckY2:
	cp 63
	jp c,DrawIt

	ld a,(ay)
	neg
	ld (ay),a

DrawIt


	ld de,structsize
	add ix,de
	pop bc
	djnz Ballloop
	ret

CheckBallHit:
	ld ix,balldata
	ld a,(nballs)
	ld b,a
chloop:
	push bc	;save counter
	ld d,(x)
	ld e,(y)
	ld a,(px)
	ld b,a
	ld a,(py)
	ld c,a
	call CheckHit
	pop bc
	ld a,(hitstatus)
	cp 1
	jp z,HitGameOver
	ld de,structsize
	add ix,de
	djnz chloop
	ret

hitstatus:
	.db 0

CheckHit:
;	ld a,0
	xor a
	ld (hitstatus),a
	ld a,d
	cp b
	ret c
	ld a,b
	add a,7
	cp d
	ret c
	ld a,c
	add a,3
	cp e
	ret nc
	ld a,c
	add a,7
	cp e
	ret c
	ld a,1
	ld (hitstatus),a
	ret

quitter:
	ei
	call _clrScrn
	call _homeup
	ld hl,qtext
	call _puts
	jp XX
qtext:
	.db "Your score: ",0

HitGameOver:
	ei
	pop hl
	call _clrScrn
	call _homeup
	ld hl,gotext
	call _puts
XX:
;	ld a,0
	ld hl,(score)
	call DisplayHL
	call _newline
	ld hl,gotext2
	call _puts
	ld hl,(highscore)
	call displayHL
	call _newline
	ld hl,secnd
	call _puts
wfs1:
	call _getkey
	cp kF1
	jp nz,wfs1
	call CheckNewHigh
	xor a
	ld (_asapvar+1),a	;make it so tios will Reload prog when run the next time
	call _clrScrn
	jp _homeup
;	call _homeup
;	ret

secnd:
	.db "Press F1",0

gotext:
	    ;123456789012345678901
	.db "haha you got hit     "
	.db "your score: ",0
gotext2:
	.db "High score: ",0

newhi:
	.db "New High Score!!!!!!!"
	.db "yeah buddy enter your"
	.db "name",0

CheckNewHigh:
	call _clrScrn
	call _homeup
	ld hl,(highscore)
	ld de,(score)
	or a
	sbc hl,de
	ret nc		;if new score isint bigger the ret ( to bad if tied, older prevails)
	ld (highscore),de
	ld hl,newhi
	call _puts
	call _newline
	ld hl,name
	call _puts
	ld a,Lleft
	call _putc
;	ld a,0
	xor a
	ld (_curCol),a
	ld d,a ;ld d,0
	ld hl,name
GetInitals:
	push hl
	push de
	ld a,(_curRow)
	inc a
	ld (_curRow),a
	ld a,Lsqup
	call _putmap
	ld a,(_curRow)
	dec a
	ld (_curRow),a
	call _get_key
	pop de
	pop hl
	cp K_LEFT
	jp z,move_cur_left
	cp K_RIGHT
	jp z,move_cur_right
	cp K_UP
	jp z,IncCur
	cp K_DOWN
	jp z,DecCur
	cp K_ENTER
	jp z,DoneInitals
	jp GetInitals

move_cur_left:
	ld a,d
	or a
	jp z,GetInitals
	dec d
	dec hl
	ld a,(_curRow)
	inc a
	ld (_curRow),a
	ld a,Lspace
	call _putmap
	ld a,(_curRow)
	dec a
	ld (_curRow),a
	ld a,(_curCol)
	dec a
	ld (_curCol),a
	jp GetInitals
move_cur_right:
	ld a,d
	cp 12
	jp z,GetInitals
	inc d
	inc hl
	ld a,(_curRow)
	inc a
	ld (_curRow),a
	ld a,Lspace
	call _putmap
	ld a,(_curRow)
	dec a
	ld (_curRow),a


	ld a,(_curCol)
	inc a
	ld (_curCol),a

	jp GetInitals

IncCur:
	inc (hl)
	ld a,(hl)
	cp 127
	jp c,valid
	dec (hl)
	ld a,(hl)
valid:

	call _putmap
	jp GetInitals
DecCur:
	dec (hl)
	ld a,(hl)
	cp 32
	jp nc,valid2
	inc (hl)
	ld a,(hl)
valid2:
	call _putmap
	jp GetInitals


DoneInitals:
	call _newline
	call save_data
	ld hl,saved
	call _puts
	jp _getkey
;	call _getkey
;	ret
saved:
	.db "game saved press any key",0

DrawBalls:
	ld a,(nballs)
	ld b,a
	ld ix,balldata
DBLoop:
	push bc
	ld d,(x)
;	ld d,a
	ld e,(y)
;	ld e,a
	call PutPixel
	inc d
	call PutPixel
	inc e
	call PutPixel
	dec d
	call PutPixel

	call Flip
	ld de,structsize
	add ix,de
	pop bc
	djnz DBLoop
	

DrawCaves:
;god im dum later!!!
;	ld a,0
	xor a
DCLoop1:
	push af
	ld hl,cavedata
	ld d,0
	ld e,a
	add hl,de
	ld b,(hl)
	ld h,0
	ld l,a
	ld de,vbuffer
	add hl,de
	ld de,16
DCLoop2:
	ld (hl),%10100101
	add hl,de
	djnz DCLoop2
	pop af
	inc a
	cp ncaves
	jp nz,DCLoop1
	ret
	
CaveCounter:
	.db 0
	
UpdateCaves:
	ld a,(CaveCounter)
	inc a
	ld (CaveCounter),a
	cp CaveCMax
	ret nz
	xor a
	ld (CaveCounter),a

	ld hl,cavedata
	ld b,ncaves
UCLOOP:
	ld a,(hl)
	cp CaveMax
	jp nc,UCEND
	inc (hl)
UCEND:
	inc hl
	djnz UCLOOP
	
	;all caves have been increased!!!
	;now we need to find out what caves to shrink!!!
	ld a,(px)
	and %00000111
	jp z,OnlyOneToShrink	;if paddle is aligned? only 1 to shrink
	ld a,(px)	
	srl a
	srl a
	srl a	;a=px/8
	ld d,0
	ld e,a	;de=px/8
	ld hl,cavedata	
	add hl,de	;hl=cavedata+px/8
	ld a,(hl)	;get current value of cave
	cp ShrinkFact+1		;if less than shrinkfactor we zero it
	jp c,SetItToZero1
	ld b,ShrinkFact	;loop shrinkfactor times
	ld a,1
SLoop:
;	ld a,(hl)
	cp (hl)
	jp nc,DoneS1	;if zero cave is clear!
	dec (hl)
	call IncScore
	djnz SLoop
DoneS1:
	inc hl
	ld a,(hl)
	cp ShrinkFact
	jp c,SetItToZero2
	ld b,ShrinkFact
	ld a,1
SLoop2:
;	ld a,(hl)
	cp (hl)
	ret nc	;if zero cave is cleared
	dec (hl)
	call IncScore
	djnz SLoop2
	ret

SetItToZero1:
	ld (hl),1
	jp DoneS1

SetItToZero2:
	ld (hl),1
	ret

OnlyOneToShrink:
	ld a,(px)
	srl a
	srl a
	srl a
	ld d,0
	ld e,a	;de=px/8
	ld hl,cavedata	
	add hl,de
	ld a,(hl)
	cp ShrinkFact+1
	jp c,SetItToZero2
	ld b,ShrinkFact
O1Loop:
	ld a,(hl)
	cp 1
	ret c	;if cave is zero were done and ret!!
	dec (hl)
	call IncScore
	djnz O1Loop
	ret 

IncScore:
	push hl
	ld hl,(score)
	inc hl
	ld (score),hl
	pop hl
	ret
;====================================================================
; DisplayHL:  (idea from SCaBBy/Mardell)    [Assembly Coder's Zenith]
;  Display HL as a 5-digit decimal number with no leading zeros
;  out: AF, HL, BC, DE destroyed
;====================================================================
DisplayA:
 ld h,0
 ld l,a
DisplayHL:
 call SetupDispHL
 jp _puts			; print number
				; we're done
DisplayHLSmallFont:
	call SetupDispHL
	jp _vputs
	
SetupDispHL:
 ld c,'0'  				; save ascii value for zero
 ld de,_OP1+5			; point to end of the buffer
 xor a				; zero terminate string
 ld (de),a				; set last byte to zero
DisplayHLl:
 call _divHLby10			; next digit
 dec de				; next position
 add a,c				; convert to ascii
 ld (de),a				; save digit
 ld a,h				; load upper byte
 or l					; check with lower byte for zero
 jr nz,DisplayHLl			; loop
 ex de,hl				; point to buffer
 ret

PutSprite:
	ld b,8
PSLoop1:
	push bc	;save first counter
	push de	;save coords1
	ld b,8
	ld a,(hl)
PSLoop2:
	push bc	;save second counter
	rla
	call c,PutPixel
;	call nc,ClearPixel
	inc d	;next x
	pop bc	;get second counter back
	djnz PSLoop2
	pop de	;get coords1 back
	inc e	;next y
	inc hl	;next byte in pixel
	pop bc	;get counter1 back
	djnz PSLoop1
	ret
ClearPixel:
	push af
	push de
	push hl
	
	ld a,d
	cp 128
	jp nc,DoneCP
;	cp 0
	or a
	jp c,DoneCP
	ld a,e
	cp 64
	jp nc,DoneCP
;	cp 0
	or a
	jp c,DoneCP

	call FindPixel
	cpl
	and (hl)
	ld (hl),a
doneCP:
	pop hl	
	pop de
	pop af
	ret
PutPixel:
	push af
	push de
	push hl

	ld a,d
	cp 128
	jp nc,DonePP
;	cp 0
	or a
	jp c,DonePP
	ld a,e
	cp 64
	jp nc,DonePP
;	cp 0
	or a
	jp c,DonePP

	call FindPixel
	or (hl)
	ld (hl),a
DonePP:
	pop hl
	pop de
	pop af
	ret

FindPixel:
	call FindAddy
	ld de,vbuffer
	add hl,de
	ret

FindAddy:
;input d,e == x,y
;output hl== offset a==bitmask
;this is just like a findpixel routine except you have to add the offset to the
;video mem or graph mem or whatever else you are using
	ld a,d
	and %00000111
	ld c,a
	ld b,0
	ld hl,FAmask
	add hl,bc
	ld c,(hl)
	xor a		;clear a
	ld h,a		;clear high byte
	ld l,e		;hl==e
	add hl,hl	;y*2
	add hl,hl	;y*4
	add hl,hl	;y*8
	add hl,hl	;y*16
	sra	d		;x/2
	sra d		;x/4
	sra d		;x/8
	ld e,d
	sub a	;a=0
	ld d,a
	add hl,de
	ld a,c
	ret

FAmask:
 .db %10000000
 .db %01000000
 .db %00100000
 .db %00010000
 .db %00001000
 .db %00000100
 .db %00000010
 .db %00000001


;from Jimmy Mardell
Random: 	       ; Creates a random number 0 <= x < A
 	push bc
 	push de
 	push hl
 	ld b,a
 	ld a,r
 	add a,a
 	ld hl,0
 	ld d,0
 	ld e,a
RMul:
 	add hl,de
 	djnz RMul
 	ld a,h
 	pop hl
 	pop de
 	pop bc
 	ret

paddle:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111111
	.db %10000001
	.db %10000001
	.db %11111111

DecPx:
	push af
	ld a,(px)
;	cp 0
	or a
	jp z,donedx
	dec a
	ld (px),a
donedx:
	pop af
	ret

IncPx:
	push af
	ld a,(px)
	cp 128-7
	jp z,doneiz
	inc a
	ld (px),a
doneiz:
	pop af
	ret

IncPy:
	push af
	ld a,(py)
	cp 63-7
	jp z,doneiy
	inc a
	ld (py),a
doneiy:
	pop af
	ret	

DecPy:
	push af
	ld a,(py)
	cp TopEdge
	jp z,donedy
	dec a
	ld (py),a
donedy:
	pop af
	ret

;This is a highly optimized writeback routine for saving high scores and saved games.
;It saves all data between data_start and data_end.
;-Jonah Cohen		<ComAsYuAre@aol.com>
save_data:
	ld hl,_asapvar
	rst 20h				;copy to OP1
	rst 10h				;_findsym
;	ret c
	ld a,b
	ld hl,data_start-_asm_exec_ram+4		;offset
	add hl,de				;hl=pointer to data in original prog
	adc a,0				;in case we overlapped pages
	call _SET_ABS_DEST_ADDR
	xor a					;no absolute addressing now
	ld hl,data_start			;get data from here
	call _SET_ABS_SRC_ADDR
	ld hl,data_end-data_start	;number of bytes to save
	call _SET_MM_NUM_BYTES
	jp _mm_ldir			;copy data and return

;store the varname like this:
varname:
;	.db 4,"Stal"			;4 letters, then each character

data_start:

highscore: .dw 0000
name:	.db "Mat!!!!!!!!!!",0
data_end:

introscreen:


 .db $FF,$EF,$FF,$1F,$F1,$C0,$1F,$F1,$FF,$EF,$FF,$71,$FF,$EF,$F7,$FF
 .db $FF,$EF,$FF,$1F,$F1,$C0,$1F,$F1,$FF,$EF,$FF,$71,$FF,$EF,$F7,$FF
 .db $E0,$EF,$FF,$1C,$71,$C0,$1C,$71,$C3,$E0,$7F,$70,$0F,$EE,$07,$07
 .db $E0,$E0,$70,$1C,$71,$C0,$1C,$71,$C3,$E0,$7F,$70,$0F,$EE,$07,$07
 .db $E0,$E0,$70,$1C,$71,$C0,$1C,$71,$C3,$E0,$70,$70,$0E,$0E,$07,$07
 .db $E0,$00,$70,$1C,$71,$C0,$1C,$71,$C3,$E0,$70,$70,$0E,$0E,$07,$00
 .db $FF,$E0,$70,$1C,$71,$C0,$1C,$71,$C0,$00,$70,$70,$0E,$0F,$F7,$FF
 .db $FF,$E0,$70,$3C,$79,$E0,$3C,$79,$C0,$00,$70,$78,$0E,$0F,$F7,$FF
 .db $03,$E0,$70,$7F,$FD,$F0,$7F,$FD,$C0,$E0,$70,$7C,$0E,$0E,$00,$0F
 .db $E3,$E0,$70,$7F,$FD,$F0,$7F,$FD,$C0,$E0,$70,$7C,$0E,$0E,$07,$0F
 .db $E3,$E0,$70,$7C,$1D,$F0,$7C,$1D,$C0,$E0,$70,$7C,$0E,$0E,$07,$0F
 .db $E3,$E0,$70,$7C,$1D,$F0,$7C,$1D,$C0,$E0,$70,$7C,$0E,$0E,$07,$0F
 .db $FF,$E0,$70,$7C,$1D,$FF,$7C,$1D,$FF,$E0,$70,$7C,$0E,$0F,$F7,$FF
 .db $FF,$E0,$70,$7C,$1D,$FF,$7C,$1D,$FF,$E0,$70,$7C,$0E,$0F,$F7,$FF
 .db $20,$40,$50,$20,$10,$44,$24,$01,$00,$80,$00,$24,$00,$02,$02,$40
 .db $20,$40,$50,$20,$10,$44,$28,$01,$00,$80,$00,$24,$00,$02,$02,$40
 .db $20,$80,$50,$10,$20,$44,$18,$00,$81,$00,$00,$28,$00,$02,$42,$40
 .db $20,$80,$50,$10,$20,$28,$10,$00,$91,$00,$00,$28,$00,$02,$44,$20
 .db $10,$80,$50,$10,$20,$28,$00,$00,$91,$00,$00,$18,$00,$02,$C4,$24
 .db $10,$80,$50,$10,$20,$28,$18,$00,$B1,$00,$00,$18,$00,$02,$A4,$24
 .db $11,$00,$50,$10,$40,$28,$18,$00,$A9,$00,$00,$10,$00,$01,$A4,$2C
 .db $11,$00,$20,$08,$40,$10,$18,$00,$6A,$00,$00,$10,$00,$01,$A8,$1A
 .db $09,$00,$20,$08,$40,$10,$1F,$6C,$4A,$00,$00,$00,$00,$01,$28,$12
 .db $09,$00,$20,$08,$80,$10,$1B,$6C,$4A,$00,$00,$00,$00,$01,$28,$12
 .db $05,$00,$20,$04,$80,$00,$1B,$6C,$0A,$00,$00,$00,$00,$01,$28,$02
 .db $06,$00,$20,$02,$80,$00,$1F,$6C,$04,$00,$00,$00,$00,$00,$10,$02
 .db $02,$00,$20,$01,$00,$00,$1F,$7C,$04,$00,$00,$00,$00,$00,$10,$01
 .db $02,$00,$00,$00,$00,$00,$00,$1C,$04,$00,$00,$00,$00,$00,$10,$01
 .db $00,$00,$00,$00,$00,$00,$00,$1C,$00,$00,$00,$00,$00,$00,$00,$01
 .db $00,$00,$00,$00,$00,$00,$00,$1C,$00,$00,$00,$00,$00,$00,$00,$00
 .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
 .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
 .db $7F,$FC,$00,$00,$00,$18,$00,$0F,$F8,$00,$00,$30,$00,$00,$00,$00
 .db $61,$8C,$00,$00,$00,$18,$00,$0C,$78,$00,$00,$30,$00,$00,$00,$00
 .db $61,$8C,$00,$00,$00,$18,$00,$0C,$78,$00,$00,$30,$00,$00,$00,$00
 .db $61,$8C,$01,$86,$00,$18,$00,$0C,$78,$00,$00,$30,$00,$00,$00,$00
 .db $61,$8D,$F3,$EF,$81,$FB,$E0,$0C,$03,$EF,$9F,$B6,$7E,$F8,$00,$00
 .db $79,$8C,$31,$E7,$81,$D8,$60,$0C,$03,$61,$9B,$B6,$76,$D8,$00,$00
 .db $79,$8D,$F1,$86,$01,$DB,$E0,$0C,$1B,$8F,$98,$3F,$7E,$E0,$00,$00
 .db $79,$8D,$B1,$86,$01,$DB,$60,$0C,$1B,$8D,$98,$3B,$70,$E0,$00,$00
 .db $79,$8D,$B1,$86,$01,$DB,$60,$0C,$1B,$8D,$99,$BB,$76,$E0,$00,$00
 .db $79,$8D,$F9,$E7,$81,$FB,$F0,$0F,$FB,$8F,$DF,$BB,$7E,$E0,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $FF,$EF,$FF,$1F,$F1,$C0,$1F,$F1,$FF,$EF,$FF,$71,$FF,$EF,$F7,$FF
; .db $FF,$EF,$FF,$1F,$F1,$C0,$1F,$F1,$FF,$EF,$FF,$71,$FF,$EF,$F7,$FF
; .db $E0,$EF,$FF,$1C,$71,$C0,$1C,$71,$C3,$E0,$7F,$70,$0F,$EE,$07,$07
; .db $E0,$E0,$70,$1C,$71,$C0,$1C,$71,$C3,$E0,$7F,$70,$0F,$EE,$07,$07
; .db $E0,$E0,$70,$1C,$71,$C0,$1C,$71,$C3,$E0,$70,$70,$0E,$0E,$07,$07
; .db $E0,$00,$70,$1C,$71,$C0,$1C,$71,$C3,$E0,$70,$70,$0E,$0E,$07,$00
; .db $FF,$E0,$70,$1C,$71,$C0,$1C,$71,$C0,$00,$70,$70,$0E,$0F,$F7,$FF
; .db $FF,$E0,$70,$3C,$79,$E0,$3C,$79,$C0,$00,$70,$78,$0E,$0F,$F7,$FF
; .db $03,$E0,$70,$7F,$FD,$F0,$7F,$FD,$C0,$E0,$70,$7C,$0E,$0E,$00,$0F
; .db $E3,$E0,$70,$7F,$FD,$F0,$7F,$FD,$C0,$E0,$70,$7C,$0E,$0E,$07,$0F
; .db $E3,$E0,$70,$7C,$1D,$F0,$7C,$1D,$C0,$E0,$70,$7C,$0E,$0E,$07,$0F
; .db $E3,$E0,$70,$7C,$1D,$F0,$7C,$1D,$C0,$E0,$70,$7C,$0E,$0E,$07,$0F
; .db $FF,$E0,$70,$7C,$1D,$FF,$7C,$1D,$FF,$E0,$70,$7C,$0E,$0F,$F7,$FF
; .db $FF,$E0,$70,$7C,$1D,$FF,$7C,$1D,$FF,$E0,$70,$7C,$0E,$0F,$F7,$FF
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$1F,$6C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$1B,$6C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$1B,$6C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$1F,$6C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$1F,$7C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$1C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$1C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$1C,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
; .db $7F,$FC,$00,$00,$00,$18,$00,$0F,$F8,$00,$00,$30,$00,$00,$00,$00
; .db $61,$8C,$00,$00,$00,$18,$00,$0C,$78,$00,$00,$30,$00,$00,$00,$00
; .db $61,$8C,$00,$00,$00,$18,$00,$0C,$78,$00,$00,$30,$00,$00,$00,$00
; .db $61,$8C,$01,$86,$00,$18,$00,$0C,$78,$00,$00,$30,$00,$00,$00,$00
; .db $61,$8D,$F3,$EF,$81,$FB,$E0,$0C,$03,$EF,$9F,$B6,$7E,$F8,$00,$00
; .db $79,$8C,$31,$E7,$81,$D8,$60,$0C,$03,$61,$9B,$B6,$76,$D8,$00,$00
; .db $79,$8D,$F1,$86,$01,$DB,$E0,$0C,$1B,$8F,$98,$3F,$7E,$E0,$00,$00
; .db $79,$8D,$B1,$86,$01,$DB,$60,$0C,$1B,$8D,$98,$3B,$70,$E0,$00,$00
; .db $79,$8D,$B1,$86,$01,$DB,$60,$0C,$1B,$8D,$99,$BB,$76,$E0,$00,$00
; .db $79,$8D,$F9,$E7,$81,$FB,$F0,$0F,$FB,$8F,$DF,$BB,$7E,$E0,$00,$00
introscreen_end:
FadeRightIntro:
	ld ix,FadeRightMasks
	call FadeMainLoop
	ret
	
FadeLeftIntro:
	ld ix,FadeLeftMasks
	call FadeMainLoop
	ret

FadeRightOutro:
	ld ix,FadeRightOutroMasks
	call FadeMainLoop
	ret

FadeLeftOutro:
	ld ix,FadeLeftOutroMasks
	call FadeMainLoop
	ret

FadeMainLoop:
	ld b,8
FMLoop1:
	push bc
	ld hl,source
	ld de,dest
	ld bc,1024
FMLoop2:
	ld a,(ix+0)
	and (hl)
	ld (de),a
	inc hl
	inc de
	dec bc
 	ld a,b
	or c
	jp nz,FMLoop2
	inc ix
	ld b,DelayTime
	call DelayB
	pop bc
	djnz FMLoop1
	ret

DelayB:
	halt
	djnz DelayB
FadeRightMasks:
	.db %10000000,%11000000,%11100000,%11110000,%11111000,%11111100,%11111110,%11111111


FadeLeftMasks:
	.db %00000001,%00000011,%00000111,%00001111,%00011111,%00111111,%01111111,%11111111


FadeRightOutroMasks:
	.db %01111111,%00111111,%00011111,%00001111,%00000111,%00000011,%00000001,%00000000

FadeLeftOutroMasks:
	.db %11111110,%11111100,%11111000,%11110000,%11100000,%11000000,%10000000,%00000000

cavedata = $+1
vbuffer = $+21
balldata = $+1024+300

.end
