; /////////////////////////////////////////////////////////////////////////
; SqrxzEqu.Asm Equates
;
; You are not allowed to distribute a modified source file nor 
; the binary. Any changes must be for personal use only and be reported to:
; Jimmy Mrdell <yarin@acc.umu.se>
; Solignac Julien <x1cygnus@online.fr>
; Florent Dhordan <unknown>
; #########################################################################

; ---------------------------------
; | Begin | Missing Ti-83 Equates |
#IfNDef Plus
ApdAble			EQU		02h
ApdRunning		EQU		03h
ApdFlags		EQU		08h
kbdScanCode		EQU		8001h
LDHLInd			EQU		0033h
#Else
_HomeUp			EQU		4558h
_GetK			EQU		_GetCSC
Timer			EQU		ApdSubTimer
#EndIf
; | End | Missing Ti-83 Equates |
; -------------------------------


; -----------------------
; | Begin | Lib Equates |
#IfNDef Mirage
FastCopy		EQU	CmdShadow + 50h + 0Fh
ScanVAT			EQU	CmdShadow + 50h + 12h
#Else
FastCopy		EQU	4092h
ScanVat			EQU	4095h
#EndIf

; | End | Lib Equates |
; ---------------------


; --------------------------
; | Begin | Macro Commands |

#Define ASCR_BOTCLIP    62
; If not defined, ascr83 will use 64

#IfDef Plus
#IfNDef Mirage
#Define			LevelPtr	0C000h
#Else
#Define			LevelPtr	EndOfFile
#EndIf
#Else
#Define			LevelPtr	EndOfFile
#EndIf

#Define			NeededMem	0C00h
#Define			ExtraBuf	LevelPtr + 0800h

; | End | Macro Commands |
; ------------------------

; -----------------
; | Begin | Flags |
;HScroll			EQU		00h
;SqrxzHasMoved			EQU		01h
;HasDiedThisFrame		EQU		02h
;UnderPortCullis		EQU		03h
;UpdateEnemies			EQU		04h
;JumpButton			EQU		05h
;Playing			EQU		06h

; | End | Flags |
; ---------------


; ------------------------
; | Begin | Init Equates |
Initial_Air		EQU		01DFh

; | End | Init Equates |
; ----------------------


#IfNDef Plus
DataArea	EQU	StatVars
#Else
DataArea	EQU	AppBackUpScreen
#EndIf

XScr		EQU	DataArea
XBlock		EQU	DataArea + 02h
LevelSize	EQU	DataArea + 03h
X		EQU	DataArea + 05h
Y		EQU	DataArea + 07h
XFlags		EQU	DataArea + 08h

Jump		EQU	DataArea + 09h
Fall		EQU	DataArea + 0Ah
SqrxzCnt	EQU	DataArea + 0Bh
SqrxzDir	EQU	DataArea + 0Ch
Dead		EQU	DataArea + 0Dh
Counter		EQU	DataArea + 0Eh
AnimCnt		EQU	DataArea + 0Fh
DeadCnt		EQU	DataArea + 10h

Tmp_X		EQU	DataArea + 11h
Tmp_Y		EQU	DataArea + 13h
Start_Y		EQU	DataArea + 14h
Start_X		EQU	DataArea + 15h

EnemyTable	EQU	DataArea + 17h

World		EQU	DataArea + 57h
WorldB		EQU	DataArea + 59h
LvlPtrs		EQU	DataArea + 5Ah
WorldT		EQU	DataArea + 5Ch
NoLevels	EQU	DataArea + 5Dh
Lvl		EQU	DataArea + 5Eh
Lives		EQU	DataArea + 5Fh
TimeLeft	EQU	DataArea + 60h
Sausages	EQU	DataArea + 62h

WaterBar	EQU	DataArea + 63h
WorldPtr	EQU	DataArea + 65h

ClipMask	EQU	DataArea + 67h
Rows2Put	EQU	DataArea + 68h
BitMask		EQU	DataArea + 69h

BackCnt		EQU	DataArea + 6Ah
CurOpt		EQU	DataArea + 6Bh


SqrxzBG		EQU	DataArea + 71h
LastSprite	EQU	DataArea + 7Bh
BGETable	EQU	DataArea + 7Dh
AnimPtr		EQU	DataArea + 0D1h
AnimTable	EQU	DataArea + 0D2h
PortC		EQU	DataArea + 0F3h

NoWorlds	EQU	DataArea + 101h
Top		EQU	DataArea + 102h
NoItems		EQU	DataArea + 103h
CurItem		EQU	DataArea + 104h
hMoveLast	EQU	DataArea + 105h

Jump_Button	EQU	DataArea + 106h
Gaming		EQU	DataArea + 108h

Worlds		EQU	DataArea + 109h


#IfNDef Plus
Timer		EQU	8009h
#EndIf
; LSB of APD counter: a great idea from MovAx.


; ----------------
; | Begin | Keys |
kyMode			EQU		37h
kyClear			EQU		0Fh
kyEnter			EQU		09h
kyMath			EQU		2Fh
; | End | Keys |
; --------------
