; /////////////////////////////////////////////////////////////////////////
; HuffExtr.Asm Huffman Decompression
;
; You are not allowed to distribute a modified source file nor 
; the binary. Any changes must be for personal use only and be reported to:
; Jimmy Mrdell <yarin@acc.umu.se>
; Solignac Julien <x1cygnus@online.fr>
; Florent Dhordan <unknown>
; #########################################################################

HUFFEXTR:
	PUSH	DE
	PUSH	DE
	PUSH	HL
	INC	HL
	LD	A,(HL)
	CP	1
	JR	NZ,MULTIFILE
	LD	B,0
MULTIFILE:
	PUSH	BC
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	E,(HL)
	INC	HL
	PUSH	HL
	ADD	A,A
	LD	C,A
	ADD	A,A
	ADD	A,C
	LD	B,0
	LD	C,A
	ADD	HL,BC
	LD	B,E
	DEC	B
	PUSH	HL
	ADD	HL,DE
	POP	DE
	LD	(TREEADDR),IX
	LD	A,1
UNCRUNCHTREE:
	LD	C,A
	AND	(HL)
	JR	Z,NOBRANCH
	PUSH	IX
	INC	IX
	INC	IX
NEXTTREEBIT:
	LD	A,C
	RLCA
	JR	NC,UNCRUNCHTREE
	INC	HL
	JR	UNCRUNCHTREE
NOBRANCH:
	LD	A,(DE)
	INC	DE
	LD	(IX),0
	LD	(IX+1),A
	INC	IX
	INC	IX
	LD	A,B
	OR	A
	JR	Z,TREEBUILT
	EX	(SP),HL
	PUSH	DE
	PUSH	IX
	POP	DE

	LD	(HL),D
	INC	HL
	LD	(HL),E

	POP	DE
	EX	(SP),HL
	INC	SP
	INC	SP
	DEC	B
	JR	NEXTTREEBIT
TREEBUILT:
	POP	IX
	POP	AF
	POP	HL
	ADD	A,A
	LD	C,A
	ADD	A,A
	ADD	A,C
	LD	B,0
	LD	C,A
	ADD	IX,BC
	LD	D,(IX)
	LD	E,(IX+1)
	ADD	HL,DE
	LD	B,(IX+3)
	LD	A,1
SHIFT:
	RLCA
	DJNZ	SHIFT
	LD	C,A
	LD	D,(IX+4)
	LD	E,(IX+5)
	POP	IX
UNCRUNCHDATA:
	PUSH	DE
	LD	DE,(TREEADDR)
CHECKTREE:
	LD	A,(DE)
	OR	A
	JR	Z,ENDOFBRANCH
	LD	A,C
	AND	(HL)
	JR	NZ,RIGHTBRANCH
	INC	DE
	INC	DE
	JR	NEXTDATABIT
RIGHTBRANCH:
	EX	DE,HL

	LD	A, (HL)
	INC	HL
	LD	L, (HL)
	LD	H, A

	EX	DE,HL
NEXTDATABIT:
	RLC	C
	JR	NC,CHECKTREE
	INC	HL
	JR	CHECKTREE
ENDOFBRANCH:
	INC	DE
	LD	A,(DE)
	LD	(IX),A
	INC	IX
	POP	DE
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,UNCRUNCHDATA
	POP	DE
	RET

TREEADDR:
	.DW	0000H

.END
END