;Michael Pearce  mikep@anet-dfw.com  http://ti85games.home.ml.org
;October 12, 1997.

#include asm86.h
#include ti86asm.inc

BACKGRND	=	_textShadow	;8 bytes for background sprite storage
ORIGBACKGRND	=	_textShadow+8	;8 more bytes for b/g sprite storage
COL0		=	_textShadow+16	;first column of stacked cards
					;1 byte - the number of flipped cards
					;6 bytes - max num of flipped cards
					;13 bytes - max num of unflipped cards
					;1 byte - marks end of stack (-1)
					;--------
					;21 bytes total
COL1		=	_textShadow+37	;21 bytes
COL2		=	_textShadow+58	;21 bytes
COL3		=	_textShadow+79	;21 bytes
COL4		=	_textShadow+100 ;21 bytes
COL5		=	_textShadow+121 ;21 bytes
COL6		=	_textShadow+142 ;21 bytes
NotUsed3	=	_textShadow+163 ;1 byte
NotUsed4	=	_textShadow+164 ;1 byte
NotUsed1	=	_textShadow+165 ;1 byte
NotUsed2	=	_textShadow+166 ;1 byte
LASTKEYPRESS	=	_textShadow+167 ;1 byte for the last key press bitmask

STACK		=	_cmdShadow	;1 byte for number of cards in stack
					;24 bytes for max number of cards
					;-------
					;25 bytes
STACKINDEX	=	_cmdShadow+25	;1 byte for index of the card in stack
SUITSTACK0	=	_cmdShadow+26	;1 byte for top card on suit stack
SUITSTACK1	=	_cmdShadow+27	;1 byte for top card on suit stack
SUITSTACK2	=	_cmdShadow+28	;1 byte for top card on suit stack
SUITSTACK3	=	_cmdShadow+29	;1 byte for top card on suit stack
FROMSTACK	=	_cmdShadow+30	;1 byte for the stack type of the
					;  card you want to move from
TOSTACK 	=	_cmdShadow+31	;1 byte for the stack type of the
					;  location to move to					      ;  FROMCARD ontop of
FROMPOS 	=	_cmdShadow+32	;1 word for x,y of position from
TOPOS		=	_cmdShadow+34	;1 word for x,y of position moving to
TOCARD		=	_cmdShadow+36	;1 byte for card number
FROMCARD	=	_cmdShadow+37	;1 byte for card number
CARDSPRITE	=	_cmdShadow+38	;32 bytes for dynamically created
					; card sprite
CARDLIST	=	_cmdShadow+115	;52 bytes - last 52 bytes for gener-
					; ating random cards

.org _asm_exec_ram


   call _runindicoff   ; Turn off busy indicator
   call _flushallmenus ; _puts may not work on the last 2 rows else
   res appTextSave,(iy+appFlags) ; Don't affect _textShadow when _puts etc

   call Intro
   call _clrLCD
   call SetupGame

MoveLoop:

   ld hl,ORIGBACKGRND
   call PutSprite

   ld a,%00111110		;\
   out (1),a			; | status of arrow keys
   in a,(1)			;/  and top keys in a
   bit 1,a			;LEFT pressed
   call z,MoveLeft
   bit 2,a			;RIGHT pressed
   call z,MoveRight
   bit 3,a			;UP pressed
   call z,MoveUp
   bit 0,a			;DOWN pressed
   call z,MoveDown
   push bc
   call _getky
   pop bc
   cp K_EXIT
   jp z,Quit
   push bc
   cp K_PLUS
   call z,IncreaseVisible
   cp K_MINUS
   call z,DecreaseVisible
   cp K_MORE
   pop bc
   call z,OptionsMenu

   ld a,%00111111		;\
   out (1),a			; | status of 2nd key in a
   in a,(1)			;/
   bit 5,a			;is second pressed?
   push af
   jr nz,MovingCardCheck	;no, so check and see if moving a card
   call HoldCard	       ;save the x,y when 2nd key first pressed
   ld de,HoldCursor	       ;2nd pressed so use the hold cursor
   jr GotCursor
MovingCardCheck:
   push bc
   call LetGoOfCard	       ;try to move the card if let go of 2nd key
   pop bc
   ld de,Cursor 	       ;assume using regular cursor
GotCursor:
   pop af
   ld (LASTKEYPRESS),a		;save this key press as last key pressed

   ld hl,ORIGBACKGRND
   call GetBackGrnd

   ld hl,BACKGRND
   call GetBackGrnd

   call OrHLwithDE

   ;hl points to BACKGRND
   call PutSprite

   call CopyGtoV		;copy the graph mem to video mem

   push bc
   call TestWin 		;check if player won the game
   pop bc
SetupNewGame:
   call c,SetupGame		;you won, so start new game

   jr MoveLoop

;end of main game loop




OptionsMenu:
   push bc

   ld hl,$FC00+130
   ld b,12
TopMenuBorder:
   ld (hl),$FF
   inc hl
   djnz TopMenuBorder
   ld a,48
   ld de,4
NextMenuRow:
   add hl,de
   ld (hl),$80
   inc hl
   ld b,10
ClearCenterMenu:
   ld (hl),0
   inc hl
   djnz ClearCenterMenu
   ld (hl),$01
   inc hl
   dec a
   jr nz,NextMenuRow
   ld b,12
   add hl,de
BottomMenuBorder:
   ld (hl),$FF
   inc hl
   djnz BottomMenuBorder

   ld hl,$0402
   ld (_curRow),hl
   ld hl,NewGameText
   call _puts
   ld hl,$0403
   ld (_curRow),hl
   ld hl,Flip1Text
   call _puts
   ld hl,$0404
   ld (_curRow),hl
   ld hl,Flip3Text
   call _puts

   pop bc

OptionKeyLoop:
   call _getky
   or a
   jr z,OptionKeyLoop
   cp K_F1
   jr z,PlayNewGame
   cp K_F2
   jr z,StackIncrement1
   cp K_F3
   jr z,StackIncrement3
   ret
StackIncrement1:
   ld a,1
   jr StoreIncrement
StackIncrement3:
   ld a,3
StoreIncrement:
   ld (STACKINCREMENT),a
PlayNewGame:
   call SetupGame
   ret


NewGameText:
.db "F1 - NEW GAME",0
Flip1Text:
.db "F2 - FLIP 1",0
Flip3Text:
.db "F3 - FLIP 3",0


Intro:
   call _clrLCD
   ld hl,$0402
   ld (_curRow),hl
   ld hl,Title
   call _puts
   ld de,$0305
   ld (_curRow),de
   call _puts
   ld de,$0006
   ld (_curRow),de
   call _puts
   ld de,$3A0E
   ld (_penCol),de
   call _vputs
   call WaitEnter
   ret
Title:
.db "Solytare 2.1",0
.db "Michael Pearce",0
.db "mgp4007@omega.uta.edu",0
.db "TI-86 port by "
.db "Jimmy Mardell",0

;destroys all registers
;C flag = 1 if you won, 0 otherwise
TestWin:
   ld b,4
   ld hl,SUITSTACK0
TestWinLoop:
   ld a,(hl)
   and %00001111		;only look at card number
   cp 12			;is the card on suit stack a king?
   jr nz,NoWin			;card is not a king so did not win
   inc hl			;check next suit stack
   djnz TestWinLoop
   ;if you get here, you won
   ld bc,1024 / 2
   ld a,$FF
   ld hl,$FC00
   ld de,$FFFF
WinnerLoop:
   ld (de),a
   ld (hl),a
   dec de
   inc hl
   halt
   dec c
   jr nz,WinnerLoop
   djnz WinnerLoop
   ld hl,$0703
   ld (_curRow),hl
   ld hl,WinText
   set 3,(iy+5)
   call _puts
   res 3,(iy+5)
   call WaitEnter
   scf				;set carry since you won
   ret
NoWin:
   or a 			;clear the carry flag
   ret

WinText:
.db "You Win!",0


;destroys af, bc, hl
AdvanceStack:
   ld a,(STACK)
   or a 			;are there zero cards in STACK?
   ret z			;yes, so cannot advance
   ld a,(STACKINDEX)
   cp -1			;is a stack card showing?
   jr nz,StackCardVisible	;yes, so jump
   ld a,(STACK) 		;else, none card currently showing
   ld b,a
   ld a,(STACKINCREMENT)
   dec a			;assume index = stackincrement - 1
   cp b 			;less cards in stack than stack increment?
   jr c,CallDrawStack		;no, so we have the index
   dec b			;index is one less than number of cards
   ld a,b
   jr CallDrawStack
StackCardVisible:
   ld hl,STACK
   ld b,(hl)
   dec b			;b has the index of the last card
   cp b 			;is the index == the last card in stack
   jr z,LastCardinStack
   ld hl,STACKINCREMENT
   add a,(hl)			;a has the index of the next card
   cp b 			;is the new index past the end of STACK?
   jr c,CallDrawStack		;no, so jump
   ld a,b			;the index is the last card of the STACK
   jr CallDrawStack
LastCardinStack:
   ld a,-1
CallDrawStack:
   ld (STACKINDEX),a
   call DrawStack	       ;redraw the updated STACK
   ret
STACKINCREMENT:
.db 3				;default # cards to advance is 3
				;will be saved after game is quit

;Saves the position trying to move a card from if 2nd key was first pressed
;bc has the x,y position
HoldCard:
   ld a,(LASTKEYPRESS)
   bit 5,a			;was the 2nd key pressed last time?
   ret z			;yes, it was pressed, so return
   ld (FROMPOS),bc		;otherwize, save the x,y position
   ret


;b,c has the x,y position
;destroys bc, a
LetGoOfCard:
   ld a,(LASTKEYPRESS)
   bit 5,a			;was the 2nd key pressed last time?
   ret nz			;no, so return (didn't let go if 2nd)

   ld (TOPOS),bc

   call GetCardFromBC	       ;get the address, card and stack # of TO
   ld (TOCARD),a
   ld a,d
   cp -1			;\ cursor was not a valid position
   ret z			;/
   ld (TOSTACK),a

   push hl
   ld bc,(FROMPOS)
   call GetCardFromBC	       ;get the address, card and stack # of FROM
   pop ix			;ix has addr of TO card, hl addr of FROM card
   ld (FROMCARD),a
   ld a,d
   cp -1			;\ cursor was not a valid position
   ret z			;/
   ld (FROMSTACK),a

   or a 			;is it coming from STACK? (this stack is 0)
   push af
   call z,MoveFromSTACK        ;yes, so where do we move it to?
   pop af

   dec a			;is it coming from SUITSTACK? (it is 1)
   push af
   call z,MoveFromSUITSTACKS   ;yes, so where do we move it to?
   pop af

   dec a			;coming from non-top of COLSTACKS? (it is 2)
   push af
   call z,MoveFromMIDCOLSTACKS ;yes, so where do we move it to?
   pop af

   dec a			;coming from top of COLSTACKS? (it is 3)
   push af
   call z,MoveFromTOPCOLSTACKS ;yes, so where do we move it to?
   pop af

   dec a			;coming from flipped over cards? (it is 4)
   call z,MoveFromAdvanceStack

   call DrawGame	       ;redraw the updated game screen

   ret


MoveFromSUITSTACKS:
   ld a,(TOSTACK)
   cp 3 			;\ can only move to
   ret nz			;/ top card of COL stacks
   ld a,(FROMCARD)
   call CardToColStack	       ;try to put the FROM card on ColStack
   ret nc
   ld a,(hl)
   and %00001111
   or a 			;is the card an ace?
   jr z,SuitStackNowEmpty	;yes, so make the suit stack empty
   dec (hl)			;else decrease the card by 1
   ret
SuitStackNowEmpty:
   ld (hl),-1
   ret

MoveFromMIDCOLSTACKS:
   ld a,(TOSTACK)
   cp 3 			;\ can only move from middle cards to
   ret nz			;/ top card of COL stacks
   ld a,(FROMCARD)
   call CardToColStack	       ;try to put the FROM card on ColStack
   ret nc
   call MoveRemainingCards
   ld (hl),-1			;remove cards from top of COLN stack
   ret

;destroys de
MoveRemainingCards:
   push hl
   push ix
   pop de
   inc de
RemainingLoop:
   inc hl
   inc de
   ld a,(hl)			;\copy 1 byte (1 card) of memory
   ld (de),a			;/
   ld (hl),-1			;move a -1 into emptied locations
   inc a			;is a == -1?
   jr nz,RemainingLoop		;no, so keep looping
   pop hl
   ret

MoveFromTOPCOLSTACKS:
   ld a,(TOSTACK)
   cp 1
   jr z,From3To1
   cp 3
   ret nz			;if it is not to 1 or 3, return
From3To3:
   ld a,(TOCARD)
   ld b,a
   ld a,(FROMCARD)
   cp b 			;trying to move card onto itself?
   jr z,MoveTopToTop		;yes, so jump
   call CardToColStack
   ret nc
   ld (hl),-1			;remove card from top of COLN stack
   ret
MoveTopToTop:
   cp -1			;is the top card upside down?
   jr z,FlipOverTopCard 	;yes, so flip it over
   push hl
   call AutoCardToSuitStack    ;else trying to move to move to suit stack
   pop hl
   ret nc			;could not move card
   ld (hl),-1			;remove card from top of COLN stack
   ret
FlipOverTopCard:
   ld a,(hl)
   or a 			;are there zero flipped over cards?
   ret z			;yes, so return
   dec (hl)			;flip over the top card (one less flipped)
   ret
From3To1:
   ld a,(FROMCARD)
   push hl
   call ManualCardToSuitStack  ;manually move card onto suit stack
   pop hl
   ret nc			;could not move card
   ld (hl),-1			;remove card from top of COLN stack
   ret



;(the flipped over stack of cards in the top left,
; i couldn't think of a good name for it)
MoveFromAdvanceStack:
   ld a,(TOSTACK)
   cp 4 			;was cursor on same stack when pressed?
   call z,AdvanceStack	       ;yes, so advance the stack
   ret

MoveFromStack:
   ld a,(TOSTACK)
   or a
   jr z,From0To0
   dec a
   jr z,From0To1
   dec a
   ret z			;can not move from stack 0 to stack 2
;else From0To3
   ld a,(FROMCARD)
   call CardToColStack
   ret nc
   ld a,(FROMCARD)
   call RemoveCardFromStack
   ret
From0To0:
   ld a,(FROMCARD)
   call AutoCardToSuitStack    ;automatically move card onto suit stack
   ret nc			;could not move card
   ld a,(FROMCARD)
   call RemoveCardFromStack
   ret
From0To1:
   ld a,(FROMCARD)
   call ManualCardToSuitStack
   ret nc
   ld a,(FROMCARD)
   call RemoveCardFromStack
   ret


;card must be in STACK
;removes whatever card STACKINDEX points to and updates STACK
RemoveCardFromStack:
   ld hl,STACKINDEX
   ld d,0
   ld e,(hl)
   dec (hl)			;stack index moves to card below
   inc e			;inc e to move passed number of cards
   ld hl,STACK
   ld a,(hl)
   dec (hl)			;one less card in stack
   sub e
   ret z			;removed last card from stack, no more to do
   ld b,a
   add hl,de
   push hl
   pop ix			;ix points to card to remove
RemFromStackLoop:
   ld a,(ix+1)
   ld (ix+0),a
   inc ix
   djnz RemFromStackLoop
   ret


;input:
;  a has the card to move on top of COLSTACKN (FROM)
;  ix has address of the top card in COLSTACKN (TO)
;output:
;  C flag is set on success
;destroys:
;  a,bc
CardToColStack:
   ld c,a
   and %00001111
   cp 12			;is the card a king?
   jr z,CardIsKing		;yes, so try to move the king
   ld a,c
   xor (ix)
   bit 4,a			;bit 4 to check color color (NZ if diff)
   jr z,ColCannotMove		;jump if cards are the same suit
   ld a,c
   and %00001111
   inc a
   ld b,a
   ld a,(ix)
   and %00001111
   cp b
   jr nz,ColCannotMove
ColCanMove:
   ld (ix+1),c
   ld (ix+2),-1
   scf
   ret
CardIsKing:
   ld a,(ix)
   or a 			;are there zero flipped cards on this stack?
   jr nz,ColCannotMove		;no, so cannot move
   push hl			;save hl
   push ix
   pop hl
   push bc
   ld bc,COL0
   sbc hl,bc			;hl has offset of card pointed to
   pop bc			;  it should be the start of a col stack
   ld a,l			;a is between 0 and 21*7
   pop hl			;restore hl
BottomOfCol:
   or a 			;is number divisible by 21?
   jr z,ColCanMove		;yes, so it is at the bottom of COL stack
   sub 21			;21 bytes for every COL stack
   jr nc,BottomOfCol		;if carry, it's the ace of spades
ColCannotMove:
   or a 			;clear carry flag
   ret

;input:
;  a has the card
;  ix has address of the SUITSTACK to try to move card to
;output:
;  C flag is set on success
;destroys:
;  a,c
ManualCardToSuitStack:
   ld c,a
   and %00001111		;only look at card number
   jr nz,NotAce 		;is the card an ace?
   dec a			;a = -1
   cp (ix)			;and suit stack empty?
   jr nz,ManCannotMove		;stack != -1 (stack not empty)
   jr ManCanMove		;;else its ok to move card
NotAce:
   ld a,c
   dec a			;\ is the card to move 1 greater than
   cp (ix)			;/ card on suit stack?
   jr z,ManCanMove		;yes, so move card
ManCannotMove:
   or a 			;clear the carry flag
   ret
ManCanMove:
   ld (ix),c
   scf				;set carry since moved card
   ret

;Automatically adds the card in a to the appropriate suit stack, if possible
;input:
;  a has the card
;output:
;  C flag is set on success
;destroys:
;  a,bc,d,hl
AutoCardToSuitStack:
   ld c,a
   and %00001111		;dont look at card's suit
   or a 			;is the card an ace?
   jr z,CardIsAce
   ld a,c			;restore card in a
   and %11110000		;only look at the card's suit
   ld b,a			;card's suit is in b
   ld hl,SUITSTACK0 - 1
   ld d,5			;number of suits + 1
NextSuitStack:
   dec d
   jr z,AutoCannotMove
   inc hl			;move to next SUITSTACK
   ld a,(hl)			;put top card of SUITSTACK in a
   and %11110000		;a has the suit of card on SUITSTACK
   cp b 			;are the cards the same suit?
   jr nz,NextSuitStack		;no, so try the next suit stack
   ld a,c			;\
   dec a			; | is the card on top of stack equal to
   cp (hl)			;/  the card before the current card?
   jr nz,AutoCannotMove 	;no, so cannot move the card
   ld (hl),c			;put the new card on top of suit stack
   scf				;set the carry flag
   ret
AutoCannotMove:
   or a 			;clear the carry flag
   ret
CardIsAce:
   ld hl,SUITSTACK0 - 1 	;1 byte before suit stacks
   ld a,-1			;-1 is an empty suit stack
SuitStackNotEmpty:
   inc hl			;\
   cp (hl)			; | get address of first empty suit stack
   jr nz,SuitStackNotEmpty	;/
   ld (hl),c			;put the card on the stack
   scf				;successfully added card
   ret



IncreaseVisible:
   push af
   ld a,(VISIBLEROWS)
   inc a
   cp 7
   jr nz,GotIncVisible
   ld a,6			;max is 6
GotIncVisible:
   ld (VISIBLEROWS),a
   call DrawGame
   pop af
   ret

DecreaseVisible:
   push af
   ld a,(VISIBLEROWS)
   dec a
   jr nz,GotDecVisible
   ld a,1			;min is 1
GotDecVisible:
   ld (VISIBLEROWS),a
   call DrawGame
   pop af
   ret

VISIBLEROWS:
.db 4				;initial # rows visible


;Move the cursor up, affects register c
;destroys d
MoveUp:
   ld d,a
   dec c
   ld a,c
   cp -1
   ld a,d
   ret nz			;not at the top of screen so return
   ld c,0			;0 is the top of the screen
   ret

;Move the cursor down, affects register c
;destroys d
MoveDown:
   ld d,a
   inc c
   ld a,c
   cp 64
   ld a,d
   ret nz			;not at the bottom of screen so return
   ld c,63			;63 is the bottom of the screen
   ret
;Move the cursor left, affects register b
;destroys d
MoveLeft:
   ld d,a
   dec b
   ld a,b
   cp -1
   ld a,d
   ret nz
   ld b,0
   ret
;Move the cursor right, affects register b
;destroys d
MoveRight:
   ld d,a
   inc b
   ld a,b
   cp 120
   ld a,d
   ret nz
   ld b,119
   ret


;input: bc has the location of the cursor
;output: a has the card, possibly -1
;	 d has the stack number (0-4), or -1 cursor not over valid location
;	 hl has the address of where the card is located.
;destroys: e registers
GetCardFromBC:
   ld a,15			;bottom y pos of top row of cards
   cp c 			;is the y position greater?
   jr c,ItsColStack		;yes, so it must be is the COL'N' stacks
   ld a,24			;left x pos of visible part of stack
   cp b 			;is the x position less?
   jr nc,FlipStack		;yes, it's less so we want to advance STACK
   ld a,40			;right x pos of movable part of stack
   cp b 			;is the x position less?
   jr c,CardNotPartOfStack	;no, so jump
   jp CardOnStack	     ;24 < x position < 40, 0 < y < 16
FlipStack:
   ld a,-1			;no card
   ld d,4			;stack 4
   ret
CardNotPartOfStack:
   ld a,56			;the left most x pos of suit stacks
   cp b 			;is x position less than?
   jr nc,OutOfBounds		;yes, so it is invalid
   ld a,120			;rightmost x position of suit stacks
   cp b 			;is x position greater?
   jr c,OutOfBounds		;yes, so it is invalid
   jp CardOnSuitStack	     ;56 < x position < 120, 0 < y < 16
ItsColStack:
   ld a,8			;left x position of leftmost card
   cp b 			;is the x pos of cursor < left of cards?
   jr nc,OutOfBounds		;yes, so it is not valid
   ld a,120			;right x position of rightmost card
   cp b 			;is the x pos of cursor > right of cards?
   jr c,OutOfBounds		;yes, so it is not valid
   push bc
   call CardInColStack		;8 < x position < 120, y >= 16
   pop bc
   ret
OutOfBounds:
   ld d,-1
   ld a,-1
   ret

;bc has x,y position
;a has card number, or -1 if 0 cards in STACK (index = 0)
;  or no card showing (index = -1)
;d has the stack number which is 0 for stack
;hl has address of card
;destroys e
CardOnStack:
   ld d,0			;card is on STACK
   ld hl,STACK
   ld a,(hl)			;\
   or a 			; | if zero cards in the stack
   ld a,-1			; |  return -1
   ret z			;/
   ld a,(STACKINDEX)		;a has index of card showing on stack
   ld e,a			;index in e for 16 bit addition
   cp -1			;\
   ld a,-1			; | if this index is -1
   ret z			;/   no card is showing
   inc hl			;address of first card
   add hl,de			;hl has the address of the card
   ld a,(hl)			;a now has the facing card in STACK
   ret

;bc has x,y position
;a has card number, or -1 if the SUIT STACK has zero cards
;d returned with the stack number which is 1 for suit stack
;hl has address of suit stack (SUITSTACK0 - SUITSTACK3)
;destroys de
CardOnSuitStack:
   ld a,b
   sub 56			;\
   rra				; |
   rra				; | get the suit column number (0-3)
   rra				; |
   rra				; |
   and 15			;/
   ld hl,SUITSTACK0		;address of the first suit stack
   ld d,0
   ld e,a
   add hl,de
   ld a,(hl)			;a now has the card (or -1 if empty)
   ld d,1			;card on the suit stack
   ret


;bc has x,y position
;a has card number, or -1 if COL'N' STACK has zero cards
;d returned with the stack number which is 3 if top card in col stacks
;  or 2 otherwise
;hl has address of card unless no card flipped over, then
;  hl has address of COLSTACKN (a == -1)
;destroys bc, de
CardInColStack:
   ld a,b
   sub 8			;\
   rra				; |
   rra				; | get the COL number (0-6)
   rra				; |
   rra				; |
   and 15			;/
   ld l,a			;row number ('N') in l
   ld h,21			;number of bytes used for each row
   call MUL_HL			;hl has offset for specific row
   ld de,COL0
   add hl,de			;hl has the beginning of COL'N'
   push hl			;\save beginning of COL'N' in ix
   pop ix			;/
   ld b,(hl)			;b has number flipped over cards
   ld a,16			;the y position of the top of top card
   inc b			;make sure not 0 for djnz
AddFlippedRows:
   inc a			;one more flipped over row
   inc hl
   djnz AddFlippedRows
   dec a			;went to far passed the end because of "inc b"
   ld d,a			;d has the y pos of end of flipped cards
   cp c 			;is the cursor over flipped cards?
   jr nc,GotVisibleHL		;yes, so hl point to bottom visible card
   ld a,(VISIBLEROWS)	       ;\ b = # of rows used for visible cards
   ld b,a			;/	(1 - 5)
   ld a,d			;a has y pos of first visible card
AddVisibleRows:
   add a,b
   cp c
   jr nc,GotVisibleHL
   inc hl
   ld e,(hl)
   inc e			;set z flag if (hl) = -1
   jr nz,AddVisibleRows
   dec hl
GotVisibleHL:
   ld d,3			;assume top card of stack
   ld a,(hl)
   cp -1
   jr z,GetColStackNAddr
   inc hl
   ld e,(hl)
   dec hl			;hl to the address of card
   inc e			;set z flag if (hl) = -1
   ret z			;next card is -1, so a is top card
   ld d,2			;top card was not selected by cursor
   ret
GetColStackNAddr:
   push ix			;\ put beginning addr of COL'N' stack
   pop hl			;/  into hl
   ret


;Deals out all of the cards, does variable initialization
; and lots of other stuff.  just look through to see all of it.
;destroys all registers
SetupGame:
   ld a,-1
   ld (SUITSTACK0),a		;\
   ld (SUITSTACK1),a		; | all suit stacks
   ld (SUITSTACK2),a		; | start out empty
   ld (SUITSTACK3),a		;/
   ld (STACKINDEX),a		;first card is not shown
   ld (LASTKEYPRESS),a		;no keys have been pressed

;create the static parts of the card sprite
   ld hl,CARDSPRITE
   ld a,%01111111		;top left or bottom left of card gfx
   ld (hl),a
   ld (CARDSPRITE+28),a
   inc hl
   rlca 			;top right or bottom right of card gfx
   ld (hl),a
   ld (CARDSPRITE+29),a
   ld b,13			;number of rows of left and right edge
   ld d,%01000000		;left edge of card gfx
   ld e,%00000010		;right edge of card gfx
CardEdgeLoop:
   inc hl
   ld (hl),d
   inc hl
   ld (hl),e
   djnz CardEdgeLoop
   xor a			;bottom row of card is 0
   ld (CARDSPRITE+30),a
   ld (CARDSPRITE+31),a

;create 52 shuffled cards at CARDLIST
   call Shuffle

;create the stack of cards that you flip through from random list of cards
   ld ix,CARDLIST
   ld hl,STACK
   ld b,24
   ld (hl),b			;number of cards in stack
   inc hl
StackLoop:
   ld a,(ix)			;\
   ld (hl),a			; | copy from CARDLIST to STACK
   inc ix			; |
   inc hl			;/
   djnz StackLoop

;create the columns with top card visible
   ld hl,COL0			;left column
   ld c,0			;start with 0 flipped over cards
COLLoop:
   push hl
   ld (hl),c			;put the number of flipped cards in mem
   inc hl
   ld b,c
   inc b
COLLoopInner:
   ld a,(ix)
   ld (hl),a
   inc hl
   inc ix
   dec b
   jr nz,COLLoopInner
   ld (hl),-1			;no more cards in stack
   pop hl
   ld de,20			;\move hl to last byte in COL
   add hl,de			;/
   ld (hl),0			;make sure it's cleared (important)
   inc hl			;hl->beginning of next COL
   inc c			;1 more card flipped next time
   ld a,7
   cp c
   jr nz,COLLoop

;Draw the game board
   call DrawGame

;Setup the cursor arrow
   ld bc,0			;initial cursor position

   ld hl,ORIGBACKGRND		;get the background of cursor
   call GetBackGrnd

   ret

;Creates a random list in CARDLIST
;destroys all registers
Shuffle:
   ld b,4			;the number of suits
   xor a			;ld a with 0
   ld hl,CARDLIST

CreateListLoop:
   ld (hl),a
   inc hl
   inc a
   ld c,a
   and %00001111		;don't look at the suit
   cp $0D			;when low nibble is $D, move to next suit
   ld a,c
   jr nz,CreateListLoop
   add a,%00010000		;move to the next suit (add 1 to high nibble)
   and %11110000		;reset the low nibble
   djnz CreateListLoop

   ld c,8			;number of times to do outer swap loop
				;i was told 4 is enough, but i'll do it more
RandomizeListOuter:
   ld ix,CARDLIST		;point to first card in list
   ld b,52			;# cards in the deck
RandomizeList:
   push bc			;save the count
   ld a,52			;\
   call PRandom 	       ;/ get a random number in a
   ld b,0			;\
   ld c,a			; | hl points to the random card
   ld hl,CARDLIST		; |
   add hl,bc			;/
   ld b,(hl)			;\
   ld c,(ix)			; | swap the two cards
   ld (ix),b			; |
   ld (hl),c			;/
   inc ix			;ix points to the next card
   pop bc			;restore counts
   djnz RandomizeList
   dec c
   jr nz,RandomizeListOuter
   ret


;Randomization routine by Jimmy Mardell (used in ZTetris v3.0)
PRandom:	       ; Creates a pseudorandom number 0 <= x < A
   ld b,a
   ld a,r
   add a,a
   ld hl,0
   ld d,0
   ld e,a
RMul:
   add hl,de
   djnz RMul
   ld a,h
   ret


;Draw the entire solitaire game screen
;destroys all registers
DrawGame:
   ld hl,_plotSScreen
   ld de,_plotSScreen+1
   ld bc,1024-1
   ld (hl),0
   ldir 			;clear graph mem

   xor a			;start with COL0
DrawAllColsLoop:
   push af
   call DrawCol
   pop af
   inc a
   cp 7
   jr nz,DrawAllColsLoop

   call DrawStack

   xor a			;start with SUITSTACK0
DrawAllSuitStacksLoop:
   push af
   call DrawSuitStack
   pop af
   inc a
   cp 4
   jr nz,DrawAllSuitStacksLoop

   ret


;a has the suit stack to draw (0-3)
;reads from SUITSTACK'N' in memory
;destroys all registers
DrawSuitStack:
   ld hl,SUITSTACK0
   ld d,0
   ld e,a
   add hl,de
   rlca
   rlca
   rlca
   rlca
   add a,56
   ld b,a			;b has the x position
   ld a,(hl)			;a has the card to draw
   ld hl,EmptyCard	       ;assume drawing empty card
   cp -1			;is the assumption correct?
   jr z,SuitStackEmpty		;yes, so draw it empty
   call CardLookUp	       ;no, so get the address of card to draw
SuitStackEmpty:
   call AllignedSprite16X16    ;draw it

   ret



;reads from STACK in memory and STACKINDEX in memory
;destroys all registers
DrawStack:
   ld hl,EmptyCard	       ;assume drawing the empty card
   ld a,(STACK) 		;get the number of cards in the stack
   ld b,a
   or a 			;no cards in stack
   jr z,Got1STStackHL
   ld a,(STACKINDEX)		;\ is the stack index equal to the number
   inc a			; | of cards in stack - 1?
   cp b 			;/
   jr z,Got1STStackHL		;yes, so draw empty
   ld hl,FlippedCard	       ;else draw flipped over card
Got1STStackHL:
   ld bc,$0800			;(x,y) is (8,0)
   call AllignedSprite16X16    ;draw flipped card

   ld hl,EmptyCard
   ld a,(STACKINDEX)
   cp -1
   jr z,Got2NDStackHL		;if index is 0, no cards are turned over
   ld hl,STACK + 1		;hl has address of first card (passed index)
   ld d,0			;\
   ld e,a			; | add the index
   add hl,de			;/
   ld a,(hl)			;a has the card to draw
   call CardLookUp		;hl has address of card's sprite
Got2NDStackHL:
   ld bc,$1800			;(x,y) is (24,0)
   call AllignedSprite16X16	;display the card facing player

   ret

;a has the column number to draw (0-6)
;reads from COL0 - COL6 in memory
;destroys all registers
DrawCol:
   ld l,a			;row number in l
   ld h,21			;number of bytes used for each row
   call MUL_HL			;hl has offset for specific row
   ld bc,COL0			;address of first column
   add hl,bc			;hl has the address of COL'N' in _textShadow
   add a,a			;\
   add a,a			; | 16 pixels from one column
   add a,a			; | to the next
   add a,a			;/
   add a,8			;move right 8 pixels to center
   ld b,a			;x position in b
   ld c,16			;y position is 16 pixels from top
   ld a,(hl)			;number of flipped cards in a
   inc hl			;move to first card
   ex de,hl			;put the location of COL'N' in de
   push af			;\
   ld hl,EmptyCard	       ; | always draw an empty card
   call AllignedSprite16X16    ; |
   pop af			;/
   or a 			;are there 0 flipped cards?
   jr z,FacingCardLoop		;yes, so jump to do facing cards
   ld hl,FlippedCard
FlippedCardLoop:
   push af
   call AllignedSprite16X16    ;draw flipped card
   inc c			;move down one row
   pop af

   inc de			;move to next card
   dec a			;one less flipped card
   jr nz,FlippedCardLoop
FacingCardLoop:
   ld a,(de)			;put the card in a for lookup
   cp -1			;-1 denotes the end of card list
   ret z			;its -1 so return
   call CardLookUp	       ;hl has address of card's sprite
   call AllignedSprite16X16    ;display the card facing player
   inc de			;move to the next card
   ld a,(VISIBLEROWS)	       ;\
   add a,c			; | move down number of rows in VISIBLEROWS
   ld c,a			;/
   jr FacingCardLoop


;draws the card at CARDSPRITE (static part of cards drawn in GameSetup)
;a has the card(high nibble is suit/low nibble is the card type)
;hl = CARDSPRITE
CardLookUp:
   push bc
   push de
   push ix
   ld c,a
   and %00110000		;only look at the suit
   rrca \ rrca			;\put suit in low nibble
   rrca \ rrca			;/
   ld e,a			;e has the suit ( 0 - 3 )
   xor a			;a = 0
   ld b,5			;multiply by 5
				; (dynamic part of sprite is 5 bytes)
SuitOffsetLoop:
   add a,e
   djnz SuitOffsetLoop		;\
   ld e,a			; | calculate the offset from first suit gfx
   ld d,0			;/  offset will be 0, 5, 10, or 15
   ld ix,SuitSprites
   add ix,de			;ix has address of suit to draw
   ld a,c
   and %00001111		;only look at the card number
   ld e,a			;e has the card number (Ace - King i.e. 0-12)
   xor a			;a = 0
   ld b,5			;multiply by 5
				; (dynamic part of sprite is 5 bytes)
NumberOffsetLoop:
   add a,e
   djnz NumberOffsetLoop	;\  calculate the offset from Ace (0) gfx
   ld e,a			; |  offset will be 0,5,10,...,55,60
   ld d,0			;/   (0 = Ace ... 60 = King)
   ld hl,NumberSprites
   add hl,de			;hl has the address of number to draw
   ld de,CARDSPRITE+2		;location to draw suit and number
   ld b,5
DrawToCARDSPRITELoop:		;copy the card one row at a time
   ld a,(hl)
   ld (de),a
   inc hl
   inc de
   ld a,(ix)
   ld (de),a
   inc ix
   inc de
   djnz DrawToCARDSPRITELoop
   ld hl,CARDSPRITE		;return with address of the sprite
   pop ix
   pop de
   pop bc
   ret


;or's 8 bytes of memory in hl with the memory in de and stores in hl's mem
;then removes the center of the sprite
OrHLwithDE:
   push hl
   push de
   push bc
   push ix
   push de
   pop ix
   ld b,8
OrHLwithDELoop:
   ld a,(de)
   or (hl)
   and (ix+8)
   ld (hl),a
   inc hl
   inc ix
   inc de
   djnz OrHLwithDELoop
   pop ix
   pop bc
   pop de
   pop hl
   ret


;bc has x,y (x position should be a multiple of 8)
;hl has sprite
AllignedSprite16X16:
   ld a,c			;\
   sub 64			; | don't draw if lower than bottom row
   ret nc			;/
   neg				;a = number of rows allowed to show
   push hl
   push de
   push bc
   ex de,hl			;put location of sprite in de
   push af
   call FIND_PIXEL		;hl has offset
   pop af			;restore y position (bottom left is origin)
   ld bc,_plotSScreen
   add hl,bc			;location of where to start drawing
   ld b,16
   cp b 			;are we going to draw more lines than allowed?
   jr nc,ASLoop 		;no, so start drawing
   ld b,a
ASLoop:
   push bc			;save count in b
   ld a,(de)			;\draw first 8 bytes of row
   ld (hl),a			;/
   inc de			;\move to second half of sprite to draw
   inc hl			;/
   ld a,(de)			;\draw second 8 bytes of row
   ld (hl),a			;/
   inc de			;next row of sprite to draw
   ld bc,15			;\move to the next row of video memory
   add hl,bc			;/
   pop bc			;restore count in b
   djnz ASLoop
   pop bc
   pop de
   pop hl
   ret

;copy graph mem to video mem

CopyGtoV:
   halt 			;reduce some flicker
   push bc
   ld hl,_plotSScreen
   ld de,$FC00
   ld bc,1024
   ldir
   pop bc
   ret

;hl has address where graphics placed,
;bc has x,y location
GetBackGrnd:
   push bc		;\
   push de		; |save registers
   push ix		; |
   push hl		;/
   push hl
   pop ix		;ix has address where graphics will be placed
   call FIND_PIXEL	;hl has offset in vid mem, a has bit^2
   ld c,a		;save bit^2 in c
   ld de,_plotSScreen	;address of vid mem
   add hl,de		;hl has physical address in vid mem
   ld b,8		;8 is the number of rows in the sprite
GBG_NewRow:
   ld d,(hl)
   inc hl
   ld e,(hl)
   ld a,c		;restore bit^2 into a
   rla
   or a 		;cp to 0 and reset C flag
   jr z,GBG_After
GBG_RotRow:
   rl e
   rl d
   rla
   jr nc,GBG_RotRow
GBG_After:
   ld (ix),d
   inc ix
   ld de,15
   add hl,de
   djnz GBG_NewRow
   pop hl		;\
   pop ix		; |
   pop de		; |restore registers
   pop bc		;/
   ret


;jimmy mardell's good ol' putsprite.  i made a one byte optimization to it.
PutSprite:
   push ix
   push bc
   push de
   push hl

   push hl
   call FIND_PIXEL	;hl has offset in viedo mem; a has bit^2
   ld de,_plotSScreen	;store into graph mem for virtual screen
   add hl,de
   push af
   ld a,64
   sub c
   ld bc,$0808		;bc=width&height
   cp 8
   jr nc,PS_OnScr
   ld c,a		;clip bottom of sprite
PS_OnScr:
   pop af
   pop ix
PS_NewRow:
   push bc
   ld d,(ix)		;d has graphics for one row of sprite
   inc ix		;point to next row of sprite
   push af
   push hl
PS_NewCol:
   rl d
   ld e,a
   jr nc,PS_NoPixel
   or (hl)
   jr PS_NextPixel
PS_NoPixel:
   cpl			;complement of a, ~a
   and (hl)		;\ a = what's in video mem AND ~bit^2
			; |only bit^2 is affected (erased)
			;/ all others AND'ed w/1, which has no affect
PS_NextPixel:
   ld (hl),a		;ld a back into video mem (where it should be)
   ld a,e		;restore bit^2 into a
   rrca 		;\circular rotation of a, so a affects next bit
   jr nc,PS_SameByte	;C flag set when the 1 in a is shifted out of a
   inc hl		;next byte in video memory
PS_SameByte:
   djnz PS_NewCol	;go to the next column if b not = 0
   pop hl		;restore the video mem address
   pop af		;restore the byte from FIND_PIXEL
   ld de,16		;\move down a row (which is 16 bytes)
   add hl,de		;/
   pop bc		;bc again contains the width and height
   dec c		;one less row to draw
   jr nz,PS_NewRow	;when c=0, don't draw anymore rows

   pop hl		;\
   pop de		; |pixel plotted so restore the registers
   pop bc		; |
   pop ix		;/
   ret

FIND_PIXEL:
 push bc
 push de
 ld hl,ExpTable
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 ld h,d
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld l,a
 add hl,hl
 add hl,hl
 ld a,e
 ld e,b
 add hl,de
 pop de
 pop bc
 ret

ExpTable:
 .db $80,$40,$20,$10,$08,$04,$02,$01

WaitEnter:
 push bc
 push de
 push hl
RepWaitEnter:
 call _getky
 cp K_ENTER
 jr nz,RepWaitEnter
 pop hl
 pop de
 pop bc
 ret

Quit:
 ld hl,ProgName-1
 rst 20h
 rst 10h
 ex de,hl
 ld a,b     ; AHL = abs address of "solytaru"
 ld de,STACKINCREMENT-_asm_exec_ram+4
 add hl,de  ; AHL=AHL+DE,
 adc a,0    ; 24 bit addition
 call $46C3 ; Convert abs address AHL to ASIC address
 ld a,(STACKINCREMENT)
 ld (hl),a

 set appTextSave,(iy+appFlags)
 call _clrScrn	 ; Clear screen and the textshadow
 ld hl,0
 ld (_curRow),hl ; Moving the cursor to top left corner
 ret		 ; Return to TI-OS! (or a shell)

ProgName:
 .db $08,"solytaru",0

#include "solytare.gfx"

Cursor:
.db %11111110
.db %11111100
.db %11111000
.db %11111100
.db %11111110
.db %11011100
.db %10001000
.db %00000000
;CursorCenter must be after Cursor!!!!
CursorCenter:
.db %11111111
.db %10000111
.db %10001111
.db %10000111
.db %10100011
.db %11110111
.db %11111111
.db %11111111

HoldCursor:
.db %01111110
.db %11111111
.db %10011001
.db %10011001
.db %01100110
.db %00111100
.db %00111100
.db %00000000
;HoldCursorCenter must be after HoldCursor
HoldCursorCenter:
.db %11111111
.db %11111111
.db %10011001
.db %10011001
.db %11100111
.db %11111111
.db %11111111
.db %11111111



FlippedCard:
.db %01111111,%11111110
.db %01000000,%00000010
.db %01011101,%10111010
.db %01001110,%10110010
.db %01000111,%11100010
.db %01000011,%11000010
.db %01000001,%10000010
.db %01000000,%00000010
.db %01000000,%00000010
.db %01001110,%11100010
.db %01001010,%10000010
.db %01001110,%11100010
.db %01001010,%10100010
.db %01001110,%11100010
.db %01111111,%11111110
.db %00000000,%00000000

EmptyCard:
.db %01010101,%01010100
.db %00000000,%00000000
.db %01000000,%00000100
.db %00000000,%00000000
.db %01000000,%00000100
.db %00000000,%00000000
.db %01000000,%00000100
.db %00000000,%00000000
.db %01000000,%00000100
.db %00000000,%00000000
.db %01000000,%00000100
.db %00000000,%00000000
.db %01000000,%00000100
.db %00000000,%00000000
.db %01010101,%01010100
.db %00000000,%00000000

.end

