;Running the Halls
;By OneBigDoofus :-) 
;OBD on irc
.nolist
#include "crash82.inc"
.list
.db "Running The Halls v1.2",0

;ported from 82/85 basic game by Harris Novar and David Mazur i think.
;was never released on net i dont think, and i made it on the 82 a thousand
;times and optimized it to about 50% of original speed, but now that it is 
;in asm, it is even faster! if you press 0 at the menu to choose speeds
;you get about the basic speed, if not faster than that
;i also added some graphix to make it a little better than text

cc1 = TEXT_MEM
cc7 = TEXT_MEM+6
cc8 = TEXT_MEM+7
ccy = TEXT_MEM+8
score = TEXT_MEM+9
delayspeed = TEXT_MEM+30


 

 ROM_CALL(CLEARLCD) 
 ld hl,$0003
 ld (CURSOR_ROW),hl
 ld hl,menu_str
 ROM_CALL(D_ZT_STR)
Menu:
 call CR_KHAND		;Built in Crash Key handler
 sbc hl,hl		;hl value is now 0   ;this is used later to figure 
 ld de,2		;de value is now 2   ;the delay speed
 cp K_0			;check if the 0 key is pressed
 jr z,speed0		;if it is pressed, goto speed0
 cp K_1			;check if the 1 key is pressed
 jr z,speed1 		;if it is pressed, goto speed1
 cp K_2			;check if the 2 key is pressed
 jr z,speed2		;if it is pressed, goto speed2
 cp K_3			;check if the 3 key is pressed
 jr z,speed3		;if it is pressed, goto speed3
 cp K_4			;check if the 4 key is pressed
 jr z,speed4		;if it is pressed, goto speed4
 cp K_5			;check if the 5 key is pressed
 jr z,speed5		;if it is pressed, goto speed5
 cp K_6			;check if the 6 key is pressed
 jr z,speed6		;if it is pressed, goto speed6
 cp K_7			;check if the 7 key is pressed
 jr z,speed7 		;if it is pressed, goto speed7
 cp K_YEDIT
 jr z,prevspeed
 cp K_MODE		;check if the MODE key is pressed
 ret z			;if it is pressed, return to crash
 jr Menu		;if none of these buttons were pressed, go back and
			;check again
prevspeed:
 ld hl,(previousspeed)
 jr speed7
speed0:			;
 add hl,de		;hl = hl +2 since de was set to 2 earlier
speed1:
 add hl,de		;hl = hl +2
speed2:
 add hl,de		;hl = hl +2
speed3:
 add hl,de		;hl = hl +2
speed4:
 add hl,de		;hl = hl +2
speed5:
 add hl,de		;hl = hl +2
speed6:
 add hl,de		;hl = hl +2
speed7:
 ld (delayspeed),hl	;delayspeed is now the value of hl
 ld (previousspeed),hl	;suggestion from Tim R if you press second, the previous
			;speed you chose is obtained
loop:
 ld a,100		;just a random value above 16 to use so you wont get
 ld hl,cc1		;hit at the beginning, now point hl to cc1
 ld b,8			;load 8 into b, so it repeats 7 times
loop1:			;here for djnz, so we can put it 100 into TEXT_MEM+0-7  
 ld (hl),a		;load a to where hl is pointing, which is TEXT_MEM+7-b
 inc hl			;point hl to next variable
 djnz loop1		;dec b \ jr nz,loop1
 call RAND		;function in crash to put a random number into a
 and %00000111		;gets last 3 bits, so a is 0-15
 ld (ccy),a		;puts the value of a, into ccy, which is where you start
 sbc hl,hl 		;
 ld (score),hl		;puts the score at 0

mainloop:
;This is a small getkey routine, taken from CrASH_Man's sprite test
;It allows smooth moving, and doesnt start off slow like GET_KEY
  LD  A, $FF \ OUT ($01), A     ; Reset Port
  LD  A, $BF \ OUT ($01), A     ; Mask out MODE and 2nd
  IN  A, ($01)
  BIT 6, A \ jr z,EXIT              ; If MODE pressed, done
  BIT 5, A \ jr z,pause      ; If 2nd pressed, delay

  LD  A, $FF \ OUT ($01), A     ; Reset Port
  LD  A, $FE \ OUT ($01), A     ; Mask out Arrows
  IN  A, ($01)
  BIT 1, A \ jr Z, moveleft
  BIT 2, A \ jr Z, moveright 
scroll:				; Lable here to come back from jumps
 call Scroll_U			; Scrolls up and puts the you sprite back and a new enemy
 call CR_GRBCopy		; fast graphbuffer copy; built in crash
 ld a,(ccy)			; the value @ ccy is now a
 ld hl,cc8			; hl now points to cc8
 cp (hl)			; compare a to whats at cc8
 jr z,EXIT			; if it is the same, you lose, goto exit
 ld hl,(score)			; hl is the value @ score
 inc hl				; hl=hl+1
 ld (score),hl			; put the new hl back in score
 ld a,(delayspeed)		; the value @ delayspeed is now a
 or a				; like cp 0, but shorter/faster
 jr z,mainloop			; if its 0, dont delay any, go back to beginning
delay:				; takes some time
 call CR_GRBCopy		; routine takes a while, so it is used to delay game
 dec a \ jr nz,delay		; a=a-1 if a is not 0, delay longer
 jr mainloop			; if a is 0, goto beginning

moveright:			; routine to move you right
 ld a,(ccy)			; put the value @ ccy into a
 cp 15				; compare a to 15
 jr z,scroll       		; if it is 15, you cant go any farther right, go back
 inc a				; a=a+1
 ld (ccy),a			; put a back into ccy
 jr scroll			; go back
moveleft:
 ld a,(ccy)			; put the value @ccy into a
 or a				; like cp 0, but shorter/faster
 jr z,scroll       		; if it is 0, go back
 dec a				; a=a-1
 ld (ccy),a			; put a back into ccy
 jr scroll			; go back	
pause:
 call GET_KEY   		; reset keyport so it doesnt goto 2nd already
 LD  HL,$0903        		; set up the coords for displaying the score
 LD  (CURSOR_ROW),HL		
 ld hl,(score)			; put score in hl
 ROM_CALL(D_HL_DECI)		; display the score
 call CR_KHAND			; uncrashable KHAND, lets you 
 cp K_MODE			; if mode is pressed, 				; 
 jr z,EXIT			; quit
 call GET_KEY			; reset keyport
 call CR_GRBcopy
 jp mainloop			; go back

EXIT:
 LD  HL,$0903        		; set up the coords for displaying the score
 LD  (CURSOR_ROW),HL		
 ld hl,(score)			; put score in hl
 ROM_CALL(D_HL_DECI)		; display the score
 LD  HL,$0303       		; set up coords for displaying "Score:"
 LD  (CURSOR_ROW),HL		; 
 ld hl,score_str		; write "score:"	
 ROM_CALL(D_ZT_STR)		; function to do it
 ld hl,$0404			; new coords to write "High:"
 ld (CURSOR_ROW),HL
 ld hl,high_str
 ROM_CALL(D_ZT_STR)		; display "High:"
 ld a,(delayspeed)		; used to determine where the highscore is
 ld hl,high7-1			; hl is 
 inc a
highloop:
 inc hl
 dec a
 jr nz, highloop
 push hl
 call LD_HL_MHL
 push hl
 ld de,(score)
 call CP_HL_DE
 jr c,newhigh
 pop hl
 ROM_CALL(D_HL_DECI)
 pop de
 jr wait
newhigh:
 pop hl \ pop de
 ld hl,score
 ldi
 ldi
 dec hl \ dec hl
 call LD_HL_MHL
 ROM_CALL(D_HL_DECI)
wait:
 call CR_KHAND 
 cp K_LEFT
 jr z,wait
 cp K_RIGHT
 jr z,wait
 cp K_MODE
 jr z,wait
 ret

Scroll_U:                       ; [16228 Clock Cycles]-- 63 less now that i took out the pushes and pops
  LD  HL, GRAPH_MEM+96          ; Copy from one row below top
  LD  DE, GRAPH_MEM             ;   to top row
  LD  BC, 672                   ;   672 bytes
  LDIR                          ; another routine by Crash man
  LD HL,GRAPH_MEM+672
  LD DE,GRAPH_MEM+673
  LD BC,108
  LD A,0
  LD (HL),A
  LDIR
putyou:			;puts a little guy on the screen
 ld a,(ccy)		;puts value of ccy into a
 ld ix, you
 ld  c,0             ;y coord is always 0
 call DrwSpr
movevars:
 ld bc,7
 ld hl,cc7
 ld de,cc8
 lddr           ; i cannot use ldir here so i use lddr
 call RAND	;
 and 15		;0-15
 ld (cc1),a
putenmy:                ;puts enemy
 call RAND              ;put in second enemy two get rid of a little bit of monotony
 and 1          ; between 0-1; only works for numbers that are powers of 2
 or a           ; equivalent to cp 0; but faster and shorter
 ld c,56
 jr z,penmy2
 ld a,(cc1)
 ld ix, enmy1
 jr DrwSpr 
penmy2:
 ld a,(cc1) 
 ld ix, enmy2
DrwSpr:		;great sprite routine by crash man, slightly modified for RTH
  LD  d, a	;do x*6+1
  ADD a, a	;x=2x
  ADD a, d	;x=x+OX(original x)   or x*3
  add a, a	;x=2x
  inc a
  LD  H, 0 \ LD  L, C           ; Do y*12
  LD  B, H
  ADD HL, HL \ ADD HL, BC       ; y=y*3
  ADD HL, HL \ ADD HL, HL       ;  =y*12
  LD  C, A                      ; Do x/4
  SRL C \ SRL C \ SRL C
  ADD HL, BC

  LD  BC, GRAPH_MEM \ ADD HL, BC ; Add address to graphbuf

  AND %00000111                 ; Get the remainder of x/8
  LD  E, 7                      ; Line loop
  LD  D, A                      ; B=how many bits to shift each line
_DS_LineLoop:
  LD  B, D                      ; Shift loop
  LD  A, (IX+0)                 ; Get sprite data
  LD  C, 0
_DS_ShiftLoop:
  RRA \ RR  C                   ; Shift Sprite Line
  DJNZ _DS_ShiftLoop
  INC IX                        ; Inc spritepointer
  OR (HL) \ LD  (HL), A        ; Write line to graphbuf
  INC HL
  LD  A, C
  OR (HL) \ LD  (HL), A
  LD  BC, 11                    ; Calculate next line address
  ADD HL, BC
  DEC E
  JR  NZ, _DS_LineLoop          ; Next line
  RET


previousspeed:
 .dw 0
high7:
 .dw 0
high6:
 .dw 0
high5:
 .dw 0
high4:
 .dw 0
high3:
 .dw 0
high2:
 .dw 0
high1:
 .dw 0
high0:
 .dw 0
you:
 .db %01110000
 .db %01010000
 .db %01110000
 .db %11111000
 .db %01110000
 .db %01010000
 .db %01010000
enmy1:
 .db %01110000
 .db %11111000
 .db %10101000
 .db %11111000
 .db %01110000
 .db %01010000
 .db %01110000
enmy2:
 .db %01110000
 .db %10101000
 .db %10101000
 .db %01110000
 .db %01110000
 .db %11011000
 .db %01110000

menu_str:
 .db "Enter Speed: 0-7",0
 

score_str:
 .db "Score:",0
high_str:
 .db "High:",0
