	.org $D748

	nop
	jp ProgStart
	.dw 0
	.dw ShellTitle

You:
	.db 0
Him:
	.db 0
ShellTitle:
	.db	"Rock Paper Scissors v1.00",0

ProgStart:
	call $4A7E		;_clrLCD
	call $4AB1		;_runIndicOff
	ld hl,Title
	xor a
	ld ($C37D),a	;_curRow
	call _putCenteredString
	ld hl,$Fc70
	call Line
	ld a,9
	ld ($C37D),a
	ld hl,Subtitle
	call _putCenteredString
	ld a,1
	ld (You),a
	ld a,4
	ld (Him),a
PreKeyLoop:
	call DispSprites
KeyLoop:
	halt \ halt
	ld a,%01111110
	out (1),a
	nop \ nop
	in a,(1)
	bit 1,a
	jr z,Left
	bit 2,a
	jr z,Right
	ld a,%00111111
	out (1),a
	nop \ nop
	in a,(1)
	bit 6,a
	jp z,$4A7E		;_clrLCD
	bit 5,a
	jr nz,KeyLoop

;Ok, now get the computer's answer.
RandGen:
	call RandomNumber
	and %00000011
	cp 0
	jr z,RandGen
	ld (Him),a
	call DispSprites
	ld hl,$FDF0
	ld a,36
	ld ($C37D),a
	call Line
	ld a,(Him)
	ld b,a
	ld a,(You)
	cp b
	jr z,Tie
	cp 3
	jr z,CheckScissors
	cp 2
	jr z,CheckRock
	ld a,b
	cp 2
	jr z,Won
Lost:
	ld hl,LostTitle
	jr _end
Tie:
	ld hl,TieTitle
	jr _end
Won:
	ld hl,WonTitle
_end:
	call _putCenteredString
	call $55AA
	jp $4A7E
CheckScissors:
	ld a,b
	cp 1
	jr z,Won
	jr Lost
CheckRock:
	ld a,b
	cp 3
	jr z,Won
	jr Lost


Left:
	ld a,(You)
	dec a
	cp 0
	jr nz,LoadAndReturn
	ld a,3
	jr LoadAndReturn
Right:
	ld a,(You)
	inc a
	cp 4
	jr nz,LoadAndReturn
	ld a,1
LoadAndReturn:
	ld b,16
LARLoop:
	halt
	djnz LARLoop
	ld (You),a
	jp PreKeyLoop
DispSprites:
	ld a,(You)
	ld b,a
	ld c,6
	call SpritePut
	ld a,(Him)
	ld b,a
	ld c,9
SpritePut:
	ld hl,Sprites-8
	ld de,$0008
SPLoop:
	add hl,de
	djnz SPLoop
	ld e,c
	ld d,2
	jp GridPutSprite

;Line
Line:
	ld b,16
LLoop:
	ld a,255
	ld (hl),a
	inc hl
	djnz LLoop
	ret

;Find The Length (# Of Pixels) Of The String Pointed To By HL (_vputs text)
;-=-=--=-=-=-=-==-=--=-=-=-===-=-=-=-=-==--=-=-==-=-=-==--=-=-==-
;Input: HL = Pointer to Zero-Terminated String
;Output: C = Length Of String (Pixels)
;Destroys: All Registers
;=-=-=-=-=-===-=-=-=-=-=-===-=-=-=-=--==--=-=-===-=-=-=-===-=-=-=
_strpixels:
	ld c,0
_strpl:
	ld a,(hl)
	or a
	ret z
	push hl
	call $56A1		;_get_vchar
	ld a,(hl)
	add a,c
	ld c,a
	pop hl
	inc hl
	jr _strpl

_putCenteredString:
	push hl
	call _strpixels
	pop hl
	ld a,128
	sub c
	rra
	ld ($C37C),a
	jp $4AA5

Sprites:

Paper:
	.db %11111111
	.db %10000001
	.db %10111001
	.db %10000001
	.db %10101101
	.db %10000001
	.db %10000001
	.db %11111111

Rock:
	.db %01111110
	.db %10010001
	.db %10000101
	.db %11011001
	.db %10000011
	.db %10101001
	.db %11100001
	.db %01111110

Scissors:
	.db %00011000
	.db %00100100
	.db %00100100
	.db %00011000
	.db %00011000
	.db %00100100
	.db %01000010
	.db %01000010

Question:
	.db %00111100
	.db %01111110
	.db %01000110
	.db %00001110
	.db %00011100
	.db %00000000
	.db %00011100
	.db %00011100

;===========================================================
; GridPutSprite:                                  [Dan Eble]
;  Puts an aligned sprite at (E, D), where HL -> Sprite
;===========================================================
; IN : D  = y (0-7 inclusive)
;      E  = x (0-15 inclusive)
;      HL-> sprite
;
; OUT: AF, BC, DE, HL, IX modified
; Current total : 28b/567t (not counting ret)
;===========================================================
GridPutSprite:
 push hl
 pop ix                 ; ix-> sprite
 srl d                  ; de = 128y+x (16 bytes/row, 8 rows)
 rra
 and $80
 or e                   ; add x offset (remember x <= 15)
 ld e,a
 ld hl,$fc00            ; hl-> video ram
 add hl,de              ; hl-> video ram + offset
 ld b,8                 ; initialize loop counter
 ld de,$10              ; initialize line increment
GPS_Loop
 ld a,(ix+0)            ; get byte from sprite
 ld (hl),a              ; put byte on screen
 inc ix                 ; move to next byte in sprite
 add hl,de              ; move to next line on screen
 djnz GPS_Loop
 ret


;===========================================
; RandomNumber     [Assembly Coder's Zenith]
; out: A = psuedo random number
; modified: AF, BC    (14 bytes/62 t-states)
;===========================================
RandomNumber:
  ld a,r
  ld b,a
  ld a,($1234)
_@RandomNumberSeed = $-2
  ld c,a
  ld a,(bc)
  ld (_@RandomNumberSeed),a
  xor b
  sub b
  add a,c
  ret


Title:
	.db "Paper, Rock, Scissors 1.0",0
Subtitle:
	.db "You            Him",0
LostTitle:
	.db "You Lost!",0
TieTitle:
	.db "It's a Tie!",0
WonTitle:
	.db "You Won!",0

.end