;Repeat After Me v1.1						08/27/00
;--------------------
;by Levi Lansing
;	-puzzlesome@hotmail.com
;	-http://www.crosswinds.net/~levisti86/    <--TI-86 Assembly help site**
;
;You are free to use anything you'd like from here as long as you give proper credit.
;You may not however edit and distribute this program unless directly to your friends
;and you must also mark the program in an obvious way so it is obvious that it was
;changed.
;
;(compiled with assembly studio 86 v3.0 BECAUSE THE UNDO DOESN'T WORK IN v3.1!!! : )
;
;by the way, the random routine for the rand #'s 1-9 is *VERY* good, but the one that
;chooses a random position for the numbers on the title screen is not so good and not
;quite perfectly random, but close enough for what I need.
;------------------------------------------------------------------------------------

#include "ti86asm.inc"
#include "asm86.h"
#include "ti86und.inc"

_user_int_ram EQU $d2fd

.org _asm_exec_ram

	nop					;Ashell discription...
	jp ProgStart
	.dw 0
	.dw ShellTitle		;location of the title name

ShellTitle:
	.db "Repeat After Me   -   v1.1",0		;Ashell- title to be displayed
ProgStart:


 ld (StackPointer),SP	;save the stack pointer so we don't have to worry if it isn't
						;where it should be when we're ready to quit
 call _runindicoff		;turns off the annoying run indicator
 call _flushallmenus	;exits all open menus

 ld hl,Settings		;point hl to the settings
 ld (hl),1			;load the standard settings
 bit 2,(iy+$23)		;if the interrupt is off...
 jr z,clear_int		;we don't want to copy it
 ld (hl),%00000011	;we are going to copy the old interrupt- tell the program we did
					;this way programs like my CoolTool that use the interrupts at all
					;times will be restored at the end of the game
 res 2,(iy+$23)		;turn user int off so it won't get called by
					;accident before we're ready
 ld hl,_user_int_ram	;copy the existing int program so we can restore it
 ld de,$f971			;hl points to where to copy from and de is where to copy to
 ld bc,255				;255 bytes in the interrupt
 ldir					;copy, increment de/hl(decrement bc) and repeat until bc=0 
clear_int:		;I always clear the interrupt for neatness (mainly for debugging)
 ld hl,$d2fd	;point hl to interrupt RAM
 ld (hl),$5A	;$5A is the standard checksum for a blank interrupt
 inc hl			;point hl one byte forward
 ld (hl),0		;clear the next byte
 ld de,$d2ff	;point de to the byte after hl
 ld bc,198		;we have to clear 198 bytes (of 200) since we already did the 1st & 2nd
 ldir			;clear it out

 ld hl,int				;hl point to the begining of the program
 ld de,_user_int_ram+1	;de pionts to where the program is to be loaded
 ld bc,int_end-int		;bc is the length of the program to be sent
 ldir					;copies it

 ld a,(_user_int_ram+1)			;this sets up checksum byte - 
 ld hl,_user_int_ram+($28*1)	;we need to add the 1st bite with another one
 add a,(hl)						;every 40 bytes and store it in the...
 ld hl,_user_int_ram+($28*2)
 add a,(hl)
 ld hl,_user_int_ram+($28*3)
 add a,(hl)
 ld hl,_user_int_ram+($28*4)
 add a,(hl)
 ld hl,_user_int_ram+($28*5)
 add a,(hl)
 ld (_user_int_ram),a			;first byte of the interrupt area
 set 2,(iy+$23)				;turn on the interrupt

 res appAutoScroll,(iy+appflags)	;turn off autoscroll (for when we print at the
									;bottom of the screen)
 ld de,TitlePic
 call decompV			;decompress the title picture to the screen

 ld a,r				;r is some kind of code counter (increments after every command)
 ld hl,Random_num+1	;point hl to the random number
 rra				;rotate a twice to the right to mix up it's value a little bit
 cp a
 rra				;same as dividing it by 4 (divides it by 2 twice)
 ld (hl),a			;r is kinda random so we'll use it as a seed value
 ld a,r				;this will make the first number a little more random
 rra
 ld b,a
DT:
 inc (hl)
 ld a,(hl)
 cp 119
 jr c,Not120PLUS
 ld (hl),1
Not120PLUS:
 djnz DT
					;done randomizing...


LoopTITLEanimation:
 ld hl,Random_num+1
 ld b,(hl)			;x coord for the circle to display
 push bc
 ld a,r				;this will make the first number a little more random
 rra
 ld b,a
DT2:
 inc (hl)
 ld a,(hl)
 cp 119
 jr c,Not120PLUS2
 ld (hl),1
Not120PLUS2:
 djnz DT2
					;done randomizing again...
 pop bc
 ld a,(hl)			;load a with the random number
 cp a				;clear the carry flag
 rra				;divide a by 2
 inc a				;so it's not 0
 ld c,a			;y coord for the circle to display
 cp 55
 jr c,TisOK
 ld c,55
TisOK:			;from here to the XYOK label we're just making sure the sprites
 ld a,c			;(letters) aren't displayed in the writing in the center of the screen
 cp 45
 jr nc,YBOTTOM
 ld a,b
 cp 24
 jr c,XYOK
 cp 102
 jr c,LoopTITLEanimation
 jr XYOK
YBOTTOM:
 ld a,b
 cp 40
 jr c,XYOK
 cp 77
 jr c,LoopTITLEanimation
 ld a,c
 cp 49
 jr c,XYOK
 ld a,b
 cp 112
 jr nc,LoopTITLEanimation
XYOK:
 push bc
 ld ix,N1-8
 ld a,(Random_num)		;rand # 1-9
 ld b,a
 ld de,8
pointIX:
 add ix,de
 djnz pointIX
 pop bc
 push ix
 call TinySprite  	;displays the random number at the random place
 pop ix
 push bc
 ld b,13
dlayT:
 halt
 djnz dlayT
 pop bc
 call TinySprite	;erases the random number ar the random place
 call _getky	;check for a key press
 cp 0			;makes sure we don't miss a few keys that won't show up if you don't
 jr z,LoopTITLEanimation	;if no key was pressed, loop this intro


 ld de,bground			;point de to the background pic
 call decompV			;and decompress it to the screen
 xor a
 ld (Level),a
 ld a,110
 ld (Timer),a
 ld a,$80
 ld (Timer2max),a
MLOOP:
 call Delay2		;guess what this is... A DELAY! DUH
 ld bc,$0E4C
 ld (_penCol),bc
 ld hl,ByText
 call _vputs		;Display "by Levi Lansing"
 call Delay2
 ld bc,$0B04
 ld (_curRow),bc
 ld hl,ReadyText
 call _puts			;Displays "Get Ready"
 call DelayLong
 ld bc,$0B04
 ld (_curRow),bc
 call _puts			;spaces (erases it)
 call NewLevel+3	;skip the delay call just this once

Main:
 ld hl,Settings			;I honestly don't think I need this any more, but it skips
 bit 2,(hl)				;the timer check if bit 2 of the settings is 0
 jr z,SkipTimerCheck
 ld hl,Timer2
 ld a,(Timer2max)
 cp (hl)
 jp c,TimeUp
 						;*************************
 ld a,(Timer2)
 ld b,a
 ld a,(Timer2max)		;Timer2max value is what we need to start the timer at
 sub b					;get the total time left
 cp a
 rra					;divide a by 2
 cp 65
 jr c,notTOOhigh		;if it's bigger than 64
 ld a,64				;make it 64
notTOOhigh:
 ld b,a
 ld a,64
 sub b					;make sure we clear the extra at the top...
 ld b,a
 ld de,16				;16 bytes per row on the screen
 ld hl,$FC0F
 cp 0					;if there aren't any to clear at the top, skip this part
 jr z,NoPXoff
 push bc
PXoffLOOP:
 ld a,%11111110
 and (hl)				;clear only bit 0, leave the rest alone
 ld (hl),a				;put it on the screen
 add hl,de				;move to the next row
 djnz PXoffLOOP
 pop bc
NoPXoff:
 ld a,64
 sub b				;get back the number of pixels to fill (blacken)
 ld b,a
PXonLOOP:			;turns the pixels on on the right side for the timer
 ld a,%00000001
 or (hl)			;turns only bit 0 to a 1
 ld (hl),a			;display it on the screen
 add hl,de			;move to the next row
 djnz PXonLOOP

SkipTimerCheck:
 ld a,%00111111
 out (1),a
 in a,(1)
 bit 6,a			;check if exit is pressed
 jp z,Exit
 ld a,%01101111		;the following checks for a # to be pressed
 out (1),a
 in a,(1)
 bit 1,a
 ld b,1				;if 1 was pressed
 call z,Cpush
 call nz,Cinv
 bit 2,a
 ld b,4				;if 4
 call z,Cpush
 call nz,Cinv
 bit 3,a
 ld b,7				;if 7
 call z,Cpush
 call nz,Cinv
 ld a,%01110111
 out (1),a
 in a,(1)
 bit 1,a
 ld b,2				;if 2
 call z,Cpush
 call nz,Cinv
 bit 2,a
 ld b,5				;if 5
 call z,Cpush
 call nz,Cinv
 bit 3,a
 ld b,8				;if 8
 call z,Cpush
 call nz,Cinv
 ld a,%01111011
 out (1),a
 in a,(1)
 bit 1,a
 ld b,3				;if 3
 call z,Cpush
 call nz,Cinv
 bit 2,a
 ld b,6				;if 6
 call z,Cpush
 call nz,Cinv
 bit 3,a
 ld b,9				;if 9
 call z,Cpush
 call nz,Cinv
 HALT				;a very minor delay, saves some battery
 HALT
 jp Main

TimeUp:
 ld b,9				;the following will uninvert any #'s that are being pushed when
 ld hl,onoff-1		;the time runs out
LOOPtu:
 inc hl
 xor a
 cp (hl)
 jr z,NOinvTU		;aren't inverted? don't uninvert them then!
 push bc
 push hl			;push hl because the sprite routine destroys it
 ld a,10
 sub b
 ld b,a				;10-b=the # that needs to be uninverted
 call invertcir		;uninverts them
 pop hl
 pop bc
NOinvTU:
 djnz LOOPtu		;loops to check all 9
 ld hl,Position
 inc (hl)
 ld hl,TimeUpText
 jr ContinueTU
LOST:
 ld hl,BuzText
ContinueTU
 ld bc,$0B04
 ld (_curRow),bc
 call _puts			;display "Time Up"
 ld b,100
DLloop:
 HALT
 djnz DLloop
 ld a,(Position)	;this will be the # the user should have pushed
 ld b,a
 ld hl,Numbers-1
Lloop:
 inc hl
 djnz Lloop
 ld d,(hl)
 ld b,6
RPloop:				;flashes the correct number 3 times (6 inverses)
 push bc
 ld b,d				;b=# to flash
 call invertcir		;invert the number on the screen
 call Delay2
 pop bc
 djnz RPloop
 ld hl,ReplayText
 ld bc,$0B04
 ld (_curRow),bc
 call _puts			;display "Replay..."
 ld b,100
RPloop2:
 HALT
 djnz RPloop2
 ld a,95				;slow down the timer (if you're in a high level) so you have
 ld (Timer),a			;more time to see what you forgot
 call PlayNumberCall	;replays the code
 call DelayLong

Exit:
 call ScreenEffect
 call _homeup
 ld hl,gameovertext
 call _puts				;display "game over"
 ld bc,$0001
 ld (_curRow),bc		;_curRow=c		_curCol=b
 call _puts				;display "you reached level"
 ld bc,$0002
 ld (_curRow),bc
 ld a,(Level)
 ld l,a					;l=Level #
 xor a					;a=0
 ld h,a					;h=0	--AHL = Level #
 call _dispAHL			;display the level number
 ld b,200				;delay
DEloop:
 HALT			;pause the cpu until the next interrupt occurs
 djnz DEloop	;loop 200 times
					;check if it's a highscore
 ld b,7
 ld hl,HighScores
 ld a,(Level)
 ld c,a				;c=score
CHECKloop:
 ld a,(hl)
 cp c				;if the current score is higher than the one it was compared to
 jr c,BeatIt		;then there was a carry, so jump to BeatIt
 inc hl
 djnz CHECKloop
 jp DispHighs		;no high score
BeatIt:
 push bc
 call ScreenEffect
 call _homeup
 ld hl,HighText
 call _puts
 pop bc
 push bc
 ld a,8
 sub b
 ld b,a
 ld hl,HighScoreNames+1
 ld de,21
HNloop:
 add hl,de
 djnz HNloop
 pop bc
 push hl
 ld hl,HighScoreNames+127		;points to the second to last name
 ld a,1
 cp b							;if b=1, the last name will be erased and no names need
 jr z,SkipHNloop2				;to be moved (skip this routine)
 push bc
HNloop2:		;moves the names down the list
 push bc
 ld bc,21
 ld de,21
 push hl
 push hl
 add hl,de
 pop de
 ld a,d
 ld d,h
 ld h,a
 ld a,e
 ld e,l
 ld l,a
 ldir
 pop hl
 pop bc
 ld de,21
 sbc hl,de
 djnz HNloop2
 pop bc
 dec b
 ld hl,HighScores+5
MoveScoresLoop:			;moves the scores with the names
 ld a,(hl)
 inc hl
 ld (hl),a
 dec hl
 dec hl
 djnz MoveScoresLoop
 inc hl
 ld a,(Level)
 ld (hl),a
 jr alreadydonethat

SkipHNloop2:
 ld hl,HighScores+6
 ld a,(Level)
 ld (hl),a				;put your new score in
alreadydonethat:
 pop hl
	push hl
	res 5,(iy+shiftflags)	;caps on
	set shiftAlpha,(iy+shiftflags)
	ld b,16				;no more than 16 characters
EnterName_Loop:			;this is the part that gets your name
	push bc
	call _getky
	pop bc
	cp K_ENTER
	jr z,SaveIt
	cp K_LEFT
	jr z,Delete
	cp K_DEL
	jr z,Delete
	cp K_ALPHA
	jr z,ALPHA
	ld c,a
	ld a,b
	cp 0
	jr z,EnterName_Loop
	ld a,c
	cp $09
	jr c,EnterName_Loop
	cp $2F
	jr nc,EnterName_Loop
	push bc
	sub 9
	ld b,a
	ld hl,CharTable-1
CharLoop:
	inc hl
	djnz CharLoop
	pop bc
	ld a,(hl)
	cp 0
	jr z,EnterName_Loop
	cp ' '
	jr z,CAPS
	bit 5,(iy+shiftflags)
	jr z,CAPS
	add a,32				;add 32 to go from caps to lower case
CAPS: 
	pop hl
	ld (hl),a
	inc hl
	push hl
	call _putc
	dec b
	jr EnterName_Loop
Delete:
	ld a,b
	cp 16
	jr z,EnterName_Loop
	ld a,' '
	call _putc
	ld hl,_curCol
	dec (hl)
	dec (hl)
	call _putc
	dec (hl)
	inc b
	pop hl
	dec hl
	ld (hl),' '
	push hl
	jr EnterName_Loop
ALPHA:							;inverses the case of the next letter
	xor a
	ld c,a
	set 5,c						;upper/lower case flag bit
	ld a,(iy+shiftflags)
	xor c
	ld (iy+shiftflags),a
	jr EnterName_Loop	

SaveIt:
	;res shiftALock,(iy+shiftflags)
	pop hl
	xor a
	cp b
	jr z,DispHighs
FillLoop:
	ld a,' '
	ld (hl),a
	inc hl
	djnz FillLoop

;****Taken From ZTetris, But the bytes to copy and some labels were modified
SaveScore:								 ;Saves The New High Score
	ld hl,ProgName     		   ; All this stuff is to make sure the hiscore table
	rst 20h	  				     ; and resume stuff are stored in the variable
	rst 10h
	ex de,hl	 		     	 ; HL -> start of variable
	ld a,b
	ld de,HighScoreNames-$D748+4  ; DE = relative offset to stuff to store (-4)
	add hl,de
	adc a,0	  				     ; Next block if necessary
	ld de,HighScoreNames	       ; DE = start of bytes to copy
	ld b,177	       					; 177 bytes to copy
RepCopy:
	push af
	push hl
	call $46C3
	ld a,(de)	       ; Read
	ld (hl),a	       ; And save it in the real variable
	pop hl
	pop af
	call $4637
	inc de
	djnz RepCopy


DispHighs:
 call ScreenEffect
 call _homeup
 ld hl,HighScoreNames
 set textInverse,(iy+textflags)		;inverse text
 call _puts
 res textInverse,(iy+textflags)		;uninverse text
 call _puts							;display the names
 inc hl					;point it to the scores
 ld de,$1001
 ld (_curRow),de
 ld b,7					;7 scores to print
HSLoop:
 push hl				;hl points to the score
 push de				;de is the coordinates to where the score will be displayed
 ld a,(hl)
 ld l,a					;l=score
 xor a					;a=0
 ld h,a					;h=0		-- AHL=score
 call _dispAHL
 pop de
 pop hl
 inc hl					;point to next score
 inc e
 ld (_curRow),de		;cursor to next line
 djnz HSLoop
 call _getkey			;wait for key press
 set appAutoScroll,(iy+appflags)	;turn back on the autoscroll
 call ScreenEffect
 call _clrScrn					;clear screen and text shaddow
 call _homeup					;move the cursor position to the top right
 call restore_int				;restore the old interrupt program (if there was one)
 ld SP,(StackPointer)			;restore the stack pointer
 ret

Cpush:					;pushes the buttons
 push af
 push bc
 ld b,9
 ld hl,onoff
 xor a
LOOPp0:
 add a,(hl)
 inc hl
 djnz LOOPp0
 pop bc
 cp 0
 jr nz,CPdone
 ld hl,onoff-1
 push bc
LOOPp:
 inc hl
 djnz LOOPp
 pop bc
 ld (hl),1
 push bc
 call invertcir
 ld hl,Timer2
 ld (hl),0
 ld hl,Settings
 set 2,(hl)
 pop bc
CPdone:
 pop af
 ret

Cinv:				;un inverts the button
 push af
 push bc
 ld hl,onoff-1
LOOPi:
 inc hl
 djnz LOOPi
 pop bc
 xor a
 cp (hl)
 jr z,CIdone
 ld (hl),0
 push bc
 call invertcir
 pop bc
;Make sure the right # was pressed:
 ld c,b
 ld a,(Position)
 inc a				;move the position forward
 ld (Position),a
 ld b,a
 ld hl,Numbers-1
Cloop:
 inc hl				;point hl to the correct number of the code
 djnz Cloop
 ld a,c
 cp (hl)
 jp nz,LOST			;if the wrong number was pushed, player lost
 ld a,(Level)
 ld b,a
 ld a,(Position)
 cp b
 call z,NewLevel	;if that was the end of the number code, advance to the next level
CIdone:
 pop af
 ret

invertcir:				;input: b=the number to inverse
 push af
 push de
 push bc
 ld hl,circoords-2
LOOPc:
 inc hl
 inc hl
 djnz LOOPc
 ld b,(hl)
 inc hl
 ld c,(hl)
 jr skipPushes		;I need the pushes for when dispCIR is called from elsewhere
dispCIR:
 push af
 push de
 push bc
skipPushes:
 ld ix,circle
 call TinySprite		;displays the first quarter of the circle
 push bc
 ld a,8
 add a,b
 ld b,a
 call TinySprite		;2nd quarter
 pop bc
 ld a,8
 add a,c
 ld c,a
 call TinySprite		;3rd quarter
 ld a,8
 add a,b
 ld b,a
 call TinySprite		;4th quarter
 pop bc
 pop de
 pop af
 ret

NewLevel:
 call DelayLong
 ld a,(Timer2max)		;Timer2max value is what we need to start the timer at
 cp a
 rra					;divide a by 2
 cp 65
 jr c,notTOOhighNL		;if it's bigger than 64
 ld a,64				;make it 64
notTOOhighNL:
 ld b,a
 ld a,64
 sub b					;make sure we clear the extra at the top...
 ld b,a
 ld de,16				;16 bytes per row on the screen
 ld hl,$FC0F
 cp 0					;if there aren't any to clear at the top, skip this part
 jr z,NoPXoffNL
 push bc
PXoffLOOPNL:
 ld a,%11111110
 and (hl)				;clear only bit 0, leave the rest alone
 ld (hl),a				;put it on the screen
 add hl,de				;move to the next row
 djnz PXoffLOOPNL
 pop bc
NoPXoffNL:
 ld a,64
 sub b				;get back the number of pixels to fill (blacken)
 ld b,a
PXonLOOPNL:			;turns the pixels on on the right side for the timer
 ld a,%00000001
 or (hl)			;turns only bit 0 to a 1
 ld (hl),a			;display it on the screen
 add hl,de			;move to the next row
 djnz PXonLOOPNL

 xor a
 ld (Position),a
 ld hl,Timer
 dec (hl)
 dec (hl)
 dec (hl)
 ld a,14		;if the timer has gone below 14, the game's going too fast so
 cp (hl)		;we'll change it back to
 jr nz,TOK
 ld (hl),17		;17
TOK:
 ld hl,Level
 inc (hl)				;advance the level
 ld a,1
 cp (hl)
 jr nz,decTimer2
 ld a,$84				;if we're at level one, load the timer max with $80
 ld (Timer2max),a
decTimer2:
 ld a,(Timer2max)
 sub 4
 cp 15					;the minimum time of response (after this it gets too fast)
 jr nc,T2Mok
 ld a,15
T2Mok:
 ld (Timer2max),a
decDONE:		;unused label
 ld a,(hl)
 ld h,0
 ld l,a
 xor a
 ld bc,$1007
 ld (_curRow),bc
 call _dispAHL		;display level number
 ld hl,LevelText
 ld bc,$0D07
 ld (_curRow),bc
 call _puts			;display "Level"
 ld hl,Level
 ld b,(hl)
 ld hl,Numbers-1
NLloop:
 inc hl
 djnz NLloop
 ld a,(Random_num)
 ld (hl),a			;random #->hl
PlayNumberCall:
 ld hl,Numbers
 ld a,(Level)
 ld b,a
PlayNumbers:		;flashes the #'s in order
 push bc
 push hl
 ld b,(hl)
 call invertcir
 call Delay
 call invertcir
 call Delay2
 pop hl
 inc hl
 pop bc
 djnz PlayNumbers
 ld hl,Timer2
 ld (hl),0			;reset the timer
 ld hl,Settings
 set 2,(hl)			;now the timer will be checked again
 ret

Delay:
 push bc
 ld a,(Timer)
 ld b,a
Dloop:
 ld a,%00111111
 out (1),a
 in a,(1)
 bit 6,a
 jp z,Exit
 bit 0,b
 jr nz,skipHALT
 HALT			;save some battery
skipHALT:
 djnz Dloop
 pop bc
 ret

Delay2:
 push bc
 ld a,(Timer)
 ld b,a
D2loop:
 ld a,%00111111
 out (1),a
 in a,(1)
 bit 6,a
 jp z,Exit
 bit 0,b
 jr nz,skipHALT2
 HALT				;save some battery
skipHALT2:
 djnz D2loop
 pop bc
 ret

DelayLong:
 push bc
 ld b,100
D3loop2:
 ld a,%00111111
 out (1),a
 in a,(1)
 bit 6,a
 jp z,Exit
 HALT				;save some battery
 djnz D3loop2
 pop bc
 ret

;this will restore the previous interrupt program and turn it back on
restore_int:
 res 2,(iy+$23)
 ld a,(Settings)
 bit 1,a
 ret z
 ld de,_user_int_ram
 ld hl,$F971
 ld bc,255
 ldir
 set 2,(iy+$23)
 ret

ScreenEffect:
 ld b,64			;b = 64 (counts across the columns)
Start:
 push bc			;hide b for later (and c too)
 ld hl,$FC00		;point hl to the begining of the display memory
 ld de,$8			;8 bytes left to skip on each line after the rotation
 ld b,64			;64 lines to move
TLloop1:
 push bc			;hide b and c
 ld b,8				;8 bytes per half row (64 cols)
 xor a				;a = 0
 rra				;clear the carry flag
TLloop:
 ld a,(hl)			;pull a byte from the screen
 rra				;rotate it right (into the carry flag)
 ld (hl),a			;put the rotation back onto the screen
 inc hl				;point to the next byte
 djnz TLloop
 add hl,de			;move hl to the next row
 pop bc				;restore the most recently pushed bc
 djnz TLloop1		;loop 64 times
 ld hl,$FC0F		;points to the end of the first row of the display mem
 ld de,$18			;since we have to move backwards, we have to skip nearly 2 rows
 ld b,64			;64 rows
TRloop1:
 push bc
 ld b,8				;8 bytes per half row
 xor a				;clear a
 rla				;rotate a left to clear the cary flag
TRloop:
 ld a,(hl)			;get byte from screen
 rla				;rotate it left
 ld (hl),a			;put the rotated byte back
 dec hl				;point hl to the previous byte
 djnz TRloop		;loop until the end of the row
 add hl,de			;point hl to the end of the next row
 pop bc
 djnz TRloop1		;loop 64 times (64 cols to move through)
 pop bc
 djnz Start			;loop 64 times to clear the whole screen!
 ret

;********************************************************
; -decompresses data that is vertically compressed with
; bmp2asm, by Levi Lansing    (total size=63 bytes)
; -(decompresses data into the video memory - 1024 bytes)
; -de=location of data to decompress
; -destroys- a,b,c,hl,de (points to byte after data)
;********************************************************
decompV:
 ld hl,$FC00        ;point hl to the screen mem
decompLoop:
 ld a,(de)          ;load the first byte of the compressed data
 cp $B7             ;check if it's a marker
 jr nz,DCnorm       ;if it's not, treat it as a normal byte
 inc de             ;if the byte is marked, the next byte tells us the value
 ld a,(de)          ;that is repeated so we
 ld c,a             ;put that in c
 inc de             ;the next byte tells us how many times it's repeated
 ld a,(de)
 ld b,a             ;we will load that into b to be used as a counter
 inc de             ;point to the next byte for later
DCrepeatLoop:
 ld (hl),c          ;put the value in the screen mem once
 push de            ;hide de
 ld de,16
 add hl,de          ;point hl to the next row (16 bytes forward)
 jr nc,DCloop       ;if hl isn't past the end of the screen data ($FFFF), then continue
 call DecompDelay	;*** Added in to create the slow horizontal effect ***
 ld de,1022         ;if it is, we need to put it back to the next column
 sbc hl,de          ;point hl to the 1st row of the next column
 ld a,l
 cp $10             ;if l is over $10 (16d), it has completed the full screen
 jr c,DCloop        ;jump if it's no over $10 to continue
 pop de             ;restore de again
 ret                ;return from the routine
DCloop:
 pop de             ;restore de
 djnz DCrepeatLoop  ;decrement b and continue loading the same byte down the
                    ;column until b is 0
 jr decompLoop      ;continue with the next byte
DCnorm:
 ld (hl),a          ;load the byte into the screen mem
 inc de             ;point de to the next byte
 push de            ;hide it
 ld de, 16
 add hl,de          ;point hl to the next row (16 bytes forward)
 pop de             ;restore de
 jr nc,decompLoop   ;if hl did not go past $FFFF (it would flip to 0) then continue
 push de            ;hide de again
 call DecompDelay	;*** Added in to create the slow horizontal effect ***
 ld de, 1022
 sbc hl,de          ;hl-1022 put's it at the 1st row of the next column
 ld a, l
 cp $10             ;see if hl is past the 1st row (if it is, the decompressing's done)
 pop de             ;restore de again
 jr c,decompLoop    ;if we're not done, keep going...
 ret                ;if we get here, we're done and will return from the routine

DecompDelay:
 push bc			;hide bc so it doesn't get changed
 ld b,4				;4 times
DDLOOP2:
 HALT				;pause the CPU until the next interrupt occurs
 djnz DDLOOP2		;loop and decrement b until it's 0
 pop bc				;restore bc
 ret				;back to the decompressing

;********************************************************
;TinySprite by Levi Lansing (puzzlesome@hotmail.com)
;   - one of the smallest putsprites I've seen (74 bytes)
;input-
;  ix-points to 8x8 sprite
;  bc-(x,y) location
;output-
;   the sprite!
;DESTROYS- a, d, e, hl, (ix-points to next sprite)
;********************************************************
TinySprite:
 push bc
 ld a,(DispLoc)
 ld h,a				;3F shifts to $FC with add hl,hl
 ld a,c
 add a,a			;a*4
 add a,a
 ld l,a
 xor a
 add hl,hl			;hl*4 (what was c has been mlt by 16)
 add hl,hl
 ld a,b				;a/8
 sra a
 sra a
 sra a
 or l				;add to more significant bytes
 ld l,a
 ld a,7				;use bottom 3 bits for counter (the # will be <8)
 and b
 ld d,a				;save counter copy in d
 ld e,8				;8 rows

ps_loop:
 ld b,d				;get saved bit offset in b
 ld a,(ix)			;get this byte of the sprite in a
 inc ix				;point ix to the next byte of the sprite
 ld c,0
 call bit_shift
 xor (hl)			;change this to 'or' or 'and' if you want
 ld (hl),a
 inc l
 jr nz,NoOver
 inc h
 xor a
 cp h
 ret z
NoOver:
 ld a,(hl)
 xor c				;also changable (if you changed the first)
 ld (hl),a
 ld a,15			;add 15 to hl (now ready for next row)
 call add_hl_a
 dec e				;counter (8 rows)
 jr nz,ps_loop
 pop bc
 ret

add_hl_a:			;add hl,a
 add a,l
 ld l,a
 ret nc
 inc h
 ret

bit_shift:			;while(b=<0)
 dec b				;a>>c
 ret m
 srl a
 rr c
 jr bit_shift

DispLoc:
 .db $3F


int:
 push af
 push hl
 ld hl,Random_num		;the random num works similar to a computer's, it constantly
 inc (hl)				;rotates through the numbers until the program needs one
 ld a,(hl)				;by now it's random since time goes by because of the users

MaxRandNum  equ  _user_int_ram+9		;defines the lable to point at the 10 below

 cp 9					;actions (we only need 9 numbers so we start over after 9)
 jr c,done
 ld (hl),1
 ld hl,Timer2			;every 9 times the interrupt runs, we increase this timer
 inc (hl)				;that keeps track of how long the user has been idle
done:
 pop hl
 pop af
 ret
int_end:




;*******all the variables are down here*******

ByText:
	.db "by Levi Lansing",0
LevelText:
	.db "Level",0
BuzText:
	.db "**WRONG**",0
TimeUpText:
	.db "Time up!!",0
ReplayText:
	.db "Replay...",0
gameovertext:
	.db "Game Over",0
	.db "You reached level",0
HighText:
	.db "You got a HighScore! "
	.db "Enter Your Name:     ",0
ReadyText:
	.db "Get Ready.",0
	.db "          ",0
HighScoreNames:
	.db "----Name--------Level",0
	.db "Genius               "
	.db "Near Genius          "
	.db "Quite Smart          "
	.db "Almost Smart         "
	.db "Just Average         "
	.db "Below Average        "
	.db "Retard               ",0
HighScores:
	.db 30
	.db 25
	.db 20
	.db 16
	.db 9
	.db 6
	.db 3

CharTable:
	.db 'X','T','O','J','E', 0 , 0 ,' ','W','S','N','I','D'
	.db  0 , 0, 'Z','V','R','M','H','C', 0 , 0 ,'Y','U','Q'
	.db 'L','G','B', 0 , 0 , 0 ,'-','P','K','F','A'
ProgName:		.db $12,$08,"repeatme"	;this is for the saving routine from tetris
										;this way it can find the program in the memory

StackPointer:		;used to save and retrieve the stack pointer
	.db 0,0
Level:				;duh, the level number (also the number of #'s)
	.db 0
Position:			;where the user is in the code
	.db 0
Settings:
	.db %00000001	;bit 0=0 when user can enter the code, 1 when they can't
					;bit 1=1 if the previous interrupt program needs to be restored
					;bit 2=1 while timing responses from the player
Timer:			;used for delays when the calc is displaying the code
 	.db 110		;decreases to speed up the length of the delays
Timer2:
	.db 0		;used to time the responses from the player
Timer2max:		;if the response time goes over the max, the player loses
	.db $80
onoff:			;tells which button is pressed on the screen
	.db 0,0,0,0,0,0,0,0,0
circoords:		;gives the coordinates of where each circle is
	.db $02,$2E, $14,$2E, $26,$2E, $02,$1E, $14,$1E, $26,$1E, $02,$0E, $14,$0E, $26,$0E
Random_num:		;is constantly incrimented each time the interrupt occurs
	.db 0		;(when it gets to 10 it is reset to 1)
	.db 0		;a place for a second rand # for the intro
circle:		;the sprite used to invert the inside of the circles
;top left
	.db %00000000
	.db %00000000
	.db %00000011
	.db %00001111
	.db %00111111
	.db %00111111
	.db %01111111
	.db %01111111
;top right
	.db %00000000
	.db %00000000
	.db %11100000
	.db %11111000
	.db %11111110
	.db %11111110
	.db %11111111
	.db %11111111
;bottom left
	.db %01111111
	.db %01111111
	.db %01111111
	.db %00111111
	.db %00111111
	.db %00001111
	.db %00000011
	.db %00000000
;bottom right
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111110
	.db %11111110
	.db %11111000
	.db %11100000
	.db %00000000

N1:
	.db %00011000
	.db %00111000
	.db %01111000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %11111111
	.db %11111111

N2:
	.db %01111100
	.db %11111111
	.db %11000011
	.db %00000111
	.db %00011110
	.db %01111000
	.db %11111111
	.db %11111111

N3:
	.db %01111110
	.db %11111111
	.db %11000011
	.db %00001110
	.db %00001110
	.db %11000111
	.db %11111111
	.db %01111110

N4:
	.db %00000110
	.db %00001110
	.db %00011110
	.db %00110110
	.db %01100111
	.db %11111111
	.db %00000110
	.db %00000110

N5:
	.db %11111111
	.db %11111111
	.db %11000000
	.db %11111110
	.db %11111111
	.db %00000011
	.db %11111111
	.db %01111110

N6:
	.db %01111110
	.db %11111111
	.db %11000000
	.db %11111110
	.db %11111111
	.db %11000011
	.db %11111111
	.db %01111110

N7:
	.db %11111111
	.db %11111111
	.db %11000011
	.db %00000111
	.db %00001110
	.db %00011100
	.db %00011100
	.db %00011100

N8:
	.db %01111110
	.db %11111111
	.db %11100111
	.db %01111110
	.db %11100110
	.db %11000011
	.db %11111111
	.db %01111110

N9:
	.db %01111110
	.db %11111111
	.db %11000011
	.db %01111111
	.db %01111111
	.db %00000111
	.db %00011110
	.db %01111000

bground:
;Compressed picture made with BMP2ASM by Levi Lansing (puzzlesome@hotmail.com)
;Compressed from 1024 bytes to 552 bytes - 46% compressed!
  .db $FF, $F0, $F3, $F3, $F3, $F0, $F0, $B7, $F1, $04, $FF, $FF, $00, $00, $00, $03
  .db $0C, $11, $11, $21, $21, $20, $20, $20, $10, $10, $0C, $03, $00, $00, $00, $03
  .db $0C, $10, $10, $B7, $20, $05, $10, $10, $0C, $03, $00, $00, $00, $03, $0C, $10
  .db $10, $21, $B7, $20, $04, $10, $11, $0C, $03, $00, $00, $00, $FF, $0F, $EF, $EF
  .db $E8, $08, $19, $B7, $E8, $04, $FF, $FF, $00, $00, $F8, $06, $01, $FC, $C4, $0C
  .db $08, $18, $10, $30, $20, $20, $01, $06, $F8, $00, $F8, $06, $01, $18, $18, $38
  .db $68, $FC, $B7, $08, $04, $01, $06, $F8, $00, $F8, $06, $01, $60, $E0, $A0, $B7
  .db $20, $04, $70, $FC, $01, $06, $F8, $00, $00, $B7, $FF, $04, $04, $04, $F4, $04
  .db $FC, $FC, $04, $FC, $FF, $B7, $00, $04, $83, $44, $44, $B7, $28, $05, $44, $44
  .db $83, $B7, $00, $05, $83, $44, $44, $B7, $28, $05, $44, $44, $83, $B7, $00, $05
  .db $83, $44, $44, $B7, $28, $05, $44, $44, $83, $B7, $00, $04, $B7, $FF, $04, $02
  .db $02, $FA, $7A, $7A, $7A, $02, $7F, $FF, $00, $00, $3E, $C1, $00, $3F, $21, $33
  .db $1E, $1F, $31, $21, $33, $1E, $00, $C1, $3E, $00, $3E, $C1, $00, $3F, $20, $3E
  .db $23, $01, $01, $23, $1E, $00, $00, $C1, $3E, $00, $3E, $C1, $00, $3E, $23, $01
  .db $03, $0E, $38, $20, $30, $1F, $00, $C1, $3E, $00, $00, $B7, $FF, $04, $01, $01
  .db $7D, $01, $3F, $3F, $01, $FF, $FF, $00, $00, $00, $80, $60, $11, $11, $B7, $0A
  .db $05, $11, $11, $60, $80, $00, $00, $00, $80, $60, $11, $11, $B7, $0A, $05, $11
  .db $11, $60, $80, $00, $00, $00, $80, $60, $11, $11, $B7, $0A, $05, $11, $11, $60
  .db $80, $00, $00, $00, $B7, $FF, $04, $00, $FE, $FE, $00, $38, $38, $00, $FF, $FF
  .db $00, $00, $0F, $30, $C0, $0F, $08, $0C, $07, $00, $00, $08, $0F, $00, $C0, $30
  .db $0F, $00, $0F, $30, $C0, $0F, $18, $10, $10, $1F, $10, $18, $0D, $07, $C0, $30
  .db $0F, $00, $0F, $30, $C0, $0F, $18, $10, $00, $07, $10, $18, $0F, $07, $C0, $30
  .db $0F, $00, $00, $FF, $EF, $EF, $83, $EF, $EF, $EF, $E7, $E7, $E7, $E3, $FF, $FF
  .db $00, $00, $80, $60, $18, $84, $C4, $C2, $C2, $42, $42, $C2, $84, $04, $18, $60
  .db $80, $00, $80, $60, $18, $84, $04, $02, $02, $82, $C2, $42, $84, $04, $18, $60
  .db $80, $00, $80, $60, $18, $84, $44, $42, $C2, $82, $C2, $C2, $C4, $04, $18, $60
  .db $80, $00, $00, $FF, $E0, $E7, $E7, $E0, $EF, $EF, $B7, $E3, $04, $FF, $FF, $B7
  .db $00, $33, $FF, $3E, $3E, $3E, $10, $B7, $DE, $06, $FF, $FF, $B7, $00, $33, $FF
  .db $0E, $FE, $F8, $1E, $FE, $FE, $B7, $7E, $04, $FF, $FF, $B7, $00, $33, $FF, $FF
  .db $FF, $3F, $E0, $E0, $E7, $60, $63, $63, $20, $FF, $FF, $B7, $00, $33, $B7, $FF
  .db $04, $10, $17, $D7, $11, $F1, $F1, $11, $FF, $FF, $B7, $00, $33, $FF, $FE, $FE
  .db $FE, $1E, $DE, $DE, $B7, $FE, $04, $FF, $FF, $B7, $00, $33, $FF, $00, $B7, $FB
  .db $05, $B7, $3B, $04, $FF, $FF, $B7, $00, $33, $FF, $3F, $BF, $BF, $A0, $A0, $A7
  .db $A0, $A3, $A3, $A0, $FF, $FF, $B7, $00, $33, $B7, $FE, $04, $1E, $1E, $DE, $1E
  .db $FE, $FE, $1E, $FE, $FE, $B7, $00, $34

TitlePic:
;Compressed picture made with BMP2ASM by Levi Lansing (puzzlesome@hotmail.com)
;Compressed from 1024 bytes to 373 bytes - 64% compressed!
  .db $B7, $FF, $FF, $B7, $FF, $05, $00, $7F, $7F, $40, $5F, $5F, $40, $7F, $7F, $71
  .db $74, $76, $B7, $77, $04, $07, $B7, $FF, $05, $E0, $EF, $EF, $E8, $EB, $E8, $EF
  .db $B7, $EE, $09, $E0, $B7, $FF, $15, $FD, $FD, $FD, $FC, $1F, $DF, $DF, $50, $5F
  .db $50, $57, $D7, $94, $97, $D7, $B7, $57, $05, $10, $B7, $FF, $05, $07, $F7, $F7
  .db $34, $B7, $B7, $01, $34, $F5, $14, $B7, $D7, $08, $C7, $B7, $FF, $16, $95, $B5
  .db $DB, $FF, $FF, $FF, $00, $FF, $01, $FD, $FD, $05, $FD, $FD, $01, $7F, $7F, $01
  .db $FD, $01, $B7, $FF, $05, $80, $BF, $A0, $AF, $AF, $20, $FE, $20, $AF, $AF, $A3
  .db $B7, $BB, $05, $83, $FF, $FF, $00, $7F, $41, $B7, $5D, $05, $45, $B7, $75, $07
  .db $04, $FF, $FF, $F7, $77, $76, $73, $FF, $FF, $FF, $00, $FF, $00, $7F, $7F, $40
  .db $5F, $47, $77, $77, $70, $7F, $7F, $70, $77, $77, $07, $FF, $FF, $43, $5B, $5B
  .db $DA, $DB, $98, $BF, $98, $DB, $DB, $D9, $DD, $DD, $DD, $DC, $DF, $C0, $FF, $FF
  .db $01, $FD, $85, $B7, $B5, $0D, $31, $FF, $FF, $FF, $31, $B6, $16, $FF, $FF, $FF
  .db $00, $FF, $10, $D7, $D7, $54, $B7, $57, $05, $D7, $D7, $10, $B7, $FF, $08, $00
  .db $FF, $40, $5F, $5F, $D0, $DF, $DF, $DC, $DD, $DD, $5C, $5F, $40, $B7, $FF, $05
  .db $00, $FF, $00, $7F, $7F, $40, $7F, $7F, $70, $77, $77, $70, $7F, $00, $FF, $FF
  .db $FF, $CA, $DA, $9A, $FF, $FF, $FF, $00, $FF, $01, $FD, $FD, $05, $FD, $FD, $01
  .db $7D, $7D, $01, $FD, $01, $B7, $FF, $08, $00, $FF, $04, $F5, $F5, $15, $F5, $F5
  .db $05, $F5, $F5, $05, $F5, $04, $B7, $FF, $05, $1F, $FF, $1F, $DF, $DF, $5F, $DF
  .db $DF, $1F, $FF, $FF, $1F, $DF, $1F, $FF, $FF, $FF, $39, $D5, $D9, $FD, $F3, $FF
  .db $00, $FF, $00, $7F, $00, $FF, $00, $7F, $41, $5D, $41, $7F, $7F, $00, $B7, $FF
  .db $08, $00, $FF, $00, $FE, $06, $76, $70, $1F, $B7, $DF, $05, $1F, $B7, $FF, $19
  .db $F0, $C6, $DF, $46, $F6, $16, $D6, $56, $56, $56, $D6, $B7, $D7, $05, $10, $B7
  .db $FF, $30, $0F, $EF, $0F, $B7, $FF, $06, $B7, $7F, $04, $1F, $DF, $1F, $B7, $FF
  .db $E7, $DD, $DD, $D5, $FF


Numbers:	;the code's stored here (the end of the program) to however long it is
.end
