;programmed by Patrick McLaughlin
#include "usgard.h"
.org 0
.db "by Patrick McLaughlin",0
storecarsprite = TEXT_MEM
storedelay = TEXT_MEM+2
storecounter = TEXT_MEM+4
storea = TEXT_MEM+6
bkgrdscreen = TEXT_MEM+8
bkgrdmempos = TEXT_MEM+10
storecarmove = TEXT_MEM+12
directmove = TEXT_MEM+14
stopmessage = TEXT_MEM+16
countletters = TEXT_MEM+18
arecord = TEXT_MEM+20
derecord = TEXT_MEM+22
jiffies = TEXT_MEM+24
seconds = TEXT_MEM+26
minutes = TEXT_MEM+28
jiffyadd = TEXT_MEM+30
maxspeed = TEXT_MEM+32
maxspeedcounter = TEXT_MEM+34
maxwideturn = TEXT_MEM+36
turnmode = TEXT_MEM+38

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;set the beginning of the program
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	ld a,0
	ld (stopmessage),a
	ld a,21
	ld (countletters),a
	ld hl,140
	ld (directmove),hl
	call &introscreen
playagain2:
	ld hl,16
	call &putbkgrdscreen
	ld a,12
	ld (maxspeed),a
	ld a,58
	ld (storedelay),a
	ld a,6
	ld (storecarsprite),a
	ld a,0
	ld (storecarmove),a
	ld (jiffies),a
	ld (seconds),a
	ld (minutes),a
	ld (maxspeedcounter),a
	ld (storecounter),a
	ld (maxwideturn),a
	ld (turnmode),a
	ld a,2
	ld (jiffyadd),a
	ld hl,&addjiffy
	call INT_INSTALL
	ld b,105
	ld c,50

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;mainloop of the game
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

mainloop:
	ld a,$BF
	out (1),a
	in a,(1)
	bit 7,a
	jp z,&playagain
	bit 6,a
	jp z,&prethankstext
	bit 5,a
	call z,&secondkey
mainloopkeys:
	ld a,(storedelay)
	cp 58
	jr z,mainloopbcandhl
	push bc
	ld hl,(storecarmove)
	ld de,cardirections
	add hl,de
	ld de,(PROGRAM_ADDR)
	add hl,de
	jp (hl)
cardirections:
	jp &car1
	jp &car2
	jp &car3
	jp &car4
	jp &car5
	jp &car6
	jp &car7
	jp &car8
	jp &car9
	jp &car10
	jp &car11
	jp &car12
	jp &car13
	jp &car14
	jp &car15
	jp &car16
mainloopbcandhl:
	call &restorebkgrd
	ld hl,(storecarsprite)
	call &ldsprite
	ld a,(maxwideturn)
	ld d,a
	ld a,(storecounter)
	cp d
	jr nc,lddwitha
	inc a
	ld (storecounter),a
	jr mainloopturnkey
mainloopcounter:
 	ld a,$FE
 	out (1),a
 	in a,(1)
	push af
 	bit 1,a
 	call z,&leftkey
	pop af
 	bit 2,a
 	call z,&rightkey
mainloopturnkey:
	ld a,(maxspeedcounter)
	or a
	jr z,incdelay
	dec a
	ld (maxspeedcounter),a
	jr dodelay
incdelay:
	ld a,(storedelay)
	cp 58
	jr z,dodelay
	inc a
	ld (storedelay),a
dodelay:
	ld d,0
	ld a,(storedelay)
findmaxwideturn:
	cp 48
	jr nc,endfindmaxwideturn
	add a,19
	inc d
	jr findmaxwideturn
endfindmaxwideturn:
	ld a,d
	ld (maxwideturn),a
	ld a,(storedelay)
	call &delay
	ld a,(turnmode)
	inc a
	cp 2
	jr nz,ais1
	ld a,0
ais1:
	ld (turnmode),a
	ld hl,(bkgrdscreen)
	ld de,288
	call CP_HL_DE
	jp z,&raceisover
	jp &mainloop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;equalize storecounter and maxwideturn
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

lddwitha:
	ld a,d
	ld (storecounter),a
	jr mainloopcounter

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;stops your car because you hit a wall
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

loaddelaywith58:
	pop bc
	ld a,58
	ld (storedelay),a
	ld a,0
	ld (maxspeedcounter),a
	jp &mainloopbcandhl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;set part of the instructions for the directions into a
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

leftkey:
	ld a,0
	ld (storecounter),a
	ld a,27
	call &delay
	ld a,(storecarsprite)
	cp 6
	jr z,ais6to96
	sub 6
	ld (storecarsprite),a
leftmove:
	ld a,(storecarmove)
	or a
	jr z,ais0to45
	sub 3
	ld (storecarmove),a
	ret
ais0to45:
	ld a,45
	ld (storecarmove),a
	ret
ais6to96:
	ld a,96
	ld (storecarsprite),a
	jr leftmove

rightkey:
	ld a,0
	ld (storecounter),a
	ld a,27
	call &delay
	ld a,(storecarsprite)
	cp 96
	jr z,ais96to6
	add a,6
	ld (storecarsprite),a
rightmove:
	ld a,(storecarmove)
	cp 45
	jr z,ais45to0
	add a,3
	ld (storecarmove),a
	ret
ais45to0:
	ld a,0
	ld (storecarmove),a
	ret
ais96to6:
	ld a,6
	ld (storecarsprite),a
	jr rightmove

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;increase in speed
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

secondkey:
	ld a,(maxspeed)
	ld d,a
	ld a,(storedelay)
	cp d
	ret c
	dec a
	dec a
	ld (storedelay),a
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;execute what happens in whatever direction your car's facing
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

car1:
	dec c
	call &calcpos
	jr c,nopixeltest1_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest1_1:
	pop bc
	push bc
	dec c
	inc b
	inc b
	inc b
	inc b
	inc b
	call &calcpos
	jr c,nopixeltest1_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest1_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option1_2
	dec c
	jr endoption1
option1_2:
	dec c
endoption1:
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl

car2:
	inc b
	inc b
	dec c
	call &calcpos
	jr c,nopixeltest2_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest2_1:
	pop bc
	push bc
	inc c
	inc c
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest2_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest2_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option2_2
	dec c
	jr endoption2
option2_2:
	dec c
	inc b
endoption2:
	ld a,b
	cp 117
	call z,&rightbkgrd
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl

car3:
	inc b
	inc b
	dec c
	call &calcpos
	jr c,nopixeltest3_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest3_1:
	pop bc
	push bc
	inc c
	inc c
	inc c
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest3_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest3_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option3_2
	inc b
	dec c
	jr endoption3
option3_2:
	inc b
	dec c
endoption3:
	ld a,b
	cp 117
	call z,&rightbkgrd
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl

car4:
	inc b
	inc b
	inc b
	dec c
	call &calcpos
	jr c,nopixeltest4_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest4_1:
	pop bc
	push bc
	inc c
	inc c
	inc c
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest4_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest4_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option4_2
	inc b
	jr endoption4
option4_2:
	dec c
	inc b
endoption4:
	ld a,b
	cp 117
	call z,&rightbkgrd
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl


car5:
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest5_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest5_1:
	pop bc
	push bc
	ld a,b
	add a,6
	ld b,a
	inc c
	inc c
	inc c
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest5_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest5_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option5_2
	inc b
	jr endoption5
option5_2:
	inc b
endoption5:
	ld a,b
	cp 117
	call z,&rightbkgrd
	jp &mainloopbcandhl

car6:
	inc c
	inc c
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest6_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest6_1:
	pop bc
	push bc
	inc b
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest6_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest6_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option6_2
	inc b
	jr endoption6
option6_2:
	inc b
	inc c
endoption6:
	ld a,b
	cp 117
	call z,&rightbkgrd
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car7:
	inc c
	inc c
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest7_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest7_1:
	pop bc
	push bc
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest7_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest7_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option7_2
	inc b
	inc c
	jr endoption7
option7_2:
	inc b
	inc c
endoption7:
	ld a,b
	cp 117
	call z,&rightbkgrd
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car8:
	inc c
	inc c
	inc c
	ld a,b
	add a,6
	ld b,a
	call &calcpos
	jr c,nopixeltest8_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest8_1:
	pop bc
	push bc
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest8_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest8_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option8_2
	inc c
	jr endoption8
option8_2:
	inc b
	inc c
endoption8:
	ld a,b
	cp 117
	call z,&rightbkgrd
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car9:
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest9_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest9_1:
	pop bc
	push bc
	inc b
	inc b
	inc b
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest9_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest9_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option9_2
	inc c
	jr endoption9
option9_2:
	inc c
endoption9:
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car10:
	dec b
	inc c
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest10_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest10_1:
	pop bc
	push bc
	inc b
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest10_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest10_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option10_2
	inc c
	jr endoption10
option10_2:
	inc c
	dec b
endoption10:
	ld a,b
	cp 7
	call z,&leftbkgrd
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car11:
	dec b
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest11_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest11_1:
	pop bc
	push bc
	inc b
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest11_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest11_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option11_2
	dec b
	inc c
	jr endoption11
option11_2:
	dec b
	inc c
endoption11:
	ld a,b
	cp 7
	call z,&leftbkgrd
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car12:
	dec b
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest12_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest12_1:
	pop bc
	push bc
	inc b
	inc b
	ld a,c
	add a,6
	ld c,a
	call &calcpos
	jr c,nopixeltest12_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest12_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option12_2
	dec b
	jr endoption12
option12_2:
	dec b
	inc c
endoption12:
	ld a,b
	cp 7
	call z,&leftbkgrd
	ld a,c
	cp 56
	call z,&downbkgrd
	jp &mainloopbcandhl

car13:
	dec b
	call &calcpos
	jr c,nopixeltest13_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest13_1:
	pop bc
	push bc
	dec b
	inc c
	inc c
	inc c
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest13_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest13_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option13_2
	dec b
	jr endoption13
option13_2:
	dec b
endoption13:
	ld a,b
	cp 7
	call z,&leftbkgrd
	jp &mainloopbcandhl

car14:
	dec b
	inc c
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest14_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest14_1:
	pop bc
	push bc
	inc b
	inc b
	dec c
	call &calcpos
	jr c,nopixeltest14_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest14_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option14_2
	dec b
	jr endoption14
option14_2:
	dec b
	dec c
endoption14:
	ld a,b
	cp 7
	call z,&leftbkgrd
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl

car15:
	dec b
	inc c
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest15_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest15_1:
	pop bc
	push bc
	inc b
	inc b
	inc b
	dec c
	call &calcpos
	jr c,nopixeltest15_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest15_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option15_2
	dec b
	dec c
	jr endoption15
option15_2:
	dec b
	dec c
endoption15:
	ld a,b
	cp 7
	call z,&leftbkgrd
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl

car16:
	dec b
	inc c
	inc c
	call &calcpos
	jr c,nopixeltest16_1
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest16_1:
	pop bc
	push bc
	inc b
	inc b
	inc b
	dec c
	call &calcpos
	jr c,nopixeltest16_2
	call &testpixel
	jp nz,&loaddelaywith58
nopixeltest16_2:
	pop bc
	ld a,(turnmode)
	or a
	jr nz,option16_2
	dec c
	jr endoption16
option16_2:
	dec b
	dec c
endoption16:
	ld a,b
	cp 7
	call z,&leftbkgrd
	ld a,c
	cp 7
	call z,&upbkgrd
	jp &mainloopbcandhl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;calculates the postion of car's bkgrdsprite
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

calcpos:
	push bc
	ld a,63
	sub c
	ld c,a
	call FIND_PIXEL
	ld a,l
	and $0F
	ld (storea),a
	ld bc,(storea)
	ld a,0
	ld de,128
divideby128:
	inc a
	sbc hl,de
	jr nc,divideby128
	ld h,16
	ld l,a
	dec l
	call MUL_HL
	add hl,bc
	ld de,TEXT_MEM2
	add hl,de
	ld a,(hl)
	cp 111
	jr c,aftermaxspeed
	cp 137
	jr c,initmaxspeed
aftermaxspeed:
	cp 39
	jr c,dontinitslowspeed
	cp 73
	jr c,initslowspeed
dontinitslowspeed:
	ld de,12
	ld (maxspeed),de
afterinitslowspeed:
	cp 144
	pop bc
	ret

initmaxspeed:
	ld de,1
	ld (storedelay),de
	ld de,100
	ld (maxspeedcounter),de
	jr aftermaxspeed

initslowspeed:
	ld de,30
	ld (maxspeed),de
	jr afterinitslowspeed

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;puts the bkgrd car is destroying
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

restorebkgrd:
	push bc
	ld a,63
	sub c
	ld c,a
	call FIND_PIXEL
	ld a,l
	and $0F
	ld (storea),a
	ld bc,(storea)
	ld a,0
	ld de,128
divideby128_2:
	inc a
	sbc hl,de
	jr nc,divideby128_2
	ld h,16
	ld l,a
	dec l
	call MUL_HL
	add hl,bc
	ld de,17
	sbc hl,de
	push hl
	ld c,0
	ld de,16
divideby16:
	inc c
	sbc hl,de
	jr nc,divideby16
	ld b,3
	ld a,c
	dec a
multiplyby8:
	add a,a
	djnz multiplyby8
	ld c,a
	add hl,de
	ld b,3
multiplyby8_2:
	add hl,hl
	djnz multiplyby8_2
	ld (storea),hl
	ld a,(storea)
	ld b,a
	pop de
	ld hl,TEXT_MEM2
	add hl,de
	ld a,3
	ld (arecord),a
restoresprites:
	ld a,3
	ld (derecord),a
restoresprites2:
	push hl
	call &ldhlwitha
	ex de,hl
	ld hl,&backgrounds
	add hl,de
	call &restorebkgrdsprite
	pop hl
dontputbkgrd:
	inc hl
	ld a,b
	add a,8
	ld b,a
	ld a,(derecord)
	dec a
	ld (derecord),a
	jr nz,restoresprites2
	ld de,13
	add hl,de
	ld a,b
	sub 24
	ld b,a
	ld a,c
	add a,8
	ld c,a
	ld a,(arecord)
	dec a
	ld (arecord),a
	jp nz,&restoresprites
	pop bc
	ret

restorebkgrdsprite:
	push bc
	ld a,63
	sub c
	ld c,a
	push hl
	call FIND_PIXEL
	ld de,$FC00
	add hl,de
	ex de,hl
	pop hl
	ld b,8
restoresprite:
	ld a,(hl)
	ld (de),a
	inc hl
	push hl
	ex de,hl
	ld de,$10
	add hl,de
	ex de,hl
	pop hl
	djnz restoresprite
	pop bc
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Tests the pixel at B,C. If the Z flag is set, no pixel, else pixel is lit
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

testpixel:
	ld a,63
	sub c
	ld c,a
	call FIND_PIXEL
	ld de,$FC00
	add hl,de
	and (hl)
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;delays game
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

delay:
	ld d,255
delay1:
	dec d
	jr nz,delay1
	dec a
	jr nz,delay
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Puts text on the screen
;Got the idea for this from some of Patrick Davidson's source,
;   so give him credit
;hl points to address
;b is the # of zero-terminated strings to to put
;check out the text file to find out how this works and
;  how to work it in usgard so you can save lots of bytes!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

puttext:
	ld a,(hl)
	ld (CURSOR_X),a
	inc hl
	ld a,(hl)
	ld (CURSOR_Y),a
	inc hl
	call D_ZM_STR
	djnz puttext
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;erases sprite
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ldsprite:
	push bc
	ld de,sprites
	add hl,de
	ld de,(PROGRAM_ADDR)
	add hl,de

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;PutSprite by Jimmy Mardell
;draws the sprite that's stored in hl at coordinates (b,c)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PutSprite:
        ld a,63
        sub c
        ld c,a
        push hl
        call FIND_PIXEL
        ld de,$FC00
        add hl,de
        ex de,hl
        pop hl
	ld b,6
        ld c,6
        push hl
        pop ix
        ex de,hl
PS_NewRow:
        push bc
        ld d,(ix)
        inc ix
        push af
        push hl
PS_NewCol:
        rl d
        ld e,a
        jr nc,PS_NoPixel
        or (hl)
        ld (hl),a
        jr PS_NextPixel
PS_NoPixel:
        cpl
        and (hl)
        ld (hl),a
PS_NextPixel:
        ld a,e
        rrca
        jr nc,PS_SameByte
        inc hl
PS_SameByte:
        djnz PS_NewCol
        pop hl
        pop af
        ld de,16
        add hl,de
        pop bc
        dec c
        jr nz,PS_NewRow
        pop bc
        ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;graphics for items
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sprites:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

	.db %01111000
	.db %11001100
	.db %01001000
	.db %01111000
	.db %11001100
	.db %01111000

	.db %00111000
	.db %01000100
	.db %01000100
	.db %11111000
	.db %10001000
	.db %01110000

	.db %00111000
	.db %00100100
	.db %11100100
	.db %10111100
	.db %11010000
	.db %01110000

	.db %00011000
	.db %01100100
	.db %10100100
	.db %10100100
	.db %10111000
	.db %01100000

	.db %01001000
	.db %11111100
	.db %10100100
	.db %10100100
	.db %11111100
	.db %01001000

	.db %01100000
	.db %10111000
	.db %10100100
	.db %10100100
	.db %01100100
	.db %00011000

	.db %01110000
	.db %11010000
	.db %10111100
	.db %11100100
	.db %00100100
	.db %00111000

	.db %01110000
	.db %10001000
	.db %11111000
	.db %01000100
	.db %01000100
	.db %00111000

	.db %01111000
	.db %11001100
	.db %01111000
	.db %01001000
	.db %11001100
	.db %01111000

	.db %00111000
	.db %01000100
	.db %01111100
	.db %10001000
	.db %10001000
	.db %01110000

	.db %00111000
	.db %00101100
	.db %11110100
	.db %10011100
	.db %10010000
	.db %01110000

	.db %00011000
	.db %01110100
	.db %10010100
	.db %10010100
	.db %10011000
	.db %01100000

	.db %01001000
	.db %11111100
	.db %10010100
	.db %10010100
	.db %11111100
	.db %01001000

	.db %01100000
	.db %10011000
	.db %10010100
	.db %10010100
	.db %01110100
	.db %00011000

	.db %01110000
	.db %10010000
	.db %10011100
	.db %11110100
	.db %00101100
	.db %00111000

	.db %01110000
	.db %10001000
	.db %10001000
	.db %01111100
	.db %01000100
	.db %00111000

backgrounds:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

	.db %00000000
	.db %00000000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00000000

	.db %00000000
	.db %00000000
	.db %00000000
	.db %00111100
	.db %00111100
	.db %00000000
	.db %00000000
	.db %00000000

	.db %00000000
	.db %00000000
	.db %00000000
	.db %01100000
	.db %01110000
	.db %00111000
	.db %00011000
	.db %00000000

	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00011000
	.db %00000000

	.db %10010001
	.db %11000100
	.db %10000000
	.db %10010001
	.db %10000000
	.db %10001010
	.db %10000000
	.db %10010010

	.db %00010001
	.db %01000101
	.db %00000001
	.db %00010001
	.db %00000001
	.db %10001011
	.db %00000001
	.db %00010011

	.db %11111111
	.db %01000100
	.db %00000000
	.db %00010001
	.db %00000000
	.db %10001010
	.db %00000000
	.db %00010010

	.db %00010001
	.db %01000100
	.db %00000000
	.db %00010001
	.db %00000000
	.db %10001010
	.db %00000000
	.db %11111111

	.db %00010001
	.db %01000100
	.db %00000000
	.db %00010001
	.db %00000000
	.db %10001010
	.db %00000000
	.db %00010010

	.db %10000000
	.db %01000000
	.db %00100000
	.db %10010000
	.db %00001000
	.db %00100100
	.db %10000010
	.db %00101001

	.db %01001001
	.db %00000010
	.db %10100100
	.db %00001000
	.db %10010000
	.db %00100000
	.db %01000000
	.db %10000000

	.db %10010010
	.db %01000000
	.db %00100101
	.db %00010000
	.db %00001001
	.db %00000100
	.db %00000010
	.db %00000001

	.db %00000001
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010010
	.db %00101000
	.db %01000001
	.db %10001000

	.db %00000011
	.db %00001111
	.db %00111111
	.db %11111100
	.db %11111100
	.db %00111111
	.db %00001111
	.db %00000011

	.db %00011000
	.db %00011000
	.db %00111100
	.db %00111100
	.db %01111110
	.db %01111110
	.db %11100111
	.db %11100111

	.db %11000000
	.db %11110000
	.db %11111100
	.db %00111111
	.db %00111111
	.db %11111100
	.db %11110000
	.db %11000000

	.db %11100111
	.db %11100111
	.db %01111110
	.db %01111110
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000

	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

	.db %00011100
	.db %01111110
	.db %01101110
	.db %11001111
	.db %11111111
	.db %11111111
	.db %11111110
	.db %01111100

	.db %00111100
	.db %01101110
	.db %11001111
	.db %11111111
	.db %01111110
	.db %00011000
	.db %00011000
	.db %00111100

	.db %11111111
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %11111111

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;prepares background of each screen depending on what side you entered the screen
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

upbkgrd:
	ld c,55
	ld de,256
	ld hl,(bkgrdscreen)
	sbc hl,de
	call &putbkgrdscreen
	ret

rightbkgrd:
	ld b,8
	ld de,16
	ld hl,(bkgrdscreen)
	add hl,de
	call &putbkgrdscreen
	ret

downbkgrd:
	ld c,8
	ld de,256
	ld hl,(bkgrdscreen)
	add hl,de
	call &putbkgrdscreen
	ret

leftbkgrd:
	ld b,116
	ld de,16
	ld hl,(bkgrdscreen)
	sbc hl,de
	call &putbkgrdscreen
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;intro screen of game
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

introscreen:
	call CLEARLCD
	ld de,$FCB4
	ld hl,&titlepic
	ld b,19
puttitle1:
	ld c,5
puttitle2:
	ld a,(hl)
	ld (de),a
	inc hl
	inc de
	dec c
	jr nz,puttitle2
	push hl
	ex de,hl
	ld de,$0B
	add hl,de
	ex de,hl
	pop hl
	djnz puttitle1

	ld b,3
	ld hl,&intro
	call &puttext
	ld b,29
	ld c,8
startcarloop:
	ld d,19
wait:
	ld hl,54
	call &carintro
	ret nz
	inc c
	dec d
	jr nz,wait

	ld d,4
wait1:
	ld hl,42
	call &carintro
	ret nz
	inc b
	inc c
	dec d
	jr nz,wait1

	ld d,51
wait2:
	ld hl,30
	call &carintro
	ret nz
	inc b
	dec d
	jr nz,wait2

	ld d,4
wait3:
	ld hl,18
	call &carintro
	ret nz
	inc b
	dec c
	dec d
	jr nz,wait3

	ld d,19
wait4:
	ld hl,6
	call &carintro
	ret nz
	dec c
	dec d
	jr nz,wait4

	ld d,4
wait5:
	ld hl,90
	call &carintro
	ret nz
	dec b
	dec c
	dec d
	jr nz,wait5

	ld d,51
wait6:
	ld hl,78
	call &carintro
	ret nz
	dec b
	dec d
	jr nz,wait6

	ld d,4
wait7:
	ld hl,66
	call &carintro
	ret nz
	dec b
	inc c
	dec d
	jr nz,wait7
	jp &startcarloop

carintro:
	push de
	call &ldsprite
	ld a,(stopmessage)
	or a
	jr z,already0
	dec a
	ld (stopmessage),a
	ld a,25
	jr afterchangede
already0:
	ld a,(countletters)
	dec a
	ld (countletters),a
	jr nz,moveletters
stopletters:
	ld a,20
	ld (countletters),a
	ld a,50
	ld (stopmessage),a
moveletters:
	push bc
	ld b,79
	ld hl,$FFB0
eraseloop:
	ld (hl),0
	inc hl
	djnz eraseloop
	pop bc
	ld a,0
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ld hl,&directions
	ld de,(directmove)
	add hl,de
	call D_ZM_STR
	push hl
	ld hl,(directmove)
	ld de,0
	call CP_HL_DE
	jr nz,afterdeis0
	ld de,140
	ld (directmove),de
afterdeis0:
	pop hl
	ld de,(directmove)
	dec de
	ld (directmove),de
	ld a,18
afterchangede:
	call &delay
	ld hl,0
	call &ldsprite
	call GET_KEY
	or a
	pop de
	ret

intro:
	.db 51,24,"...the game",0
	.db 25,40,"by Patrick McLaughlin",0
	.db 36,46,"version 0.7 beta",0

directions:
 	.db "pcmprog@hotmail.com",0
	.db "E-mail me at:      ",0
	.db "Exit=exits game    ",0
	.db "More=restarts race ",0
	.db "Left & Right=turn  ",0
	.db "2nd=accelerates    ",0
	.db "ANY KEY STARTS RACE",0

titlepic:
	.db %00000000,%00000000,%00000011,%00000000,%00000001
	.db %00000000,%00000000,%00000000,%00000100,%00000001
	.db %00000000,%00000000,%00000001,%10000111,%11100010
	.db %00000000,%00000000,%00000001,%11000110,%00110000
	.db %00000000,%00000000,%01100000,%11100110,%00110000
	.db %00000000,%00000000,%11000000,%01100110,%00110000
	.db %00000000,%00000001,%10000110,%00000000,%00000000
	.db %00000000,%00000000,%11001100,%00000000,%00000000
	.db %00000000,%00000000,%01111000,%00000000,%00000000
	.db %00000000,%00011111,%00000000,%00000000,%00000000
	.db %00000000,%00110001,%10000000,%00000000,%00000000
	.db %00000000,%00110001,%10000000,%00000000,%00000000
	.db %00000000,%01111111,%10000000,%00000000,%00000000
	.db %00000000,%00000000,%00000000,%00000000,%00000000
	.db %00000111,%11000011,%10000000,%00000000,%00000000
	.db %00001100,%01101110,%00000000,%00000000,%00000000
	.db %00001100,%01111000,%00000000,%00000000,%00000000
	.db %00001100,%01100000,%00000000,%00000000,%00000000
	.db %00000111,%11111111,%10000000,%00000000,%00000000

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;puts background of each screen
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putbkgrdscreen:
	push bc
	ld de,TEXT_MEM2
	ld (derecord),de
	ld (bkgrdscreen),hl
	ld de,&level1
	add hl,de
	ld b,0
	ld c,0
	ld a,128
putbkgrdscreen1:
	push af
	ld a,(hl)
	ld (storea),a
	ld de,(storea)
	push hl
	push bc
	ld hl,&backgrounds
	add hl,de
	ld de,(derecord)
	ld (de),a
	inc de
	ld (derecord),de
	ld a,63
	sub c
	ld c,a
	push hl
	call FIND_PIXEL
	ld de,$FC00
	add hl,de
	ex de,hl
	pop hl
	ex de,hl
	ld b,8
putbkgrdscreen2:
	push bc
	ld a,(de)
	inc de
	ld (hl),a
	ld bc,16
	add hl,bc
	pop bc
	djnz putbkgrdscreen2
	pop bc
	pop hl
	ld a,b
	add a,8
	ld b,a
	cp 128
	jr nz,putbkgrdscreen3
	ld a,c
	add a,8
	ld c,a
	ld b,0
	ld de,16
	add hl,de
putbkgrdscreen3:
	inc hl
	pop af
	dec a
	jp nz,&putbkgrdscreen1
	pop bc
	ret

level1:
	.db $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90\.db $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90
	.db $90,$48,$48,$48,$58,$00,$00,$00,$60,$48,$48,$48,$48,$48,$48,$48\.db $48,$58,$00,$00,$00,$00,$00,$00,$00,$00,$60,$48,$48,$48,$48,$90
	.db $90,$48,$48,$58,$00,$20,$00,$18,$00,$60,$48,$48,$48,$48,$48,$48\.db $58,$00,$00,$98,$00,$10,$00,$10,$00,$18,$00,$60,$48,$48,$48,$90
	.db $90,$48,$58,$00,$20,$00,$00,$00,$18,$00,$60,$40,$40,$40,$40,$40\.db $00,$20,$00,$00,$00,$00,$00,$00,$00,$00,$18,$00,$60,$48,$48,$90
	.db $90,$58,$00,$20,$00,$68,$38,$50,$00,$18,$00,$00,$00,$00,$00,$00\.db $20,$00,$68,$A0,$A0,$38,$38,$38,$38,$50,$00,$18,$00,$60,$48,$90
	.db $90,$00,$20,$00,$68,$48,$48,$48,$50,$00,$18,$00,$10,$00,$10,$00\.db $00,$68,$A0,$A0,$48,$48,$48,$48,$48,$48,$50,$00,$18,$00,$60,$90
	.db $90,$00,$00,$00,$28,$48,$48,$48,$48,$50,$00,$00,$00,$00,$00,$00\.db $68,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$50,$00,$18,$00,$90
	.db $90,$00,$08,$00,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90\.db $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90

	.db $90,$00,$00,$00,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90\.db $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90
	.db $90,$00,$08,$00,$28,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48\.db $48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$A0,$48,$A0,$48,$A0,$90
	.db $90,$00,$00,$00,$28,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48\.db $48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$48,$90
	.db $90,$00,$08,$00,$60,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40\.db $40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$A0,$40,$A0,$40,$A0,$A8
	.db $90,$00,$00,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00\.db $00,$00,$00,$98,$00,$00,$00,$00,$00,$00,$98,$00,$00,$00,$00,$00
	.db $90,$00,$00,$00,$00,$00,$10,$00,$10,$00,$10,$00,$10,$00,$10,$00\.db $10,$00,$10,$00,$10,$00,$98,$00,$98,$00,$10,$00,$98,$00,$10,$00
	.db $90,$50,$00,$00,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00\.db $00,$00,$00,$00,$00,$00,$98,$00,$00,$00,$00,$00,$00,$00,$98,$00
	.db $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90\.db $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$A8

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;puts and executes info screen when race is over
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

raceisover:
	call INT_REMOVE
	ld a,0
	ld (arecord),a
	ld hl,0
	ld (derecord),hl
	call CLEARLCD
	ld b,3
recordnameloop:
	ld hl,initialsandscore
	ld de,(derecord)
	add hl,de
	ld de,(PROGRAM_ADDR)
	add hl,de
	call &ldhlwitha
	ld a,(arecord)
	ld (CURSOR_X),a
	ld a,9
	ld (CURSOR_Y),a
	ld de,alphabet
	add hl,de
	ld de,(PROGRAM_ADDR)
	add hl,de
	call D_ZM_STR
	ld a,(arecord)
	add a,6
	ld (arecord),a
	ld hl,(derecord)
	inc hl
	ld (derecord),hl
	djnz recordnameloop
	ld hl,&recordtime		;put the recordtime
	inc hl
	inc hl
	call &ldhlwitha
	ld a,1
	ld (CURSOR_ROW),a
	ld a,16
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,&recordtime
	inc hl
	call &ldhlwitha
	ld a,1
	ld (CURSOR_ROW),a
	ld a,13
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,&recordtime
	call &ldhlwitha
	ld a,1
	ld (CURSOR_ROW),a
	ld a,10
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,&recordtime
	inc hl
	inc hl
	ld a,(hl)
	call &putcolon
	ld a,1
	ld (CURSOR_ROW),a
	ld a,18
	ld (CURSOR_COL),a
	call D_ZT_STR
	ld hl,&recordtime
	inc hl
	ld a,(hl)
	call &putcolon
	ld a,1
	ld (CURSOR_ROW),a
	ld a,15
	ld (CURSOR_COL),a
	call D_ZT_STR
	ld hl,(jiffies)		;your score after each race
	ld a,3
	ld (CURSOR_ROW),a
	ld a,9
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,(seconds)
	ld a,3
	ld (CURSOR_ROW),a
	ld a,6
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,(minutes)
	ld a,3
	ld (CURSOR_ROW),a
	ld a,3
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld a,(jiffies)
	call &putcolon
	ld a,3
	ld (CURSOR_ROW),a
	ld a,11
	ld (CURSOR_COL),a
	call D_ZT_STR
	ld a,(seconds)
	call &putcolon
	ld a,3
	ld (CURSOR_ROW),a
	ld a,8
	ld (CURSOR_COL),a
	call D_ZT_STR
	ld b,8
	ld hl,$FCE2
dotlineloop2:
	ld (hl),%10101010
	inc hl
	djnz dotlineloop2
	ld b,4
	ld hl,&normalintro
	call &puttext
	ld hl,&recordtime
	ld a,(minutes)
	ld d,(hl)
	cp d
	jr c,newrecord
	jr z,keeptesting
	jp &waitagain
keeptesting:
	inc hl
	ld a,(seconds)
	ld d,(hl)
	cp d
	jr c,newrecord
	jr z,keeptesting2
	jp &waitagain
keeptesting2:
	inc hl
	ld a,(jiffies)
	ld d,(hl)
	cp d
	jp nc,&waitagain

newrecord:
	ld b,2
	ld hl,&fasttime
	call &puttext
	ld hl,$FCA0
	ld b,79
eraseloop2:
	ld (hl),0
	inc hl
	djnz eraseloop2
	ld hl,&recordtime
	ld b,3
eraserecords:
	ld (hl),0
	inc hl
	djnz eraserecords
	ld hl,&recordtime	;stores new time
	ld a,(minutes)
	ld (hl),a
	inc hl
	ld a,(seconds)
	ld (hl),a
	inc hl
	ld a,(jiffies)
	ld (hl),a
	ld b,8
	ld hl,$FCE2
dotlineloop:
	ld (hl),%10101010
	inc hl
	djnz dotlineloop
	ld hl,(jiffies)		;draw new recordtime
	ld a,1
	ld (CURSOR_ROW),a
	ld a,16
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,(seconds)
	ld a,1
	ld (CURSOR_ROW),a
	ld a,13
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld hl,(minutes)
	ld a,1
	ld (CURSOR_ROW),a
	ld a,10
	ld (CURSOR_COL),a
	call D_HL_DECI
	ld a,(jiffies)
	call &putcolon
	ld a,1
	ld (CURSOR_ROW),a
	ld a,18
	ld (CURSOR_COL),a
	call D_ZT_STR
	ld a,(seconds)
	call &putcolon
	ld a,1
	ld (CURSOR_ROW),a
	ld a,15
	ld (CURSOR_COL),a
	call D_ZT_STR

	ld a,0
	ld (arecord),a
	ld (derecord),a
	ld (storea),a
inputloop:
	ld a,70
	call &delay
	ld a,(arecord)
	ld (CURSOR_X),a
	ld a,9
	ld (CURSOR_Y),a
	ld a,$FE
 	out (1),a
 	in a,(1)
	push af
 	bit 1,a
 	jr z,prevletter
afterprevletter:
	pop af
	push af
 	bit 2,a
 	jr z,nextletter
afternextletter:
	pop af
	bit 0,a
	jr z,newletter
afternewletter:
	ld de,(derecord)
	ld hl,alphabet
	add hl,de
	ld de,(PROGRAM_ADDR)
	add hl,de
	call D_ZM_STR
	jr inputloop

prevletter:
	ld a,(derecord)
	or a
	jr z,afterprevletter
	dec a
	dec a
	dec a
	ld (derecord),a
	jr afterprevletter

nextletter:
	ld a,(derecord)
	cp 75
	jr z,afternextletter
	inc a
	inc a
	inc a
	ld (derecord),a
	jr afternextletter

newletter:
	ld a,255
	call &delay
	ld hl,initialsandscore
	ld de,(storea)
	add hl,de
	ld de,(PROGRAM_ADDR)
	add hl,de
	ld a,(derecord)
	ld (hl),a
	ld a,(arecord)
	add a,6
	ld (arecord),a
	ld a,(storea)
	inc a
	ld (storea),a
	cp 3
	jr nz,afternewletter

waitagain:
	ld a,$BF
	out (1),a
	in a,(1)
	bit 7,a
	jp z,&playagain
	bit 6,a
	jr nz,waitagain

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;thanks you for playing
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

thankstext:
	call CLEARLCD
	ld b,1
	ld hl,&thanks
	call &puttext
	ld b,2
finaldelay:
	ld a,255
	call &delay
	djnz finaldelay
	ret

normalintro:
	.db 0,0,"Best time:",0
	.db 39,17,"Your Time Was:",0
	.db 45,40,"Play Again?",0
	.db 26,46,"Yes=[MORE]   No=[EXIT]",0

fasttime:
	.db 38,0,"A new fast time!",0
	.db 28,52,"Enter letter=[DOWN]",0

thanks:
	.db 32,29,"Thanks For Playing!",0

initialsandscore:
	.db 45,6,36

recordtime:
	.db 1,30,00

colon:
	.db ":",0

colonwith0:
	.db ":0",0

alphabet:
	.db "A ",0\.db "B ",0\.db "C ",0\.db "D ",0\.db "E ",0\.db "F ",0
	.db "G ",0\.db "H ",0\.db "I ",0\.db "J ",0\.db "K ",0\.db "L ",0
	.db "M ",0\.db "N ",0\.db "O ",0\.db "P ",0\.db "Q ",0\.db "R ",0
	.db "S ",0\.db "T ",0\.db "U ",0\.db "V ",0\.db "W ",0\.db "X ",0
	.db "Y ",0\.db "Z ",0

playagain:
	call INT_REMOVE
	jp &playagain2

prethankstext:
	call INT_REMOVE
	jp &thankstext

putcolon:
	cp 10
	jr nc,putcolon2
 	ld hl,&colonwith0
	ret
putcolon2:
	ld hl,&colon
	ret

ldhlwitha:
	ld de,0
	ld (storea),de
	ld a,(hl)
	ld (storea),a
	ld hl,(storea)
	ret
	
ldawith2:
	ld a,2
	ld (jiffyadd),a
	ret

addjiffy:
	ld a,(jiffyadd)
	dec a
	jr z,ldawith2
	ld (jiffyadd),a
	ld a,(jiffies)
	inc a
	cp 100
	jr z,addsecond
	ld (jiffies),a
	ret
addsecond:
	ld a,0
	ld (jiffies),a
	ld a,(seconds)
	inc a
	cp 60
	jr z,addminute
	ld (seconds),a
	ret
addminute:
	ld a,0
	ld (seconds),a
	ld a,(minutes)
	inc a
	ld (minutes),a
	ret
.end





