;-------------------------------------------------------------------------------------
;This is my first game wrote in assembly.  I don't have many comments now, but I might 
;add more later.  If you modify this source, please don't distribute it to others.
;If you find any bugs, please tell me.
;
;If you want to use parts of my program, please give me credit in your source.
;
; E-mail: saywhat97@hotmail.com
; webpage: http://www.angelfire.com/wi/JohnsMiscLinks
;-------------------------------------------------------------------------------------


#include "asm86.h"
#include "ti86asm.inc"
#include "ti86abs.inc"
#include "ti86ops.inc"


Ptzend1 =_asm_exec_ram+8000								;at the end of the program.


; saved with all saved games
savelev = Ptzend1							;level used in save game
savestat = Ptzend1+10						;tells program when game was saved
ppoints = Ptzend1+11						;player's number of points
pammo = Ptzend1+13							;amount of players ammo
plives = Ptzend1+14							;number of players lives
lev = Ptzend1+15							;level game was saved at

; saved with games saved after a level was played but not passed
ppointsg = Ptzend1+16						;number of points needed to pass level
enmyblives = Ptzend1+18
penmyk = Ptzend1+19							;number of enemy kills to pass level
enmybossn = Ptzend1+20
penmykg = Ptzend1+21
numa = Ptzend1+22
numb = Ptzend1+23
enmycnt = Ptzend1+24
enmydd1 = Ptzend1+25
enmydd2 = Ptzend1+26
enmydd3 = Ptzend1+27
enmydd4 = Ptzend1+28
enmyddb  = Ptzend1+29
enmydd = Ptzend1+30
plivesg = Ptzend1+31
scoreneed = Ptzend1+32
ptz = Ptzend1+34
ptz1 = Ptzend1+52
ptz2 = Ptzend1+73
ptz3 = Ptzend1+94
ptz4 = Ptzend1+115
ptz5 = Ptzend1+136
ptz6 = Ptzend1+157
ptz7 = Ptzend1+178

; saved with games saved using CLEAR button
enmyrMnSRT = Ptzend1+199
enmycMnSRT = Ptzend1+200
enmyrMn = Ptzend1+201
enmycMn = Ptzend1+202
psDir = Ptzend1+203
psR = Ptzend1+204
psC = Ptzend1+205
bsDir = Ptzend1+206
bsR = Ptzend1+207
bsC = Ptzend1+208
shtDir = Ptzend1+209
shtR = Ptzend1+210
shtC = Ptzend1+211
pr = Ptzend1+212
pc = Ptzend1+213
enmyr1 = Ptzend1+214
enmyr2 = Ptzend1+215
enmyr3 = Ptzend1+216
enmyr4 = Ptzend1+217
enmyrb = Ptzend1+218
enmyc1 = Ptzend1+219
enmyc2 = Ptzend1+220
enmyc3 = Ptzend1+221
enmyc4 = Ptzend1+222
enmycb = Ptzend1+223

; not saved in save games
mr = Ptzend1+224
mc = Ptzend1+225
Menuentries = Ptzend1+226
loadstat = Ptzend1+227
contrastcnt = Ptzend1+228
contrastcnta = Ptzend1+229
pdiecnt = Ptzend1+230
rlst = Ptzend1+231
clst = Ptzend1+232
shtClast = Ptzend1+233
shtRlast = Ptzend1+234
shtRc = Ptzend1+235
shtCc = Ptzend1+236
shtDirc = Ptzend1+237
title = Ptzend1+238
instloopnum = Ptzend1+239
checkbytenum = Ptzend1+240
chrleft = Ptzend1+241
xtableloc = Ptzend1+242
symlocate  = Ptzend1+244
levhl = Ptzend1+246
leva = Ptzend1+248
pcol = Ptzend1+249
prow = Ptzend1+250
no_save = Ptzend1+251
xlevelsnum = Ptzend1+252							;number of external levels found
xlevelstable = Ptzend1+253							;table of external levels
editeract = Ptzend1+416
testlevs = Ptzend1+417
maxlevs = Ptzend1+418
charmax = Ptzend1+419
editview = Ptzend1+420
passwordmakenum = Ptzend1+421
passloopnum = Ptzend1+422
passwordcheck  = Ptzend1+423
passwordtyped = Ptzend1+428
passwordtyping = Ptzend1+433
r = Ptzend1+434
c = Ptzend1+435
enmygoing = Ptzend1+436
enmycheck = Ptzend1+437
PTZWRLD = Ptzend1+439								;used when loading levels from a world
levlength  = Ptzend1+450
rnow = Ptzend1+452
cnow = Ptzend1+453
rlast = Ptzend1+454
clast = Ptzend1+455
editbossstat = Ptzend1+456							;1 if boss on screen
charcount = Ptzend1+457
string = Ptzend1+458
numtype = Ptzend1+480
bytenum = Ptzend1+481
converted = Ptzend1+482
place1 = Ptzend1+484
place10 = Ptzend1+486
place100 = Ptzend1+488
place1000 = Ptzend1+490
place10000 = Ptzend1+492
placetimes = Ptzend1+494
mulcount = Ptzend1+496
convloopcount = Ptzend1+497
dispname = Ptzend1+498
dispwname = Ptzend1+520
curlengthwname = Ptzend1+542
newsize = Ptzend1+544
cursize = Ptzend1+546
wnamelength =Ptzend1+548
next = Ptzend1+550





.org _asm_exec_ram
First_label
	nop									;start of table used by ASE,etc.
	jp The_start_of_game
    .dw $0000
    .dw Name  							;end of table
Highscrnum: .db 0,0
Lastscrnum: .db 0,0
The_start_of_game:
	call $49DC							;flush all menus
	call _clrScrn
	res appAutoScroll,(iy+appflags)		;turn off scrolling
	call _runindicoff          			;turn off run indicator
editeristhere
	ld a,0
	ld (PTZWRLD+9),a
	ld (editview),a
	ld (testlevs),a
	ld (no_save),a
	ld (title),a
Progstart:
	ld a,0
	ld (savestat),a
	ld (loadstat),a
	ld hl,50
	ld (scoreneed),hl
	ld a,2
	ld (contrastcnt),a
	ld a,2
	ld (contrastcnta),a
    ld hl,title_pic
    ld de,$Fd63
    ld bc,169
    ldir
    ld hl,title_pic2
    ld de,$Fe32
    ld bc,42
    ldir
    ld hl,box1
    ld de,$Ff39
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ff49
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ff59
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ff69
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ff79
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ff89
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ff99
    ld bc,7
    ldir
    ld hl,box2
    ld de,$Ffa9
    ld bc,7
    ldir
    ld hl,box1
    ld de,$Ffb9
    ld bc,7
    ldir
    ld hl,bar
    ld de,$Ff06
    ld bc,4
    ldir
	ld a,41
	ld (_penRow),a
	ld a,52
	ld (_penCol),a
	ld hl,ver
	call _vputs
	ld a,49
	ld (_penRow),a
	ld a,8
	ld (_penCol),a
	ld hl,by
	call _vputs
	ld a,56
	ld (_penRow),a
	ld a,8
	ld (_penCol),a
	ld hl,auther
	call _vputs
	ld a,52
	ld (_penRow),a
	ld a,81
	ld (_penCol),a
	ld hl,press
	call _vputs
begin:
	call _getkey
	cp kExit
	jp z,End
pleaz:
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,please
	call _puts
Firstmenu:
	ld a,2
	ld b,a
	ld a,1
	ld hl,newmsg
	call putflines
	ld a,6
	ld (Menuentries),a
	call Menustart
	jp mainmenuchoose
Menustart
	call $47e3
	ld a,3
	ld b,a
	ld a,16
	ld hl,exittoquit
	call putflines
	ld a,2
	ld (pr),a
	jp Menumain
Menumain
	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld a,5
	call _putmap
Menukeyloop:
	call _getkey
	cp kEnter
	jp z,Menuend
	cp kUp
	jr z,menuup
	cp kDown
	jr z,menudown
	cp kExit
	jr z,mEnd
	jr Menukeyloop
mEnd
	pop hl
	jp End
menuup
	ld a,(pr)
	cp 2
	jr z,Menuloopup
	ld (pc),a
	ld a,(pr)
	dec a
	ld (pr),a
	jr menudraw
menudown
	ld a,(Menuentries)
	ld b,a
	ld a,(pr)
	cp b
	jr z,Menuloopdown
	ld (pc),a
	ld a,(pr)
	inc a
	ld (pr),a
	jr menudraw
Menuloopup
	ld (pc),a
	ld a,(Menuentries)
	ld (pr),a
	jr menudraw
Menuloopdown
	ld (pc),a
	ld a,2
	ld (pr),a
	jr menudraw
menudraw
	ld a,(pc)
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld a,$20
	call _putmap
	ld a,(pr)
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld a,5
	call _putmap
	jp Menukeyloop
Menuend
	call $47e3

	ret
mainmenuchoose:
	ld a,(pr)
	cp 2
	jr z,Newgame
	cp 3
	jp z,Loadgame
	cp 4
	jp z,ViewHighscore
	cp 5
	jp z,Instructions
	cp 6
	jp z,Delgames
	jp Editer
Editer
	jp pleaz
Newgame:								;begin a new game
	call Selectlevs						;goto world selection menu
Restarted:								;jumped to after Restart selected on level menu
	ld hl,0
	ld (ppoints),hl
	ld a,0
	ld (pammo),a
	ld a,1
	ld (lev),a
	ld a,3
	ld (plives),a
Loadl:									;jumped to after player passes a level
	ld a,0
	ld (psDir),a
	ld (bsDir),a
	ld (enmyddb),a
	ld (enmydd1),a
	ld (enmydd2),a
	ld (enmydd3),a
	ld (enmydd4),a
	ld (penmyk),a
	ld a,-1
	ld (enmyr1),a
	ld (enmyc1),a
	ld (enmyrMn),a
	ld (enmycMn),a
	call Find_location_of_level
	jp Levloopend
Find_location_of_level
	ld hl,PTZWRLD-1						;world selected to be played
	rst 20h
	rst 10h
	jp c,noworlds
	ld a,0
	ld h,a
	ld a,13								;bytes to skip at the start of the world string
	ld l,a
	add hl,de
	push hl
	ld a,b
	call $46c3											; a,(ahl)
	pop hl	
	inc a
	ld e,a 												; bytes of the authors name
	ld a,0
	ld d,a
	add hl,de
	push hl
	ld a,b
	call $46c3											; a,(ahl)
	pop hl
	inc a
	ld e,a												; bytes of the worlds name
	ld a,0
	ld d,a
	add hl,de
	ld de,166											; bytes for 1 level
	ld a,(lev)
	dec a
Levloop
	cp 0
	jr z,Levloope
	dec a
	add hl,de
	jr Levloop
Levloope:
	ld a,b
	ret
Levloopend
	push af
	push hl
	call $46c3											; a,(ahl)
	ld b,a
	ld a,(editview)
	cp 1
	jr z,Levloopecont
	ld a,(lev)
	cp b
	jp nz,Uwin
Levloopecont
	pop hl
	pop af
	inc hl
	call _SET_ABS_SRC_ADDR
	ld hl,ptz
	ld a,0
	call _SET_ABS_DEST_ADDR
	ld a,166
	ld l,a
	ld a,0
	ld h,a
	call _SET_MM_NUM_BYTES
	call _mm_ldir
Levbgn:
	call $47e3
	ld a,0
	ld (psDir),a
	ld (bsDir),a
	ld a,-1
	ld (bsR),a
	ld (bsC),a
	ld (enmyrMn),a
	ld (enmycMn),a
	ld a,(ptz+15)
	ld (enmyrb),a
	ld a,(ptz+16)
	ld (enmycb),a
	ld a,(ptz+17)
	ld (enmyblives),a
	ld a,(ptz+7)
	ld (enmyr1),a
	ld a,(ptz+8)
	ld (enmyc1),a
	ld a,(ptz+9)
	ld (enmyr2),a
	ld a,(ptz+10)
	ld (enmyc2),a
	ld a,(ptz+11)
	ld (enmyr3),a
	ld a,(ptz+12)
	ld (enmyc3),a
	ld a,(ptz+13)
	ld (enmyr4),a
	ld a,(ptz+14)
	ld (enmyc4),a
	ld a,(ptz+6)
	ld (enmybossn),a
	ld a,(ptz+3)
	ld (enmycnt),a
	ld a,(ptz+4)
	ld (pr),a
	ld (rlst),a
	ld a,(ptz+5)
	ld (pc),a
	ld (clst),a
	ld hl,(ptz)
	ld (ppointsg),hl
	ld a,(ptz+2)
	ld (penmykg),a
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld a,10
	ld (_curCol),a
	ld a,(lev)
	ld l,a
	ld a,0
	ld h,a
	call $4a33 										; display ahl as a decimal
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,Enterl
	call _puts
	ld a,1
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,goalst
	call _puts
	ld a,2
	ld (_curRow),a
	ld a,16
	ld (_curCol),a
	ld hl,(ppointsg)
	ld a,0
	call $4a33 										; display ahl as a decimal
	ld a,2
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,pointsgt
	call _puts
	ld a,3
	ld (_curRow),a
	ld a,16
	ld (_curCol),a
	ld a,(penmykg)
	ld l,a
	ld a,0
	ld h,a
	call $4a33 										; display ahl as a decimal
	ld a,3
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,enemykt
	call _puts
	ld a,(editview)
	cp 1
	ret z
Playerlifegain
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,(scoreneed)
	ld a,h
	ld b,a
	ld a,d
	cp b
	jr nc,playscrhighergo
	jr LEVmenua
playscrhighergo
	ld a,l
	ld b,a
	ld a,e
	cp b
	jr nc,playscrhigher
	jr LEVmenua
playscrhigher:
	ld hl,(scoreneed)
	EX DE,HL
	ld hl,150
	add hl,de
	ld (scoreneed),hl
	ld a,(plives)
	inc a
	ld (plives),a
LEVmenua:
	ld a,6
	ld (_curRow),a
	ld a,2
	ld (_curCol),a
	ld hl,go
	call _puts
	ld a,15
	ld (_curCol),a
	ld hl,menutxt
	call _puts
	ld a,1
	ld (mc),a
	ld (_curCol),a
	ld a,5
	call _putmap
levMenukeyloop:
	call _getkey
	cp kEnter
	jp z,levMenuend
	cp kLeft
	jr z,levmenuleft
	cp kRight
	jr z,levmenuright
	cp kExit
	jr z,levmEnd
	jr levMenukeyloop
levmEnd
	jp End
levmenuleft
	ld a,(mc)
	cp 1
	jr z,levMenuloopleft
	ld (mr),a
	ld a,1
	ld (mc),a
	jr levmenudraw
levmenuright
	ld a,(mc)
	cp 14
	jr z,levMenuloopright
	ld (mr),a
	ld a,14
	ld (mc),a
	jr levmenudraw
levMenuloopleft
	ld (mr),a
	ld a,14
	ld (mc),a
	jr levmenudraw
levMenuloopright
	ld (mr),a
	ld a,1
	ld (mc),a
	jr levmenudraw
levmenudraw
	ld a,6
	ld (_curRow),a
	ld a,(mr)
	ld (_curCol),a
	ld a,$20
	call _putmap
	ld a,6
	ld (_curRow),a
	ld a,(mc)
	ld (_curCol),a
	ld a,5
	call _putmap
	jp levMenukeyloop
levMenuend
	ld a,0
	ld (loadstat),a
	ld a,(mc)
	cp 1
	jr z,Ptzl
	cp 14
	jp z,Levmenub
Ptzl:
	call Screendraw
	jp drawend
Screendraw:
	call _clrLCD
	call $47e3
	ld a,2
	ld (savestat),a
	ld hl,ptz1-1
	ld d,h
	ld e,l
	push bc
	push de
	ld a,0
	ld d,a
	ld (_curRow),a
	ld a,-1
	ld c,a
	ld (_curCol),a
Main:
	inc d
MainA:
	inc c
Mload:
	ld a,d
	ld (numa),a
	ld a,c
	ld (numb),a
	pop de
	pop bc
	ld a,1
	ld l,a
	ld a,0
	ld h,a
	add hl,de
	ld d,h
	ld e,l
	ld a,b
	call $46c3											; a,(ahl)
	push bc
	push de
	ld h,a
	ld a,(numb)
	ld c,a
	ld a,(numa)
	ld d,a
	ld a,h
	push af
	cp 4
	jr c,maindraw
	ld a,(loadstat)
	cp 1
	jr z,Blank
maindraw
	call $47e3
	pop af
	push af
	push de
	ld hl,displaytable
	add a,a
	ld de,0
	ld e,a
	add hl,de
	pop de
	jr Draw
Blank
	ld hl,displaytable+18
Draw:
	pop af
	ld a,c
	ld (_curCol),a
	ld a,d
	ld (_curRow),a
	ld a,h
	call _puts
	ld a,c
	cp 20
	jp nz,MainA
	ld a,-1
	ld c,a
	ld a,d
	cp 7
	jr nz,Main
	pop de
	pop bc
	ret
drawend:
	ld a,0
	ld (enmygoing),a
enmydddraw
	ld a,(enmygoing)
	cp 5
	jp z,Plyrdr
	ld de,0
	ld e,a
	ld hl,enmydd1
	add hl,de
	ld a,(hl)
	cp 0
	call nz,draw1blank
	ld a,(enmygoing)
	inc a
	ld (enmygoing),a
	jr enmydddraw
draw1blank:
	ld hl,enmyr1
	add hl,de
	ld a,(hl)
	ld (_curRow),a
	ld hl,enmyc1
	add hl,de
	ld a,(hl)
	ld (_curCol),a
	ld a,$20
	call _putmap
	ret
Turnstrt:
	ld a,0
	ld (pdiecnt),a
	ld (_curRow),a
	ld (_curCol),a
	ld a,0
	ld h,a
	ld a,(lev)
	ld l,a
	ld a,0
	call $4a33											; display ahl as a decimal
	ld a,0
	ld h,a
	ld a,(plives)
	ld l,a
	ld a,0
	call $4a33											; display ahl as a decimal
	ld a,0
	ld h,a
	ld a,(pammo)
	ld l,a
	ld a,0
	call $4a33											; display ahl as a decimal
	ld hl,(ppoints)
	ld a,0
	call $4a33											; display ahl as a decimal
	ld hl,(ppoints)
	EX DE,HL
	ld hl,(ppointsg)
	ld a,h
	ld b,a
	ld a,d
	cp b
	jr nc,egoalkcgo
	jr Plyrmv
egoalkcgo
	ld a,l
	ld b,a
	ld a,e
	cp b
	jp nc,egoalkc
Plyrmv:
	call PdieChck
	ld a,%11111110
	out (1),a
	nop
	nop
	in a,(1)
	bit 3,a
	jp z,Pup
	in a,(1)
	bit 0,a
	jp z,Pdown
	in a,(1)
	bit 2,a
	jp z,Pright
	in a,(1)
	bit 1,a
	jp z,Pleft
	ld a,%10111111
	out (1),a
	nop
	nop
	in a,(1)
	bit 7,a
	jp z,Pause
	in a,(1)
	bit 6,a
	jp z,Exit
	ld a,%11101111
	out (1),a
	nop
	nop
	in a,(1)
	bit 7,a
	jp z,Pshootup
	in a,(1)
	bit 5,a
	jp z,Pshootdown
	ld a,%11110111
	out (1),a
	nop
	nop
	in a,(1)
	bit 6,a
	jp z,Pshootright
	ld a,%11011111
	out (1),a
	nop
	nop
	in a,(1)
	bit 6,a
	jp z,Pshootleft
	ld a,%11111101
	out (1),a
	nop
	nop
	in a,(1)
	bit 1,a
	jp z,Contrastup
	in a,(1)
	bit 2,a
	jp z,Contrastdwn
	in a,(1)
	bit 6,a
	jp z,Savegame
	jp Plyrmvd
Contrastup:									;increases the screen contrasr
	ld a,(contrastcnt)
	dec a
	ld (contrastcnt),a
	cp 0									;used to slow down contrast change
	jp nz,Plyrmv
	ld a,(contrastcnta)
	dec a
	ld (contrastcnta),a
	cp 0									;used to slow down contrast change
	jp nz,Plyrmv
	ld a,255
	ld (contrastcnt),a
	ld a,3
	ld (contrastcnta),a
	ld a,($c008)							;contrast stored in ram
	cp $1f
	jp z,Plyrmv
	inc a
	ld ($c008),a
	out (2),a
	jp Plyrmv
Contrastdwn:								;decrease contrast
	ld a,(contrastcnt)
	dec a
	ld (contrastcnt),a
	cp 0									;used to slow down contrast change
	jp nz,Plyrmv
	ld a,(contrastcnta)
	dec a
	ld (contrastcnta),a
	cp 0									;used to slow down contrast change
	jp nz,Plyrmv
	ld a,255
	ld (contrastcnt),a
	ld a,3
	ld (contrastcnta),a
	ld a,($c008)							;contrast stored in ram
	cp 0
	jp z,Plyrmv
	dec a
	ld ($c008),a
	out (2),a
	jp Plyrmv
Pshootleft:
	ld a,(psDir)
	cp 0
	jp nz,Enmysstrt
	ld a,(pammo)
	cp 0
	jp z,Enmysstrt
	dec a
	ld (pammo),a
	ld a,(pr)
	ld (psR),a
	ld a,(pc)
	ld (psC),a
	ld a,4
	ld (psDir),a
	jp Pshootdraw
Pshootright:
	ld a,(psDir)
	cp 0
	jp nz,Enmysstrt
	ld a,(pammo)
	cp 0
	jp z,Enmysstrt
	dec a
	ld (pammo),a
	ld a,(pr)
	ld (psR),a
	ld a,(pc)
	ld (psC),a
	ld a,3
	ld (psDir),a
	jp Pshootdraw
Pshootup:
	ld a,(psDir)
	cp 0
	jp nz,Enmysstrt
	ld a,(pammo)
	cp 0
	jp z,Enmysstrt
	dec a
	ld (pammo),a
	ld a,(pr)
	ld (psR),a
	ld a,(pc)
	ld (psC),a
	ld a,1
	ld (psDir),a
	jp Pshootdraw
Pshootdown:
	ld a,(psDir)
	cp 0
	jp nz,Enmysstrt
	ld a,(pammo)
	cp 0
	jp z,Enmysstrt
	dec a
	ld (pammo),a
	ld a,(pr)
	ld (psR),a
	ld a,(pc)
	ld (psC),a
	ld a,2
	ld (psDir),a
	jp Pshootdraw
Pleft:
	ld a,(pc)
	cp 0
	jp z,Plyrmvd
	ld a,(pc)
	dec a
	ld (pc),a
	jp Plyrmc
Pright:
	ld a,(pc)
	cp 20
	jp z,Plyrmvd
	ld a,(pc)
	inc a
	ld (pc),a
	jp Plyrmc
Pup:
	ld a,(pr)
	cp 1
	jp z,Plyrmvd
	ld a,(pr)
	dec a
	ld (pr),a
	jp Plyrmc
Pdown:
	ld a,(pr)
	cp 7
	jp z,Plyrmvd
	ld a,(pr)
	inc a
	ld (pr),a
	jp Plyrmc
Plyrmc:
	ld a,(pr)
	ld (r),a
	ld a,(pc)
	ld (c),a
	call findtiletype
	cp 1
	jr z,Ppointg
	cp 2
	jr z,Pammog
	cp 7
	jr z,Plyrdr
	cp 9
	jr z,Plyrdr
	cp 10
	jr z,Plyrdr
	cp 11
	jr z,Plyrdr
	ld a,(rlst)
	ld (pr),a
	ld a,(clst)
	ld (pc),a
	jp Plyrmvd
Pammog:
	ld a,9
	ld (hl),a
	ld hl,(pammo)
	ld a,5
	ld e,a
	ld a,0
	ld d,a
	add hl,de
	ld (pammo),hl
	jp Plyrdr
Ppointg:
	ld a,9
	ld (hl),a
	ld hl,(ppoints)
	ld a,5
	ld e,a
	ld a,0
	ld d,a
	add hl,de
	ld (ppoints),hl
	jp Plyrdr
Plyrdr:
	ld a,(clst)
	ld (_curCol),a
	ld a,(rlst)
	ld (_curRow),a
	ld a,$20
	call _putmap
Playerdraw
	ld a,(pc)
	ld (_curCol),a
	ld a,(pr)
	ld (_curRow),a
	ld a,$2a
	call _putmap
	ld a,(pc)
	ld (clst),a
	ld a,(pr)
	ld (rlst),a
	jp Plyrmvd
findtiletype
	ld a,(r)
	ld hl,0
	ld de,21
	dec a
Plyrmcloop
	cp 0
	jr z,Plyrmcloopend
	dec a
	add hl,de
	jr Plyrmcloop
Plyrmcloopend
	EX DE,HL
	ld hl,ptz1
	add hl,de
	ld a,0
	ld d,a
	ld a,(c)
	ld e,a
	add hl,de
	ld a,(hl)
	ret
Pause:
	ld a,0
	ld (_curRow),a
	ld a,20
	ld (_curCol),a
	ld a,$50
	call _putmap
	call _getkey
	ld a,0
	ld (_curRow),a
	ld a,20
	ld (_curCol),a
	ld a,$20
	call _putmap
	jp Plyrmvd
Exit:
End:
	ld a,(testlevs)
	cp 1
	ret z
	ld a,(no_save)
	cp 0
	jr nz,No_re_write
	call Scorechecks						;checks for high score
	ld hl,PUTZ-1							;next few lines re-write score into ram to save scores
	rst 20h
	rst 10h
	jr c,No_re_write
	ld a,b
	ld h,d
	ld l,e
	ld de,12
	add hl,de
	call _SET_ABS_DEST_ADDR
	ld hl,Highscrnum
	ld a,0
	call _SET_ABS_SRC_ADDR
	ld hl,4
	ld a,0
	call _SET_MM_NUM_BYTES
	call _mm_ldir
No_re_write
	ld a,0									;puts cursor at top of screen
	ld (_curRow),a
	set appAutoScroll,(iy+appflags)			;turns on scrolling
	call _runindicon						;turns on run indicator
	call _clrScrn
	ld a,0
	ld (iy+18),a							;resets status of 2nd and ALPHA keys
	call $47f3
	ret										;leaves program
egoalkc:
	ld a,(penmykg)
	ld b,a
	ld a,(penmyk)
	cp b
	jp c,Plyrmv
	ld a,(lev)
	inc a
	ld (lev),a
	ld a,0
	ld (savestat),a
	jp Loadl
Plyrmvd:
	call Playershootmove
	jp Enmysstrt
Enmysstrt:
	ld a,0
	ld (enmygoing),a
Enmysstrtloop
	ld a,(enmycnt)
	ld b,a
	ld a,(enmygoing)
	cp b
	jp z,Enmybossstrt
	call Enmynostrt
	ld a,(enmygoing)
	inc a
	ld (enmygoing),a
	jr Enmysstrtloop
Enmynostrt:
	ld hl,enmydd1
	ld a,(enmygoing)
	ld de,0
	ld e,a
	add hl,de
	ld a,(hl)
	cp 1
	ret z
	ld a,(enmygoing)
	ld de,0
	ld e,a
	ld hl,enmydd1
	add hl,de
	ld a,(hl)
	ld (enmydd),a
	ld hl,enmyr1
	add hl,de
	ld a,(hl)
	ld (enmyrMn),a
	ld hl,enmyc1
	add hl,de
	ld a,(hl)
	ld (enmycMn),a
	call Enmymovemn
	call PdieChck
	ld a,(enmygoing)
	ld de,0
	ld e,a
	ld a,(enmyrMn)
	ld hl,enmyr1
	add hl,de
	ld (hl),a
	ld a,(enmycMn)
	ld hl,enmyc1
	add hl,de
	ld (hl),a
	ld a,(enmydd)
	ld hl,enmydd1
	add hl,de
	ld (hl),a
	call Playershootmove
	ret
Enmybossstrt:
	ld a,(enmyddb)
	cp 1
	jp z,Turnstrt
	ld a,(enmybossn)
	cp 0
	jp z,Turnstrt
	ld a,(enmyddb)
	ld (enmydd),a
	ld a,(enmyrb)
	ld (enmyrMn),a
	ld a,(enmycb)
	ld (enmycMn),a
	call Enmybossmove
	call PdieChck
	ld a,(enmyrMn)
	ld (enmyrb),a
	ld a,(enmycMn)
	ld (enmycb),a
	ld a,(enmydd)
	ld (enmyddb),a
	call Playershootmove
	jp Turnstrt
Enmybossmove
	ld a,(enmyrMn)
	ld (enmyrMnSRT),a
	ld a,(enmycMn)
	ld (enmycMnSRT),a
	ld a,(enmyrb)
	ld b,a
	ld a,(pr)
	cp b
	jr z,BossRowsame
	ld a,(enmycb)
	ld b,a
	ld a,(pc)
	cp b
	jr z,BossColsame
	jp Enmymovemnrnd
BossRowsame:
	ld a,(enmycb)
	ld b,a
	ld a,(pc)
	cp b
	jr c,Bshootleft
	jr Bshootright
BossColsame:
	ld a,(enmyrb)
	ld b,a
	ld a,(pr)
	cp b
	jr c,Bshootup
	jr Bshootdown
Bshootleft:
	ld a,(bsDir)
	cp 0
	jp nz,Enmymovemnrnd
	ld a,(enmyrb)
	ld (bsR),a
	ld a,(enmycb)
	ld (bsC),a
	ld a,4
	ld (bsDir),a
	jp bossshootdraw
Bshootright:
	ld a,(bsDir)
	cp 0
	jp nz,Enmymovemnrnd
	ld a,(enmyrb)
	ld (bsR),a
	ld a,(enmycb)
	ld (bsC),a
	ld a,3
	ld (bsDir),a
	jp bossshootdraw
Bshootup:
	ld a,(bsDir)
	cp 0
	jp nz,Enmymovemnrnd
	ld a,(enmyrb)
	ld (bsR),a
	ld a,(enmycb)
	ld (bsC),a
	ld a,1
	ld (bsDir),a
	jp bossshootdraw
Bshootdown:
	ld a,(bsDir)
	cp 0
	jp nz,Enmymovemnrnd
	ld a,(enmyrb)
	ld (bsR),a
	ld a,(enmycb)
	ld (bsC),a
	ld a,2
	ld (bsDir),a
	jp bossshootdraw
Enmymovemn:
	ld a,(enmyrMn)
	ld (enmyrMnSRT),a
	ld a,(enmycMn)
	ld (enmycMnSRT),a
	ld a,0
 	call $4613
	ld a,3
	call $4617
 	call $5544
	call $5577		;_CONVOP1
	cp 3
	jr z,Enmymovemnrnd
	ld a,(enmyrMn)
	ld b,a
	ld a,(pr)
	cp b
	jr z,EnmyRowsame
	ld a,(enmycMn)
	ld b,a
	ld a,(pc)
	cp b
	jr z,EnmyColsame
	jr Enmymovemnrnd
EnmyRowsame:
	ld a,(enmycMn)
	ld b,a
	ld a,(pc)
	cp b
	jr c,EnmymvL
	jr EnmymvR
EnmyColsame:
	ld a,(enmyrMn)
	ld b,a
	ld a,(pr)
	cp b
	jr c,EnmymvU
	jr EnmymvD
Enmymovemnrnd:
	ld a,0
 	call $4613
	ld a,8
	call $4617
 	call $5544
	call $5577		;_CONVOP1  
 	cp 0
	jp z,Enmymovemn
	cp 3
	jp z,EnmymvL
	cp 1
	jp z,EnmymvR
	cp 4
	jp z,EnmymvU
	cp 2
	jp z,EnmymvD
	cp 8
	jp z,EnmymvL
	cp 6
	jp z,EnmymvR
	cp 7
	jp z,EnmymvU
	cp 5
	jp z,EnmymvD
	ret
EnmymvL:
	ld a,(enmycMn)
	cp 0
	ret z
	ld a,(enmycMn)
	dec a
	ld (enmycMn),a
	jp EnmymoveCHK
EnmymvR:
	ld a,(enmycMn)
	cp 20
	ret z
	ld a,(enmycMn)
	inc a
	ld (enmycMn),a
	jp EnmymoveCHK
EnmymvU:
	ld a,(enmyrMn)
	cp 1
	ret z
	ld a,(enmyrMn)
	dec a
	ld (enmyrMn),a
	jp EnmymoveCHK
EnmymvD:
	ld a,(enmyrMn)
	cp 7
	ret z
	ld a,(enmyrMn)
	inc a
	ld (enmyrMn),a
	jp EnmymoveCHK
EnmymoveCHK:
	ld a,(enmyrMn)
	ld (r),a
	ld a,(enmycMn)
	ld (c),a
	call findtiletype
	cp 7
	jr z,Enemymovechk2
	cp 9
	jr z,Enemymovechk2
	cp 10
	jr z,Enemymovechk2
	cp 11
	jr z,Enemymovechk2
	jp Enmymovenogo
Enemymovechk2
	ld a,(enmycnt)
	ld b,a
	ld a,(enmybossn)
	add a,b
	ld c,a
	ld a,0
	ld (enmycheck),a
Enemymovechk2loop
	cp c
	jr z,EnmymoveDrw
	ld a,(enmycheck)
	ld de,0
	ld e,a
	ld hl,enmyr1
	add hl,de
	ld a,(hl)
	ld b,a
	ld a,(enmyrMn)
	cp b
	jr z,enemymovechk2col
Enemymovechk2loopend
	ld a,(enmycheck)
	inc a
	ld (enmycheck),a
	jr Enemymovechk2loop
enemymovechk2col
	ld hl,enmyc1
	add hl,de
	ld a,(hl)
	ld b,a
	ld a,(enmycMn)
	cp b
	jr z,Enmymovenogo
	jr Enemymovechk2loopend
Enmymovenogo:
	ld a,(enmyrMnSRT)
	ld (enmyrMn),a
	ld a,(enmycMnSRT)
	ld (enmycMn),a
	ret
EnmymoveDrw:
	ld a,(enmyrMn)
	ld (_curRow),a
	ld a,(enmycMn)
	ld (_curCol),a
	ld a,$58
	call _putmap
Enmymoveblank
	ld a,(enmyrMnSRT)
	ld (_curRow),a
	ld a,(enmycMnSRT)
	ld (_curCol),a
	ld a,$20
	call _putmap
	ret
PdieChck:
	ld a,(enmyrMn)
	ld b,a
	ld a,(pr)
	sub b
	cp 0
	jr z,Rowsamepchck
	cp -1
	jr z,Rowsamepchck
	cp 1
	jr z,Rowsamepchck
	jr PdieChckdone
Rowsamepchck
	ld a,(pdiecnt)
	inc a
	ld (pdiecnt),a
	ld a,(enmycMn)
	ld b,a
	ld a,(pc)
	sub b
	cp 0
	jr z,Colsamepchck
	cp -1
	jr z,Colsamepchck
	cp 1
	jr z,Colsamepchck
	jr PdieChckdone
Colsamepchck:
	ld a,(pdiecnt)
	inc a
	ld (pdiecnt),a
PdieChckdone:
	ld a,(pdiecnt)
	cp 2
	jp z,Playerdead
	ld a,0
	ld (pdiecnt),a
	ret
Playerdead:
	ld a,0
	ld (pdiecnt),a
Playerdeadstuff
	pop hl
	ld a,(plives)
	dec a
	ld (plives),a
	cp 0
	jp nz,Youdied
	jp Theend
Youdied:
	pop hl
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,udied
	call _puts
	ld a,1
	ld (savestat),a
Udiedeloop:
	call _getkey
	cp kEnter
	jr nz,Udiedeloop
	jp Levbgn
Theend
	pop hl
	call Scorechecks
	call $47e3
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,theend
	call _puts
	ld a,(testlevs)
	cp 0
	ret nz
Endeloop:
	call _getkey
	cp kEnter
	jr nz,Endeloop
	jp pleaz
noworlds:
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,noworld
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,1
	ld (_curRow),a
	ld hl,PTZWRLD+1
	call _puts
	jp Menugotomain
Uwin:
	call Scorechecks
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,wonmsg
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld hl,High
	call _puts
	ld a,16
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	ld a,0
	ld hl,(Highscrnum)
	call $4a33												; display ahl as a decimal
	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,Your
	call _puts
	ld a,16
	ld (_curCol),a
	ld a,5
	ld (_curRow),a
	ld a,0
	ld hl,(Lastscrnum)
	call $4a33												; display ahl as a decimal
	pop hl
	pop hl
	jp Menugotomain
Playershootmove:
	ld a,(bsDir)
	cp 0
	jp z,Playershootmove2h
	call Shootenmydiechk
	ld a,(bsDir)
	ld (shtDir),a
	ld a,(bsR)
	ld (shtR),a
	ld a,(bsC)
	ld (shtC),a
	call Shootmove
	ld a,(shtDir)
	ld (bsDir),a
	ld a,(shtC)
	ld (bsC),a
	ld a,(shtR)
	ld (bsR),a
	call Shootenmydiechk
Playershootmove2h:
	ld a,(psDir)
	cp 0
	ret z
	call Shootenmydiechk
	ld a,(psDir)
	ld (shtDir),a
	ld a,(psR)
	ld (shtR),a
	ld a,(psC)
	ld (shtC),a
	call Shootmove
	ld a,(shtDir)
	ld (psDir),a
	ld a,(shtC)
	ld (psC),a
	ld a,(shtR)
	ld (psR),a
	call Shootenmydiechk
	ret
Shootmove:
	ld a,(shtC)
	ld (shtClast),a
	ld a,(shtR)
	ld (shtRlast),a
	ld a,(shtDir)
	cp 1
	jr z,Shootup
	cp 2
	jr z,Shootdown
	cp 3
	jr z,Shootright
	cp 4
	jr z,Shootleft
Shootup
	ld a,(shtR)
	cp 1
	jp z,shootstop
	ld a,(shtR)
	cp 0
	jp z,shootstop
	dec a
	ld (shtR),a
	jr Shootcheck
Shootdown
	ld a,(shtR)
	cp 7
	jp z,shootstop
	ld a,(shtR)
	cp 8
	jp z,shootstop
	inc a
	ld (shtR),a
	jr Shootcheck
Shootleft
	ld a,(shtC)
	cp 0
	jp z,shootstop
	ld a,(shtC)
	cp -1
	jp z,shootstop
	dec a
	ld (shtC),a
	jr Shootcheck
Shootright
	ld a,(shtC)
	cp 20
	jp z,shootstop
	ld a,(shtC)
	cp 21
	jp z,shootstop
	inc a
	ld (shtC),a
	jr Shootcheck
Shootcheck
	ld a,(shtR)
	cp 1
	jr z,Shtrmcr1
	cp 2
	jr z,Shtrmcr2
	cp 3
	jr z,Shtrmcr3
	cp 4
	jr z,Shtrmcr4
	cp 5
	jr z,Shtrmcr5
	cp 6
	jr z,Shtrmcr6
	cp 7
	jr z,Shtrmcr7
Shtrmcr1:
	ld hl,ptz1
	jr Shtrmcre
Shtrmcr2:
	ld hl,ptz2
	jr Shtrmcre
Shtrmcr3:
	ld hl,ptz3
	jr Shtrmcre
Shtrmcr4:
	ld hl,ptz4
	jr Shtrmcre
Shtrmcr5:
	ld hl,ptz5
	jr Shtrmcre
Shtrmcr6:
	ld hl,ptz6
	jr Shtrmcre
Shtrmcr7:
	ld hl,ptz7
Shtrmcre:
	ld a,0
	ld d,a
	ld a,(shtC)
	ld e,a
	add hl,de
	ld a,(hl)
	cp 1
	jp z,shootstop
	cp 2
	jp z,shootstop
	cp 0
	jp z,shootstop
	jr Shootdraw
Shootdraw
	ld a,(shtR)
	ld (_curRow),a
	ld a,(shtC)
	ld (_curCol),a
	ld a,$14
	call _putmap
Shootdrawblank
	ld a,(shtRlast)
	ld (_curRow),a
	ld a,(shtClast)
	ld (_curCol),a
	ld a,$20
	call _putmap
	ret
Instructions
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,instrmsg
	call _puts
	ld hl,textfiledata
	ld de,$c068
	ld bc,13
	ldir
	ld hl,variable-1
	rst 20h
	rst 10h
	jr c,noHelp
	set 2,(iy+$1F)

	ld hl,variable-1
	rst 20h
	call $5730	;_exec_assembly
	jp The_start_of_game
noHelp
	ld a,1
	ld (_curRow),a
	ld (_curCol),a
	ld hl,nohelpviewer
	call _puts
	call _getkey
	jp The_start_of_game
ViewHighscore
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,hiscrmsg
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld hl,High
	call _puts
	ld a,16
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	ld a,0
	ld hl,(Highscrnum)
	call $4a33												; display ahl as a decimal
	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,Last
	call _puts
	ld a,16
	ld (_curCol),a
	ld a,5
	ld (_curRow),a
	ld a,0
	ld hl,(Lastscrnum)
	call $4a33												; display ahl as a decimal
	jp Menugotomain
Menugotomain
	ld a,(testlevs)
	cp 1
	ret z
	call _getkey
	cp kExit
	jp z,End
	cp kEnter
	jr nz,Menugotomain
	jp pleaz
Restartgame:
	call Scorechecks
	jp Restarted
Nosavegame
	call $47e3
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,noworld
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,1
	ld (_curRow),a
	ld hl,PTZSAVE+1
	call _puts
	jp Menugotomain
Loadgame:
	or a
	ld hl,PTZSAVE-1
	rst 20h
	rst 10h
	jp c,Nosavegame
	ld a,b
	ld h,d
	ld l,e
	call _inc_ptr_ahl
	call _inc_ptr_ahl
	call _SET_ABS_SRC_ADDR
	ld hl,PTZWRLD
	ld a,0
	call _SET_ABS_DEST_ADDR
	ld a,10
	ld l,a
	ld a,0
	ld h,a
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	ld a,0
	ld hl,savestat
	call _SET_ABS_DEST_ADDR
	ld a,0
	ld hl,225
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	call $47e3
	ld a,(savestat)
	cp 0
	jp z,Loadl
	cp 1
	jp z,Levbgn
	cp 2
	jp z,savegametype2
	jp Nosavegame
delptzsave
	call _delvar
	jr makeptzsave
savestat0
	ld hl,PTZSAVE-1
	rst 20h
	ld hl,16
	call $472f											; create string
	ld a,0
	ld hl,16
	call _SET_MM_NUM_BYTES
	jr makeptzsaveend
savestat1
	ld hl,PTZSAVE-1
	rst 20h
	ld hl,200
	call $472f											; create string
	ld a,0
	ld hl,200
	call _SET_MM_NUM_BYTES
	jr makeptzsaveend
savestat2
	ld hl,PTZSAVE-1
	rst 20h
	ld hl,225
	call $472f											; create string
	ld a,0
	ld hl,225
	call _SET_MM_NUM_BYTES
	jr makeptzsaveend
Savegame:
	or a
	ld hl,PTZSAVE-1
	rst 20h
	rst 10h
	jr nc,delptzsave
makeptzsave
	ld a,(savestat)
	cp 0
	jr z,savestat0
	cp 1
	jr z,savestat1
	jr savestat2
makeptzsaveend
	ld hl,PTZSAVE-1
	rst 20h
	rst 10h
	ld a,b
	ld h,d
	ld l,e
	call _inc_ptr_ahl
	call _inc_ptr_ahl
	call _SET_ABS_DEST_ADDR
	ld hl,savelev
	ld a,0
	call _SET_ABS_SRC_ADDR
	call _mm_ldir
	ld a,(savestat)
	cp 2
	jp nz,Levbgn
	call Scorechecks
	jp End
Delgames:
	call _clrLCD
	ld a,0
	ld (_curCol),a
	ld (_curRow),a
	ld hl,delgames
	call _puts
	ld a,2
	ld b,a
	ld a,1
	ld hl,Delalltxt
	call putflines
	ld a,4
	ld (Menuentries),a
	call Menustart
	ld a,(pr)
	cp 2
	jr z,delallsave
	cp 3
	jr z,DeleteWorld
	cp 4
	jr z,Uninstall
DeleteWorld
	call Selectlevs
	ld hl,PTZWRLD-1
	rst 20h
	rst 10h
	call _delvar
	call $47e3
	jp pleaz
Uninstall
	ld a,1
	ld (no_save),a
	call FindxLevs
	ld a,(xlevelsnum)
	ld (pr),a
	ld hl,xlevelstable-9
	ld (xtableloc),hl
uninstallwrldloop
	ld a,(pr)
	cp 0
	jr z,uninstallsave
	dec a
	ld (pr),a
	ld de,9
	ld hl,(xtableloc)
	add hl,de
	ld (xtableloc),hl
	dec hl
	rst 20h
	rst 10h
	call _delvar
	jr uninstallwrldloop
uninstallsave
	ld hl,PTZSAVE-1
	rst 20h
	rst 10h
	jr c,uninstallputz
	call _delvar
uninstallputz
	ld hl,PUTZ-1
	rst 20h
	rst 10h
	jp c,End
	call _delvar
	jp End
delallsave:
	ld hl,PTZSAVE-1
	rst 20h
	rst 10h
	jp c,pleaza
	call _delvar
	call $47e3
	jp pleaz
pleaza
	call $47e3
	jp pleaz
shootstop
	ld a,0
	ld (shtDir),a
	ld (shtC),a
	ld (shtR),a
	jp Shootdrawblank 
Pshootdraw
	call Shootenmydiechk
	ld a,(psR)
	ld (shtR),a
	ld a,(psC)
	ld (shtC),a
	ld a,(psDir)
	ld (shtDir),a
	call Shootmove
	ld a,(shtR)
	ld (psR),a
	ld a,(shtC)
	ld (psC),a
	ld a,(shtDir)
	ld (psDir),a
	call Shootenmydiechk
	jp Playerdraw
bossshootdraw
	call Shootenmydiechk
	ld a,(bsR)
	ld (shtR),a
	ld a,(bsC)
	ld (shtC),a
	ld a,(bsDir)
	ld (shtDir),a
	call Shootmove
	ld a,(shtR)
	ld (bsR),a
	ld a,(shtC)
	ld (bsC),a
	ld a,(shtDir)
	ld (bsDir),a
	call Shootenmydiechk
	ld a,(enmyrMn)
	ld (_curRow),a
	ld a,(enmycMn)
	ld (_curCol),a
	ld a,$58
	call _putmap
	ret
Scorechecks
	ld hl,(ppoints)
	ld (Lastscrnum),hl
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,(Highscrnum)
	ld a,h
	ld b,a
	ld a,d
	cp b
	jr nc,highscrhighergo
	ret
highscrhighergo
	ld a,l
	ld b,a
	ld a,e
	cp b
	jr nc,highscrhigher
	ret
highscrhigher:
	ld hl,(ppoints)
	ld (Highscrnum),hl
	ret
Shootenmydiechk
	ld a,(psDir)
	cp 0
	jr z,shootenemychk2
	ld a,(psDir)
	ld (shtDirc),a
	ld a,(psR)
	ld (shtRc),a
	ld a,(psC)
	ld (shtCc),a
	call shootenemycheck
	ld a,(shtDirc)
	ld (psDir),a
	ld a,(shtRc)
	ld (psR),a
	ld a,(shtCc)
	ld (psC),a
	ld a,(enmyrb)
	ld b,a
	ld a,(psR)
	cp b
	jp z,enmybchkf
shootenemychk2
	ld a,(bsDir)
	cp 0
	ret z
	ld a,(bsDir)
	ld (shtDirc),a
	ld a,(bsR)
	ld (shtRc),a
	ld a,(bsC)
	ld (shtCc),a
	call shootenemycheck
	ld a,(shtDirc)
	ld (bsDir),a
	ld a,(shtRc)
	ld (bsR),a
	ld a,(shtCc)
	ld (bsC),a
	ld a,(pr)
	ld b,a
	ld a,(bsR)
	cp b
	jp z,playerschkf
	ret
shootenemycheck
	ld a,(enmycnt)
	cp 0
	ret z
	cp 1
	jr z,enmy2chkend
	cp 2
	jr z,enmy3chkend
	cp 3
	jr z,enmy4chkend
	ld a,(enmyr4)
	ld b,a
	ld a,(shtRc)
	cp b
	jp z,enmy4chkf
enmy4chkend
	ld a,(enmyr3)
	ld b,a
	ld a,(shtRc)
	cp b
	jp z,enmy3chkf
enmy3chkend
	ld a,(enmyr2)
	ld b,a
	ld a,(shtRc)
	cp b
	jp z,enmy2chkf
enmy2chkend
	ld a,(enmyr1)
	ld b,a
	ld a,(shtRc)
	cp b
	jp z,enmy1chkf
	ret
enmy1chkf
	ld a,(enmyc1)
	ld b,a
	ld a,(shtCc)
	cp b
	ret nz
	ld a,0
	ld (shtRc),a
	ld (shtCc),a
	ld (shtDirc),a
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,10
	add hl,de
	ld (ppoints),hl
	ld a,(penmyk)
	inc a
	ld (penmyk),a
	ld a,1
	ld (enmydd1),a
	ld a,(enmyc1)
	ld (enmycMn),a
	ld (enmycMnSRT),a
	ld a,(enmyr1)
	ld (enmyrMn),a
	ld (enmyrMnSRT),a
	call EnmymoveDrw
	ld a,-2
	ld (enmyc1),a
	ld (enmyr1),a
	ld (enmycMn),a
	ld (enmyrMn),a
	ret
enmy2chkf
	ld a,(enmyc2)
	ld b,a
	ld a,(shtCc)
	cp b
	jp nz,enmy2chkend
	ld a,0
	ld (shtRc),a
	ld (shtCc),a
	ld (shtDirc),a
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,10
	add hl,de
	ld (ppoints),hl
	ld a,(penmyk)
	inc a
	ld (penmyk),a
	ld a,1
	ld (enmydd2),a
	ld a,(enmyc2)
	ld (enmycMn),a
	ld (enmycMnSRT),a
	ld a,(enmyr2)
	ld (enmyrMn),a
	ld (enmyrMnSRT),a
	call EnmymoveDrw
	ld a,-2
	ld (enmyc2),a
	ld (enmyr2),a
	ld (enmycMn),a
	ld (enmyrMn),a
	jp enmy2chkend
enmy3chkf
	ld a,(enmyc3)
	ld b,a
	ld a,(shtCc)
	cp b
	jp nz,enmy3chkend
	ld a,0
	ld (shtRc),a
	ld (shtCc),a
	ld (shtDirc),a
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,10
	add hl,de
	ld (ppoints),hl
	ld a,(penmyk)
	inc a
	ld (penmyk),a
	ld a,1
	ld (enmydd3),a
	ld a,(enmyc3)
	ld (enmycMn),a
	ld (enmycMnSRT),a
	ld a,(enmyr3)
	ld (enmyrMn),a
	ld (enmyrMnSRT),a
	call EnmymoveDrw
	ld a,-2
	ld (enmyc3),a
	ld (enmyr3),a
	ld (enmycMn),a
	ld (enmyrMn),a
	jp enmy3chkend
enmy4chkf
	ld a,(enmyc4)
	ld b,a
	ld a,(shtCc)
	cp b
	jp nz,enmy4chkend
	ld a,0
	ld (shtRc),a
	ld (shtCc),a
	ld (shtDirc),a
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,10
	add hl,de
	ld (ppoints),hl
	ld a,(penmyk)
	inc a
	ld (penmyk),a
	ld a,1
	ld (enmydd4),a
	ld a,(enmyc4)
	ld (enmycMn),a
	ld (enmycMnSRT),a
	ld a,(enmyr4)
	ld (enmyrMn),a
	ld (enmyrMnSRT),a
	call EnmymoveDrw
	ld a,-2
	ld (enmyc4),a
	ld (enmyr4),a
	ld (enmycMn),a
	ld (enmyrMn),a
	jp enmy4chkend
enmybchkf
	ld a,(enmycb)
	ld b,a
	ld a,(psC)
	cp b
	jp nz,shootenemychk2
	ld a,(enmyblives)
	dec a
	ld (enmyblives),a
	cp 0
	jp nz,shootenemychk2
	ld a,0
	ld (psR),a
	ld (psC),a
	ld (psDir),a
	ld hl,(ppoints)
	ld d,h
	ld e,l
	ld hl,15
	add hl,de
	ld (ppoints),hl
	ld a,(penmyk)
	inc a
	ld (penmyk),a
	ld a,1
	ld (enmyddb),a
	ld a,(enmycb)
	ld (enmycMn),a
	ld (enmycMnSRT),a
	ld a,(enmyrb)
	ld (enmyrMn),a
	ld (enmyrMnSRT),a
	call EnmymoveDrw
	ld a,-2
	ld (enmycb),a
	ld (enmyrb),a
	ld (enmycMn),a
	ld (enmyrMn),a
	jp shootenemychk2
playerschkf:
	ld a,(pc)
	ld b,a
	ld a,(bsC)
	cp b
	ret nz
	ld a,(bsR)
	ld (_curRow),a
	ld a,(bsC)
	ld (_curCol),a
	ld a,$14
	call _putmap
	ld a,0
	ld (bsDir),a
	ld a,-1
	ld (bsR),a
	ld (bsC),a
	ld a,(plives)
	cp 1
	jp Playerdeadstuff
Levmenub:
	call _clrLCD
	ld a,0
	ld (_curCol),a
	ld (_curRow),a
	ld hl,menutxt
	call _puts
	ld a,2
	ld b,a
	ld a,1
	ld hl,go
	call putflines
	ld a,6
	ld (Menuentries),a
	call Menustart
	ld a,(pr)
	ld (mr),a
	ld a,(rlst)
	ld (pr),a
	ld a,(clst)
	ld (pc),a
	ld a,(mr)
	cp 2
	jp z,Ptzl
	cp 3
	jp z,gotomain
	cp 4
	jp z,Savegame
	cp 5
	jp z,Loadgame
	cp 6
	jp z,Restartgame
gotomain:
	call Scorechecks
	jp pleaz
savegametype2
	ld a,1
	ld (loadstat),a
	jp Ptzl
Selectlevs
	call FindxLevs
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,Selectlev
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	ld hl,up_down
	call _puts
	ld a,3
	ld b,a
	ld a,16
	ld hl,exittoquit
	call putflines
	ld a,1
	ld (mr),a
	jr Selectlevdraw
selectlevloop
	call _getkey
	cp kEnter
	jp z,selectlevloopend
	cp kExit
	jp z,mEnd
	cp kUp
	jr z,Selectlevup
	cp kDown
	jr z,Selectlevdown
	jr selectlevloop
Selectlevup
	ld a,(mr)
	cp 1
	jr z,selectuploop
	dec a
	ld (mr),a
	jr Selectlevdraw
Selectlevdown
	ld a,(xlevelsnum)
	ld b,a
	ld a,(mr)
	cp b
	jr z,selectdownloop
	inc a
	ld (mr),a
	jr Selectlevdraw
selectuploop
	ld a,(xlevelsnum)
	ld (mr),a
	jr Selectlevdraw
selectdownloop
	ld a,1
	ld (mr),a
	jr Selectlevdraw
Selectlevdraw
	ld a,(mr)
	ld hl,xlevelstable-9
	ld de,9
Selectlevhlcalc
	add hl,de
	dec a
	cp 0
	jr nz,Selectlevhlcalc
	ld de,PTZWRLD
	ld bc,9
	ldir
	ld a,3
	ld (_curRow),a
	ld a,4
	ld (_curCol),a
	ld hl,PTZWRLD+1								; displays world name
	call _puts

	call getauthorname
	call $47e3
	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,spaces
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,5
	ld (_curRow),a
	ld hl,spaces
	call _puts
	ld a,32
	ld (_penRow),a
	ld a,0
	ld (_penCol),a
	ld hl,dispwname
	call _vputs
	ld a,39
	ld (_penRow),a
	ld a,0
	ld (_penCol),a
	ld hl,by
	call _vputs
	ld hl,dispname
	call _vputs
	jp selectlevloop
selectlevloopend								; loads selected world into savelev for saved games
    ld hl,PTZWRLD
    ld de,savelev
    ld bc,10
    ldir
	ret


FindxLevs
	call _clrScrn
	ld hl,_textShadow
	ld de,xlevelstable
	ld bc,162
	ldir
	call $47f3									; load RAM page 7
	ld a,$bf
	ld h,a
	ld a,$ff
	ld l,a
	ld (symlocate),hl
	ld a,0
	ld (xlevelsnum),a
Symsearch
	call $47f3									; load RAM page 7
	ld hl,(symlocate)
	ld a,(hl)
	cp $0c
	jr z,Stringfound
	ld de,($d29b)
	or a
	sbc hl,de
	jp c,Findlevsdone
Symsearchnot
	call $47f3									; load RAM page 7
	ld hl,(symlocate)
	ld de,5
	or a
	sbc hl,de
	ld a,0
	ld d,a
	ld a,(hl)
	inc a
	ld e,a
	or a
	sbc hl,de
	ld (symlocate),hl
	jr Symsearch
Stringfound
	ld hl,(symlocate)
	ld de,4
	or a
	sbc hl,de
	ld a,(hl)
	cp 0
	jr nz,Symsearchnot
	ld hl,(symlocate)
	dec hl
	ld a,(hl)
	ld e,a
	dec hl
	ld a,(hl)
	ld d,a
	dec hl
	ld a,(hl)
	ld b,a
	ld h,d
	ld l,e
	ld a,b
checkstring
	call $4637												; ahl+1
	call $4637												; ahl+1
	ld (leva),a
	ld (levhl),hl
	ld a,0
	ld (checkbytenum),a
checkstringloop
	ld a,(leva)
	ld hl,(levhl)
	call $46c3												; a,(ahl)
	ld b,a
	ld hl,checkbytes
	ld a,(checkbytenum)
	ld e,a
	ld a,0
	ld d,a
	or a
	add hl,de
	ld a,(hl)
	cp b
	jr nz,Symsearchnot
	ld a,(hl)
	cp 0
	jr z,versioncheck
	ld a,(leva)
	ld hl,(levhl)
	call $4637
	ld (leva),a
	ld (levhl),hl
	ld a,(checkbytenum)
	inc a
	ld (checkbytenum),a
	jr checkstringloop
versioncheck
	ld a,(leva)
	ld hl,(levhl)
	call $4637
	call $46c3												; a,(ahl)
	ld b,a
	ld a,(vercheck)
	cp b
	jp nz,Symsearchnot
itsPtzlev
	call $47f3
	ld a,(xlevelsnum)
	cp 16
	jr z,Findlevsdone
	inc a
	ld (xlevelsnum),a
	ld hl,xlevelstable-9
	ld de,9
itsPtzlev1									;world found, next few lines write name to table
	add hl,de
	dec a
	cp 0
	jr nz,itsPtzlev1
	ld (xtableloc),hl
	ld hl,(symlocate)
	ld de,5
	or a
	sbc hl,de
	ld (symlocate),hl
	ld a,(hl)
	ld hl,(xtableloc)
	ld (hl),a
	ld (chrleft),a
itsPtzlevloop
	ld a,(chrleft)
	cp 0
	jr z,itsPtzlevloopend
	ld hl,(symlocate)
	dec hl
	ld (symlocate),hl
	ld a,(hl)
	ld hl,(xtableloc)
	inc hl
	ld (hl),a
	ld (xtableloc),hl
	ld a,(chrleft)
	dec a
	ld (chrleft),a
	jr itsPtzlevloop
itsPtzlevloopend
	ld hl,(symlocate)
	dec hl
	ld (symlocate),hl
	jp Symsearch
Findlevsdone
	call $47e3
	ld a,(no_save)
	cp 1									; game being deleted
	ret z
	ld a,(xlevelsnum)
	cp 0									; checks if worlds were found
	jp z,not_a_lev_fnd
	ret

not_a_lev_fnd								; no worlds found on calculator
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,nolevsfnd
	call _puts
	pop hl
	pop hl
	jp Menugotomain

; puts multiple lines of strings using fixed width font, and all start at the same col.
; inputs: a=col, b=row, hl=start of strings, last string must end in 0,0 example: .db "Hi!",0,0
; MUST be called
putflines
	ld (_curCol),a
	ld (pcol),a
	ld a,b
	ld (_curRow),a
	ld (prow),a
putflinesloop
	call _puts
	ld a,(pcol)
	ld b,a
	ld a,(_curCol)
	cp b
	ret z
	ld (_curCol),a
	ld a,(prow)
	inc a
	ld (prow),a
	ld (_curRow),a
	ld a,(pcol)
	ld (_curCol),a
	jr putflinesloop


getauthorname
getworldname
	ld b,21
	ld hl,dispwname
	ld a,$20
spaceinworldnameloop
	ld (hl),a
	inc hl
	djnz spaceinworldnameloop
	ld a,0
	ld (hl),a
	ld b,21
	ld hl,dispname
	ld a,$20
spaceinauthornameloop
	ld (hl),a
	inc hl
	djnz spaceinauthornameloop
	ld a,0
	ld (hl),a
	ld hl,PTZWRLD-1
	rst 20h
	rst 10h
	ld h,0
	ld l,13
	add hl,de
	ld a,b
	push af
	push hl
	call $46c3
	cp 0
	jr z,dispworldnamestartbegn
	inc a
	ld (place10),a
	ld a,1
	ld (place1),a
dispauthornameloop
	pop hl
	pop af
	inc hl
	push af
	push hl
	call $46c3
	push af
	ld hl,dispwname
	ld a,(place1)
	ld e,a
	dec e
	ld d,0
	add hl,de
	pop af
	ld (hl),a
	ld  a,(place1)
	inc a
	ld (place1),a
	ld b,a
	ld a,(place10)
	cp b
	jr nz,dispauthornameloop
	pop hl
	pop af
	inc hl
	push af
	push hl
dispworldnamestart
	call $46c3
	cp 0
	jp z,dispworldnameend
	inc a
	ld (place10),a
	ld a,1
	ld (place1),a
dispworldnameloop
	pop hl
	pop af
	inc hl
	push af
	push hl
	call $46c3
	push af
	ld hl,dispname
	ld a,(place1)
	ld e,a
	dec e
	ld d,0
	add hl,de
	pop af
	ld (hl),a
	ld  a,(place1)
	inc a
	ld (place1),a
	ld b,a
	ld a,(place10)
	cp b
	jr nz,dispworldnameloop
dispworldnameend
	pop hl
	pop af
	ret
dispworldnamestartbegn
	pop hl
	inc hl
	push hl
	jr dispworldnamestart





nohelpviewer
.db "Need file: HelpView",0
variable
.db 8,"HelpView"

textfiledata
.db 7
.db 1
.db 20
.db 0
textvariable
.db 8,"PutzHelp"
PTZTemp .db 8,"Tempfile",0
noworld: .db "Can't find file:",0
spaces .db "               ",0
Selectlev: .db "Select Level",0
PUTZ: .db 4,"Putz",0						;used when re-writing program
PTZSAVE: .db 8,"Ptz_Save",0					;saved game
exittoquit: .db "Press",0
exittoquit1: .db "exit",0
exittoquit2: .db "to",0
exittoquit3: .db "quit",0,0
nolevsfnd .db "No levels found",0
menutxt: .db "Menu",0
ver: .db "V  0.91",0
up_down: .db 6,"/",7,0
press: .db "Press Enter!!",0
please: .db "Please choose one...",0
by: .db "By ",0
auther: .db "John Kempen",0
Name .db "Putz! v0.91 by John Kempen",0
High: .db "High Score:",0
Your: .db "Your Score:",0
Last: .db "Last Score:",0
udied: .db "You died ",0
theend: .db "Game Over ",0
Enterl: .db "Enter Level:",0
goalst: .db "Goals:",0
enemykt: .db "Enemy kill goal:",0
pointsgt: .db "Points goal:",0
newmsg: .db "New game",0
loadmsg: .db "Load game",0
hiscrmsg: .db "Scores",0
instrmsg: .db "Instructions",0
delgames: .db "Del. stuff",0,0
Delalltxt: .db "Delete saved",0
deleteworldmsg .db "Delete World",0
Uninstallallmsg .db "Uninstall all",0,0
go: .db "Go!",0
mainmenu: .db "Main",0
savegames: .db "Save game",0
loadmsg1: .db "Load game",0
restartgames: .db "Restart game",0,0
wonmsg: .db "You beat the game!",0
title_pic:
      .db %00001111,%11100000,%11000001,%10000111,%11111111,%10000111,%11111111,%11000000,%01100000,0,0,0,0
.db 0,0,0,%00001111,%11110000,%11000001,%10000111,%11111111,%10000111,%11111111,%10000000,%01100000,0,0,0,0
.db 0,0,0,%00001100,%00110000,%11000001,%10000000,%00110000,%00000000,%000000111,%0000000,%01100000,0,0,0,0
.db 0,0,0,%00001100,%00010000,%11000001,%10000000,%00110000,%00000000,%00001110,%00000000,%01100000,0,0,0,0
.db 0,0,0,%00001100,%00110000,%11000001,%10000000,%00110000,%00000000,%00011100,%00000000,%01100000,0,0,0,0
.db 0,0,0,%00001111,%11110000,%11000001,%10000000,%00110000,%00000000,%00111000,%00000000,%01100000,0,0,0,0
.db 0,0,0,%00001111,%11100000,%11000001,%10000000,%00110000,%00000000,%01110000,%00000000,%01100000,0,0,0,0
.db 0,0,0,%00001100,%00000000,%11000001,%10000000,%00110000,%00000000,%11100000,%00000000,%00000000,0,0,0,0
.db 0,0,0,%00001100,%00000000,%11100011,%10000000,%00110000,%00000001,%11000000,%00000000,%00000000,0,0,0,0
.db 0,0,0,%00001100,%00000000,%01111111,%00000000,%00110000,%00000011,%11111111,%11000000,%01100000,0,0,0,0
.db 0,0,0,%00001100,%00000000,%00111110,%00000000,%00110000,%00000111,%11111111,%11000000,%01100000
title_pic2
.db %00000001,255,255,255,255,255,255,255,255,255,0,0,0,0
.db 0,0,%00000011,255,255,255,255,255,255,255,255,255,%10000000,0,0,0
.db 0,0,%00000001,255,255,255,255,255,255,255,255,255
box1:
.db %00000111,255,255,255,255,255,%11111110
box2:
.db %00000100,0,0,0,0,0,%00000010
bar:
.db %00111111,255,255,%10000000
displaytable
.db "O",0,"",0,"",0," ",0,"*",0,"X",0,"X",0,"*",0," ",0," ",0,"X",0,"X",0
checkbytes: .db "Ptz",0						;bytes at the begining of worlds, 0 ends checking
vercheck: .db 1								;version of string, used if I make changes to string
the_end
.db 0,0,0,0,0,0,0,0,0
newlevbytes
.db 0,0,0,0,0,0,0,0
spacecode
.db 9


.end


