;In Oxidation States.
;First byte holds number of states in lower nibble and first oxidation state
;in upper nibble.  Second byte (if any) holds two oxidation states, as does
;the third, fourth, etc.  In each ox state nibble, the lower 3 bits hold the
;number while the upper bit holds the sign(1=+, 0=-).  Sytax:
;.db %(+/- of 1st ox;1st ox)(# of ox states),%(3rd ox)(2nd ox),%(5th ox)(...
;Example:
;.db %1 011 0100,%1 110 1 100,%0000 1 111
;     +   3    4  +   6 +   4  ---- +   7
;
;4 oxidation states: +3, +4, +6, and +7

;bit 7,6:	Number of words/bytes
;bit 5:		0=Compressed data; 1=string
;bit 4:		0=First datum's a word; 1=first datum's a byte
;bit 3-0:	Number of decimal places if compressed data; length of
;			string if string

EL1:
.db "H",0	;Symbol
.db "Hydrogen",0;Name
.db %10010101 \ .db 94\.dw 1007	;Atomic Mass;1.00794
.db %01000011 \ .dw 14025	;Melting Point;14.025
.db %01000011 \ .dw 20268	;Boiling Point;20.268
.db %01000000 \ .dw 1312	;First Ionization Energy;1312
.db %00010010,%00001001;-1,+1

EL2:
.db "He",0
.db "Helium",0
.db %10000110\ .dw 602\ .dw 4002	;4.002602
.db %01010010\ .db 95 	;.95
.db %01000011\ .dw 4215	;4.215
.db %01000000\ .dw 2372	;2372
.db 0	;none

EL3:
.db "Li",0
.db "Lithium",0
.db %01000011\ .dw 6941	;6.941
.db %01000001\ .dw 4537	;453.7
.db %01000000\ .dw 1615	;1615
.db %01000001\ .dw 5202	;520.2
.db %10010001	;1+

EL4:
.db "Be",0
.db "Beryllium",0
.db %10010110\ .db 182\ .dw 9012	;9.012182
.db %01000000\ .dw 1560	;1560
.db %01000000\ .dw 2745	;2745
.db %01000001\ .dw 8995	;899.5
.db %10100001	;2+

EL5:
.db "B",0
.db "Boron",0
.db %01000011\ .dw 10811	;10.811
.db %01000000\ .dw 2300	;2300
.db %01000000\ .dw 4275	;4275
.db %01000001\ .dw 8006	;800.6
.db %10110001	;3+

EL6:
.db "C",0
.db "Carbon",0
.db %01000011\ .dw 12011	;12.011
.db %01000000\ .dw 4100	;4100
.db %01000000\ .dw 4470	;4470
.db %01000001\ .dw 10865	;1086.5
.db %01000011,%11001010	;4-,2+,4+

EL7:
.db "N",0
.db "Nitrogen",0
.db %10010101\ .db 74\ .dw 14006	;14.00674
.db %01000010\ .dw 6314	;63.14
.db %01000010\ .dw 7735	;77.35
.db %01000000\ .dw 1402	;1402
.db %00111000,%00010010,%10101001,%11001011,%00001101
				;3-,2-,1-,1+,2+,3+,4+,5+

EL8:
.db "O",0
.db "Oxygen",0
.db %10010100\ .db 4\ .dw 15999	;15.9994
.db %01000010\ .dw 5035	;50.35
.db %01000010\ .dw 9018	;90.18
.db %01000001\ .dw 13139	;1313.9
.db %00100010,%00000001	;2-,1-

EL9:
.db "F",0
.db "Fluorine",0
.db %10000111\ .dw 4032\ .dw 18998	;18.9984032
.db %01000010\ .dw 5348	;53.48
.db %01000010\ .dw 8495	;84.95
.db %01000010\ .dw 1681	;1681
.db %00010001	;1-

EL10:
.db "Ne",0
.db "Neon",0
.db %10010100\ .db 7\ .dw 20179	;20.1797
.db %01000011\ .dw 24553	;24.553
.db %01000011\ .dw 27096	;27.096
.db %01000000\ .dw 2081	;2081
.db 0	;none

EL11:
.db "Na",0
.db "Sodium",0
.db %10000110\ .dw 768\ .dw 22989	;22.989768
.db %01000001\ .dw 3710	;371.0
.db %01000000\ .dw 1156	;1156
.db %01000001\ .dw 4959	;495.9
.db %10010001	;1+

EL12:
.db "Mg",0
.db "Magnesium",0
.db %01000011\ .dw 24305	;24.305
.db %01000000\ .dw 922	;922
.db %01000000\ .dw 1363	;1363
.db %01000001\ .dw 7378	;737.8
.db %10100001	;2+

EL13:
.db "Al",0
.db "Aluminum",0
.db %10000110\ .dw 539\ .dw 26981	;26.981539
.db %10010110\ .db 5\ .dw 9332	;933.25
.db %01000000\ .dw 2793	;2793
.db %01000001\ .dw 5775	;577.5
.db %10110001	;3+

EL14:
.db "Si",0
.db "Silicon",0
.db %10010100\ .db 5\ .dw 28085	;28.0855
.db %01000000\ .dw 1685	;1685
.db %01000000\ .dw 3540	;3540
.db %01000001\ .dw 7865	;786.5
.db %10100010,%00001100	;2+,4+

EL15:
.db "P",0
.db "Phosphorus",0
.db %10000110\ .dw 762\ .dw 30973	;30.973762
.db %01000010\ .dw 31730	;317.30
.db %01000000\ .dw 550	;550
.db %01000000\ .dw 1012	;1012
.db %00110011,%11011011	;3-,3+,5+

EL16:
.db "S",0
.db "Sulfur",0
.db %01000011\ .dw 32066	;32.066
.db %01000010\ .dw 38836	;388.36
.db %10010010\ .db 5\ .dw 7177	;717.75
.db %01000001\ .dw 9996	;999.6
.db %00100011,%11101100	;2-,4+,6+

EL17:
.db "Cl",0
.db "Chlorine",0
.db %10010100\ .db 7\ .dw 35452	;35.4527
.db %01000010\ .dw 17216	;172.16
.db %01000001\ .dw 2391	;239.1
.db %01000001\ .dw 12555	;1255.5
.db %00010100,%10111001,%00001101	;1-,1+,3+,5+

EL18:
.db "Ar",0
.db "Argon",0
.db %01000011\ .dw 39948	;39.948
.db %01000010\ .dw 8381	;83.81
.db %01000010\ .dw 8730	;87.30
.db %01000000\ .dw 1521	;1521
.db 0	;none

EL19:
.db "K",0
.db "Potassium",0
.db %10010100\ .db 3\ .dw 39098	;39.0983
.db %01000010\ .dw 33635	;336.35
.db %01000000\ .dw 1032	;1032
.db %01000001\ .dw 4188	;418.8
.db %10010001	;1+

EL20:
.db "Ca",0
.db "Calcium",0
.db %01000011\ .dw 40078	;40.078
.db %01000000\ .dw 1112	;1112
.db %01000000\ .dw 1757	;1757
.db %01000001\ .dw 5898	;589.8
.db %10100001	;2+

EL21:
.db "Sc",0
.db "Scandium",0
.db %10010101\ .db 91\ .dw 44955	;44.95591
.db %01000000\ .dw 1812	;1812
.db %01000000\ .dw 3104	;3104
.db %01000000\ .dw 631	;631
.db %10110001	;3+

EL22:
.db "Ti",0
.db "Titanium",0
.db %01000010\ .dw 4788	;47.88
.db %01000000\ .dw 1943	;1943
.db %01000000\ .dw 3562	;3562
.db %01000001\ .dw 6581	;658.1
.db %10100011,%11001011	;2+,3+,4+

EL23:
.db "V",0
.db "Vanadium",0
.db %10010100\ .db 5\ .dw 50941	;50.9415
.db %01000000\ .dw 2175	;2175
.db %01000000\ .dw 3682	;3682
.db %01000001\ .dw 6503	;650.3
.db %10100100,%11001011,%00001101	;2+,3+,4+,5+

EL24:
.db "Cr",0
.db "Chromium",0
.db %10010100\ .db 1\ .dw 51996	;51.9961
.db %01000000\ .dw 2130	;2130
.db %01000000\ .dw 2945	;2945
.db %01000001\ .dw 6528	;652.8
.db %10100011,%11101011	;2+,3+,6+

EL25:
.db "Mn",0
.db "Manganese",0
.db %10000101\ .dw 805\ .dw 5493	;54.93805
.db %01000000\ .dw 1517	;1517
.db %01000000\ .dw 2335	;2335
.db %01000001\ .dw 7175	;717.5
.db %10100101,%11001011,%11111110	;2+,3+,4+,6+,7+

EL26:
.db "Fe",0
.db "Iron",0
.db %01000011\ .dw 55847	;55.847
.db %01000000\ .dw 1809	;1809
.db %01000000\ .dw 3135	;3135
.db %01000001\ .dw 7594	;759.4
.db %10100010,%00001011	;2+,3+

EL27:
.db "Co",0
.db "Cobalt",0
.db %10010100\ .db 2\ .dw 58933	;58.9332
.db %01000000\ .dw 1768	;1768
.db %01000000\ .dw 3201	;3201
.db %01000001\ .dw 7588	;758.8
.db %10100010,%00001011	;2+,3+

EL28:
.db "Ni",0
.db "Nickel",0
.db %10010100\ .db 4\ .dw 58693	;58.6934
.db %01000000\ .dw 1726	;1726
.db %01000000\ .dw 3187	;3187
.db %01000001\ .dw 7367	;736.7
.db %10100011,%11001011	;2+,3+,4+

EL29:
.db "Cu",0
.db "Copper",0
.db %01000011\ .dw 63546	;63.546
.db %01000001\ .dw 13576	;1357.6
.db %01000000\ .dw 2836	;2836
.db %01000001\ .dw 7455	;745.5
.db %10010010,%00001010	;1+,2+

EL30:
.db "Zn",0
.db "Zinc",0
.db %01000010\ .dw 6539	;65.39
.db %10010010\ .db 3\ .dw 6927	;692.73
.db %01000000\ .dw 1180	;1180
.db %01000001\ .dw 9064	;906.4
.db %10100001	;2+

EL31:
.db "Ga",0
.db "Gallium",0
.db %10010011\ .db 3\ .dw 6972	;69.723
.db %01000010\ .dw 30290	;302.90
.db %01000000\ .dw 2478	;2478
.db %01000001\ .dw 5788	;578.8
.db %10010010,%00001011	;1+,3+

EL32:
.db "Ge",0
.db "Germanium",0
.db %01000010\ .dw 7261	;72.61
.db %01000001\ .dw 12104	;1210.4
.db %01000000\ .dw 3107	;3107
.db %01000001\ .dw 7612	;761.2
.db %10100010,%00001100	;2+4+

EL33:
.db "As",0
.db "Arsenic",0
.db %10010101\ .db 159\ .dw 7492	;74.92159
.db %01000000\ .dw 1081	;1081
.db %01000000\ .dw 876	;876
.db %01000000\ .dw 947	;947
.db %10110010,%00001101	;3+,5+

EL34:
.db "Se",0
.db "Selenium",0
.db %01000010\ .dw 7896	;78.96
.db %01000000\ .dw 494	;494
.db %01000000\ .dw 958	;958
.db %01000001\ .dw 9407	;940.7
.db %00100100,%11001010,%00001110	;2-,2+,4+,6+

EL35:
.db "Br",0
.db "Bromine",0
.db %10010011\ .db 4\ .dw 7990	;79.904
.db %01000010\ .dw 26590	;265.90
.db %01000010\ .dw 33235	;332.35
.db %01000001\ .dw 11399	;1139.9
.db %00010100,%10111001,%00001101	;1-,1+,3+,5+

EL36:
.db "Kr",0
.db "Krypton",0
.db %01000001\ .dw 838	;83.8
.db %01000010\ .dw 11578	;115.78
.db %01000010\ .dw 11980	;119.80
.db %01000000\ .dw 1351	;1351
.db 0	;none

EL37:
.db "Rb",0
.db "Rubidium",0
.db %10010100\ .db 78\ .dw 8546	;85.4678
.db %01000010\ .dw 31264	;312.64
.db %01000000\ .dw 961	;961
.db %01000000\ .dw 403	;403
.db %10010001	;1+

EL38:
.db "Sr",0
.db "Strontium",0
.db %01000010\ .dw 8762	;87.62
.db %01000000\ .dw 1041	;1041
.db %01000000\ .dw 1650	;1650
.db %01000001\ .dw 5495	;549.5
.db %10100001	;2+

EL39:
.db "Y",0
.db "Yttrium",0
.db %10000101\ .dw 585\ .dw 8890	;88.90585
.db %01000000\ .dw 1799	;1799
.db %01000000\ .dw 3611	;3611
.db %01000000\ .dw 616	;616
.db %10110001	;3+

EL40:
.db "Zr",0
.db "Zirconium",0
.db %10010011\ .db 4\ .dw 9122	;91.224
.db %01000000\ .dw 2125	;2125
.db %01000000\ .dw 4682	;4682
.db %01000001\ .dw 6597	;659.7
.db %11000001	;4+

EL41:
.db "Nb",0
.db "Niobium",0
.db %10000101\ .dw 638\ .dw 9290	;92.90638
.db %01000000\ .dw 2740	;2740
.db %01000000\ .dw 5017	;5017
.db %01000001\ .dw 6641	;664.1
.db %11000010,%00001101	;4+,5+

EL42:
.db "Mo",0
.db "Molybdenum",0
.db %01000010\ .dw 9594	;95.94
.db %01000000\ .dw 2890	;2890
.db %01000000\ .dw 4912	;4912
.db %01000000\ .dw 685	;685
.db %11000011,%11101101	;4+,5+,6+

EL43:
.db "Tc",0
.db "Technetium",0
.db %10010100\ .db 72\ .dw 9790	;97.9072
.db %01000000\ .dw 2473	;2473
.db %01000000\ .dw 4538	;4538
.db %01000000\ .dw 702	;702
.db %10100100,%11101100,%00001111	;2+,4+,6+,7+

EL44:
.db "Ru",0
.db "Ruthenium",0
.db %01000010\ .dw 10107	;101.07
.db %01000000\ .dw 2523	;2523
.db %01000000\ .dw 4423	;4423
.db %01000000\ .dw 711	;711
.db %10100100,%11001011,%00001101	;2+,3+,4+,5+

EL45:
.db "Rh",0
.db "Rhodium",0
.db %10010100\ .db 55\ .dw 10290	;102.9055
.db %01000000\ .dw 2236	;2236
.db %01000000\ .dw 3970	;3970
.db %01000000\ .dw 720	;720
.db %10110011,%11011100	;3+,4+,5+

EL46:
.db "Pd",0
.db "Palladium",0
.db %01000010\ .dw 10642	;106.42
.db %01000000\ .dw 1825	;1825
.db %01000000\ .dw 3237	;3237
.db %01000000\ .dw 805	;805
.db %10100010,%00001100	;2+,4+

EL47:
.db "Ag",0
.db "Silver",0
.db %10010100\ .db 82\ .dw 10786	;107.8682
.db %01000000\ .dw 1234	;1234
.db %01000000\ .dw 2436	;2436
.db %01000001\ .dw 7308	;730.8
.db %10010001	;1+

EL48:
.db "Cd",0
.db "Cadmium",0
.db %10010011\ .db 1\ .dw 11241	;112.411
.db %01000010\ .dw 59418	;594.18
.db %01000000\ .dw 1040	;1040
.db %01000001\ .dw 8677	;867.7
.db %10100001	;2+

EL49:
.db "In",0
.db "Indium",0
.db %01000010\ .dw 11482	;114.82
.db %01000010\ .dw 42976	;429.76
.db %01000000\ .dw 2346	;2346
.db %01000001\ .dw 5582	;558.2
.db %10010010,%00001011	;1+,3+

EL50:
.db "Sn",0
.db "Tin",0
.db %01000010\ .dw 11871	;118.71
.db %01000010\ .dw 50506	;505.06
.db %01000000\ .dw 2876	;2876
.db %01000001\ .dw 7084	;708.4
.db %10100010,%00001100	;2+,4+

EL51:
.db "Sb",0
.db "Antimony",0
.db %10010011\ .db 7\ .dw 12175	;121.757
.db %01000000\ .dw 904	;904
.db %01000000\ .dw 1860	;1860
.db %01000000\ .dw 834	;834
.db %10110010,%00001101	;3+,5+

EL52:
.db "Te",0
.db "Tellurium",0
.db %01000001\ .dw 1276	;127.6
.db %10010010\ .db 5\ .dw 7226	;722.65
.db %01000000\ .dw 1261	;1261
.db %01000000\ .dw 869	;869
.db %00100100,%11001010,%00001110	;2-,2+,4+,6+

EL53:
.db "I",0
.db "Iodine",0
.db %10000101\ .dw 447\ .dw 12690	;126.90447
.db %01000001\ .dw 3867	;386.7
.db %01000001\ .dw 4584	;458.4
.db %01000001\ .dw 10084	;1008.4
.db %00010100,%11011001,%00001111	;1-,1+,5+,7+

EL54:
.db "Xe",0
.db "Xenon",0
.db %01000010\ .dw 13129	;131.29
.db %01000010\ .dw 16136	;161.36
.db %01000010\ .dw 16503	;165.03
.db %01000000\ .dw 1170	;1170
.db 0	;none

EL55:
.db "Cs",0
.db "Cesium",0
.db %10000101\ .dw 543\ .dw 13290	;132.90543
.db %01000010\ .dw 30155	;301.55
.db %01000000\ .dw 944	;944
.db %01000001\ .dw 3757	;375.7
.db %10010001	;1+

EL56:
.db "Ba",0
.db "Barium",0
.db %10010011\ .db 7\ .dw 13732	;137.327
.db %01000000\ .dw 1002	;1002
.db %01000000\ .dw 2171	;2171
.db %01000001\ .dw 5029	;502.9
.db %10100001	;2+

EL57:
.db "La",0
.db "Lanthanum",0
.db %10010100\ .db 55\ .dw 13890	;138.9055
.db %01000000\ .dw 1193	;1193
.db %01000000\ .dw 3730	;3730
.db %01000000\ .dw 538	;538
.db %10110001	;3+

EL58:
.db "Ce",0
.db "Cerium",0
.db %10010011\ .db 5\ .dw 14011	;140.115
.db %01000000\ .dw 1071	;1071
.db %01000000\ .dw 3699	;3699
.db %01000000\ .dw 541	;541
.db %10110010,%00001100	;3+,4+

EL59:
.db "Pr",0
.db "Praseodymium",0
.db %10000101\ .dw 765\ .dw 14090	;140.90765
.db %01000000\ .dw 1204	;1204
.db %01000000\ .dw 3785	;3785
.db %01000000\ .dw 522	;522
.db %10110010,%00001100	;3+,4+

EL60:
.db "Nd",0
.db "Neodymium",0
.db %01000010\ .dw 14424	;144.24
.db %01000000\ .dw 1289	;1289
.db %01000000\ .dw 3341	;3341
.db %01000000\ .dw 530	;530
.db %10100010,%00001011	;2+,3+

EL61:
.db "Pm",0
.db "Promethium",0
.db %10010100\ .db 28\ .dw 14491	;144.9128
.db %01000000\ .dw 1204	;1204
.db %01000000\ .dw 3785	;3785
.db %01000000\ .dw 536	;536
.db %10110001	;3+

EL62:
.db "Sm",0
.db "Samarium",0
.db %01000010\ .dw 15036	;150.36
.db %01000000\ .dw 1345	;1345
.db %01000000\ .dw 2064	;2064
.db %01000000\ .dw 542	;542
.db %10100010,%00001011	;2+,3+

EL63:
.db "Eu",0
.db "Europium",0
.db %10010011\ .db 5\ .dw 15196	;151.965
.db %01000000\ .dw 1090	;1090
.db %01000000\ .dw 1870	;1870
.db %01000000\ .dw 547	;547
.db %10100010,%00001011	;2+,3+

EL64:
.db "Gd",0
.db "Gadolinium",0
.db %01000010\ .dw 15725	;157.25
.db %01000000\ .dw 1585	;1585
.db %01000000\ .dw 3539	;3539
.db %01000000\ .dw 592	;592
.db %10110001	;3+

EL65:
.db "Tb",0
.db "Terbium",0
.db %10000101\ .dw 534\ .dw 15892	;158.92534
.db %01000000\ .dw 1630	;1630
.db %01000000\ .dw 3496	;3496
.db %01000000\ .dw 564	;564
.db %10110010,%00001100	;3+,4+

EL66:
.db "Dy",0
.db "Dysprosium",0
.db %01000001\ .dw 1625	;162.5
.db %01000000\ .dw 1682	;1682
.db %01000000\ .dw 2835	;2835
.db %01000000\ .dw 572	;572
.db %10100010,%00001011	;2+,3+

EL67:
.db "Ho",0
.db "Holmium",0
.db %10010100\ .db 32\ .dw 16490	;164.9032
.db %01000000\ .dw 1743	;1743
.db %01000000\ .dw 2968	;2968
.db %01000000\ .dw 581	;581
.db %10110001	;3+

EL68:
.db "Er",0
.db "Erbium",0
.db %01000010\ .dw 16726	;167.26
.db %01000000\ .dw 1795	;1795
.db %01000000\ .dw 3136	;3136
.db %01000000\ .dw 589	;589
.db %10110001	;3+

EL69:
.db "Tm",0
.db "Thulium",0
.db %10000101\ .dw 421\ .dw 16893	;168.93421
.db %01000000\ .dw 1818	;1818
.db %01000000\ .dw 2220	;2220
.db %01000000\ .dw 596	;596
.db 0	;none

EL70:
.db "Yb",0
.db "Ytterbium",0
.db %01000010\ .dw 17304	;173.04
.db %01000000\ .dw 1097	;1097
.db %01000000\ .dw 1467	;1467
.db %01000000\ .dw 603	;603
.db %10100010,%00001011	;2+,3+

EL71:
.db "Lu",0
.db "Lutetium",0
.db %10010011\ .db 7\ .dw 17496	;174.967
.db %01000000\ .dw 1936	;1936
.db %01000000\ .dw 3666	;3666
.db %01000000\ .dw 524	;524
.db %10110001	;3+

EL72:
.db "Hf",0
.db "Hafnium",0
.db %01000010\ .dw 17849	;178.49
.db %01000000\ .dw 2500	;2500
.db %01000000\ .dw 4876	;4876
.db %01000001\ .dw 6544	;654.4
.db %11000001	;4+

EL73:
.db "Ta",0
.db "Tantalum",0
.db %10010100\ .db 79\ .dw 18094	;180.9479
.db %01000000\ .dw 3287	;3287
.db %01000000\ .dw 5731	;5731
.db %01000001\ .dw 7608	;760.8
.db %11000010,%00001101	;4+,5+

EL74:
.db "W",0
.db "Tungsten",0
.db %01000010\ .dw 18385	;183.85
.db %01000000\ .dw 3680	;3680
.db %01000000\ .dw 5828	;5828
.db %01000001\ .dw 7704	;770.4
.db %11000011,%11101101	;4+,5+,6+

EL75:
.db "Re",0
.db "Rhenium",0
.db %10010011\ .db 7\ .dw 18620	;186.207
.db %01000000\ .dw 3453	;3453
.db %01000000\ .dw 5869	;5869
.db %01000000\ .dw 760	;760
.db %10110100,%11101100,%00001111	;3+,4+,6+,7+

EL76:
.db "Os",0
.db "Osmium",0
.db %01000001\ .dw 1902	;190.2
.db %01000000\ .dw 3300	;3300
.db %01000000\ .dw 5285	;5285
.db %01000000\ .dw 840	;840
.db %11000011,%10001110	;4+,6+,8+

EL77:
.db "Ir",0
.db "Iridium",0
.db %01000010\ .dw 19222	;192.22
.db %01000000\ .dw 2716	;2716
.db %01000000\ .dw 4701	;4701
.db %01000000\ .dw 880	;880
.db %10110011,%11011100	;3+,4+,5+

EL78:
.db "Pt",0
.db "Platinum",0
.db %01000010\ .dw 19508	;195.08
.db %01000000\ .dw 2045	;2045
.db %01000000\ .dw 4100	;4100
.db %01000000\ .dw 868	;868
.db %10100010,%00001100	;2+,4+

EL79:
.db "Au",0
.db "Gold",0
.db %10000101\ .dw 654\ .dw 19696	;196.96654
.db %10010110\ .db 8\ .dw 13375	;1337.58
.db %01000000\ .dw 3130	;3130
.db %01000001\ .dw 8899	;889.9
.db %10010010,%00001011	;1+,3+

EL80:
.db "Hg",0
.db "Mercury",0
.db %01000010\ .dw 20059	;200.59
.db %01000010\ .dw 23428	;234.28
.db %01000000\ .dw 630	;630
.db %01000000\ .dw 1007	;1007
.db %10010010,%00001010	;1+,2+

EL81:
.db "Tl",0
.db "Thallium",0
.db %10010100\ .db 33\ .dw 20438	;204.3833
.db %01000000\ .dw 577	;577
.db %01000000\ .dw 1746	;1746
.db %01000001\ .dw 5891	;589.1
.db %10010010,%00001011	;1+,3+

EL82:
.db "Pb",0
.db "Lead",0
.db %01000001\ .dw 2072	;207.2
.db %01000001\ .dw 6006	;600.6
.db %01000000\ .dw 2023	;2023
.db %01000001\ .dw 7156	;715.6
.db %10100010,%00001100	;2+,4+

EL83:
.db "Bi",0
.db "Bismuth",0
.db %10000101\ .dw 8037\ .dw 2089	;208.98037
.db %01000010\ .dw 54442	;544.42
.db %01000000\ .dw 1837	;1837
.db %01000000\ .dw 703	;703
.db %10110010,%00001101	;3+,5+

EL84:
.db "Po",0
.db "Polonium",0
.db %10010100\ .db 24\ .dw 20898	;208.9824
.db %01000000\ .dw 527	;527
.db %01000000\ .dw 1235	;1235
.db %01000000\ .dw 813	;813
.db %00100100,%11001010,%00001110	;2-,2+,4+,6+

EL85:
.db "At",0
.db "Astatine",0
.db %10000101\ .dw 8037\ .dw 2099	;209.98037
.db %01000000\ .dw 575	;575
.db %01000000\ .dw 610	;610
.db %01000000\ .dw 916	;916
.db %00010010,%00001101	;1-,5+

EL86:
.db "Rn",0
.db "Radon",0
.db %10010100\ .db 76\ .dw 22201	;222.0176
.db %01000000\ .dw 202	;202
.db %01000000\ .dw 211	;211
.db %01000000\ .dw 1037	;1037
.db 0	;none

EL87:
.db "Fr",0
.db "Francium",0
.db %10010100\ .db 97\ .dw 22301	;223.0197
.db %01000000\ .dw 300	;300
.db %01000000\ .dw 950	;950
.db %01000000\ .dw 375	;375
.db %10010001	;1+

EL88:
.db "Ra",0
.db "Radium",0
.db %10010100\ .db 54\ .dw 22602	;226.0254
.db %01000000\ .dw 973	;973
.db %01000000\ .dw 1809	;1809
.db %01000001\ .dw 5091	;509.1
.db %10100001	;2+

EL89:
.db "Ac",0
.db "Actinium",0
.db %10010100\ .db 78\ .dw 22702	;227.0278
.db %01000000\ .dw 1323	;1323
.db %01000000\ .dw 3473	;3473
.db %01000000\ .dw 666	;666
.db %10110001	;3+

EL90:
.db "Th",0
.db "Thorium",0
.db %10010100\ .db 81\ .dw 23203	;232.0381
.db %01000000\ .dw 2028	;2028
.db %01000000\ .dw 5061	;5061
.db %01000000\ .dw 587	;587
.db %11000001	;4+

EL91:
.db "Pa",0
.db "Protactinium",0
.db %10000101\ .dw 588\ .dw 23103	;231.03588
.db 0	;unknown
.db 0	;unknown
.db %01000000\ .dw 568	;568
.db %10110011,%11011100	;3+,4+,5+

EL92:
.db "U",0
.db "Uranium",0
.db %10010100\ .db 89\ .dw 23802	;238.0289
.db %01000000\ .dw 1405	;1405
.db %01000000\ .dw 4407	;4407
.db %01000000\ .dw 584	;584
.db %10110100,%11011100,%00001110	;3+,4+,5+,6+

EL93:
.db "Np",0
.db "Neptunium",0
.db %10010100\ .db 82\ .dw 23704	;237.0482
.db %01000000\ .dw 910	;910
.db 0	;unknown
.db %01000000\ .dw 597	;597
.db %10100101,%11001011,%11101101	;2+,3+,4+,5+,6+

EL94:
.db "Pu",0
.db "Plutonium",0
.db %10010100\ .db 42\ .dw 24406	;244.0642
.db %01000000\ .dw 913	;913
.db %01000000\ .dw 3503	;3503
.db %01000000\ .dw 585	;585
.db %10110100,%11011100,%00001110	;3+,4+,5+,6+

EL95:
.db "Am",0
.db "Americium",0
.db %10010100\ .db 14\ .dw 24306	;243.0614
.db %01000000\ .dw 1268	;1268
.db %01000000\ .dw 2880	;2880
.db %01000000\ .dw 579	;579
.db %10100011,%11001011	;2+,3+,4+

EL96:
.db "Cm",0
.db "Curium",0
.db %10000100\ .dw 703\ .dw 2470	;247.0703
.db %01000000\ .dw 1340	;1340
.db 0	;unknown
.db %01000000\ .dw 581	;581
.db %10110010,%00001100	;3+,4+

EL97:
.db "Bk",0
.db "Berkelium",0
.db %10000100\ .dw 703\ .dw 2470	;247.0703
.db 0	;unknown
.db 0	;unknown
.db %01000000\ .dw 601	;601
.db %10110010,%00001100	;3+,4+

EL98:
.db "Cf",0
.db "Californium",0
.db %10010100\ .db 96\ .dw 25107	;251.0796
.db %01000000\ .dw 900	;900
.db 0	;unknown
.db %01000000\ .dw 608	;608
.db %10110010,%00001100	;3+,4+

EL99:
.db "Es",0
.db "Einsteinium",0
.db %10010100\ .db 28\ .dw 25208	;252.0828
.db 0	;unknown
.db 0	;unknown
.db %01000000\ .dw 619	;619
.db %10110001	;3+

EL100:
.db "Fm",0
.db "Fermium",0
.db %10010100\ .db 51\ .dw 25709	;257.0951
.db 0	;unknown
.db 0	;unknown
.db %01000000\ .dw 627	;627
.db %10100010,%00001011	;2+,3+

EL101:
.db "Md",0
.db "Mendelevium",0
.db %10010100\ .db 86\ .dw 25809	;258.0986
.db 0	;unknown
.db 0	;unknown
.db %01000000\ .dw 635	;635
.db %10100010,%00001011	;2+,3+

EL102:
.db "No",0
.db "Nobelium",0
.db %10000100\ .dw 1009\ .dw 259	;259.1009	;!!!!
.db 0	;unknown
.db 0	;unknown
.db %01000000\ .dw 642	;642
.db %10100010,%00001011	;2+,3+

EL103:
.db "Lr",0
.db "Lawrencium",0
.db %10010100\ .db 54\ .dw 26010	;260.1054
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db %10110001	;3+

EL104:
.db "Rf",0
.db "Rutherfordium",0
.db %01000000\ .dw 261	;261
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL105:
.db "Db",0
.db "Dubnium",0
.db %01000000\ .dw 262	;262
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL106:
.db "Sg",0
.db "Seaborgium",0
.db %01000000\ .dw 263	;263
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL107:
.db "Bh",0
.db "Bohrium",0
.db %01000000\ .dw 262	;262
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL108:
.db "Hs",0
.db "Hassium",0
.db %01000000\ .dw 265	;265
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL109:
.db "Mt",0
.db "Meitnerium",0
.db %01000000\ .dw 266	;266
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL110:
.db "Uun",0
.db "Ununnilium",0
.db %01000000\ .dw 269	;269
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL111:
.db "Uuu",0
.db "Unununium",0
.db %01000000\ .dw 272	;272
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown

EL112:
.db "Uub",0
.db "Ununbium",0
.db %01000000\ .dw 272	;272
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
.db 0	;unknown
