;##################################################################
;
;   Phoenix-Z80 (Level definitions)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated November 24, 2000.
;
;##################################################################     

;############## Table of level descriptions

level_table:
        .dw     lev1                                 
        .dw     lev2
        .dw     lev3
        .dw     _shop
        .dw     lev4
        .dw     lev5
        .dw     bounce6
        .dw     lev6
        .dw     _shop
        .dw     lev4a
        .dw     lev5a
        .dw     bounce8
        .dw     lev6a
        .dw     _shop
        .dw     lev7
SPLIT_LEVEL     =15
        .dw     lev8
        .dw     bounce10
        .dw     lev9
        .dw     _shop

        .dw     lev10
        .dw     lev11
        .dw     lev12
        .dw     _shop
        .dw     lev13
        .dw     lev14
        .dw     lev15
        .dw     _shop
        .dw     lev13a
        .dw     lev14a
        .dw     lev15a
        .dw     _shop


        .dw     levsw        
        .dw     levl
        .dw     _shop
        .dw     levo1
        .dw     levo2
        .dw     levo3
        .dw     _shop
        .dw     levsw        
        .dw     levl

        .dw     _game_finished

;############## Level descriptions
;
; Level descriptions begin with a
;
;       .db     total_number_of_enemies
;
; followed by as many of the following level-initialization commands as
; needed to specify the level
;
;       .db     0               ; end the level data
;
;       .db     1,num,type,x,y  ; install num enemies of specified type in
;       .dw     image           ; a row starting at (x,y) with given image
;
;       .db     4               ; install a single enemy, copying the whole
;       .dw     data            ; structure from memory at (data)
;
;       .db     7,num           ; install num bouncing enemies
;
;       .db     10,num,type     ; install num "delayed-entry" enemies
;
;       .db     13,byte         ; write the byte to memory at address
;       .dw     addr
;
;       .db     16              ; Marks the end of the game
;
;       .db     19              ; Enters the shop
;
;       .db     22              ; write misc. word to memory at address
;       .dw     word, addr
;
; Note the "image", "word", and "data" are expected to be offsets within
; the level data on the TI-85 (but "addr" is *NOT*).

levsw:  .db     9
        .db     10,9,36
        .db     0

levo1:  .db     8
        .db     10,8,30
        .db     0

levo2:  .db     12
        .db     10,12,30
        .db     0

levo3:  .db     13
        .db     10,12,30
        .db     4
        .dw     boss_data2
        .db     0

levl:   .db     18
        .db     4
        .dw     boss_data3
        .db     13,128
        .dw     which_shot
        .db     10,17,9
        .db     22
        .dw     huge_oval_pattern,pattern
        .db     0

lev1:   .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_1
        .db     1,6,3,18,10
        .dw     img_enemy_1
        .db     1,6,3,18,20
        .dw     img_enemy_1
        .db     13,0
        .dw     which_shot
        .db     0

lev2:   .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_1
        .db     1,6,3,20,10
        .dw     img_enemy_1
        .db     1,6,3,18,20
        .dw     img_enemy_1
        .db     0

lev3:   .db     7
        .db     1,6,3,18,20
        .dw     img_enemy_1
        .db     4
        .dw     boss_data
        .db     0

lev4:   .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_2
        .db     1,6,3,18,10
        .dw     img_enemy_2
        .db     1,6,3,18,20
        .dw     img_enemy_2
        .db     0

lev5:   .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_2
        .db     1,6,3,20,10
        .dw     img_enemy_2
        .db     1,6,3,18,20
        .dw     img_enemy_2
        .db     0

lev6:   .db     7
        .db     1,6,3,18,20
        .dw     img_enemy_2
        .db     4
        .dw     boss_data
        .db     0

lev4a:  .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_2
        .db     1,6,3,18,10
        .dw     img_enemy_2a
        .db     1,6,3,18,20
        .dw     img_enemy_2a
        .db     0

lev5a:  .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_2a
        .db     1,6,3,20,10
        .dw     img_enemy_2a
        .db     1,6,3,18,20
        .dw     img_enemy_2a
        .db     0

lev6a:  .db     13
        .db     1,6,3,18,23
        .dw     img_enemy_2a
        .db     1,6,3,18,15
        .dw     img_enemy_2
        .db     4
        .dw     boss_data
        .db     0

lev7:   .db     14
        .db     10,14,9
        .db     22
        .dw     circle_pattern,pattern
        .db     0

lev8:   .db     13
        .db     10,13,9
        .db     22
        .dw     figure_eight_pattern,pattern
        .db     0

lev9:   .db     14
        .db     10,13,9
        .db     22
        .dw     oval_pattern,pattern
        .db     4
        .dw     boss_data
        .db     0

lev10:  .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_4
        .db     1,6,3,18,10
        .dw     img_enemy_4
        .db     1,6,3,18,20
        .dw     img_enemy_4
        .db     13,1
        .dw     which_shot
        .db     0

lev11:  .db     18
        .db     1,6,3,18,0
        .dw     img_enemy_4
        .db     1,6,3,20,10
        .dw     img_enemy_4
        .db     1,6,3,18,20
        .dw     img_enemy_4
        .db     0

lev12:  .db     13
        .db     1,6,3,18,12
        .dw     img_enemy_2
        .db     1,6,3,18,21
        .dw     img_enemy_2
        .db     4
        .dw     boss_data2
        .db     0

bounce6:
        .db     6
        .db     7,6
        .db     0

bounce8:
        .db     8
        .db     7,8
        .db     0

bounce10:
        .db     10
        .db     7,10
        .db     0

lev13:  .db     18
        .db     1,6,21,18,0
        .dw     img_spin_1a
        .db     1,6,21,18,10
        .dw     img_spin_1a
        .db     1,6,21,18,20
        .dw     img_spin_1a
        .db     0

lev14:  .db     18
        .db     1,6,21,12,0
        .dw     img_spin_1a
        .db     1,6,21,19,10
        .dw     img_spin_1a
        .db     1,6,21,12,20
        .dw     img_spin_1a
        .db     0

lev15:  .db     14
        .db     1,7,21,16,12
        .dw     img_spin_1a
        .db     1,6,21,22,21
        .dw     img_spin_1a
        .db     4
        .dw     boss_data2
        .db     0

lev13a: .db     18
        .db     1,6,21,18,0
        .dw     img_spin_2a
        .db     1,6,21,18,10
        .dw     img_spin_2a
        .db     1,6,21,18,20
        .dw     img_spin_2a
        .db     0

lev14a: .db     18
        .db     1,6,21,12,0
        .dw     img_spin_2a
        .db     1,6,21,19,10
        .dw     img_spin_2a
        .db     1,6,21,12,20
        .dw     img_spin_2a
        .db     0

lev15a: .db     14
        .db     1,7,21,16,12
        .dw     img_spin_2a
        .db     1,6,21,22,21
        .dw     img_spin_2a
        .db     4
        .dw     boss_data2
        .db     0

_game_finished:
        .db     0,16

_shop:  .db     0,19

;############## Pattens

huge_oval_pattern:
        .db     1,18
        .db     64,20,0
        .db     10,16,0
        .db     8,12,-12
        .db     24,0,-10
        .db     8,-12,-12
        .db     10,-16,0
        .db     64,-20,0
        .db     10,-16,0
        .db     8,-12,12
        .db     24,0,10
        .db     8,12,12
        .db     10,16,0
        .db     0

;     KKK            EEE
;    L   JJ        DD   F
;   L      JJ    DD      F
;| A         JJDD         G |
;| A         DDJJ         G |
;v A       DD    JJ       G v
;   B    DD        JJ    H
;    BCCC            IIIH

figure_eight_pattern:
        .db     0,12
        .db     12,12,12        ;B
        .db     16,16,0         ;C
        .db     34,16,-12       ;D
        .db     16,15,0         ;E
        .db     12,12,12        ;F
        .db     8,0,12          ;G
        .db     12,-12,12       ;H
        .db     16,-15,0        ;I
        .db     34,-16,-12      ;J
        .db     16,-16,0        ;K
        .db     12,-12,12       ;L
        .db     8,0,12          ;A
        .db     0

circle_pattern:
        .db     0,14
        .db     8,12,12
        .db     16,16,0
        .db     8,12,-12
        .db     16,0,-16
        .db     8,-12,-12
        .db     16,-16,0
        .db     8,-12,12
        .db     16,0,16
        .db     0

oval_pattern:
        .db     0,16
        .db     4,12,12
        .db     76,16,0
        .db     4,12,-12
        .db     6,0,-16
        .db     4,-12,-12
        .db     76,-16,0
        .db     4,-12,12
        .db     6,0,16
        .db     0

;############## Data for bosses

boss_data:
        .db     12                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     1                       ; e_y
        .db     10                      ; e_h
        .db     60                      ; e_pwr

boss_data2:
        .db     18                      ; e_type
        .db     0                       ; e_phase
        .db     31                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     1                       ; e_y
        .db     10                      ; e_h
        .db     100                     ; e_pwr

boss_data3:
        .db     27
        .db     0
        .db     40
        .db     90
        .db     17
        .db     1
        .db     15
        .db     150
