;##################################################################
;
;   Phoenix-Z80 (Data storage, Save/Restore)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated October 28, 2000.
;
;##################################################################     

;############## Save the game

game_save:
#ifdef  __TI85__
        ld      hl,(PROGRAM_ADDR)
        ld      (&saved_address),hl
#endif
#ifndef  __TI82__
        ld      a,(ext_level)
        or      a
        jp      nz,game_exit
#endif
        ld      de,&saved_flag
        ld      a,1
        ld      (de),a
        inc     de
        ld      hl,perm_var_start
        ld      bc,perm_var_size
        ldir
        jp      &game_exit

;############## Test for saved game, restoring if it exists

restore_game:
        ld      hl,&saved_flag
        ld      a,(hl)
        or      a
        ret     z
        ld      (hl),0
        inc     hl
        ld      de,perm_var_start
        ld      bc,perm_var_size
        ldir
#ifdef  __TI85__
        scf
        ccf
        ld      hl,(PROGRAM_ADDR)
        ld      de,(&saved_address)
        sbc     hl,de
        ex      de,hl                   ;DE = adjustment for pointers

        ld      hl,pattern
        call    &ADD_MHLPI_DE



        ld      hl,&e_array+e_img
        ld      a,e_num
        ld      bc,e_size-1
loop_image_fixup:
        call    &ADD_MHLPI_DE
        add     hl,bc
        dec     a
        jr      nz,loop_image_fixup
#endif
        jp      &pre_main_loop

#ifdef  __TI85__
ADD_MHLPI_DE:
        push    af
        push    de
        push    hl
        call    LD_HL_MHL
        add     hl,de
        ex      de,hl
        pop     hl
        ld      (hl),e
        inc     hl
        ld      (hl),d
        pop     de
        pop     af
        ret
#endif

;############## Actual storage space

permanent_data_start:

saved_flag:
        .db     0

saved_data:
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

pb_array:                                           
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

e_array:
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

eb_array:             
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

game_data_end:

saved_address:
        .db     31337

high_scores:
        .db     "Patrick D ",0
        .dw     30000
        .db     "Patrick D ",0
        .dw     25000
        .db     "Patrick D ",0
        .dw     20000
        .db     "Patrick D ",0
        .dw     18000
        .db     "Patrick D ",0
        .dw     16000
        .db     "Patrick D ",0
        .dw     14000
        .db     "Patrick D ",0
high_scores_end:
        .dw     8000

permanent_data_end:
