;##################################################################
;
;   Phoenix-82 (New game initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated October 21, 2000.
;
;##################################################################     

difficulty_msg:
        .db     "Choose Difficulty",0
        .db     0
        .db     "3) Beginner",0
        .db     "4) Intermediate",0
        .db     "5) Advanced",0
        .db     -1

speed_msg:
        .db     "Choose Speed",0
        .db     0
        .db     "6) Slow",0
        .db     "7) Fast",0
        .db     -1

;############## Prepare new game

initialize_game:
        ROM_CALL(CLEARLCD)
        ld      hl,difficulty_msg
        call    display_hl_msgs

dsel_loop:
        call    GET_KEY
        cp      G_3
        jr      z,play_easy
        cp      G_4
        jr      z,play_medium
        cp      G_5
        jr      z,play_hard
        cp      G_DEL
        jp      z,game_exit
        cp      G_CLEAR
        jp      z,game_exit
        cp      G_MODE
        jr      nz,dsel_loop
        jp      game_exit

play_hard:
        ld      a,20
        ld      de,15000
        jr      install_game_variables
play_medium:
        ld      a,50
        ld      de,5000
        jr      install_game_variables
play_easy:
        ld      a,100
        ld      de,0
install_game_variables:
        push    de
        ld      hl,perm_var_start
        ld      bc,perm_var_size-1
        call    OTH_CLEAR
        pop     de

        ld      (bonus_score),de
        ld      (difficulty),a

        ld      hl,player_y
        ld      (hl),70         ; Player Y coord = 70
        inc     hl
        ld      (hl),60         ; Player X coord = 60
        inc     hl
        inc     hl
        inc     hl
        ld      (hl),16         ; Status of player's ship

        ld      hl,19000
        ld      (time_score),hl

        ROM_CALL(CLEARLCD)
        ld      hl,speed_msg
        call    display_hl_msgs

ssel_loop:
        call    GET_KEY
        cp      G_6
        jr      z,play_slow
        cp      G_7
        jr      z,play_fast
        cp      G_DEL
        jp      z,game_exit
        cp      G_CLEAR
        jp      z,game_exit
        cp      G_MODE
        jr      nz,ssel_loop
        jp      game_exit

play_slow:
        ld      a,3
        ld      de,0
        jr      speed_chosen
play_fast:
        ld      a,2
        ld      de,5000
speed_chosen:
        ld      (speed),a
        ld      hl,(bonus_score)
        add     hl,de
        ld      (bonus_score),hl


        ld      hl,&permanent_data_start
        ld      bc,game_data_end-permanent_data_start-1
        jp      OTH_CLEAR
