;##################################################################
;
;   Phoenix-82 (Screen display routines)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated October 28, 2000.
;
;##################################################################   

;############## Display -1 terminated list of strings at (HL)

display_hl_msgs:
        ld      de,0
show_loop:
        ld      (CURSOR_ROW),de
        push    de
        ROM_CALL(D_ZT_STR)
        pop     de
        ld      a,(hl)
        inc     a
        ret     z
        inc     e
        jr      show_loop

;############## Prepares on-screen shield indicator

prepare_indicator:
        ld      a,(player_pwr)
        or      a
        ret     z
        ret     m
        ld      b,a
        ld      hl,GFX_AREA+1024-3
        ld      de,-16
loop_ind:
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        djnz    loop_ind
        ret

;############## Clears screen buffer

clear_buffer:
        ld      (smc_savesp+1),sp
        ld      hl,0
        ld      sp,GFX_AREA+1024
        ld      b,63
loop_super_clear:
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        djnz    loop_super_clear
smc_savesp:
        ld      sp,0

        ld      hl,GFX_AREA+2
        ld      bc,11
        jp      OTH_CLEAR

;############## Display entire screen from buffer

display_screen:
        ld      a,$80           ; 7
        out     ($10),a         ; 11
        ld      hl,GRAPH_MEM+2-16-(-(16*64)+1)    ; 10
        ld      a,$20           ; 7
        ld      c,a             ; 4     ; 43
fastCopyAgain:
        ld      b,64            ; 7
        inc     c               ; 4
        ld      de,-(16*64)+1   ; 10
        out     ($10),a         ; 11
        add     hl,de           ; 11
        ld      de,15           ; 10
fastCopyLoop:
        add     hl,de           ; 11
        inc     hl              ; 6
        ret     c               ; 5
        ld      a,(hl)          ; 7
        out     ($11),a         ; 11
        djnz    fastCopyLoop    ; 13/8  ; 3392
        ld      a,c             ; 4
        cp      $2B+1           ; 7
        jr      nz,fastCopyAgain; 12/7
        ret     ; 11    ; 18
