;##################################################################
;
;   Phoenix-Z80 (Player handling)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 30, 2000.
;
;##################################################################     

;############## Movement, Firing (by OTH_ARROW) and ship display

autofire:
        bit     5,c
        jr      nz,fire_done
        ld      hl,fire_counter
        inc     (hl)
        ld      a,(hl)
        cp      4
        jr      nz,fire_done
        ld      (hl),0
        push    bc
        call    &player_shoot
        pop     bc
        jr      fire_done

do_player:
        call    OTH_ARROW
        ld      c,a
        ld      a,(weapon_upgrade)
        or      a
        jr      nz,autofire
        ld      hl,jp2nd
        bit     5,c
        jr      nz,notpressed
        ld      a,(hl)
        ld      (hl),1
        or      a
        push    bc
        call    z,&player_shoot
        pop     bc
        jr      fire_done
notpressed:
        ld      (hl),0
fire_done:

        ld      hl,player_y
        rr      c     
        jr      c,no_down       
        ld      a,(hl)  
        add     a,1     
        cp      90
        jr      z,no_down       
        ld      (hl),a  
no_down:
        inc     hl      
        rr      c       
        jr      c,no_left       
        ld      a,(hl)  
        add     a,-2
        cp      12
        jr      z,no_left       
        ld      (hl),a  
no_left:
        rr      c       
        jr      c,no_right      
        ld      a,(hl)  
        add     a,2
        cp      108     
        jr      z,no_right      
        ld      (hl),a  
no_right:
        ld      d,(hl)  
        dec     hl      
        rr      c       
        jr      c,no_up 
        ld      a,(hl)  
        add     a,-1     
        cp      68            
        jr      z,no_up 
        ld      (hl),a  
no_up:                                  
        ld      de,(player_y)
        ld      hl,&img_player_ship_normal
        ld      a,(player_pwr)
        cp      4
        jp      nc,&drw_spr
        ld      hl,&img_player_ship_damaged
        jp      &drw_spr

;############## Control keys (GET_KEY)

handle_input:
        call    GET_KEY
        cp      K_MORE
        jp      z,&game_save
        cp      K_EXIT
        jp      z,&game_exit

        ld      hl,chosen_weapon
        cp      K_F5
        jr      z,select_weapon_5
        cp      K_F4
        jr      z,select_weapon_4
        cp      K_F3
        jr      z,select_weapon_3
        cp      K_F2
        jr      z,select_weapon_2
        sub     K_F1
        ret     nz
        ld      (hl),a
        ret

select_weapon_2:
        ld      a,(weapon_2)
        or      a
        ret     z
        ld      (hl),a
        ret

select_weapon_3:
        ld      a,(weapon_3)    
        or      a
        ret     z
        ld      (hl),2
        ret

select_weapon_4:
        ld      a,(weapon_4)
        or      a
        ret     z
        ld      (hl),3
        ret

select_weapon_5:
        ld      a,(weapon_5)
        or      a
        ret     z
        ld      (hl),4
        ret
