;##################################################################
;
;   Phoenix-Z80 (Variable and data structure defintions)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated November 24, 2000.
;
;##################################################################   

;############## Player bullet structure definition

pb_type         =0
pb_dmg          =1
pb_x            =2
pb_w            =3
pb_y            =4
pb_h            =5
pb_img          =6
pb_data         =8

pb_size         =10

pb_num          =16

;############## Enemy structure definition

e_type          =0          ; Type (offset in jump table)
e_phase         =1          ; Phase of movement (enemy-specific use)
e_timer         =2          ; Timer (enemy-specific use)
e_x             =3          ; X coordinate
e_w             =4          ; Width 
e_y             =5          ; Y coordinate
e_h             =6          ; Height
e_pwr           =7          ; Shield strength
e_img           =8          ; Image pointer (not required)
e_data          =10         ; Misc. data (enemy-specific use)

e_size          =12

e_num           =18

;############## Enemy bullet structure definition

eb_type         =0
eb_dmg          =1
eb_x            =2
eb_w            =3
eb_y            =4
eb_h            =5
eb_data         =6

eb_size         =10

eb_num          =15

;############## Screen side data

#ifdef  __TI85__
sidesdata       =$FA70
leftsidecoord   =$FB70
leftsidevel     =$FB71
rightsidecoord  =$FB72
rightsidevel    =$FB73
#else
sidesdata       =$AA70
leftsidecoord   =$AB70
leftsidevel     =$AB71
rightsidecoord  =$AB72
rightsidevel    =$AB73
#endif

;############## Permanent variables

perm_var_start  =TEXT_MEM

posqueue        =TEXT_MEM
player_y        =TEXT_MEM+20
player_x        =TEXT_MEM+21
enemies_left    =TEXT_MEM+22
level           =TEXT_MEM+23              
player_pwr      =TEXT_MEM+24
player_cash     =TEXT_MEM+25
weapon_upgrade  =TEXT_MEM+27
weapon_2        =TEXT_MEM+28
weapon_3        =TEXT_MEM+29
weapon_4        =TEXT_MEM+30
weapon_5        =TEXT_MEM+31
fire_counter    =TEXT_MEM+32
chosen_weapon   =TEXT_MEM+33
game_timer      =TEXT_MEM+34
pattern         =TEXT_MEM+36
companion_pwr   =TEXT_MEM+38
companion_y     =TEXT_MEM+39
companion_x     =TEXT_MEM+40
companion_img   =TEXT_MEM+41
difficulty      =TEXT_MEM+43
which_shot      =TEXT_MEM+44
time_score      =TEXT_MEM+45
bonus_score     =TEXT_MEM+47
completed       =TEXT_MEM+49
speed           =TEXT_MEM+50

perm_var_size   =51

;############## Temporary variables

misc_flags      =TEXT_MEM+111
data_addr       =TEXT_MEM+112
ext_level       =TEXT_MEM+114
level_addr      =TEXT_MEM+115
doing_enemies   =TEXT_MEM+117
beb_image       =TEXT_MEM+118
temp            =TEXT_MEM+120
shop_item       =TEXT_MEM+121
test_coords     =TEXT_MEM+122
timer           =TEXT_MEM+126
jp2nd           =TEXT_MEM+127
