#include <stdio.h>
#include <string.h>

char line[9999];
char oline[9999];
int lines = 0;

int process_file(FILE *infile, FILE *outfile)
{
    char *in, x, y, *out;
    char filename[20];
    FILE *nextfile;

    while (fgets(line, 9999, infile)) {
        lines++;
        if (!(strnicmp("#include", line, 8))) {
            in = line - 1;
            while (x = *++in) {
                if (x == '"') {
                    out = filename;
                    while (x = *++in) {
                        if (x == '"')
                            break;
                        *out++ = x;
                    }
                    *out = 0;
                    if (nextfile = fopen(filename, "r")) {
                        process_file(nextfile, outfile);
                        fclose(nextfile);
                    } else
                        printf("Unable to open include file %s\n", filename);
                    break;
                }
            }

        } else {
            in = line - 1;
            while (x = *++in) {
                if (x == '"') {
                    fputc(x, outfile);
                    while ((x = *++in) != '"') {
                        if (x == 0) {
                            in--;
                            x = '&';
                                break;
                        }
                        fputc(x, outfile);
                    }
                }
                if (x != '&')
                    fputc(x, outfile);
                if (x == ';') {
                    fputs(in + 1, outfile);
                    break;
                }
            }
        }
    }
    fprintf(outfile, "\n");
}

int main(int argc, char *argv[])
{
    int argnum;

    FILE *infile;
    FILE *outfile;

    printf("TI-85 to TI-82 source code converter, version 0.1\n");
    printf("Programmed by Patrick Davidson (pad@calc.org)\n");
    printf("This program is in the public domain.  There is no warranty.\n\n");
    
    if (argc != 3) {
        printf("Usage: %s infile outfile\n");
        return 423;
    } else {
        if (infile = fopen(argv[1], "r")) {
            if (outfile = fopen(argv[2], "w")) {
                fprintf(outfile, "#define  __TI82__\n");
                process_file(infile, outfile);
                printf("Conversion complete.  Processed %d lines.\n", lines);
            } else {
                printf("Unable to open output file!\n");
            }
            fclose(infile);
        } else {
            printf("Unable to open input file!\n");
        }
    }
}
