;##################################################################
;
;   Phoenix-Z80 (New game initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 4, 2000.
;
;##################################################################     

difficulty_msg:
        .db     "Choose Difficulty",0
        .db     0
        .db     "F3) Beginner",0
        .db     "F4) Intermediate",0
        .db     "F5) Advanced",0
        .db     -1

;############## Prepare new game

initialize_game:
        call    CLEARLCD
        ld      hl,&difficulty_msg
        call    &display_hl_msgs

dsel_loop:
        call    &scroll_sides
        call    &display_sides
        
        call    &synchronize
        call    GET_KEY
        cp      K_F3
        jr      z,play_easy
        cp      K_F4
        jr      z,play_medium
        cp      K_F5
        jr      z,play_hard
        cp      K_EXIT
        jr      nz,dsel_loop
        jp      &game_exit

play_hard:
        ld      a,20
        jr      install_game_variables
play_medium:
        ld      a,50
        jr      install_game_variables
play_easy:
        ld      a,100
install_game_variables:
        ld      hl,perm_var_start
        ld      bc,perm_var_size-1
        call    OTH_CLEAR

        ld      (difficulty),a

        ld      hl,player_y
        ld      (hl),70         ; Player Y coord = 70
        inc     hl
        ld      (hl),60         ; Player X coord = 60
        inc     hl
        inc     hl
        inc     hl
        ld      (hl),16         ; Status of player's ship

        ld      hl,&permanent_data_start
        ld      bc,permanent_data_end-permanent_data_start-1
        jp      OTH_CLEAR
