;##################################################################
;
;   P H O E N I X         F O R        T I - 8 5   /  T I - 8 6
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 4, 2000.
;
;##################################################################     
        
#ifndef __TI86__
        .include "usgard.h"
        .org    0
#endif

#ifdef  __TI86__
#include "ti-86.h"
#endif

title:  .db     "Phoenix 0.10 by Patrick D",0

;############## Include variable and data structure definitions
        
#include "phoenixz.h" 

;############## Initialize TIOS variables

main:   set     0,(iy+3)                ; Redraw graph screen
        ld      (iy+13),0               ; No-scroll text mode
        
;############## Initialize synchronization and side system
        
        call    &set_up_sides

        ld      hl,&timer_interrupt
        call    INT_INSTALL

        call    &restore_game
  
;############## Title screen

        call    CLEARLCD
        ld      hl,&title_main

show_title:
        push    hl
        call    &clear_buffer
        ld      hl,GRAPH_MEM
        ld      de,$fc00
        ld      bc,$200
        ldir
        pop     hl

        call    &display_hl_msgs
        
title_loop:
        call    &scroll_sides
        call    &display_sides
        
        call    &synchronize
        call    GET_KEY
        cp      K_F2
        jr      z,show_contact
        cp      K_F3
        jr      z,show_instructions
        cp      K_F1
        jp      z,&start_new_game
        cp      K_EXIT
        jr      nz,title_loop

game_exit:
        call    INT_REMOVE  
        jp      OTH_EXIT

show_contact:
        ld      hl,&title_contact
        jr      show_title

show_instructions:
        ld      hl,&title_instructions
        jr      show_title

;############## Title screen messages

title_main:
        .db     "  Phoenix  0.10",0
        .db     0
        .db     "  Programmed by",0
        .db     "Patrick  Davidson",0
        .db     0
        .db     " F1 - Start Game",0
        .db     "F2 - Contact Info",0
        .db     "F3 - Instructions",0
        .db     -1

title_instructions:
        .db     "Arrows: Move Ship",0
        .db     "Fn: Select Weapon",0
        .db     "2nd: Shoot Weapon",0
        .db     "MORE: Save + Exit",0
        .db     -1

title_contact:
        .db     "E-Mail:",0
        .db     "     pad@calc.org",0
        .db     "World Wide Web:",0
        .db     "    pad.calc.org",0
        .db     -1

;############## Initialize a new game

start_new_game:
        call    &initialize_game
        
;############## Game main loop
        
main_loop:
        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl

        call    &scroll_sides           ; Scroll sides (inside side buffer)
        call    &clear_buffer           ; Prepare main display buffer

        call    &do_player              ; Move and draw player
        call    &do_companion           ; Move and draw companion ship

        call    &enemies                ; Move and draw enemies

        call    &player_bullets         ; Move and draw player bullets

        call    &enemy_bullets          ; Move and draw enemy bullets
        call    &hit_player             ; Collisions involving player

        call    &synchronize            ; Wait for next 1/30 second cycle
        call    &display_screen         ; Copy display buffer to video memory

        call    &hit_enemies            ; Collisions btw. bullets & enemies

        call    &handle_input           ; Process control keys
        ld      a,(enemies_left)
        or      a
        call    z,&load_level
        jr      main_loop
        
;############## Include remainder of game files
        
#include "lib.asm"
#include "newgame.asm"
#include "display.asm"
#include "drwspr.asm"
#include "images.asm"
#include "player.asm"
#include "shoot.asm"
#include "bullets.asm"
#include "enemies.asm"
#include "init.asm"
#include "enemyhit.asm"
#include "collide.asm"
#include "ebullets.asm"
#include "hityou.asm"
#include "shop.asm"
#include "helper.asm"
#include "data.asm"
#include "eshoot.asm"

        .end
