;##################################################################
;
;   Phoenix-Z80 (Collisions between player and other objects)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last modified September 3, 2000.
;
;##################################################################     

hit_companion:
        ld      a,(companion_x)
        ld      l,a
        ld      h,7
        ld      (test_coords),hl
        ld      a,(companion_y)
        ld      l,a
        ld      h,7
        ld      (test_coords+2),hl
        ld      c,1
        jr      player_hit_scan

hit_player:
        ld      a,(player_x)
        ld      l,a
        ld      h,8
        ld      (test_coords),hl
        ld      a,(player_y)
        ld      l,a
        ld      h,6
        ld      (test_coords+2),hl

;############## Enemy bullet scanning loop

        ld      c,0
player_hit_scan:
        ld      hl,&eb_array        ; HL -> player bullet to check
        ld      b,eb_num
loop_player_hit_scan:
        ld      a,(hl)              ; Check if this bullet exists
        or      a
        jr      z,no_pbullet_here

        push    hl
        inc     hl
        inc     hl                  ; HL -> X coordinate of bullet

        call    &collision_check    ; Does it collide?
        jr      nc,no_player_collision

;############## Collision handling

        xor     a
        pop     hl
        push    hl

        ld      (hl),a
        inc     hl
        ld      e,(hl)
        cp      e
        jr      z,money

        bit     0,c
        jr      nz,did_hit_companion
        
        ld      a,(player_pwr)
        sub     e
        ld      (player_pwr),a
        jp      c,&game_exit
        jr      no_player_collision

did_hit_companion:
        ld      a,(companion_pwr)
        sub     e
        ld      (companion_pwr),a

        dec     a
        bit     7,a
        jr      z,no_player_collision

        ld      a,-1
        ld      (companion_pwr),a
        ld      hl,&image_explosion
        ld      (companion_img),hl

;############## End of collision handling

no_player_collision:
        pop     hl

no_pbullet_here:
        ld      de,eb_size          ; Next bullet in array
        add     hl,de
        djnz    loop_player_hit_scan

        ret

;############## Money collection

money:  ld      hl,(player_cash)
        ld      de,(difficulty)
        ld      d,0
        add     hl,de
        jr      c,no_player_collision
        ld      (player_cash),hl
        jr      no_player_collision
