                         
 ; ************************************************************************
 ;
 ;                       Pac-Man 99 for the TI-86
 ;
 ;     Copyright 1997-1999 by Patrick Davidson.  All Rights Reserved.
 ;
 ;     This software is free but copyrighted.  See the file "COPYING.PDC" 
 ;  which should be distributed with the software for specific conditions 
 ;  of distribution and modification.                                     
 ;
 ;                             CONTACT ADDRESSES
 ;
 ;         WWW : http://pad.calc.org/       E-Mail : pad@calc.org
 ;
 ; ************************************************************************ 

 ; -------------- PROGRAM HEADER --------------------------------------------

         .include "asm86.h"
         .include "ti86asm.inc"
         .include "ti86abs.inc"
         .org     _asm_exec_ram

         nop
         jp       Start
         .dw      0
         .dw      Title
Title:   .db      "Pac-Man 99 1.1",0
Start:   ld       (OTH_EXIT+1),sp

 ; -------------- INITIALIZATION CODE ---------------------------------------

         call     $49dc

         call     _runindicoff
         call     _clrLCD 
         ld       (iy+5),2
         ld       a,(CONTRAST)

         cp       $1f
         jr       z,ok1
         inc      a
ok1:     out      (2),a

         ld       a,(saved_flag)
         or       a
         jp       nz,now

 ; -------------- TITLE SCREEN ----------------------------------------------

         xor      a
         ld       (cheat),a
display_ttl_scr:
         ld       hl,title
         ld       b,7
         call     display_info_screen

intro_loop:
         ld       hl,$fe01                   ; Erase side panel
         ld       b,32
         xor      a
         ld       de,16
clear_loop:
         ld       (hl),a
         add      hl,de
         djnz     clear_loop

         ld       hl,curspos                 ; Redraw arrow
         ld       a,(hl)
         and      3
         ld       (hl),a
         ld       h,$7f
         rrca
         rra
         rl       h
         add      a,a
         inc      a
         ld       l,a
         ld       ix,arrow
         ld       de,16
         ld       b,8
arrow_loop:
         ld       a,(ix)
         ld       (hl),a
         inc      ix
         add      hl,de
         djnz     arrow_loop

         call     _getkey                    ; Read and process keystrokees
         cp       k7
         jr       nz,no__cheat
         ld       a,1
         ld       (cheat),a
no__cheat:
         ld       hl,curspos
         cp       kExit
         jp       z,OTH_EXIT
         cp       kEnter
         jr       z,selected
         cp       kUp
         jr       nz,no_up
         dec      (hl)
no_up:   cp       kDown
         jr       nz,intro_loop
         inc      (hl)
         jr       intro_loop

selected:
         ld       a,(hl)
         or       a
         jr       z,toggle_speed
         dec      a
         jr       z,toggle_numen
         dec      a
         jr       z,instructions
         jr       start

toggle_speed:
         ld       hl,speed
         ld       a,(hl)
         or       a
         jr       z,speed_slow
         ld       (hl),0
         ld       hl,speedtext_fast
         jr       speed_set
         ret
speed_slow:
         ld       (hl),1
         ld       hl,speedtext_slow
speed_set:
         ld       de,speed_text
         ld       bc,4
         ldir
         jp       display_ttl_scr

toggle_numen:
         ld       hl,numen
         ld       a,(hl)
         or       a
         jr       z,numen_three
         ld       (hl),0
         ld       a,'4'
         jr       numen_set
numen_three:
         ld       (hl),1
         ld       a,'3'
numen_set:
         ld       (number_text),a
         jp       display_ttl_scr

instructions:
         ld       hl,inst_text
         ld       b,6
         call     display_info_screen
inst_waiting:
         call     _getkey
         or       a
         jr       z,inst_waiting
         jp       display_ttl_scr
         
start:   ld       de,easy_enemy_data
         ld       hl,900
         ld       a,(numen)
         or       a
         jr       nz,three_enemies
         ld       de,default_enemy_data
         ld       hl,1400
three_enemies:
         ld       (enemy_setup+1),de
         ld       a,(speed)
         or       a
         jr       z,fast_speed
         ld       de,-900
         add      hl,de
fast_speed:
         ld       (score),hl
now:
         call     play_game
         ei
         ld       a,%111111
         out      (1),a
         in       a,(1)
         sla      a
         jp       nc,save_the_game
         call     do_scores
         call     CLEARLCD 
         ld       (CURSOR_ROW),de
         ld       hl,hstitle
         call     D_ZT_STR 
         ld       hl,$1001
         ld       (CURSOR_ROW),hl
         ld       de,hsdata
         ld       b,7
high_display_loop:                         ;Display high scores
         ld       a,(de)
         ld       l,a
         inc      de
         ld       a,(de)
         ld       h,a
         inc      de
         push     de
         call     _D_HL_DECI 
         ld       hl,CURSOR_ROW
         dec      (hl)
         pop      hl
         call     D_ZT_STR 
         ex       de,hl
         ld       hl,CURSOR_ROW
         inc      (hl)
         djnz     high_display_loop

         call     _getkey
         jr       end_game

display_info_screen:
         push     bc
         push     hl
         call     _clrLCD
         ld       (CURSOR_ROW),de
         pop      hl
         call     D_ZT_STR

         pop      bc
l4:      ld       a,(hl)
         ld       (CURSOR_X),a
         inc      hl
         ld       a,(hl)
         ld       (CURSOR_Y),a
         inc      hl
         call     D_ZM_STR 
         djnz     l4
         ret

save_the_game:
         ld       de,saved_flag
         ld       a,3
         ld       (de),a

end_game:
         ld       a,(CONTRAST)
         out      (2),a

 ; -------------- BASIC ROUTINE LIBRARY -------------------------------------

OTH_EXIT:
         ld       sp,0                       ; Restore stack pointer

         ld       (iy+13),6                  ; Restore system flags

         ei
         ld       hl,TEXT_MEM
         ld       bc,167
         call     OTH_CLEAR
         ld       hl,0
         ld       (CURSOR_ROW),hl
         jp       _clrScrn

OTH_CLEAR:
         ld       d,h
         ld       e,l
         ld       (hl),0
         inc      de
         ldir
         ret

_D_HL_DECI:
         push     bc
         ld       de,up_data+4
         ld       b,5
ldhld:   call     UNPACK_HL
         add      a,48
         ld       (de),a
         dec      de
         djnz     ldhld
         ld       hl,up_data
         ld       b,4
lis:     ld       a,(hl)
         cp       48
         jr       nz,dis
         ld       (hl),32
         inc      hl
         djnz     lis
dis:     ld       hl,up_data
         call     _puts
         pop      bc
         ret

up_data: .db      "PAD98",0

 ; -------------- SCORING ---------------------------------------------------

do_scores:
         ld       hl,lowest                  ;See if ya got a hi-score
         call     LD_HL_MHL
         ld       de,(score)
         call     CP_HL_DE
         ret      nc
         call     CLEARLCD 
         ld       (CURSOR_ROW),de
         ld       hl,hi_score_str
         call     D_ZT_STR 
         ld       hl,lowest+2

         ld       (temp),hl
         ld       b,16
         ld       c,32
space_loop:
         ld       (hl),c
         inc      hl
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
         ld       a,'_'
         call     TX_CHARPUT
         ld       hl,CURSOR_COL
         dec      (hl)
         call     _getkey
         cp       kDel
         jr       z,backup
         cp       kLeft
         jr       z,backup
         cp       kEnter
         jr       z,nomore

         cp       $5B
         jp       p,enter_name_loop
         ld       c,a
         ld       a,15
         cp       b
         jr       z,enter_name_loop

         ld       hl,chartable
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         or       a
         jr       z,enter_name_loop

         ld       (ix),a
         call     TX_CHARPUT  
         inc      b
         inc      ix
         jr       enter_name_loop

backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),' '
         ld       a,32
         call     TX_CHARPUT
         ld       hl,CURSOR_COL
         dec      (hl)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop

nomore:
         ld       hl,(score)
         ld       (lowest),hl
         ld       ix,lowest
         ld       b,6
sort_scores:
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-19)
         ld       h,(ix-18)
         call     CP_HL_DE
         ret      nc
         push     bc
         ld       b,19
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-19)
         ld       (ix),c
         ld       (ix-19),e
         inc      ix
         djnz     exg_loop
         ld       de,-38
         add      ix,de
         pop      bc
         djnz     sort_scores
         ret

chartable:
         .db      0,0,0,0,0,":",0,0
         .db      0,0,0,0,"+-*/"
         .db      "^()[]=",0,0
         .db      ",",0,0,0,"0123"
         .db      "456789",0," "
         .db      "ABCDEFGH"
         .DB      "IJKLMNOP"
         .db      "QRSTUVWX"
         .DB      "YZabcdef"
         .db      "ghijklmn"
         .db      "opqrstuv"
         .db      "wxyz"


 ; -------------- THE ACTUAL GAME -------------------------------------------

play_game:
         di
         call     CLEARLCD
         ld       hl,$1000
         ld       (iy+13),%11100000

         ld       (CURSOR_ROW),hl
         ld       hl,initialtemplate
         call     D_ZT_STR
         ld       de,$1003
         ld       (CURSOR_ROW),de
         call     D_ZT_STR)
         ld       de,$1006
         ld       (CURSOR_ROW),de
         call     D_ZT_STR
         ld       hl,saved_flag
         ld       a,(hl)
         ld       (hl),0
         or       a
         jr       nz,main_loop

         LD       hl,lives
         ld       (hl),9
         ld       a,1
         ld       (level),a
level_start:
         call     make_level
         call     prepare_to_play_level
main_loop:
         call     render_background
         call     do_you
         call     do_enemies
         call     display_stats
         call     display_data
         call     toggle_autopilot
         ld       a,(pills)
         or       a
         jr       z,you_won
         ld       a,%111111
         out      (1),a
         in       a,(1)
         sla      a
         ret      nc
         sla      a
         jr       c,main_loop
         ret
you_won:
         ld       hl,level
         inc      (hl)
         set      7,(iy+13)
         ld       b,100
         ld       a,(lives)
         ld       e,a
         ld       d,0
         ld       hl,(score)
loopis:  add      hl,de
         ld       (score),hl
         set      5,(iy+13)
         push     hl
         push     de
         push     bc
         call     display_stats
         pop      bc
         pop      de
         pop      hl
         djnz     loopis
         ld       a,(level)
nlev:
         cp       NUM_LEVELS+1
         jr       z,win

         call     display_stats
         jr       level_start
win:
         ld       hl,(score)
         ld       de,1000
         add      hl,de
         ld       (score),hl
         set      5,(iy+13)
         call     display_stats
         ld       b,3
loop_flickerw:
         push     bc
         call     display_data
         ld       bc,0
lww1:    dec      bc
         ld       a,b
         or       c
         jr       nz,lww1
         ld       hl,$0303
         ld       (CURSOR_ROW),hl
         ld       hl,youwin
         call     D_ZT_STR)
         ld       bc,0
lww2:    dec      bc
         ld       a,b
         or       c
         jr       nz,lww2
         pop      bc
         djnz     loop_flickerw        
         ret
youwin:  .db      "YOU WIN!!!!",0

 ; -------------- DISPLAY STATUS INFORMATION --------------------------------

display_stats:
         ld       a,(speed)
         or       a
         jr       z,displayfast
         ld       (iy+13),224
displayfast:
         bit      5,(iy+13)
         jr       z,nsc
         ld       hl,$1001
         ld       (CURSOR_ROW),hl
         ld       hl,(score)
         call     _D_HL_DECI
nsc:     bit      6,(iy+13)
         jr       z,nlc
         ld       hl,$1004
         ld       (CURSOR_ROW),hl
         ld       a,(lives)
         ld       l,a
         ld       h,0
         call     _D_HL_DECI
nlc:     bit      7,(iy+13)
         jr       z,nllc
         ld       hl,$1007
         ld       (CURSOR_ROW),hl
         ld       a,(level)
         ld       l,a
         ld       h,0
         call     _D_HL_DECI
nllc:    ld       (iy+13),0
         ret

 ; -------------- RENDER THE BACKGROUND -------------------------------------

render_background:
         ld       ix,$9000
         ld       hl,data
         ld       b,12
line_loop:
         push     bc
         ld       b,12
blocks_loop:

         xor      a
         ld       e,a                        ;E = Middle
         ld       c,a                        ;C = Top
         ld       d,a                        ;D = Bottom

         ld       a,(hl)
         inc      hl

         rra
         jr       nc,notop
         ld       c,%11111111
notop:

         rra
         jr       nc,noleft
         set      7,c
         ld       d,%10000000
         ld       e,%10000000
noleft:

         rra
         jr       nc,nobottom
         ld       d,%11111111
nobottom:

         rra
         jr       nc,noright
         inc      e
         set      0,c
         set      0,d
noright:

         ld       (ix),c
         ld       (ix+12),e
         ld       (ix+24),e
         ld       (ix+60),e
         ld       (ix+72),e
         ld       (ix+84),d

         rra
         jr       nc,no_small_pill
         set      3,e
         set      4,e
         jr       no_large_pill
no_small_pill:

         rra
         jr       nc,no_large_pill
      
         set      3,e
         set      4,e
         ld       d,e
         ld       (ix+24),d
         ld       (ix+60),d
         set      5,e
         set      2,e

no_large_pill:      

         ld       (ix+36),e
         ld       (ix+48),e

         inc      ix

         djnz     blocks_loop
         ld       bc,84
         add      ix,bc
         pop      bc
         djnz     line_loop
         ret

 ; -------------- COPY THE IMAGE TO THE SCREEN ------------------------------

top_of_buffer:
         ld       de,384
         add      hl,de
         jr       dispi
display_data:
         ld       hl,$9000
         ld       a,(y)
         bit      6,a
         jr       nz,top_of_buffer
         sub      32
         jr       z,dispi
         jp       m,dispi
         ld       b,a
         ld       de,12
lfa:     add      hl,de
         djnz     lfa
dispi:   ld       de,$fc00
         ld       a,32
loop_copy_image:
         ld       bc,12
         ldir
         inc      de
         inc      de
         inc      de
         inc      de
         ld       bc,12
         ldir
         inc      de
         inc      de
         inc      de
         inc      de
         dec      a
         jp       nz,loop_copy_image
         ret

 ; -------------- SET UP A LEVEL --------------------------------------------

make_level:
         ld       de,144
         ld       hl,level_maps-144
         ld       a,(level)
         ld       b,a
lfld:    add      hl,de
         djnz     lfld
         ld       bc,144
         ld       de,data
         ld       b,144
         ld       c,0
loop_make_level_map:
         ld       a,(hl)
         bit      4,a
         jr       z,nph
         inc      c
nph:     ld       (de),A
         INC      HL
         INC      DE
         djnz     loop_make_level_map
         ld       a,c
         ld       (pills),a
         ret

prepare_to_play_level:
         call     render_background      
         call     display_stats
         ld       hl,image_right
         ld       (image),hl
         ld       hl,0
         ld       (x),hl
         ld       (xv),hl
         ld       (nxv),hl
         ld       a,$5f
         ld       (bitsmc+1),a
         ld       b,3
loop_flicker:
         push     bc
         call     display_data
         ld       bc,0
lw1:     dec      bc
         ld       a,b
         or       c
         jr       nz,lw1
         ld       hl,$0303
         ld       (CURSOR_ROW),hl
         ld       hl,getready
         call     D_ZT_STR)
         ld       bc,0
lw2:     dec      bc
         ld       a,b
         or       c
         jr       nz,lw2
         pop      bc
         djnz     loop_flicker
         ld       de,enemies
enemy_setup:
         ld       hl,default_enemy_data
         ld       bc,20
         ldir
         ret

 ; -------------- SPRITE RENDERING ROUTINE ----------------------------------

offsets_table:
         .db      128,64,32,16,8,4,2,1
drw_spr: ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (smc1+1),a

         ld       hl,$9000          ;Calculate byte number
         ld       a,e
         add      a,a
         add      a,a
         add      a,a
         rl       b
         add      a,a
         rl       b
         srl      d
         srl      d
         srl      d
         or       d
         ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         ld       b,(ix+1)        
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)            ;Load one line of image
         inc      ix
smc1     ld       a,1               ;Load pixel mask
iloop:   sla      c                 ;Test leftmost pixel
         jr       nc,noplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret

drw_spr96:
         ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (_smc1+1),a

         ld       hl,$9000          ;Calculate byte number

         ld       a,e
         add      a,a
         add      a,e
         rl       b
         add      a,a
         rl       b
         add      a,a
         rl       b
         srl      d
         srl      d
         srl      d
         add      a,d
         jr       nc,n1
         inc      b
n1:      ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         ld       b,(ix+1)        
_oloop:  push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)            ;Load one line of image
         inc      ix
_smc1    ld       a,1               ;Load pixel mask
_iloop:  sla      c                 ;Test leftmost pixel
         jr       nc,_noplot        ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
_noplot: rrca
         jr       nc,_notedge       ;Test if edge of byte reached
         inc      hl                ;Go to next byte
_notedge:djnz     _iloop
         pop      hl                ;Restore address
         ld       bc,12             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     _oloop
         ret

 ; -------------- DO STUFF ABOUT YOU ----------------------------------------

do_you:
         ld       ix,(image)
         ld       hl,x
         ld       d,(hl)
         inc      hl
         ld       e,(hl)
         call     drw_spr96
         ld       hl,x
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         inc      hl
         ld       b,a
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         ld       (y),a
         or       b
         and      7
         jr       nz,read_arrows

 ; -------------- POSSIBLY CHANGE YOUR MOVEMENT -----------------------------

autop:   ld       a,0
         or       a
         jr       z,___km
         ld       hl,0
         ld       (nxv),hl
___km:
         call     read_arrows
         ld       hl,(nxv)
         ld       (xv),hl
         ld       hl,x
         ld       c,(hl)            ;C = X
         srl      c                 ;C = X / 2
         srl      c                 ;C = X / 4
         srl      c                 ;C = X / 8
         inc      hl                ;HL -> Y
         ld       a,(hl)            ;A = Y
         ld       b,a               ;B = Y
         srl      a                 ;A = Y / 2
         add      a,b               ;A = 12 * Y / 8
         add      a,c               ;A = (X / 8) + (12 * Y / 8)
         ld       hl,data           ;HL -> MAP
         ld       c,a               ;C = (X / 8) + (12 * Y / 8)
         ld       b,0               ;BC = (X / 8) + (12 * Y / 8)
         add      hl,bc             ;HL -> MAP + (X / 8) + (12 * Y / 8)
         ld       a,(hl)

         bit      4,a
         jr       z,nopill
         push     hl
         ld       hl,pills
         dec      (hl)
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         set      5,(iy+13)
         pop      hl
nopill:  bit      5,a
         jr       z,nospill
         push     af
         push     hl
         ld       hl,enemies
         ld       de,5
         ld       B,4
lse:     ld       a,(hl)
         cp       3
         jr       nz,cste
         ld       (hl),6
cste:    add      hl,de
         djnz     lse
         ld       a,160
         ld       (cdown),a
         ld       hl,(score)
         add      hl,de
         ld       (score),hl
         set      5,(iy+13)
         pop      hl
         pop      af
         nop
nospill: and      15
         ld       (hl),a

bitsmc:  bit      3,a
         ret      z
         ld       hl,0
         ld       (xv),hl
         ret
read_arrows:
         LD       A,%1111110
         ld       ix,bitsmc+1
         OUT      (1),a
         in       a,(1)
         srl      a
         jr       c,no_down
         ld       hl,image_down
         ld       (image),hl
         ld       hl,$0100
         ld       (nxv),hl
         ld       (ix),$57
no_down: srl      a
         jr       c,no_left
         ld       hl,image_left
         ld       (image),hl
         ld       hl,$00ff
         ld       (nxv),hl
         ld       (ix),$4f
no_left: srl      a
         jr       c,no_right
         ld       hl,image_right
         ld       (image),hl
         ld       hl,$0001
         ld       (nxv),hl
         ld       (ix),$5f
no_right:srl      a
         ret      c
         ld       hl,image_up
         ld       (image),hl
         ld       hl,$ff00
         ld       (nxv),hl
         ld       (ix),$47
         ret

 ; -------------- TOGGLE AUTOPILOT ------------------------------------------

toggle_autopilot:
         ld       a,%111111
         out      (1),a
         ld       hl,jp2nd
         in       a,(1)
         bit      5,a
         jr       nz,notpressed
         ld       a,(hl)
         or       a
         ret      nz
         ld       a,(autop+1)
         cpl
         ld       (autop+1),a
         ret
notpressed:
         ld       (hl),0
         ret

 ; -------------- STUFF RELATED TO ENEMIES ----------------------------------

do_enemies:
         ld       a,(cdown)
         or       a
         jr       z,ncd
         dec      a
         ld       (cdown),a
ncd:
         ld       hl,enemies
         ld       b,4
enemy_loop:
         push     bc
         push     hl
         ld       b,0
         ld       c,(hl)
         ld       ix,enemy_routine_table
         add      ix,bc
         jp       (ix)
eback:   pop      hl
         pop      bc
         ld       de,5
         add      hl,de
         djnz     enemy_loop
         ret
enemy_routine_table:
         jp       eback
         jp       enemy_normal
         jp       enemy_scared
         jp       enemy_dead_r
enemy_dead_l:
         inc      hl
         dec      (hl)
         jr       z,enemy_restore
enemy_draw:
         ld       d,(hl)
         inc      hl
         ld       e,(hl)
         ld       ix,image_ghost_dead
         call     drw_spr96
         jr       eback
enemy_dead_r:
         inc      hl
         inc      (hl)
         ld       a,(hl)         
         cp       88
         jr       z,enemy_restore
         jr       enemy_draw
enemy_restore:
         dec      hl
         ld       (hl),3
         jr       eback

rand:    ld       de,0
         ld       a,(de)
         xor      e
         inc      de
         res      7,d
         ld       (rand+1),de
         ret

 ; -------------- NORMAL ENEMY ----------------------------------------------

enemy_normal:
         inc      hl
         ld       a,(hl)
         inc      hl
         or       (hl)
         and      7
         scf
         call     z,enemy_pseudo_intelligence
         call     nc,change_enemy_related_stuff

         ld       a,(y)
         sub      (hl)
         dec      hl
         add      a,5
         jp       m,nocoll1
         cp       10
         jr       nc,nocoll1
         ld       a,(x)
         sub      (hl)
         add      a,5
         jp       m,nocoll1
         cp       10
         jr       nc,nocoll1
         ld       a,(cheat)
         or       a
         jr       nz,nocoll1
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         ld       hl,lives
         dec      (hl)
         set      6,(iy+13)
         ret      z
         call     prepare_to_play_level
         jp       main_loop
nocoll1:
      
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(Hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       d,a
         inc      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       e,A
         ld       ix,image_ghost
         call     drw_spr96
         jp       eback

 ; -------------- SCARED ENEMY ----------------------------------------------

slow:    inc      hl
         ld       d,(hl)
         inc      hl
         ld       e,(Hl)
         jr       drawit         
btn:     ld       (hl),3
         jp       enemy_normal
enemy_scared:
         ld       a,(cdown)
         or       a
         jr       z,btn
         rra
         jr       nc,slow
         inc      hl
         ld       a,(hl)
         inc      hl
         or       (hl)
         and      7
         scf
         call     z,enemy_pseudo_intelligence_2
         call     nc,change_enemy_related_stuff

         ld       a,(y)
         sub      (hl)
         dec      hl
         add      a,5
         jp       m,nocoll2
         cp       10
         jr       nc,nocoll2
         ld       a,(x)
         sub      (hl)
         add      a,5
         jp       m,nocoll2
         cp       10
         jr       nc,nocoll2
         ld       a,(hl)
         dec      hl
         ld       (hl),12
         sub      44
         jp       p,ec1
         ld       (hl),9
ec1:     inc      hl
         inc      hl
         ld       a,(hl)
         and      %11111000
         ld       (hl),a
         inc      hl
         ld       (hl),0
         inc      hl
         ld       (hl),0
         ld       hl,(score)
         ld       de,50
         add      hl,de
         ld       (score),hl
         set      5,(iy+13)
         jp       eback
nocoll2:
                
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(Hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       d,a
         inc      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       e,A
drawit:
         ld       ix,image_ghost_scared
         call     drw_spr96
         jp       eback

 ; -------------- CHANGE ENEMY DIRECTION ------------------------------------

enemy_pseudo_intelligence:
         push     hl
         call     rand    
         rra
         jr       c,_updown
_leftright:
         dec      hl
         ld       a,(x)
         sub      (hl)
         jp       p,right__
         jr       left__
_updown:
         ld       a,(y)
         sub      (hl)
         jp       m,up__
_down:   jr       down__
enemy_pseudo_intelligence_2:
         push     hl
         call     rand
         rra
         jr       c,__updown
         dec      hl
         ld       a,(x)
         sub      (hl)
         jp       m,right__
         jr       left__
__updown:
         ld       a,(y)
         sub      (hl)
         jp       p,up__
         jr       down__
change_enemy_related_stuff:
         push     hl
         ld       a,r
         and      3
         dec      a
         jr       z,left__
         dec      a
         jr       z,right__
         dec      a
         jr       z,up__
down__:  ld       a,$57
         ld       bc,$0100
         jr       enemy_continue
left__:  ld       a,$4f
         ld       bc,$00ff
         jr       enemy_continue
right__: ld       a,$5f
         ld       bc,1
         jr       enemy_continue
up__:    ld       a,$47
         ld       bc,$ff00
enemy_continue:
         ld       hl,smcebit+1
         ld       (hl),a
         pop      hl
         inc      hl
         ld       (hl),c
         inc      hl
         ld       (hl),b
         dec      hl
         dec      hl

         ld       a,(hl)            ;A = Y
         push     hl
         dec      hl
         ld       c,(hl)            ;C = X
         srl      c                 ;C = X / 2
         srl      c                 ;C = X / 4
         srl      c                 ;C = X / 8
         ld       b,a               ;B = Y
         srl      a                 ;A = Y / 2
         add      a,b               ;A = 12 * Y / 8
         add      a,c               ;A = (X / 8) + (12 * Y / 8)
         ld       hl,data           ;HL -> MAP
         ld       c,a               ;C = (X / 8) + (12 * Y / 8)
         ld       b,0               ;BC = (X / 8) + (12 * Y / 8)
         add      hl,bc             ;HL -> MAP + (X / 8) + (12 * Y / 8)
         ld       a,(hl)
         pop      hl
         scf
smcebit: bit      0,a
         ret      z
         inc      hl
         ld       (hl),0
         inc      hl
         ld       (hl),0
         dec      hl
         dec      hl
         scf
         ccf
         ret

 ; -------------- IMAGES ----------------------------------------------------

image_right:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01110110
         .db      %01111100
         .db      %01111000
         .db      %01111110
         .db      %00111100
image_up:
         .db      7,7
         .db      %00000000
         .db      %00100100
         .db      %01110110
         .db      %01011110
         .db      %01111110
         .db      %01111110
         .db      %00111100
image_left:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01101110
         .db      %00111110
         .db      %00011110
         .db      %01111110
         .db      %00111100
image_down:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01111110
         .db      %01111110
         .db      %01111010
         .db      %01101110
         .db      %00100100
image_ghost:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01111110
         .db      %01111010
         .db      %01111110
         .db      %01111110
         .db      %01010100
image_ghost_scared:
         .db      7,7
         .db      %00000000
         .db      %00101000
         .db      %01010100
         .db      %00101010
         .db      %01010100
         .db      %00101010
         .db      %01010100
image_ghost_dead:
         .db      7,4
         .db      %01000100
         .db      %10101010
         .db      %10101010
         .db      %01000100

 ; -------------- LEVEL DATA ------------------------------------------------

level_maps:
         .db      03,21,21,21,17,21,21,17,21,21,21,25
         .db      26,35,21,21,20,17,17,20,21,21,41,26
         .db      26,26,19,21,21,20,20,21,21,25,26,26
         .db      26,26,18,17,17,21,21,17,17,24,26,26
         .db      18,24,26,26,26,19,25,26,26,26,18,24
         .db      26,22,44,26,18,28,22,24,26,38,28,26
         .db      26,19,41,26,18,25,19,24,26,35,25,26
         .db      18,24,26,26,26,22,28,26,26,26,18,24
         .db      26,26,18,20,20,21,21,20,20,24,26,26
         .db      26,26,22,21,21,17,17,21,21,28,26,26
         .db      26,38,21,21,17,20,20,17,21,21,44,26
         .db      22,21,21,21,20,21,21,20,21,21,21,28

         .db      03,21,21,17,17,21,21,17,17,21,21,25
         .db      26,35,21,28,26,19,25,26,22,21,41,26
         .db      26,26,35,17,20,28,22,20,17,41,26,26
         .db      18,28,26,26,19,17,17,25,26,26,22,24
         .db      18,21,24,26,26,10,10,26,26,18,21,24
         .db      26,19,28,18,28,10,10,22,24,22,25,26
         .db      26,22,25,18,25,10,10,19,24,19,28,26
         .db      18,21,24,26,26,10,10,26,26,18,21,24
         .db      18,25,26,26,22,20,20,28,26,26,19,24
         .db      26,26,38,20,17,25,19,17,20,44,26,26
         .db      26,38,21,25,26,22,28,26,19,21,44,26
         .db      22,21,21,20,20,21,21,20,20,21,21,28

         .db      03,21,21,17,17,41,35,17,17,21,21,25
         .db      26,19,21,28,26,26,26,26,22,21,25,26
         .db      26,26,19,21,28,26,26,22,21,25,26,26
         .db      18,28,26,19,21,16,16,21,25,26,22,24
         .db      18,21,28,26,19,24,18,25,26,22,21,24
         .db      38,21,21,24,26,14,14,26,18,21,21,44
         .db      35,21,21,24,26,11,11,26,18,21,21,41
         .db      18,21,25,26,22,24,18,28,26,19,21,24
         .db      18,25,26,22,21,16,16,21,28,26,19,24
         .db      26,26,22,21,25,26,26,19,21,28,26,26
         .db      26,22,21,25,26,26,26,26,19,21,28,26
         .db      22,21,21,20,20,44,38,20,20,21,21,28

         .db      03,21,25,19,21,21,17,21,25,19,21,25
         .db      26,19,20,28,19,21,20,25,22,20,25,26
         .db      22,24,19,21,44,19,25,38,21,25,18,28
         .db      19,44,18,21,17,28,22,17,21,24,38,25
         .db      26,19,24,19,28,19,25,22,25,18,25,26
         .db      18,24,26,26,19,28,22,17,24,26,26,26
         .db      26,26,26,18,20,25,19,28,26,26,18,24
         .db      26,22,24,22,25,22,28,19,28,18,28,26
         .db      22,25,18,21,20,25,19,20,21,24,19,28
         .db      19,24,22,21,25,22,28,19,21,28,18,25
         .db      26,22,17,25,22,17,21,28,19,17,28,26
         .db      38,21,28,22,21,20,21,21,28,22,21,44

         .db      03,21,21,17,21,21,21,21,17,21,21,25
         .db      22,21,25,18,21,25,19,21,24,19,21,28
         .db      19,21,28,22,21,24,18,21,28,22,21,25
         .db      26,19,21,21,17,20,20,17,21,21,25,26
         .db      26,26,19,21,20,21,21,20,21,25,26,26
         .db      22,44,22,21,17,21,21,17,21,28,38,28
         .db      19,41,19,21,20,21,21,20,21,25,35,25
         .db      26,26,22,21,17,21,21,17,21,28,26,26
         .db      26,22,21,21,20,17,17,20,21,21,28,26
         .db      22,21,25,19,21,24,18,21,25,19,21,28
         .db      19,21,28,18,21,28,22,21,24,22,21,25
         .db      22,21,21,20,21,21,21,21,20,21,21,28

         .db      03,21,21,21,21,17,17,21,21,21,21,25
         .db      26,35,17,21,21,28,22,21,21,17,41,26
         .db      26,26,18,21,21,21,21,21,21,24,26,26
         .db      26,26,18,21,17,25,19,17,21,24,26,26
         .db      26,26,26,19,28,26,26,22,25,26,26,26
         .db      18,28,26,26,19,12,06,25,26,26,22,24
         .db      18,25,26,26,22,09,03,28,26,26,19,24
         .db      26,26,26,22,25,26,26,19,28,26,26,26
         .DB      26,26,18,21,20,28,22,20,21,24,26,26
         .db      26,26,18,21,21,21,21,21,21,24,26,26
         .db      26,38,20,21,21,25,19,21,21,20,44,26
         .db      22,21,21,21,21,20,20,21,21,21,21,28

         .db      03,25,19,21,21,21,21,21,21,25,19,25
         .db      26,26,22,21,17,25,19,17,21,28,26,26
         .db      26,22,17,21,44,18,24,38,21,17,28,26
         .db      18,21,16,17,21,28,22,21,17,16,21,24
         .db      18,25,26,26,19,21,21,25,26,26,19,24
         .db      26,26,26,22,20,25,19,20,28,26,26,26
         .db      26,26,26,19,17,28,22,17,25,26,26,26
         .db      18,28,26,26,22,21,21,28,26,26,22,24
         .db      18,21,16,20,21,25,19,21,20,16,21,24
         .db      26,19,20,21,41,18,24,35,21,20,25,26
         .db      26,26,19,21,20,28,22,20,21,25,26,26
         .db      22,28,22,21,21,21,21,21,21,28,22,28

         .db      03,21,21,17,21,21,21,21,17,21,21,25
         .db      26,35,17,20,21,25,19,21,20,17,41,26
         .db      22,28,22,21,21,24,18,21,21,28,22,28
         .db      19,21,21,17,25,26,26,19,17,21,21,25
         .db      18,25,19,24,26,26,26,26,18,25,19,24
         .db      26,26,26,26,26,26,26,26,26,26,26,26
         .db      26,26,26,26,26,18,24,26,26,26,26,26
         .db      18,28,22,24,18,28,22,24,18,28,22,24
         .db      18,21,21,24,22,17,17,28,18,21,21,24
         .db      26,19,41,18,21,28,22,21,24,35,25,26
         .db      26,26,26,22,21,25,19,21,28,26,26,26
         .db      22,28,22,21,21,20,20,21,21,28,22,28

NUM_LEVELS =8

 ; ------------- TEXT / ENEMY DATA ------------------------------------------

getready:.db      "GET READY!",0
default_enemy_data:
         .db      3,40,40,0,0
easy_enemy_data:
         .DB      3,48,40,0,0
         .DB      3,40,48,0,0
         .DB      3,48,48,0,0       
         .DB      0,00,00,0,0
initialtemplate:
         .db      "SCORE",0
         .db      "LIVES",0
         .db      "LEVEL",0
speedtext_slow:
         .db      "SLOW"
speedtext_fast:
         .db      "FAST"

stored_data_start:

title:   .db      "P A C - M A N     9 9",0
         .db      0,10,"Copyright 1997-99 by"
         .db      " Patrick Davidson",0
         .db      24,17,"E-Mail - "
         .db      "pad@calc.org",0
         .db      22,24,"WWW - "
         .db      "http://pad.calc.org/",0
         .db      20,33,"Change Speed"
         .db      " (FAST)",0
speed_text        =*-6
         .db      20,41,"Change # of enemies"
         .db      " (4)",0
number_text       =*-3
         .db      20,49,"Read Instructions",0
         .db      20,57,"Start playing Pac-Man!",0

inst_text:
         .db      "Pac-Man  Instructions",0
         .db      0,16,"While playing,  "
         .db      "arrow keys move you.",0
         .db      0,24,"The [2nd] key toggles "
         .db      "control modes.",0
         .db      0,32,"Press [MORE] to save "
         .db      "the game and exit.",0
         .db      0,40,"If you get a highscore, "
         .db      "you can enter up",0
         .db      0,48,"to 15 chars.  Press "
         .db      "[ENTER] when done.",0 
         .db      7,58,"Press any key to"
         .db      " return to main menu",0
         .db      0,0,0

arrow:   .db      %00011000
         .db      %00001100
         .db      %00000110
         .db      %11111111
         .db      %11111111
         .db      %00000110
         .db      %00001100
         .db      %00011000

 ; ---------------------- HIGH SCORES ---------------------------------------
hi_score_str:
         .db      "----> PACMAN 99 <----"
         .db      "  You have a hiscore!"
         .db      "Enter your name here:",0
hstitle: .db      "= PACMAN HIGHSCORES =",0
hsdata:  .dw      5000
         .db      "Pac-Man 99      ",0
         .dw      4500
         .db      "Pac-Man 99      ",0
         .dw      4000
         .db      "Pac-Man 99      ",0
         .dw      3500
         .db      "Pac-Man 99      ",0
         .dw      3000
         .db      "Pac-Man 99      ",0
         .dw      2750
         .db      "Pac-Man 99      ",0
lowest   .dw      2500
         .db      "Pac-Man 99      ",0

 ; -------------- VARIABLE ADDRESSES ----------------------------------------

saved_flag:
         .db      0

cheat    .db      0
lives    .db      0
x        .db      0
y        .db      0                     
xv       .db      0                     
yv       .db      0                     
level    .db      0                     
image    .dw      0                     
pills    .dw      0             
enemies  .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
jp2nd    .db      0
nxv      .db      0        
nyv      .db      0    
cdown    .dw      0     
score    .dw      0
speed    .db      0
numen    .db      0
curspos  .db      3

data:    .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
stored_data_end:

scrlstart         =TEXT_MEM
scrlpos           =TEXT_MEM+2
temp              =TEXT_MEM+4

         .end
