;Minesweeper! v2.0 for TI-83 and TI-83 Plus (Ion)
;Written by Ryan Bolyard
;01/07/01   - v1.1 release
;01/30/01   - v1.3 (never released)
;04/17/01   - v2.0 release
.nolist
#include "ion.inc"

;-----------= Variables = -----------
a       =sram
b       =a+1
c       =b+1
d       =c+1
e       =d+1
f       =e+1
g       =f+1
h       =g+1
i       =h+1
j       =i+1
k       =j+1
l       =k+1
m       =l+1
n       =m+1
o       =n+1
p       =o+1
q       =p+1
r       =q+1
s       =r+1
t       =s+1
u       =t+1
v       =u+1
w       =v+1
x       =w+1
y       =x+1
z       =y+1
ol      =z+1
ma      =ol+1
mb      =ma+160
l1      =mb+160
l2      =l1+50
l3      =l2+50
l4      =l3+50
diml1   =l4+50
diml2   =diml1+1
diml3   =diml2+1
diml4   =diml3+1
temp    =diml4+1
timerb  =temp+1
timera  =timerb+1
timerct =timera+1
level   =timerct+1
ct      =level+1
menu_pos =ct+1
.list
#ifdef TI83P
        .org    progstart-2
        .db     $BB,$6D
#else
        .org    progstart
#endif

;-----------= Beginning of ASM code =-----------
        ret
        jr      nc,start
        .db     "Minesweeper! v2.0",0
start:
        ld      a,3
        ld      (k),a
        ld      (menu_pos),a
;        ld      a,8
;        ld      (a),a
;        ld      (b),a
        ld      hl,0808h
        ld      (a),hl
        ld      a,10
        ld      (m),a
        ld      a,1
        ld      (level),a
        jp      oline
la:
        ld      a,(b)
        ld      b,a
        ld      a,(a)
        ld      c,a
        call    mult
        ld      c,a
        ld      a,(s)
        ld      b,a
        ld      a,(m)
        ld      d,a
        ld      a,c
        sub     b
        cp      d
        jp      z,lw
        ld      a,(c)
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        ld      b,2
        add     a,b
        ld      (e),a
        ld      a,(d)
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        ld      (f),a
        call    draw_cursor
        bcall(_copygbuf)
        call    draw_cursor
        ld      a,(timerct)
        add     a,3
        ld      (timerct),a
la_wait:
        ld      a,(timerct)
        inc     a
        ld      (timerct),a
        cp      217
        jr      c,not_time
        xor     a       ;ld  a,0
        ld      (timerct),a
        ld      a,(timerb)
        inc     a
        ld      (timerb),a
        cp      60
        jr      nz,no_carry
        xor     a       ;ld  a,0
        ld      (timerb),a
        ld      a,(timera)
        inc     a
        ld      (timera),a
no_carry:
not_time:
        bcall(_getk)
        ld      (z),a
        or      a       ;cp  0
        jr      z,la
;        ld      a,5
;timer_wait:
;        dec     a
;        or      a       ;cp  0
;        jr      nz,timer_wait
;        ld      a,(z)
        cp      2           ;[(left)]
        call    z,move_left
        ld      a,(z)
        cp      3           ;[(right)]
        call    z,move_right
        ld      a,(z)
        cp      4           ;[(up)]
        call    z,move_up
        ld      a,(z)
        cp      1           ;[(down)]
        call    z,move_down
        ld      a,(z)
        cp      55          ;[MODE]
        jp      z,ls
        cp      15          ;[CLEAR]
        jp      z,ls
        cp      9           ;[ENTER]
        jr      z,no_goto_a_enter
        cp      54          ;[2nd]
        jr      z,no_goto_a_enter
        cp      17          ;[(-)]
        jr      z,no_goto_a
        cp      48
        jr      z,no_goto_a ;[ALPHA]
        jr      la_wait
no_goto_a:
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_b
        ld      (temp),a
        and     %00000001
        or      a       ;cp  0
        jp      nz,la
        ld      a,(temp)
        and     %10000000
        or      a       ;cp  0
        jr      nz,unflag
        ld      d,%10000000
        call    set_mat_b
        call    draw_flag
        ld      a,(l)
        inc     a
        ld      (l),a
        jp      la
unflag:
        ld      d,0
        call    set_mat_b
        call    draw_flag
        ld      a,(l)
        dec     a
        ld      (l),a
        jp      la
no_goto_a_enter:
;        jr      no_goto_a_enter
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_a
        ld      (n),a
        call    get_mat_b
        ld      (temp),a
        and     %10000000
        or      a       ;cp  0
        jp      nz,la
        ld      a,(temp)
        cp      1
        jp      z,la
        ld      a,(n)
        cp      9
        jp      z,ll
        or      a       ;cp  0
        jr      z,hit_space
        call    clr_l3
        call    clr_l4
        ld      a,(temp)
        cp      1
        jp      z,la
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(e)
        inc     a
        ld      (e),a
        call    draw_bracket
        ld      a,(s)
        inc     a
        ld      (s),a
        ld      a,(e)
        ld      d,a
        ld      a,(f)
        ld      e,a
        call    draw_n
        jp      la
hit_space:
        call    clr_l1
        call    clr_l2
        ld      a,(c)
        ld      c,1
        call    set_l1
        ld      a,(d)
        call    set_l2
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
while_diml1_0:
        call    clr_l3
        call    clr_l4
        ld      a,1
        ld      (ol),a
for_ol_1_diml1:
        ld      a,(ol)
        ld      c,a
        call    get_l1
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        inc     a
        ld      (g),a
        ld      a,(ol)
        ld      c,a
        call    get_l2
        ld      (temp),a
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        ld      (h),a
        ld      a,(ol)
        ld      c,a
        call    get_l1
;        dec     a
        ld      c,a
        ld      a,(temp)
;        dec     a
        ld      b,a
        call    get_mat_a
        ld      (n),a
        or      a       ;cp  0
        jr      z,no_draw_num
        ld      a,(h)
        ld      (f),a
        ld      a,(g)
        inc     a
        ld      (e),a
        call    draw_bracket
        ld      a,(g)
        inc     a
        ld      d,a
        ld      a,(h)
        ld      e,a
        call    draw_n
        jp      n_not_0
no_draw_num:
        ld      a,(h)
        ld      (f),a
        ld      a,(g)
        inc     a
        ld      (e),a
        call    draw_bracket
        ld      a,(ol)
        ld      c,a
        call    get_l1
        ld      (i),a
        call    get_l2
        ld      (j),a
        cp      1
        jp      z,j_not_g_1
        ld      a,(i)
        cp      1
        jr      z,i_not_g_1
        ld      a,(j)
;        dec     a
        dec     a
        ld      b,a
        ld      a,(i)
;        dec     a
        dec     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_jm1_im1_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        dec     a
        call    set_l3
        ld      a,(j)
        dec     a
        call    set_l4
        ld      a,(j)
;        dec     a
        dec     a
        ld      b,a
        ld      a,(i)
;        dec     a
        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_jm1_im1_not_0:
i_not_g_1:
        ld      a,(j)
;        dec     a
        dec     a
        ld      b,a
        ld      a,(i)
;        dec     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_jm1_i_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        call    set_l3
        ld      a,(j)
        dec     a
        call    set_l4
        ld      a,(j)
;        dec     a
        dec     a
        ld      b,a
        ld      a,(i)
;        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_jm1_i_not_0:
        ld      a,(a)
        ld      b,a
        ld      a,(i)
        cp      b
        jr      z,i_not_l_a
        ld      a,(j)
;        dec     a
        dec     a
        ld      b,a
        ld      a,(i)
        inc     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_jm1_ip1_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        inc     a
        call    set_l3
        ld      a,(j)
        dec     a
        call    set_l4
        ld      a,(j)
;        dec     a
        dec     a
        ld      b,a
        ld      a,(i)
        inc     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_jm1_ip1_not_0:
i_not_l_a:
j_not_g_1:
        ld      a,(i)
        cp      1
        jp      z,i_not_g1
        ld      a,(j)
;        dec     a
        ld      b,a
        ld      a,(i)
;        dec     a
        dec     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_j_im1_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        dec     a
        call    set_l3
        ld      a,(j)
        call    set_l4
        ld      a,(j)
;        dec     a
        ld      b,a
        ld      a,(i)
;        dec     a
        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_j_im1_not_0:
i_not_g1:
        ld      a,(a)
        ld      b,a
        ld      a,(i)
        cp      b
        jr      z,i_not_la
        ld      a,(j)
;        dec     a
        ld      b,a
        ld      a,(i)
        inc     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_j_ip1_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        inc     a
        call    set_l3
        ld      a,(j)
        call    set_l4
        ld      a,(j)
;        dec     a
        ld      b,a
        ld      a,(i)
        inc     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_j_ip1_not_0:
i_not_la:
        ld      a,(b)
        ld      b,a
        ld      a,(j)
        cp      b
        jp      z,j_not_l_b
        ld      a,(i)
        cp      1
        jr      z,i_not_g1_
        ld      a,(j)
        inc     a
        ld      b,a
        ld      a,(i)
;        dec     a
        dec     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_jp1_im1_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        dec     a
        call    set_l3
        ld      a,(j)
        inc     a
        call    set_l4
        ld      a,(j)
        inc     a
        ld      b,a
        ld      a,(i)
;        dec     a
        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_jp1_im1_not_0:
i_not_g1_:
        ld      a,(j)
        inc     a
        ld      b,a
        ld      a,(i)
;        dec     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_jp1_i_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        call    set_l3
        ld      a,(j)
        inc     a
        call    set_l4
        ld      a,(j)
        inc     a
        ld      b,a
        ld      a,(i)
;        dec     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_jp1_i_not_0:
        ld      a,(a)
        ld      b,a
        ld      a,(i)
        cp      b
        jr      z,i_not_la_
        ld      a,(j)
        inc     a
        ld      b,a
        ld      a,(i)
        inc     a
        ld      c,a
        call    get_mat_b
        or      a       ;cp  0
        jr      nz,matb_jp1_ip1_not_0
        ld      a,(diml3)
        inc     a
        ld      c,a
        ld      a,(i)
        inc     a
        call    set_l3
        ld      a,(j)
        inc     a
        call    set_l4
        ld      a,(j)
        inc     a
        ld      b,a
        ld      a,(i)
        inc     a
        ld      c,a
        ld      d,1
        call    set_mat_b
        ld      a,(s)
        inc     a
        ld      (s),a
matb_jp1_ip1_not_0:
i_not_la_:
j_not_l_b:

n_not_0:
        ld      a,(diml1)
        ld      b,a
        ld      a,(ol)
        inc     a
        ld      (ol),a
        dec     a
        cp      b
        jp      nz,for_ol_1_diml1
        call    clr_l1
        call    clr_l2
        call    l3_to_l1
        call    l4_to_l2
        ld      a,(diml1)
        or      a       ;cp  0
        jp      nz,while_diml1_0
        jp      la
ls:
        bcall(_clrscr)
        bcall(_homeup)
        ld      hl,txt_mine_sweeper
        call    draw_inv
        bcall(_newline)
        ld      hl,txt_stats_menu
        bcall(_puts)
;        bcall(_newline)
;        bcall(_newline)
;        ld      h,7
;        ld      l,6
        ld      hl,0906h
        ld      a,(m)
        cp      100
        jr      c,two_digits
        ld      h,0Ah
two_digits:
        ld      (CURROW),hl
        ld      a,(m)
        ld      h,0
        ld      l,a
        bcall(_disphl)
        ld      a,11
        ld      (CURCOL),a
        ld      hl,txt_slash
        bcall(_puts)
        ld      a,6
        ld      (CURCOL),a
        ld      a,(l)
        ld      h,0
        ld      l,a
        bcall(_disphl)
;        xor     a       ;ld  a,0
        ld      a,2
        ld      (CURCOL),a
        ld      hl,txt_flags
        bcall(_puts)
        ld      b,7
        call    draw_time
        ld      b,3
        call    menu_draw
menu_ls:
        push    bc
        bcall(_getk)
        pop     bc
        ld      (z),a
        cp      4           ;[(up)]
        call    z,menu_up
        cp      1           ;[(down)]
        call    z,menu_down
        cp      9           ;[(ENTER)]
        jr      nz,menu_ls
        ld      a,b
        cp      3
        jp      z,la
        cp      5
        jr      z,oline
        cp      4
        jp      z,off
le:
        jp      oline
oline:
        xor     a       ;ld  a,0
        ld      (l),a
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_mine_sweeper
        call    draw_inv
        bcall(_newline)
        ld      hl,txt_menu
        bcall(_puts)
        ld      hl,6
        ld      (CURROW),hl
        ld      hl,txt_name
        bcall(_puts)
        ld      hl,3808h        ;8,56
        ld      (pencol),hl
        ld      hl,txt_site
        bcall(_vputs)
        ld      b,3
        call    menu_draw
menu_ol:
        push    bc
        bcall(_getk)
        pop     bc
;        ld      (z),a
        cp      4           ;[(up)]
        call    z,menu_up
        cp      1           ;[(down)]
        call    z,menu_down
;        cp      44          ;[LOG]
;        call    z,micro
        cp      9           ;[ENTER]
        jr      nz,menu_ol
        ld      a,b
        cp      3
        jp      z,llevel
        cp      4
        jp      z,lo
        jp      lq
lq:
        bcall(_cleargbuf)
        bcall(_clrlcdf)
        ret
lo:
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_options_cursor
        call    draw_inv
        bcall(_newline)
        ld      hl,txt_options_menu
        bcall(_puts)
        ld      a,(k)
        inc     a
        inc     a
        ld      b,a
        call    menu_draw
options_wait:
        push    bc
        bcall(_getk)
        pop     bc
;        ld      (z),a
        cp      4           ;[(up)]
        push    af
        call    z,menu_up
        pop     af
;        ld      a,(z)
        cp      1           ;[(down)]
        push    af
        call    z,menu_down
        pop     af
;        ld      a,(z)
        cp      9           ;[ENTER]
        jr      nz,options_wait
        ld      a,b
        dec     a
        dec     a
        ld      (k),a
        jp      oline
llevel:
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_mine_sweeper
        call    draw_inv
        ld      hl,3
        ld      (currow),hl
        ld      hl,txt_levels_menu
        bcall(_puts)
        ld      a,(menu_pos)
        ld      b,a
        call    menu_draw
        ld      a,(level)
        cp      4
        jr      c,level_not_cust
        sub     3
        ld      (level),a
level_not_cust:
        call    level_draw
llevel_wait:
        push    bc
        bcall(_getk)
        pop     bc
;        ld      (z),a
        cp      4       ;[(up)]
        push    af
        call    z,menu_up
        pop     af
;        ld      a,(z)
        cp      1       ;[(down)]
        push    af
        call    z,menu_down
        pop     af
;        ld      a,(z)
        cp      2       ;[(left)]
        push    af
        call    z,level_left
        pop     af
;        ld      a,(z)
        cp      3       ;[(right)]
        push    af
        call    z,level_right
        pop     af
;        ld      a,(z)
        cp      15      ;[CLEAR]
        push    af
        ld      a,b
        ld      (menu_pos),a
        pop     af
        jp      z,oline
;        ld      a,(z)
        cp      9       ;[ENTER]
        jr      nz,llevel_wait
        ld      a,b
        cp      3
        jr      z,preset
        cp      4
        jr      z,lp
;        jr      reset_sure
reset_sure:
        ld      hl,2
        ld      (currow),hl
        ld      hl,txt_you_sure
        bcall(_puts)
reset_sure_wait:
        bcall(_getk)
        cp      44
        jr      z,llevel
        cp      34
        jr      z,reset_hs
        jr      reset_sure_wait
reset_hs:
        ld      de,highsc
        ld      a,6
reset_highsc:
        push    af
        ld      a,59
        ld      (de),a
        pop     af
        inc     de
        dec     a
        or      a       ;cp  0
        jr      nz,reset_highsc
        ld      de,highname
        ld      a,20h
        ld      (de),a
        inc     de
        ld      (de),a
        inc     de
        ld      a,3
reset_highname_loop:
        push    af
        ld      bc,highnamereset
        ld      a,14
reset_highname:
        push    af
        ld      a,(bc)
        ld      (de),a
        pop     af
        inc     de
        inc     bc
        dec     a
        or      a       ;cp  0
        jr      nz,reset_highname
        pop     af
        dec     a
        or      a       ;cp  0
        jr      nz,reset_highname_loop
        jp      llevel
preset:
        ld      a,(level)
        cp      3
        jr      z,preset_expert
        cp      2
        jr      z,preset_inter
;        ld      a,8
;        ld      (a),a
;        ld      (b),a
        ld      hl,0808h
        ld      (a),hl
        ld      a,10
        ld      (m),a
        jr      start_level         ;beginner:  8x8, 10 mines  =15.625% mines
preset_inter:
;        ld      a,10
;        ld      (a),a
;        ld      (b),a
        ld      hl,0A0Fh
        ld      (a),hl
        ld      a,30
        ld      (m),a
        jr      start_level         ;intermediate:  15x10, 30 mines  =20%
preset_expert:
;        ld      a,15
;        ld      (a),a
;        ld      a,10
;        ld      (b),a
        ld      hl,0A0Fh
        ld      (a),hl
        ld      a,40
        ld      (m),a
        jr      start_level         ;expert:  15x10, 40 mines  =26+(2/3)%
lp:
        ld      a,(level)
        add     a,3
        ld      (level),a
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_mine_sweeper
        call    draw_inv
        bcall(_newline)
        ld      hl,txt_play_menu
        bcall(_puts)
        ld      b,3
        call    menu_draw
        call    draw_play_menu
while_z_not_enter:
        push    bc
        bcall(_getk)
        pop     bc
;        ld      (z),a
        cp      4           ;[(up)]
        push    af
        call    z,menu_up
        pop     af
;        ld      a,(z)
        cp      1           ;[(down)]
        push    af
        call    z,menu_down
        pop     af
        cp      2           ;[(left)]
        push    af
        call    z,menu_left
        pop     af
        cp      3           ;[(right)]
        push    af
        call    z,menu_right
        pop     af
;        ld      a,(z)
        cp      15          ;[CLEAR]
        jp      z,llevel
        cp      9           ;[ENTER]
        jr      nz,while_z_not_enter
start_level:
        bcall(_cleargbuf)
        ld      b,0
        call    fill_mat_a
        call    fill_mat_b
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_mine_sweeper
        call    draw_inv
        ld      hl,0103h
        ld      (CURROW),hl
        ld      hl,txt_wait
        bcall(_puts)
;        ld      a,9
;        ld      (d),a
        ld      a,(m)
        ld      (e),a
        ld      a,(a)
        ld      b,a
        ld      a,(b)
        ld      c,a
        call    mult
        sra     a
        ld      (temp),a
;        ld      b,a
;        ld      a,(m)
;        cp      b
;        jp      c,less_half_mines
;        xor     a       ;ld  a,0
;        ld      (d),a
;        ld      a,(a)
;        ld      b,a
;        ld      a,(b)
;        ld      c,a
;        call    mult
;        ld      c,a
;        ld      a,(m)
;        ld      b,a
;        ld      a,c
;        sub     b
;        ld      (e),a
;        ld      b,9
;        call    fill_mat_a
less_half_mines:
        ld      a,1
        ld      (c),a
for_c_1toe:
;        ld      hl,3
;        ld      (CURROW),hl
;        ld      a,(c)
;        ld      l,a
;        bcall(_disphl)
        ld      a,(a)
        ld      b,a
        call    ionRandom
        inc     a
        ld      (x),a
        ld      a,(b)
        ld      b,a
        call    ionRandom
        inc     a
        ld      (y),a
;        dec     a
        ld      b,a
        ld      a,(x)
;        dec     a
        ld      c,a
        call    get_mat_a
;        ld      c,a
;        ld      a,(d)
;        ld      b,a
;        ld      a,c
        cp      9
        jr      nz,new_spot
        ld      a,(c)
        dec     a
        ld      (c),a
new_spot:
        ld      a,(x)
;        dec     a
        ld      c,a
        ld      a,(y)
;        dec     a
        ld      b,a
;        ld      a,(d)
        ld      d,9
        call    set_mat_a
        ld      a,(e)
        inc     a
        ld      b,a
        ld      a,(c)
        inc     a
        ld      (c),a
        cp      b
        jr      nz,for_c_1toe
;        bcall(_clrlcdf)
;        bcall(_homeup)
        xor     a       ;ld  a,0
        ld      (f),a
;        ld      hl,txt_numbering
;        call    draw_inv
;        ld      hl,3
;        ld      (CURROW),hl
;        ld      hl,txt_wait
;        bcall(_puts)
;        ld      a,9
;        ld      (g),a
;        ld      a,(temp)
;        ld      b,a
;        ld      a,(m)
;        cp      b
;        jr      c,less_half_mines_
;        xor     a       ;ld  a,0
;        ld      (g),a
less_half_mines_:
        ld      a,1
        ld      (y),a
for_y_1tob:
        ld      a,1
        ld      (x),a
for_x_1toa:
;        ld      a,(f)
;        inc     a
;        ld      (f),a
;        ld      hl,3
;        ld      (CURROW),hl
;        ld      l,a
;        bcall(_disphl)
        xor     a       ;ld  a,0
        ld      (e),a
        ld      a,(y)
;        dec     a
        ld      b,a
        ld      a,(x)
;        dec     a
        ld      c,a
        call    get_mat_a
;        ld      c,a
;        ld      a,(g)
;        ld      b,a
;        ld      a,c
        cp      9
        jp      nz,mata_not_g
        ld      a,(y)
        dec     a
        ld      (d),a
for_d_ym1_yp1:
        ld      a,(d)
        or      a       ;cp  0
        jr      nz,d_g_0
        ld      a,1
        ld      (d),a
d_g_0:
        ld      a,(b)
        inc     a
        ld      b,a
        ld      a,(d)
        cp      b
        jp      z,d_g_b
        ld      a,(x)
        dec     a
        ld      (c),a
for_c_xm1_xp1:
        ld      a,(c)
        or      a       ;cp  0
        jr      nz,c_g_0
        ld      a,1
        ld      (c),a
c_g_0:
        ld      a,(y)
        ld      b,a
        ld      a,(d)
        cp      b
        jr      nz,d_not_y_c_not_x
        ld      a,(x)
        ld      b,a
        ld      a,(c)
        cp      b
        jr      nz,d_not_y_c_not_x
        ld      a,(c)
        inc     a
        ld      (c),a
d_not_y_c_not_x:
        ld      a,(a)
        inc     a
        ld      b,a
        ld      a,(c)
        cp      b
        jr      z,c_g_a
;        ld      a,(g)
;        or      a       ;cp  0
;        jr      nz,g_0_else
;        ld      a,(d)
;;        dec     a
;        ld      b,a
;        ld      a,(c)
;;        dec     a
;        ld      c,a
;        call    get_mat_a
;        cp      9
;        jr      nz,mata_not_9
;        ld      a,(e)
;        inc     a
;        ld      (e),a
;mata_not_9:
;        jr      mata_is_9
g_0_else:
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_a
        ld      (temp),a
        cp      9
        jr      z,mata_is_9
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        ld      a,(temp)
        inc     a
        ld      d,a
        call    set_mat_a
mata_is_9:

c_g_a:
        ld      a,(x)
        inc     a
        inc     a
        ld      b,a
        ld      a,(c)
        inc     a
        ld      (c),a
        cp      b
        jp      nz,for_c_xm1_xp1
d_g_b:
        ld      a,(y)
        inc     a
        inc     a
        ld      b,a
        ld      a,(d)
        inc     a
        ld      (d),a
        cp      b
        jp      nz,for_d_ym1_yp1
;        ld      a,(g)
;        or      a       ;cp  0
;        jr      nz,g_not_0_
;        ld      a,(y)
;;        dec     a
;        ld      b,a
;        ld      a,(x)
;;        dec     a
;        ld      c,a
;        ld      a,(e)
;        ld      d,a
;        call    set_mat_a
g_not_0_:
mata_not_g:
        ld      a,(a)
        inc     a
        ld      b,a
        ld      a,(x)
        inc     a
        ld      (x),a
        cp      b
        jp      nz,for_x_1toa
        ld      a,(b)
        inc     a
        ld      b,a
        ld      a,(y)
        inc     a
        ld      (y),a
        cp      b
        jp      nz,for_y_1tob
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      a,(b)
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        ld      (c),a
        ld      a,(a)
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        inc     a
        inc     a
        ld      (d),a
        ld      a,1
        ld      (f),a
for_f_1to6b_6:              ;1 to (c)-6
        ld      a,3
        ld      (e),a
for_e_3to6ap3_6:            ;3 to (d)-6
        call    draw_bracket
        ld      a,(d)
        ld      c,a
        ld      b,6
        ld      a,(e)
        add     a,b
        ld      (e),a
        cp      c
        jr      nz,for_e_3to6ap3_6
        ld      a,(c)
        ld      c,a
        ld      b,6
        ld      a,(f)
        add     a,b
        ld      (f),a
        cp      c
        jr      nz,for_f_1to6b_6
        ld      a,(a)
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        inc     a
        ld      (d),a
        ld      d,a
        ld      c,63
        ld      e,63
        ld      b,1
        bcall(_darkline)
        ld      a,(b)
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        inc     a
        ld      b,a
        ld      a,63
        sub     b
        ld      (c),a       ;(c)=63-(6B-2)     (d)=6A+2
        ld      b,1
        ld      a,(c)
        ld      c,a
        ld      e,a
        ld      a,(d)
        ld      d,a
        bcall(_darkline)
        ld      b,1
        ld      c,63
        ld      d,1
        ld      a,(c)
        ld      e,a
        bcall(_darkline)
        ld      a,(d)
        inc     a
        ld      b,a
        ld      d,a
        ld      c,63
        ld      a,(c)
        ld      e,a
        bcall(_darkline)
        xor     a       ;ld  a,0
        ld      (ol),a
        ld      a,1
        ld      (d),a
for_d_1tob:
        ld      a,1
        ld      (c),a
for_c_1toa:
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_a
        or      a       ;cp  0
        jr      nz,mata_d_c_not_0
        ld      a,1
        ld      (ol),a
        ld      a,(a)
        ld      (c),a
        ld      a,(b)
        ld      (d),a
mata_d_c_not_0:
        ld      a,(a)
        inc     a
        ld      b,a
        ld      a,(c)
        inc     a
        ld      (c),a
        cp      b
        jr      nz,for_c_1toa
        ld      a,(b)
        inc     a
        ld      b,a
        ld      a,(d)
        inc     a
        ld      (d),a
        cp      b
        jr      nz,for_d_1tob
while_mata_d_c_9:
        ld      a,(a)
        ld      b,a
        call    ionRandom
        inc     a
        ld      (c),a
        ld      a,(b)
        ld      b,a
        call    ionRandom
        inc     a
        ld      (d),a
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_a
        cp      9
        jr      z,while_mata_d_c_9
        ld      a,(k)
        cp      3
        jr      nz,k_not_3
        ld      a,(ol)
        cp      1
        jr      nz,k_not_3
while_mata_d_c_not_0:
        ld      a,(a)
        ld      b,a
        call    ionRandom
        inc     a
        ld      (c),a
        ld      a,(b)
        ld      b,a
        call    ionRandom
        inc     a
        ld      (d),a
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_a
        or      a       ;cp  0
        jr      nz,while_mata_d_c_not_0
k_not_3:
        ld      a,(k)
        cp      1
        jr      nz,k_not_1
        ld      a,1
        ld      (c),a
        ld      (d),a
k_not_1:
        xor     a       ;ld  a,0
        ld      (s),a
        ld      (timera),a
        ld      (timerb),a
        ld      (timerct),a
        jp      la
lw:
        ld      a,1
        ld      (d),a
for_d_1tob_:
        ld      a,(d)
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        ld      (f),a
        ld      a,1
        ld      (c),a
for_c_1toa_:
        ld      a,(c)
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        ld      b,2
        add     a,b
        ld      (e),a
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_b
        cp      %10000000
        jr      z,already_flag
        call    get_mat_a
        cp      9
        call    z,draw_flag
already_flag:
        ld      a,(a)
        inc     a
        ld      b,a
        ld      a,(c)
        inc     a
        ld      (c),a
        cp      b
        jr      nz,for_c_1toa_
        ld      a,(b)
        inc     a
        ld      b,a
        ld      a,(d)
        inc     a
        ld      (d),a
        cp      b
        jr      nz,for_d_1tob_
        bcall(_copygbuf)
        call    wait
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_win
        call    draw_inv
        ld      b,4
        call    draw_time
        call    wait
        ld      a,(level)
        cp      4
        jp      nc,oline
        call    get_high        ;Time:  h:l
        ld      a,(timera)
        ld      b,a
        ld      a,h
        cp      b
        jp      c,no_new_high
        jr      nz,new_high
        ld      a,(timerb)
        cp      l
        jp      nc,no_new_high
new_high:
        call    save_high

        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txtnhigh
        call    draw_inv
        bcall(_newline)
        ld      hl,txtinit
        bcall(_puts)
        ld      hl,0207h
        ld      (currow),hl
        ld      hl,txtalpha
        bcall(_puts)
        ld      hl,0005h
        ld      (currow),hl
        ld      ix,highname
        xor     a       ;ld  a,0
        ld      (z),a
        ld      a,(level)
        dec     a
savenameloop:
        or      a       ;cp  0
        jr      z,savenameloop_done
        ld      bc,14
        add     ix,bc
        dec     a
        jr      savenameloop
savenameloop_done:
        inc     ix
        inc     ix
        ld      b,32
        ld      a,14
clrloop:
        ld      (ix),b
        inc     ix
        dec     a
        or      a
        jr      nz,clrloop
        ld      a,14
backtrackloop:
        dec     ix
        dec     a
        or      a       ;cp  0
        jr      nz,backtrackloop
        xor     a
        ld      (ct),a
        ld      b,0
        jr      drawcur
upper_lower:
        ld      a,(z)
        inc     a
        ld      (z),a
        cp      2
        jr      nz,drawcur
        xor     a       ;ld  a,0
        ld      (z),a
        jr      drawcur
enter_name_loop:
        ld      a,(ix)
        ld      (ct),a
        push bc
        bcall(_getK)
        pop bc
        or       a
        jr       z,enter_name_loop
        cp       $38
        jp       z,backup
        cp       $09
        jp       z,nomore
        cp      2
        jp      z,backcur
        ld       c,a
        ld       a,14
        cp       b
        jr       z,enter_name_loop
        ld      a,c
        cp      48
        jr      z,upper_lower
        cp      4
        jp      z,nextchar
        cp      1
        jp      z,prevchar
        cp      3
        jp      z,writechar
        ld       hl,chartable-10
        ld      a,(z)
        or      a       ;cp  0
        jr      z,char_ok
        ld      hl,chartablelower-10
char_ok:
        ld       e,c
        ld       d,0
        add      hl,de
        ld       a,(hl)
writecharret:
        ld       (ix),a
        bcall(_putc)
        inc      b
        inc      ix
        ld      a,14
        cp      b
        jr      z,too_much
        jr      drawcur
too_much:
        ld      hl,CURROW
        inc     (hl)
        ld      hl,CURCOL
        dec     (hl)
        ld      a,32
        bcall(_putc)
        ld      hl,CURROW
        dec     (hl)
        jr      enter_name_loop
drawcur:
        ld      hl,CURROW
        inc     (hl)
        ld      a,(curcol)
        or      a       ;cp  0
        jr      z,curoffscreen
        ld      hl,CURCOL
        dec     (hl)
        ld      a,32
        bcall(_putc)
curoffscreen:
        ld      d,6
        ld      a,(z)
        or      a       ;cp  0
        jr      z,cur_ok
        ld      d,1Eh
cur_ok:
        ld      a,d
        bcall(_putc)
        ld      a,32
        bcall(_putc)
        ld      hl,CURROW
        dec     (hl)
        ld      hl,CURCOL
        dec     (hl)
        dec     (hl)
        jp      enter_name_loop
backup:
        dec      b
        ld       a,255
        cp       b
        jr       z,too_far
        dec      ix
        ld       (ix),32
        ld       hl,CURCOL
        dec      (hl)
        ld       a,32
        bcall(_putc)
        dec      (hl)
        jr      drawcur
too_far: inc      b
        jp       enter_name_loop
nextchar:
        ld      a,(ct)
        inc     a
        ld      (ct),a
        jr      putchar
prevchar:
        ld      a,(ct)
        dec     a
        ld      (ct),a
        jr      putchar
writechar:
        ld      a,(ct)
        jp      writecharret
putchar:
        ld      d,214
        cp      d
        jr      z,badchar
        ld      (ix),a
        bcall(_putc)
        ld      hl,CURCOL
        dec     (hl)
        jr      drawcur
backcur:
        dec     b
        ld       a,255
        cp       b
        jr       z,too_far
        dec     ix
        ld      hl,CURCOL
        dec     (hl)
        ld      a,(ix)
        ld      (ct),a
        jp      drawcur
badchar:
        ld      a,c
        cp      4
        jr      z,nextchar
        jr      prevchar
nomore:
        ld      (highname),ix


no_new_high:
        jp      oline
ll:
        ld      a,1
        ld      (d),a
for_d_1tob_l:
        ld      a,(d)
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        inc     a
        ld      (f),a
        ld      a,1
        ld      (c),a
for_c_1toa_l:
        ld      a,(c)
        dec     a
        ld      b,a
        ld      c,6
        call    mult
        ld      b,3
        add     a,b
        ld      (e),a
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        call    get_mat_a
        ld      (temp),a
        cp      9
        jr      z,mine_spot
        call    get_mat_b
        cp      %10000000
        call    z,draw_bad_flag
mine_spot:
        ld      a,(temp)
        cp      9
        call    z,draw_mine
        ld      a,(a)
        inc     a
        ld      b,a
        ld      a,(c)
        inc     a
        ld      (c),a
        cp      b
        jr      nz,for_c_1toa_l
        ld      a,(b)
        inc     a
        ld      b,a
        ld      a,(d)
        inc     a
        ld      (d),a
        cp      b
        jr      nz,for_d_1tob_l
        bcall(_copygbuf)
        call    wait
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_lose
        call    draw_inv
        ld      b,4
        call    draw_time
        call    wait
        jp      oline
move_left:
        ld      a,(c)
        cp      1
        ret     z
        dec     a
        ld      (c),a
        ld      a,(z)
        ret
move_right:
        ld      a,(a)
        ld      b,a
        ld      a,(c)
        cp      b
        ret     z
        inc     a
        ld      (c),a
        ld      a,(z)
        ret
move_up:
        ld      a,(d)
        cp      1
        ret     z
        dec     a
        ld      (d),a
        ld      a,(z)
        ret
move_down:
        ld      a,(b)
        ld      b,a
        ld      a,(d)
        cp      b
        ret     z
        inc     a
        ld      (d),a
        ld      a,(z)
        ret
wait:
        bcall(_getk)
        cp      9
        jr      nz,wait
        ret
level_left:
        ld      a,b
        cp      3
        ret     nz
        ld      a,(level)
        dec     a
        or      a       ;cp  0
        jr      nz,level_left_ok
        ld      a,1
level_left_ok:
        ld      (level),a
        call    level_draw
        ret
level_right:
        ld      a,b
        cp      3
        ret     nz
        ld      a,(level)
        inc     a
        cp      4
        jr      nz,level_right_ok
        ld      a,3
level_right_ok:
        ld      (level),a
;        call    level_draw
;        ret
level_draw:
        ld      hl,0102h
        ld      (currow),hl
        ld      a,(level)
        cp      3
        jr      z,draw_expert
        cp      2
        jr      z,draw_inter
        ld      hl,txt_levels_begin
        jr      draw_level
draw_inter:
        ld      hl,txt_levels_inter
        jr      draw_level
draw_expert:
        ld      hl,txt_levels_expert
draw_level:
        bcall(_puts)
        call    get_high
        ld      a,h
        ld      (timera),a
        ld      a,l
        ld      (timerb),a
        push    bc
        ld      b,6
        call    draw_time
        call    draw_highname
        pop     bc
        ret
menu_up:
        ld      a,b
        dec     a
        cp      2
        ret     z
        ld      b,a
        call    menu_draw
        ret
menu_down:
        ld      a,b
        inc     a
        cp      6
        ret     z
        ld      b,a
        call    menu_draw
        ret
menu_left:
        ld      a,b
        cp      3
        jr      nz,menu_not_3
        ld      a,(a)
        dec     a
        cp      1
        ret     z
        ld      (a),a
        call    draw_play_menu
        ret
menu_not_3:
        cp      4
        jr      nz,menu_not_4
        ld      a,(b)
        dec     a
        or      a       ;cp  0
        ret     z
        ld      (b),a
        call    draw_play_menu
        ret
menu_not_4:
        ld      a,(m)
        dec     a
        or      a       ;cp  0
        ret     z
        ld      (m),a
        call    draw_play_menu
        ret
menu_right:
        ld      a,b
        cp      3
        jr      nz,menu_not_3_
        ld      a,(a)
        inc     a
        cp      16
        ret     z
        ld      (a),a
        call    draw_play_menu
        ret
menu_not_3_:
        cp      4
        jr      nz,menu_not_4_
        ld      a,(b)
        inc     a
        cp      11
        ret     z
        ld      (b),a
        call    draw_play_menu
        ret
menu_not_4_:
        ld      a,(m)
        inc     a
        ld      (m),a
        call    draw_play_menu
        ret
draw_time:
        ld      h,8
        ld      l,b             ;8,b
        ld      (CURROW),hl
        ld      a,(timerb)
        ld      l,a
        ld      h,0
        bcall(_disphl)
        ld      a,(timerb)
        cp      10
        jr      nc,no_zero_time
        ld      h,7
        ld      l,b             ;7,b
        ld      (CURROW),hl
        ld      hl,0
        bcall(_disphl)
no_zero_time:
        ld      h,10
        ld      l,b             ;10,b
        ld      (CURROW),hl
        ld      hl,txt_colon
        bcall(_puts)
        ld      h,5
        ld      l,b             ;5,b
        ld      (CURROW),hl
        ld      a,(timera)
        ld      l,a
        ld      h,0
        bcall(_disphl)
        ld      h,3
        ld      l,b             ;3,b
        ld      (CURROW),hl
        ld      hl,txt_time
        bcall(_puts)
        ret
menu_draw:
        ld      de,2
menu_draw_loop:
        ld      (CURROW),de
        ld      hl,txt_space
        ld      c,b
        dec     c
        ld      a,e
        cp      c
        jr      nz,menu_draw_space
        ld      hl,txt_menu_pick
menu_draw_space:
        bcall(_puts)
        inc     de
        ld      a,e
        cp      5
        jr      nz,menu_draw_loop
        ret
draw_play_menu:
        push    bc
        ld      a,(a)
        ld      b,a
        ld      a,(b)
        ld      c,a
        call    mult
        ld      b,a
        ld      a,(m)
        cp      b
        jr      c,not_too_many_mines
        ld      a,b
        dec     a
        ld      (m),a
not_too_many_mines:
        ld      hl,2050
        ld      (CURROW),hl
        ld      h,0
        ld      a,(a)
        ld      l,a
        bcall(_disphl)
        ld      hl,2051
        ld      (CURROW),hl
        ld      h,0
        ld      a,(b)
        ld      l,a
        bcall(_disphl)
        ld      hl,2052
        ld      (CURROW),hl
        ld      h,0
        ld      a,(m)
        ld      l,a
        bcall(_disphl)
        pop     bc
        ret
l3_to_l1:
        ld      a,(diml3)
        ld      (diml1),a
        ld      c,0
l3_to_l1_loop:
        call    get_l3
        call    set_l1
        inc     c
        ld      a,c
        cp      50
        jr      nz,l3_to_l1_loop
        call    dim_l1
        ld      (diml1),a
        ret
l4_to_l2:
        ld      a,(diml4)
        ld      (diml2),a
        ld      c,0
l4_to_l2_loop:
        call    get_l4
        call    set_l2
        inc     c
        ld      a,c
        cp      50
        jr      nz,l4_to_l2_loop
        ld      a,(diml1)
        ld      (diml2),a
        ret
dim_l1:
        ld      b,-1
        ld      de,l1
        dec     de
dim_l1_loop:
        inc     b
        inc     de
        ld      a,(de)
        or      a       ;cp  0
        jr      nz,dim_l1_loop
        ld      a,b
        ret
;dim_l3:
;        ld      b,-1
;        ld      de,l3
;        dec     de
;dim_l3_loop:
;        inc     b
;        inc     de
;        ld      a,(de)
;        or      a       ;cp  0
;        jr      nz,dim_l3_loop
;        ld      a,b
;        ret
clr_l1:
        xor     a       ;ld  a,0
        ld      (diml1),a
        ld      hl,l1
        ld      b,a
        ld      a,50
        jr      clr_list
;clr_l1_loop:
;        ld      (hl),b
;        inc     hl
;        dec     a
;        or      a       ;cp  0
;        jr      nz,clr_l1_loop
;        ret
clr_l2:
        xor     a       ;ld  a,0
        ld      (diml2),a
        ld      hl,l2
        ld      b,a
        ld      a,50
        jr      clr_list
;clr_l2_loop:
;        ld      (hl),b
;        inc     hl
;        dec     a
;        or      a       ;cp  0
;        jr      nz,clr_l2_loop
;        ret
clr_l3:
        xor     a       ;ld  a,0
        ld      (diml3),a
        ld      hl,l3
        ld      b,a
        ld      a,50
        jr      clr_list
;clr_l3_loop:
;        ld      (hl),b
;        inc     hl
;        dec     a
;        or      a       ;cp  0
;        jr      nz,clr_l3_loop
;        ret
clr_l4:
        xor     a       ;ld  a,0
        ld      (diml4),a
        ld      hl,l4
        ld      b,a
        ld      a,50
clr_list:
        ld      (hl),b
        inc     hl
        dec     a
        or      a       ;cp  0
        jr      nz,clr_list
        ret
;clr_l4_loop:
;        ld      (hl),b
;        inc     hl
;        dec     a
;        or      a       ;cp  0
;        jr      nz,clr_l4_loop
;        ret
get_l1:
        ld      hl,l1
        jr      get_list
get_l2:
        ld      hl,l2
        jr      get_list
get_l3:
        ld      hl,l3
        jr      get_list
get_l4:
        ld      hl,l4
get_list:
        ld      b,0
        add     hl,bc
        dec     hl
        ld      a,(hl)
        ret
keep_dim_check:
        ld      b,(hl)
        ld      a,c
        cp      b
        jr      c,keep_dim
        inc     b
        ld      (hl),b
        ret
keep_dim:
        ld      (hl),b
        ret
set_l1:
        push    af
        ld      hl,diml1
        call    keep_dim_check
;        ld      b,a
;        ld      a,c
;        cp      b
;        jr      c,keep_dim_1
;        ld      a,b
;        inc     a
;        ld      (diml1),a
;keep_dim_1:
        pop     af
        ld      hl,l1
        jr      set_list
;        ld      b,0
;        add     hl,bc
;        dec     hl
;        ld      (hl),a
;        ret
set_l2:
        push    af
        ld      hl,diml2
        call    keep_dim_check
;        ld      b,a
;        ld      a,c
;        cp      b
;        jr      c,keep_dim_2
;        ld      a,b
;        inc     a
;        ld      (diml2),a
;keep_dim_2:
        pop     af
        ld      hl,l2
        jr      set_list
;        ld      b,0
;        add     hl,bc
;        dec     hl
;        ld      (hl),a
;        ret
set_l3:
        push    af
        ld      hl,diml3
        call    keep_dim_check
;        ld      b,a
;        ld      a,c
;        cp      b
;        jr      c,keep_dim_3
;        ld      a,b
;        inc     a
;        ld      (diml3),a
;keep_dim_3:
        pop     af
        ld      hl,l3
        jr      set_list
;        ld      b,0
;        add     hl,bc
;        dec     hl
;        ld      (hl),a
;        ret
set_l4:
        push    af
        ld      hl,diml4
        call    keep_dim_check
;        ld      b,a
;        ld      a,c
;        cp      b
;        jr      z,keep_dim_4
;        ld      a,b
;        inc     a
;        ld      (diml4),a
;keep_dim_4:
        pop     af
        ld      hl,l4
;        ld      b,0
;        add     hl,bc
;        dec     hl
;        ld      (hl),a
;        ret
set_list:
        ld      b,0
        add     hl,bc
        dec     hl
        ld      (hl),a
        ret
draw_cursor:
        ld      a,(f)
        ld      l,a
        ld      a,(e)
        ld      b,7
        ld      ix,spr_cursor
        call    ionPutSprite
        ret
draw_flag:
        ld      a,(f)
        ld      l,a
        ld      a,(e)
        ld      b,6
        ld      ix,spr_flag
        call    ionPutSprite
        ret
draw_bracket:
        ld      a,(f)
        ld      l,a
        ld      a,(e)
        ld      b,6
        ld      ix,spr_bracket
        call    ionPutSprite
        ret
draw_mine:
        call    draw_bracket
        ld      a,(d)
;        dec     a
        ld      b,a
        ld      a,(c)
;        dec     a
        ld      c,a
        ld      ix,spr_mine_flag
        call    get_mat_b
        cp      %10000000
        jr      z,flagged
;        ld      a,(e)
;        dec     a
;        ld      (e),a
;        call    z,draw_flag
;        ld      a,(e)
;        inc     a
;        ld      (e),a
        ld      ix,spr_mine
flagged:
        ld      a,(f)
        ld      l,a
        ld      a,(e)
        ld      b,6
        call    ionPutSprite
        ret
draw_bad_flag:
        ld      a,(f)
        ld      b,3
        add     a,b
        ld      l,a
        ld      a,(e)
        ld      b,1
        ld      ix,spr_bad_flag
        call    ionPutSprite
        ret
draw_n:
        ld      a,(n)
        ld      ix,spr_1
        dec     a
        ld      b,a
        ld      c,5
        push    de
        call    mult
        pop     de
        ld      b,0
        ld      c,a
;draw_n_loop:
        add     ix,bc
;        dec     a
;        or      a       ;cp  0
;        jr      nz,draw_n_loop
        ld      a,e
        inc     a
        ld      l,a
        ld      a,d
        inc     a
        ld      b,5
        call    ionPutSprite
        ret
mult:                       ;find b*c, where b and c are integers and Ans<256, return is: a
        ld      a,b
        or      a       ;cp  0
        ret     z
        ld      a,c
        or      a       ;cp  0
        ret     z
;        xor     a       ;ld  a,0
        ld      d,0
mult_loop:
        ld      a,d
        add     a,c
        ld      d,a
        ld      a,b
        dec     a
        or      a       ;cp  0
        ld      b,a
        jr      nz,mult_loop
        ld      a,d
        ret
fill_mat_a:
        ld      hl,ma
        ld      a,160
fill_mat_a_loop:
        ld      (hl),b
        inc     hl
        dec     a
        or      a       ;cp  0
        jr      nz,fill_mat_a_loop
        ret
fill_mat_b:
        ld      hl,mb
        ld      a,160
fill_mat_b_loop:
        ld      (hl),b
        inc     hl
        dec     a
        or      a       ;cp  0
        jr      nz,fill_mat_b_loop
        ret
get_mat_a:
        ld      hl,ma
get_mat:
        ld      a,b
        dec     a
        sla     a
        sla     a
        sla     a
        sla     a
        add     a,c
        dec     a
        ld      e,a
        ld      d,0
        add     hl,de
        ld      a,(hl)
        ret
get_mat_b:
        ld      hl,mb
        jr      get_mat
set_mat_a:
        ld      hl,ma
set_mat:
        ld      a,b
        dec     a
        sla     a
        sla     a
        sla     a
        sla     a
        add     a,c
        dec     a
        ld      b,d
        ld      e,a
        ld      d,0
        add     hl,de
        ld      a,b
        ld      (hl),a
        ret
set_mat_b:
        ld      hl,mb
        jr      set_mat
draw_inv:
        set     textInverse,(IY+textflags)
        bcall(_puts)
        res     textInverse,(IY+textflags)
        ret
off:    ld      a,1
        out     (3),a
        ei
        halt
back:   jp      ls
draw_highname:
        ld      hl,highname
        ld      a,(level)
        dec     a
get_highname_loop:
        or      a       ;cp  0
        jr      z,get_highname_loop_done
        ld      bc,14
        add     hl,bc
        dec     a
        jr      get_highname_loop
get_highname_loop_done:
        ld      d,h
        ld      e,l
        inc     de
        inc     de
        ld      hl,0107h
        ld      (currow),hl
        ld      a,14
draw_highname_loop:
        push    af
        ld      a,(de)
        bcall(_putc)
        inc     de
        pop     af
        dec     a
        or      a       ;cp  0
        jr      nz,draw_highname_loop
        ret
get_high:
        ld      de,highsc
        ld      a,(level)
        dec     a
get_high_loop:
        or      a       ;cp  0
        jr      z,get_high_loop_done
        inc     de
        inc     de
        dec     a
        jr      get_high_loop
get_high_loop_done:
        ld      a,(de)
        ld      h,a
        inc     de
        ld      a,(de)
        ld      l,a
        ret
save_high:
        ld      a,(timera)
        ld      h,a
        ld      a,(timerb)
        ld      l,a
        ld      de,highsc
        ld      a,(level)
        dec     a
save_high_loop:
        or      a       ;cp  0
        jr      z,save_high_loop_done
        inc     de
        inc     de
        dec     a
        jr      save_high_loop
save_high_loop_done:
        ld      a,h
        ld      (de),a
        inc     de
        ld      a,l
        ld      (de),a
        ret
spr_cursor:                 ;(8 x 7) 7 x 7 cursor
        .db %11111110
        .db %10000010
        .db %10000010
        .db %10000010
        .db %10000010
        .db %10000010
        .db %11111110
spr_bracket:                ;(8 x 6) 5 x 5: [] ,for spaces
        .db %00000000
        .db %11011000
        .db %10001000
        .db %10001000
        .db %10001000
        .db %11011000
spr_flag:                   ;(8 x 6) 1 x 5 line for flags
        .db %00000000
        .db %00010000
        .db %00010000
        .db %00010000
        .db %00010000
        .db %00010000
spr_mine:                   ;(8 x 6) 5 x 5: * ,mine (when lose)
        .db %00000000
        .db %00100000
        .db %10101000
        .db %01110000
        .db %10101000
        .db %00100000
spr_mine_flag:              ;(8 x 6) 5 x 5: * ,mine (when lose and is already flagged)
        .db %00000000
        .db %00000000
        .db %10001000
        .db %01010000
        .db %10001000
        .db %00000000
spr_bad_flag:
        .db %01110000       ;(8 x 1) 4 x 1: mark wrong flags
spr_1:
        .db %01000000
        .db %11000000
        .db %01000000
        .db %01000000
        .db %11100000
spr_2:
        .db %11000000
        .db %00100000
        .db %01000000
        .db %10000000
        .db %11100000
spr_3:
        .db %11000000
        .db %00100000
        .db %01000000
        .db %00100000
        .db %11000000
spr_4:
        .db %10000000
        .db %10100000
        .db %11100000
        .db %00100000
        .db %00100000
spr_5:
        .db %11100000
        .db %10000000
        .db %11000000
        .db %00100000
        .db %11000000
spr_6:
        .db %01100000
        .db %10000000
        .db %11100000
        .db %10100000
        .db %11100000
spr_7:
        .db %11100000
        .db %00100000
        .db %01000000
        .db %10000000
        .db %10000000
spr_8:
        .db %11100000
        .db %10100000
        .db %11100000
        .db %10100000
        .db %11100000
txt_mine_sweeper:
        .db "- MINESWEEPER! -",0
txt_name:
        .db "   R. Bolyard",0
txt_site:
        .db "phantom.bigsitecity.com"
txt_menu:
        .db "  Play          "
        .db "  Options       "
        .db "  Quit",0
txt_levels_menu:
        .db "  Custom        "
        .db "  Reset Scores",0
txt_levels_begin:
        .db " Beginner"         ;207d left arrow, 05h right arrow
        .db 05h
        .db "    ",0
txt_levels_inter:
        .db 207d
        .db "Intermediate"
        .db 05h,0
txt_levels_expert:
        .db 207d
        .db "Expert       ",0
txt_play_menu:
        .db "  X dim:        "
        .db "  Y dim:        "
        .db "  Mines:",0
txt_options_cursor:
        .db "  Cursor Start  ",0
txt_options_menu:
        .db "  Upper Left    "
        .db "  Non-Mine Spot "
        .db "  Blank Spot",0
txt_stats_menu:
        .db "  Continue      "
        .db "  Calc off      "
        .db "  Quit",0
txt_flags:
        .db "Flags:",0
txt_slash:
        .db "/",0
txt_time:
        .db "Time:",0
txt_colon:
        .db ":",0
txt_menu_pick:      ;a filled in arrow (character 5)
        .db "",0
txt_space:
        .db " ",0
;txt_placing:
;        .db "Placing mines...",0
;txt_numbering:
;        .db "  Numbering...  ",0
txt_wait:
        .db "Please wait...",0
txt_win:
        .db "*** YOU WIN! ***",0
txt_lose:
        .db "--- YOU LOSE ---",0
txtnhigh:
        .db     "-New High Score-",0
txtinit:
        .db     "  Please enter  "
        .db     "   your name:   ",0
txtalpha:
        .db     "ALPHA - caps",0
txt_you_sure:
        .db "  Are you sure  "
        .db "  you want to   "
        .db " reset all high "
        .db "    scores?     "
        .db "                "
        .db "  Press Y or N ",0
chartable:
         .db      "'WRMH_"
         .DB      ".-[VQLG"
         .DB      00h
         .DB      "..ZUPKFC"
         .DB      "@ YTOJEBX.XSNIDA"
         .DB      ".54321!#"
chartablelower:
        .db     22h
        .db     "wrmh_"
        .db     ".?[vqlg"
        .db     00h
        .db     ".:zupkfc"
        .db     "@ ytojebx.xsnida"
        .db     ".09876!#"

highsc:
        .dw     3B3Bh   ;59:59
        .dw     3B3Bh   ;59:59
        .dw     3B3Bh   ;59:59
highname:
        .dw     2020h

        .dw     2020h
        .dw     6E41h
        .dw     6E6Fh
        .dw     6D79h
        .dw     756Fh
        .dw     2073h
        .dw     2020h

        .dw     2020h
        .dw     6E41h
        .dw     6E6Fh
        .dw     6D79h
        .dw     756Fh
        .dw     2073h
        .dw     2020h

        .dw     2020h
        .dw     6E41h
        .dw     6E6Fh
        .dw     6D79h
        .dw     756Fh
        .dw     2073h
        .dw     2020h
highnamereset:
;        .dw     2020h

        .dw     2020h
        .dw     6E41h
        .dw     6E6Fh
        .dw     6D79h
        .dw     756Fh
        .dw     2073h
        .dw     2020h

;        .dw     2020h
;        .dw     6E41h
;        .dw     6E6Fh
;        .dw     6D79h
;        .dw     756Fh
;        .dw     2073h
;        .dw     2020h

;        .dw     2020h
;        .dw     6E41h
;        .dw     6E6Fh
;        .dw     6D79h
;        .dw     756Fh
;        .dw     2073h
;        .dw     2020h
.end
END
;eof ---DO NOT WRITE PAST THIS POINT---
