;--------------------------------------------------------------------
;			 MINEFIELDS v1.0	
;	Copyright(C)1999 Thomas Bladh (tiberius@swipnet.se)
;--------------------------------------------------------------------	
; This is the source to the game Minefields for the TI86. Most of 
; it is commented. If you don't understand my comments or think
; that i comment way too much, then thats because it's my comments.
; I didn't have unlimited time to write this, so some comments might
; be wrong. Some code might also not be optimal, all i know is that
; it works.
;
; The copyright notice means that i have all the rights to this
; material and that i can let people use it providing that they 
; follow the rules. The rules are: Feel free to look at and copy
; parts of the code or whole subroutines, like the sprite, display,
; and string input routines. Don't copy the whole game, change the
; strings and call it your own. A reason for letting people look at
; the code and maybe copy some routines is that it is a way to
; learn. Another is that a few routines were not originally my 
; ideas, they were published by others. I have named the original
; authors in the routine headers in these cases.
;
; Some terminology i use to make it easier to read (for me):
;
; SUB_my_sub:		- allmost all subroutines are named this way
;
; LBL_my_sub_0:	(0,1,2)	- allmost all labels in subroutines are named  
;                         this way
;
; I am not a guru z80 asm programmer, because of this i don't always
; write perfect routines ;), i usually get them to do the jobb but
; they may be somewhat large or slow. If you see something that i 
; don't or know a better way of doing something please let me know,
; send me an e-mail (tiberius@swipnet.se).
;
; Thomas Bladh January 2, 1999
;--------------------------------------------------------------------

#include "asm86.h"       
#include "ti86asm.inc"
#include "ti86math.inc"
#include "ti86ops.inc"
#include "ti86abs.inc"

_HLdiv10        .equ    $4044
map_image	.equ	$C0F9		; _textShadow 21*8=168 bytes, 112 needed

; offset of a screen page, 256*(192+41) = 59648 (E900h) 
; $E900 - $D748 = 4536 bytes into _asm_exec_ram
; keep program < 4536 bytes
VID_LOC1 = 41			; screen offset 1 for grayscale (normal is 60)
VID_LOC2 = VID_LOC1 + 4		; screen offset 2
DATA_ZONE	.equ	256*(192+VID_LOC1)	; 256*(192+41) = 59648 ($E900)

LIFE_VALUE	.equ	8
GEM_BONUS	.equ	8
MAP_BONUS	.equ	16
LIVES		.equ	9
MINEV_REPS	.equ	3158
WALK_PITCH	.equ	15
WALK_DURATION	.equ	70

        .org _asm_exec_ram         

;--------------------Ashell Program description--------------------
        nop
        jp      start
.dw     $0000
.dw     Title
;------------------------------------------------------------------
start:
        call    _runindicoff            ; turn of busy indicator
	;------------------------------
	; decompress and view the intro
	;------------------------------
	ld	hl,PIC_DATA		;  HL = pointer to compressed information
	ld	de,DATA_ZONE		;  DE = pointer to where to put decompressed information
	call	SUB_decompress		;  decompress image data
	call	SUB_gray_view		;  view the grayscale
	;------------------------------
	; decompress the maps
	;------------------------------
	ld	hl,MAP_DATA		;  HL = pointer to compressed information
	ld	de,DATA_ZONE		;  DE = pointer to where to put decompressed information
	call	SUB_decompress		;  decompress map data
	xor	a			; zero soundflag (disable sound)
	ld	(sound_flag),a		; ----------||---------
NO_HIGH:


TITLE:
        call    _clrLCD                 ; clear the LCD
        ld	hl,0			; zero hl
	ld      (score),hl              ; zero the score
        call    SUB_display_title	; display the title screen
	xor	a
	ld	(menu_pos),a		; set menu_pos to a (0)
;-------------------------------------------------------------------
; menu handling
;-------------------------------------------------------------------
WAIT_MENU:
	call	SUB_menu_select		; draw the select icon
KEY_NONE:
	call	SUB_soundcheck
	call    _getky                 	; get keypress in a
        cp	K_NOKEY			; compare to no key
	jp	z,KEY_NONE		; if equal then jump
	cp      K_EXIT                  ; compare keypress to Exit
        jp      z,PROG_EXIT             ; if equal then jump
        cp      K_ENTER                 ; compare keypress to Enter
        jp      z,ITEM_SELECTED       	; if equal then jump
	cp	K_SECOND		; compare keypress to [2nd]
	jp      z,ITEM_SELECTED       	; if equal then jump
	cp	K_UP			; compare keypress to Up 
	jp	z,MENU_UP		; if equal then jump
	cp	K_DOWN			; compare keypress to Down
	jp	z,MENU_DN		; jump if equal
	cp	K_F1			; compare keypress to F1
	call	z,SUB_soundstate	; jump if equal
	cp	K_PLUS			; compare to K_PLUS
	call	z,SUB_contrast_up	; if equal then call (raise the contrast)
	cp	K_MINUS			; compare to K_MINUS
	call	z,SUB_contrast_down	; if equal then call (lower the contrast)
        jp	KEY_NONE      
	;WAIT_MENU               ; else do it again
	;-------------------------------
	; if key pressed was up arrow
	;-------------------------------
MENU_UP:
	call	SUB_walk_sound
	call 	SUB_menu_deselect	; deselect previous menu item
	ld	a,(menu_pos)		; load a with menu_pos
	cp	0			; compare a to 0
	jr	nz,MENU_UP_NORM		; jump if not equal
	ld	a,3			; load a with 3
MENU_UP_NORM:
	dec	a			; decrease a
	ld	(menu_pos),a		; set menu_pos to a
	jp	WAIT_MENU		; return to menu loop
	;-------------------------------
	; if key pressed was down arrow
	;-------------------------------
MENU_DN:
	call	SUB_walk_sound
	call 	SUB_menu_deselect	; deselect previous menu item
	ld	a,(menu_pos)		; load a with menu_pos
	cp	2			; compare a to 2
	jr	nz,MENU_DN_NORM		; jump if not equal
	ld	a,255			; set a to 255 (-1)
MENU_DN_NORM:
	inc	a			; increase a
	ld	(menu_pos),a		; set menu pos to value in a
	jp	WAIT_MENU		; return to the menu loop
	;--------------------------------
	; if key pressed was Enter or 2nd
	;--------------------------------
ITEM_SELECTED:
	ld	a,(menu_pos)		; load a with menu_pos
	cp	2			; compare to 2 (EXIT)
	jp	z,PROG_EXIT		; jump if equal
	cp	1			; compare to 1 (HIGHSCORE)
	jp	z,WAIT_MENU		; jump if equal
	;--------------------------------
	; if the above was not satisfied
	; it defaults to program start
	;--------------------------------
	call	SUB_happy_sound

	;xor	a			; zero the mineview flag
	;ld	(minev_flag),a		; ----------||---------

        ld	hl,0			; zero hl
	ld	(minev_counter),hl	; 
	xor	a	                ; set map to use
        ld      (map_nr),a              ; ------||------
        ld      a,LIVES		        ; set number of lives to 9
        ld      (fig_lives),a           ; ------||------

restart:

	xor	a
	ld	(minev_flag),a

        call	SUB_load_next_map	; load next map
	call    SUB_map_init            ; draw map
restart_not_map:
	call	SUB_black_top		; draw the black bar
	call	SUB_update_stats        ; update statusbar
        ld      a,15                    ; set fig startpos to (15,7)
        ld      (fig_xpos),a            ; ------||------
        ld      a,7                     ; ------||------
        ld      (fig_ypos),a            ; ------||------
	call    SUB_fig_draw            ; draw the figure
;-----------------------------------------------------------------
;MAIN LOOP 
;-----------------------------------------------------------------
MAIN_LOOP:
	call	SUB_minev_countdown
        ld      a,(fig_xpos)            ; load a with fig_xpos
        ld      c,a                     ; load c with a
        ld      a,(fig_ypos)            ; load a with fig_ypos
        ld      b,a                     ; load b with a
        call    SUB_get_map_xy          ; check map for walls, mines...        
        cp      0                       ; compare to grass
        jp      z,just_grass            ; if equal jump
        cp      2                       ; compare to 2 (exit)
        jp      nz,not_it00             ; if not equal then jump
        call    SUB_step_on_exit        ; else change next level
        ld      a,(map_nr)		; load a with map_nr
        cp      16			; check if 16
        jp      z,WINNER		; if so we have a winner
        jp      restart                 ; restart and goto next level
not_it00:
        cp      3                       ; compare to 3 (mine)
        jp      nz,not_it01             ; if not equal then jump
        call    SUB_step_on_mine        ; else is dead
        ld      a,(fig_lives)           ; load a with lives left
        cp      0                       ; compare to 0
        jp      z,LOOSER	        ; if equal GAME OVER !!
        jp      restart_not_map         ; else restart
not_it01:
        cp      4                       ; compare to 4 (bonus)
        jp      nz,just_grass           ; jump if not equal
        call    SUB_score_bonus         ; else call sub
just_grass:
        call    SUB_mine_warning        ; warn player of mines
        call    GET_KEY                 ; get keypress in a
        cp      K_RIGHT                 ; compare keypress to kRight
        jp      z,SUB_walk_right        ; if equal then jump (walk right)
        cp      K_LEFT                  ; compare keypress to kLeft
        jp      z,SUB_walk_left         ; if equal then jump (walk left)
        cp      K_UP                    ; compare keypress to kUp
        jp      z,SUB_walk_up           ; if equal then jump (walk up)
        cp      K_DOWN                  ; compare keypress to kDown
        jp      z,SUB_walk_down         ; if equal then jump (walk down)
	cp	K_CLEAR			; compare to K_CLEAR
	jp	z,SUB_minev_init	; if equal then jump (activate mineview)
	cp	K_F1			; compare keypress to F1
	call	z,SUB_soundstate	; jump if equal
	cp	K_PLUS			; compare to K_PLUS
	call	z,SUB_contrast_up	; if equal then jump (raise the contrast)
	cp	K_MINUS			; compare to K_MINUS
	call	z,SUB_contrast_down	; if equal then call (lower the contrast)
	cp      K_EXIT                  ; compare keypress to kExit
        jp      z,TITLE		        ; if equal then call (exit)
;------------------------------------------
; Development only             (level skip)
;------------------------------------------
;        cp      K_RAISE
;        jp      nz,no_level_skip
;        call    SUB_step_on_exit
;        jp      restart
;no_level_skip:
;------------------------------------------
	jp      MAIN_LOOP               ; jump (main_loop)
LOOSER:
	call    SUB_disp_over		; display game over info
        jp      TITLE			; return to title screen (menu)
WINNER:
        call    SUB_disp_win		; display winner info
	jp	TITLE			; return to title screen (menu)
PROG_EXIT:
	;-------------------------------
	; This routine was made by 
	; Jimmy Mrdell
	;-------------------------------
	; Save the highscore to the 
	; program var
	;-------------------------------
	ld	hl,PROG_NAME		; load hl with adress of data
	rst	20h			; reset ?
	rst	10h			; reset ?
	ex	de,hl			; exchange de and hl
	ld	a,b			; load a with b
	ld	de,HIGHSCORE-$D748+4	; set de to distance from program start?
	add	hl,de			; add de to hl (hl=program var offset ??)
	adc	a,0			; add with carry 0 to a	
	ld	de,HIGHSCORE	; set de to HIGHSCORE offset
	ld	b,13			; load into b # of bytes HIGHSCORE is 
HIGHCOPY:
	push	af			; preserve af
	push	hl			; preserve hl
	call	$46C3			; call rom routine
	ld	a,(de)			; load byte from de into a
	ld	(hl),a			; copy byte into memory at hl
	pop	hl			; restore hl
	pop	af			; restore af
	call	$4637			; call rom routine
	inc	de			; increase de
	djnz	HIGHCOPY		; repeat until b=0
	;-------------------------------
	; Clear the text shadow
	;-------------------------------
	ld      hl,$C0F9                ; it's our mess, we clean it up
        ld      de,$C0FA                ; ----------||----------
        ld      (hl),$20                ; fill area with ascii space
        ld      bc,$A7                  ; ----------||----------
        ldir                            ; do it
	;-------------------------------
	; End the game
	;-------------------------------
	call	SUB_sad_sound
        call    _clrLCD                 ; clear the LCD
        ret                             ; return to ti-os
;-----------------------------------------------------------------
;WALK RIGHT
;-----------------------------------------------------------------
SUB_walk_right:
        ld      a,(fig_xpos)            ; load a with pos to change
        inc     a                       ; change it
        cp      16                      ; compare pos to max+1
        jp      z,LBL_walk_right_1      ; if equal then jump (no movement)
        ld      c,a                     ; load c with a
        ld      a,(fig_ypos)            ; load a with pos
        ld      b,a                     ; load b with a (pos)
        call    SUB_get_map_xy          ; check map for walls, mines...
        cp      1                       ; compare to wall
        jp      z,LBL_walk_right_1      ; if equal then jump (no movement)
	cp	5			; compare to toombstone
        jp      z,LBL_walk_right_1      ; if equal then jump (no movement)
	call    SUB_fig_erase           ; erase previous figure
	ld      a,c                     ; load a with c (pos)
        ld      (fig_xpos),a            ; uppdate position
	ld	a,1			; set fig direction to 1=right
	ld	(fig_dir),a		; ----------||---------
	call	SUB_fig_draw		; draw the figure
LBL_walk_right_1:
	call	SUB_walk_sound
        jp      MAIN_LOOP               ; return to main loop
;-----------------------------------------------------------------
;WALK LEFT
;-----------------------------------------------------------------
SUB_walk_left:
        ld      a,(fig_xpos)            ; load a with pos to change
        cp      0                       ; compare pos to min
        jp      z,LBL_walk_left_1       ; if equal then jump (no movement)
        dec     a                       ; change it
        ld      c,a                     ; load c with a
        ld      a,(fig_ypos)            ; load a with pos
        ld      b,a                     ; load b with a (pos)
        call    SUB_get_map_xy          ; check map for walls, mines...
        cp      1                       ; compare to wall
        jp      z,LBL_walk_left_1       ; if equal then jump (no movement)
	cp	5			; compare to toombstone
        jp      z,LBL_walk_left_1       ; if equal then jump (no movement)
	call    SUB_fig_erase           ; erase previous figure
        ld      a,c                     ; load a with c (pos)
        ld      (fig_xpos),a            ; uppdate position
	ld	a,2			; set fig direction to 2=left
	ld	(fig_dir),a		; ----------||---------
	call    SUB_fig_draw            ; draw the figure
LBL_walk_left_1:
	call	SUB_walk_sound
	jp      MAIN_LOOP               ; return to main loop        
;-----------------------------------------------------------------
;WALK UP
;-----------------------------------------------------------------
SUB_walk_up:
        ld      a,(fig_ypos)            ; load a with pos to change
        cp      1                       ; compare pos to min
        jp      z,LBL_walk_up_1         ; if equal then jump (no movement)
        dec     a                       ; change it
        ld      b,a                     ; load b with a
        ld      a,(fig_xpos)            ; load a with pos
        ld      c,a                     ; load c with a (pos)
        call    SUB_get_map_xy          ; check map for walls, mines...
        cp      1                       ; compare to wall
        jp      z,LBL_walk_up_1         ; if equal then jump (no movement)
	cp	5			; compare to toombstone
        jp      z,LBL_walk_up_1         ; if equal then jump (no movement)
	call    SUB_fig_erase           ; erase previous figure
        ld      a,b                     ; load a with b (pos)
        ld      (fig_ypos),a            ; uppdate position
	xor	a			; set fig direction to 0=up/down
	ld	(fig_dir),a		; ----------||---------
	call    SUB_fig_draw            ; draw the figure
LBL_walk_up_1:
	call	SUB_walk_sound
        jp      MAIN_LOOP               ; return to main loop
;-----------------------------------------------------------------
;WALK DOWN
;-----------------------------------------------------------------
SUB_walk_down:                          
        ld      a,(fig_ypos)            ; load a with pos to change
        inc     a                       ; change it
        cp      8                       ; compare pos to max+1
        jp      z,LBL_walk_down_1       ; if equal then jump (no movement)
        ld      b,a                     ; load b with a
        ld      a,(fig_xpos)            ; load a with pos
        ld      c,a                     ; load c with a (pos)
        call    SUB_get_map_xy          ; check map for walls, mines...
        cp      1                       ; compare to wall
        jp      z,LBL_walk_down_1       ; if equal then jump (no movement)
	cp	5			; compare to toombstone
        jp      z,LBL_walk_down_1	; if equal then jump (no movement)
	call    SUB_fig_erase           ; erase previous figure
        ld      a,b                     ; load a with b (pos)
        ld      (fig_ypos),a            ; uppdate position
	xor	a			; set fig direction to 0=up/down
	ld	(fig_dir),a		; ----------||---------
	call    SUB_fig_draw            ; draw the figure
LBL_walk_down_1:
	call	SUB_walk_sound
        jp      MAIN_LOOP               ; return to main loop

;-----------------------------------------------------------------
; SUB_soundstate - toggle sound on/off 
;-----------------------------------------------------------------
SUB_soundstate:
	ld	a,(sound_flag)	
	cp	1
	jp	z,LBL_soundstate_0	
	inc	a			; set a to 1
	ld	(sound_flag),a
	xor	a
	ret
LBL_soundstate_0:
	xor	a
	ld	(sound_flag),a
	xor	a			; zero a
	ret
;-----------------------------------------------------------------
; SUB_soundcheck - display speaker icon on title screen 
;-----------------------------------------------------------------
SUB_soundcheck:
	ld	a,(sound_flag)	
	cp	1
	jp	z,LBL_soundcheck_0	
	ld	de,sprite_7
        ld      b,0                     ; clear previous score
        ld      c,15		        ; ---------||---------
        call    SUB_putsprite_8         ; ---------||---------
	ret
LBL_soundcheck_0
	ld	de,sprite_10
        ld      b,0                     ; clear previous score
        ld      c,15		        ; ---------||---------
        call    SUB_putsprite_8         ; ---------||---------
	ret
;-----------------------------------------------------------------
; SUB_minev_init - initiate the mineview
;-----------------------------------------------------------------
SUB_minev_init:
	;---------------------------------------
	; check if mineview is already on
	;---------------------------------------
	ld	a,(minev_flag)		; load a with flag byte
	cp	0			; compare to 0
	jp	nz,MAIN_LOOP		; if not zero (mineview is on) then return
	;---------------------------------------
	; check if player has enough points
	;---------------------------------------
	ld	hl, (score)		; load the score into hl
	ld	a,h			; load a with high order byte of hl
	cp	0			; compare to 0
	jr	nz,LBL_minev_init_0	; if not zero then it is obviously > cost
	ld	a,l			; load a with low order byte hl (score)
	cp	64			; compare to cost of mineview
	jp	c,MAIN_LOOP		; if a is < than cost then you can't aford it
LBL_minev_init_0:
	;---------------------------------------
	; player pays the price (-64)
	;---------------------------------------
	ld	de,64
	or      a                       ; sub de from hl
        sbc     hl,de                   ; -------||------
	ld	(score),hl		; load the new score from hl
	call	SUB_disp_score		; display it
	;---------------------------------------
	; mineview is on
	;---------------------------------------
	ld	a,1			; set a to 1
	ld	(minev_flag),a		; set mineview flag to 1
	ld	de,sprite_11		; load offset of sprite into de (warning)
	call	SUB_set_mines		; view the mines
	jp	MAIN_LOOP		; return to keycheck loop
;-----------------------------------------------------------------
; SUB_minev_countdown - countdown routine for the mineview
;-----------------------------------------------------------------
SUB_minev_countdown:
	ld	a,(minev_flag)		; load a with flag byte
	cp	1			; compare to 1
	ret	nz			; return if not equal
	ld	hl,(minev_counter)	; load the counter value into hl
	inc	hl			; increase the hl
	ld	(minev_counter),hl	; load counter with new value
	ld	de,MINEV_REPS		; load de with number of reps
	call	SUB_cphlde		; compare hl with de
	ret	nz			; return if not zero
	ld	de,sprite_2		; load offset of sprite into de (grass)
	call	SUB_set_mines		; hide the mines
        ld	hl,0			; zero hl
	ld	(minev_counter),hl	; 
	xor	a			; reset the flag 
	ld	(minev_flag),a		; --------||-------
	ret				; return
;-----------------------------------------------------------------
; SUB_contrast_up
;-----------------------------------------------------------------
SUB_contrast_up:
        ld      a,($C008)
        cp      31
        jp      nz,LBL_contrast_up_0
        ret
LBL_contrast_up_0:
        inc     a
        ld      ($C008),a
        out     (2),a
	xor	a
        ret
;-----------------------------------------------------------------
; SUB_contrast_down
;-----------------------------------------------------------------
SUB_contrast_down:
        ld      a,($C008)
        cp      0
        jp      nz,LBL_contrast_down_0
        ret
LBL_contrast_down_0:
        dec     a
        ld      ($C008),a
        out     (2),a
	xor	a
        ret

;-----------------------------------------------------------------
;SUB_fig_erase - erases the figure
;-----------------------------------------------------------------
SUB_fig_erase:
	push	bc
        ld      de,sprite_2             ; grass sprite
        ld      a,(fig_ypos)            ; y_value
        ld      b,a                     ; load b with a (ypos)
        ld      a,(fig_xpos)            ; x_value
        ld      c,a                     ; load c with a (xpos)
        call    SUB_putsprite_8         ; put the sprite
	pop	bc
        ret                             ; return from sub
;-----------------------------------------------------------------
;SUB_fig_draw - draws the figure
;-----------------------------------------------------------------
SUB_fig_draw:
	push	bc
	ld      a,(fig_ypos)            ; y_value
        ld      b,a                     ; load b with a (ypos)
        ld      a,(fig_xpos)            ; x_value
        ld      c,a                     ; load c with a (xpos)
	ld	a,(fig_dir)		; load direction info into a
        cp	1			; compare to 1 (right)
	jp	nz,LBL_fig_draw_0	; if not check next
	ld      de,sprite_9             ; sprite_9 (right)
        call    SUB_putsprite_8         ; put the sprite
	pop	bc
	ret				; return
LBL_fig_draw_0:
        cp	2			; compare to 2 (left)
	jp	nz,LBL_fig_draw_1	; if not then it's up/down
	ld      de,sprite_8             ; sprite_8 (left)
        call    SUB_putsprite_8         ; put the sprite
	pop	bc
	ret				; return
LBL_fig_draw_1:
 	ld      de,sprite_1             ; figure sprite
        call    SUB_putsprite_8         ; put the sprite
	pop	bc
	ret                             ; return from sub
;-----------------------------------------------------------------
;SUB_map_init - displays the map
;-----------------------------------------------------------------
SUB_map_init:
        ld      b,1                     ; y_value
        ld      c,0                     ; x_value
LBL_map_init_0:
        push    bc                      ; preserve bc
        call    SUB_get_map_xy          ; get map data
        cp      0                       ; if 0 (grass) then 
        jp      z,LBL_map_init_4        ; jump
        cp      1                       ; if 1 (wall) then
        jp      z,LBL_map_init_1        ; jump
        cp      2                       ; if 2 (exit) then 
        jp      z,LBL_map_init_2        ; jump
        cp      4                       ; if 4 (bonus) then
        jp      z,LBL_map_init_3	; jump
        cp	5			; if 5 (tombstone)
	jp	z,LBL_temp_0		; jump
	jp      LBL_map_init_4          ; else jump (grass)
LBL_map_init_1:                        
        ld      de,sprite_3             ; sprite_3 (wall)
        jp      LBL_map_init_5          ; jump
LBL_map_init_2:
        ld      de,sprite_4             ; sprite_4 (exit)
        jp      LBL_map_init_5          ; jump
LBL_map_init_3:                         
        ld      de,sprite_5             ; sprite_4 (extra life)
        jp      LBL_map_init_5          ; jump
LBL_temp_0:
	ld	de,sprite_10		; sprite 10 (tombstone)
	jp	LBL_map_init_5		; jump
LBL_map_init_4:
        ld      de,sprite_2             ; sprite_2 (grass)
LBL_map_init_5:
        call    SUB_putsprite_8         ; display sprite
        pop     bc                      ; restore bc
        inc     c                       ; increase c (x)
        ld      a,16                    ; load a with 16
        cp      c                       ; compare a and c
        jp      nz,LBL_map_init_0       ; if not equal jump
        ld      c,0                     ; zero c (x)
        inc     b                       ; increase b (y)
        ld      a,8                     ; load a with 8
        cp      b                       ; compare a with b
        jp      nz,LBL_map_init_0       ; jump if equal
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_putsprite_8                                     Thomas Bladh
;-----------------------------------------------------------------
;input: de = pointer to 8x8 sprite
;       b  = y position (0-7)
;       c  = x position (0 - 15)
;
;example:
;   (0,0)
;       ------------
;       |          |
;       |          |
;       ------------
;                  (15,7)
;-----------------------------------------------------------------
SUB_putsprite_8:
	push	bc			; preserve bc
	push	de			; preserve de
	ld      a,b                     ; load a with y value (0-7)
        push    bc                      ; save bc
        ld      hl,16                   ; load hl with 16
        call    SUB_hl_mul_a            ; multiply hl and a
        ld      a,8                     ; load a with 8
        call    SUB_hl_mul_a            ; multiply hl with a (8)
        pop     bc                      ; restore bc
        ld      b,0                     ; set y value to 0
        add     hl,bc                   ; add x value to offset
        ld      bc,$FC00                ; load bc with adress of video mem
        add     hl,bc                   ; add to offset in hl
	pop	de			; restore de
        ld b, 8				; 8 rows
LBL_putsprite_8_0:
 	ld a,(de)           		; load byte from sprite into a
        ld (hl),a          		; load it into screen mem
        inc de              		; move to the next byte of the sprite
		;--------------------------------------
		; This can be used with 8xn size tiles
		;--------------------------------------
		;ld	a,b
		;ld	bc,16
		;add	hl,bc
		;ld	b,a
		;-----------------------------
	;-----------------------------
	; Use this with 8x8 tiles only
	;-----------------------------
	ld	a,l			; load a with l
        add	a,16			; move to next row on screen
        ld	l,a			; load l with a
	;-----------------------------	
	djnz 	LBL_putsprite_8_0	; loop while b <> 0
	pop	bc			; restore bc
	ret
;-----------------------------------------------------------------
; SUB_get_map_xy - returns map data for x,y in a      Thomas Bladh
;-----------------------------------------------------------------
; input:	c = map xpos
; 		b = map ypos               
; output:	a = map data
;		destroys af,de,hl
;-----------------------------------------------------------------
SUB_get_map_xy:
	push	bc			; preserve bc
	dec	b			; decrease b (y coord)
	ld	h,0			; load h with 0
	ld	l,b			; load l with b
	ld	a,16			; load a with 16
	call    SUB_hl_mul_a            ; multiply hl by a
	ld	d,0			; load d with 0
	ld	e,c			; load e with c	
	add	hl,de			; add de to hl
	ld	de,map_image		; load de with adress map_image
	add	hl,de			; add de to hl
	ld	a,(hl)			; load value at hl into a
	pop	bc			; restore bc
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_set_map_xy - sets map data for x,y (c,b)        Thomas Bladh
;-----------------------------------------------------------------
; input:	c = map xpos
; 		b = map ypos               
;		a = data to set
; output: tile on map
;	  destroys de,hl	
;-----------------------------------------------------------------
SUB_set_map_xy:
	push	bc			; preserve bc
	push	af			; preserve af
	dec	b			; decrease b
	ld      h,0			; zero h
	ld	l,b			; load l with b
	ld	a,16			; set a to 16
	call    SUB_hl_mul_a            ; multiply hl by a
	ld	d,0			; zero d
	ld	e,c			; load e with c
	add	hl,de			; add de to hl
	ld	de,map_image		; load de with offset
	add	hl,de			; add offset to hl
	pop	af			; restore af
	ld	(hl),a			; load a into hl
	pop	bc			; restore bc
        ret                             ; return from sub
;---------------------------------------------------------------
; Original author: Jimmy Mrdell ?
; This routine is from Cyber Optics Ti86 page, I made one myself
; but it was somewhat larger than this ;) .
;---------------------------------------------------------------
; SUB_disp_hl - displays value of hl at current pen location
;---------------------------------------------------------------
; input:        hl = value to display (0-65535)
; output:       Displays value of hl with menu style chars
;               without leading zeros in decimal notation
;               at pen location. (af,hl,bc,de destroyed)
;---------------------------------------------------------------
SUB_disp_hl:
	ld	c,'0'  				; save ascii value for zero
	ld	de,_OP1+5			; point to end of the buffer
	xor	a				; zero terminate string
	ld	(de),a				; set last byte to zero
LBL_disp_hl_0:
	call	_HLdiv10			; next digit
	dec	de				; next position
	add	a,c				; convert to ascii
	ld	(de),a				; save digit
	ld	a,h				; load upper byte
	or	l				; check with lower byte for zero
	jr	nz,LBL_disp_hl_0		; loop
	ex	de,hl				; point to buffer
	call	_vputs				; print number
	ret					; we're done
;-----------------------------------------------------------------
;Multiply hl with a (hl*a->hl)       (70 clks)
;-----------------------------------------------------------------
SUB_hl_mul_a:
        ex      de,hl                   ; exchange de and hl            #4
        ld      hl,0                    ; zero hl                       #10
	cp      0                       ; check if a = 0                #7
        ret     z                       ; return from sub if equal      #11
        ld      b,a                     ; load b with a                 #4
LBL_hl_mul_a_1:
        add     hl,de                   ; add de to hl                  #11
        djnz    LBL_hl_mul_a_1          ; b=b-1: repeat until b = 0     #13
        ret                             ; return from sub               #10
;-----------------------------------------------------------------
; SUB_step_on_mine - handles step on mine event
;-----------------------------------------------------------------
SUB_step_on_mine:
        ld      a,(fig_lives)           ; load a with mem variable
        dec     a                       ; decrease a
        ld      (fig_lives),a           ; load mem variable with a
        ld      de,anim_1               ; load de with offset of anim_1
        ld      b,11                    ; b with 7 (number of frames)
        call    SUB_animate_at_fig	; start the animation
        ld	de,LIFE_VALUE		; load de with 
	ld      hl,(score)		; load hl with score
	or      a                       ; sub hl with de
        sbc     hl,de                   ; -------||------
	jp	nc,LBL_step_on_mine_0	; if not carry then jump
	ld	hl,0			; zero hl
LBL_step_on_mine_0:
	ld      (score),hl		; load score variable with hl
	ld	a,(fig_xpos)		; load a with fig_xpos
	ld	c,a			; load c with a
	ld	a,(fig_ypos)		; load a with fig_ypos
	ld	b,a			; load b with a
	ld	a,5			; load a with 5 (toombstone)
	call	SUB_set_map_xy		; set map at (c,b) to a
	call	SUB_sad_sound
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_step_on_exit - handles step on exit event
;-----------------------------------------------------------------
SUB_step_on_exit:
	call	SUB_happy_sound
        ld      de,anim_2               ; load de with offset of anim_1
        ld      b,7                     ; b with 7 (number of frames)
        call    SUB_animate_at_fig	; play the animation 
        ld      hl,(score)		; load hl with score
        ld      de,MAP_BONUS		; load de with 16
        add     hl,de			; add de(16) to score
        ld      (score),hl		; load score with new value
        call    SUB_disp_score		; display the new score
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_general_delay - halts execution a*halt
;-----------------------------------------------------------------
SUB_general_delay                       
        push    bc                      ; preserve bc
        ld      b,a
LBL_general_delay_0:
        halt                            ; halt execution until next int ?
        djnz    LBL_general_delay_0     ; jump decrease if not zero (b)
        pop     bc                      ; restore bc
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_score_bonus - handles bonus event
;-----------------------------------------------------------------
SUB_score_bonus:
	call    SUB_fig_draw            ; draw the figure
	ld	a,(fig_xpos)
	ld	c,a
	ld	a,(fig_ypos)		
	ld	b,a			; load b into a
	xor	a			; zero a
	call	SUB_set_map_xy		; set a tile on the map
	ld      hl,(score)		; load score into hl
        ld      de,GEM_BONUS		; load 8 into de
        add     hl,de			; add de(8) to hl
        ld      (score),hl		; load score with new value 
        call    SUB_disp_score		; display the bew score
	call	SUB_gem_sound
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_mine_warning - warns player if a mine is near
;-----------------------------------------------------------------
;
;   123
;   4X6   X = PLAYER
;   789
;
;-----------------------------------------------------------------
SUB_mine_warning:
	ld      a,(fig_ypos)            ; load a with fig_ypos
        inc	a			; increase a by 1
	ld	d,a			; load d with a (to be used in the loop below)
	sub	2			; decrease a by 2
        ld      b,a                     ; load b with a (y start position for the search)  
	ld      a,(fig_xpos)            ; load a with fig_xpos
        inc	a			; increase a
	ld	e,a			; load e with a (to be used in the loop below)
	sub	2			; decrease a by 2
	ld      c,a                     ; load c with a (x start position for the search)
LBL_mine_warning_0:
	ld	a,b			; load b (y coord) into a
	cp	8			; compare a to 8
	jp	z,LBL_mine_warning_1	; if equal then we are out of bounds
	cp	0			; compare to 0
	jp	z,LBL_mine_warning_1	; if equal then we are out of bounds
	ld	a,c			; load c (x coord) into a
	cp	16			; compare to 16
	jp	z,LBL_mine_warning_1	; if equal then we are out of bounds
	cp	255			; compare to 255
	jp	z,LBL_mine_warning_1	; if equal then we are out of bounds
	push	de			; preserve de
	call    SUB_get_map_xy          ; check the map at (c,b), value returned in a
	pop	de			; restore de
	cp	3			; compare a with 3 
	jp	z,LBL_mine_warning_2	; jump if equal (a mine was found)	
LBL_mine_warning_1:
	ld	a,c			; load a with c
	inc	c			; increase c
	cp	e			; check if x coord is at end of search (is equal to e)
	jp	nz,LBL_mine_warning_0	; if not equal jump
	sub	2			; decrease a with 2	
	ld	c,a			; load c with a (c = x coord)
	ld	a,b			; load a with b (b = y coord)
	inc	b			; increase b
	cp	d          		; check if y coord is at end of search 
	jp	nz,LBL_mine_warning_0	; if not equal jump
        ld      a,(warn_flag)		; check if skull is on
        cp      1			; ------||------
        ret     nz			; if not return
					; if the skull is on and no mine is 
					; detected then it should be turned off.
        ld      de,sprite_7             ; point de to skull-erase sprite
        xor     a			; zero a
        ld      (warn_flag),a		; zero warn_flag with a
        ld      b,0                     ; load b with ypos
        ld      c,15                    ; load c with xpos
        call    SUB_putsprite_8         ; put the sprite
        ret				; return
LBL_mine_warning_2:			; a mine is found
        ld      a,1			; load a with 1
        ld      (warn_flag),a		; set flag to 1 (mine is detected)
        ld      de,sprite_6             ; point de to sprite
        ld      b,0                     ; load b with (ypos)
        ld      c,15                    ; load c with (xpos)
        call    SUB_putsprite_8         ; put the sprite
        ret				; return	
;---------------------------------------------------------------------
;SUB_inpstr - text input at pen location
;---------------------------------------------------------------------
;input:	hl=adress of destination string, this should be a string of
;	zeros (String .db 0,0,0,0,0,0,0,0)
;	b=maximum length (should be length of destination string-1)
;output: string of length b or less at hl
;---------------------------------------------------------------------
SUB_inpstr:
LBL_inpstr_0:
	set	shiftAlpha,(iy+shiftflags)	; set Alpha on?? (it works)
	push	hl			; preserve hl			
	call    _getkey                 ; get keypress in a
	pop	hl			; restore hl
	cp	kEnter			; compare a to kEnter
	jr	z,LBL_inpstr_3		; if equal then we are done
	;---------------------------------------------------------------
	; check if b is zero (this means that we have filled the string
	; and just wait for the user to press enter)
	;---------------------------------------------------------------
	ld	c,a			; save a in c
	ld	a,b			; load a with b
	cp	0			; compare to 0
	jr	z,LBL_inpstr_0		; if equal then jump
	ld	a,c			; restore a from c
	;------------------------------
	; check if a is in A-Z
	;------------------------------
	cp	$28			; compare a to 28h
	jr	z,LBL_inpstr_1		; a_equal_to
	jr	nc,LBL_inpstr_1		; a_greater_than
	jr	LBL_inpstr_0		; a must be less than 28h (i think)
LBL_inpstr_1:
	cp	$41			; compare a to 41h
	jr	z,LBL_inpstr_2		; a_equal_to
	jr	c,LBL_inpstr_2		; a_less_than
	jr	LBL_inpstr_0		; a must be greater than 41h (i think)
LBL_inpstr_2:
	add	a,25			; add 25 to a to get ASCII
	ld	(hl),a			; load (hl) with char in a
	inc	hl			; increase hl (memory pointer)
	dec	b			; decrease b (char counter)
	call	_vputmap		; echo one char
	jp	LBL_inpstr_0		; do it again
LBL_inpstr_3:
	xor	a			; zero a
	ld	(hl),a			; put zero at hl (ending the string)
	res	shiftAlpha,(iy+shiftflags)	; reset Alpha on?? (it works)
	ret				; return from sub
;-----------------------------------------------------------------
; SUB_animate_at_fig - plays animation at the fig_pos
;-----------------------------------------------------------------
SUB_animate_at_fig:
        push    bc                      ; preserve bc
        push    de                      ; preserve de
        ld      a,(fig_xpos)            ; load a with mem variable
        ld      c,a                     ; load c with a
        ld      a,(fig_ypos)            ; load a with mem variable
        ld      b,a                     ; load b with a
        call    SUB_putsprite_8         ; put the sprite at de
        ld      a,20
        call    SUB_general_delay       ; delay
        pop     de                      ; restore de
        ex      de,hl                   ; exchange de and hl
        ld      de,8                    ; load de with 8
        add     hl,de                   ; add de to hl
        ex      de,hl                   ; exchange de and hl
        pop     bc                      ; restore bc
        djnz    SUB_animate_at_fig      ; jump decrease if not zero (b)
        ret
;-----------------------------------------------------------------
; SUB_display_title - displays title text
;-----------------------------------------------------------------
SUB_display_title:
	call	SUB_black_top
	call	SUB_black_bottom	
        set     textInverse,(iy+textflags) ; enable textinverse
        ld      a,5
        ld      (_penCol),a             
        ld      a,57
        ld      (_penRow),a             
        ld      hl,prog_text_0
        call    _vputs                  
        ld	a,23
        ld      (_penCol),a             
	xor	a
        ld      (_penRow),a             
        ld      hl,prog_text_1
        call    _vputs
        res     textInverse,(iy+textflags) ; enable textinverse
	ld      a,45
        ld      (_penCol),a             
        ld      a,16
        ld      (_penRow),a             
        ld      hl,prog_text_7
        call    _vputs                  
	ld      a,45
        ld      (_penCol),a             
        ld      a,24
        ld      (_penRow),a             
        ld      hl,prog_text_8
        call    _vputs                  
	ld      a,45
        ld      (_penCol),a             
        ld      a,32
        ld      (_penRow),a             
        ld      hl,prog_text_9
        call    _vputs                  
	ret
;-----------------------------------------------------------------
; SUB_disp_over - displays game over screen
;-----------------------------------------------------------------
SUB_disp_over:
	call	SUB_update_stats
	call	SUB_clear_map
	call	SUB_black_bottom
	ld      a,46
        ld      (_penCol),a             ; load pen column with a (0)
        ld      a,18
        ld      (_penRow),a             ; load pen row with a (0)
        ld      hl,prog_text_6
        call    _vputs                  ; put the string (menu style)
	set     textInverse,(iy+textflags) ; enable textinverse
        ld      a,46
        ld      (_penCol),a             ; load pen column with a (0)
        ld      a,57
        ld      (_penRow),a             ; load pen row with a (0)
        ld      hl,prog_text_4
        call    _vputs                  ; put the string (menu style)
	res     textInverse,(iy+textflags) ; enable textinverse
	call	SUB_check_highscore
	ret
;-----------------------------------------------------------------
; SUB_disp_win - displays winner screen
;-----------------------------------------------------------------
SUB_disp_win:
	call	SUB_update_stats
	call	SUB_clear_map;
	call	SUB_black_bottom
        ld      a,26
        ld      (_penCol),a             ; load pen column with a
        ld      a,18
        ld      (_penRow),a             ; load pen row with a
        ld      hl,prog_text_5
        call    _vputs                  ; put the string (menu style)
        ;
        ; press a key text
	set     textInverse,(iy+textflags) ; enable textinverse
        ld      a,45
        ld      (_penCol),a             ; load pen column with a (0)
        ld      a,57
        ld      (_penRow),a             ; load pen row with a (0)
        ld      hl,prog_text_4
        call    _vputs                  ; put the string (menu style)
	res     textInverse,(iy+textflags) ; enable textinverse
	;-----------------------------------------------------------------
	; calculate the life bonus and update the stats
	;-----------------------------------------------------------------
	ld	hl,(score)
	ld	a,(fig_lives)
	ld	b,a
LBL_disp_win_0:
	ld	de,LIFE_VALUE
	add	hl,de
	ld	(score),hl
	ld	a,b
	dec	a
	ld	(fig_lives),a
	push	bc
	push	hl
	ld	a,5
	call	SUB_general_delay
	call	SUB_disp_score
	call	SUB_disp_lives
	call	SUB_gem_sound
	pop	hl
	pop	bc
	djnz	LBL_disp_win_0	
	call	SUB_check_highscore
        ret
;-----------------------------------------------------------------
; SUB_wait_key - halts until enter or 2nd is pressed
;-----------------------------------------------------------------
SUB_wait_key:
        call    _getky                  ; get keypress in a
        cp	K_SECOND		; compare keypress to K_SECOND
	ret	z	
	cp      K_ENTER                 ; compare keypress to K_ENTER
	ret	z
        jp      SUB_wait_key 	        ; continue
        ret                          	; else return
;-----------------------------------------------------------------
; SUB_update_stats - updates the statusbar
;-----------------------------------------------------------------
SUB_update_stats:
	set     textInverse,(iy+textflags) ; enable textinverse
        ld      a,52                    ; display the "score:" string
        ld      (_penCol),a             ; ------||------
        xor     a                       ; ------||------
        ld      (_penRow),a             ; ------||------
        ld      hl,info_score           ; ------||------
        call    _vputs                  ; ------||------
        ld      a,1                     ; display the "Minefield:" string
        ld      (_penCol),a             ; ------||------
        xor     a
        ld      (_penRow),a             ; ------||------
        ld      hl,info_bar             ; ------||------
        call    _vputs                  ; ------||------
        ld      a,93                    ; display the "lives:" string
        ld      (_penCol),a             ; ------||------
        xor     a                       ; ------||------
        ld      (_penRow),a             ; ------||------
        ld      hl,info_lives           ; ------||------
        call    _vputs                  ; ------||------
        res     textInverse,(iy+textflags) ; enable textinverse
        call    SUB_disp_score          ; display the score
        call    SUB_disp_mapnum         ; display the map number
        call    SUB_disp_lives          ; display life information
	ret
;-----------------------------------------------------------------
; SUB_disp_mapnum - displays the map number
;-----------------------------------------------------------------
SUB_disp_mapnum:
        set     textInverse,(iy+textflags) ; enable textinverse
        ld      a,38                    ; display map number at
        ld      (_penCol),a             ; pen location
        xor     a                       ; ---------||---------
        ld      (_penRow),a             ; ---------||---------
        ld      a,(map_nr)              ; ---------||---------
        ld      h,0                     ; ---------||---------
        ld      l,a                     ; ---------||---------
        call    SUB_disp_hl             ; ---------||---------
        res     textInverse,(iy+textflags) ; enable textinverse
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_disp_score - displays the score
;-----------------------------------------------------------------
SUB_disp_score:
        set     textInverse,(iy+textflags) ; enable textinverse
        ld      de,sprite_7             ; use blank sprite to
        ld      b,0                     ; clear previous score
        ld      c,9                     ; ---------||---------
        call    SUB_putsprite_8         ; ---------||---------
        ld      de,sprite_7             ; ---------||---------
        inc     c                       ; ---------||---------
        call    SUB_putsprite_8         ; ---------||---------
        ld      a,75                    ; display score at 
        ld      (_penCol),a             ; pen location
        xor     a                       ; ---------||---------
        ld      (_penRow),a             ; ---------||---------
        ld      hl,(score)              ; ---------||---------
        call    SUB_disp_hl             ; ---------||---------
        res     textInverse,(iy+textflags) ; enable textinverse
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_disp_lives - displays life value
;-----------------------------------------------------------------
SUB_disp_lives:
        set     textInverse,(iy+textflags) ; enable textinverse
        ld      a,113                   ; load a with 113
        ld      (_penCol),a             ; load pen column with a (97)
        xor     a                       ; zero a
        ld      (_penRow),a             ; load pen row with a (0)
        ld      a,(fig_lives)           ; load a with mem variable
        ld      h,0                     ; zero h
        ld      l,a                     ; load l with a
        call    SUB_disp_hl             ; display hl
        res     textInverse,(iy+textflags) ; enable textinverse
        ret                             ; return from sub
;-----------------------------------------------------------------
; SUB_load_next_map - loads the next map
;-----------------------------------------------------------------
SUB_load_next_map:
	ld	hl,112
	ld	a,(map_nr)
	call	SUB_hl_mul_a
	ld	de,DATA_ZONE
	add	hl,de
	ld	de,map_image
	ld	bc,112
	ldir
	ld	a,(map_nr)
	inc	a
	ld	(map_nr),a	
	ret
;-----------------------------------------------------------------
; SUB_check_highscore - check if score > highscore, if so update
;-----------------------------------------------------------------
SUB_check_highscore:
	;------------------------------
	; check if score > highscore
	;------------------------------
	ld	hl,(highscore_score)
	ld	de,(score)
	call	SUB_cphlde
	jr	z,LBL_check_highscore_0	 ; if equal then skip
	jr	nc,LBL_check_highscore_0 ; if less then skip
	;------------------------------
	; Update highscore
	;------------------------------
	ld      a,20
        ld      (_penCol),a             
        ld      a,29
        ld      (_penRow),a             
        ld      hl,prog_text_14
        call    _vputs                  ; put the string (menu style)
	ld      a,15
        ld      (_penCol),a             
        ld      a,40
        ld      (_penRow),a             
        ld      hl,prog_text_13
        call    _vputs                  ; put the string (menu style)
	ld	hl,highscore_name
	ld	b,10
	call	SUB_inpstr
	ld	hl,(score)
	ld	(highscore_score),hl
	ret
	;------------------------------
	; score is <= highscore
	;------------------------------
LBL_check_highscore_0:
	call	SUB_wait_key		; wait for keypress
	ret
;-----------------------------------------------------------------
; SUB_black_top	- set top 7 rows to black
;-----------------------------------------------------------------
SUB_black_top:
	ld      hl,$FC00                ; set the top 7 rows to black
        ld      de,$FC01                ; ----------||----------
        ld      (hl),$FF                ; ----------||----------
        ld      bc,$006F                ; ----------||----------
        ldir                            ; ----------||----------
	ret
;-----------------------------------------------------------------
; SUB_black_top	- set bottom 7 rows to black
;-----------------------------------------------------------------
SUB_black_bottom:
	ld      hl,$FF90                ; set the bottom 7 rows to black
        ld      de,$FF91                ; ----------||----------
        ld      (hl),$FF                ; ----------||----------
        ld      bc,$006F                ; ----------||----------
        ldir                            ; ----------||----------
	ret
;-----------------------------------------------------------------
; SUB_clear_map	- clear the map
;-----------------------------------------------------------------
SUB_clear_map:
	ld      hl,$FC70                ; clear the field
        ld      de,$FC71                ; ----------||----------
        ld      (hl),$00                ; ----------||----------
        ld      bc,$031F                ; ----------||----------
        ldir                            ; ----------||----------
	ret
;-----------------------------------------------------------------
; SUB_menu_select - menu selection routine
;-----------------------------------------------------------------
SUB_menu_select:
	ld      hl,$FEA0                ; clear area
        ld      de,$FEA1                ; ----------||----------
        ld      (hl),$00                ; ----------||----------
        ld      bc,$BF                  ; ----------||----------
        ldir                            ; ----------||----------
	ld	a,(menu_pos)
	cp	0
	call	z,SUB_start_info	
	cp	1
	call	z,SUB_highscore_info	
	cp	2
	call	z,SUB_exit_info	
	inc	a
	inc	a
        ld      b,a
	ld      c,4                     
        ld	de,sprite_12
	call    SUB_putsprite_8         
	ret
;-----------------------------------------------------------------
; SUB_menu_deselect - menu selection routine
;-----------------------------------------------------------------
SUB_menu_deselect:
	ld	a,(menu_pos)
	inc	a
	inc	a
        ld      b,a
	ld      c,4                     
        ld	de,sprite_0
	call    SUB_putsprite_8         
	ret
;-----------------------------------------------------------------
; SUB_start_info - menu selection info
;-----------------------------------------------------------------
SUB_start_info:
	push	af
	ld      a,6
        ld      (_penCol),a             
        ld      a,41
        ld      (_penRow),a             
        ld      hl,prog_text_2
        call    _vputs                  
        ld      a,4
        ld      (_penCol),a             
        ld      a,48
        ld      (_penRow),a             
        ld      hl,prog_text_3
        call    _vputs                  
	pop	af
	ret
;-----------------------------------------------------------------
; SUB_highscore_info - menu selection info
;-----------------------------------------------------------------
SUB_highscore_info:
	push	af
	ld      a,25
        ld      (_penCol),a             
        ld      a,44
        ld      (_penRow),a             
	ld	a,'['
	call	_vputmap
        ld      hl,highscore_name
        call    _vputs                  
	ld	a,','
	call	_vputmap
	ld      a,81
        ld      (_penCol),a             
        ld      a,44
        ld      (_penRow),a             
	ld	hl,(highscore_score)
	call	SUB_disp_hl	
        ld      hl,prog_text_10
        call    _vputs                  
	pop	af
	ret
;-----------------------------------------------------------------
; SUB_exit_info - menu selection info
;-----------------------------------------------------------------
SUB_exit_info:
	;----------------------------
	; This SUB is left unused
	; might be implemented later
	;----------------------------
	push	af
	ld      a,24
        ld      (_penCol),a             
        ld      a,44
        ld      (_penRow),a             
        ld      hl,prog_text_11
	call	_vputs
	pop	af
	ret
;-----------------------------------------------------------------
; SUB_set_mines - reveals the mines (mineview)
; input: de=offset of sprite	
;-----------------------------------------------------------------
SUB_set_mines:
	ld      b,1                     ; set b to 1 (y coord)
LBL_set_mines_0
        ld      c,0                     ; x_value
LBL_set_mines_1:
	push	de
	call	SUB_get_map_xy
	pop	de
	cp	3
	jp	nz,LBL_set_mines_2
	push	de
	call SUB_putsprite_8
	pop	de
LBL_set_mines_2:			; jump here to skip draw
	inc     c
	ld	a,c
	cp	16
	jp	nz,LBL_set_mines_1
	inc	b
	ld	a,b
	cp	8
	jp	nz,LBL_set_mines_0
	ret
	;-------------------------------------------------------------------
	; SUB_checksum_calc - calculates 2 byte checksum for the highscore
	;-------------------------------------------------------------------
	;input:	de=start adress of checksum
	;	b=number of bytes to checksum
	;output: hl=checksum word (destroys: af,bc,de,hl)
	;-------------------------------------------------------------------
	;SUB_checksum_calc:
	;	ld	hl,0			; zero hl
	;LBL_checksum_calc_0:
	;	push	bc			; preserve bc (counter)
	;	ld	a,(de)			; load byte from hl into a
	;	ld	c,a			; load c with a
	;	ld	b,0			; zero b
	;	add	hl,bc			; add bc to hl
	;	inc	de			; increase de (memory pointer)
	;	pop	bc			; restore bc (counter)
	;	djnz	LBL_checksum_calc_0	; decrease & jump if b <> 0	
	;	ret	
;-----------------------------------------------------------------
; Original author: Matthew Johnson
;-----------------------------------------------------------------
; SUB_playtone - plays a tone through the linkport
;-----------------------------------------------------------------
; Input:
;   c = frequency (pitch of sound, up to 255 where 255 is the 
;	lowest pitch)
;  hl = duration (length of tone, up to 65,535) 
; Output:
;   sound (duh)
;   destroys af,bc,hl
;-----------------------------------------------------------------
SUB_play_tone:
LBL_play_tone_0:
	dec	hl
	xor	a			; clear a
	cp	h			; check if h is 0
	jr 	nz,LBL_play_tone_1 	; jump if not equal	
	xor	a			; clear a
	cp	l			; check if l is 0
	ret	z		        ; both h and l were zero, so hl = 0 and now we return
LBL_play_tone_1:			; speakers off
	ld	a,%11111100		; load a with bit pattern   	  
	out	(7),a			; Turn off both red and white wires
	ld	b,c			; load b with c
Delay1: 
	djnz	Delay1          	; The larger B is, the higher the delay thus the lower the frequency
	ld	a,%11000000		; load a with bit pattern
	out	(7),a      		; Turn on both red and white wires
	ld	b,c			; load b with c
Delay2: 
	djnz	Delay2         		; The larger B is, the higher the delay thus the lower the frequency
	jp	LBL_play_tone_0		; jump
;-----------------------------------------------------------------
; Compare  hl to de
;-----------------------------------------------------------------
SUB_cphlde:
        ld      a,h                     ; load a with h
        cp      d                       ; compare to d
        ret     nz                      ; return if not zero
        ld      a,l                     ; load a with l
        cp      e                       ; compare to e
        ret                             ; return
;-----------------------------------------------------------------
; SUB_sad_sound - sort of ominous sound (hopefully)
;-----------------------------------------------------------------
SUB_sad_sound:
	ld	a,(sound_flag)		; load soundflag into a
	cp	1			; is it set
	ret	nz			; if not we wont play
	ld	hl,100
	ld	b,5
	ld	c,96
LBL_sad_sound_0:	
	push	bc
	push	hl
	call	SUB_play_tone		; play the tone
	pop	hl	
	pop	bc
	ld	de,10
	add	hl,de
	ld	a,c
	add	a,10
	ld	c,a
	djnz	LBL_sad_sound_0
	ret
;-----------------------------------------------------------------
; SUB_happy_sound - glad sound, finished a level...
;-----------------------------------------------------------------
SUB_happy_sound:
	ld	a,(sound_flag)		; load soundflag into a
	cp	1			; is it set
	ret	nz			; if not we wont play
	ld	hl,100
	ld	b,4
	ld	c,64
LBL_happy_sound_0:	
	push	bc
	push	hl
	call	SUB_play_tone		; play the tone
	pop	hl	
	pop	bc
	ld	de,8
	or	a
	sbc	hl,de
	ld	a,c
	sub	10
	ld	c,a
	djnz	LBL_happy_sound_0
	ret
;-----------------------------------------------------------------
; SUB_gem_sound - sound played when you reach a bonus gem
;-----------------------------------------------------------------
SUB_gem_sound:
	ld	a,(sound_flag)		; load soundflag into a
	cp	1			; is it set
	ret	nz			; if not we wont play
	ld	hl,50			; set length to 50
	ld	c,32			; set pitch to 32
	call	SUB_play_tone		; play the tone
	ld	hl,50			; set length to 50
	ld	c,64			; set pitch to 64
	call	SUB_play_tone		; play the tone
	ld	hl,50			; set length to 50
	ld	c,96			; set pitch to 96
	call	SUB_play_tone		; play the tone
	ret
;-----------------------------------------------------------------
; SUB_walk_sound - anoying sound played when you walk
;-----------------------------------------------------------------
SUB_walk_sound:
	ld	a,(sound_flag)		; load soundflag into a
	cp	1			; is it set
	ret	nz			; if not we wont play
	ld	hl,WALK_DURATION	; set the duration  
	ld	c,WALK_PITCH		; set the pitch 
	call	SUB_play_tone		; play the tone
	ret
;-----------------------------------------------------------------
; SUB_gray_view - display 2 level grayscale, could be tuned
;-----------------------------------------------------------------
SUB_gray_view:
	ld	ix,LBL_gray_view_0
LBL_gray_view_0:
	ld      a,VID_LOC2		; offset of second page  256*(192+45) = 60672 (ED00h)
	out     (0),a
	halt	
	ld      a,VID_LOC1		; offset of first page 256*(192+41) = 59648 (E900h)
	out     (0),a		
	call    _getky	   	  	; get keypress status
	cp	K_NOKEY
	jp	nz,LBL_gray_view_1
	halt                         
	halt                        
	jp	(ix)
LBL_gray_view_1: 
	ld      a,$3C          		; set display page back to normal
	out     (0),a
	ret
;-----------------------------------------------------------------
; Original author: Kirk Meyer	  (included in the Lite86 package)
;-----------------------------------------------------------------
;input: hl = pointer to compressed data
;	de = pointer to where decompressed info is to be put
;output: decompressed data
;	 destroys af,bc,de,hl
;-------------------------------------------------------------------
SUB_decompress:
        ld a,(hl)
        bit 7,a
        jr z,LBL_decompress_0
        inc hl
        and %01111111
        ld b,0
        ld c,a
        ldir
        jr SUB_decompress
LBL_decompress_0:
        push af
        or %11111100
        ld b,a
        inc hl
        ld c,(hl)
        inc hl
        pop af
        and %01111100
        rrca
        rrca
        or a
        ret z
        push hl
        ld h,d
        ld l,e
        add hl,bc
        inc a
        inc a
        ld b,0
        ld c,a
        ldir
        pop hl
        jr SUB_decompress
	

; VARIABLES - could be located in free ram as it is only 15 bytes

fig_xpos:       .db     0               ; figure x position
fig_ypos:       .db     0               ; figure y position
map_nr:         .db     0               ; map number
warn_flag:      .db     0		; is 1 if mine warning is on
fig_lives       .db     0               ; number of lives
fig_dir:	.db	0		; direction of movement (0=up or down,1=right,2=left)
menu_pos:	.db	0		; menu position (0 = START GAME, 1 = VIEW HISCORE, 2 = EXIT)
minev_flag:	.db	0		; mineview flag
sound_flag	.db	0		; sound on\off
minev_counter:	.dw	0		; mineview counter
score:          .dw     0		; the game score

; STRINGS  

Title:          .db     "Minefields v1.0 by Thomas Bladh",0
info_bar:       .db     "Minefield:",0
info_lives:     .db     "lives:  ",0
info_score:     .db     "score:  ",0
prog_text_0:	.db     "Thomas Bladh (tiberius@swipnet.se)",0
prog_text_1:	.db     "MINEFIELDS  v1.0  (c)  1999",0
prog_text_2:	.db     "[CLEAR] - activate mineview,  [F1] -",0
prog_text_3:	.db     "toggle  sound,  [EXIT] - ends the game",0             
prog_text_4:	.db     "Press ENTER...",0             
prog_text_5:	.db     "You have won the game!!",0
prog_text_6:	.db     "Game Over",0
prog_text_7:	.db	"START GAME",0
prog_text_8:	.db	"VIEW HIGHSCORE",0
prog_text_9:	.db	"EXIT",0
prog_text_10:	.db	"   pts]",0
prog_text_11:	.db	"Exit to Calc-OS or Shell...",0
; prog_text_12 has been removed
prog_text_13:	.db	"Enter your name:  ",0
prog_text_14:	.db	"You have the highest score!!",0

; the program name is used by the highscore-save routine

PROG_NAME:
  .db $12,7,"minefld"

HIGHSCORE:					; 13 bytes total
highscore_name 	.db     "TIBERIUS",0,0,0  	; 11 bytes
highscore_score .dw     64			; 2 bytes

; SPRITES

#include "m_sprite.asm"

;ANIMATIONS

#include "m_anim.asm"

; GAME MAPS - compressed map data

#include "m_maps.db"

; GAME TITLE - compressed image data

#include "m_pic.db"

        .end
