; Melt Man V1.0, a TCPA game
; - http://tcpa.calc.org/
;
; You may use this source for whatever you want.
; However, you may not distribute edited versions.
;
; Disclaimer - looking at this source may cause 
;	serious brain trama.


#include "ion.inc"

sprite_number = 8
p_right = 8
p_left = 9
p_up = 10
p_down = 11
bullet1 = 1
bullet2 = 2
brick = 3
door = 4
spike = 5
spike2 = 6
enemy = 7
key = 12
breakable_block = 13
potion = 14
clear = 15

playerx     = saferam1
playery     = saferam1+1
mapx        = saferam1+2		
mapy        = saferam1+3
facing      = saferam1+4	; 0 = down, 1 = left, 2 = right, 3 = up 
current_sprite_number = saferam1+5
bullets     = saferam1+6	; number of bullets
key_status  = saferam1+7	; 0 = don't have, 1 = have
max_enemies = saferam1+8	; maximun number of enemies, used in the delay
level       = saferam1+9
lives	    = saferam1+10
potions     = saferam1+11
potion_in_use = saferam1+12
potion_status = saferam1+13
potion_timer = saferam1+14
timer       = saferam1+50	; two bytes
map_var     = saferam1+75
enemy_table = saferam1+500	; the first byte of the table is the number of enemies.
				; enemy_table+1 is the first byte of the first enemy
				; ea. enemy has two bytes:
				;	1: xcoord.  0-23
				; 	2: ycoord.  0-7

#ifdef TI83P
 .org Progstart-2
 .db $BB, $6D

#else
 .org Progstart
 
#endif
 ret
 jr nc,initialization
 .db "Melt Man - Matthew L.",0

initialization:
 set textwrite, (iy+sgrflags)
 ld de,0*256+5			; y*256+x 
 ld hl,title
 call text
 push hl
invert_title:
 ld hl,plotsscreen
 ld b,12*7
invert_title2:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 djnz invert_title2
 call ionFastCopy
 pop hl
 ld b,18
scrolling_introduction:
 push bc
 call scroll
 call clear_line
 ld de,56*256+0
 call text
 pop bc
 djnz scrolling_introduction
 call ionFastCopy
 bcall(_getkey)

initialize_game:
 xor a
 ld (level),a
 ld a,5
 ld (lives),a
get_level:
 or a 
 sbc hl,hl
 ld (mapx),hl
 ld (bullets),hl
 ld (potions),hl
 ld (potion_status),hl
 ld a,p_right
 ld (current_sprite_number),a
 ld a,2
 ld (facing),a
 ld a,(level)
 ld b,a
 add a,a	; * 2
 add a,b	; * 3
 add a,a	; * 6
 add a,a	; * 12
 add a,a	; * 24
 ld l,a
 ld h,0
 add hl,hl	; * 48
 add hl,hl	; * 96
 add hl,hl	; * 192
; add hl,hl	; * 384
 ld de,map
 add hl,de
 ld de,map_var
 push de
 ld b,193
 ld c,15
 call ionDecompress
 pop hl

 ld bc,12*8*2*2
get_player_coords:
 ld a,sprite_number
 cpir
 ld hl,24*16
 or a 
 sbc hl,bc
 ld de,24
 ld b,-1
div24:
 inc b
 or a
 sbc hl,de
 jr nc,div24
 ld a,l
 add a,23
 ld (playerx),a
 ld a,b
 ld (playery),a
 call build_enemy_table
 ld a,(enemy_table)
 ld (max_enemies),a
; add a,5
 ld (bullets),a
 call tilemap

keypresses:
 ld b,$FE
 call direct_input
 cp %11111110
 call z,player_down
 cp %11111101
 call z,player_left
 cp %11111011
 call z,player_right
 cp %11110111
 call z,player_up
 ld b,$BF
 call direct_input
 cp 223
 call z,fire
 cp 127
 call z,infos
 cp 191
 ret z
 ld b,$DF
 call direct_input
 cp 127
 call z,use_potion
 call move_enemies
 call smooth_delay
 call check_potion
 jr keypresses

check_potion:
 ld a,(potion_in_use)
 dec a
; jp z,update_potion_status
 ret nz 

update_potion_status:
; ld hl,(potion_timer)
; ld de,1
; sbc hl,de
; ld (potion_timer),hl
 ld a,(potion_timer)
 dec a
 ld (potion_timer),a
 jr z,done_with_potion
 call get_current_position
 ld a,(hl)
; or a
 cp clear
 jr z,update_potion_status2
; xor a
 ld a,clear
 ld (hl),a
 jp tilemap
; ret

update_potion_status2:
 ld a,(current_sprite_number)
 ld (hl),a
 jp tilemap

done_with_potion:
 call get_current_position
 ld a,(current_sprite_number)
 ld (hl),a
 xor a
 ld (potion_in_use),a
 jp tilemap
 
use_potion:
 ld a,(potion_in_use)
 or a
 ret nz
 ld a,(potions)
 or a
 ret z
 dec a
 ld (potions),a
 ld a,1
 ld (potion_in_use),a
 ld a,$49
 ld (potion_timer),a
 ret 

infos:
 res plotloc, (iy+plotflags)
 bcall(_grbufclr)
 call ionFastCopy
 ld bc,0*256+55
 ld de,94*256+55
 ld h,1
 bcall(_iline)
 ld c,63
 ld de,0*256+1
 bcall(_iline)
 ld de,94*256+63
 bcall(_iline)
 ld bc,94*256+1
 bcall(_iline)
 ld de,0*256+1
 bcall(_iline)
 ld de,1*256+5
 ld hl,title
 call text
 ld de,10*256+3
 ld hl,livestxt
 call text
 push hl
 ld a,(lives)
 bcall(_setxxop1)
 ld a,1
 bcall(_dispop1a)
 pop hl
 ld de,18*256+3
 call text
 push hl
 ld a,(level)
 inc a
 bcall(_setxxop1)
 ld a,1
 bcall(_dispop1a)
 pop hl
 ld de,26*256+3
 call text
 push hl
 ld a,(enemy_table)
 bcall(_setxxop1)
 ld a,2
 bcall(_dispop1a)
 pop hl
 ld de,34*256+3
 call text
 push hl
 ld a,(key_status)
 dec a
 jr nz,infos2
 ld hl,have_text 
 jr infos3
infos2:
 ld hl,dont_have_text
infos3:
; bcall(_setxxop1)
; ld a,1
; bcall(_dispop1a)
 ld de,34*256+18
 call text
 pop hl
 ld de,42*256+3
 call text
 push hl
 ld a,(bullets)
 bcall(_setxxop1)
 ld a,2
 bcall(_dispop1a)
 pop hl
 ld de,50*256+3
 call text
 push hl
 ld a,(potions)
 bcall(_setxxop1)
 ld a,2
 bcall(_dispop1a)
 pop hl
 ld de,55*256+50
 call text
 ld a,16
 ld hl,alien_ship
 ld de,plotsscreen+(20*12)+6
draw_ship:
 ld bc,5
 ldir
 ld bc,12-5
 ex de,hl
 add hl,bc
 ex de,hl
 dec a
 jr nz,draw_ship
 
 call ionFastCopy
infos_pause:
 ld b,$FD
 call direct_input
 cp 254
 jp nz,infos_pause
 jp tilemap 

smooth_delay:
 ld a,(enemy_table)
 ld b,a
 ld a,(max_enemies)
 sub b
 inc a
 ei
smooth_delay2:
 ld b,1
smooth_delay3:
 halt
 djnz smooth_delay3
 dec a
 jr nz,smooth_delay2
 di
 ret 

move_enemies:
 ld de,enemy_table
 ld a,(de)
 or a
 ret z
 ld b,a
move_enemies2:
 inc de
 push de				; this screws up the stack for exiting...
 push bc				;
 ld b,8
 call ionRandom
 or a
 jp z,enemy_down
 dec a
 jp z,enemy_left
 dec a
 jp z,enemy_right
 dec a
 jp z,enemy_up
move_enemies3:
 pop bc
 pop de
 inc de
 djnz move_enemies2
 ret
 
enemy_down:
 push de
 inc de
 ld a,(de)
 pop de
 cp 15
 jr z,move_enemies3
 call get_current_enemy_position
 ld a,(ix+24)
 cp clear
 jp z,dead
 ld b,a
 ld a,(current_sprite_number)
 cp b
; cp current_sprite_number
 jp z,dead
 ld a,b
 or a
 jp nz,move_enemies3
 push de
 inc de
 ld a,(de)
 inc a
 ld (de),a
 pop de
; ld (hl),enemy
 ld (ix+24),enemy
; or a
; ld de,12*2
; sbc hl,de
 ld (hl),0 
 call tilemap
 jp move_enemies3

enemy_left: 
 ld a,(de)
 or a
 jr z,move_enemies3
 call get_current_enemy_position
 dec hl
 ld a,(hl)
 cp clear 
 jp z,dead
 ld b,a
 ld a,(current_sprite_number)
 cp b
; cp current_sprite_number
 jp z,dead
 ld a,b
 or a
 jp nz,move_enemies3
 ld a,(de)
 dec a
 ld (de),a
 ld (hl),enemy
 inc hl
 ld (hl),0
 call tilemap
 jp move_enemies3

enemy_right:
 ld a,(de)
 cp 23
 jr z,move_enemies3
 call get_current_enemy_position
 inc hl
 ld a,(hl)
 cp clear
 jp z,dead
 ld b,a
 ld a,(current_sprite_number)
 cp b
; cp current_sprite_number
 jp z,dead
 ld a,b
 or a
 jp nz,move_enemies3
 ld a,(de)
 inc a
 ld (de),a
 ld (hl),enemy
 dec hl
 ld (hl),0 
 call tilemap
 jp move_enemies3

enemy_up:
 push de
 inc de
 ld a,(de)
 pop de
 or a
 jp z,move_enemies3
 call get_current_enemy_position
 ld a,(ix-24)
 cp clear
 jp z,dead
 ld b,a
 ld a,(current_sprite_number)
 cp b
; cp current_sprite_number
 jp z,dead
 ld a,b
 or a
 jp nz,move_enemies3
 push de
 inc de
 ld a,(de)
 dec a
 ld (de),a
 pop de
; ld (hl),enemy
 ld (ix-24),enemy
; ld de,12*2
; add hl,de
 ld (hl),0
 call tilemap
 jp move_enemies3

get_current_enemy_position:	; de = x, de+1 = y, hl&ix are positions returned (for kicks)
 push de
 push de
 inc de
 ld a,(de)
 ld b,a
 add a,a
 add a,b
 add a,a
 add a,a
 ld l,a
 ld h,0
 add hl,hl
 pop de
 ld a,(de)
 ld c,a
 ld b,0
 add hl,bc
 ld de,map_var
 add hl,de
 pop de
 push hl
 pop ix
 ret

fire:
 ld a,(bullets)
 or a
 ret z
 dec a
 ld (bullets),a
 ld a,(facing)
 or a
 jr z,fire_down
 dec a
 jr z,fire_left
 dec a
 jr z,fire_right
 jp fire_up

fire_down:
 call get_current_position		; get current position on tilemap
fire_down2:
 ld de,12*2				; 24 bytes per tilemap row		
 add hl,de				; get position just below character
 ld a,(hl)				; put value into a
 cp brick				; is the value less than a brick?
 jr c,fire_down3			; place the bullet if so
 cp enemy				; is the value an enemy?
 jr nz,fire_down5			; if not,  finish up the firing loop
 ld (hl),0
 push hl
 push de
 call enemy_dead
; call build_enemy_table
 pop de
 pop hl
fire_down5:
 cp breakable_block
 jr nz,fire_down6
 ld (hl),potion
fire_down6:
 or a
 sbc hl,de
 ld a,(hl)
 cp p_down
 jp z,nokey2
 ld (hl),0
; call tilemap
 jp nokey2
fire_down3:
 ld (hl),bullet2
 push hl
 or a
 sbc hl,de
 ld a,(hl)
 cp p_down
 jr z,fire_down4
 ld (hl),0
fire_down4:
 call tilemap
 pop hl
 jr fire_down2

fire_left:
 call get_current_position
fire_left2:
 dec hl
 ld a,(hl)
 cp brick
 jr c,fire_left3
 cp enemy
 jr nz,fire_left5
 ld (hl),0
 push hl
; call build_enemy_table
 call enemy_dead
 pop hl
fire_left5:
 cp breakable_block
 jr nz,fire_left6
 ld (hl),potion
fire_left6:
 inc hl
 ld a,(hl)
 cp p_left
 jp z,nokey2
; jp nc,nokey
 ld (hl),0
; call tilemap
 jp nokey2
fire_left3:
 ld (hl),bullet1
 push hl
 inc hl
 ld a,(hl)
 cp p_left
 jr z,fire_left4
 ld (hl),0
fire_left4:
 call tilemap
 pop hl
 jr fire_left2

fire_right:
 call get_current_position
fire_right2:
 inc hl
 ld a,(hl)
 cp brick
 jr c,fire_right3
 cp enemy
 jr nz,fire_right5
 ld (hl),0
 push hl
; call build_enemy_table
 call enemy_dead
 pop hl
fire_right5:
 cp breakable_block
 jr nz,fire_right6
 ld (hl),potion
fire_right6:
 dec hl
 ld a,(hl)
 cp p_right 
 jp z,nokey2
; jp nc,nokey
 ld (hl),0
; call tilemap
 jp nokey2
fire_right3:
 ld (hl),bullet1
 push hl
 dec hl
 ld a,(hl)
 cp p_right
 jr z,fire_right4
 ld (hl),0
fire_right4:
 call tilemap
 pop hl
 jr fire_right2


fire_up:
 call get_current_position
fire_up2:
 ld de,12*2
 or a
 sbc hl,de
 ld a,(hl)
 cp brick
 jr c,fire_up3
 cp enemy
 jr nz,fire_up5
 ld (hl),0
 push hl
 push de
; call build_enemy_table
 call enemy_dead
 pop de
 pop hl
fire_up5:
 cp breakable_block
 jr nz,fire_up6
 ld (hl),potion
fire_up6:
 add hl,de
 ld a,(hl)
 cp p_up
 jp z,nokey2
; jp nc,nokey
 ld (hl),0
; call tilemap
 jp nokey2
fire_up3:
 ld (hl),bullet2
 push hl
 add hl,de
 ld a,(hl)
 cp p_up
 jr z,fire_up4
 ld (hl),0
fire_up4:
 call tilemap
 pop hl
 jr fire_up2

player_down:
 ld a,(playery)
 cp 7
 jp z,change_view_down
 call get_current_position
 ld b,0 
 ld a,(ix+24)
 cp brick			; carry is greater than or equal to.
 call nc,check_object
 xor a
 ld (facing),a
; ld (hl),a
 ld (ix),a
; ld (ix+24),sprite_number
 ld (ix+24),p_down
 ld a,(playery)
 inc a
 ld (playery),a
 ld a,p_down
 ld (current_sprite_number),a
 jp tilemap
; jp nokey

player_up:
 ld a,(playery)
 or a
 jp z,change_view_up
 call get_current_position
 ld b,3
 ld a,(ix-24)
 cp brick
 call nc,check_object
 xor a
; ld (hl),a
; ld (ix-24),sprite_number
 ld (ix),a
 ld (ix-24),p_up
 ld a,(playery)
 dec a
 ld (playery),a
 ld a,3
 ld (facing),a
; jp tilemap
 ld a,p_up
 ld (current_sprite_number),a
 jp tilemap
; jp nokey

player_left:
 ld a,(playerx)
 or a
 jp z,adjust_view_left
 call get_current_position
 ld b,1
 ld a,(ix-1)
 cp brick
 call nc,check_object
 xor a
; ld (hl),a
; dec hl
; ld (hl),p_left
 ld (ix),a
 ld (ix-1),p_left
 ld a,(playerx)
 dec a
 ld (playerx),a
 ld a,1
 ld (facing),a
; jp tilemap
 ld a,p_left
 ld (current_sprite_number),a
 jp tilemap
; jp nokey

player_right:
 ld a,(playerx)
 cp 11
 jp z,adjust_view_right
 call get_current_position
 ld b,2
 ld a,(ix+1)
 cp brick
 call nc,check_object
 xor a
; ld (hl),a
; inc hl
; ld (hl),p_right
 ld (ix),a
 ld (ix+1),p_right
 ld a,(playerx)
 inc a
 ld (playerx),a
 ld a,2
 ld (facing),a
 ld a,p_right
 ld (current_sprite_number),a
 jp tilemap
; jp nokey

change_view_up:
 ld a,(mapy)
 or a
 ret z
 call get_current_position
 ld a,(ix-24)
 cp spike
 jp nc,dead2				; greater than or equal too
 cp brick
 ret z
; -----
 ld b,8
 push hl
change_view_up2:
 ld a,(mapy)
 dec a
 ld (mapy),a
 push bc
 call tilemap
 call delay
 pop bc
 djnz change_view_up2
 pop hl
; -----
 ld (hl),0
; xor a
; ld (mapy),a
 ld a,7
 ld (playery),a
 call get_current_position
 ld a,p_up
 ld (hl),a
 ld (current_sprite_number),a
 ld a,3
 ld (facing),a
 jp tilemap

adjust_view_left:
 ld a,(mapx)
 or a
 ret z
 call get_current_position
 ld a,(ix-1)
 cp spike
 jp nc,dead2
 cp brick
 ret z
; -----
 ld b,12
 push hl
adjust_view_left2:
 ld a,(mapx)
 dec a
 ld (mapx),a
 push bc
 call tilemap
 call delay
 pop bc
 djnz adjust_view_left2
 pop hl
; -----
 ld (hl),0
; xor a
; ld (mapx),a
 ld a,11
 ld (playerx),a
 call get_current_position
 ld a,p_left
 ld (hl),a
 ld (current_sprite_number),a
 ld a,1
 ld (facing),a
 jp tilemap

change_view_down:					
 ld a,(mapy)
 cp 8
 ret z
 call get_current_position
 ld a,(ix+24)
 cp spike
 jp nc,dead2
 cp brick
 ret z
; -----
 ld b,8
 push hl
change_view_down2:
 ld a,(mapy)
 inc a
 ld (mapy),a
 push bc
 call tilemap
 call delay
 pop bc
 djnz change_view_down2
 pop hl
; -----
 ld (hl),0
; ld a,8
; ld (mapy),a
; ld a,1
 xor a
 ld (facing),a
 ld (playery),a
 call get_current_position
 ld a,p_down
 ld (hl),a
 ld (current_sprite_number),a
 jp tilemap

adjust_view_right:
 ld a,(mapx)
 cp 12
 ret z
 call get_current_position
 ld a,(ix+1)
 cp spike
 jp nc,dead2
 cp brick
 ret z
; -----
 ld b,12
 push hl
adjust_view_right2:
 ld a,(mapx)
 inc a
 ld (mapx),a
 push bc
 call tilemap
 call delay
 pop bc
 djnz adjust_view_right2
 pop hl
; -----
 ld (hl),0
; ld a,12
; ld (mapx),a
; ld a,1
 xor a
 ld (playerx),a
 call get_current_position
 ld a,p_right
 ld (hl),a
 ld (current_sprite_number),a
 ld a,2
 ld (facing),a
 jp tilemap

get_current_position:				; return position in ix&hl for kicks
 ld a,(mapy)
 ld b,a
 ld a,(playery)
 add a,b
 ld b,a
 add a,a
 add a,b
 add a,a
 add a,a
 ld l,a
 ld h,0
 add hl,hl
 ld a,(playerx)
 ld b,a
 ld a,(mapx)
 add a,b
 ld d,0
 ld e,a 
 add hl,de
 ld de,map_var
 add hl,de
 push hl
 pop ix
 ret

check_object:
 cp brick
 jr nz,check_object2
 pop hl
 ret 
check_object2:
 cp breakable_block
 jr nz,check_object3
 pop hl
 ret
check_object3:
 cp key
 jr nz,check_object4
 ld a,1
 ld (key_status),a
 ret
check_object4:
 cp potion
 jr nz,check_object5
 ld a,(potions)
 inc a
 ld (potions),a
 ret
check_object5:
 cp door
 call z,check_level_complete
 push af
 ld a,(potion_in_use)
 dec a
 jp z,enemy_dead2
 pop af
 pop bc
 pop bc
 jp dead3

check_level_complete:
 ld a,(key_status)
 dec a
 jr z,level_completed
 pop hl
 pop hl
 ret
level_completed:
; ---- put win code here -----
 pop hl
 pop hl
 pop hl
 ld a,(level)
 cp 5
 jr nz,continue_game
you_won:
 bcall(_grbufclr)
 bcall(_clrscrf)
 ld de,0*256+5			; y*256+x 
 ld hl,title
 call text
inv_title:
 ld hl,plotsscreen
 ld b,12*7
inv_title2:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 djnz inv_title2
 ld hl,win_text
 ld de,10*256+0
 call text
 ld de,17*256+0
 call text
 ld de,24*256+0
 call text
 ld de,31*256+0
 call text
 ld de,38*256+0
 call text
 ld de,45*256+0
 call text
 call ionFastCopy
 bcall(_getkey)
 ret
continue_game:				
 inc a
 ld (level),a
 jp get_level

tilemap:
 bcall(_grbufclr)		; damn xor sprites
 ld a,(mapy)
 ld b,a
 add a,a
 add a,b
 add a,a
 add a,a
 ld l,a
 ld h,0
 add hl,hl
tilemap_continue:
 ld a,(mapx)
 ld e,a
 ld d,0
 add hl,de
 ld de,map_var-1
 add hl,de
 ld c,8
tilemap2:
 ld b,12
tilemap3:
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 ld e,a
 ld d,0
 push hl
 push bc
 ld ix,sprites
 add ix,de
 call draw_sprite
 pop bc
 pop hl
 djnz tilemap3
 ld de,12
 add hl,de
 dec c
 jr nz,tilemap2
 jp ionFastCopy

draw_sprite:
 ld a,8
 sub c
 add a,a
 add a,a
 add a,a
 ld l,a
 ld a,12
 sub b
 add a,a
 add a,a
 add a,a
 ld b,8
 jp ionPutSprite

search_for_bullet:
 ld hl,map_var
 ld a,bullet1
 ld bc,384
 cpir
 ret

search_for_second_bullet:
 ld hl,map_var
 ld a,bullet2
 ld bc,384
 cpir 
 ret

exit_enemy_dead:
 pop hl
 ret

enemy_dead2:
 pop af
 cp spike
 jr z,exit_enemy_dead
 cp spike2
 jr z,exit_enemy_dead
 ld a,b
; ld (facing),a
; ld a,(facing)
 or a
 jr nz,enemy_not_down
 ld de,24
 add hl,de
 jr enemy_dead3
enemy_not_down:
 dec a
 jr nz,enemy_not_left
 dec hl
 jr enemy_dead3
enemy_not_left:
 dec a
 jr nz,enemy_not_right
 inc hl
 jr enemy_dead3
enemy_not_right:
 ld de,-24
 add hl,de 

enemy_dead3:
 ld (hl),0

enemy_dead:
 ld a,(key_status)
 or a
 jr nz,build_enemy_table
 ld a,(enemy_table)
 dec a
 jr nz,build_enemy_table
 push hl
; ld (hl),0
 call search_for_bullet
 call nz,search_for_second_bullet
 jp nz,last_enemy_death_sequence2
 dec hl						; this seems to 
 ld (hl),0					; be the problem
enemy_dead_continue:
; jp last_enemy_death_sequence

last_enemy_death_sequence:
; ld a,(potion_in_use)
; dec a 
; jr z,last_enemy_death_sequence_inv
 pop hl
 ld (hl),key
 push ix
 call tilemap
 call build_enemy_table
 call ionFastCopy
 pop ix
 ret

last_enemy_death_sequence2:
 pop hl
; ld a,(current_sprite_number)
; ld (hl),a
 ld a,1
 ld (key_status),a
 push ix
 call build_enemy_table
 call tilemap
 call ionFastCopy
 pop ix
 ret

build_enemy_table:
 or a
 sbc hl,hl
 ld (enemy_table),hl
 ld de,enemy_table
 ld bc,12*8*2*2
 ld hl,map_var
build_enemy_table2:
 ld a,enemy
 cpir
 ld a,c
 or b
 ret z
 ld a,(enemy_table)
 inc a
 ld (enemy_table),a 
 push bc
 push de
 push hl
 ld hl,12*8*2*2
 or a
 sbc hl,bc
 ld de,24
 ld b,-1
enemy_div24:
 inc b
 or a
 sbc hl,de
 jr nc,enemy_div24
 ld a,l
 add a,23
 pop hl
 pop de
 inc de
 ld (de),a
 inc de
 ld a,b
 ld (de),a
 pop bc
 jr build_enemy_table2

dead:
 pop bc
 pop bc
dead2:
 ld a,(potion_in_use)
 dec a
 jp z,enemy_dead3
 pop hl
dead3:
 ld a,(current_sprite_number)
 ld ix,sprites
 add a,a
 add a,a
 add a,a
 ld e,a
 ld d,0
 add ix,de
 call Put_Dead_Sprite
 ld b,6
 ld ix,death_sprites
death_animation:
 push bc
 call Put_Dead_Sprite
 call ionFastCopy
 call Put_Dead_Sprite
 ld b,20
 ei
 call delay_lp
 pop bc
 ld de,8
 add ix,de
 djnz death_animation
 ld a,(lives)
 dec a
 ld (lives),a
 jp nz,get_level
 ret

delay:
 ei
 ld b,6
delay_lp:
 halt
 djnz delay_lp
 di
 ret

put_dead_sprite:
 push ix
 ld a,(playery)
 add a,a
 add a,a
 add a,a
 ld l,a
 ld a,(playerx)
 add a,a
 add a,a
 add a,a
 ld b,8
 call ionPutSprite
 pop ix
 ret

nokey2:
 call tilemap
nokey:
 call move_enemies
 call smooth_delay
 call check_potion
 ei
 halt				; thanks to Jason K.
 di
 ld b,$FE
 call direct_input
 cp $FF
 jr nz,nokey 
 ld b,$BF
 call direct_input
 cp $FF
 jr nz,nokey
 ret

direct_input:
 ld a,$FF
 out (1),a
 ld  a,b
 out (1),a
 in a,(1)
 ret

scroll: 
 ld b,7
scroll2:
 push bc
 push hl
 ld hl,plotsscreen+(12*9)
 ld de,plotsscreen+(12*8)
 ld bc,756-(12*9)
 ldir
 call ionFastCopy
 ei
 ld b,17
 call delay_lp
 pop hl
 pop bc
 ld a,$FF
 out (1),a
 ld a,$FE
 out (1),a
 in a,(1)
 cp $FF
 jr z,scroll3
 pop bc
 pop hl		; gotta take the call out
 jp initialize_game
scroll3:
 djnz scroll2
 ret

clear_line:
 xor a
 ld de,plotsscreen+(12*56)
 ld b,12*7
clear_line2:
 ld (de),a
 inc de
 djnz clear_line2
 ret

text:
 ld (pencol),de
 bcall(_vputs)
 ret

title:
 .db "The Adventures of Melt Man",0
 .db "  On one seemingly peaceful",0
 .db "day, our hero Melt Man was",0
 .db "taken captive by a mob of",0  
 .db "angry aliens.  Said aliens",0
 .db "then took our hero to their",0
 .db "mothership and told him of",0
 .db "their evil plan.  They were",0
 .db "to use Melt Man as a sort of",0
 .db "guniea pig in some experi-",0
 .db "ments.  These experiments",0
 .db "would test his ability to",0
 .db "reason, react, and finally",0
 .db "to survive.  If he did not",0
 .db "pass this test, the aliens",0
 .db "would exterminate the",0
 .db "whole human race.  The",0
 .db "stage was now set for our",0
 .db "hero ... ",0

livestxt:
 .db "Lives: ",0
 .db "Level: ",0
 .db "Enemies: ",0
 .db "Key: ",0
 .db "Bullets: ",0
 .db "Potions: ",0
 .db "Press Enter",0

Have_text:
 .db "Have",0
Dont_have_text:
 .db "Have not",0

win_text:
 .db "Congratulations.  You have",0
 .db "saved the world!  You",0
 .db "were able to defeat the",0
 .db "evil aliens who took you",0
 .db "captive.  We are eternally",0
 .db "greatful.",0

sprites:
blank:
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

bullet:
 .db %00000000
 .db %00000001
 .db %11101111
 .db %11111111
 .db %11111110
 .db %00010000
 .db %00000000
 .db %00000000

;bullet2:
 .db %00111000
 .db %00111000
 .db %00111000
 .db %00011100
 .db %00111000
 .db %00111000
 .db %00111000
 .db %01110000

;brick:
 .db %11111111
 .db %10101011
 .db %11010101
 .db %11111111
 .db %11111111
 .db %10101011
 .db %11010101
 .db %11111111

;door:
 .db %11111111
 .db %10000001
 .db %10000001
 .db %10110001
 .db %10110001
 .db %10000001
 .db %10000001
 .db %11111111

;spike:
 .db %00001111
 .db %11111111
 .db %00001111
 .db %00000001
 .db %00001111
 .db %11111111
 .db %00001111
 .db %00000001

;spike2:
 .db %11110000
 .db %11111111
 .db %11110000
 .db %10000000
 .db %11110000
 .db %11111111
 .db %11110000
 .db %10000000

;enemy
 .db %00011000
 .db %00111100
 .db %01011010
 .db %11011011
 .db %01111110
 .db %00111100
 .db %01100110
 .db %11000011

;player_right:
 .db %01111100
 .db %11110010
 .db %11111111
 .db %01011110
 .db %01101101
 .db %00111100
 .db %01111110
 .db %11100111

;player_left:
 .db %00111110
 .db %01001111
 .db %11111111
 .db %01111010
 .db %10110110
 .db %00111100
 .db %01111110
 .db %11100111

;player_up:
 .db %00011000
 .db %00111100
 .db %00111100
 .db %01111110
 .db %10111101
 .db %00111100
 .db %01111110
 .db %11100111

;player_down:
 .db %00011000
 .db %00100100
 .db %00111100
 .db %01111110
 .db %10111101
 .db %00111100
 .db %01111110
 .db %11100111

;key:
 .db %00000000
 .db %00000010
 .db %00000101
 .db %00001000
 .db %01110100
 .db %10010000
 .db %10010000
 .db %01100000

;breakable_box:
 .db %11111111
 .db %10000001
 .db %10000001
 .db %10000001
 .db %10000001
 .db %10000001
 .db %10000001
 .db %11111111

;potion
 .db %00111000
 .db %00101000
 .db %00101000
 .db %01000100
 .db %11111110
 .db %11111110
 .db %11111110
 .db %01111100

;clear:
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

death_sprites:
 .db %00011000
 .db %00111100
 .db %00111100
 .db %01111110
 .db %01111110
 .db %00111100
 .db %01111110
 .db %11100111

 .db %00000000
 .db %00011000
 .db %00111100
 .db %00111100
 .db %01111110
 .db %00111100
 .db %01111110
 .db %11100111

 .db %00000000
 .db %00000000
 .db %00011000
 .db %00111100
 .db %00111100
 .db %01011010
 .db %00111100
 .db %01100110

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00011000
 .db %00111100
 .db %00111100
 .db %01100110

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00011000
 .db %00111100
 .db %00111100

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00011100
 .db %01111110

alien_ship:
 .db %00000000,%00000001,%11111111,%00000000,%00000000
 .db %00000000,%00000111,%11111111,%11000000,%00000000
 .db %00000000,%01111111,%11111111,%11111100,%00000000
 .db %00000011,%11101011,%11010111,%10101111,%10000000
 .db %00001111,%11010111,%10101111,%01011111,%11100000
 .db %00011111,%11111111,%11111111,%11111111,%11110000
 .db %00111111,%11111111,%11111111,%11111111,%11111000
 .db %00111000,%11000110,%00110001,%10001100,%01111000
 .db %00111111,%11111111,%11111111,%11111111,%11111000
 .db %00111111,%11111111,%11111111,%11111111,%11111000
 .db %00011111,%11101011,%11010111,%10101111,%11110000
 .db %00001111,%11010111,%10101111,%01011111,%11100000
 .db %00000011,%11111111,%11111111,%11111111,%10000000
 .db %00000000,%01111111,%11111111,%11111100,%00000000
 .db %00000000,%00000111,%11111111,%11000000,%00000000
 .db %00000000,%00000001,%11111111,%00000000,%00000000
 

#include "melt1.inc"

.end
END
 

