#include "usgard.h"

.ORG 0
.db "MegaMan 85 v1.0",0

pencol = $8333
penrow = $8334

textflags       =       5           ; IY OFFSET VALUE
texteraseBelow  =       1
textsscrolled   =       2
textInverse     =       3
Lunderscore     =     05fh     ;5fh
lspace          =     020h
curcol = $800D
currow = $800C
SAVESSCREEN = TEXT_MEM
PLOTSSCREEN = $8641
_clrlcdfull = $8C56
_getk = GET_KEY

_CPHLDE  = $008E  

_PUTC       =    $8C41  

_VPUTMAP    =    M_CHARPUT
  
_VPUTS      =    	$8C4A  
_DISPHL     =    D_HL_DECI




#DEFINE	kDown	K_DOWN
#DEFINE	kLeft	K_LEFT
#DEFINE	kRight	K_RIGHT
#DEFINE	kUp	K_UP
#DEFINE	kEnter	K_ENTER
#DEFINE	kMode	K_EXIT
#DEFINE	kDel	K_DEL
#DEFINE	kYEq	35h
#DEFINE	k2nd	36h
#DEFINE	kAlpha	30h

#define	xmm	SAVESSCREEN		; Mega Man's x-coord
#define	ymm	SAVESSCREEN+2	; Mega Man's y-coord
#define	jrem	SAVESSCREEN+3	; remebers the y-coord where the jump started
#define	jchk	SAVESSCREEN+4	; check for jump: 0=no jump 1=jump up 2=jump down
#define	wchk	SAVESSCREEN+5	; check if ok to shoot again: 0=yes >0=no
#define	dir	SAVESSCREEN+6	; direction Mega Man is facing: 0=left 1=right
#define	x2	SAVESSCREEN+7	; x-coord for many different things
#define	y2	SAVESSCREEN+8	; y-coord for many different things
#define	xb	SAVESSCREEN+9	; x-coord for boss
#define	yb	SAVESSCREEN+10	; y-coord for boss
#define	wx1	SAVESSCREEN+11	; x-coord for 1st shot
#define	wy1	SAVESSCREEN+12	; y-coord for 1st shot
#define	wx2	SAVESSCREEN+13	; x-coord for 2nd shot
#define	wy2	SAVESSCREEN+14	; y-coord for 2nd shot
#define	wx3	SAVESSCREEN+15	; x-coord for 3rd shot
#define	wy3	SAVESSCREEN+16	; y-coord for 3rd shot
#define	bdir	SAVESSCREEN+17	; direction of boss: 0=left 1=right
#define	wdir1	SAVESSCREEN+18	; direction of 1st shot: 0=left 1=right
#define	wdir2	SAVESSCREEN+19	; direction of 2nd shot: 0=left 1=right
#define	wdir3	SAVESSCREEN+20	; direction of 3rd shot: 0=left 1=right
#define	wchk1	SAVESSCREEN+21	; check if bullet #1 is still on screen: 0=no 1=yes
#define	wchk2	SAVESSCREEN+22	; check if bullet #2 is still on screen: 0=no 1=yes
#define	wchk3	SAVESSCREEN+23	; check if bullet #3 is still on screen: 0=no 1=yes
#define	curlvl	SAVESSCREEN+24	; pointer to the beginning of the level data
#define	feet	SAVESSCREEN+26	; check for which running sprite to use: 0 or 1
#define	xscr	SAVESSCREEN+27	; x scroller
#define	tempscr	SAVESSCREEN+29	; amount scrolled within incomplete block
#define	schk	SAVESSCREEN+31	; scroll check: 0=no 1=yes
#define	boss	SAVESSCREEN+33	; which boss u will face: 1 2 3=top row 4 5 6=middle row 7 8 9=bottom row
#define	wpnspr	SAVESSCREEN+34	; current weapon sprite
#define	smlspr	SAVESSCREEN+36	; current 8x8 sprite
#define	curpic	SAVESSCREEN+38	; current pic to draw
#define	bosspic	SAVESSCREEN+40	; current boss sprite
#define	death	SAVESSCREEN+42	; check if dead: 0=no 1=yes
#define	win	SAVESSCREEN+44	; check if level is completed: 0=no 1=yes
#define	xe	SAVESSCREEN+45	; x-coord for enemy
#define	ye	SAVESSCREEN+46	; y-coord for enemy
#define	edir	SAVESSCREEN+47	; direction enemy is travelling
#define	echk	SAVESSCREEN+48	; check for onscreen enemy: 0=no 1=i 2=t 3=dead
#define	enspr	SAVESSCREEN+49	; current enemy sprite
#define	ecount	SAVESSCREEN+51	; counts how many pixels enemy has moved (32 pixels allowed)
#define	ecount2	SAVESSCREEN+52	; counts how many pixels have scrolled since enemy appeared
#define	bchk	SAVESSCREEN+53	; checks for boss: 0=no 1=yes
#define	bwx	SAVESSCREEN+54	; x-coord of boss's shot
#define	bwspr	SAVESSCREEN+55	; sprite for boss's shot
#define	bwchk	SAVESSCREEN+57	; check for boss's shot onscreen
#define	bjchk	SAVESSCREEN+58	; check for boss's jump: 0=no jump 1=jump down 2=jump up
#define	lv1done	SAVESSCREEN+59	; checks levels completed: 0 1 2=top row 3 _ 4=middle row 5 6 7=bottom row
#define	anpw	SAVESSCREEN+60	; checks for password dots corresponding to Anchorman
#define	mapw	SAVESSCREEN+61	; checks for password dots corresponding to Mailman
#define	mdpw	SAVESSCREEN+62	; checks for password dots corresponding to Madman
#define	dopw	SAVESSCREEN+63	; checks for password dots corresponding to Doorman
#define	popw	SAVESSCREEN+64	; checks for password dots corresponding to Policeman
#define	frpw	SAVESSCREEN+65	; checks for password dots corresponding to Freshman
#define	sepw	SAVESSCREEN+66	; checks for password dots corresponding to Top Secret Weapon
#define	sapw	SAVESSCREEN+67	; checks for password dots corresponding to Salesman
#define	mipw	SAVESSCREEN+68	; checks for password dots corresponding to Milkman
#define	tankpw	SAVESSCREEN+69	; checks for password dots corresponding to energy tanks
#define	lives	SAVESSCREEN+70	; the number of lives you have
#define	tanks	SAVESSCREEN+71	; the number of energy tanks you have
#define	remlvl	SAVESSCREEN+72	; remembers which level you were on before the special boss screens
#define	wpn	SAVESSCREEN+74	; which weapon you are using: 1=an...5=??...9=mi
#define	wrem1	SAVESSCREEN+75	; remembers x-coord where short-range bullet #1 must stop
#define	wrem2	SAVESSCREEN+76	; remembers x-coord where short-range bullet #2 must stop
#define	wrem3	SAVESSCREEN+77	; remembers x-coord where short-range bullet #3 must stop
#define	bcount	SAVESSCREEN+78	; special counting variable used for final bosses
#define	item	SAVESSCREEN+79	; check for item in level: 0=no 1=yes 2=got
#define	enp	SAVESSCREEN+80	; life energy
#define	enan	SAVESSCREEN+81	; energy for anchor toss
#define	enma	SAVESSCREEN+82	; energy for stamp throw
#define	enmd	SAVESSCREEN+83	; energy for swearing scream
#define	endo	SAVESSCREEN+84	; energy for splinter shot
#define	ense	SAVESSCREEN+85	; energy for top secret weapon
#define	enpo	SAVESSCREEN+86	; energy for badge boomerang
#define	enfr	SAVESSCREEN+87	; energy for zit shield
#define	ensa	SAVESSCREEN+88	; energy for bill charge
#define	enmi	SAVESSCREEN+89	; energy for milk bubble
#define	enwpn	SAVESSCREEN+90	; energy for current weapon
#define	ene	SAVESSCREEN+91	; energy for enemy
#define	enb	SAVESSCREEN+92	; energy for boss
#define	hchk	SAVESSCREEN+93	; check if you've been hit: 0=no 1=yes
#define	pixelsetting	SAVESSCREEN+100
prog_start:
  ld hl,$fc00
  ld (hl),0
  ld de,$fc01
  ld bc,1023
  ldir


  ld hl,SAVESSCREEN
  ld (hl),0
  ld de,SAVESSCREEN
  ld bc,128
  ldir

R_0: 	call BUFCLR
R_1: 	call BUFCOPY2
	ld de,15*256+34
	ld (CURSOR_X),de
R_2: 	ld hl,djs
	ROM_CALL(D_ZM_STR)
	ld de,25*256+49
	ld (CURSOR_X),de
R_3: 	ld hl,pre
	ROM_CALL(D_ZM_STR)
	ld de,15*256+34
	ld (CURSOR_X),de
R_4: 	ld hl,djs
	ROM_CALL(D_ZM_STR)
djsp_loop:
	ROM_CALL(GET_KEY)
	cp $37
	ret z
	or a
	jr z,djsp_loop

	ROM_CALL(_clrlcdfull)
	ld hl,1*256+17
	ld (pencol),hl
R_5: 	ld hl,intro1
	ROM_CALL(_VPUTS)
	ld hl,7*256+17
	ld (pencol),hl
R_6: 	ld hl,intro2
	ROM_CALL(_VPUTS)
	ld hl,13*256+17
	ld (pencol),hl
R_7: 	ld hl,intro3
	ROM_CALL(_VPUTS)
	ld hl,19*256+17
	ld (pencol),hl
R_8: 	ld hl,intro4
	ROM_CALL(_VPUTS)
	ld hl,25*256+17
	ld (pencol),hl
R_9: 	ld hl,intro5
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_10: 	ld hl,intro6
	ROM_CALL(_VPUTS)
	ld hl,37*256+17
	ld (pencol),hl
R_11: 	ld hl,intro7
	ROM_CALL(_VPUTS)
	ld hl,43*256+17
	ld (pencol),hl
R_12: 	ld hl,intro8
	ROM_CALL(_VPUTS)
	ld hl,49*256+17
	ld (pencol),hl
R_13: 	ld hl,intro9
	ROM_CALL(_VPUTS)
	ld hl,55*256+17
	ld (pencol),hl
R_14: 	ld hl,intro10
	ROM_CALL(_VPUTS)
story_loop:
	ROM_CALL(GET_KEY)
	cp K_EXIT
	ret z
	or a
	jr z,story_loop
	ROM_CALL(_clrlcdfull)
	ld hl,1*256+17
	ld (pencol),hl
R_15: 	ld hl,intro11
	ROM_CALL(_VPUTS)
	ld hl,7*256+17
	ld (pencol),hl
R_16: 	ld hl,intro12
	ROM_CALL(_VPUTS)
	ld hl,13*256+17
	ld (pencol),hl
R_17: 	ld hl,intro13
	ROM_CALL(_VPUTS)
	ld hl,19*256+17
	ld (pencol),hl
R_18: 	ld hl,intro14
	ROM_CALL(_VPUTS)
	ld hl,25*256+17
	ld (pencol),hl
R_19: 	ld hl,intro15
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_20: 	ld hl,intro16
	ROM_CALL(_VPUTS)
	ld hl,37*256+17
	ld (pencol),hl
R_21: 	ld hl,intro17
	ROM_CALL(_VPUTS)
	ld hl,43*256+17
	ld (pencol),hl
R_22: 	ld hl,intro18
	ROM_CALL(_VPUTS)
	ld hl,49*256+17
	ld (pencol),hl
R_23: 	ld hl,intro19
	ROM_CALL(_VPUTS)
	ld hl,55*256+17
	ld (pencol),hl
R_24: 	ld hl,intro20
	ROM_CALL(_VPUTS)
story_loop2:
	ROM_CALL(GET_KEY)
	cp K_EXIT
	ret z
	or a
	jr z,story_loop2
	ROM_CALL(_clrlcdfull)
R_25: 	call BUFCLR
	xor a			; no levels completed
	ld (lv1done),a
	ld (tanks),a	; 0 energy tanks
	inc a
	ld (tankpw),a	; 0 energy tanks (for password system)
	inc a
	inc a
	ld (lives),a	; 3 lives
R_26: 	ld hl,logo		; display title screen
	ld de,PLOTSSCREEN
	ld bc,768
	ldir
R_27: 	call BUFCOPY2
	ld a,17
	ld (x2),a
	ld a,43
	ld (y2),a
R_28: 	ld hl,pwdot
	ld (smlspr),hl
menu_loop:
R_29: 	call xor_8x8
R_30: 	call BUFCOPY2
R_31: 	call xor_8x8
	ROM_CALL(GET_KEY)
	cp K_UP
	jr z,curs_change
	cp K_DOWN
	jr z,curs_change
	cp $09
	jr z,title_done
	cp K_EXIT
	jr nz,menu_loop
	ret
curs_change:
	ld a,(y2)
	ld b,a
	ld a,97
	sub b
	ld (y2),a
	jr menu_loop
title_done:
	ld a,(y2)
	cp 43
	jr z,cb_init
R_32: 	call enter_pw
	cp $37		; exit game if MODE was pressed on enter password screen
	ret z
cb_init:
	ld a,33
	ld (x2),a
	ld a,22
	ld (y2),a
	ROM_CALL(_clrlcdfull)
choose_boss:
R_33: 	call BUFCLR
R_34: 	ld hl,cbs
	ld de,PLOTSSCREEN
	ld bc,768
	ldir
	ld a,(lv1done)
	ld c,a
	bit 0,c
R_35: 	call nz,no_an
	bit 1,c
R_36: 	call nz,no_ma
	bit 2,c
R_37: 	call nz,no_md
	bit 3,c
R_38: 	call nz,no_do
	bit 4,c
R_39: 	call nz,no_po
	bit 5,c
R_40: 	call nz,no_fr
	bit 6,c
R_41: 	call nz,no_sa
	bit 7,c
R_42: 	call nz,no_mi
R_43: 	call BUFCOPY2
boss_loop:
R_44: 	call xor_corners
R_45: 	call BUFCOPY2
R_46: 	call xor_corners
	ROM_CALL(GET_KEY)
	cp K_UP
	jr z,bcurs_up
	cp K_DOWN
	jr z,bcurs_down
	cp K_LEFT
	jr z,bcurs_left
	cp K_RIGHT
	jr z,bcurs_right
	cp K_ENTER
	jr z,find_boss
	cp K_EXIT
	jr nz,boss_loop
	ROM_CALL(GET_KEY)	; clear the keybuffer
R_47: 	call BUFCLR
	ROM_CALL(_clrlcdfull)
	ret
bcurs_up:
	ld a,(y2)
	cp 1
	jr z,boss_loop
	ld a,(y2)
	sub 21
	ld (y2),a
	jr boss_loop
bcurs_down:
	ld a,(y2)
	cp 43
R_48: 	jp z,boss_loop
	ld a,(y2)
	add a,21
	ld (y2),a
R_49: 	jp boss_loop
bcurs_left:
	ld a,(x2)
	cp 2
R_50: 	jp z,boss_loop
	ld a,(x2)
	sub 31
	ld (x2),a
R_51: 	jp boss_loop
bcurs_right:
	ld a,(x2)
	cp 64
R_52: 	jp z,boss_loop
	ld a,(x2)
	add a,31
	ld (x2),a
R_53: 	jp boss_loop
find_boss:
	ld a,(y2)
	cp 1
	jr z,row1
	cp 22
	jr z,row2
	ld a,7
	jr found_row
row2:
	ld a,4
	jr found_row
row1:
	ld a,1
found_row:
	ld (boss),a
	ld a,(x2)
	cp 64
	jr z,add2
	cp 33
	jr nz,add0
	ld a,(boss)
	inc a
	jr add_done
add0:
	ld a,(boss)
	jr add_done
add2:
	ld a,(boss)
	add a,2
add_done:
	ld (boss),a
	ld a,44
	ld (xb),a
	ld a,27
	ld (yb),a
	ld a,(boss)
	cp 1
	jr z,an_init
	cp 2
	jr z,ma_init
	cp 3
	jr z,md_init
	cp 4
R_54: 	jp z,do_init
	cp 5
R_55: 	jp z,ti_init
	cp 6
R_56: 	jp z,po_init
	cp 7
R_57: 	jp z,fr_init
	cp 8
R_58: 	jp z,sa_init
	cp 9
R_59: 	jp z,mi_init
an_init:
	ld a,(lv1done)
	bit 0,a
R_60: 	jp nz,choose_boss
R_61: 	ld hl,ansl
R_62: 	call disp_boss
R_63: 	ld hl,wpan
	ld (bwspr),hl
	ld hl,54*256+46
	ld (pencol),hl
R_64: 	ld hl,a_n
	ROM_CALL(_VPUTS)
R_65: 	ld hl,lvlan
R_66: 	jp intro_done
ma_init:
	ld a,(lv1done)
	bit 1,a
R_67: 	jp nz,choose_boss
R_68: 	ld hl,masl
R_69: 	call disp_boss
R_70: 	ld hl,wpma
	ld (bwspr),hl
	ld hl,54*256+50
	ld (pencol),hl
R_71: 	ld hl,m_a
	ROM_CALL(_VPUTS)
R_72: 	ld hl,lvlma
R_73: 	jp intro_done
md_init:
	ld a,(lv1done)
	bit 2,a
R_74: 	jp nz,choose_boss
R_75: 	ld hl,mdsl
R_76: 	call disp_boss
R_77: 	ld hl,wpmd
	ld (bwspr),hl
	ld hl,54*256+52
	ld (pencol),hl
R_78: 	ld hl,m_d
	ROM_CALL(_VPUTS)
R_79: 	ld hl,lvlmd
R_80: 	jp intro_done
do_init:
	ld a,(lv1done)
	bit 3,a
R_81: 	jp nz,choose_boss
R_82: 	ld hl,dosl
R_83: 	call disp_boss
R_84: 	ld hl,wpdo
	ld (bwspr),hl
	ld hl,54*256+50
	ld (pencol),hl
R_85: 	ld hl,d_o
	ROM_CALL(_VPUTS)
R_86: 	ld hl,lvldo
R_87: 	jp intro_done
ti_init:
	ld a,(lv1done)
	bit 0,a
R_88: 	jp z,choose_boss
	bit 1,a
R_89: 	jp z,choose_boss
	bit 2,a
R_90: 	jp z,choose_boss
	bit 3,a
R_91: 	jp z,choose_boss
	bit 4,a
R_92: 	jp z,choose_boss
	bit 5,a
R_93: 	jp z,choose_boss
	bit 6,a
R_94: 	jp z,choose_boss
	bit 7,a
R_95: 	jp z,choose_boss
R_96: 	ld hl,tisl
R_97: 	call disp_boss
R_98: 	ld hl,wpp
	ld (bwspr),hl
	ld hl,54*256+38
	ld (pencol),hl
R_99: 	ld hl,t_i
	ROM_CALL(_VPUTS)
R_100: 	ld hl,lvlti
R_101: 	jp intro_done
po_init:
	ld a,(lv1done)
	bit 4,a
R_102: 	jp nz,choose_boss
R_103: 	ld hl,posl
R_104: 	call disp_boss
R_105: 	ld hl,wppo
	ld (bwspr),hl
	ld hl,54*256+46
	ld (pencol),hl
R_106: 	ld hl,p_o
	ROM_CALL(_VPUTS)
R_107: 	ld hl,lvlpo
	jr intro_done
fr_init:
	ld a,(lv1done)
	bit 5,a
R_108: 	jp nz,choose_boss
R_109: 	ld hl,frsl
R_110: 	call disp_boss
R_111: 	ld hl,wpfr
	ld (bwspr),hl
	ld hl,54*256+48
	ld (pencol),hl
R_112: 	ld hl,f_r
	ROM_CALL(_VPUTS)
R_113: 	ld hl,lvlfr
	jr intro_done
sa_init:
	ld a,(lv1done)
	bit 6,a
R_114: 	jp nz,choose_boss
R_115: 	ld hl,sasl
R_116: 	call disp_boss
R_117: 	ld hl,wpsa
	ld (bwspr),hl
	ld hl,54*256+48
	ld (pencol),hl
R_118: 	ld hl,s_a
	ROM_CALL(_VPUTS)
R_119: 	ld hl,lvlsa
	jr intro_done
mi_init:
	ld a,(lv1done)
	bit 7,a
R_120: 	jp nz,choose_boss
R_121: 	ld hl,misl
R_122: 	call disp_boss
R_123: 	ld hl,wpmi
	ld (bwspr),hl
	ld hl,54*256+50
	ld (pencol),hl
R_124: 	ld hl,m_i
	ROM_CALL(_VPUTS)
R_125: 	ld hl,lvlmi
intro_done:
	ld (curlvl),hl	; remember the start of the level
	ld (remlvl),hl
R_126: 	call delay
	ROM_CALL(_clrlcdfull)
R_127: 	call BUFCLR
R_128: 	call wpn_fill
part1_init:
R_129: 	call init_vars
	ld a,44		; initialize some variables
	ld (ymm),a
	xor a
	ld (jchk),a
	ld (bchk),a
	ld (wpn),a
	inc a
	ld (dir),a
	ld (schk),a
R_130: 	ld hl,wpp
	ld (wpnspr),hl
R_131: 	call ShowLevel
R_132: 	call main_loop
	ROM_CALL(_getk)		; clear the keybuffer
R_133: 	call BUFCLR
	ROM_CALL(_clrlcdfull)
	ld a,(death)	; check if died
	or a
R_134: 	jp nz,lost_life
	ld a,(win)
	or a
	ret z			; exit loop if level has not been completed
part2_init:
R_135: 	ld hl,lvlb1
	xor a
	ld (bchk),a
R_136: 	call init_lvlb
	ld a,(death)	; check if died
	or a
R_137: 	jp nz,lost_life
	ld a,(win)
	or a
	ret z			; exit loop if level has not been completed
	xor a			; initialize boss variables
	ld (bdir),a
	ld (bjchk),a
	inc a
	ld (bchk),a
	ld a,28
	ld (enb),a
	ld a,44
	ld (yb),a
	ld a,76
	ld (xb),a
R_138: 	ld hl,lvlb2
R_139: 	call init_lvlb
	ld a,(death)	; check if died
	or a
R_140: 	jp nz,lost_life
	ld a,(win)
	or a
	ret z			; exit game if level has not been completed
	ld a,(lv1done)
	ld b,a
	ld a,(boss)
	cp 5
R_141: 	jp z,final_boss
	cp 1
	jr z,set_bit0
	cp 2
	jr z,set_bit1
	cp 3
	jr z,set_bit2
	cp 4
	jr z,set_bit3
	cp 6
	jr z,set_bit4
	cp 7
	jr z,set_bit5
	cp 8
	jr z,set_bit6
	set 7,b
	jr set_bit_done
set_bit6:
	set 6,b
	jr set_bit_done
set_bit5:
	set 5,b
	jr set_bit_done
set_bit4:
	set 4,b
	jr set_bit_done
set_bit3:
	set 3,b
	jr set_bit_done
set_bit2:
	set 2,b
	jr set_bit_done
set_bit1:
	set 1,b
	jr set_bit_done
set_bit0:
	set 0,b
set_bit_done:
	ld a,b
	ld (lv1done),a
R_142: 	call you_got		; show "you got x weapon" screen
	cp K_EXIT		; exit is MODE was pressed at you got screen
	ret z
R_143: 	call show_pw		; show password
	cp kMode		; exit if MODE was pressed at show password screen
	ret z
R_144: 	jp cb_init
lost_life:
R_145: 	call wpn_fill
	ld a,(lives)	; go to game over screen if all lives lost
	or a
	jr z,game_over
	ld a,(schk)
	or a
R_146: 	jp z,part2_init
R_147: 	jp part1_init
game_over:
R_148: 	call show_pw
	cp kMode		; exit if MODE was pressed at show password screen
	ret z
	ld a,3
	ld (lives),a
	ROM_CALL(_clrlcdfull)
R_149: 	call BUFCLR
	ld d,13
	ld e,17
	ld h,80
	ld l,17
R_150: 	call FLine
	ld e,46
	ld l,46
R_151: 	call FLine
	ld d,12
	ld e,18
	ld h,12
	ld l,45
R_152: 	call FLine
	ld d,81
	ld h,81
R_153: 	call FLine
R_154:       call BUFCOPY2
	ld hl,18*256+47
	ld (pencol),hl
R_155: 	ld hl,gover
	ROM_CALL(_VPUTS)
	ld hl,25*256+41
	ld (pencol),hl
R_156: 	ld hl,cont
	ROM_CALL(_VPUTS)
	ld hl,32*256+30
	ld (pencol),hl
R_157: 	ld hl,stgsel
	ROM_CALL(_VPUTS)
	ld hl,39*256+47
	ld (pencol),hl
R_158: 	ld hl,endgame
	ROM_CALL(_VPUTS)
R_159: 	call BUFCLR
go_loop:
	ROM_CALL(_getk)
	cp k2nd
	jr z,go_cont
	cp kAlpha
R_160: 	jp z,cb_init
	cp kMode
	ret z
	jr go_loop
go_cont:
	ld hl,(remlvl)
	ld (curlvl),hl
R_161: 	jp part1_init
final_boss:
	xor a
	ld (boss),a
	ld (win),a
R_162: 	call main_loop
	ld a,(death)	; check if died
	or a
R_163: 	jp nz,lost_life
	ld a,(win)
	or a
	ret z			; exit game if level has not been completed
ending:
	ROM_CALL(_clrlcdfull)
R_164: 	call BUFCLR
	ld d,0
	ld e,36
	ld h,94
	ld l,36
R_165: 	call FLine
	ld a,24
	ld (ymm),a
	ld (yb),a
	ld hl,20
	ld (xmm),hl
R_166: 	ld hl,mmwr
	ld (curpic),hl
R_167: 	call xor_char
	ld a,68
	ld (xb),a
R_168: 	ld hl,tisl
	ld (bosspic),hl
R_169: 	call xor_boss
R_170: 	call BUFCOPY2
	ld de,37*256+17
	ld (pencol),de
R_171: 	ld hl,end1
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_172: 	ld hl,end2
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_173: 	ld hl,end3
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_174: 	ld hl,end4
	ROM_CALL(_VPUTS)
R_175: 	call long_delay
R_176: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_177: 	ld hl,end5
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_178: 	ld hl,end6
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_179: 	ld hl,end7
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_180: 	ld hl,end8
	ROM_CALL(_VPUTS)
R_181: 	call long_delay
R_182: 	call xor_char
R_183: 	ld hl,mmsl
	ld (curpic),hl
R_184: 	call xor_char
R_185: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_186: 	ld hl,end9
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_187: 	ld hl,end10
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_188: 	ld hl,end11
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_189: 	ld hl,end12
	ROM_CALL(_VPUTS)
R_190: 	call long_delay
R_191: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_192: 	ld hl,end13
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_193: 	ld hl,end14
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_194: 	ld hl,end15
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_195: 	ld hl,end16
	ROM_CALL(_VPUTS)
R_196: 	call long_delay
R_197: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_198: 	ld hl,end17
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_199: 	ld hl,end18
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_200: 	ld hl,end19
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_201: 	ld hl,end20
	ROM_CALL(_VPUTS)
R_202: 	call long_delay
R_203: 	call xor_char
	ld hl,58
	ld (xmm),hl
R_204: 	ld hl,mmwr
	ld (curpic),hl
R_205: 	call xor_char
R_206: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_207: 	ld hl,end21
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_208: 	ld hl,end22
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_209: 	ld hl,end23
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_210: 	ld hl,end24
	ROM_CALL(_VPUTS)
R_211: 	call long_delay
R_212: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_213: 	ld hl,end25
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_214: 	ld hl,end26
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_215: 	ld hl,end27
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_216: 	ld hl,end28
	ROM_CALL(_VPUTS)
R_217: 	call long_delay
R_218: 	call xor_char
R_219: 	call xor_boss
	ld hl,39
	ld (xmm),hl
	ld a,49
	ld (xb),a
R_220: 	ld hl,mmrl
	ld (curpic),hl
R_221: 	call xor_char
R_222: 	call xor_boss
R_223: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_224: 	ld hl,end29
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_225: 	ld hl,end30
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_226: 	ld hl,end31
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_227: 	ld hl,end32
	ROM_CALL(_VPUTS)
R_228: 	call long_delay
R_229: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_230: 	ld hl,end33
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_231: 	ld hl,end34
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_232: 	ld hl,end35
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_233: 	ld hl,end36
	ROM_CALL(_VPUTS)
R_234: 	call long_delay
R_235: 	call xor_char
R_236: 	ld hl,mmsr
	ld (curpic),hl
R_237: 	call xor_char
R_238: 	call BUFCOPY2
	ld hl,37*256+17
	ld (pencol),hl
R_239: 	ld hl,end37
	ROM_CALL(_VPUTS)
	ld de,43*256+17
	ld (pencol),de
;R_240: 	ld hl,end38
	ROM_CALL(_VPUTS)
	ld de,49*256+17
	ld (pencol),de
;R_241: 	ld hl,end39
	ROM_CALL(_VPUTS)
	ld de,55*256+17
	ld (pencol),de
;R_242: 	ld hl,end40
	ROM_CALL(_VPUTS)
R_243: 	call long_delay
R_244: 	call BUFCOPY2
	ld hl,40*256+29
	ld (pencol),hl
R_245: 	ld hl,end41
	ROM_CALL(_VPUTS)
R_246: 	call med_delay
	ld hl,46*256+29
	ld (pencol),hl
R_247: 	ld hl,end42
	ROM_CALL(_VPUTS)
	ld hl,52*256+29
	ld (pencol),hl
R_248: 	ld hl,end43
	ROM_CALL(_VPUTS)
end_loop:
	ROM_CALL(_getk)		; go to credits upon keypress
	cp kMode		; exit if MODE is pressed
	ret z
	or a
	jr z,end_loop
	ROM_CALL(_clrlcdfull)
R_249: 	call BUFCLR
	ld hl,1*256+1
	ld (pencol),hl
R_250: 	ld hl,cred1
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_251: 	ld hl,cred5
	ROM_CALL(_VPUTS)
R_252: 	call delay
R_253: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_254: 	ld hl,cred55
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_255: 	ld hl,cred56
	ROM_CALL(_VPUTS)
R_256: 	call delay
R_257: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_258: 	ld hl,cred2
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_259: 	ld hl,cred5
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_260: 	ld hl,cred6
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_2606: 	ld hl,cred66
	ROM_CALL(_VPUTS)
R_261: 	call delay
R_262: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_263: 	ld hl,cred3
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_264: 	ld hl,test1
	ROM_CALL(_VPUTS)
	ld de,31*256+17
	ld (pencol),de
;R_265: 	ld hl,test2
	ROM_CALL(_VPUTS)
	ld de,41*256+17
	ld (pencol),de
;R_266: 	ld hl,test3
	ROM_CALL(_VPUTS)
	ld de,51*256+17
	ld (pencol),de
;R_267: 	ld hl,test4
	ROM_CALL(_VPUTS)
R_268: 	call delay
R_269: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_270: 	ld hl,cred3
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_271: 	ld hl,test5
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_272: 	ld hl,test6
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_273: 	ld hl,test7
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_274: 	ld hl,test8
	ROM_CALL(_VPUTS)
R_275: 	call delay
R_276: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_277: 	ld hl,cred3
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_278: 	ld hl,test9
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_279: 	ld hl,test10
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_280: 	ld hl,test11
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_281: 	ld hl,test12
	ROM_CALL(_VPUTS)
R_282: 	call delay
R_283: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_284: 	ld hl,cred3
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_285: 	ld hl,test13
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_286: 	ld hl,test14
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_287: 	ld hl,test15
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_288: 	ld hl,test16
	ROM_CALL(_VPUTS)
R_289: 	call delay
R_290: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_291: 	ld hl,cred3
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_292: 	ld hl,test17
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_293: 	ld hl,test18
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_294: 	ld hl,test19
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_295: 	ld hl,test20
	ROM_CALL(_VPUTS)
R_296: 	call delay
R_297: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_298: 	ld hl,cred4
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_299: 	ld hl,cred7
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_300: 	ld hl,cred8
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_301: 	ld hl,cred9
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_302: 	ld hl,cred10
	ROM_CALL(_VPUTS)
R_303: 	call delay
R_304: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_305: 	ld hl,cred4
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_306: 	ld hl,cred11
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_307: 	ld hl,cred12
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_308: 	ld hl,cred13
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_309: 	ld hl,cred14
	ROM_CALL(_VPUTS)
R_310: 	call delay
R_311: 	call BUFCOPY2
	ld hl,1*256+1
	ld (pencol),hl
R_312: 	ld hl,cred4
	ROM_CALL(_VPUTS)
	ld hl,21*256+17
	ld (pencol),hl
R_313: 	ld hl,cred15
	ROM_CALL(_VPUTS)
	ld hl,31*256+17
	ld (pencol),hl
R_314: 	ld hl,cred16
	ROM_CALL(_VPUTS)
	ld hl,41*256+17
	ld (pencol),hl
R_315: 	ld hl,cred17
	ROM_CALL(_VPUTS)
	ld hl,51*256+17
	ld (pencol),hl
R_316: 	ld hl,cred18
	ROM_CALL(_VPUTS)
R_317: 	call delay
R_318: 	call BUFCOPY2
	ld hl,11*256+26
	ld (pencol),hl
R_319: 	ld hl,pres
	ROM_CALL(_VPUTS)
	ld hl,31*256+36
	ld (pencol),hl
R_320: 	ld hl,djs
	ROM_CALL(_VPUTS)
cred_loop:
	ROM_CALL(_getk)		; exit game upon keypress
	or a
	jr z,cred_loop
	ret
init_lvlb:
	ld (curlvl),hl
R_321: 	call init_vars
	ld (schk),a
	ld (bcount),a
R_322: 	call ShowLevel
R_323: 	call main_loop
	ld a,(win)		; see if you defeated TI's spaceship
	cp 2
	jr z,ship_dead
	ROM_CALL(_getk)		; clear the keybuffer
R_324: 	call BUFCLR
	ROM_CALL(_clrlcdfull)
	ret
init_vars:
	ld hl,0
	ld (xscr),hl
	ld (tempscr),hl
	ld hl,8			; initialize some variables
	ld (xmm),hl
	xor a
	ld (wchk),a
	ld (wchk1),a
	ld (wchk2),a
	ld (wchk3),a
	ld (win),a
	ld (death),a
	ld (feet),a
	ld (item),a
	ld (echk),a
	ld (bwchk),a
	ld (hchk),a
	ret
ship_dead:
	ld a,28
	ld (enb),a
R_325: 	call check_spr
	ld b,0			; erase ship
R_326: 	call ship_init
ti_fall:				; TI falls to the bottom of the screen
	ld a,(yb)
	inc a
	ld (yb),a
R_327: 	call xor_boss
R_328: 	call BUFCOPY
R_329: 	call xor_boss
	ld a,(yb)
	cp 44
	jr nz,ti_fall
R_330: 	call check_spr
	ret
main_loop:
	ld a,(hchk)
	or a
R_331: 	call nz,thrown_back
	ld hl,(xmm)
R_332: 	call load_x
	ld a,(ymm)
	add a,4
	push hl
	push af
R_333: 	call GetBlock
R_334: 	call CheckItem
	pop af
	pop hl
	ld de,7
	add hl,de
R_335: 	call GetBlock
R_336: 	call CheckItem
	ld a,(echk)
	or a
R_337: 	call nz,check_ehitu
	ld a,(bchk)
	or a
R_338: 	call nz,check_bhitu
	ld a,(bwchk)
	or a
R_339: 	call nz,check_bwhitu
R_340: 	call ShowLevel
	ld a,(boss)			; draw spaceship if necessary
	cp 5
	ld b,1
R_341: 	call z,ship_init
R_342: 	call draw_nrg		; draw energy lines
R_343: 	call check_spr		; figure out which Mega Man sprite to use
;R_5007:	call xor_char		; draw it

	ld a,(wchk1)		; check if shots should be displayed and display as necessary
	or a
R_344: 	call nz,xor_wpn1
	ld a,(wchk2)
	or a
R_345: 	call nz,xor_wpn2
	ld a,(wchk3)
	or a
R_346: 	call nz,xor_wpn3
	ld a,(echk)		; check for enemy and display as necessary
	push af
	cp 1
R_347: 	call z,xor_en
	pop af
	cp 2
R_348: 	call z,xor_en
	ld a,(bwchk)		; check for boss's shot and display as necessary
	or a
R_349: 	call nz,xor_bwpn
	ld a,(bchk)		; check for boss and display as necessary
	or a
R_350: 	call nz,xor_boss
R_351: 	call BUFCOPY		; copy everything to the buffer
	ld a,(enp)
	or a
R_352: 	call z,die
R_353: 	call xor_char		; erase the Megaman sprite
	ld a,(wchk1)		; check for shots and erase as necessary
	or a
R_354: 	call nz,shot1_move
	ld a,(wchk2)
	or a
R_355: 	call nz,shot2_move
	ld a,(wchk3)
	or a
R_356: 	call nz,shot3_move
	ld a,(echk)		; check for enemy and erase as necessary
	push af
	cp 1
R_357: 	call z,i_move
	pop af
	cp 2
R_358: 	call z,t_move
	ld a,(bwchk)		; check for boss's shot and erase as necessary
	or a
R_359: 	call nz,boss_shot_move
	ld a,(bchk)		; check for boss and erase as necessary
	or a
R_360: 	call nz,boss_move
R_4444: call BUFCLR
	ld a,(wchk)
	or a
R_361: 	call nz,inc_wchk
	ld a,(dir)
	or a
	jr z,left_spr
R_362: 	ld hl,mmsr
	jr f_spr
left_spr:
R_363: 	ld hl,mmsl
f_spr:
	ld (curpic),hl

      call OTH_ARROW
	bit 1,a
R_364: 	call z,move_left
	bit 2,a
R_365: 	call z,move_right
	bit 4,a
R_366: 	call z,sub_screen
	bit 5,a
R_367: 	call z,jump
R_368: 	call nz,jchk_now_2
R_369:       call fall
	bit 6,a
	ret z		; exit loop is MODE has been pressed
	bit 7,a
R_370: 	call z,pause
	ld a,$DF	; check ALPHA
	out (1),a
	in a,(1)
	bit 7,a
R_371: 	call z,shoot
	ld a,(death)
	or a
	ret nz		; exit loop if dead
	ld a,(win)
	or a
R_372: 	jp z,main_loop	; exit loop if level completed
	ret


fall:
	push af
	ld a,(jchk)
	cp 1
	jr z,no_fall
R_373: 	call CheckDown
R_374: 	call z,CheckDown2
	jr nz,end_fall
	ld a,(ymm)
	inc a
	ld (ymm),a
	cp 52
R_375: 	call z,die
	jr no_fall
end_fall:
	xor a
	ld (jchk),a
no_fall:
	pop af
	ret

pause:
 push af
R_376: 	call tiny_delay
pause_loop:
	ROM_CALL(_getk)
	cp kMode
	ret z
	cp kEnter
	jr nz,pause_loop
R_377: 	call tiny_delay
 pop af
	ret
jchk_now_2:		; make sure you can't jump
	push af
	ld a,2
	ld (jchk),a
	pop af
	ret
move_right:
      push af
	ld a,(feet)
	and $02
R_378: 	ld hl,mmrr2
	jr nz,rr2_spr
R_379: 	ld hl,mmrr
rr2_spr:
	ld (curpic),hl
	ld a,(xmm)
	cp 80
R_380: 	call z,won
R_381: 	call CheckRight
R_382: 	call z,CheckRight2
R_383: 	call z,CheckRight3
	jr nz,no_right
R_384: 	call change_right
	ld a,(xmm)
	cp 44
	jr nz,no_scroll
	ld a,(xscr)
	cp 68
	jr z,no_scroll
	ld a,(schk)
	or a
	jr z,no_scroll
R_385: 	call scroll
	jr no_right
no_scroll:
	ld hl,xmm
	inc (hl)
no_right:
	ld a,(dir)
	or a
R_386: 	call z,change_right
      pop af
	ret
change_right:
R_387: 	call feet_inc
	ld a,1
	ld (dir),a
	ret
move_left:
	push af
	ld a,(feet)
	and $02
R_388: 	ld hl,mmrl2
	jr nz,rl2_spr
R_389: 	ld hl,mmrl
rl2_spr:
	ld (curpic),hl
	ld a,(xmm)
	or a
	jr z,no_left
R_390: 	call CheckLeft
R_391: 	call z,CheckLeft2
R_392: 	call z,CheckLeft3
	jr nz,no_left
R_393: 	call change_left
	ld hl,xmm
	dec (hl)

no_left:
	ld a,(dir)
	or a
R_394: 	call nz,change_left
	pop af
	ret
change_left:
R_395: 	call feet_inc
	xor a
	ld (dir),a
	ret
CheckRight:
	ld hl,(xmm)
R_396: 	call load_x
	ld de,8
	add hl,de
	jr CheckHorz
CheckLeft:
	ld hl,(xmm)
R_397: 	call load_x
	dec hl
CheckHorz:
	ld a,(ymm)
R_398: 	call GetBlock
R_399: 	call CheckTile
	ret
CheckRight2:
	ld hl,(xmm)
R_400: 	call load_x
	ld de,8
	add hl,de
	jr CheckHorz2
CheckLeft2:
	ld hl,(xmm)
R_401: 	call load_x
	dec hl
CheckHorz2:
	ld a,(ymm)
	add a,11
R_402: 	call GetBlock
R_403: 	call CheckTile
	ret
CheckRight3:
	ld hl,(xmm)
R_404: 	call load_x
	ld de,8
	add hl,de
	jr CheckHorz3
CheckLeft3:
	ld hl,(xmm)
R_405: 	call load_x
	dec hl
CheckHorz3:
	ld a,(ymm)
	add a,6
R_406: 	call GetBlock
R_407: 	call CheckTile
	ret
GetBlock:		; Gets the block at (HL,A) -> A. HL = addr, B,C = coord
	srl h
	rr l
	srl h
	rr l
	srl h
 	rr l		; Divide X with 8
	ld b,l
	cp 64
	jr c,OnScreen
	xor a
OnScreen:
	srl a
	srl a
	srl a		; Divide Y with 8
	ld c,a
	add hl,hl
	add hl,hl
	add hl,hl
	ld d,0
	ld e,a
	add hl,de	; HL = x*8+y
	ld de,(curlvl)
	add hl,de	; Add HL with the pointer to the level data
	ld a,(hl)
	ret

CheckTile:
	or a
	ret z
	cp 5
	ret c
	xor a
	ret

CheckItem:
	cp 5
	jr z,got_life
	cp 6
	jr z,got_tank
	ret

got_life:
	ld a,(item)
	cp 1
	ret nz
	inc a
	ld (item),a
	ld a,(lives)
	inc a
	ld (lives),a
	ret
got_tank:
	ld a,(item)
	cp 1
	ret nz
	inc a
	ld (item),a
	ld a,(tanks)
	inc a
	ld (tanks),a
	ret
jump:
	push af
	ld a,(jchk)
	cp 2
	jr z,no_jump
	or a
	jr nz,jump_up
	ld a,1
	ld (jchk),a
	ld a,(ymm)
	sub 10
	jr nc,jrem_not0
	ld a,1
jrem_not0:
	ld (jrem),a
jump_up:
	ld a,(jrem)
	ld b,a
	ld a,(ymm)
	cp b
	jr c,end_jump
R_408: 	call CheckUp
R_409: 	call z,CheckUp2
	jr nz,end_jump
	ld a,(ymm)
	dec a
	ld (ymm),a
	jr no_jump
end_jump:
	ld a,2
	ld (jchk),a
no_jump:
	pop af
	ret

CheckUp:
	ld a,(ymm)
	dec a
	jr CheckVert
CheckDown:
	ld a,(ymm)
	add a,12
CheckVert:
	ld hl,(xmm)
R_410: 	call load_x
R_411: 	call GetBlock
R_412: 	call CheckTile
	ret
CheckUp2:
	ld a,(ymm)
	dec a
	jr CheckVert2
CheckDown2:
	ld a,(ymm)
	add a,12
CheckVert2:
	ld hl,(xmm)
R_413: 	call load_x
	ld de,7
	add hl,de
R_414: 	call GetBlock
R_415: 	call CheckTile
	ret
shoot_sa:
	ld a,(xmm)
	ld (wx1),a
	ld a,(ymm)
	add a,4
	ld (wy1),a
	ld a,1
	ld (wchk1),a
	ld a,(enwpn)
	sub 4
	ld (enwpn),a
R_416: 	call check_spr
R_417: 	call xor_char
	ret
shoot_fr:
	ld a,(xmm)
	ld (wx1),a
	ld a,(ymm)
	ld (wy1),a
R_418: 	call xor_wpn1
	ld a,(wy1)
	add a,4
	ld (wy1),a
R_419: 	call xor_wpn1
	ld a,(wy1)
	add a,4
	ld (wy1),a
	ld a,1
	ld (wchk1),a
	ld a,(enwpn)
	sub 4
	ld (enwpn),a
R_420: 	call check_spr
;R_421: 	call xor_char
	ret
shoot_md:
	ld a,(ymm)
	inc a
	ld (wy1),a
	ld a,(dir)
	or a
	ld a,(xmm)
	jr z,smd_left
	add a,8
	jr smd_right
smd_left:
	sub 8
smd_right:
	ld (wx1),a
	ld a,1
	ld (wchk1),a
	ld a,(enwpn)
	sub 4
	ld (enwpn),a
	ret
shoot_se:
	ld a,(bchk)		; restrictions on using top secret weapon
	or a
	ret nz
	ld a,(echk)
	or a
	ret z
	cp 3
	ret z
	ld a,(ymm)
	cp 26
	ret c
	ld a,(lives)
	cp 3
	ret c
	ld a,(tanks)
	cp 4
	ret c
R_422: 	call won		; effect is beating the current part of the level if requirements are met
	xor a
	ld (enwpn),a
	ret
shoot:
	ld a,(wchk)
	or a
	ret nz
	ld a,(wpn)
	or a
	jr z,no_check_enwpn
	ld a,(enwpn)	; don't shoot if no weapon energy left
	or a
	ret z
no_check_enwpn:
	ld a,(dir)	; make sure you aren't too close to edge of screen
	or a
	jr z,try_left
	ld a,(xmm)
	cp 80
	ret nc
	jr shoot_cont
try_left:
	ld a,(xmm)
	cp 8
	ret c
shoot_cont:
	ld a,(wpn)
	cp 3
	jr z,shoot_md
	cp 5
	jr z,shoot_se
	cp 7
R_423: 	jp z,shoot_fr
	cp 8
R_424: 	jp z,shoot_sa
	ld a,1
	ld (wchk),a
	ld a,(wpn)
	or a
	jr z,no_dec_enwpn
	ld a,(enwpn)
	dec a
	ld (enwpn),a
no_dec_enwpn:
	ld a,(wchk1)	; check for bullet #1
	or a		; if it doesn't exist, it does now
	jr z,store_shot1
	ld a,(wchk2)	; check for bullet #2
	or a		; if it doesn't exist, it does now
	jr z,store_shot2
	ld a,(wchk3)	; check for bullet #3
	or a		; if it doesn't exist, it does now
	ret nz
	ld a,(ymm)	; initialize shot #3
	add a,5
	ld (wy3),a
	ld a,(dir)
	ld (wdir3),a
	or a
	jr z,shoot_left3
	ld a,(xmm)
	add a,8
	ld b,a
	add a,12
	jr shoot_init3
shoot_left3:
	ld a,(xmm)
	sub 8
	ld b,a
	sub 12
shoot_init3:
	res 0,a
	ld (wrem3),a
	ld a,b
	ld (wx3),a
	ld a,1
	ld (wchk3),a
	ret
store_shot2:
	ld a,(ymm)	; initialize shot #2
	add a,5
	ld (wy2),a
	ld a,(dir)
	ld (wdir2),a
	or a
	jr z,shoot_left2
	ld a,(xmm)
	add a,8
	ld b,a
	add a,24
	jr shoot_init2
shoot_left2:
	ld a,(xmm)
	sub 8
	ld b,a
	sub 24
shoot_init2:
	res 0,a
	ld (wrem2),a
	ld a,b
	ld (wx2),a
	ld a,1
	ld (wchk2),a
	ret
store_shot1:
	ld a,(ymm)	; initialize shot #1
	add a,5
	ld (wy1),a
	ld a,(dir)
	ld (wdir1),a
	or a
	jr z,shoot_left1
	ld a,(xmm)
	add a,8
	ld b,a
	add a,24
	jr shoot_init1
shoot_left1:
	ld a,(xmm)
	sub 8
	ld b,a
	sub 24
shoot_init1:
	res 0,a
	ld (wrem1),a
	ld a,b
	ld (wx1),a
	ld a,1
	ld (wchk1),a
	ret
shot3_move:
R_425: 	call xor_wpn3
	ld a,(xmm)
	ld b,a
	ld a,(wx3)
	cp 4
	jr c,sm_end3
	cp 87
	jr nc,sm_end3
	res 0,a
	cp b
	jr z,sm_end3
	ld b,a
	ld a,(wpn)
	cp 1
	jr z,sm_short3
	cp 2
	jr z,sm_short3
	cp 6
	jr z,sm_short3
sm_cont3:
	ld a,(wdir3)
	or a
	ld a,(wpn)
	jr z,sm_left3
	inc b
	inc b
	or a
	jr z,smr_two3
	cp 4
	jr z,smr_two3
	cp 6
	jr z,smr_two3
	jr sm_store3
smr_two3:
	inc b
	jr sm_store3
sm_left3:
	dec b
	dec b
	or a
	jr z,sml_two3
	cp 4
	jr z,sml_two3
	cp 6
	jr z,sml_two3
sml_two3:
	dec b
sm_store3:
	ld a,b
	ld (wx3),a
	ret
sm_short3:
	ld a,(wrem3)
	res 0,a
	sub b
	jr nz,sm_cont3
	ld a,(wpn)
	cp 6
	jr z,sm_chg3
sm_end3:
	xor a		; shot is off the screen
	ld (wchk3),a
	ret
sm_chg3:
	ld a,(wdir3)	; reverse dir shot #3 is moving
	inc a
	and $01
	ld (wdir3),a
	jr sm_cont3
shot2_move:
R_426: 	call xor_wpn2
	ld a,(xmm)
	ld b,a
	ld a,(wx2)
	cp 4
	jr c,sm_end2
	cp 87
	jr nc,sm_end2
	res 0,a
	cp b
	jr z,sm_end2
	ld b,a
	ld a,(wpn)
	cp 1
	jr z,sm_short2
	cp 2
	jr z,sm_short2
	cp 6
	jr z,sm_short2
sm_cont2:
	ld a,(wdir2)
	or a
	ld a,(wpn)
	jr z,sm_left2
	inc b
	inc b
	or a
	jr z,smr_two2
	cp 4
	jr z,smr_two2
	cp 6
	jr z,smr_two2
	jr sm_store2
smr_two2:
	inc b
	jr sm_store2
sm_left2:
	dec b
	dec b
	or a
	jr z,sml_two2
	cp 4
	jr z,sml_two2
	cp 6
	jr z,sml_two2
sml_two2:
	dec b
sm_store2:
	ld a,b
	ld (wx2),a
	ret
sm_short2:
	ld a,(wrem2)
	res 0,a
	sub b
	jr nz,sm_cont2
	ld a,(wpn)
	cp 6
	jr z,sm_chg2
sm_end2:
	xor a			; shot is off the screen
	ld (wchk2),a
	ret
sm_chg2:
	ld a,(wdir2)	; reverse dir shot #2 is moving
	inc a
	and $01
	ld (wdir2),a
	jr sm_cont2
ssa_move:
R_427: 	call check_spr
R_428: 	call xor_char
ssam_loop:
	ld a,(wx1)
	inc a
	ld (wx1),a
R_429: 	call xor_wpn1
R_430: 	call BUFCOPY
R_431: 	call xor_wpn1
	ld a,(wx1)
	cp 88
	jr nz,ssam_loop
ssam_loop2:
	ld a,(wx1)
	dec a
	ld (wx1),a
R_432: 	call xor_wpn1
R_433: 	call BUFCOPY
R_434: 	call xor_wpn1
	ld a,(wx1)
	or a
	jr nz,ssam_loop2
ssam_loop3:
	ld a,(wx1)
	inc a
	ld (wx1),a
R_435: 	call xor_wpn1
R_436: 	call BUFCOPY
R_437: 	call xor_wpn1
	ld a,(xmm)
	ld b,a
	ld a,(wx1)
	cp b
	jr nz,ssam_loop3
	xor a
	ld (wchk1),a
	ld a,(echk)
	or a
	jr z,ssam_bchk
	cp 3
	jr z,ssam_bchk
	ld a,(ye)
	ld b,a
	ld a,(wy1)
	sub 7
	cp b
	ret nc
	add a,10
	cp b
	ret c
	xor a
	ld a,(ene)
	or a
	sub 2
	jr nc,sahite_nokill
	xor a
sahite_nokill:
	ld (ene),a
	or a
	ret nz
	ld a,3
	ld (echk),a
	ret
ssam_bchk:
	ld a,(bchk)
	or a
	ret z
	ld a,(yb)
	ld b,a
	ld a,(wy1)
	sub 11
	cp b
	ret nc
	add a,14
	cp b
	ret c
R_438: 	call dam7_or1
	ld a,(enb)
	or a
	sub 1
	jr nc,sahitb_nokill
	xor a
sahitb_nokill:
	ld (enb),a
	ret nz
R_439: 	call won
	ret
sfr_move:
	ld a,(wy1)
	sub 4
	ld (wy1),a
R_440: 	call xor_wpn1
	ld a,(wy1)
	sub 4
	ld (wy1),a
R_441: 	call xor_wpn1
R_442: 	call short_delay
	xor a
	ld (wchk1),a
R_443: 	call check_spr
R_444: 	call xor_char
	ld a,(echk)
	or a
	jr z,sfrm_bchk
	cp 3
	jr z,sfrm_bchk
	ld a,(xe)
	ld b,a
	ld a,(wx1)
	sub 11
	cp b
	ret nc
	add a,22
	cp b
	ret c
	ld a,(ye)
	ld b,a
	ld a,(wy1)
	sub 7
	cp b
	ret nc
	add a,10
	cp b
	ret c
	xor a
	ld a,(ene)
	or a
	sub 2
	jr nc,frhite_nokill
	xor a
frhite_nokill:
	ld (ene),a
	or a
	ret nz
	ld a,3
	ld (echk),a
	ret
sfrm_bchk:
	ld a,(bchk)
	or a
	ret z
	ld a,(xb)
	ld b,a
	ld a,(wx1)
	sub 11
	cp b
	ret nc
	add a,22
	cp b
	ret c
	ld a,(yb)
	ld b,a
	ld a,(wy1)
	sub 11
	cp b
	ret nc
	add a,14
	cp b
	ret c
R_445: 	call dam7_or1
	ld a,(enb)
	or a
	sub 1
	jr nc,frhitb_nokill
	xor a
frhitb_nokill:
	ld (enb),a
	ret nz
R_446: 	call won
	ret
smd_move:
R_447: 	call short_delay
	xor a
	ld (wchk1),a
	ld a,(echk)
	or a
	jr z,smdm_bchk
	cp 3
	jr z,smdm_bchk
R_448: 	call xor_en
	ld a,3
	ld (echk),a
	xor a
	ld (ecount),a
smdm_bchk:
	ld a,(bchk)
	or a
	ret z
R_449: 	call dam7_or1
	ld a,(enb)
	or a
	sub 1
	jr nc,mdhitb_nokill
	xor a
mdhitb_nokill:
	ld (enb),a
	ret nz
R_450: 	call won
	ret
shot1_move:
R_451: 	call xor_wpn1
	ld a,(wpn)
	cp 3
	jr z,smd_move
	cp 7
R_452: 	jp z,sfr_move
	cp 8
R_453: 	jp z,ssa_move
	ld a,(xmm)
	ld b,a
	ld a,(wx1)
	cp 4
	jr c,sm_end1
	cp 87
	jr nc,sm_end1
	res 0,a
	cp b
	jr z,sm_end1
	ld b,a
	ld a,(wpn)
	cp 1
	jr z,sm_short1
	cp 2
	jr z,sm_short1
	cp 6
	jr z,sm_short1
sm_cont1:
	ld a,(wdir1)
	or a
	ld a,(wpn)
	jr z,sm_left1
	inc b
	inc b
	or a
	jr z,smr_two1
	cp 4
	jr z,smr_two1
	cp 6
	jr z,smr_two1
	jr sm_store1
smr_two1:
	inc b
	jr sm_store1
sm_left1:
	dec b
	dec b
	or a
	jr z,sml_two1
	cp 4
	jr z,sml_two1
	cp 6
	jr z,sml_two1
sml_two1:
	dec b
sm_store1:
	ld a,b
	ld (wx1),a
	ret
sm_short1:
	ld a,(wrem1)
	res 0,a
	sub b
	jr nz,sm_cont1
	ld a,(wpn)
	cp 6
	jr z,sm_chg1
sm_end1:
	xor a		; shot is off the screen
	ld (wchk1),a
	ret
sm_chg1:
	ld a,(wdir1)	; reverse dir shot #1 is moving
	inc a
	and $01
	ld (wdir1),a
	jr sm_cont1
inc_wchk:		; lets you shoot again
	inc a
	cp 8
	jr nz,keep_wchk
	xor a
keep_wchk:
	ld (wchk),a
	ret
die:
R_454: 	call short_delay
	ld a,(lives)
	dec a
	ld (lives),a
      ld a,1
      ld (death),a
	ret
won:
	ld a,1
	ld (win),a
	ld a,(bchk)		; check for boss
	or a
	ret z
	ld a,(boss)		; see if that boss was the spaceship
	cp 5
	ret nz
	ld a,2		; if so, set win=2
	ld (win),a
	ret
s1_dec:
	ld a,(wx1)
	dec a
	ld (wx1),a
	ld a,(wrem1)
	dec a
	ld (wrem1),a
	ret
s2_dec:
	ld a,(wx2)
	dec a
	ld (wx2),a
	ld a,(wrem2)
	dec a
	ld (wrem2),a
	ret
s3_dec:
	ld a,(wx3)
	dec a
	ld (wx3),a
	ld a,(wrem3)
	dec a
	ld (wrem3),a
	ret
scroll:
R_455: 	call BUFCLR
	ld a,(tempscr)
	inc a
	cp 8
	jr nz,scroll_cont
	ld a,(xscr)
	inc a
	ld (xscr),a
	xor a
scroll_cont:
	ld (tempscr),a
	ld a,(wchk1)
	or a
R_456: 	call nz,s1_dec
	ld a,(wchk2)
	or a
R_457: 	call nz,s2_dec
	ld a,(wchk3)
	or a
R_458: 	call nz,s3_dec
	ld a,(echk)
	or a
R_459: 	call nz,next_en
	ld a,(echk)
	or a
	ret z
	cp 3
	ret z
	ld a,(xe)	; decrease x-coord of enemy
	dec a
	ld (xe),a
	or a
R_460: 	call z,en_dead
      
	ret

ShowLevel:
	ld hl,(xscr)
	add hl,hl
	add hl,hl
	add hl,hl
	push hl
	pop de
	ld hl,(curlvl)
	add hl,de
	ld bc,0
RepShowLevel:		; displays the current full screen of the level
	ld a,(hl)
	cp 5
R_461: 	call nc,item_init
	inc hl
	push hl
	ld h,0
	ld l,a
	add hl,hl
	add hl,hl
	add hl,hl
R_462: 	ld de,lvlspr
      add hl,de
	push bc
	ld a,(tempscr)
	ld d,a
	ld a,b
	sub d
	ld (x2),a
      ld b,a
	ld a,c
	ld (y2),a
R_463:       call PutSprClp

skip_8x8:
	pop bc
	pop hl
	ld a,c
	add a,8
	ld c,a
	cp 64
R_464: 	jp nz,RepShowLevel
	ld c,0
	ld a,b
	add a,8
	ld b,a
	cp 104
R_465: 	jp nz,RepShowLevel
 ret

item_init:
	ld d,a
	cp 7
	jr nc,t_init
	ld a,(item)
	cp 2
	jr z,no_item_init
	ld a,1
	ld (item),a
	ld a,d
	ret
no_item_init:
	xor a			; replace item sprite with blank sprite
	ret

t_init:
	ld a,(echk)		; check for existing enemy
	or a
	jr nz,no_en_init
      ld a,b
      cp 96
      jr nc,no_en_init
R_466: 	ld hl,iup		; initialize enemy variables
	xor a
	ld (edir),a
	ld (ecount),a
	ld (ecount2),a
	inc a
	inc a
	ld (ene),a
	ld a,d
	cp 9
	ld a,1
	jr z,i_init
	ld a,3
	ld (ene),a
	dec a
R_467: 	ld hl,tleft
i_init:
	ld (echk),a
	ld (enspr),hl
	ld a,b
	ld (xe),a
	ld a,c
	ld (ye),a
no_en_init:
	xor a			; replace enemy sprite with blank sprite
	ret
load_x:				; loads x location (input as hl) into hl, accounting for scrolling
	push hl
	ld hl,(xscr)
	add hl,hl
	add hl,hl
	add hl,hl
	pop de
	add hl,de
	push hl
	ld hl,(tempscr)
	pop de
	add hl,de
	ret
feet_inc:		; feet changes from 0 to 1 to 2 to 3 to 0
	ld a,(feet)
	inc a
	cp 4
	jr nz,store_feet
	xor a
store_feet:
	ld (feet),a
	ret
sub_screen:
	push af
	ROM_CALL(_clrlcdfull)
R_468: 	call BUFCLR
R_469: 	call tiny_delay
	xor a
	ld (wchk1),a
	ld (wchk2),a
	ld (wchk3),a
	ld a,(wpn)
	or a
	jr z,ss_cont
	cp 1
	jr z,en_an
	cp 2
	jr z,en_ma
	cp 3
	jr z,en_md
	cp 4
	jr z,en_do
	cp 5
	jr z,en_se
	cp 6
	jr z,en_po
	cp 7
	jr z,en_fr
	cp 8
	jr z,en_sa
	cp 9
	jr z,en_mi
en_an:
	ld a,(enwpn)
	ld (enan),a
	jr ss_cont
en_ma:
	ld a,(enwpn)
	ld (enma),a
	jr ss_cont
en_md:
	ld a,(enwpn)
	ld (enmd),a
	jr ss_cont
en_do:
	ld a,(enwpn)
	ld (endo),a
	jr ss_cont
en_se:
	ld a,(enwpn)
	ld (ense),a
	jr ss_cont
en_po:
	ld a,(enwpn)
	ld (enpo),a
	jr ss_cont
en_fr:
	ld a,(enwpn)
	ld (enfr),a
	jr ss_cont
en_sa:
	ld a,(enwpn)
	ld (ensa),a
	jr ss_cont
en_mi:
	ld a,(enwpn)
	ld (enmi),a
ss_cont:
	ld a,28
	ld (x2),a
	ld a,53
	ld (y2),a
R_470: 	ld hl,tank
	ld (smlspr),hl
R_471: 	call xor_8x8
	ld a,55
	ld (x2),a
R_472: 	ld hl,head
	ld (smlspr),hl
R_473: 	call xor_8x8
	ld d,0
	ld e,0
	ld h,94
	ld l,0
R_474: 	call FLine
	ld e,62
	ld l,62
R_475: 	call FLine
	ld e,51
	ld l,51
R_476: 	call FLine
	ld e,50
	ld l,50
R_477: 	call FLine
	ld d,94
	ld e,62
	ld l,0
R_478: 	call FLine
	ld d,0
	ld h,0
R_479: 	call FLine
	ld d,47
	ld h,47
R_480: 	call FLine
	xor a
	ld (x2),a
	inc a
	ld (y2),a
R_481: 	ld hl,pwdot
	ld (smlspr),hl
ss_loop_new:
R_482: 	call xor_8x8
R_483: 	call BUFCOPY2
	ld a,(lv1done)
	bit 0,a
	jr z,ss_line1
	ld d,16
	ld e,15
	push af
	ld a,(enan)
	add a,17
	ld h,a
	ld l,15
R_484: 	call FLine
	pop af
ss_line1:
	bit 1,a
	jr z,ss_line2
	ld d,16
	ld e,25
	push af
	ld a,(enma)
	add a,17
	ld h,a
	ld l,25
R_485: 	call FLine
	pop af
ss_line2:
	bit 2,a
	jr z,ss_line3
	ld d,16
	ld e,35
	push af
	ld a,(enmd)
	add a,17
	ld h,a
	ld l,35
R_486: 	call FLine
	pop af
ss_line3:
	bit 3,a
	jr z,ss_line4
	ld d,16
	ld e,45
	push af
	ld a,(endo)
	add a,17
	ld h,a
	ld l,45
R_487: 	call FLine
	pop af
ss_line4:
	bit 4,a
	jr z,ss_line5
	ld d,63
	ld e,15
	push af
	ld a,(enpo)
	add a,64
	ld h,a
	ld l,15
R_488: 	call FLine
	pop af
ss_line5:
	bit 5,a
	jr z,ss_line6
	ld d,63
	ld e,5
	push af
	ld a,(ense)
	add a,64
	ld h,a
	ld l,5
R_489: 	call FLine
	ld d,63
	ld e,25
	ld a,(enfr)
	add a,64
	ld h,a
	ld l,25
R_490: 	call FLine
	pop af
ss_line6:
	bit 6,a
	jr z,ss_line7
	ld d,63
	ld e,35
	push af
	ld a,(ensa)
	add a,64
	ld h,a
	ld l,35
R_491: 	call FLine
	pop af
ss_line7:
	bit 7,a
	jr z,ss_line_done
	ld d,63
	ld e,45
	ld a,(enmi)
	add a,64
	ld h,a
	ld l,45
R_492: 	call FLine
ss_line_done:
	ld d,16
	ld e,5
	ld a,(enp)
	add a,17
	ld h,a
	ld l,5
R_493: 	call FLine
R_494: 	call BUFCOPY2
	ld a,(lv1done)
	bit 0,a
	jr z,ss_bit1
      push af
	ld hl,12*256+23
	ld (pencol),hl
R_495: 	ld hl,an
	ROM_CALL(_VPUTS)
      pop af
ss_bit1:
	bit 1,a
	jr z,ss_bit2
      push af
	ld hl,22*256+23
	ld (pencol),hl
R_496: 	ld hl,ma
	ROM_CALL(_VPUTS)
      pop af
ss_bit2:
	bit 2,a
	jr z,ss_bit3
      push af
	ld hl,32*256+23
	ld (pencol),hl
R_497: 	ld hl,md
	ROM_CALL(_VPUTS)
      pop af
ss_bit3:
	bit 3,a
	jr z,ss_bit4
      push af
	ld hl,42*256+23
	ld (pencol),hl
R_498: 	ld hl,do
	ROM_CALL(_VPUTS)
      pop af
ss_bit4:
	bit 4,a
	jr z,ss_bit5
      push af
	ld hl,12*256+70
	ld (pencol),hl
R_499: 	ld hl,po
	ROM_CALL(_VPUTS)
      pop af
ss_bit5:
	bit 5,a
	jr z,ss_bit6
      push af
	ld hl,22*256+70
	ld (pencol),hl
R_500: 	ld hl,fr
	ROM_CALL(_VPUTS)
	ld hl,2*256+70
	ld (pencol),hl
R_501: 	ld hl,se
	ROM_CALL(_VPUTS)
      pop af
ss_bit6:
	bit 6,a
	jr z,ss_bit7
      push af
	ld hl,32*256+70
	ld (pencol),hl
R_502: 	ld hl,sa
	ROM_CALL(_VPUTS)
      pop af
ss_bit7:
	bit 7,a
	jr z,ss_loop_init
      push af
	ld hl,42*256+70
	ld (pencol),hl
R_503: 	ld hl,mi
	ROM_CALL(_VPUTS)
      pop af
ss_loop_init:
	ld hl,2*256+23
	ld (pencol),hl
R_504: 	ld hl,p
	ROM_CALL(_VPUTS)
	ld hl,54*256+40
	ld (pencol),hl
	ld a,(tanks)
      ld l,a
      ld h,0
	call DM_HL_DECI
	ld hl,54*256+67
	ld (pencol),hl
	ld a,(lives)
      ld l,a
      ld h,0
	call DM_HL_DECI
R_505: 	call xor_8x8
ss_loop:
	ROM_CALL(_getk)
	cp kUp
R_506: 	jp z,ss_up
	cp kDown
R_507: 	jp z,ss_down
	cp kLeft
R_508: 	jp z,ss_horz
	cp kRight
R_509: 	jp z,ss_horz
	cp k2nd
R_510: 	jp z,ss_tank
	cp kMode
R_511: 	jp z,ss_mode
	cp kYEq
	jr nz,ss_loop
R_512: 	ld hl,wpp
	ld a,(lv1done)
	ld b,a
	ld a,(x2)
	or a
	ld a,(y2)
	jr z,wpn_left
	cp 1
	jr z,ss_se
	cp 11
R_513: 	jp z,ss_po
	cp 21
R_514: 	jp z,ss_fr
	cp 31
R_515: 	jp z,ss_sa
R_516: 	jp ss_mi
wpn_left:
	ld c,0
R_517: 	ld hl,wpp
	cp 1
R_518: 	jp z,ss_exit
	cp 11
	jr z,ss_an
	cp 21
	jr z,ss_ma
	cp 31
	jr z,ss_md
	jr ss_do
ss_an:
	bit 0,b
	jr z,ss_loop
	ld c,1
	ld a,(enan)
	ld (enwpn),a
R_519: 	ld hl,wpan
R_520: 	jp ss_exit
ss_ma:
	bit 1,b
	jr z,ss_loop
	ld c,2
	ld a,(enma)
	ld (enwpn),a
R_521: 	ld hl,wpma
	jr ss_exit
ss_md:
	bit 2,b
R_522: 	jp z,ss_loop
	ld c,3
	ld a,(enmd)
	ld (enwpn),a
R_523: 	ld hl,wpmd
	jr ss_exit
ss_do:
	bit 3,b
R_524: 	jp z,ss_loop
	ld c,4
	ld a,(endo)
	ld (enwpn),a
R_525: 	ld hl,wpdo
	jr ss_exit
ss_se:
	bit 5,b
R_526: 	jp z,ss_loop
	ld c,5
	ld a,(ense)
	ld (enwpn),a
R_527: 	ld hl,wpse
	jr ss_exit
ss_po:
	bit 4,b
R_528: 	jp z,ss_loop
	ld c,6
	ld a,(enpo)
	ld (enwpn),a
R_529: 	ld hl,wppo
	jr ss_exit
ss_fr:
	bit 5,b
R_530: 	jp z,ss_loop
	ld c,7
	ld a,(enfr)
	ld (enwpn),a
R_531: 	ld hl,wpfr
	jr ss_exit
ss_sa:
	bit 6,b
R_532: 	jp z,ss_loop
	ld c,8
	ld a,(ensa)
	ld (enwpn),a
R_533: 	ld hl,wpsa
	jr ss_exit
ss_mi:
	bit 7,b
R_534: 	jp z,ss_loop
	ld c,9
	ld a,(enmi)
	ld (enwpn),a
R_535: 	ld hl,wpmi
ss_exit:
	ld a,c
	ld (wpn),a
	ld (wpnspr),hl
	ROM_CALL(_clrlcdfull)
R_536: 	call BUFCLR
R_537: 	call ShowLevel
	pop af
R_538: 	call tiny_delay
	ret
ss_mode:
	pop bc			; pop to something other than af so it remembers that MODE has been pressed
	ret
ss_up:
	ld a,(y2)
	cp 1
	jr z,ss_vert
	sub 10
	ld (y2),a
R_539: 	jp ss_loop_new
ss_down:
	ld a,(y2)
	cp 41
	jr z,ss_vert
	add a,10
	ld (y2),a
R_540: 	jp ss_loop_new
ss_vert:
	ld b,a
	ld a,42
	sub b
	ld (y2),a
R_541: 	jp ss_loop_new
ss_horz:
	ld a,(x2)
	ld b,a
	ld a,47
	sub b
	ld (x2),a
R_542: 	jp ss_loop_new
ss_tank:
	ld a,(tanks)
	or a
R_543: 	jp z,ss_loop_new
	dec a
	ld (tanks),a
	ld a,28
	ld (enp),a
R_544: 	jp ss_loop_new

check_spr:
	ld a,(dir)
	or a
	jr z,check_spr_l
check_spr_r:
R_545: 	ld hl,mmhr
	ld a,(hchk)
	or a
	jr nz,found_spr
	ld a,(ymm)
	add a,12
R_546: 	call CheckVert
	jr c,not_jump_r
R_547: 	ld hl,mmjr
	ld a,(jchk)
	or a
	jr nz,found_spr
not_jump_r:
R_548: 	ld hl,mmwr
	ld a,(wchk)
	or a
	jr nz,found_spr
      jr xor_char

check_spr_l:
R_550: 	ld hl,mmhl
	ld a,(hchk)
	or a
	jr nz,found_spr
	ld a,(ymm)
	add a,12
R_551: 	call CheckVert
	jr c,not_jump_l
R_552: 	ld hl,mmjl
	ld a,(jchk)
	or a
	jr nz,found_spr
not_jump_l:
R_553: 	ld hl,mmwl
	ld a,(wchk)
	or a
	jr nz,found_spr
      jr xor_char
	
found_spr:
	ld (curpic),hl
xor_char:
	ld hl,(curpic)
	ld c,12
	ld a,(ymm)
	ld e,a
	ld a,(xmm)
R_555: 	call SPRXOR
	ret


t_move:
R_556: 	call xor_en
R_557: 	call check_en_dist
	ld a,(edir)
	or a
	ld a,(xe)
	jr z,t_move_l
	inc a
	jr t_move_r
t_move_l:
	dec a
	or a
R_558: 	call z,en_dead
t_move_r:
	ld (xe),a
	ret
i_move:
R_559: 	call xor_en
R_560: 	call check_en_dist
	ld a,(edir)
	or a
	ld a,(ye)
	jr z,i_move_u
	inc a
	jr i_move_d
i_move_u:
	dec a
i_move_d:
	ld (ye),a
	ret
ti_check:
	ld a,(echk)
	cp 3
	jr nz,tic_cont
	xor a
	ld (echk),a
tic_cont:
	ld b,46
	ld c,46
	ld a,(bcount)
	inc a
	ld (bcount),a
	cp 50
	ld a,7
R_561: 	call z,item_init
	ld a,(bcount)
	cp 100
	ld a,9
R_562: 	call z,item_init
	ld a,(bcount)
	cp 100
	ret nz
	xor a
	ld (bcount),a
	ret
ship_check:
	ld a,(bcount)
	inc a
	cp 50
	jr z,ship_laser
	ld (bcount),a
	ret
ship_laser:
	xor a
	ld (bcount),a
	ld b,1
R_563: 	call xor_laser
R_564: 	call short_delay
	ld a,(ymm)
	cp 38
R_565: 	call c,die
	ld b,0
R_566: 	call xor_laser
	ret
boss_move:
R_567: 	call xor_boss
	ld a,(boss)
	or a
	jr z,ti_check
	cp 5
	jr z,ship_check
	ld a,(bjchk)
	or a
	jr nz,boss_jump
	ld a,(bdir)
	or a
	ld a,(xb)
	jr z,boss_move_l
	inc a
	cp 76
	jr boss_move_r
boss_move_l:
	dec a
	cp 56
boss_move_r:
	ld (xb),a
	jr z,boss_turn
	cp 66
R_568: 	call z,boss_shoot
	ret
boss_turn:
	ld a,(bdir)		; reverse dir boss is moving
	ld b,a
	ld a,1
	sub b
	ld (bdir),a
	ld a,2
	ld (bjchk),a
	ret
boss_jump:
	ld a,(bjchk)
	cp 1
	ld a,(yb)
	jr z,boss_fall
	dec a
	cp 34
	jr boss_jump_end
boss_fall:
	inc a
	cp 44
boss_jump_end:
	ld (yb),a
	ret nz
	ld a,(bjchk)
	dec a
	ld (bjchk),a
	ret
bshoot_sa:
	ld a,(xb)
	ld (bwx),a
R_569: 	call xor_boss
	ret
bshoot_fr:
	ld a,(xb)
	ld (bwx),a
	ret
bshoot_md:
	ld a,(xb)
	sub 8
	ld (bwx),a
	ret
boss_shoot:
	ld a,(bwchk)
	or a
	ret nz
	inc a
	ld (bwchk),a
	ld a,(boss)
	cp 3
	jr z,bshoot_md
	cp 7
	jr z,bshoot_fr
	cp 8
	jr z,bshoot_sa
	ld a,58
	ld (bwx),a
	ret
bssa_move:
R_570: 	call xor_boss
R_571: 	call check_spr
R_572: 	call xor_char
bssam_loop:
	ld a,(bwx)
	dec a
	ld (bwx),a
R_573: 	call xor_bwpn
R_574: 	call BUFCOPY
R_575: 	call xor_bwpn
	ld a,(bwx)
	or a
	jr nz,bssam_loop
bssam_loop2:
	ld a,(bwx)
	inc a
	ld (bwx),a
R_576: 	call xor_bwpn
R_577: 	call BUFCOPY
R_578: 	call xor_bwpn
	ld a,(bwx)
	cp 88
	jr nz,bssam_loop2
bssam_loop3:
	ld a,(bwx)
	dec a
	ld (bwx),a
R_579: 	call xor_bwpn
R_580: 	call BUFCOPY
R_581: 	call xor_bwpn
	ld a,(xb)
	ld b,a
	ld a,(bwx)
	cp b
	jr nz,bssam_loop3
	xor a
	ld (bwchk),a
R_582: 	call check_spr
R_583: 	call xor_char
	ld a,(ymm)
	ld b,a
	ld a,37
	cp b
	ret nc
	add a,16
	cp b
	ret c
	ld a,(enp)
	or a
	sub 4
	jr nc,bssam_nokill
	xor a
bssam_nokill:
	ld (enp),a
	ret
bsfr_move:
R_584: 	call check_spr
R_585: 	call xor_boss
R_586: 	call xor_bwpn
R_587: 	call BUFCOPY
R_588: 	call xor_char
R_589: 	call xor_boss
R_590: 	call xor_bwpn
R_591: 	call short_delay
	xor a
	ld (bwchk),a
	ld a,(xmm)
	ld b,a
	ld a,55
	cp b
	ret nc
	add a,22
	cp b
	ret c
	ld a,(ymm)
	ld b,a
	ld a,33
	cp b
	ret nc
	add a,11
	cp b
	ret c
	ld a,(enp)
	or a
	sub 4
	jr nc,bsfrm_nokill
	xor a
bsfrm_nokill:
	ld (enp),a
	ret
bsmd_move:
R_592: 	call short_delay
	ld a,(enp)
	or a
	sub 4
	jr nc,bsmdm_nokill
	xor a
bsmdm_nokill:
	ld (enp),a
	xor a
	ld (bwchk),a
	ret
boss_shot_move:
R_593: 	call xor_bwpn
	ld a,(boss)
	cp 8
R_594: 	jp z,bssa_move
	cp 3
	jr z,bsmd_move
	cp 7
	jr z,bsfr_move
	ld a,(xb)
	ld b,a
	ld a,(bwx)
	cp 2
	jr c,bsm_end
	cp b
	jr z,bsm_end
	ld b,a
bsm_cont:
	dec b
	dec b
	ld a,(boss)
	cp 4
	jr nz,bsm_store
	dec b
bsm_store:
	ld a,b
	ld (bwx),a
	ret
bsm_end:
	xor a			; boss's shot is off the screen
	ld (bwchk),a
	ret
check_en_dist:			; check distance enemy has moved and turn around if necessary
	ld a,(ecount)
	inc a
	cp 33
R_595: 	call z,en_turn
	ld (ecount),a
	ret
en_turn:
	ld hl,(enspr)
	ld de,8 ;16
	ld a,(edir)
	or a
	jr z,en_turn_r
	sbc hl,de
	dec a
	jr en_turn_l
en_turn_r:
	add hl,de
	inc a
en_turn_l:
	ld (enspr),hl
	ld (edir),a
	xor a
	ret
en_dead:			; enemy is now dead
	ld a,3
	ld (echk),a
	xor a
	ld (ecount),a
	ret
next_en:			; check if previous enemy is clear so next enemy can initialize
	ld a,(ecount2)
	inc a
	ld (ecount2),a
	cp 96
	ret nz
	xor a
	ld (echk),a
	ret
xor_en:
	ld hl,(enspr)
	ld c,8
	ld a,(ye)
	ld e,a
	ld a,(xe)
R_596: 	call SPRXOR
	ret
xor_corners:
R_597: 	ld hl,uprlft
	ld (smlspr),hl
R_598: 	call xor_8x8
	ld a,(x2)
	add a,22
	ld (x2),a
R_599: 	ld hl,uprrt
	ld (smlspr),hl
R_600: 	call xor_8x8
	ld a,(y2)
	add a,12
	ld (y2),a
R_601: 	ld hl,lwrrt
	ld (smlspr),hl
R_602: 	call xor_8x8
	ld a,(x2)
	sub 22
	ld (x2),a
R_603: 	ld hl,lwrlft
	ld (smlspr),hl
R_604: 	call xor_8x8
	ld a,(y2)
	sub 12
	ld (y2),a
	ret
xor_8x8:
	ld c,8
	ld a,(y2)
	ld e,a
	ld a,(x2)
	ld hl,(smlspr)
R_605: 	call SPRXOR
	ret
xor_wpn1:
	ld c,4
	ld a,(wy1)
	ld e,a
	ld a,(wx1)
	ld hl,(wpnspr)
R_606: 	call SPRXOR
	ret
xor_wpn2:
	ld c,4
	ld a,(wy2)
	ld e,a
	ld a,(wx2)
	ld hl,(wpnspr)
R_607: 	call SPRXOR
	ret
xor_wpn3:
	ld c,4
	ld a,(wy3)
	ld e,a
	ld a,(wx3)
	ld hl,(wpnspr)
R_608: 	call SPRXOR
	ret
xor_bwpn:
	ld c,4
	ld e,49
	ld a,(bwx)
	ld hl,(bwspr)
R_609: 	call SPRXOR
	ret
tiny_delay:
	ld b,25
	jr del_loop
short_delay:
	ld b,55
	jr del_loop
long_delay:
R_610: 	call delay
R_6100: 	call delay
med_delay:
	ld b,110
	jr del_loop
delay:
	ld b,200
del_loop:
      ei
	halt
	halt
	djnz del_loop
	ret
disp_boss:
	ld (bosspic),hl
	ROM_CALL(_clrlcdfull)
R_611: 	call BUFCLR
	xor a
	ld (x2),a
	ld a,16
	ld (y2),a
R_612: 	ld hl,bint
	ld (smlspr),hl
	ld b,12
draw1:
	push bc
R_613: 	call xor_8x8
	ld a,(x2)
	add a,8
	ld (x2),a
	pop bc
	djnz draw1
	ld a,0
	ld (x2),a
	ld a,40
	ld (y2),a
R_614: 	ld hl,bint
	ld (smlspr),hl
	ld b,12
draw2:
	push bc
R_615: 	call xor_8x8
	ld a,(x2)
	add a,8
	ld (x2),a
	pop bc
	djnz draw2
R_616: 	call xor_boss
R_617: 	call BUFCOPY2
	ret
xor_boss:
	ld c,12
	ld a,(yb)
	ld e,a
	ld a,(xb)
	ld hl,(bosspic)
R_618: 	call SPRXOR
	ret
no_an:
	ld d,2
	ld e,1
	ld h,31
	ld l,20
R_619: 	call FLine
	ld e,20
	ld l,1
R_620: 	call FLine
	ret
no_ma:
	ld d,33
	ld e,1
	ld h,62
	ld l,21
R_621: 	call FLine
	ld e,21
	ld l,1
R_622: 	call FLine
	ret
no_md:
	ld d,64
	ld e,1
	ld h,93
	ld l,21
R_623: 	call FLine
	ld e,20
	ld l,1
R_624: 	call FLine
	ret
no_do:
	ld d,2
	ld e,22
	ld h,31
	ld l,41
R_625: 	call FLine
	ld e,41
	ld l,22
R_626: 	call FLine
	ret
no_po:
	ld d,64
	ld e,22
	ld h,93
	ld l,41
R_627: 	call FLine
	ld e,41
	ld l,22
R_628: 	call FLine
	ret
no_fr:
	ld d,2
	ld e,43
	ld h,31
	ld l,62
R_629: 	call FLine
	ld e,62
	ld l,43
R_630: 	call FLine
	ret
no_sa:
	ld d,33
	ld e,43
	ld h,62
	ld l,62
R_631: 	call FLine
	ld e,62
	ld l,43
R_632: 	call FLine
	ret
no_mi:
	ld d,64
	ld e,43
	ld h,93
	ld l,62
R_633: 	call FLine
	ld e,62
	ld l,43
R_634: 	call FLine
	ret
you_got:
	ROM_CALL(_clrlcdfull)
R_635: 	call BUFCLR
	ld d,0
	ld e,0
	ld h,94
	ld l,0
R_636: 	call FLine
	ld e,62
	ld l,62
R_637: 	call FLine
	ld e,43
	ld l,43
R_638: 	call FLine
	ld d,94
	ld e,62
	ld l,0
R_639: 	call FLine
	ld d,0
	ld h,0
R_640: 	call FLine
	ld hl,35
	ld (xmm),hl
	ld a,50
	ld (ymm),a
R_641: 	ld hl,mmsr
	ld (curpic),hl
	ld a,43
	ld (wx1),a
	ld a,51
	ld (wy1),a
	ld a,(boss)
R_642: 	ld hl,wpmd
	cp 3
	jr z,yg_cont
R_643: 	ld hl,mmwr
	ld (curpic),hl
	ld a,55
	ld (wx1),a
	ld a,55
	ld (wy1),a
	ld a,(boss)
R_644: 	ld hl,wpan
	cp 1
	jr z,yg_cont
R_645: 	ld hl,wpma
	cp 2
	jr z,yg_cont
R_646: 	ld hl,wpdo
	cp 4
	jr z,yg_cont
R_647: 	ld hl,wppo
	cp 6
	jr z,yg_cont
	cp 9
R_648: 	ld hl,wpmi
	jr z,yg_cont
	push af
	ld a,35
	ld (wx1),a
	ld a,54
	ld (wy1),a
R_649: 	call xor_char
	pop af
R_650: 	ld hl,wpsa
	cp 8
	jr z,yg_cont
R_651: 	ld hl,wpfr
	ld (wpnspr),hl
R_652: 	call xor_wpn1
	ld a,50
	ld (wy1),a
R_653: 	call xor_wpn1
	ld a,58
	ld (wy1),a
R_654: 	ld hl,wpfr
yg_cont:
	ld (wpnspr),hl
R_655: 	call xor_wpn1
R_656: 	call xor_char
R_657: 	call BUFCOPY2
	ld hl,10*256+51
	ld (pencol),hl
R_658: 	ld hl,yougot
	ROM_CALL(_VPUTS)
	ld a,(boss)
	cp 1
	jr z,yg_an
	cp 2
	jr z,yg_ma
	cp 3
	jr z,yg_md
	cp 4
	jr z,yg_do
	cp 6
	jr z,yg_po
	cp 7
	jr z,yg_fr
	cp 8
R_659: 	jp z,yg_sa
R_660: 	jp yg_mi
yg_an:
	ld hl,20*256+44
	ld (pencol),hl
R_661: 	ld hl,ygan
	ROM_CALL(_VPUTS)
R_662: 	jp yg_loop
yg_ma:
	ld hl,20*256+41
	ld (pencol),hl
R_663: 	ld hl,ygma
	ROM_CALL(_VPUTS)
	jr yg_loop
yg_md:
	ld hl,20*256+36
	ld (pencol),hl
R_664: 	ld hl,ygmd
	ROM_CALL(_VPUTS)
	jr yg_loop
yg_do:
	ld hl,20*256+42
	ld (pencol),hl
R_665: 	ld hl,ygdo
	ROM_CALL(_VPUTS)
	jr yg_loop
yg_po:
	ld hl,20*256+34
	ld (pencol),hl
R_666: 	ld hl,ygpo
	ROM_CALL(_VPUTS)
	jr yg_loop
yg_fr:
	ld hl,20*256+47
	ld (pencol),hl
R_667: 	ld hl,ygfr
	ROM_CALL(_VPUTS)
	ld hl,30*256+28
	ld (pencol),hl
R_668: 	ld hl,ygse
	ROM_CALL(_VPUTS)
	ld hl,53*256+71
	ld (pencol),hl
R_669: 	ld hl,se
	ROM_CALL(_VPUTS)
	jr yg_loop
yg_sa:
	ld hl,20*256+44
	ld (pencol),hl
R_670: 	ld hl,ygsa
	ROM_CALL(_VPUTS)
	jr yg_loop
yg_mi:
	ld hl,20*256+44
	ld (pencol),hl
R_671: 	ld hl,ygmi
	ROM_CALL(_VPUTS)
yg_loop:
	ROM_CALL(_getk)
	cp kMode
	ret z
	cp kEnter
	jr nz,yg_loop
	ret
draw_grid:
	ROM_CALL(_clrlcdfull)
R_672: 	call BUFCLR
	ld d,28
	ld e,9
	ld h,73
	ld l,9
R_673: 	call FLine
	ld e,18
	ld l,18
R_674: 	call FLine
	ld e,27
	ld l,27
R_675: 	call FLine
	ld e,36
	ld l,36
R_676: 	call FLine
	ld e,45
	ld l,45
R_677: 	call FLine
	ld e,54
	ld l,54
R_678: 	call FLine
	ld h,28
	ld l,10
R_679: 	call FLine
	ld d,37
	ld h,37
R_680: 	call FLine
	ld d,46
	ld h,46
R_681: 	call FLine
	ld d,55
	ld h,55
R_682: 	call FLine
	ld d,64
	ld h,64
R_683: 	call FLine
	ld d,73
	ld h,73
R_684: 	call FLine
	ret
pw_text:
	ld hl,1*256+47
	ld (pencol),hl
R_685: 	ld hl,one
	ROM_CALL(_VPUTS)
	ld hl,1*256+56
	ld (pencol),hl
R_686: 	ld hl,two
	ROM_CALL(_VPUTS)
	ld hl,1*256+65
	ld (pencol),hl
R_687: 	ld hl,three
	ROM_CALL(_VPUTS)
	ld hl,1*256+74
	ld (pencol),hl
R_688: 	ld hl,four
	ROM_CALL(_VPUTS)
	ld hl,1*256+83
	ld (pencol),hl
R_689: 	ld hl,five
	ROM_CALL(_VPUTS)
	ld hl,10*256+39
	ld (pencol),hl
R_690: 	ld hl,a
	ROM_CALL(_VPUTS)
	ld hl,19*256+39
	ld (pencol),hl
R_691: 	ld hl,b
	ROM_CALL(_VPUTS)
	ld hl,28*256+39
	ld (pencol),hl
R_692: 	ld hl,c
	ROM_CALL(_VPUTS)
	ld hl,37*256+39
	ld (pencol),hl
R_693: 	ld hl,d
	ROM_CALL(_VPUTS)
	ld hl,46*256+39
	ld (pencol),hl
R_694: 	ld hl,e
	ROM_CALL(_VPUTS)
	ld hl,56*256+48
	ld (pencol),hl
R_695: 	ld hl,enter
	ROM_CALL(_VPUTS)
	ret
show_pw:
R_696: 	call draw_grid
	ld a,(tanks)		; find correct password dot for number of tanks
	ld b,1
	or a
	jr z,spw_cont
	ld b,2
	cp 1
	jr z,spw_cont
	ld b,4
	cp 2
	jr z,spw_cont
	ld b,8
	cp 3
	jr z,spw_cont
	ld b,16
spw_cont:
	ld a,b
	ld (tankpw),a
R_697: 	ld hl,pwdot
	ld (smlspr),hl
	ld a,(lv1done)
	bit 0,a
	jr z,no_an_dot
	ld a,28
	jr an_dot
no_an_dot:
	ld a,46	
an_dot:
	ld (y2),a
	ld a,47
	ld (x2),a
R_698: 	call xor_8x8
	ld a,(lv1done)
	bit 1,a
	jr z,no_ma_dot
	ld a,10
	ld (y2),a
	ld a,38
	jr ma_dot
no_ma_dot:
	ld a,28
	ld (y2),a
	ld a,65
ma_dot:
	ld (x2),a

R_699: 	call xor_8x8
	ld a,(lv1done)
	bit 2,a
	jr z,no_md_dot
	ld a,46
	ld (y2),a
	ld a,65
	jr md_dot
no_md_dot:
	ld a,10
	ld (y2),a
	ld a,56
md_dot:
	ld (x2),a
R_700: 	call xor_8x8
	ld a,(lv1done)
	bit 3,a
	jr z,no_do_dot
	ld a,37
	ld (y2),a
	ld a,47
	jr do_dot
no_do_dot:
	ld a,46
	ld (y2),a
	ld a,38
do_dot:
	ld (x2),a
R_701: 	call xor_8x8
	ld a,(lv1done)
	bit 4,a
	jr z,no_po_dot
	ld a,37
	ld (y2),a
	ld a,29
	jr po_dot
no_po_dot:
	ld a,19
	ld (y2),a
	ld a,65
po_dot:
	ld (x2),a
R_702: 	call xor_8x8
	ld a,(lv1done)
	bit 5,a
	jr z,no_fr_dot
	ld a,56
	jr fr_dot
no_fr_dot:
	ld a,29
fr_dot:
	ld (x2),a
	ld a,19
	ld (y2),a
R_703: 	call xor_8x8
	ld a,(lv1done)
	bit 5,a
	jr z,no_se_dot
	ld a,46
	ld (y2),a
	ld a,29
	jr se_dot
no_se_dot:
	ld a,28
	ld (y2),a
	ld a,56
se_dot:
	ld (x2),a
R_704: 	call xor_8x8
	ld a,(lv1done)
	bit 6,a
	jr z,no_sa_dot
	ld a,38
	jr sa_dot
no_sa_dot:
	ld a,47
sa_dot:
	ld (x2),a
	ld a,19
	ld (y2),a
R_705: 	call xor_8x8
	ld a,(lv1done)
	bit 7,a
	jr z,no_mi_dot
	ld a,28
	ld (y2),a
	ld a,38
	jr mi_dot
no_mi_dot:
	ld a,37
	ld (y2),a
	ld a,56
mi_dot:
	ld (x2),a
R_706: 	call xor_8x8
tank_dot:
	ld a,(tankpw)
	ld b,a
	ld a,10
	ld (y2),a
	ld a,47
	ld (x2),a
	bit 0,b
	jr nz,tank_dot_found
	ld a,46
	ld (y2),a
	ld a,56
	ld (x2),a
	bit 1,b
	jr nz,tank_dot_found
	ld a,28
	ld (y2),a
	ld a,29
	ld (x2),a
	bit 2,b
	jr nz,tank_dot_found
	ld a,10
	ld (y2),a
	ld a,65
	ld (x2),a
	bit 3,b
	jr nz,tank_dot_found
	ld a,37
	ld (y2),a
	ld a,38
	ld (x2),a
tank_dot_found:
R_707: 	call xor_8x8
R_708: 	call BUFCOPY2
R_709: 	call pw_text
show_pw_loop:
	ROM_CALL(_getk)
	cp kMode
	ret z
	cp kEnter
	jr nz,show_pw_loop
	ret
enter_pw:
	xor a
	ld (anpw),a
	ld (mapw),a
	ld (mdpw),a
	ld (dopw),a
	ld (popw),a
	ld (frpw),a
	ld (sepw),a
	ld (sapw),a
	ld (mipw),a
	ld (tankpw),a
R_710: 	call draw_grid
R_711: 	ld hl,pwcurs
	ld (smlspr),hl
	ld a,10
	ld (y2),a
	ld a,29
	ld (x2),a
ep_loop_new:
R_712: 	call xor_8x8
R_713: 	call BUFCOPY2
R_714: 	call pw_text
R_715: 	call xor_8x8
ep_loop:
	ROM_CALL(_getk)
	cp kLeft
	jr z,ep_left
	cp kRight
	jr z,ep_right
	cp kUp
	jr z,ep_up
	cp kDown
	jr z,ep_down
	cp k2nd
	jr z,ep_dot
	cp kEnter
R_716: 	jp z,check_pw
	cp kMode
	ret z
	jr ep_loop
ep_left:
	ld a,(x2)
	cp 29
	jr z,ep_horz
	sub 9
	ld (x2),a
	jr ep_loop_new
ep_right:
	ld a,(x2)
	cp 65
	jr z,ep_horz
	add a,9
	ld (x2),a
	jr ep_loop_new
ep_horz:
	ld b,a
	ld a,94
	sub b
	ld (x2),a
	jr ep_loop_new
ep_up:
	ld a,(y2)
	cp 10
	jr z,ep_vert
	sub 9
	ld (y2),a
	jr ep_loop_new
ep_down:
	ld a,(y2)
	cp 46
	jr z,ep_vert
	add a,9
	ld (y2),a
	jr ep_loop_new
ep_vert:
	ld b,a
	ld a,56
	sub b
	ld (y2),a
	jr ep_loop_new
ep_dot:
R_717: 	ld hl,pwdot
	ld (smlspr),hl
R_718: 	call xor_8x8
R_719: 	ld hl,pwcurs
	ld (smlspr),hl
	ld a,(y2)
	cp 10
	jr z,rowa
	cp 19
	jr z,rowb
	cp 28
R_720: 	jp z,rowc
	cp 37
R_721: 	jp z,rowd
R_722: 	jp rowe
rowa:
	ld a,(x2)
	cp 29
	jr z,rowa_col1
	cp 38
	jr z,rowa_col2
	cp 47
	jr z,rowa_col3
	cp 56
	jr z,rowa_col4
	jr rowa_col5
rowa_col1:
	ld a,(tankpw)
	bit 5,a
	set 5,a
R_723: 	jp z,tankpw_done
	res 5,a
R_724: 	jp tankpw_done
rowa_col2:
	ld a,(mapw)
	bit 1,a
	set 1,a
	jr z,mapw_done
	res 1,a
mapw_done:
	ld (mapw),a
R_725: 	jp ep_loop_new
rowa_col3:
	ld a,(tankpw)
	bit 0,a
	set 0,a
R_726: 	jp z,tankpw_done
	res 0,a
R_727: 	jp tankpw_done
rowa_col4:
	ld a,(mdpw)
	bit 0,a
	set 0,a
	jr z,mdpw_done
	res 0,a
mdpw_done:
	ld (mdpw),a
R_728: 	jp ep_loop_new
rowa_col5: 
	ld a,(tankpw)
	bit 3,a
	set 3,a
R_729: 	jp z,tankpw_done
	res 3,a
R_730: 	jp tankpw_done 
rowb:
	ld a,(x2)
	cp 29
	jr z,rowb_col1
	cp 38
	jr z,rowb_col2
	cp 47
	jr z,rowb_col3
	cp 56
	jr z,rowb_col4
	jr rowb_col5
rowb_col1:
	ld a,(frpw)
	bit 0,a
	set 0,a
	jr z,frpw_done
	res 0,a
frpw_done:
	ld (frpw),a
R_731: 	jp ep_loop_new 
rowb_col2:
	ld a,(sapw)
	bit 1,a
	set 1,a
	jr z,sapw_done
	res 1,a
sapw_done:
	ld (sapw),a
R_732: 	jp ep_loop_new
rowb_col3: 
	ld a,(sapw)
	bit 0,a
	set 0,a
	jr z,sapw_done
	res 0,a
	jr sapw_done
rowb_col4: 
	ld a,(frpw)
	bit 1,a
	set 1,a
	jr z,frpw_done
	res 1,a
	jr frpw_done
rowb_col5: 
	ld a,(popw)
	bit 0,a
	set 0,a
	jr z,popw_done
	res 0,a
popw_done:
	ld (popw),a
R_733: 	jp ep_loop_new 
rowc:
	ld a,(x2)
	cp 29
	jr z,rowc_col1
	cp 38
	jr z,rowc_col2
	cp 47
	jr z,rowc_col3
	cp 56
	jr z,rowc_col4
	jr rowc_col5 
rowc_col1:
	ld a,(tankpw)
	bit 2,a
	set 2,a
	jr z,tankpw_done
	res 2,a
tankpw_done:
	ld (tankpw),a
R_734: 	jp ep_loop_new 
rowc_col2:
	ld a,(mipw)
	bit 1,a
	set 1,a
	jr z,mipw_done
	res 1,a
mipw_done:
	ld (mipw),a
R_735: 	jp ep_loop_new
rowc_col3: 
	ld a,(anpw)
	bit 1,a
	set 1,a
R_736: 	jp z,anpw_done
	res 1,a
R_737: 	jp anpw_done
rowc_col4: 
	ld a,(sepw)
	bit 0,a
	set 0,a
R_738: 	jp z,sepw_done
	res 0,a
R_739: 	jp sepw_done
rowc_col5: 
	ld a,(mapw)
	bit 0,a
	set 0,a
R_740: 	jp z,mapw_done
	res 0,a
R_741: 	jp mapw_done 
rowd:
	ld a,(x2)
	cp 29
	jr z,rowd_col1
	cp 38
	jr z,rowd_col2
	cp 47
	jr z,rowd_col3
	cp 56
	jr z,rowd_col4
	jr rowd_col5
rowd_col1: 
	ld a,(popw)
	bit 1,a
	set 1,a
R_742: 	jp z,popw_done
	res 1,a
R_743: 	jp popw_done
rowd_col2: 
	ld a,(tankpw)
	bit 4,a
	set 4,a
	jr z,tankpw_done
	res 4,a
	jr tankpw_done 
rowd_col3:
	ld a,(dopw)
	bit 1,a
	set 1,a
	jr z,dopw_done
	res 1,a
dopw_done:
	ld (dopw),a
R_744: 	jp ep_loop_new
rowd_col4: 
	ld a,(mipw)
	bit 0,a
	set 0,a
	jr z,mipw_done
	res 0,a
R_745: 	jp mipw_done
rowd_col5:
	ld a,(tankpw)
	bit 6,a
	set 6,a
R_746: 	jp z,tankpw_done
	res 6,a
R_747: 	jp tankpw_done
rowe:
	ld a,(x2)
	cp 29
	jr z,rowe_col1
	cp 38
	jr z,rowe_col2
	cp 47
	jr z,rowe_col3
	cp 56
	jr z,rowe_col4
	jr rowe_col5 
rowe_col1: 
	ld a,(sepw)
	bit 1,a
	set 1,a
	jr z,sepw_done
	res 1,a
sepw_done:
	ld (sepw),a
R_748: 	jp ep_loop_new 
rowe_col2:
	ld a,(dopw)
	bit 0,a
	set 0,a
	jr z,dopw_done
	res 0,a
	jr dopw_done
rowe_col3:
	ld a,(anpw)
	bit 0,a
	set 0,a
	jr z,anpw_done
	res 0,a
anpw_done:
	ld (anpw),a
R_749: 	jp ep_loop_new
rowe_col4: 
	ld a,(tankpw)
	bit 1,a
	set 1,a
R_750: 	jp z,tankpw_done
	res 1,a
R_751: 	jp tankpw_done 
rowe_col5: 
	ld a,(mdpw)
	bit 1,a
	set 1,a
R_752: 	jp z,mdpw_done
	res 1,a
R_753: 	jp mdpw_done
check_pw:
	ld a,(anpw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(mapw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(mdpw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(dopw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(popw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(frpw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(sepw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(sapw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(mipw)
	or a
	jr z,pw_error
	cp 3
	jr z,pw_error
	ld a,(tankpw)
	ld b,0
	cp 1
R_754: 	jp z,pw_good
	inc b
	cp 2
R_755: 	jp z,pw_good
	inc b
	cp 4
R_756: 	jp z,pw_good
	inc b
	cp 8
R_757: 	jp z,pw_good
	inc b
	cp 16
R_758: 	jp z,pw_good
pw_error:
	ROM_CALL(_clrlcdfull)
R_759: 	call BUFCLR
	ld d,19
	ld e,9
	ld h,75
	ld l,9
R_760: 	call FLine
	ld e,17
	ld l,17
R_761: 	call FLine
	ld d,18
	ld e,10
	ld h,18
	ld l,16
R_762: 	call FLine
	ld d,76
	ld h,76
R_763: 	call FLine
	ld d,29
	ld e,39
	ld h,64
	ld l,39
R_764: 	call FLine
	ld e,61
	ld l,61
R_765: 	call FLine
	ld d,28
	ld e,40
	ld h,28
	ld l,60
R_766: 	call FLine
	ld d,65
	ld h,65
R_767: 	call FLine
R_768: 	call BUFCOPY2
	ld hl,10*256+36
	ld (pencol),hl
R_769: 	ld hl,pwerr
	ROM_CALL(_VPUTS)
	ld hl,40*256+46
	ld (pencol),hl
R_770: 	ld hl,pwtry
	ROM_CALL(_VPUTS)
	ld hl,47*256+49
	ld (pencol),hl
R_771: 	ld hl,yes
	ROM_CALL(_VPUTS)
	ld hl,54*256+47
	ld (pencol),hl
R_772: 	ld hl,no
	ROM_CALL(_VPUTS)
pe_loop:
	ROM_CALL(_getk)
	cp k2nd
R_773: 	jp z,enter_pw
	cp kAlpha
	ret z
	cp kMode
	ret z
	jr pe_loop
pw_good:
	ld a,b
	ld (tanks),a
	ld a,(lv1done)
	ld b,a
	ld a,(anpw)
	bit 1,a
	jr z,pg1
	set 0,b
pg1:
	ld a,(mapw)
	bit 1,a
	jr z,pg2
	set 1,b
pg2:
	ld a,(mdpw)
	bit 1,a
	jr z,pg3
	set 2,b
pg3:
	ld a,(dopw)
	bit 1,a
	jr z,pg4
	set 3,b
pg4:
	ld a,(popw)
	bit 1,a
	jr z,pg5
	set 4,b
pg5:
	ld a,(frpw)
	bit 1,a
	jr z,pg6
	set 5,b
pg6:
	ld a,(sapw)
	bit 1,a
	jr z,pg7
	set 6,b
pg7:
	ld a,(mipw)
	bit 1,a
	jr z,pg_done
	set 7,b
pg_done:
	ld a,b
	ld (lv1done),a
	ret
ship_init:
	ld a,(bchk)
	or a
	ret z
	ld d,35
	ld e,38
	ld h,85
	ld l,38
R_774: 	call FLine
	ld h,55
	ld l,28
R_775: 	call FLine
	ld d,65
	ld e,28
R_776: 	call FLine
	ld h,85
	ld l,38
R_777: 	call FLine
	ld d,65
	ld e,48
R_778: 	call FLine
	ld h,55
	ld l,48
R_779: 	call FLine
	ld d,35
	ld e,38
R_780: 	call FLine
	ld d,45
	ld e,40
	ld h,75
	ld l,40
R_781: 	call FLine
	ld e,36
	ld l,36
R_782: 	call FLine
	ld d,56
	ld e,50
	ld h,56
	ld l,53
R_783: 	call FLine
	ld d,63
	ld h,63
R_784: 	call FLine
	ld d,58
	ld h,58
	ld l,54
R_785: 	call FLine
	ld d,61
	ld h,61
R_786: 	call FLine
	ld a,56
	ld (xb),a
	ld a,16
	ld (yb),a
	ret
xor_laser:
	ld d,8
	ld e,39
	ld h,35
	ld l,39
R_787: 	call FLine
	dec e
	dec h
	dec l
R_788: 	call FLine
	dec e
	inc h
	dec l
R_789: 	call FLine
R_790: 	call check_spr
R_791: 	call xor_boss
R_792: 	call BUFCOPY
R_793: 	call xor_char
R_794: 	call xor_boss
	ret
wpn_fill:
	ld a,28
	ld (enp),a
	ld (enan),a
	ld (enma),a
	ld (enmd),a
	ld (endo),a
	ld (ense),a
	ld (enpo),a
	ld (enfr),a
	ld (ensa),a
	ld (enmi),a
	ld (enwpn),a
	ret
draw_nrg:
	ld a,(bchk)
	or a
R_795: 	call nz,draw_bnrg
	ld d,10
	ld e,38
	ld h,10
	ld a,(enp)
	ld b,a
	ld a,37
	sub b
	ld l,a
R_796: 	call FLine
	ld a,(wpn)
	or a
	ret z
	ld d,12			; draw weapon energy line
	ld e,38
	ld h,12
	ld a,(enwpn)
	ld b,a
	ld a,37
	sub b
	ld l,a
FLine:
 ld b,1                          ;dave- the routine begins here
        push bc
        ld a,b
        ld (pixelsetting),a
        push de
        push hl
        ld a,h
        cp d
        jr nc,DXpos
        ex de,hl
DXpos:
        ld b,d
        ld c,e
        ld de,$8641
        push hl
R_797:        call FindPixel
        add hl,de
        ex (sp),hl
        ld e,c
        ld c,a
        ld a,h
        sub b
        ld b,a
        ld a,l
        sub e
        ld de,12
        jr nc,DYpos
        neg
        ld de,-12
DYpos:
        push af
        sub b
        jr nc,DY_Greater
        add a,a
        neg
R_806        ld (x_ai+1),a
        pop af
        add a,a
R_805        ld (XDNeg+1),a
        sub b
        pop hl
        push af
        ld a,c
R_798:      call setpixel
        pop af
        bit 7,a
        jr nz,XDNeg
XNewRow:
        add hl,de
x_ai:
        sub 0
        push af
        rrc c
        jr nc,XNoWrap1
        inc hl
XNoWrap1:
        ld a,c
R_799:                call setpixel
        pop af
        dec b
        jr z,LineDone
        jr nc,XNewRow
XDNeg:
        add a,0
        push af
        rrc c
        jr nc,XNoWrap2
        inc hl
XNoWrap2:
        ld a,c
R_800:        call setpixel
        pop af
        dec b
        jr z,LineDone
        jr c,XNewRow
        jr XDNeg
DY_Greater:
        neg
        add a,a
R_801        ld (YNoWrap+1),a
        ld a,b
        add a,a
R_802        ld (YDNeg+1),a
        pop hl
        sub h
        ld b,h
        pop hl
        push af
        ld a,c
R_803        call setpixel
        pop af
YRepeat:
        bit 7,a
        jr nz,YDNeg
        rrc c
        jr nc,YNoWrap
        inc hl
YNoWrap:
        add a,0
        jr YPlot
YDNeg:
        add a,0
YPlot:
        add hl,de
        push af
        ld a,c
R_804        call setpixel
        pop af
        djnz YRepeat
LineDone:
        pop hl
        pop de
        pop bc
        ret

setpixel:
        push af
        ld a,(pixelsetting)
        cp 1
        jr z,orpixel
        pop af
        cpl
        and (hl)
        ld (hl),a
        jr orpixelend
orpixel:
        pop af
        or (hl)
        ld (hl),a
orpixelend:
        ret
;
; This is your default FindPixel routine. Can be exchanged with
; the famous Eble-Yopp... FindPixel routine.
;

FindPixel:
        push bc
        push de
R_807:         ld hl,ExpTable
        ld d,0
        ld a,b
        and $07
        ld e,a
        add hl,de
        ld e,(hl)
        ld h,d
        srl b
        srl b
        srl b
        ld a,c
        add a,a
        add a,a
        ld l,a
        add hl,hl
        push de
        ld e,a
        ld d,0 
        add hl,de
        pop de
        ld a,e
        ld e,b
        add hl,de
        pop de
        pop bc
        ret

ExpTable:
        .db $80,$40,$20,$10,$08,$04,$02,$01

draw_bnrg:
	ld d,86
	ld e,38
	ld h,86
	ld a,(enb)
	ld b,a
	ld a,37
	sub b
	ld l,a
R_808:	call FLine
	ret

check_ehitu:
	ld a,(echk)
	cp 3
	ret z
	ld a,(wx1)
	ld d,a
	ld a,(wy1)
	ld e,a
	ld a,(wchk1)
	ld c,a
	or a
R_809: 	call nz,check_white
	ld a,c
	ld (wchk1),a
	ld a,(wx2)
	ld d,a
	ld a,(wy2)
	ld e,a
	ld a,(wchk2)
	ld c,a
	or a
R_810: 	call nz,check_white
	ld a,c
	ld (wchk2),a
	ld a,(wx3)
	ld d,a
	ld a,(wy3)
	ld e,a
	ld a,(wchk3)
	ld c,a
	or a
R_811: 	call nz,check_white
	ld a,c
	ld (wchk3),a
	ld a,(xmm)
	ld b,a
	ld a,(xe)
	sub 7
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld a,(ymm)
	ld b,a
	ld a,(ye)
	sub 11
	cp b
	ret nc
	add a,18
	cp b
	ret c
	ld a,(enp)
	or a
	sub 1
	jr nc,ehitu_nokill
	xor a
ehitu_nokill:
	ld (enp),a
	ld a,1
	ld (hchk),a
	ret
check_bhitu:
	ld a,(wx1)
	ld d,a
	ld a,(wy1)
	ld e,a
	ld a,(wchk1)
	ld c,a
	or a
R_812: 	call nz,check_whitb
	ld a,c
	ld (wchk1),a
	ld a,(wx2)
	ld d,a
	ld a,(wy2)
	ld e,a
	ld a,(wchk2)
	ld c,a
	or a
R_813: 	call nz,check_whitb
	ld a,c
	ld (wchk2),a
	ld a,(wx3)
	ld d,a
	ld a,(wy3)
	ld e,a
	ld a,(wchk3)
	ld c,a
	or a
R_814: 	call nz,check_whitb
	ld a,c
	ld (wchk3),a
	ld a,(boss)
	cp 5
	jr z,check_shitu
	ld a,(xmm)
	ld b,a
	ld a,(xb)
	sub 7
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld a,(ymm)
	ld b,a
	ld a,(yb)
	sub 11
	cp b
	ret nc
	add a,22
	cp b
	ret c
	ld a,(enp)
	or a
	sub 7
	jr nc,bhitu_nokill
	xor a
bhitu_nokill:
	ld (enp),a
	ld a,1
	ld (hchk),a
	ret
check_shitu:
	ld a,(xmm)
	ld b,a
	ld a,28
	cp b
	ret nc
	xor a
	ld (enp),a
	ld a,1
	ld (hchk),a
	ret
check_bwhitu:
	ld a,(xmm)
	ld b,a
	ld a,(bwx)
	sub 7
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld a,(ymm)
	ld b,a
	ld a,38
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld a,(enp)
	or a
	sub 2
	jr nc,bwhitu_nokill
	xor a
bwhitu_nokill:
	ld (enp),a
	ld a,1
	ld (hchk),a
	ret
check_white:
	ld a,(xe)
	ld b,a
	ld a,d
	sub 7
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld a,(ye)
	ld b,a
	ld a,e
	sub 7
	cp b
	ret nc
	add a,10
	cp b
	ret c
	ld c,0
	ld a,(ene)
	or a
	sub 1
	jr nc,white_nokill
	xor a
white_nokill:
	ld (ene),a
	or a
	ret nz
	ld a,3
	ld (echk),a
	ret
check_whitb:
	ld a,(boss)
	cp 5
	jr z,check_whits
	ld a,(xb)
	ld b,a
	ld a,d
	sub 7
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld a,(yb)
	ld b,a
	ld a,e
	sub 11
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld c,0
R_815: 	call dam7_or1
	ld a,(enb)
	or a
	sub 1
	jr nc,whitb_nokill
	xor a
whitb_nokill:
	ld (enb),a
	ret nz
R_816: 	call won
	ret
check_whits:
	ld b,35
	ld a,d
	sub 7
	cp b
	ret nc
	add a,14
	cp b
	ret c
	ld b,42
	ld a,e
	cp b
	ret nc
	add a,10
	cp b
	ret c
	ld c,0
R_817: 	call dam7_or1
	ld a,(enb)
	or a
	sub 1
	jr nc,whits_nokill
	xor a
whits_nokill:
	ld (enb),a
	or a
	ret nz
R_818: 	call won
	ret
dam7_or1:
	ld a,(wpn)
	or a
	ret z
	cp 5
	ret z
	cp 1
	jr z,an_on_po
	cp 2
	jr z,ma_on_do
	cp 3
	jr z,md_on_sa
	cp 4
	jr z,do_on_fr
	cp 6
	jr z,po_on_md
	cp 7
	jr z,fr_on_an
	cp 8
	jr z,sa_on_mi
	cp 9
	jr z,mi_on_ma
an_on_po:
	ld a,(boss)
	cp 5
	jr z,damage7
	cp 6
	ret nz
	jr damage7
ma_on_do:
	ld a,(boss)
	or a
	jr z,damage7
	cp 4
	ret nz
	jr damage7
md_on_sa:
	ld a,(boss)
	cp 8
	ret nz
	jr damage7
do_on_fr:
	ld a,(boss)
	cp 7
	ret nz
	jr damage7
po_on_md:
	ld a,(boss)
	cp 3
	ret nz
	jr damage7
fr_on_an:
	ld a,(boss)
	cp 1
	ret nz
	jr damage7
sa_on_mi:
	ld a,(boss)
	cp 9
	ret nz
	jr damage7
mi_on_ma:
	ld a,(boss)
	cp 2
	ret nz
damage7:
	ld a,(enb)
	or a
	sub 6
	jr nc,dam7_nokill
R_819: 	call won
	xor a
dam7_nokill:
	ld (enb),a
	ret
thrown_back:
	xor a
	ld (hchk),a
	ld hl,(xmm)
R_820: 	call load_x
	or a
	ld de,8
	sbc hl,de
	push hl
	push hl
R_821: 	call CheckHorz
	pop hl
R_822: 	call z,CheckHorz2
	pop hl
R_823: 	call z,CheckHorz3
	jr nz,thrown_short
	ld a,(xmm)
	sub 8
	ld (xmm),a
	ret
thrown_short:
	ld hl,(xmm)
R_824: 	call load_x
	push hl
	srl h
	rr l
	srl h
	rr l
	srl h
 	rr l			; divide x by 8
	add hl,hl
	add hl,hl
	add hl,hl		; multiply x by 8
	push hl
	pop de
	pop hl
	or a
	sbc hl,de
	push hl
	ld hl,(xmm)
	pop de
	or a
	sbc hl,de
	ld (xmm),hl
	ret

; SPRXOR 
;Ŀ
; Xor 8x8 sprite  a=x, e=y, bc=sprite address                               
;
SPRXOR:
; ld b,a
; ld a,c
; ld d,a
; ld a,e
; ld c,a
; ld a,d
; ld e,a

	push hl		; Save sprite address
;   Calculate the address in graphbuf   
	ld hl,0		; Do y*12
	ld d,0
	add hl,de
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld d,0		; Do x/8
	ld e,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,PLOTSSCREEN
	add hl,de		; Add address to graphbuf
	ld b,00000111b	; Get the remainder of x/8
	and b
	or a			; Is this sprite aligned to 8*n,y?
R_825: 	jp z,XALIGN
;   Non aligned sprite blit starts here   
	pop ix		; ix->sprite
	ld d,a		; d=how many bits to shift each line
	ld e,c		; Line loop
XLILOP:
	ld b,(ix+0)		; Get sprite data
	ld c,0		; Shift loop
	push de
XSHLOP:
	srl b
	rr c
	dec d
R_826: 	jp nz,XSHLOP
	pop de
	ld a,b		; Write line to graphbuf
	xor (hl)
	ld (hl),a
	inc hl
	ld a,c
	xor (hl)
	ld (hl),a
	ld bc,11		; Calculate next line address
	add hl,bc
	inc ix		; Inc spritepointer
	dec e
R_827: 	jp nz,XLILOP	; Next line
R_828: 	jp XDONE1
;   Aligned sprite blit starts here   
XALIGN:			; Blit an aligned sprite to graphbuf
	pop de		; de->sprite
	ld b,c
XALOP1:
	ld a,(de)
	xor (hl)
	ld (hl),a
	inc de
	push bc
	ld bc,12
	add hl,bc
	pop bc
	djnz XALOP1
XDONE1:
	ret

;
;Hideaki Omuro's SpriteClip routine begins here 
;

PutSprClp: 
   XOR  A
__XChange_1:    LD   DE, 8     ; D = 0, E = Height

                OR   C                            ; If C < 0
R_5000:         JP   M, _SCX_NoBotClp             ; No bottom clip.

                LD   A, $3F                       ; Is C is offscreen?
                SUB  C
                RET  C

__XChange_2:    CP   8-1       ; If C + 7 < 64
                JR   NC, _SCX_NoVertClp           ; No vertical clip.
                INC  A
                LD   E, A
                JR   _SCX_NoVertClp               ; Height = 64 - C

_SCX_NoBotClp:
__XChange_3:    CP   -(8-1)    ; Is C is offscreen?
                RET  C

                ADD  A, E                         ; Find how many lines
                LD   C, A                         ; to actually draw
                SUB  E

                NEG
                LD   E, A
                ADD  HL, DE                       ; Move HL down
                LD   E, C                         ; by -C lines
                LD   C, D

_SCX_NoVertClp: PUSH HL                           ; IX -> Sprite
                POP  IX

                LD   A, $77                       ; OP code for
R_5001:                         LD   (_SCX_OPchg_1), A            ;   LD   (HL), A
R_5002:                         LD   (_SCX_OPchg_2), A

                XOR  A                            ; Is B > 0?
                OR   B
R_5003:                         JP   M, _SCX_NoRightClp

                CP   89                           ; Is B < 89?
                JR   C, _SCX_ClpDone
                CP   96
                RET  NC

R_5004:                         LD   HL, _SCX_OPchg_1             ; Modify LD to NOP
                JR   _SCX_ClpModify

_SCX_NoRightClp:CP   -7                           ; Is B is offscreen?
                RET  C

R_5005:                         LD   HL, _SCX_OPchg_2             ; Modify LD to NOP
_SCX_ClpModify: LD   (HL), D

_SCX_ClpDone:   LD   B, D
                LD   H, B
                LD   L, C
                ADD  HL, BC                       ; HL = Y * 12
                ADD  HL, BC
                ADD  HL, HL
                ADD  HL, HL

                LD   C, A                         ; HL = Y*12 + X/8
                SRA  C
                SRA  C
                SRA  C
                INC  C

                ADD  HL, BC
                LD   BC, PLOTSSCREEN
                ADD  HL, BC

                LD   B, E                         ; B = number of rows

                CPL
                AND  %00000111                    ; find number of
                LD   E, A                         ; instructions to jump
                ADD  A, E
                ADD  A, E
R_5006:                         LD   (_SCX_OPchg_3 + 1), A        ; 3 * (7 - number)

                LD   DE, 13

_SCX_LineLoop:  LD   C, (IX)
                XOR  A
_SCX_OPchg_3:   JR   _SCX_OPchg_3                 ; modify

                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA

                XOR  (HL)                         ; XOR with background
_SCX_OPchg_1:   LD   (HL), A                      ; Write
                DEC  HL                           ; HL -> next 8 pixels

                LD   A, C
                XOR  (HL)                         ; XOR with background
_SCX_OPchg_2:   LD   (HL), A                      ; Write
                ADD  HL, DE                       ; HL -> next row

                INC  IX                           ; Increment to next data
                DJNZ _SCX_LineLoop
                RET

 

; SPRXOR 

;Ŀ
; Z80 ۳    Sprite83    ۳ movax ۳
;
BUFCLR:
 push af \ push hl \ push de \ push bc
 LD HL,$8641
 LD (HL),0
 LD DE,$8642
 LD BC,1024
 LDIR
 pop bc \ pop de \ pop hl \ pop af
 RET
a_n:	.db	"Anchorman",0
m_a:	.db	"Mailman",0
m_d:	.db	"Madman",0
d_o:	.db	"Doorman",0


t_i:	.db	"Titanic Iniquity",0
p_o:	.db	"Policeman",0
f_r:	.db	"Freshman",0
s_a:	.db	"Salesman",0
m_i:	.db	"Milkman",0

p:	.db	"P",0
an:	.db	"AN",0
ma:	.db	"MA",0
md:	.db	"MD",0
do:	.db	"DO",0
se:	.db	"??",0
po:	.db	"PO",0
fr:	.db	"FR",0
sa:	.db	"SA",0
mi:	.db	"MI",0

a:	.db	"A",0
b:	.db	"B",0
c:	.db	"C",0
d:	.db	"D",0
e:	.db	"E",0
one:	.db	"1",0
two:	.db	"2",0
three:	.db	"3",0
four:	.db	"4",0
five:	.db	"5",0
enter:	.db	"Press Enter",0

yougot:	.db	"You Got",0
ygan:	.db	"Anchor Toss",0
ygma:	.db	"Stamp Throw",0
ygmd:	.db	"Swearing Scream",0
ygdo:	.db	"Splinter Shot",0
ygpo:	.db	"Badge Boomerang",0
ygfr:	.db	"Zit Shield",0
ygse:	.db	"and Top Secret Weapon",0
ygsa:	.db	"Bill Charge",0
ygmi:	.db	"Milk Bubble",0

pwerr:	.db	"Password Error!",0
pwtry:	.db	"Try Again?",0
yes:	.db	"2nd = Yes",0
no:	.db	"Alpha = No",0

gover:	.db	"Game Over",0
cont:	.db	"2nd = Continue",0
stgsel:	.db	"Alpha = Stage Select",0
endgame:	.db	"Exit = End",0

intro1:	.db	"The battles of Mega Man and",0
intro2:	.db	"Dr. Wily raged for many",0
intro3:	.db	"years, until age finally",0
intro4:	.db	"began to take its toll on",0
intro5:	.db	"Wily.  In the final years of",0
intro6:	.db	"his life, Wily devoted all",0
intro7:	.db	"his time to constructing",0
intro8:	.db	"his most ingenious and",0
intro9:	.db	"horrifying robotic",0
intro10:	.db	"creation ever...",0
intro11:	.db	"Having used his cherished",0
intro12:	.db	"TI-85 calculator as the",0
intro13:	.db	"very core of his greatest",0
intro14:	.db	"masterpiece, Wily, with",0
intro15:	.db	"his last dying breath,",0
intro16:	.db	"dubbed his new successor:",0
intro17:	.db	"'Titanic Iniquity',",0
intro18:	.db	"or 'TI' for short.  Mega Man",0
intro19:	.db	"must now stop TI and his 8",0
intro20:	.db	"new robot masters...",0

end1:	.db	"Upon the destruction of TI,",0
end2:	.db	"Mega Man is visibly upset",0
end3:	.db	"that such a great thing had",0
end4:	.db	"to be destroyed...",0
end5:	.db	"Had it not been for Dr. Wily,",0
end6:	.db	"the TI-85 calc might",0
end7:	.db	"have been used for good",0
end8:	.db	"instead of for evil...",0
end9:	.db	"These thoughts all ran",0
end10:	.db	"through the mind of our hero",0
end11:	.db	"as he turned around to head",0
end12:	.db	"back to the lab...",0
end13:	.db	"Mega Man was just about",0
end14:	.db	"to leave, when he realized",0
end15:	.db	"that some good could still",0
end16:	.db	"come out of TI...",0
end17:	.db	"As a robot, Mega Man can",0
end18:	.db	"program and re-program",0
end19:	.db	"just about anything, and",0
end20:	.db	"TI was no exception...",0
end21:	.db	"he quickly ran over to the",0
end22:	.db	"lifeless robot and used",0
end23:	.db	"all of his skill to make",0
end24:	.db	"his enemy into his friend...",0
end25:	.db	"In a short time, Mega Man",0
end26:	.db	"proved his mastery in",0
end27:	.db	"re-programming, and TI",0
end28:	.db	"was reborn...",0
end29:	.db	"As they both left, Mega",0
end30:	.db	"Man knew that he would",0
end31:	.db	"never again have to face",0
end32:	.db	"Titanic Iniquity...",0
end33:	.db	"Often, TI would",0
end34:	.db	"ask his new friend",0
end35:	.db	"what his initials",0
end36:	.db	"stood for...",0
end37:	.db	"In response,",0
end38:	.db	"Mega Man",0
end39:	.db	"would always just",0
end40:	.db	"smile, and say...",0
end41:	.db	"'Thats Irrelevant.'",0
end42:	.db	"  H",0
end43:	.db	"  END.",0

cred1:	.db	"Programming:",0
cred2:	.db	"Graphics:",0
cred3:	.db	"Testers:",0
cred4:	.db	"Special Thanks to:",0
cred5:	.db	"Dave Jaklitsch",0
cred55:     .db   "85/86 Port by:",0
cred56      .db   "Sam Heald",0
cred6:	.db	"Eddie Gallagher",0
cred66:     .db   "Micheal Meaders",0
cred7:	.db	"Jimmy Mardell",0
cred8:	.db	"Bill Nagel",0
cred9:	.db	"Hideaki Omuro",0
cred10:	.db	"Jeff Mears",0
cred11:	.db	"Hannes Edfeldt",0
cred12:	.db	"Joe Wingbermuehle",0
cred13: .db	"Mark May",0
cred14:	.db	"The TI-Files",0
cred15:	.db	"The #TI-Files Crew",0
cred16:	.db	"Texas Instruments",0
cred17:	.db	"ZiLog",0
cred18:	.db	"Capcom",0
test1:	.db	"Matt Skrabanek",0
test2:	.db	"Matt Waters",0
test3:	.db	"Alex Sedeno",0
test4:	.db	"Andrew Ungvarsky",0
test5:	.db	"Dan Englender",0
test6:	.db	"Chad Whitman",0
test7:	.db	"Ian Kaplan",0
test8:	.db	"Ahmed El-Helw",0
test9:	.db	"Anthony Chan",0
test10:	.db	"Eric Chan",0
test11:	.db	"Matt Tandy",0
test12:	.db	"Dan Koester",0
test13:	.db	"Danny Welsh",0
test14:	.db	"Joe Farley",0
test15:	.db	"Chris Musolf",0
test16:	.db	"Stuart Bergstrom",0
test17:	.db	"Matt Senator",0
test18:	.db	"Fred Coughlin",0
test19:	.db	"Steven Gerstacker",0
            .db	"Luke Rosenburg     ",0
test20:	.db	"Luke Rosenburg",0
pres:	.db	"Presented by:",0

djs:	.db	"D. JacKaL Software",0
      .db 0
pre:	.db	"Presents...",0

logo:
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$07,$8F,$DF,$DF,$F7,$F0,$00,$00,$00
.DB $00,$00,$00,$0F,$9F,$FF,$FF,$F7,$F8,$00,$00,$00
.DB $00,$00,$00,$1F,$BF,$FE,$3E,$07,$FC,$00,$00,$00
.DB $00,$00,$00,$20,$40,$43,$E2,$F4,$22,$00,$00,$00
.DB $00,$00,$00,$40,$08,$40,$62,$94,$01,$00,$00,$00
.DB $00,$00,$00,$84,$18,$C7,$E3,$8C,$00,$80,$00,$00
.DB $00,$00,$01,$0C,$30,$87,$E3,$CC,$00,$40,$00,$00
.DB $00,$00,$02,$1C,$F0,$80,$60,$0C,$3E,$20,$00,$00
.DB $00,$00,$04,$3B,$E0,$80,$60,$04,$3F,$10,$00,$00
.DB $00,$00,$08,$73,$E1,$80,$50,$04,$1F,$88,$00,$00
.DB $00,$00,$1F,$E3,$BF,$FF,$FF,$FF,$FF,$FC,$00,$00
.DB $00,$00,$20,$43,$80,$FC,$07,$E0,$FF,$C2,$00,$00
.DB $00,$00,$7F,$C3,$FF,$FF,$FF,$FF,$FF,$FF,$80,$00
.DB $00,$00,$80,$4C,$01,$08,$04,$20,$0C,$70,$40,$00
.DB $00,$01,$00,$58,$01,$10,$02,$20,$03,$38,$20,$00
.DB $00,$02,$00,$60,$01,$10,$C1,$20,$00,$DC,$10,$00
.DB $00,$04,$00,$40,$01,$20,$C1,$10,$00,$3E,$08,$00
.DB $00,$08,$08,$01,$01,$40,$00,$90,$00,$0F,$04,$00
.DB $00,$10,$18,$03,$02,$C1,$E0,$50,$20,$03,$82,$00
.DB $00,$3F,$FF,$FF,$FE,$FF,$FF,$DF,$FF,$FF,$FF,$00
.DB $00,$7F,$FF,$FF,$FF,$FF,$FF,$EF,$FF,$FF,$FF,$80
.DB $00,$FF,$F7,$FD,$FF,$FF,$FF,$EF,$FF,$FF,$FF,$C0
.DB $01,$01,$E4,$F2,$02,$07,$FC,$18,$07,$F0,$00,$20
.DB $02,$03,$C5,$E2,$06,$0F,$FC,$08,$09,$FC,$00,$10
.DB $04,$07,$87,$C2,$04,$0F,$FE,$08,$08,$7F,$00,$08
.DB $08,$0F,$07,$83,$FF,$FF,$FF,$FF,$F8,$1F,$FF,$F8
.DB $1F,$FE,$06,$07,$FF,$FC,$07,$FF,$FC,$0F,$FF,$F8
.DB $07,$FC,$00,$07,$FF,$F8,$03,$FF,$FC,$03,$FF,$F8
.DB $0F,$F8,$00,$07,$FF,$F0,$03,$FF,$FE,$00,$FF,$F8
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$0E,%01111100,$00,$81,$84,$40,$00,$00,$00
.DB $00,$00,$00,$11,%01000000,$00,$82,$46,$C0,$00,$00,$00
.DB $00,$00,$00,$11,%01000000,$00,$82,$05,$40,$00,$00,$00
.DB $00,$00,$00,$0E,%01111000,$01,$41,$05,$40,$00,$00,$00
.DB $00,$00,$00,$11,%00000101,%11111001,$40,$84,$40,$00,$00,$00
.DB $00,$00,$00,$11,%00000100,$01,$C0,$44,$40,$00,$00,$00
.DB $00,$00,$00,$11,%00000100,$02,$22,$44,$40,$00,$00,$00
.DB $00,$00,$00,$0E,%01111000,$02,$21,$84,$40,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$80,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$0E,$0F,$83,$03,$83,$E0,$00,$00,$00
.DB $00,$00,$00,$10,$02,$04,$82,$40,$80,$00,$00,$00
.DB $00,$00,$00,$10,$02,$04,$82,$40,$80,$00,$00,$00
.DB $00,$00,$00,$0C,$02,$07,$83,$80,$80,$00,$00,$00
.DB $00,$00,$00,$02,$02,$04,$82,$40,$80,$00,$00,$00
.DB $00,$00,$00,$02,$02,$04,$82,$40,$80,$00,$00,$00
.DB $00,$00,$00,$1C,$02,$04,$82,$40,$80,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$1C,$63,$9D,$13,$39,$C0,$00,$00,$00
.DB $00,$00,$00,$12,$94,$21,$14,$A5,$20,$00,$00,$00
.DB $00,$00,$00,$12,$94,$21,$14,$A5,$20,$00,$00,$00
.DB $00,$00,$00,$1C,$F3,$19,$54,$B9,$20,$00,$00,$00
.DB $00,$00,$00,$10,$90,$85,$54,$A5,$20,$00,$00,$00
.DB $00,$00,$00,$10,$90,$85,$54,$A5,$20,$00,$00,$00
.DB $00,$00,$00,$10,$97,$38,$A3,$25,$C0,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

cbs:
.DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$00,$00,$03
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$3F,$FC,$03
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$40,$02,$03
.DB $C0,$00,$00,$00,$80,$1F,$F8,$01,$00,$98,$19,$03
.DB $C0,$01,$80,$00,$80,$10,$48,$01,$01,$24,$24,$83
.DB $C0,$02,$40,$00,$80,$20,$44,$01,$01,$42,$5A,$83
.DB $C0,$02,$40,$00,$80,$28,$94,$01,$01,$42,$5A,$83
.DB $C0,$01,$80,$00,$80,$24,$A4,$01,$01,$5A,$42,$83
.DB $C0,$1F,$F8,$00,$80,$2C,$B4,$01,$01,$5A,$42,$83
.DB $C0,$21,$84,$00,$80,$4D,$32,$01,$01,$24,$24,$83
.DB $C0,$1E,$78,$00,$80,$41,$02,$01,$01,$19,$98,$83
.DB $C0,$02,$40,$00,$80,$41,$02,$01,$01,$01,$80,$83
.DB $C0,$42,$42,$00,$80,$42,$02,$01,$01,$41,$82,$83
.DB $C0,$42,$42,$00,$80,$82,$01,$01,$01,$20,$04,$83
.DB $C0,$42,$42,$00,$80,$82,$01,$01,$01,$1F,$F8,$83
.DB $C0,$A4,$25,$00,$80,$82,$01,$01,$01,$15,$00,$83
.DB $C0,$A4,$25,$00,$80,$82,$01,$01,$00,$91,$01,$03
.DB $C0,$A4,$25,$00,$81,$01,$00,$81,$00,$4E,$02,$03
.DB $C0,$A8,$15,$00,$81,$00,$80,$81,$00,$3F,$FC,$03
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$00,$00,$03
.DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$00,$00,$03
.DB $C0,$00,$00,$00,$80,$FF,$FF,$01,$00,$FF,$FF,$03
.DB $C0,$00,$00,$00,$80,$80,$01,$01,$00,$AA,$55,$03
.DB $C0,$3F,$FC,$00,$80,$86,$61,$01,$00,$AA,$55,$03
.DB $C0,$20,$04,$00,$80,$9C,$39,$01,$00,$FF,$FF,$03
.DB $C0,$2E,$E4,$00,$80,$E4,$27,$01,$00,$BF,$FD,$03
.DB $C0,$2A,$A4,$00,$80,$88,$11,$01,$00,$BE,$7D,$03
.DB $C0,$EA,$A7,$00,$BF,$FC,$3F,$FD,$00,$BE,$7D,$03
.DB $C1,$2E,$E4,$80,$A0,$16,$68,$05,$00,$9C,$39,$03
.DB $C1,$2A,$A4,$80,$A3,$F6,$6F,$C5,$00,$80,$81,$03
.DB $C1,$6A,$A6,$80,$AC,$10,$08,$35,$00,$80,$81,$03
.DB $C1,$6E,$E6,$80,$B0,$20,$04,$0D,$00,$81,$81,$03
.DB $C1,$60,$06,$80,$80,$3F,$FC,$01,$00,$80,$01,$03
.DB $C1,$60,$66,$80,$80,$08,$10,$01,$00,$80,$71,$03
.DB $C1,$60,$66,$80,$86,$10,$08,$61,$00,$5F,$8A,$03
.DB $C0,$A0,$05,$00,$85,$90,$09,$A1,$00,$40,$72,$03
.DB $C0,$2E,$E4,$00,$84,$60,$06,$21,$00,$20,$04,$03
.DB $C0,$2A,$A4,$00,$84,$00,$00,$21,$00,$3F,$FC,$03
.DB $C0,$2A,$A4,$00,$87,$FF,$FF,$E1,$00,$00,$00,$03
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$00,$00,$03
.DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$00,$00,$03
.DB $C0,$24,$24,$00,$80,$00,$00,$01,$00,$00,$30,$03
.DB $C0,$92,$49,$00,$80,$0C,$30,$01,$00,$00,$D0,$03
.DB $C1,$52,$4A,$80,$80,$0C,$30,$01,$00,$03,$08,$03
.DB $C0,$7E,$7E,$00,$80,$3F,$FE,$01,$00,$04,$64,$03
.DB $C0,$C3,$C3,$00,$80,$7F,$FE,$01,$00,$05,$84,$03
.DB $C1,$4B,$D2,$80,$80,$6C,$30,$01,$00,$0C,$04,$03
.DB $C1,$4A,$52,$80,$80,$6C,$30,$01,$00,$12,$02,$03
.DB $C1,$42,$42,$80,$80,$6C,$30,$01,$00,$22,$02,$03
.DB $C1,$7E,$7E,$80,$80,$6C,$30,$01,$00,$42,$01,$03
.DB $C1,$20,$04,$80,$80,$6C,$30,$01,$00,$C1,$03,$03
.DB $C1,$0A,$50,$80,$80,$7F,$FC,$01,$00,$B9,$0D,$03
.DB $C1,$41,$82,$80,$80,$3F,$FE,$01,$00,$86,$B1,$03
.DB $C1,$88,$11,$80,$80,$0C,$37,$01,$00,$A1,$C1,$03
.DB $C0,$A7,$E5,$00,$80,$0C,$37,$01,$00,$B2,$89,$03
.DB $C0,$C2,$43,$00,$80,$0C,$37,$01,$00,$96,$95,$03
.DB $C0,$63,$C6,$00,$80,$0C,$37,$01,$00,$84,$95,$03
.DB $C0,$30,$0C,$00,$80,$0C,$37,$01,$00,$A0,$95,$03
.DB $C0,$1F,$F8,$00,$80,$7F,$FC,$01,$00,$9E,$95,$03
.DB $C0,$00,$00,$00,$80,$00,$00,$01,$00,$00,$00,$03
.DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

uprlft:
.db %11111111
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %10000000

uprrt:
.db %11111111
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001

lwrlft:
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %10000000
.db %11111111

lwrrt:
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %11111111

bint:
.db %00000000
.db %00000000
.db %11111111
.db %01010101
.db %10101010
.db %11111111
.db %00000000
.db %00000000

pwcurs:
.db %10000001
.db %01011010
.db %00100100
.db %01000010
.db %01000010
.db %00100100
.db %01011010
.db %10000001

pwdot:
.db %00000000
.db %00000000
.db %00011000
.db %00111100
.db %00111100
.db %00011000
.db %00000000
.db %00000000

lvlspr:
; 0=blank
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

; 2=ceiling

.db %11111111
.db %10101011
.db %11010101
.db %10101011
.db %11010101
.db %10101011
.db %11010101
.db %11111111


; 4=block

.db %11111111
.db %10000001
.db %10111101
.db %10100101
.db %10100101
.db %10111101
.db %10000001
.db %11111111

; 6=floor

.db %11111111
.db %10100101
.db %11111111
.db %10100101
.db %10100101
.db %11111111
.db %10100101
.db %11111111

; 8=door

.db %11111111
.db %00000000
.db %11111111
.db %00000000
.db %11111111
.db %00000000
.db %11111111
.db %00000000

; 10=extra life
head:

.db %00111100
.db %01000010
.db %11111111
.db %10100101
.db %10000001
.db %01011010
.db %00100100
.db %00011000


; 12=energy tank
tank:

.db %01111110
.db %10000001
.db %10111101
.db %10100001
.db %10111001
.db %10100001
.db %10111101
.db %01111110

; 14=T enemy
tleft:
.db %11111111
.db %10011101
.db %10101001
.db %11101111
.db %01000100
.db %10110100
.db %10000010
.db %11111110

tright:
.db %11111111
.db %10111001
.db %10010101
.db %11110111
.db %00100010
.db %00101101
.db %01000001
.db %01111111

; 18=I enemy
iup:
.db %11111111
.db %10011101
.db %10101001
.db %11100111
.db %00110100
.db %01100110
.db %01000010
.db %01111110

idown:
.db %01111110
.db %01000010
.db %01100110
.db %00110100
.db %11100111
.db %10101001
.db %10011101
.db %11111111

wpp:
.db %00000000
.db %00011000
.db %00011000
.db %00000000

wpan:
.db %00111100
.db %00011000
.db %01011010
.db %00111100

wpma:
.db %01111110
.db %01001110
.db %01000010
.db %01111110

wpmd:
.db %10010110
.db %10111001
.db %00111010
.db %10010010

wpdo:
.db %00000000
.db %01111111
.db %01111111
.db %00000000

wpse:
.db %01100110
.db %10011001
.db %00100010
.db %00100010

wppo:
.db %01011010
.db %01100110
.db %00100100
.db %00011000

wpfr:
.db %10101010
.db %01010101
.db %10101010
.db %01010101

wpsa:
.db %00111100
.db %11111111
.db %11111111
.db %00111100

wpmi:
.db %00111100
.db %01011010
.db %01000010
.db %00111100

mmsr:
.db %00011000
.db %00100100
.db %01011110
.db %01101010
.db %00100100
.db %00011000
.db %01100110
.db %11100111
.db %11011011
.db %00111100
.db %01011010
.db %11100111

mmrr:
.db %00011000
.db %00100100
.db %01011110
.db %01101010
.db %00100100
.db %00011000
.db %11100110
.db %11100110
.db %00011000
.db %11111100
.db %11101010
.db %00001110

mmrr2:
.db %00011000
.db %00100100
.db %01011110
.db %01101010
.db %00100100
.db %00011000
.db %01100100
.db %01110100
.db %00111000
.db %00111100
.db %01010100
.db %01101100

mmjr:
.db %00011000
.db %00100100
.db %01011110
.db %01101010
.db %00100100
.db %11011011
.db %11100111
.db %01100110
.db %00111100
.db %00111010
.db %01011111
.db %01100000

mmwr:
.db %00011000
.db %00100100
.db %01011110
.db %01101010
.db %00100100
.db %00011000
.db %01100111
.db %11100111
.db %11011000
.db %00111100
.db %01010100
.db %11101110

mmhr:
.db %00110001
.db %01011000
.db %10111101
.db %11100100
.db %01001001
.db %00110000
.db %11001100
.db %11100010
.db %00010010
.db %01101100
.db %10010100
.db %11101100

mmsl:
.db %00011000
.db %00100100
.db %01111010
.db %01010110
.db %00100100
.db %00011000
.db %01100110
.db %11100111
.db %11011011
.db %00111100
.db %01011010
.db %11100111

mmrl:
.db %00011000
.db %00100100
.db %01111010
.db %01010110
.db %00100100
.db %00011000
.db %01100111
.db %01100111
.db %00011000
.db %00111111
.db %01010111
.db %01110000

mmrl2:
.db %00011000
.db %00100100
.db %01111010
.db %01010110
.db %00100100
.db %00011000
.db %00100110
.db %00101110
.db %00011100
.db %00111100
.db %00101010
.db %00110110

mmjl:
.db %00011000
.db %00100100
.db %01111010
.db %01010110
.db %00100100
.db %11011011
.db %11100111
.db %01100110
.db %00111100
.db %01011100
.db %11111010
.db %00000110

mmwl:
.db %00011000
.db %00100100
.db %01111010
.db %01010110
.db %00100100
.db %00011000
.db %11100110
.db %11100111
.db %00011011
.db %00111100
.db %00101010
.db %01110111

mmhl:
.db %10001100
.db %00011010
.db %10111101
.db %00100111
.db %10010010
.db %00001100
.db %00110011
.db %01000111
.db %01001000
.db %00110110
.db %00101001
.db %00110111

ansl:
.db %00011000
.db %00100100
.db %00100100
.db %00011000
.db %01111110
.db %00011000
.db %10011001
.db %01011010
.db %00111100
.db %00111100
.db %01100110
.db %11100111

masl:
.db %01111110
.db %01000110
.db %01001010
.db %01010010
.db %11010011
.db %11010011
.db %11001011
.db %01000110
.db %01111110
.db %00111100
.db %01100110
.db %11100111

mdsl
.db %00011110
.db %00011110
.db %00101110
.db %01010010
.db %00100100
.db %10011000
.db %11111110
.db %01111111
.db %00011001
.db %00111100
.db %01100110
.db %11100111

dosl:
.db %01111110
.db %01000010
.db %01000010
.db %01000010
.db %11110011
.db %11110011
.db %11000011
.db %01000010
.db %01111110
.db %00111100
.db %01100110
.db %11100111

tisl:
.db %11111111
.db %10100101
.db %11100111
.db %00100100
.db %00100100
.db %01000010
.db %01111110
.db %11000011
.db %11100111
.db %11011011
.db %01100110
.db %11100111

posl:
.db %01111110
.db %01100110
.db %01010010
.db %01000010
.db %00100100
.db %00011000
.db %10111110
.db %11111111
.db %10011001
.db %10111100
.db %01100110
.db %11100111

frsl:
.db %10100101
.db %11111111
.db %10100101
.db %11100111
.db %01011010
.db %01000010
.db %00111100
.db %11111111
.db %11011011
.db %00111100
.db %01100110
.db %11100111

sasl:
.db %00011000
.db %00100100
.db %00100100
.db %00011000
.db %00111110
.db %11011000
.db %11111111
.db %00011011
.db %01111100
.db %00111100
.db %01100110
.db %11100111

misl:
.db %00011100
.db %00100010
.db %01111111
.db %01000101
.db %11101101
.db %11000111
.db %11111111
.db %01000111
.db %01000101
.db %01111111
.db %01100110
.db %11100111

lvlan:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,7,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,7,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,6,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,3,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,3,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,9,0,3
 .db 1,0,0,3,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,9
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,3,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,3,0,0
 .db 1,0,0,0,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlma:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,0,9
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,0,0,9
 .db 1,0,0,0,0,2,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,2,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,7,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,0,3
 .db 1,0,0,0,3,0,6,3
 .db 1,0,0,0,3,0,0,0
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,7,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,2,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,2,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlshit:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,9,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,9,0,0,0
 .db 0,0,2,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,9,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,9,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,3
 .db 1,0,5,1,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3




lvldo:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,0,9,0,0
 .db 1,0,0,3,3,0,0,3
 .db 1,0,0,3,3,0,0,3
 .db 1,0,0,3,3,0,0,3
 .db 1,0,5,3,3,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,7,0,1
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,1,0
 .db 0,0,0,0,0,1,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,1,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,1,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,1,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,1,0,0
 .db 0,0,0,0,0,0,9,0
 .db 0,0,0,0,1,0,0,0
 .db 0,0,0,1,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,7,0,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlmd:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,9,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,9,0,0,0
 .db 0,0,2,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,9,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,2,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,9,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,3
 .db 1,0,5,1,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlti:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,9,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,2,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,7,2,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,9,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,7,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,2,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,6,2,0,0,0,0,3
 .db 0,0,0,2,0,0,0,3
 .db 0,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlpo:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,3,3,0,0,0,3
 .db 1,0,3,3,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,3,3,0,0,0,3
 .db 1,0,3,3,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,0,9,0
 .db 1,0,0,0,0,2,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,1,0,0,0,3,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,0,0,0,0,3
 .db 1,1,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,7,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,7,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,0,9
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,0,0,0,0,0,0
 .db 1,0,0,0,5,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,1,0,0,0,3,3,3
 .db 1,1,1,0,0,0,3,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlfr:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,2,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,7,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,2
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,2,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,2,0,0,0
 .db 1,0,0,0,2,0,0,0
 .db 1,0,0,0,0,0,9,3
 .db 1,0,0,3,0,0,0,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,0,3,3
 .db 1,0,0,3,0,6,3,3
 .db 1,0,0,3,0,0,0,3
 .db 1,0,0,3,0,0,0,0
 .db 1,0,0,3,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,7,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,2,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,2,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,9,0
 .db 1,0,0,0,2,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,2,0,0,0,0
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,1,0,0,0,0,0,3
 .db 1,1,1,0,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlsa:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,0,9,3
 .db 1,0,0,0,0,0,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,0,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,7,0,0,3,3,3
 .db 1,1,1,0,0,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,7,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,0,0,0,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,9,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,2,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,2,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,2,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0
 .db 1,0,5,1,0,0,0,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlmi:
 .db 1,2,2,2,2,2,2,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,1,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,7,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,0,0,0,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,7,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,1,0,0,3,3
 .db 1,1,1,0,0,0,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,1,0,7,3,3,3
 .db 1,1,1,0,0,3,3,3
 .db 1,1,0,0,0,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,1,0,0,3,3,3,3
 .db 1,0,0,0,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,7,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,3,3,3,3,3
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,0,0
 .db 1,0,0,0,0,0,5,3
 .db 2,1,1,1,0,0,0,3
 .db 2,2,2,1,0,0,0,3
 .db 2,1,1,1,4,4,4,3

lvlb1:
 .db 1,1,1,1,4,4,4,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,0,0,0,3
 .db 1,1,1,1,4,4,4,3

lvlb2:
 .db 1,1,1,1,4,4,4,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,0,0,0,0,0,0,3
 .db 1,1,1,1,1,1,1,3

BUFCOPY:
_GRBUFCPY_V:
bufcpy:
R_829:  call LogoPut
 ld hl,$8641
 ld de,$fc00
 ld a,64
copy_loop:
 ld bc,12
 ldir
 push af
 ld a,(de)
 or %10000000
 ld (de),a
 pop af
 inc de
 inc de 
 inc de
 inc de
 dec a
 jr nz,copy_loop
 ret

BUFCOPY2:
 ld hl,$8641
 ld de,$fc02
 ld a,64
copy_loop2:
 ld bc,12
 ldir
 push af
 xor a
 inc de
 ld (de),a
 inc de
 ld (de),a 
 inc de
 ld (de),a
 inc de
 ld (de),a
 pop af
 dec a
 jr nz,copy_loop2
 ret


LogoPut:
R_830:  ld hl,Logo
 ld de,$fc00+(16*5)+12
 ld a,55
lop3:
 ld bc,4
 ldir
 inc de
 inc de 
 inc de
 inc de
 inc de
 inc de 
 inc de
 inc de
 inc de
 inc de 
 inc de
 inc de
 dec a
 jr nz,lop3
 ret
pixelsetting = TEXT_MEM2

Logo:
    .db     0,14,0,0
    .db     0,19,128,0
    .db     0,39,192,0
    .db     0,127,224,0
    .db     0,207,224,0
    .db     0,255,208,0
    .db     0,176,208,0
    .db     0,172,80,0
    .db     0,172,96,0
    .db     0,128,112,0
    .db     1,222,204,0
    .db     3,32,134,0
    .db     3,159,15,0
    .db     7,160,47,0
    .db     7,224,63,0
    .db     7,224,63,0
    .db     7,255,255,0
    .db     3,191,238,0
    .db     0,71,144,0
    .db     0,194,%00011000,0
    .db     1,245,124,0
    .db     3,248,255,0
    .db     7,248,255,128
    .db     7,248,255,128
    .db     0,0,0,0
    .db     0,0,0,0
    .db     6,103,119,192
    .db     9,152,136,32
    .db     9,151,184,32
    .db     16,23,188,144
    .db     32,16,172,208
    .db     62,255,247,240,
    .db     72,39,150,8
    .db     88,103,146,72
    .db     58,71,146,100
    .db     186,64,131,116
    .db     62,64,129,112
    .db     255,255,255,252
    .db     255,255,255,252
    .db     251,140,103,152
    .db     51,140,99,136
    .db     51,8,33,136
    .db     35,8,32,136
    .db     35,8,48,136
    .db     83,9,48,68
    .db     80,9,19,%01100100 ;96
    .db     119,119,255,172
    .db     144,9,17,%10010010 ;144
    .db     177,8,17,%10000010    ;128
    .db     51,16,24,%11000010    ;128
    .db     55,16,8,%11100001     ;224
    .db     111,19,136,%01110001  ;112
    .db     108,19,136,%01110001  ;112
    .db     224,252,127,%00011111 ;28
    .db     224,252,127,%00011111 ;140


.end
