;=================================================
; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999
;-------------------------------------------------
; MazeDraw.asm: part of Maze-3D source code
; Maze-3D Raycasting Engine version 0.5 beta
; Written by Clem Vasseur <darkclem@wanadoo.fr>
; Icarus Productions <http://icarus.ticalc.org>
;=================================================

; A = slice height (even: bit 0 = 0)

DrawSlice:
 cp 2
 ret c
 cp MAX_SCALE+1
 ret nc

 ld e,0
ScrnCol = $-1
 ld b,SCREEN_HEIGHT
 cp b
 jr nc,SupScrn

 ld b,a
 add a,a
 add a,a
 ld l,a
 ld h,0

 ld a,(GrayScrn)
 add a,2
 ld d,a

 add hl,hl
 ex de,hl
 sbc hl,de
 jr RenderSlice

SupScrn:
 ld a,(GrayScrn)
 ld h,a
 ld l,e

RenderSlice:
 ld de,16

 ld a,0
ColorFlag = $-1
 or a
 jr nz,RenderLoop2

RenderLoop:		;58
 ld a,0
ColMask = $-1
 or (hl)
 ld (hl),a

 set 2,h
 ld a,0
ColMask2 = $-1
 or (hl)
 ld (hl),a
 res 2,h

 add hl,de
 djnz RenderLoop

#if 0
RenderLoop:		;46
 set 0,(hl)
 set 2,h
 set 0,(hl)
 res 2,h

 add hl,de
 djnz RenderLoop
#endif

 ret

RenderLoop2:
 ld a,(ColMask)
 cpl
 and (hl)
 ld (hl),a

 set 2,h
 ld a,(ColMask2)
 or (hl)
 ld (hl),a
 res 2,h

 add hl,de
 djnz RenderLoop2
 ret

.end
