;=================================================
; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999
;-------------------------------------------------
; Trigo.asm: part of Maze-3D source code
; Maze-3D Raycasting Engine version 0.5 beta
; Written by Clem Vasseur <darkclem@wanadoo.fr>
; Icarus Productions <http://icarus.ticalc.org>
;=================================================

Cos64:				; DE = 64 * COS(A)
 add a,64
Sin64:				; DE = 64 * SIN(A)
 ld d,0
 ld e,a
 ld hl,Sin64Table
 add hl,de
 ld e,(hl)
 bit 7,e
 ret z
 ld d,-1
 ret

#if 0
Sin:				; A = 128 * SIN(A)
 and %01111111
 ld d,0
 ld e,a
 ld hl,Sin128Table
 add hl,de
 ld a,(hl)
 ret
#endif

CosInv:				; DE = 256 / COS(A)
 add a,64
SinInv:				; DE = 256 / SIN(A)
 ld d,0
 ld e,a
 sla e
 ld hl,SinInv256Table
 add hl,de
 ld e,(hl)
 inc hl
 ld d,(hl)
 ret

TanInv:				; DE = 256 / TAN(A)
 add a,64
Tan:				; DE = 256 * TAN(A)
 ld d,0
 ld e,a
 sla e
 ld hl,Tan256Table
 add hl,de
 ld e,(hl)
 inc hl
 ld d,(hl)
 ret

#include "Trigo.inc"

.end
