// Maze3D -- Z80 RAYCASTING ENGINE
// GBTD to M3D texture converter
// Copyright(C)1999 Clem Vasseur
// Email:darkclem@wanadoo.fr

#include <stdio.h>

int main(void)
{
	FILE *in, *out;
	unsigned char *buf;
	long size, i;

	printf("\n +---------------------------------+");
	printf("\n | Maze3D -- Z80 RAYCASTING ENGINE |");
	printf("\n |  GBTD to M3D texture converter  |");
	printf("\n |  Copyright(C)1999 Clem Vasseur  |");
	printf("\n |    Email:darkclem@wanadoo.fr    |");
	printf("\n +---------------------------------+\n\n");

	if ((in = fopen("Textures.bin", "rb")) == NULL)
	{
		fprintf(stderr, "Error opening input file: Textures.bin\n");
		return 1;
	}

	fseek(in, 0L, SEEK_END);
	size = ftell(in);
	rewind(in);
	buf = (char *)malloc(size);
	fread(buf, 1, size, in);
	fclose(in);

	if ((out = fopen("MazeTEX.asm", "w")) == NULL)
	{
		fprintf(stderr, "Error opening output file: MazeTEX.asm\n");
		return 2;
	}

	fprintf(out, ";=================================================\n");
	fprintf(out, "; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999\n");
	fprintf(out, ";-------------------------------------------------\n");
	fprintf(out, "; MazeTEX.asm: part of Maze-3D source code\n");
	fprintf(out, "; Maze-3D Raycasting Engine version 0.5 beta\n");
	fprintf(out, "; Written by Clem Vasseur <darkclem@wanadoo.fr>\n");
	fprintf(out, "; Icarus Productions <http://icarus.ticalc.org>\n");
	fprintf(out, ";=================================================\n");

	fprintf(out, "\n	.plugin string86\n");
	fprintf(out, "\n	.db \"3D\"		;Maze3D file indicator\n");

	for(i = 0; i < size; i+=64)
	{
		fprintf(out, "\n\n; TEX %d", 1 + (i / 64));

		fprintf(out, "\n .db $%02X", buf[i]);
		fprintf(out, ",$%02X", buf[i+32]);

		fprintf(out, ",$%02X", buf[i+2]);
		fprintf(out, ",$%02X", buf[i+34]);

		fprintf(out, ",$%02X", buf[i+4]);
		fprintf(out, ",$%02X", buf[i+36]);

		fprintf(out, ",$%02X", buf[i+6]);
		fprintf(out, ",$%02X", buf[i+38]);

		fprintf(out, ",$%02X", buf[i+8]);
		fprintf(out, ",$%02X", buf[i+40]);

		fprintf(out, ",$%02X", buf[i+10]);
		fprintf(out, ",$%02X", buf[i+42]);

		fprintf(out, ",$%02X", buf[i+12]);
		fprintf(out, ",$%02X", buf[i+44]);

		fprintf(out, ",$%02X", buf[i+14]);
		fprintf(out, ",$%02X", buf[i+46]);

		fprintf(out, "\n .db $%02X", buf[i+16]);
		fprintf(out, ",$%02X", buf[i+32+16]);

		fprintf(out, ",$%02X", buf[i+2+16]);
		fprintf(out, ",$%02X", buf[i+34+16]);

		fprintf(out, ",$%02X", buf[i+4+16]);
		fprintf(out, ",$%02X", buf[i+36+16]);

		fprintf(out, ",$%02X", buf[i+6+16]);
		fprintf(out, ",$%02X", buf[i+38+16]);

		fprintf(out, ",$%02X", buf[i+8+16]);
		fprintf(out, ",$%02X", buf[i+40+16]);

		fprintf(out, ",$%02X", buf[i+10+16]);
		fprintf(out, ",$%02X", buf[i+42+16]);

		fprintf(out, ",$%02X", buf[i+12+16]);
		fprintf(out, ",$%02X", buf[i+44+16]);

		fprintf(out, ",$%02X", buf[i+14+16]);
		fprintf(out, ",$%02X", buf[i+46+16]);

		fprintf(out, "\n .db $%02X", buf[i+1]);
		fprintf(out, ",$%02X", buf[i+32+1]);

		fprintf(out, ",$%02X", buf[i+2+1]);
		fprintf(out, ",$%02X", buf[i+34+1]);

		fprintf(out, ",$%02X", buf[i+4+1]);
		fprintf(out, ",$%02X", buf[i+36+1]);

		fprintf(out, ",$%02X", buf[i+6+1]);
		fprintf(out, ",$%02X", buf[i+38+1]);

		fprintf(out, ",$%02X", buf[i+8+1]);
		fprintf(out, ",$%02X", buf[i+40+1]);

		fprintf(out, ",$%02X", buf[i+10+1]);
		fprintf(out, ",$%02X", buf[i+42+1]);

		fprintf(out, ",$%02X", buf[i+12+1]);
		fprintf(out, ",$%02X", buf[i+44+1]);

		fprintf(out, ",$%02X", buf[i+14+1]);
		fprintf(out, ",$%02X", buf[i+46+1]);

		fprintf(out, "\n .db $%02X", buf[i+16+1]);
		fprintf(out, ",$%02X", buf[i+32+16+1]);

		fprintf(out, ",$%02X", buf[i+2+16+1]);
		fprintf(out, ",$%02X", buf[i+34+16+1]);

		fprintf(out, ",$%02X", buf[i+4+16+1]);
		fprintf(out, ",$%02X", buf[i+36+16+1]);

		fprintf(out, ",$%02X", buf[i+6+16+1]);
		fprintf(out, ",$%02X", buf[i+38+16+1]);

		fprintf(out, ",$%02X", buf[i+8+16+1]);
		fprintf(out, ",$%02X", buf[i+40+16+1]);

		fprintf(out, ",$%02X", buf[i+10+16+1]);
		fprintf(out, ",$%02X", buf[i+42+16+1]);

		fprintf(out, ",$%02X", buf[i+12+16+1]);
		fprintf(out, ",$%02X", buf[i+44+16+1]);

		fprintf(out, ",$%02X", buf[i+14+16+1]);
		fprintf(out, ",$%02X", buf[i+46+16+1]);

	}
	fprintf(out, "\n\n.end\n");
	fclose(out);
	free(buf);

	printf(" GBTD binary file Textures.bin\n");
	printf(" converted to ASM file MazeTEX.asm\n");
	return 0;
}
