;=================================================
; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999
;-------------------------------------------------
; Maze3D.asm: part of Maze-3D source code
; Maze-3D Raycasting Engine version 0.5 beta
; Written by Clem Vasseur <darkclem@wanadoo.fr>
; Icarus Productions <http://icarus.ticalc.org>
;=================================================

#include "Ti86.inc"
#include "Maze3D.inc"

#DEFINE TITLE_PIC

.org _asm_exec_ram

 nop
 jp ProgStart
 .dw 0,TextScrn+1

ProgStart:
 call _flushAllMenus
 call _runIndicOff
 call FadeOut

 ld hl,MazeLIB
 ld de,MazeExecRam
 call Decompress

#ifdef TITLE_PIC
 call OpenGray

 ld hl,MazePic
 ld de,GrayScrn1
 call Decompress
 call FadeIn

 ld b,200
Delay:
 halt
 djnz Delay

 call FadeOut
 call CloseGray
#endif
 call _clrWindow

 xor a
 ld hl,TextScrn
 set 1,(iy+5)
 set 3,(iy+5)
 call vputs_center
 res 3,(iy+5)
 call vputs_center
 ld a,42
 set 3,(iy+5)
 call vputs_center
 res 3,(iy+5)
 call vputs_center
 call vputs_center
 res 1,(iy+5)

 ld de,$0403
 ld (_curRow),de
 call _puts

 call FadeIn
 call _getcsc
Getkey:
 halt
 call _getcsc
 or a
 jr z,Getkey

 ld a,1
 ld hl,Level-$8000
 call _SET_ABS_DEST_ADDR

 ld hl,MazeLVL-1
 call DataLoad

 ld hl,MazeTEX-1
 call DataLoad

InitGame:
 xor a
 ld (Pov),a
 ld hl,$027F
 ld (ColWorld),hl
 ld (RowWorld),hl

StartGame:
 call OpenGray
 call MazeExecRam
 call CloseGray

ExitProg:
 res onInterrupt,(iy+onFlags)
 jp _clrWindow

DataLoad:
 push hl
 rst rmov10toop1
 rst rfindsym
 jr c,VarNotFound
 call _DATA_SIZE_TO_DE
 dec de
 dec de
 push de
 call _GET_DATA_SIZE_DE_INC
 call _SET_ABS_SRC_ADDR
 ld hl,$4433
 call _cphlde
 pop hl
 jr nz,VarInvalid
 xor a
 call _SET_MM_NUM_BYTES
 call _mm_lDIR
 pop hl
 jp _RAM_PAGE_1

VarNotFound:
 call _clrWindow
 pop hl
 inc hl
 call _putps
 ld hl,NotFound
ErrExit:
 call _puts
 pop hl
 jp _newline

VarInvalid:
 call _clrWindow
 pop hl
 inc hl
 call _putps
 ld hl,Invalid
 jr ErrExit

Decompress:
 ld a,(hl)
 bit 7,a
 jr z,Compressed
 inc hl
 and %01111111
 ld b,0
 ld c,a
 ldir
 jr Decompress
Compressed:
 push af
 or %11111100
 ld b,a
 inc hl
 ld c,(hl)
 inc hl
 pop af
 and %01111100
 rrca
 rrca
 or a
 ret z
 push hl
 ld h,d
 ld l,e
 add hl,bc
 inc a
 inc a
 ld b,0
 ld c,a
 ldir
 pop hl
 jr Decompress

vputs_center:
 push af
 push hl
 ld (_penRow),a
 ld d,0
get_size:
 ld a,(hl)
 or a
 jr z,got_size
 push hl
 push de
 call _copycharmaps
 pop af
 add a,(hl)
 ld d,a
 pop hl
 inc hl
 jr get_size
got_size:
 ld a,128
 sub d
 rra
 ld (_penCol),a
 pop hl
 call _vputs
 pop af
 add a,7
 ret

FadeIn:
 ld a,(_contrast)
 ld b,a
FadeInLoop:
 ld a,(_contrast)
 sub b
 out (2),a
 halt
 halt
 halt
 djnz FadeInLoop
 ld a,(_contrast)
 out (2),a
 ret

FadeOut:
 ld a,(_contrast)
 ld b,a
FadeOutLoop:
 ld a,b
 out (2),a
 halt
 halt
 halt
 djnz FadeOutLoop
 xor a
 out (2),a
 ret

#include "Gray.asm"

MazeTEX:
 .db 7,"MazeTEX"

MazeLVL:
 .db 7,"MazeLVL"

NotFound:
 .text " not found"

Invalid:
 .text " invalid"

TextScrn:
 .text " Maze3D 5 by Clem Vasseur"
 .text "<darkclem@wanadoo.fr>"

 .text " Special thanks"
 .text "Andreas Ess - Johannes Rajala"
 .text "Kirk Meyer - Matthew Shepcar"

 .text "PRESS ANY KEY"

#ifdef TITLE_PIC
MazePic:
 .incbin "Mazepic.bin"
#endif

MazeLIB:
 .incbin "MazeLIB.bin"

.end
