;-------------------------
;     Marin-The-Movie
; Ported By Craig Slusher
;-------------------------

#include "crash82.inc"

BOXX = TEXT_MEM
BOXY = TEXT_MEM+1
SOLX = TEXT_MEM+2
SOLY = TEXT_MEM+3
TRUY = TEXT_MEM+4
TRFX = TEXT_MEM+5
TRBX = TEXT_MEM+6
QUIT = TEXT_MEM+7
TIME = TEXT_MEM+8

.org START_ADDR
.db "Marin v1.2",0

start:
        xor a			;Load 0 into A, save a byte
        ld      (quit),a
beginning:
        ROM_CALL(CLEARLCD)
        ld      hl,pic
        ld      de,GRAPH_MEM
        ld      bc,768
        ldir
        ROM_CALL(DISP_GRAPH)
        ld      a,56
        ld      (CURSOR_Y),a
        ld      a,54
        ld      (CURSOR_X),a
        ld      hl,press
        ROM_CALL(D_ZM_STR)
	call enter

restart:
        ROM_CALL(CLEARLCD)
        call BUFCLR
        ld hl,0
        ld (CURSOR_POS),hl
        ld a,40
        ld (SOLX),a
        ld a,9
        ld (SOLY),a
        ld a,40
        ld (BOXX),a
        ld a,1
        ld (BOXY),a
        ld (TRBX),a
        ld a,55
        ld (TRUY),a
        ld a,9
        ld (TRFX),a
        jp moveloop

moveloop:
        ld a,(BOXX)
        cp 0
        jr z,x1
        cp 87
        jr z,x86
        ld a,(BOXY)
        cp 0
        jr z,y1
        cp 25
        jr z,y25
        jr mainstart
x1:
        ld      a,1
        ld      (BOXX),a
        ld      (SOLX),a
        jr      mainstart
x86:
        ld      a,86
        ld      (BOXX),a
        ld      (SOLX),a
        jr      mainstart
y1:
        ld      a,1
        ld      (BOXY),a
        ld      a,9
        ld      (SOLY),a
        jr      mainstart
y25:
        ld      a,24
        ld      (BOXY),a
        ld      a,31
        ld      (SOLY),a
        jr      mainstart
mainstart:
        call putbox
mainloop:
        call truck
        ld a,(TRBX)
        cp 96
        jp z,fixtruck
        inc a
        ld (TRBX),a
        ld a,(TRFX)
        inc a
        ld (TRFX),a
        call truck
        ROM_CALL(DISP_GRAPH)
	ld 	a,0ffh		;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0feh		;Load desired port
	out   (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp	251			;If key is right
        jr z,right 
        cp 	253			;If key is left
        jr z,left 
        cp 254   
        jr z,down 
        cp 247    
        jr z,up
        ld 	a,0ffh		;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0bfh		;Load desired port
	out   (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp 	223			;Is it 2nd
	jp 	z,droploop		;DropLoop if so
	cp	127			;Is it delete
	jp	z,Pause		;Pause
	jr mainloop 

left:
        call putbox
        ld a,(BOXX)
        dec a 
        ld (BOXX),a 
        ld (SOLX),a
        jp moveloop
right:
        call putbox
        ld a,(BOXX) 
        inc a 
        ld (BOXX),a
        ld (SOLX),a
        jp moveloop
up:
        call putbox
        ld a,(BOXY)
        dec a 
        ld (BOXY),a 
        ld a,(SOLY)
        dec a
        ld (SOLY),a
        jp moveloop
down:
        call putbox
        ld a,(BOXY) 
        inc a 
        ld (BOXY),a 
        ld a,(SOLY)
        inc a
        ld (SOLY),a
        jp moveloop
putbox:
        ld a,(BOXY)
        ld e,a 
        ld a,(BOXX) 
        ld bc,copter 
        call SPRXOR
        ld a,(SOLY)
        ld e,a
        ld a,(SOLX)
        ld bc,soldier
        call SPRXOR
        call truck
        ret
truck:
        ld a,(TRUY)
        ld e,a
        ld a,(TRBX)
        ld bc,truckback
        call SPRXOR
        ld a,(TRUY)
        ld e,a
        ld a,(TRFX)
        ld bc,truckfront
        call SPRXOR
        ret
soldier2:
        ld      a,(SOLY)
        ld      e,a
        ld      a,(SOLX)
        ld      bc,soldier
        call    SPRXOR
        ret
fixtruck:
        ld      a,9
        ld      (TRFX),a
        ld      a,1
        ld      (TRBX),a
        call truck
        jp mainloop
droploop:
        ld      a,(SOLY)
        cp      54
        jp      z,landfix
        cp      53
        jp      z,land
        call    soldier2
        call    truck
        ld      a,(SOLY)
        inc     a
        inc     a
        ld      (SOLY),a
        ld      a,(TRBX)
        inc     a
        ld      (TRBX),a
        ld      a,(TRFX)
        inc     a
        ld      (TRFX),a
        call    soldier2
        call    truck
        ROM_CALL(DISP_GRAPH)
        jp      droploop
landfix:
        call    soldier2
        ld      a,53
        ld      (SOLY),a
        call    soldier2
        ROM_CALL(DISP_GRAPH)
land:
        ld a,(SOLX)
        ld b,a
        ld a,(TRBX)
        cp b
        jp z,on      
        inc a
        cp b
        jp z,on
        inc a
        cp b
        jp z,on
        inc a
        cp b
        jp z,on
        jp gameover
on:
        ld      a,1
        ld      (CURSOR_X),a
        ld      a,30
        ld      (CURSOR_Y),a
        ld      hl,madeit
        ROM_CALL(D_ZM_STR)
        call	wait_key
	jp      restart
gameover:
        ld      a,1
        ld      (CURSOR_X),a
        ld      a,30
        ld      (CURSOR_Y),a
        ld      hl,over
        ROM_CALL(D_ZM_STR)
        call	wait_key
	jp      beginning
Pause:
      ;  ROM_CALL(CLEARLCD)
      ;  ld      a,0
      ;  ld      (CURSOR_X),a
      ;  ld      (CURSOR_Y),a
      ;  ld      hl,pausemess
      ;  ROM_CALL(D_ZT_STR)
wait:
        call    GET_KEY
        cp      G_DEL
        jp z,quit
        or 	    a
        jp nz,mainloop
        jr      z,wait

enter:
        call    GET_KEY
        cp      G_CLEAR
        jp      nz,enter
        ret
quit:
        ROM_CALL(CLEAR_DISP)
        call BUFCLR
	ld a,1
        ld (CURSOR_X),a
        ld a,2
	ld (CURSOR_Y),a
        ld hl,made
        ROM_CALL(D_ZM_STR)
        ld a,1
        ld (CURSOR_X),a
        ld a,8
        ld (CURSOR_Y),a
        ld hl,name
        ROM_CALL(D_ZM_STR)
        ld a,1
        ld (CURSOR_X),a
        ld a,22
        ld (CURSOR_Y),a
        ld hl,have
        ROM_CALL(D_ZM_STR)
        ld a,56
        ld (CURSOR_Y),a
        ld a,50
        ld (CURSOR_X),a
        ld hl,press
        ROM_CALL(D_ZM_STR)
        call enter
        ROM_CALL(CLEARLCD)
        ret
BUFCLR:
        ld hl,$88B8
        ld de,$88B9
        ld bc,$2FF
        ld (hl),0
        ldir
        ret
wait_key:
	ld       a,10                   ;Wait for a keypress
        call     waste_time
waste_time:
l:       halt
         dec      a
         jr       nz,l
         ret

;Ŀ
; Z80 ۳    Sprite83    ۳ movax ۳
; 

; Sprite xor routine v1.0
; Coded by Hannes Edfeldt in 1997

; This routine uses xor to draw the sprite, therefore you can erase the sprite
; by just drawing it again at the same x and y coordinates. See xordemo.z80
; for an example of how to use this routine.

; Feel free to use this routine in your own productions as long as you give me
; some credit.

; This file should of course be viewed in a DOS texteditor ;)

; Hannes Edfeldt -+- movax@algonet.se -+- http://www.algonet.se/~movax


; SPRXOR 
;Ŀ
; Xor 8x8 sprite  a=x, e=y, bc=sprite address                               
;
SPRXOR:

        push    bc              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
        add     hl,de
        add     hl,de
        add     hl,de
        add     hl,hl
        add     hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$88B8
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        xor     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor     (hl)
        ld      (hl),a

        ld      bc,11           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        xor     (hl)
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret

soldier:
        .db %01000001
        .db %01011101
        .db %00101010
        .db %00011100
        .db %00100010
        .db %00100010
        .db %01100011
        .db %00000000
copter:
        .db %01111111
        .db %00001000
        .db %00111111
        .db %01000001
        .db %01000001
        .db %00111111
        .db %10010010
        .db %01111111
truckback:
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %10000000
        .db %11111111
        .db %00111000
        .db %00010000
pic:
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126
    .db     1,248,63,193,255,193,252,124,126,0,0,193,2,8,64,35,0,35,4,194,194,0,1,192,132,8,128,23,0,23,5
    .db     193,194,0,1,192,72,9,128,23,0,23,5,192,194,0,1,192,48,11,134,23,12,23,5,192,66,0,1,192,0,11
    .db     134,23,12,23,5,192,2,0,1,192,0,11,128,23,0,23,5,192,2,0,1,192,0,11,128,23,0,39,5,192,2
    .db     0,1,192,0,11,134,23,0,71,5,192,2,0,1,195,2,11,134,23,12,39,5,192,2,0,1,195,134,11,134,23
    .db     12,23,5,194,2,0,1,195,206,11,134,23,12,23,5,195,2,0,1,195,254,11,134,23,12,23,5,195,130,0,1
    .db     195,238,11,134,23,12,23,5,195,194,0,1,253,207,251,255,231,255,247,249,255,254,0,1,248,143,243,255,199,255,231
    .db     241,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,192,0,0,198,0,0,16,0
    .db     0,0,0,146,64,0,0,68,0,0,0,0,0,0,0,16,64,0,0,108,0,0,0,0,0,0,0,16,88,124,0
    .db     108,124,238,112,124,0,0,0,16,100,130,0,84,130,68,16,130,0,0,0,16,68,254,254,84,130,68,16,254,0,0
    .db     0,16,68,128,0,68,130,40,16,128,0,0,0,16,68,130,0,68,130,40,16,130,0,0,0,56,238,124,0,238,124
    .db     16,124,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,0
    .db     0,0,16,16,0,0,0,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0
    .db     0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0
    .db     255,0,0,0,0,0,0,0,0,0,0,2,68,0,0,0,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0
    .db     0,0,0,0,0,130,0,0,0,0,0,0,0,0,0,0,0,186,0,0,0,0,0,0,0,0,0,0,0,84,0
    .db     0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,0,0,0,0
    .db     0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,130,0,0,0
    .db     0,0,0,0,0,0,0,0,130,0,0,0,0,0,0,0,0,0,0,1,131,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

truckfront:
        .db %00011000
        .db %00010100
        .db %00010010
        .db %00010001
        .db %00010001
        .db %11111111
        .db %00001110
        .db %00000100

made: .db "This game was made by",0
madeit: .db "You made it!",0
have: .db "Have a nice day  :)",0
name: .db "Craig Slusher",0
over: .db "Game Over!",0
; pausemess: .db "Pause",0
press: .db "Press Clear",0

.end
END