         ; *****************************************************************
         ; *
         ; *               L U N O I D     I X
         ; *
         ; *
         ; *           Programmed by Patrick Davidson
         ; *
         ; *             last updated : 8-August-97
         ; *
         ; *****************************************************************
scrlpos  =$8170
temp     =$8180
temp2    =$8182
temp3    =$8183
  ; ------------------------ PROGRAM HEADER --------------------------------
         .org     0
         .include "usgard.h"
         .db      "Lunoid 9.4 by Patrick D"
         .db      0
#DEFINE LOCATE(xc,yc)    ld de,(xc*256)+yc \ ld ($800c),de
  ; ----------------------- INITIALIZATION --------------------------------
         ROM_CALL(CLEARLCD)
         ld       b,96
         ld       a,32
         ld       ix,$8641
pcl:     ld       hl,0
         ld       ($800c),hl
         push     af
         push     bc
         ROM_CALL(TX_CHARPUT)
         ld       hl,$fc00
         ld       b,8
         ld       de,16
il2:     ld       a,(hl)
         ld       (ix),a
         add      hl,de
         inc      ix
         djnz     il2
         pop      bc
         pop      af
         inc      a
         djnz     pcl
         ld       a,(CONTRAST)
         inc      a
         cp       $20
         jr       nz,ok1
         dec      a
ok1:     inc      a
         cp       $20
         jr       nz,ok2
         dec      a
ok2:     out      (2),a
         ld       (iy+13),0
         ld       a,1
         ld       (USG_BITS),a
         call     &stuff            ;do the game
         ld       a,(CONTRAST)    
         out      (2),a
         ROM_CALL(CLEARLCD)
         ld       hl,temp2
         ld       a,(hl)
         or       a
         ret      nz
         LOCATE(0,0)
         ld       hl,&hstitle
         ROM_CALL(D_ZT_STR)
         LOCATE(16,1)
         ld       ix,&hsdata
         ld       b,7
high_display_loop:
         ld       l,(ix+0)
         ld       h,(ix+1)
         ROM_CALL(D_HL_DECI)
         ld       hl,$800c
         dec      (hl)
         inc      ix
         inc      ix
         push     ix
         pop      hl
         ROM_CALL(D_ZT_STR)
         ld       de,17
         add      ix,de
         ld       hl,$800c
         inc      (hl)
         djnz     high_display_loop
         call     &wait_key
         ret
stuff:
         ld       hl,&saved_flag     ;Check for saved game
         ld       a,(hl)
         or       a
         jp       nz,&restore_game
         ld       hl,0
         ld       ($800c),hl
         ld       hl,&initial_msg
         ROM_CALL(D_ZT_STR)
         ld       ix,$800c
         inc      (ix)
         ROM_CALL(D_ZT_STR)
         ld       a,200
         call     &waste_time
         ld       hl,0
         ld       (scrlpos),hl
         ld       hl,$0806
         ld       ($8941),hl

intro_loop:
         ld       hl,$89c1
         ld       b,128
lclearscrl:
         ld       (hl),0
         inc      hl
         djnz     lclearscrl
         ld       hl,(scrlpos)
         inc      hl
         ld       de,(scrl_end-scrltext)*8
         call     CP_HL_DE
         jr       nz,okscrl
         ld       hl,0
okscrl:  ld       (scrlpos),hl
         ld       a,8
         call     UNPACK_HL+2
         cpl
         and      7
         ld       de,&scrltext
         add      hl,de
         ld       b,15
scroll_loop:
         push     bc
         push     hl
         push     af
         ld       a,(hl)
         sub      32
         ld       l,a
         ld       h,0
         add      hl,hl
         add      hl,hl
         add      hl,hl
         ld       de,$8641
         add      hl,de
         ld       de,$8943
         ld       bc,8
         ldir
         pop      af
         push     af
         ld       d,a
         ld       e,56
         ld       ix,$8941
         call     &drw_spr
         pop      af
         pop      hl
         pop      bc
         add      a,8
         inc      hl
         djnz     scroll_loop
         ld       de,15
         ld       hl,$89c1
         ld       b,8
         ld       a,255
loop_blox:
         ld       (hl),a
         add      hl,de
         ld       (hl),a
         inc      hl
         djnz     loop_blox
         dec      hl
         ld       de,$ffff
         ld       bc,128
         lddr

         call     GET_KEY
         or       a
         jp       z,&intro_loop

         ld       hl,&speed
         ld       (hl),4
         cp       K_F2
         jr       nz,not_f2
         ld       (hl),3
not_f2:  cp       K_F3
         jr       nz,not_f3
         ld       (hl),2
not_f3:  cp       K_F4
         jr       nz,not_f4
         ld       (hl),1
not_f4:  cp       K_F5
         jr       nz,not_f5
         ld       (hl),0
not_f5:
         ld       hl,&lives
         ld       (hl),8
         dec      hl
         ld       (hl),0
  ; ------------------- OUTER GAME LOOP ----------------------
         ROM_CALL(CLEARLCD)
         ld       hl,0
         ld       ($800c),hl
         ld       hl,&universe_ttl
         ROM_CALL(D_ZT_STR)
         push     hl
         ld       hl,$800c
         inc      (hl)
         pop      hl
         ROM_CALL(D_ZT_STR)
loopu:   call     GET_KEY
         cp       K_F1
         jr       z,classic
         cp       K_F2
         jr       z,f2
         cp       K_F3
         jr       z,f3
         cp       K_F4
         jr       z,f4
         cp       K_F5
         jr       z,f5
         cp       K_EXIT
         ret      z
         jr       loopu
f2:      ld       a,2
         jr       start
f3:      ld       a,4
         jr       start
f4:      ld       a,6
         jr       start
f5:      ld       a,8
         jr       start
classic: ld       a,0
start:
         ld       (&uchoice),a
play_da_game:
         ld       hl,&lives
         inc      (hl)
         call     &level_addr
         ld       b,32                  ;Copy the map + count blocks
         ld       de,&data
set_up_1:ld       c,(hl)
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         inc      hl
         djnz     set_up_1
         ld       hl,&level
         inc      (hl)
level_loop:
         call     &do_level
restore_position:
         call     &play_level
         xor      a
         out      (1),a
         ld       a,(&won)
         or       a
         jr       z,finished_level
         ld       hl,&lives
         dec      (hl)
         jr       z,game_over
         jr       level_loop
finished_level:
         call     &level_addr
         ld       a,(hl)
         cp       255
         Jr       nz,play_da_game

  ; ---------------------- END OF GAME -------------------------
game_over:                    ;Set up score page
         ROM_CALL(CLEARLCD)
         LOCATE(0,0)
         ld       hl,&end_msg
         ROM_CALL(D_ZT_STR)
         ld       hl,&lives
         ld       a,(hl)                ;Score for levels completed
         or       a
         jr       z,won_
         ld       hl,&level
         dec      (hl)
won_:    ld       a,(hl)
         or       a
         jr       z,no_levels
         ld       b,a
         ld       hl,0
         ld       (&score),hl
         ld       de,1000
level_score_loop:
         ld       a,30
         call     &waste_time
         add      hl,de
         push     hl
         push     de
         LOCATE(16,1)
         ROM_CALL(D_HL_DECI)
         pop      de
         ld       hl,(&score)
         add      hl,de
         ld       (&score),hl
         push     de
         LOCATE(16,6)
         ROM_CALL(D_HL_DECI)
         pop      de
         pop      hl
         djnz     level_score_loop
no_levels:
         ld       bc,(&bricks)           ;Score for bricks hit
         ld       a,b
         or       c
         jr       z,no_bricks
         ld       hl,0              
bricks_loop:
         inc      hl
         push     hl
         push     de
         LOCATE(16,2)
         ROM_CALL(D_HL_DECI)
         pop      de
         ld       hl,(&score)
         inc      hl
         ld       (&score),hl
         LOCATE(16,6)
         ROM_CALL(D_HL_DECI)
         pop      hl
         dec      bc
         ld       a,b
         or       c
         jr       nz,bricks_loop
no_bricks:
         ld       a,5                  ;Score bonus for speed
         ld       hl,&speed
         sub      (hl)
         ld       b,a
         ld       hl,0
         ld       de,500
speed_loop:
         ld       a,30
         call     &waste_time
         add      hl,de
         push     hl
         push     de
         LOCATE(16,3)
         ROM_CALL(D_HL_DECI)
         pop      de
         ld       hl,(&score)
         add      hl,de
         ld       (&score),hl
         push     de
         LOCATE(16,6)
         ROM_CALL(D_HL_DECI)
         pop      de
         pop      hl
         djnz     speed_loop
         ld       a,(&won)              ;Score victory bonus
         or       a
         jr       nz,lost
         ld       b,80
         ld       hl,0
         ld       de,50
victory_loop:
         ld       a,30
         call     &waste_time
         add      hl,de
         push     hl
         push     de
         LOCATE(16,4)
         ROM_CALL(D_HL_DECI)
         pop      de
         ld       hl,(&score)
         add      hl,de
         ld       (&score),hl
         push     de
         LOCATE(16,6)
         ROM_CALL(D_HL_DECI)
         pop      de
         pop      hl
         djnz     victory_loop

         ld       hl,&lives
         ld       b,(hl)              ;Score bonus for extra lives
         ld       hl,0
         ld       de,100
lives_loop:
         ld       a,30
         call     &waste_time
         add      hl,de
         push     hl
         push     de
         LOCATE(16,5)
         ROM_CALL(D_HL_DECI)
         pop      de
         ld       hl,(&score)
         add      hl,de
         ld       (&score),hl
         push     de
         LOCATE(16,6)
         ROM_CALL(D_HL_DECI)
         pop      de
         pop      hl
         djnz     lives_loop
lost:
         call     &wait_key
         ld       hl,&lowest                  ;See if ya got a hi-score
         call     LD_HL_MHL
         ld       de,(&score)
         call     CP_HL_DE
         ret      nc
         ROM_CALL(CLEARLCD)
         LOCATE(0,0)
         ld       hl,&hi_score_str
         ROM_CALL(D_ZT_STR)
         ld       hl,&lowest+2
         ld       (temp),hl
         ld       b,16
space_loop:
         ld       (hl),32
         inc      hl
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
         call     GET_KEY
         cp       0
         jr       z,enter_name_loop
         cp       K_DEL
         jr       z,backup
         cp       K_ENTER
         jr       z,nomore
         ld       c,a
         ld       a,15
         cp       b
         jr       z,enter_name_loop
         ld       hl,&chartable
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         ld       (ix),a
         ROM_CALL(TX_CHARPUT) 
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),32
         ld       hl,$800d
         dec      (hl)
         ld       a,32
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:
         ld       hl,&lowest
         ld       de,(&score)
         ld       (hl),e
         push     hl
         inc      hl
         ld       (hl),d
         pop      ix              ;sort hiscore table
         ld       b,6
sort_scores
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-19)
         ld       h,(ix-18)
         call     CP_HL_DE
         ret      nc
         push     bc
         ld       b,19
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-19)
         ld       (ix),c
         ld       (ix-19),e
         inc      ix
         inc      hl
         djnz     exg_loop
         ld       de,-38
         add      ix,de
         pop      bc
         djnz     sort_scores
         ret
 ;------------------ LEVEL STARTING CODE ---------------------
do_level:
         ld       hl,&x
         ld       (hl),128
         inc      hl
         ld       (hl),58
         inc      hl
         ld       (hl),112
         inc      hl
         ld       (hl),-1
         inc      hl
         ld       (hl),-1
         ret
 ;---------------------- THE MAIN GAME -----------------------
play_level:
         ROM_CALL(CLEARLCD)       ;Display level entry message
         ld       hl,0
         ld       ($800c),hl
         ld       hl,&approaching
         ROM_CALL(D_ZT_STR)
         ld       hl,&level
         ld       c,(hl)
         ld       b,0
         push     bc
         pop      hl
         ROM_CALL(D_HL_DECI)
         ld       hl,&press
         ROM_CALL(D_ZT_STR)
         ld       hl,&lives
         ld       c,(hl)
         ld       b,0
         push     bc
         pop      hl
         ROM_CALL(D_HL_DECI)
         call     &wait_key
         cp       K_EXIT
         jp       z,&r3
game_main_loop:
         ld       hl,$8641
         ld       b,128
         xor      a
clgloop: ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         djnz     clgloop
         ld       a,(&speed)             ;Slow down a bit
         or       a
         call     nz,&waste_time
         call     &redraw_solid          ;Redraw all blocks
         ld       hl,&x
         ld       a,(&xv)
         add      a,(hl)
         ld       (hl),a
         inc      hl
         bit      5,(hl)                ;Bounce off of blocks
         dec      hl
         jr       nz,bottom_section_1      
         call     &test_hit      
         bit      1,a      
         jr       z,horiz_not_solid      
         ld       a,(&xv)      
         neg      
         ld       (&xv),a      
         add      a,(hl)      
         ld       (hl),a      
         jr       bottom_section_1
horiz_not_solid:
         cp       0
         jr       z,bottom_section_1
         ld       a,(&xv)
         neg
         ld       (&xv),a
bottom_section_1:
         inc      hl                         ;HL -> Y
         ld       a,(&yv)
         add      a,(hl)      
         ld       (hl),a      
         bit      5,(hl)                  
         jr       nz,bottom_section_2
         call     &test_hit
         bit      1,a
         jr       z,vert_not_solid
         ld       a,(&yv)
         neg
         ld       (&yv),a
         add      a,(hl)
         ld       (hl),a
         jr       bottom_section_2
vert_not_solid:
         cp       0
         jr       z,bottom_section_2
         ld       a,(&yv)
         neg
         ld       (&yv),a
bottom_section_2:
         ld       e,(hl)
         dec      hl
         ld       d,(hl)
         srl      d
         dec      e
         dec      d
         ld       ix,&spr_ball
         call     &drw_spr

         ld       hl,&y
         ld       b,(hl)                ;Bounce off top
         ld       a,1
         cp       b
         jr       nz,not_top
         ld       (&yv),a
not_top: ld       a,(hl)                ;Bounce off paddle / Fall off screen
         cp       62
         ret      z
         cp       61
         call     z,&bounce_paddle
         cp       60
         call     z,&bounce_paddle
         dec      hl
         ld       a,(hl)                ;Bounce off left edge
         ld       de,&xv
         and      252
         jr       nz,not_hit_left_edge
hit_left_edge:                          ;Hit left edge of screen
         ld       a,(de)
         bit      7,a
         jr       z,not_hit_left_edge
         neg
         ld       (de),a
not_hit_left_edge:
         ld       a,(hl)              ;Bounce off right edge
         add      a,4
         and      252
         jr       nz,not_hit_right_edge
hit_right_edge:                         ;Hit right edge of screen
         ld       a,(de)
         bit      7,a
         jr       nz,not_hit_right_edge
         neg
         ld       (de),a
not_hit_right_edge:
         ld       a,%00111111           ;Exit key = get out!
         out      (1),a
         in       a,(1)
         bit      6,a
         jp       z,&r3
         ld       a,%01111110           ;Left arrow = go left!
         out      (1),a
         in       a,(1)
         bit      1,a
         call     z,&go_left
         in       a,(1)                 ;Right arrow = go right!
         bit      2,a                 
         call     z,&go_right
         in       a,(1)                 ;Down arrow = save & exit
         bit      0,a
         jp       z,&save

         ld       a,(&p)                 ; Draw paddle
         srl      a
         ld       d,a
         ld       e,60
         ld       ix,&leftp
         push     de
         call     &drw_spr
         pop      de
         ld       a,d
         add      a,8
         ld       d,a
         ld       ix,&rightp
         call     &drw_spr

         ld       de,$fc00
         ld       hl,$8641
         ld       bc,1024
         ldir
         ld       a,(&won)
         or       a
         jp       nz,&game_main_loop
         ret
  ; ------------------- UTILITY ROUTINES ----------------------
save:    pop      bc                ;Save the game
         pop      bc
         ld       hl,&saved_flag
         ld       (hl),1
         ld       hl,USG_BITS
         ld       (hl),3
         ld       hl,temp2
         ld       (hl),1
         ld       a,(CONTRAST)    
         out      (2),a
         ret
restore_game:                             ;Restore the game
         ld       (hl),0
         jp       &restore_position
wait_key:ld       a,200                   ;Wait for a keypress
         call     &waste_time
wait_inner:
         call     GET_KEY
         or       a
         ret      nz
         jr       wait_inner
test_hit:
         ld       a,(&y)                ;Test if a block has been hit
         and      28
         sla      a
         sla      a
         ld       b,a
         ld       a,(&x)
         srl      a
         srl      a
         srl      a
         srl      a
         add      a,b
         push     hl
         ld       hl,&data
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         cp       1
         jr       z,clr_block
         cp       2
         jr       z,dec_block
         pop      hl
         ret
dec_block:
         ld       (hl),1
         pop      hl
         ret
clr_block:                    ;Clear out a block
         push     af
         ld       (hl),0
         ld       a,(&y)
         and      28
         ld       b,0
         ld       c,a
         sla      c
         sla      c
         sla      c
         bit      7,c
         jr       z,n_s
         ld       b,1
n_s:     sla      c
         ld       a,(&x)
         srl      a
         srl      a
         srl      a
         srl      a
         ld       hl,$fc00
         add      hl,bc
         ld       b,0
         ld       c,a
         add      hl,bc
         ld       c,16
         ld       (hl),b
         add      hl,bc
         ld       (hl),b
         add      hl,bc
         ld       (hl),b
         add      hl,bc
         ld       (hl),b
         ld       hl,(&bricks)
         inc      hl
         ld       (&bricks),hl
         pop      af
         pop      hl
         ret

r3:      ld       a,(CONTRAST)    
         out      (2),a
         ld       hl,temp2
         ld       (hl),1
         pop      af
         pop      af
         ret
go_right:
         ld       a,(&p)
         cp       224
         jr       z,right_edge
         inc      a
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         cp       224
         jr       z,right_edge
         inc      a
         cp       224
         jr       z,right_edge
         inc      a
         cp       224
         jr       z,right_edge
         inc      a
quit_moving:
         ld       (&p),a
         ret
right_edge:                   ;If paddle is at right edge
         ld       a,224
         ld       (&p),a
         ret
go_left:
         ld       a,(&p)
         cp       0
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         dec      a
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         dec      a
         ld       (&p),a
         xor      a
         ret
left_edge:                     ;If paddle is at left edge
         xor      a
         ld       (&p),a
         ret
waste_time:
         push     bc
         ld       b,0
l:       push     bc
         ld       b,a
il:      nop
         djnz     il
         pop      bc
         djnz     l
         pop      bc
         ret

bounce_paddle:                ;Bounce ball off paddle
         dec      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         sub      (hl)
         ld       c,a
         srl      a
         srl      a             
         srl      a
         srl      a
         srl      a
         ret      nz
         ld       hl,&bounces
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       hl,&yv
         ld       (hl),-1
         dec      hl
         ld       (hl),a
         dec      hl
         dec      hl
         ret
redraw_solid:                 ;Redraw all bricks
         ld       hl,&won
         ld       (hl),0
         ld       ix,$8641
         ld       hl,&data
         ld       b,8
rs_outer:push     bc
         ld       b,16
         ld       de,
rs_inner:ld       a,(hl)
         dec      a
         jr       z,draw_block
         dec      a
         JR       Z,draw_block_tough
         dec      a
         jr       z,draw_block_solid
ok:      inc      hl
         inc      ix
         djnz     rs_inner
         ld       de,48
         add      ix,de
         pop      bc
         djnz     rs_outer
         ret
draw_block:                   ;Draw a standard block
         cpl
         ld       (&won),a
         ld       (ix+0),255
         ld       (ix+16),129
         ld       (ix+32),129
         ld       (ix+48),255
         jp       &ok
draw_block_solid:             ;Draw a solid block
         ld       (ix+0),255
         ld       (ix+16),255
         ld       (ix+32),255
         ld       (ix+48),255
         jp       &ok
draw_block_tough:             ;Draw a tough block
         cpl
         ld       (&won),a
         ld       (ix+0),255
         ld       (ix+16),195
         ld       (ix+32),195
         ld       (ix+48),255
         jp       &ok
 ; -------------- SRPITE DRAWING ROUTINE ------------------------------------
offsets_table:
         .db      128,64,32,16,8,4,2,1
drw_spr: ld       a,d
         and      7
         ld       hl,&offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (&smc1+1),a

         ld       hl,$8641          ;Calculate byte number
         ld       B,0
         ld       a,e
         add      a,a
         add      a,a
         add      a,a
         rl       b
         add      a,a
         rl       b
         ld       c,d
         srl      c
         srl      c
         srl      c
         or       c
         ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         inc      ix
         ld       b,(ix)        
         inc      ix
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix)            ;Load one line of image
         inc      ix
smc1     ld       a,1               ;Load pixel mask
iloop:   sla      c                 ;Test leftmost pixel
         jr       nc,noplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret

 ; -------------- SPRITE FOR PADDLE -----------------------------------------
leftp:   .db      8,4
         .db      %01111111
         .db      %10000000
         .db      %10000000
         .db      %01111111
rightp:  .db      8,4
         .db      %11111110
         .db      %00000001
         .db      %00000001
         .db      %11111110
spr_ball:.db      3,3
         .db      %01000000
         .db      %11100000
         .db      %01000000
 ; -------------- FIND A LEVEL ----------------------------------------------
level_addr:
         ld       a,(&uchoice)
         ld       e,a
         ld       d,0
         ld       hl,&universe_list
         add      hl,de
         call     LD_HL_MHL
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       a,(&level)
         ld       b,a
         inc      b
         ld       de,32
find_level_loop:
         add      hl,de
         djnz     find_level_loop
         ret
  ; ------------------------ DATA -------------------------
bounces: .db      -3,-3
         .db      -2,-2,-2,-2,-2,-2
         .db      -1,-1,-1,-1,-1,-1
         .db      0,0,0,0
         .db      1,1,1,1,1,1
         .db      2,2,2,2,2,2
         .db      3,3
initial_msg: 
         .db      "L U N O I D       I X",0
         .db      "by Patrick A Davidson"
         .db      "  (ariwsi@juno.com)  "
         .DB      "   Copyright 1997    "
         .db      "Choose Speed : F1-F5"
         .db      0
scrltext:.db      "                 "
         .db      "WELCOME TO LUNOID 9!   "
         .db      "PRESS A FUNCTION KEY "
         .db      "TO SELECT THE SPEED AND "
         .db      "BEGIN THE GAME!  F1 IS THE "
         .db      "SLOWEST AND F5 THE FASTEST.  "
         .db      "WHEN PLAYING, MOVE AROUND "
         .db      "WITH THE LEFT AND RIGHT "
         .db      "ARROWS.  TO MOVE MORE SLOWLY, "
         .db      "HOLD DOWN THE UP ARROW AT THE "
         .db      "SAME TIME.  TO EXIT AND SAVE "
         .db      "THE GAME, PRESS THE DOWN "
         .db      "ARROW.  THIS GAME WAS FINISHED "
         .db      "IN AUGUST 1997.  "
         .db      "TEXT RESTARTS..."
scrl_end:.db      "                 "
end_msg: .db      " -> Final Scoring <- "
         .db      "Levels finished:    0"
         .db      "     Bricks hit:    0"
         .db      "    Speed bonus:    0"
         .db      "  Victory bonus:    0"
         .db      "Lives remaining:    0"
         .db      "*** TOTAL SCORE:    0"
         .db      " ---> Lunoid IX <---",0
approaching:
         .db      "---> NEXT LEVEL:"
         .db      0
press:   .db      "PRESS ANY KEY TO PLAY"
         .db      "LIVES REMAINING:"
 ; -------------------- GAME DATA -------------------------------------------
saved_flag:
         .db      0
x        .db      0 
y        .db      0
p        .db      0
xv       .db      0
yv       .db      0
level    .db      0
lives    .db      0
won      .db      0
speed    .db      0
bricks   .dw      0
score    .dw      0
uchoice: .db      0
data     .dw      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 ; -------------------- UNIVERSE DATA ---------------------------------------
universe_ttl:
         .db      "CHOOSE YOUR UNIVERSE:",0
         .DB      "F1) The Sandbox      "
         .db      "F2) Classic Universe "
         .db      "F3) The Dark Realm   "
         .db      "F4) Castle of Death  "
         .db      "F5) Ultimate Universe",0
universe_list:
         .dw      sandbox-32
         .dw      classic_universe-32
         .dw      dark_realm-32
         .dw      castle_death-32
         .dw      ultimate-32
classic_universe:
         .db      %11111100,%00000000,%00000000,%00111111
         .db      %11110000,%00000000,%00000000,%00001111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%10101010,%10101010,%00000000
         .db      %00000000,%01010101,%01010101,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %00000000,%10100000,%00101010,%10000000
         .db      %00000010,%00001000,%00100000,%00000000
         .db      %00000010,%00001000,%00100000,%00000000
         .db      %00000000,%10100000,%00101010,%10000000
         .db      %00000010,%00001000,%00000000,%10000000
         .db      %00000010,%00001000,%00100000,%10000000
         .db      %00000000,%10100000,%00001010,%10000000
         .db      %00001111,%11111111,%11111111,%11110000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00111111,%11111111,%11111111,%11111100
         .db      %00101010,%10001010,%10100010,%10100000
         .db      %00100000,%10001000,%00100010,%00001000
         .db      %00101010,%10001010,%10100010,%00001000
         .db      %00100000,%00001000,%00100010,%00001000
         .db      %00100000,%00001000,%00100010,%10100000
         .db      %00111111,%11111111,%11111111,%11111100
         .db      255
dark_realm:
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11111100,%00000000,%00000000,%00111111
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000001,%01010101,%01010101,%01010101
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000011,%11111111,%11111111,%11111111
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %01010101,%01010101,%01010101,%01000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11111111,%11111111,%11111111,%11000000
         .db      255
sandbox: .db      %01010101,%01010101,%01010101,%01010101
         .db      %01000000,%00000000,%00000000,%00000001
         .db      %01000101,%01010101,%01010101,%01010001
         .db      %01000100,%00000000,%00000000,%00010001
         .db      %01000100,%00000000,%00000000,%00010001
         .db      %01000101,%01010101,%01010101,%01010001
         .db      %01000000,%00000000,%00000000,%00000001
         .db      %01010101,%01010101,%01010101,%01010101
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %00000010,%10101010,%10101010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %00000010,%10101010,%10101010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %00000010,%10101010,%10101010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      255
castle_death:
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %11111111,%11110000,%00001111,%11111111
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      255
ultimate:.db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %11111100,%00111111,%11111100,%00111111
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      255
 ; ---------------------- HIGH SCORES -------------------------
hi_score_str:
         .db      "----> LUNOID IX <----"
         .db      "  You have a hiscore!"
         .db      "Enter your name:     ",0
hstitle: .db      "==LUNOID HIGHSCORES==",0
hsdata:  .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
lowest   .dw      666
         .db      "Bill Gates      ",0
chartable:
         .db      "..........XTOJE."
         .db      ". WSNID!.ZVRMHC?"
         .db      ".YUQLGB#x~+PKFA|"
         .db      "@54321.~+"

         .end
