DefaultSpriteHeight = 6

;=====================================
draw_screen:
;
; input:	
; output:	screen drawn to graphmem
;=====================================
	call	clear_graph_mem
	call	draw_next
	ld	hl,	GRAPH_MEM + 12+8
	call	draw_title
	call	draw_line
	call	draw_balls
	call	draw_my_name
	call	draw_score
	call	draw_high_score
	call	draw_help_line
	ret

;====================================
draw_help_line:
;====================================
	ld	hl,	27 *256+ 69
	ld	(GRAF_CURS),hl
	ld	hl,	help_str
	ROM_CALL(D_ZM_STR)
	ret

help_str:
	.db "Y=  Help",0

;=====================================
draw_high_score:
;=====================================
	ld	hl,	34 *256+ 68
	ld	(GRAF_CURS),hl
	ld	hl,	hi_str
	ROM_CALL(D_ZM_STR)
		
	ld	hl,	(high_score)
	ld	b,	5
	call	DM_HL_DECI
	ret
hi_str:
	.db	"Hi ",0

;=====================================
draw_score:
;====================================
	ld	hl,	9 *256+ 75
	ld	(GRAF_CURS),hl
	ld	hl,	(score)
	ld	b,	5
	call	DM_HL_DECI
	ret

;=====================================
draw_my_name:
;=====================================

	ld	hl,	51*256+67
	ld	(GRAF_CURS),hl
	ld	hl,	my_name_1
	ROM_CALL(D_ZM_STR)
	
	ld	hl,	57*256+71
	ld	(GRAF_CURS),hl
	ld	hl,	my_name_2
	ROM_CALL(D_ZM_STR)
	ret

;=====================================
draw_next:
;
; input:	(next)
; output:	the next three tiles drawn in a box
;=======================================
	
          ld        a,        6
          call      SetSpriteHeight
	
	ld	hl,	GRAPH_MEM+(16*12+8)
	call	draw_box_top
	ld	hl,	GRAPH_MEM+(25*12+8)
	call	draw_box_top
	ld	b,	8
	ld	hl,	GRAPH_MEM+(17*12+8)
draw_box_sides:
	ld	(hl),	%00000100
	ld	de,	3
	add	hl,	de
	ld	(hl),	%00001000
	ld	de,	9
	add	hl,	de
	djnz	draw_box_sides

	ld	b,	3
	ld	de,	71*256+18
	ld	hl,	next
draw_tiles_loop:
	push	bc
	
	push	de
	pop	bc
	ld	a,	(hl)
	push	hl
	push	de
	call	draw_ball_at_bc
	pop	de
	pop	hl
	inc	hl
	ld	a,	7
	add	a,	d
	ld	d,	a
	
	pop	bc
	djnz	draw_tiles_loop
	ret

draw_box_top:	
	ld	(hl),	%00000111
	inc	hl
	ld	(hl),	%11111111
	inc	hl
	ld	(hl),	%11111111
	inc	hl
	ld	(hl),	%11111000
	ret


;======================================
draw_title:
;
; input:	hl = address to start drawing
; output:	title drawn to graphmem
;======================================

	ld	b,	8
	ld	de,	title
draw_title_line:
	push	bc
	ld	b,	4
draw_title_byte:	
	ld	a,	(de)
	ld	(hl),	a
	inc	hl
	inc	de
	djnz	draw_title_byte
	ld	bc,	8
	add	hl,	bc
	pop	bc
	djnz	draw_title_line
	ret

;======================================
draw_line:
;
; input:	none
; output:	vertical line drawn to graphmem
;======================================

	ld	c,	%01000000
	ld	hl,	GRAPH_MEM+8
	ld	b,	64
	ld	de,	12
line_loop:
	ld	a,	(hl)
	or	c
	ld	(hl),	a
	add	hl,	de
	djnz	line_loop
	ret

;======================================
flash_start:
;
; input:  flash
; output: start is erased or not
;=======================================
          ld        a,        6
          call      SetSpriteHeight
          
          ld        a,        (start_flag)   ; return if start_flag is false
          cp	    0
          ret       z
          
          
          ld        a,        (flash)
          inc       a
          and       %00001111
          ld        (flash),  a         ; return if (flash) > $80
          cp        $08
          ret       nc
          
          ld        hl,       start     ; de = row and col of start
          ld        b,        (hl)
          inc       hl
          ld        c,        (hl)
          
          ld        a,        0
          call      draw_ball
          ret

;=======================================
draw_selector:
;
; input:  bc = x and y (0-8)
; output: that square is inverted in the graphmem
;======================================
          ld        a,        8
          call      SetSpriteHeight
          
          ld        a,        b         ; b = 7d
          call      times_seven
          ld        b,        a
         
          ld        a,        c         ; c = 7d
          call      times_seven
          ld        c,        a
          
          dec       b
          dec       c
          ld        hl,       selector
          call      PutSprClp
          ret


;======================================
draw_balls:
;
; input: board
; output: balls drawn to the graph_mem
;======================================
          ld        a,        6
          call      SetSpriteHeight
          
          ld        b,        9         ; draw 9 cols
          ld        hl,       board+81  ; load the balls from here
board_cols:
          
          ld        c,        b         ; cols = c
          ld        b,        9         ; draw 9 rows
board_rows:                              
          dec       hl                  ; goto the next address for the balls
          
          push      bc                  ; save row and col
          push      hl                  ; save the ball address
          
          dec       c                   ; counting now starts at 0 instead of 1
          dec       b                   
          ld        a,        (hl)      ; get the ball value
          cp        0
          jr        z,        dont_draw ; dont draw a ball if their isn't one there
          
          call      draw_ball           ; draw the ball
dont_draw:
          pop       hl                  ; get the ball address
          pop       bc                  ; get the row and col
          
          djnz      board_rows          ; loop to the rows
          
          ld        b,        c         ; put the row back into the counter
          djnz      board_cols          ; loop to the cols
          ret                           ; done!
      

;======================================
draw_ball:
;
; input:  bc = x and y of ball (0-8),(0-8)
;         a = number of the ball (1-5) - 0 for blank          
; output: ball drawn to the graph mem
;======================================
          push      af                  ; save the ball number
          
          ld        a,        b         ; b = 7d
          call      times_seven
          ld        b,        a
         
          ld        a,        c         ; c = 7d
          call      times_seven
          ld        c,        a
          pop       af
draw_ball_at_bc:           
          add       a,        a         ; a = 2a
          add       a,        a         ; a = 4a
          ld        e,        a         ; e = 4a
          add       a,        a         ; a = 8a
          add       a,        e         ; a = 12a
          ld        e,        a         ; e = 12a
          ld        d,        0         ; de = 12a
          ld        hl,       blank     ; hl = balls + 12a
          add       hl,       de        ; hl points to the sprite for the ball
          
          call      PutSprClp           ; draw the sprite there
          ret

;======================================
times_seven:
; 
; input:  a
; output: a = 7*a
;=======================================
          push      bc
          ld        c,        a         ; c = a
          add       a,        a         ; a = 2a
          add       a,        a         ; a = 4a
          add       a,        a         ; a = 8a
          sub       c                   ; a = 7a
          inc       a
          pop       bc
          ret

my_name_1:
	.db "Jon",0
my_name_2:
	.db "Snyder",0
selector:
          .db %11111111       ;invert symbol
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111

          .db %11111111       ;invert symbol
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111
          .db %11111111          
                    
blank:
	.db %00000011
	.db %00000011
	.db %00000011
	.db %00000011
	.db %00000011
	.db %00000011

          .db %00000000
          .db %00000000
          .db %00000000
          .db %00000000
          .db %00000000
          .db %00000000
balls:
          .db %00000011  ; square
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          
          .db %00000000
          .db %01111000
          .db %01111000
          .db %01111000
          .db %01111000
          .db %00000000
          
          .db %00000011  ; cross
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          
          .db %00110000
          .db %00110000
          .db %11111100
          .db %11111100
          .db %00110000
          .db %00110000
          
          .db %00000011  ; diamond
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          
          .db %00110000
          .db %01111000
          .db %11111100
          .db %11111100
          .db %01111000
          .db %00110000
          
          .db %00000011  ; up arrow
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          
          .db %00110000
          .db %01111000
          .db %11111100
          .db %00110000
          .db %00110000
          .db %00110000
          
          .db %00000011  ; triangle
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          
          .db %00000100
          .db %00001100
          .db %00011100
          .db %00111100
          .db %01111100
          .db %11111100

disapper:
          .db %00000011  ; blank
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          .db %00000011
          
          .db %00101000  ; blank
          .db %10000000
          .db %00000100
          .db %10000000
          .db %00000100
          .db %01010000
          
; Width: 32  Height: 8  (32 bytes)
title:
	.db %00011000,%00000000,%00000000,%00000000
	.db %00011000,%00011000,%00000000,%00000000
	.db %00011000,%00000000,%00000000,%00000000
	.db %00011000,%00111010,%11000111,%00011110
	.db %00011000,%00011011,%10101100,%10110000
	.db %00011000,%00011011,%00101111,%10111110
	.db %00011000,%10011011,%00101100,%00000110
	.db %00011111,%10111011,%00100111,%10111100
          
