; select.asm
; includes routines for selecting the square that the user picks

;===========================================
get_square:
;
; input:  bc = starting row and col
; output: bc = row and col that 2nd was pushed on
;============================================

select_refresh:
          push      bc
          push      bc
          call      draw_screen
          call      flash_start               ; flashes the selected ball
          pop       bc
          call      draw_selector
          call      CR_GRBCopy
          pop       bc
          
select_getkey:

          
          call      GET_KEY
          
          cp        G_UP
          jr        z,        select_up
          
          cp        G_DOWN
          jr        z,        select_down
          
          cp        G_RIGHT
          jr        z,        select_right
          
          cp        G_LEFT
          jr        z,        select_left
          
          cp        G_2ND
          ret       z
          
          cp	G_YEDIT
          jr	z,	select_help
          
          cp	G_ALPHA
          jr	z,	select_alpha
          
          cp	G_DEL
          jr	z,	select_save_quit
          
          cp	G_MODE
          call	z,	sure_quit
          jr        select_refresh
          
select_save_quit:
	ld	a,	1
	ld	(saved_game_flag),a
	ld	sp,	(saved_sp)
	ret				; quit the program

select_help:
	push	bc
	call	draw_help
	pop	bc
	jr	select_refresh
	
select_alpha:
	push	bc
	call	place_next
	call	get_next
	pop	bc
	jr	select_refresh

select_up:

	dec	c
	ld	a,	c
	cp	$FF
	jr	nz,	select_refresh
	
	ld	c,	8
        jr      select_refresh
          
select_down:
	inc	c
	ld	a,	c
	cp	9
	jr	nz,	select_refresh
	
	ld	c,	0
        jr      select_refresh

select_right:
	inc	b
	ld	a,	b
	cp	9
	jr	nz,	select_refresh
	
	ld	b,	0
        jr      select_refresh
          
select_left:
	dec	b
	ld	a,	b
	cp	$FF
	jr	nz,	select_refresh
	
	ld	b,	8
        jr      select_refresh
          
;============================================
get_board_piece:
;
; input:	bc = row and col
; output:	hl = address to the row and col in the board
;=============================================

	ld	hl,	board
	call	row_col_to_address
	ret
	
;==============================================	
row_col_to_address:
;
; input:	bc = row and col
;		hl = board offset
; output:	hl = address of row and col
;===============================================
	push	bc
	ld	a,	c
	add	a,	a
	add	a,	a
	add	a,	a
	add	a,	c
	add	a,	b
	ld	c,	a
	ld	b,	0
	add	hl,	bc
	pop	bc
	ret
	
	
	
	
