#include "ti86asm.inc"

;#####===== SOURCE CODE FOR HIGHWAY
;#####===== BY Jarno Lveri, 2000, Finland

;If you find any bugs or maybe a way to make this smaller,
;please email me at jlaaveri@hotmail.com

.org _asm_exec_ram

_asapvar		=$d6fc
_set_abs_src_addr	=$4647
_set_abs_dest_addr	=$5285
_set_mm_num_bytes	=$464f
_mm_ldir		=$52ed

;########## prog start
	nop
	jp titlescreen
	.dw 0
	.dw ShellTitle

ShellTitle:
	.db "Highway DX by JTL",0
;=====title screen
titlescreen:
 call _clrScrn
 call _runindicoff
 ld hl,tsc
 ld de,$fd80
 ld bc,160
 ldir
 ld de,$2847
 ld (_penCol),de
 ld hl,by
 call _vputs
tscloop:
 ld de,rightcar
 ld hl,$fe40
 ld b,4
 call putsprite
 ld de,leftcar
 ld hl,$fd2f
 ld b,4
 call putsprite
 ld b,11
tscloop2:
 push bc
 ld hl,$fe3f
 ld c,4
 call scrolr
 ld hl,$fd60
 ld c,4
 call scroll
 halt
 halt
 pop bc
 call _getky
 cp K_ENTER
 jr z,menu
 djnz tscloop2
 jr tscloop

;=====draw menu
menu:
 call _clrScrn
 ld hl,tsc
 ld de,$fc20
 ld bc,160
 ldir
 ld hl,$fcf0
 call makemaproad
 ld de,$0e10
 call incd9
 ld hl,mtsta
 call _vputs
 call incd9
 ld hl,mtspe
 call _vputs
 call incd9
 ld hl,mtfre
 call _vputs  
 call incd9
 ld hl,mtste
 call _vputs
 call incd9
 ld hl,mthig
 call _vputs

;=====activate menu
menuloop:
 call menu_a
 call _getkey
 cp kF1
 jp z,start
 cp kF5
 jp z,exit
 cp kF2
 jr z,setspeed
 cp kF3
 jr z,setfreq
 cp kF4
 jr z,setsteer
 jr menuloop

setspeed:
 xor a
 ld b,32
 ld hl,$fcd0
emptyhsinmenu:
 ld (hl),a
 inc hl
 djnz emptyhsinmenu
 ld a,%11010000
 ld ($fcd0),a
 ld ($fce0),a
 ld a,(speedB)
 call inca
 ld (speedB),a
 ld b,a
 ld hl,highscore_slow-1
 call inchl
 ld b,(hl)
setspeedhscar:
 push bc
 ld hl,$fccf
 ld c,2
 call scrolr
 pop bc
 djnz setspeedhscar
 jr menuloop
setfreq:
 ld a,(freqB)
 call inca
 ld (freqB),a
 jr menuloop
setsteer:
 ld a,(steerB)
 call inca
 ld (steerB),a
 jr menuloop

;=====menu stuff
menu_a
 ld de,$1550
 call incd9
 ld a,(speedB)
 ld hl,a_speed-7
 call menu_ud
 call incd9
 ld a,(freqB)
 ld hl,a_freq-7
 call menu_ud
 call incd9
 ld a,(steerB)
 ld hl,a_steer-7 

menu_ud:
 ld c,a
menu_udl:
 ld b,7
 call inchl
 dec c
 jr nz,menu_udl
 jp _vputs

inca:
 inc a
 cp 4
 ret nz
 ld a,1
 ret

start:

;=====set traffic frequentity
 ld a,(freqB)
 cp 1
 jr nz,a_isnt_one
 ld a,72
 jr freq_set_done
a_isnt_one:
 cp 2
 jr nz,a_is_three
 ld a,60
 jr freq_set_done
a_is_three:
 ld a,52
freq_set_done:
 ld (setllane),a
 add a,a
 ld (setrlane),a

;=====set setbtndelay
 ld a,(steerB)
 add a,1
 add a,a
 add a,a
 ld (setbtndelay),a

;=====reset score
 xor a
 ld (score),a

;=====other stuff
 ld hl,$fe20				
 ld (carpos),hl				
 ld hl,straight					
 ld (spriteaddr),hl
 xor a
 ld (cheat),a
 inc a
 ld (ltraffic),a
 ld (rtraffic),a
 inc a
 ld (way),a
 ld a,$21
 ld (way2),a
 ld a,22
 ld (scoremem),a

;########## first screen
 ld b,16	
build:
 push bc

 ld b,8					
buildscrl:				
 push bc
 ld hl,0
 ld c,64
 call scroll
 call _getky
 cp K_0
 jr nz,noch
 ld a,1
 ld (cheat),a
noch:
 pop bc
 djnz buildscrl
 call makewalls

 pop bc
 djnz build 	

;=====draw "map"
 ld hl,$ffb0
 ld b,5
putmapcars:
 ld a,%11010000
 ld (hl),a
 call s16ba
 djnz putmapcars

 ld hl,$ffd0
 call makemaproad

 ld hl,highscore_slow-1
 ld a,(speedB)
 ld b,a
 call inchl
 ld b,(hl)
 ld a,b
 or a
 jr z,mainloop
hscar:
 push bc
 ld hl,$ffdf
 ld c,2
 call scrolr
 pop bc
 djnz hscar

;################################################
;======engine====================================
;################################################
mainloop:

 ld a,(cheat)
 dec a
 jr z,cheat_on
;=====check if the way is clear or not
 ld a,(way2)
 ld b,a
 ld hl,(carpos)
 call inchl
 ld b,4
crashcheck:
 ld a,(hl)
 and %10000000
 jp nz,crash
 call s16ba
 djnz crashcheck
cheat_on:

;=====draw your car
 ld de,(spriteaddr)
 ld hl,(carpos)
 ld b,8
dcloop:
 ld a,(de)
 or a
 jr z,dcjump
 ld (hl),a
dcjump:
 call s16ba
 inc de
 djnz dcloop

;=====check keyboard
 ld a,(btndelay)
 cp 0
 jr z,dokc
 dec a
 ld (btndelay),a 
 jr kcdone
dokc:
 call checkkeys
kcdone:

;=====scroll the left lane
 ld hl,$fda0 
 ld c,24
 call scroll

;=====slowdown
 ld a,(speedB)
 cp 1
 jr z,nohalt
 cp 2
 jr z,normhalt 
 halt
normhalt:
 halt
nohalt:

;=====inc score
 ld a,(scoremem)
 dec a
 ld (scoremem),a
 cp 0
 jr nz,noincscore
 ld a,(score)
 inc a
 ld (score),a 
 ld hl,$ffaf
 ld c,2
 call scrolr
;=====draw a milestone
 ld de,milestone
 ld b,4
 ld hl,$ff4f
 call putsprite
noincscore:

;=====check ltraffic
 ld a,(ltraffic)
 dec a
 ld (ltraffic),a
 cp 0
 jr nz,leftdone
;=====draw car on left lane
 ld hl,leftcar
 ld (whichcomcar),hl
 ld hl,$fbdf
 ld (whichlane),hl
 ld hl,llplus 
 call comcars
 ld a,(setllane)
 ld (ltraffic),a
leftdone:

;=====check rtraffic
 ld a,(rtraffic)
 dec a
 ld (rtraffic),a
 cp 0
 jr nz,rightdone
;=====draw car on right lane
 ld hl,rightcar
 ld (whichcomcar),hl
 ld hl,$fd5f
 ld (whichlane),hl
 ld hl,rlplus 
 call comcars
 ld a,(setrlane)
 ld (rtraffic),a

rightdone:
 ld a,(l4mem)
 dec a
 ld (l4mem),a
 jp nz,mainloop
;#####========== 2
 ld a,2
 ld (l4mem),a

;=====scroll road edges
 ld hl,$fc20
 ld c,2
 call scroll 
 ld hl,$ff80
 ld c,6
 call scroll

 ld a,(l3mem)
 dec a
 ld (l3mem),a
 jp nz,mainloop
;#####========== 4
 ld a,2
 ld (l3mem),a

;=====scroll right lane
 ld hl,$ff20
 ld c,25
 call scroll

 ld a,(l2mem)
 dec a
 ld (l2mem),a
 jp nz,mainloop
;#####========== 8
 ld a,2
 ld (l2mem),a

;=====check if 'exit' is pressed
 ld a,%111111
 out (1),a
 nop
 nop
 in a,(1)
 bit 6,a
 jp z,crash

;=====draw road edges
 call makewalls

;=====move car if way=0 or way=4
 ld b,$10
 ld hl,(carpos)
 ld a,(way)
 cp 0
 jr z,carposzero
 cp 4
 jr z,carposfour
 jr done_mch
carposzero:
 call dechl
 jr done_mch
carposfour:
 call inchl
done_mch:
 ld (carpos),hl	

 ld a,(l1mem)
 dec a
 ld (l1mem),a
 jp nz,mainloop
;#####========== 16
 ld a,2
 ld (l1mem),a

;=====move car if way=1 or way=3
 ld b,$10
 ld hl,(carpos)
 ld a,(way)
 cp 1
 jr z,carposone
 cp 3
 jr z,carposthree
 jr done_mce
carposone:
 call dechl
 jr done_mce
carposthree:
 call inchl 
done_mce:
 ld (carpos),hl

 ld a,(l0mem)
 dec a
 ld (l0mem),a
 jp nz,mainloop
;#####========== xxx
 ld a,(freqB)
 ld b,a
 add a,a	;a = 2b
 add a,a	;a = 4b
 add a,b	;a = 5b
 add a,a	;a = 10b
 add a,8	;a = 10b+8,	a=18, a=28 or a=38
 ld (l0mem),a			

;=====more traffic, please
 ld a,(setllane)
 dec a
 ld (setllane),a
 add a,a
 ld (setrlane),a

 jp mainloop
;################################################
;========end of the engine=======================
;################################################


;########## call-instructios
crash:
 ld de,$0602
 ld (_curRow),de
 ld hl,gameover
 call _puts

 ld a,(cheat)
 cp 1
 jr z,nonewhs
 ld hl,highscore_slow-1
 ld a,(speedB)
 ld b,a
 call inchl
 ld b,(hl)
 ld a,(score)
 cp b
 jr c,nonewhs
 push hl
 ld de,$0503
 ld (_curRow),de
 ld hl,newhs
 call _puts
 pop hl
 ld (hl),a
nonewhs:
 call _getkey
 cp kEnter
 jr nz,nonewhs
 jp menu
exit:	
	;following routine made by Jimi Malcolm
	ld hl,_asapvar			
	rst 20h					
	rst 10h					
	ld a,b					
	ld hl,data_start-_asm_exec_ram+4
	add hl,de								
	adc a,$00							
	call _set_abs_dest_addr								
	xor a					
	ld hl,data_start		
	call _set_abs_src_addr								
	ld hl,data_end-data_start
	call _set_mm_num_bytes								
	call _mm_ldir										
	call _homeup							
	jp _clrScrn				

;=====
makewalls:
 ld de,wall
 ld hl,$fc0f
 ld b,2
 call putsprite
 ld de,wall
 ld hl,$ff2f
 ld b,2
 jp putsprite

;=====
checkkeys:
 ld a,%11111110
 out (1),a
 in a,(1)
 bit 3,a
 jr z,turnup
 bit 0,a
 ret nz

;=====
turndown:
 ld a,(way)
 cp 4
 ret z
 inc a
 ld (way),a
 ld hl,(spriteaddr)
 ld b,8
 call dechl
 ld (spriteaddr),hl
 ld a,(way2)
 ld b,$10
 add a,b
 ld (way2),a
 ld a,(setbtndelay)
 ld (btndelay),a
 ret
 
;=====
turnup:
 ld a,(way)
 cp 0						;or a??? (testaa........)
 ret z
 dec a
 ld (way),a
 ld hl,(spriteaddr)
 ld b,8
 call inchl
 ld (spriteaddr),hl
 ld a,(way2)
 ld b,$10
 sub b
 ld (way2),a
 ld a,(setbtndelay)
 ld (btndelay),a
 ret

;=====
putsprite:	
 ld a,(de)
 ld (hl),a
 call s16ba
 inc de
 djnz putsprite
 ret

;=====
s16ba:
 ld a,16
 add a,l
 ld l,a
 adc a,h
 sub l
 ld h,a
 ret

;=====
inchl:
 inc hl
 djnz inchl
 ret

;=====
dechl:
 dec hl
 djnz dechl
 ret

;=====
scroll:
 ld b,16
 or a 
scroll2: 
 dec hl 
 rl (hl) 
 djnz scroll2 
 dec c 
 jr nz,scroll 
 ret

;=====
scrolr:
 ld b,16
 or a 
scrolr2: 
 inc hl 
 rr (hl) 
 djnz scrolr2 
 dec c 
 jr nz,scrolr 
 ret

;=====
comcars:
 ld a,(hl)				;hl = rlplus/llplus, 1.byte
 dec a
 jr nz,ranstart
 ld a,4
 ld (hl),a
 inc hl					;hl = rlplus/llplus, 2.byte
 ld a,(hl)
 inc a
 and %11
 ld (hl),a
 ld b,a	
 jr yesran
ranstart:
 ld (hl),a				;hl = rlplus/llplus, 1.byte 
 ld a,r
 rra
 and %11
 ld b,a
 inc hl					;hl = rlplus/llplus, 2.byte
 inc hl					;hl = ranmem
 ld a,(hl)
 and %11
 cp b
 jr nz,noran
 ld a,(hl)
 rlca
 rlca 
 and %11
 ld b,a
 jr yesran
noran:
 ld a,(hl)
 sla a
 sla a
 or b
 ld (hl),a 
yesran:
 inc b
 ld hl,(whichlane)
 ld de,$60
findlane: 
 add hl,de
 djnz findlane
 ld de,(whichcomcar)
 ld b,4
 jp putsprite

;=====
incd9:
 ld a,7
 add a,d
 ld d,a
 ld (_penCol),de
 ret

;=====
makemaproad:
 ld b,16
 ld a,%10101010
road:
 ld (hl),a
 inc hl
 djnz road
 ret

;########## variables
carpos:
.dw $fe20
spriteaddr:
.dw straight

way:
.db 2
way2:
.db $21
rightlanedelay:
.db 1
whichcomcar:
.dw 0
whichlane:
.dw 0
ltraffic
.db 1
setllane:
.db 64
rtraffic:
.db 1
setrlane:
.db 128
btndelay:
.db 1
setbtndelay:
.db 0
l4mem:
.db 1
l3mem:
.db 1
l2mem:
.db 1
l1mem:
.db 1
l0mem:
.db 1
cheat:
.db 0
scoremem:
.dw 0


score:
.db 0

;########## text
by:
.db "by Jarno Laaveri",0

mtsta:
.db "F1..start",0
mtspe:
.db "F2..speed level:",0
mtfre:
.db "F3..traf.freq:",0
mtste:
.db "F4..steering:",0
mthig:
.db "F5..exit",0

a_speed:
.db "fast  ",0
.db "med.  ",0
.db "slow  ",0

a_freq:
.db "low   ",0
.db "med.  ",0
.db "high  ",0

a_steer:
.db "tight ",0
.db "med.  ",0
.db "loose ",0

gameover:
.db "GAME OVER",0
newhs:
.db "NEW RECORD!",0

;########## lane info
;=====left
llplus:
.db 8,3
lranmem:
.db 0

;=====right
rlplus:
.db 4,3
rranmem:
.db 0

;########## sprites
hardright:
.db 0
.db %00011000
.db %00110100
.db %01101110
.db %00111101
.db %00011001
.db %00001111
.db %00000110

easyright:
.db 0
.db %00100000
.db %01111000
.db %11011110
.db %10111001
.db %01110011
.db %00011110
.db 0

straight:
.db 0
.db 0
.db %01111110
.db %01011001
.db %01011001
.db %01111110
.db 0
.db 0

easyleft:
.db 0
.db %00001110
.db %01110011
.db %10111001
.db %11011110
.db %01111000
.db %00100000
.db 0

hardleft:
.db %00000110
.db %00001111
.db %00011001
.db %00111101
.db %01101110
.db %00110100
.db %00011000
.db 0

wall:
.db %11001100
.db %11001100

milestone:
.db %00001111
.db %00001011
.db %00001101
.db %00001111

leftcar:
.db %01111110
.db %10011010
.db %10011010
.db %01111110

rightcar:
.db %11111100
.db %10110010
.db %10110010
.db %11111100

tsc:
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%10111011,%11011111,%00011110,%11101111,%01110111,%11000111,%11011101,%11000110,%11011111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%10111011,%11011110,%11111110,%11101111,%01110111,%10111011,%11011101,%11011010,%11011111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%10111011,%11011110,%11111110,%11101111,%01110111,%10111011,%11011101,%11011011,%00111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%10111011,%11011110,%10011110,%11101111,%01101111,%10000111,%10111011,%11011010,%11011111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%10000111,%10111110,%11011110,%00011110,%11101111,%01110111,%11000011,%11000110,%11011111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%01110111,%10111101,%11011101,%11011110,%10101111,%01110111,%11111011,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%01110111,%10111101,%11011101,%11011110,%10101111,%01110111,%11111011,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%01110111,%10111110,%00111101,%11011111,%00011111,%01110111,%10000111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111

;##### highscores
data_start:
highscore_slow:
.db 10
highscore_med:
.db 10
highscore_fast:
.db 10
speedB:
.db 2
freqB:
.db 2
steerB:
.db 2
data_end:

.end
