; +--------------------------+
; | GameNO1 ASM version 1.00 |
; +--------------------------+
;   This is my first game in assembly.  I know it can get repititious
; but, it was my first attempt.  Hopefully, some people will have fun and
; try to beat each other's scores.  maybe in the next version, i'll add 
; the saving of high scores.  This source is commented at every line in 
; order to help other programmers (maybe this will help more than ammuse,
; but hey, it was a first try...).  Also, if you want to copy anything, 
; please email me first to tell me, and don't just change the sprites and
; the name and call it your own.
; Enjoy!
;
; Akshay Dhalwala
; akdjr@softhome.net
; http://akdjr.freeservers.com

#include "ti86asm.inc"

;_randint equ $5544

.org _asm_exec_ram

	call _runindicoff           ; Turn off the annoying run indicator
	call _flushallmenus         ; Clear all open menus
	call _clrLCD                ; Clear the screen
TitleScreen:
	ld a,0                      ; load a with 0
	ld (_curCol),a              ; set cursor column with a
	ld a,0                      ; load a with 0
	ld (_curRow),a              ; load cursor row with a
	ld hl,titletext1            ; load hl with titletext1
	call _puts                  ; display the string at cursor position
	ld a,1                      ; Increment row, and display text
	ld (_curRow),a              ;         =======
	ld hl,titletext2            ;            |
	call _puts                  ;            V
	ld a,2                      ; 
	ld (_curRow),a              ; 
	ld hl,titletext3            ; 
	call _puts                  ; 
	ld a,3                      ; 
	ld (_curRow),a              ; 
	ld hl,titletext4            ; and so on....
	call _puts                  ; 
	ld a,4                      ; 
	ld (_curRow),a              ; 
	ld hl,titletext5            ; 
	call _puts                  ; 
	ld a,5                      ; 
	ld (_curRow),a              ; 
	ld hl,titletext6            ; 
	call _puts                  ; 
	ld a,6                      ; 
	ld (_curRow),a              ; 
	ld hl,titletext7            ; 
	call _puts                  ; and so on.....

MNULOOP:
	call _getkey                ; pause,read a keypress from the keyboard
	cp kF1                      ; is it F1?
	jp z,StartGame              ; if so, start the game
	cp kF5                      ; is it F5?
	jp z,ExitProgA              ; if so, leave the program
	jp MNULOOP                  ; neither key was pressed, check again
StartGame:
	call _clrLCD                ; clear the screen
	ld hl,Level1                ; load hl with tilemap Level1
	call DrawMap                ; Draw the map
	ld a,1                      ; load player x coordinate
	ld (px),a                   ; with 1
	ld a,2                      ; load player y coordinate
	ld (py),a                   ; with 1 too
	ld a,(py)                   ; \
	ld d,a                      ;  \
	ld a,(px)                   ;  |-> Display player sprite
	ld e,a                      ;  /
	ld hl,player                ; /
	call GridPutSprite          ; Show the sprite
	ld a,6                      ; load money x coordinate
	ld (my),a                   ; with 6
	ld a,14                     ; load money y coordinate
	ld (mx),a                   ; with 14
	ld a,(my)                   ; \
	ld d,a                      ;  \
	ld a,(mx)                   ;  |-> Display money sprite
	ld e,a                      ;  /
	ld hl,money                 ; /
	call GridPutSprite          ; show the sprite
	ld hl,0
	ld (score),hl               ; set score to 0
	ld a,1
	ld (putflag),a              ; don't try to put another money sprite
	ld a,25
	ld (timercount),a           ; load timer count with 25.
	ld (timercount2),a          ; timercount helps slow down the timer
	ld a,60
	ld (timer),a                ; load timer with 60
	ld a,1
	ld (quitflag),a             ; don't want to quit yet...
	ld a,15
	ld (dcnt),a

MainLoop:
	call _getky                 ; read a key from the keyboard
	cp K_DOWN                   ; is it down?
	call z,MoveDown             ; if so, move down
	cp K_LEFT                   ; is it left?
	call z,MoveLeft             ; if so, move left
	cp K_RIGHT                  ; is it right?
	call z,MoveRight            ; if so, move right
	cp K_UP                     ; is it up?
	call z,MoveUp	            ; if so, move up
	ld a,%111111                ; load a with bitmask for exit key
	out (1),a                   ; send bitmask out keyboard port
	nop                         ; allow port to recover
	in a,(1)                    ; read in from port into a
	bit 6,a                     ; test bit 6 (exit)
	jr z,ExitTime               ; if it is exit, quit game
	call HasGotten              ; test if player is on money
	call DoTimer                ; implement the timer
	call UpdateStats            ; update score and time
	ld a,(quitflag)             ; load a with quitflag
	cp 5                        ; if it is 5
	jr z,ExitProg               ; quit current game
	jr MainLoop                 ; no keys, go back up to mainloop

ExitTime:
	call Pause                  ; Pause the game
	call _clrLCD                ; clear the screen
	jr ExitProg                 ; goto exit game preliminaries

ExitProg:
	call _clrLCD                ; clear the screen
	ld a,3                      ; load cursor row
	ld (_curRow),a              ; with 3
	ld a,0                      ; load cursor column
	ld (_curCol),a              ; with 0
	ld hl,scoretext             ; load hl with score text
	call _puts                  ; display the text
	ld a,7						; load cursor column
	ld (_curCol),a				; with 7
	ld hl,(score)				; load hl with current score
	call DispHL					; show the number
	call Pause					; pause the action =)
	call _clrLCD				; clear the screen
	jp TitleScreen				; go back to title screen
ExitProgA:
	call _clrScrn				; clear everything
	ret							; lets get out of here...

MoveDown:
	ld a,(py)					; load a with player y
	cp 6						; is it six?
	jr z,DEND					; player is at bottom, don't move
	call ErasePlayer			; player can move, erase him
	ld a,(py)					; load a with player y
	inc a						; increment it
	ld (py),a					; load player y with a
	call DrawPlayer				; draw the player
DEND:
	ret							; sub routine is done, return

MoveUp:
	ld a,(py)					; load a with player y
	cp 2						; is it two?
	jr z,UEND					; player is at the top, don't move
	call ErasePlayer			; player can move, erase him
	ld a,(py)					; load a with player y
	dec a						; decrement it
	ld (py),a					; load player y with a
	call DrawPlayer				; draw the player
UEND:
	ret							; sub routine is done, return

MoveRight:
	ld a,(px)					; load a with player x
	cp 14						; is it fourteen?
	jr z,REND					; player is at max right, don't move
	call ErasePlayer			; player can move, erase him
	ld a,(px)					; load a with player x
	inc a						; increment it
	ld (px),a					; load player x with a
	call DrawPlayer				; draw the player
REND:
	ret							; sub routine is done, return

MoveLeft:
	ld a,(px)					; load a with player x
	cp 1						; is it one?
	jr z,LEND					; player is at max left, don't move
	call ErasePlayer			; player can move, erase him
	ld a,(px)					; load a with player x
	dec a						; decrement it
	ld (px),a					; load player x with a
	call DrawPlayer				; draw the player
LEND:
	ret							; sub routine is done, return

DrawPlayer:
	ld a,(py)					; load a with player y
	ld d,a						; load d with a
	ld a,(px)					; load a with player x
	ld e,a						; load e with a
	ld hl,player				; load hl with player sprite
	call GridPutSprite			; display the sprite
	ret							; return from where we were called from

ErasePlayer:
	ld a,(py)					; same as DrawPlayer, except
	ld d,a						; that we are loading hl with
	ld a,(px)					; the grass sprite instead of player
	ld e,a
	ld hl,sprite_0
	call GridPutSprite
	ret

HasGotten:
	ld a,(mx)					; load a with money x
	ld b,a						; load b with a
	ld a,(px)					; load a with player x
	cp b						; are a and b the same?
	jp nz,NOPE					; nope, don't award points
	ld a,(my)					; load a with money y
	ld b,a						; load b with a
	ld a,(py)					; load a with player y
	cp b						; are a and b the same?
	jp nz,NOPE					; nope, don't award points
	ld hl,(score)				; player is on money, load hl with score
	inc hl						; \
	inc hl						;  \
	inc hl						;  |-> increase score by 5
	inc hl						;  /
	inc hl						; /
	ld (score),hl				; load score with hl
	ld a,5						; load a with 5
	ld (putflag),a				; allow another money to be placed
	call PlaceMoney				; place the money
NOPE:
	ret							; done with checking, return

PlaceMoney:
	ld a,(putflag)				; load a with putflag
	cp 1						; is it 1?
	jp z,PMEND					; don't put any money
	ld a,(my)
	ld d,a
	ld a,(mx)					; erase current money
	ld e,a
	ld hl,sprite_0
	call GridPutSprite
	ld a,13						; load a with 13
	call Random					; generate a random number between 0 and 13
	cp 0						; if it is 0, make it 1
	call z,IncA					; call my increment a routine
	ld (mx),a					; load money x with a
	ld a,6						; load a with 6
	call Random					; generate a random number between 0 and 6
	cp 0						; if it is 0, make it 2
	call z,IncA2				; call increment a twice routine
	cp 1						; if it is 1, make it 2
	call z,IncA					; call increment a routine
	ld (my),a					; load money y with a
	ld a,(mx)					; draw the money sprite
	ld e,a						; at location e,d
	ld a,(my)					; with mx in e and my in d
	ld d,a
	ld hl,money					; load hl with money sprite
	call GridPutSprite			; draw it to the screen
	ld a,(py)					; same as above, except with
	ld d,a						; the player sprite
	ld a,(px)
	ld e,a
	ld hl,player
	call GridPutSprite
	ld a,1						; don't allow another money
	ld (putflag),a				; to be placed
PMEND:
	ret							; we are done, so return

UpdateStats:
	ld a,0						; load a with 0
	ld (_curRow),a				; load cursor row with a
	ld a,0						; load a with 0
	ld (_curCol),a				; load cursor column with a
	ld hl,scoretext				; load hl with score text
	call _puts					; display the string
	ld a,0						; load a with 0
	ld (_curRow),a				; load cursor row with a
	ld a,7						; load a with 7
	ld (_curCol),a				; load cursor column with a
	ld hl,(score)				; load hl with current score
	call DispHL					; display the number
	ld a,0						; load a with 0
	ld (_curRow),a				; load cursor row with a
	ld a,11						; load a with 11
	ld (_curCol),a				; load cursor column with a
	ld hl,timertext				; load a with timer text
	call _puts					; display the string
	ld a,0						; load a with 0
	ld (_curRow),a				; load cursor row with a
	ld a,17						; load a with 17
	ld (_curCol),a				; load cursor column with a
	ld a,(timer)				; load a with the timer
	call DispA					; diplay the number
	ret							; we are done, so return

DoTimer:
	ld a,(timercount)			; load a with timer count
	cp 0						; is it 0?
	jp z,DT2					; if so, decrement second timer count
	dec a						; else, decrement timer count 1
	cp 0						; check if it is zero again
	jp z,DT2					; if so, decrement second timer count
	ld (timercount),a			; load timercount with a
	ret							; no need to decrement anything else, return
DT2:
	ld a,(timercount2)			; load a with timer count 2
	cp 0						; is it 0?
	jp z,DT1					; if so, decrement the real timer
	dec a						; else decrement timer count 2
	cp 0						; check if it zero again
	jp z,DT1					; if so, decrement the real timer
	ld (timercount2),a			; load timercount2 with a
	ret							; no need to decrement anything else, return
DT1:
	ld a,(timer)				; load a with the timer
	dec a						; decrement it
	cp 0						; is it zero?
	jp z,DTENDG					; player is out of timer
	ld (timer),a				; load timer with a
	;ld a,(dcnt)
	;dec a
	call GoAway
	ld a,25						; load a with 25
	ld (timercount),a			; restore timer count
	ld (timercount2),a			; and timer count 2
;	ld b,25
;DTST:
;	halt
;	djnz DTST
	ret
DTENDG:
	ld a,5						; player ran out of timer
	ld (quitflag),a				; quit the game
DTENDGG:
	ret							; nothing happened, so return

IncA3:
	inc a						; increment a three times
	inc a
	inc a
	ret							; we are done, so return

IncA2:
	inc a						; increment a two times
	inc a
	ret							; we are done, so return

IncA:
	inc a						; increment a one time
	ret							; we are done, so return

Pause:
	ld a,7						; load a with 7
	ld (_curRow),a				; load cursor row with a
	ld a,0						; load a with 0
	ld (_curCol),a				; load cursor column with a
	ld hl,entertext				; load hl with enter text
	call _puts					; display the string
PLOOP:
	call _getkey				; pause and get a key from the keyboard
	cp kEnter					; is it Enter?
	jr nz,PLOOP					; it isn't, so check another key
	ret							; it is enter, so return

GoAway:
	ld a,(putflag)
	cp 1
	jp nz,GAEND
	ld a,(dcnt)
	cp 0
	jp z,GAPLACE
	dec a
	jp GAEND
GAPLACE:
	ld a,5
	ld (putflag),a
	ld a,15
	ld (dcnt),a
GAEND:
	ret

;Random:
;	call _SetXXOP1 ;OP1=a (lower bound)
;	ld a,b
;	call _SetXXOP2 ;OP2=a (upper bound)
;	call _randint ;get random number between OP1 and OP2
;	call _CONVOP1 ;put random number in a and return
;	ret

Level1:
	.db 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2		; 2- blank tile
	.db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1		; 1- block tile
	.db 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1		; 0- grass tile
	.db 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	.db 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	.db 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	.db 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	.db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

#include "drawmap.asm"			; David Phillip's drawmap and gridputsprite
#include "dispahl.asm"			; ACZ's disp a or hl routine
#include "random.asm"			; Jimmy Mardel's random number routine

player:
	.db %00011000
	.db %00100100
	.db %00011000
	.db %00111100
	.db %01011010
	.db %00011000
	.db %00100100
	.db %01100110

money:
	.db %00101000
	.db %01111110
	.db %10101000
	.db %10101000
	.db %01111100
	.db %00101010
	.db %11111100
	.db %00101000


;vars
px:						; player x
.db 0
py:						; player y
.db 0
mx:						; money x
.db 0
my:						; money y
.db 0
score:					; current score
.dw 0
putflag:				; flag for placing money, 1-don't place, 5-place
.db 0
timercount:				; part of timer
.db 0
timercount2:			; part of timer
.db 0
timer:					; actual timer
.db 0
quitflag:				; flag for quitting, 1-don't quit, 5-quit
.db 0
dcnt:
.db 0

scoretext:
.db "Score:",0
timertext:
.db "Time:",0
entertext:
.db "Press Enter...",0
titletext1:
.db " Welcome GameNO1 ASM ",0
titletext2:
.db "---------------------",0
titletext3:
.db "   F1- Start Game    ",0
titletext4:
.db "   F5- Quit Game     ",0
titletext5:
.db "---------------------",0
titletext6:
.db "Coded By: Akshay D.  ",0
titletext7:
.db "akdjr.freeservers.com",0

Sprites:						; sprites for the tilemap

sprite_0:
	.db %10101010
	.db %00000000
	.db %01010101
	.db %00000000
	.db %10101010
	.db %00000000
	.db %01010101
	.db %00000000

sprite_1:
	.db %11111111
	.db %10000001
	.db %10100101
	.db %10000001
	.db %10000001
	.db %10100101
	.db %10000001
	.db %11111111

sprite_2:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

; and we are done!!

.end
