#include "ti86asm.inc"

_asapvar	    	=$d6fc
_set_abs_src_addr	=$4647
_set_abs_destaddr	=$5285
_set_mm_num_bytes	=$464f
_mm_ldir	    	=$52ed

inithlp =	$f000
round =		$f001
results =   $f002
cl_v =		$f008
vert =		$f009
horz =		$f00a
hdelay =	$f00b
vdelay =	$f00c

.org _asm_exec_ram

 call _runindicoff
start_prog:
 call _clrScrn

;reset variables

 ld hl,$f000
 xor a
 ld (hl),a
 ld de,$f001
 ld bc,15
 ldir
 ld a,6
 ld (cl_v),a

; draw menu

 ld de,taulu2
 call draw_taulu

 ld hl,txt
 set 3,(iy+5)
 ld bc,$0500
 ld (_curRow),bc
 call _puts
 res 3,(iy+5)
 ld bc,$0921
 ld (_penCol),bc
 call _vputs
 ld bc,$0607
 ld (_curRow),bc
 call _putps

 ld a,10
 ld (_curCol),a 
 ld hl,highscore+1
 call _putps
 ld hl,highscore
 ld a,(hl)
 ld bc,$0e07
 call findscore	;for some reason _dispAHL doesn't
			;work, so I have to use this routine
			;to print highscore. please email me
			;if you know why is that.

draw_initials:
 ld bc,$0904
 ld (_curRow),bc
 ld hl,initials
 call _puts

;run menu
 
menuloop:
 halt
 call _getky
 cp K_EXIT
 jp z,exit
 cp K_RIGHT
 jr nz,mno_right
 ld a,(inithlp)
 inc a
 cp 3
 jr nz,init_nextj
 xor a
init_nextj:
 ld (inithlp),a
 xor a
mno_right:
 push af
 ld hl,initials
 ld a,(inithlp)
 ld c,a
 ld b,0
 add hl,bc
 pop af
 cp K_UP
 jr nz,no_init_up
 ld a,(hl)
 inc a
 cp 214
 jr nz,n214u
 inc a
n214u:
 ld (hl),a
 xor a
no_init_up:
 cp K_DOWN
 jr nz,no_init_down
 ld a,(hl)
 dec a

 ld (hl),a
 xor a
no_init_down:
 cp K_ENTER
 jr nz,draw_initials

;draw screen

 call _clrScrn
 ld de,taulu2
 call draw_taulu
 
 ld hl,$fc00
 ld b,64
vert_line:
 ld a,%00000001
 ld (hl),a
 ld de,16
 add hl,de
 djnz vert_line

 ld hl,$fc70
 ld b,15
horz_line:
 ld a,-1
 ld (hl),a
 inc hl
 djnz horz_line

 ld de,cursor_h
 ld hl,$fc21
 ld b,5
 call putsprite
 ld hl,$fc90
 ld b,7
 call putsprite

;the game

mainloop:
 ld a,(hdelay)
 inc a
 cp 36
 jr nz,no_horz

 ld a,(horz)
 or a
 jr nz,sright

;====
sleft:
 ld b,5
 ld hl,$fc6f
sleft1:
 push bc
 ld b,15
 or a
sleft2:
 rl (hl)
 dec hl
 djnz sleft2

 ld a,0
 jr nc,sleft3
 inc a
sleft3:
 push hl
 ld de,15
 add hl,de
 or (hl)
 ld (hl),a
 pop hl
 dec hl
 pop bc
 djnz sleft1
 xor a
 jr no_horz

;====
sright:
 ld b,5
 ld hl,$fc21
sright1:
 push bc
 ld b,15
 or a
sright2:
 rr (hl)
 inc hl
 djnz sright2

 ld a,0
 jr nc,sright3
 ld a,%10000000
sright3:
 push hl
 ld de,14
 sbc hl,de
 or (hl)
 ld (hl),a
 pop hl
 inc hl
 pop bc
 djnz sright1
 xor a

no_horz:
 ld (hdelay),a
 ld a,(vdelay)
 inc a
 cp 100
 jr nz,no_vert

 ld a,(vert)
 or a
 jr nz,sdown

;====
sup:
 ld hl,$fc90
 call to_vopc
 ld hl,$fc80
 ld a,(hl)
 ld hl,$fff0
 ld (hl),a
 ld hl,$fc70
 call from_vopc

 ld a,(cl_v)
 dec a
 cp 1
 jr nz,clv_n57
 ld a,57
 jr clv_n57

;====
sdown:
 ld hl,$fc80
 call to_vopc
 ld a,(hl)
 ld hl,$fc80
 ld (hl),a
 call from_vopc

 ld a,(cl_v)
 inc a
 cp 58
 jr nz,clv_n57
 ld a,2
clv_n57:
 ld (cl_v),a
 xor a

no_vert:
 ld (vdelay),a

;check keys
 ld a,%11111110
 out (1),a
 nop
 nop
 in a,(1)
 bit 3,a
 jr nz,nou
  xor a
  ld (vert),a
  jr kcdone
nou:
 bit 2,a
 jr nz,nor
  ld a,1
  ld (horz),a
  jr kcdone
nor:
 bit 1,a
 jr nz,nol
  xor a
  ld (horz),a
  jr kcdone
nol:
 bit 0,a
 jr nz,kcdone
  ld a,1
  ld (vert),a
kcdone:
 ld a,%10111111
 out (1),a
 nop
 nop
 in a,(1)
 bit 5,a
 jr z,shot

;end
 call _getky
 cp K_EXIT
 jp z,exit
 jp mainloop






shot:
 ld hl,$fc60
 ld b,15
checkv:
 inc hl
 ld a,(hl)
 cp 0
 jr nz,end_cv
 djnz checkv
end_cv:
 ld c,a
 ld a,(cl_v)

 ld b,a
 ld de,16
findpix:
 add hl,de
 djnz findpix

 ld b,0

 ld de,tauluX
 call draw_taulu
  ld a,(hl)
  and c
  jr z,miss
  inc b

 ld de,taulu4
 call draw_taulu
  ld a,(hl)
  and c
  jr nz,no_add8
  ld a,8
  add a,b
  ld b,a

no_add8:
 ld de,taulu3
 call draw_taulu
  ld a,(hl)
  and c
  jr nz,no_add4
  ld a,4
  add a,b
  ld b,a

no_add4:  
 ld de,taulu2
 call draw_taulu
  ld a,(hl)
  and c
  jr nz,no_add2
  inc b
  inc b

no_add2:  
 ld de,taulu1
 call draw_taulu
  ld a,(hl)
  and c
  jr nz,miss
  inc b

miss:
 ld de,taulu2
 call draw_taulu
 ld a,(hl)
 xor c
 ld (hl),a

 ld a,15
 ld (_curCol),a
 ld a,(round)
 ld hl,results
 ld e,a
 ld d,0
 add hl,de
 ld a,b
 ld (hl),a
 ld a,e
 inc a
 ld (round),a
 ld (_curRow),a
 push af
 ld l,b
 xor a
 ld h,a
 call _dispAHL
 
reload:
 call _getky
 cp K_ALPHA
 jr nz,reload
 pop af
 cp 5
 jr z,round_done
 jp mainloop
 
round_done:
 ld c,0
 ld b,5
 ld hl,results
total:
 ld a,(hl)
 add a,c
 ld c,a
 inc hl
 djnz total
 push bc
 ld a,c
 ld bc,$1207
 call findscore

 ld bc,$1306
 ld (_curRow),bc
 ld a,'='
 call _putc

 call _pause

 pop bc	;c = total score
 ld a,(highscore)
 cp c
 jr nc,nonewhs
 ld a,c
 ld (highscore),a
 ld hl,initials
 ld de,highscore+2
 ld bc,3
 ldir

nonewhs:
 jp start_prog













;call instructions:

;====
exit:
 call _clrScrn
	ld hl,_asapvar	;save game -routine by Jimi Malcolm
	rst 20h				
	rst 10h			
	ld a,b		
	ld hl,highscore-_asm_exec_ram+4
	add hl,de	
	adc a,$00		
	call _set_abs_dest_addr						
	xor a			
	ld hl,highscore
	call _set_abs_src_addr
	ld hl,vopc-highscore
	call _set_mm_num_bytes
	call _mm_ldir
 jp _homeup

;====
findscore:
 ld de,0
 ld (_curRow),bc
 ld b,a
findscore2:
 inc d
 ld a,10
 cp d
 jr nz,no10
 inc e
 ld d,0
no10:
 djnz findscore2
 ld a,e
 add a,48
 call _putc
 ld a,d
 add a,48
 call _putc
 ret

;====
to_vopc:
 ld b,55
 ld de,vopc
to_vopc2:
 ld a,(hl)
 ld (de),a
 call s16ba
 inc de
 djnz to_vopc2
 ret

;====
from_vopc:
 ld b,55
 ld de,vopc
from_vopc2:
 call s16ba
 ld a,(de)
 ld (hl),a
 inc de
 djnz from_vopc2
 ret

;=====
putsprite:
 ld a,(de)
 ld (hl),a
 call s16ba
 inc de
 djnz putsprite
 ret

;=====
s16ba:
 ld a,$10
 add a,l	
 ld l,a	
 adc a,h	
 sub l	
 ld h,a	
 ret

;=====
draw_taulu:
 push hl
 push bc
 ld hl,$fd36
 ld b,16
dtl1:
 push bc
 ld b,4
dtl2:
 ld a,(de)
 ld (hl),a
 inc hl
 inc de
 djnz dtl2
 ld bc,12
 add hl,bc
 pop bc
 djnz dtl1
 dec de
 dec de
 dec de
 dec de
 ld b,16
dtl1b:
 push bc
 ld b,4
dtl2b:
 ld a,(de)
 ld (hl),a
 inc hl
 inc de
 djnz dtl2b
 ld bc,12
 add hl,bc
 ex de,hl
 ld bc,8
 sbc hl,bc
 ex de,hl
 pop bc
 djnz dtl1b
 pop bc
 pop hl
 ret

cursor_h:
.db %11111110
.db %11111110
.db %01111100
.db %00111000
.db %00010000

cursor_v:
.db %00110001
.db %00111001
.db %00111101
.db %00111111
.db %00111101
.db %00111001
.db %00110001

txt:
.db 15,158,'r',158,"ng r",187,"ng",192,0
.db "Jarno Laaveri 2001",0
.db 3,"hs:"


tauluX:
  .db %00000000,%00001111,%11110000,%00000000
  .db %00000000,%01111111,%11111110,%00000000
  .db %00000001,%11111111,%11111111,%10000000
  .db %00000011,%11111111,%11111111,%11000000  
  .db %00000111,%11111111,%11111111,%11100000 
  .db %00001111,%11111111,%11111111,%11110000 
  .db %00011111,%11111111,%11111111,%11111000   
  .db %00111111,%11111111,%11111111,%11111100   
  .db %00111111,%11111111,%11111111,%11111100   
  .db %01111111,%11111111,%11111111,%11111110   
  .db %01111111,%11111111,%11111111,%11111110   
  .db %01111111,%11111111,%11111111,%11111110   
  .db %11111111,%11111111,%11111111,%11111111   
  .db %11111111,%11111111,%11111111,%11111111   
  .db %11111111,%11111111,%11111111,%11111111   
  .db %11111111,%11111111,%11111111,%11111111    

taulu1:
  .db %00000000,%00001111,%11110000,%00000000
  .db %00000000,%01110000,%00001110,%00000000
  .db %00000001,%10001111,%11110001,%10000000   
  .db %00000010,%01110000,%00001110,%01000000   
  .db %00000100,%11001111,%11110011,%00100000   
  .db %00001001,%00110000,%00001100,%10010000   
  .db %00010010,%01000111,%11100010,%01001000   
  .db %00100100,%10011000,%00011001,%00100100   
  .db %00101001,%01100111,%11100110,%10010100   
  .db %01011010,%10011000,%00011001,%01011010   
  .db %01010100,%10100111,%11101101,%00101010   
  .db %01010101,%01101100,%00010010,%10101010   
  .db %10101001,%01011011,%11011010,%10010101   
  .db %10101010,%10100100,%00101101,%01010101   
  .db %10101010,%10101001,%10010101,%01010101   
  .db %10101010,%10101010,%01010101,%01010101   

taulu2:
  .db %00000000,%00001111,%11110000,%00000000
  .db %00000000,%01111111,%11111110,%00000000
  .db %00000001,%11110000,%00001111,%10000000   
  .db %00000011,%10000000,%00000001,%11000000   
  .db %00000111,%00001111,%11110000,%11100000   
  .db %00001110,%00111111,%11111100,%01110000   
  .db %00011100,%01111000,%00011110,%00111000   
  .db %00111000,%11100000,%00000111,%00011100   
  .db %00110001,%10000111,%11100001,%10001100   
  .db %01100011,%00011111,%11111000,%11000110   
  .db %01100111,%00111000,%00011100,%11100110   
  .db %01100110,%01110000,%00001110,%01100110   
  .db %11001110,%01100011,%11000110,%01110011   
  .db %11001100,%11000111,%11100011,%00110011   
  .db %11001100,%11001110,%01110011,%00110011   
  .db %11001100,%11001100,%00110011,%00110011 

taulu3:
  .db %00000000,%00001111,%11110000,%00000000
  .db %00000000,%01111111,%11111110,%00000000
  .db %00000001,%11111111,%11111111,%10000000   
  .db %00000011,%11111111,%11111111,%11000000   
  .db %00000111,%11110000,%00001111,%11100000   
  .db %00001111,%11000000,%00000011,%11110000   
  .db %00011111,%10000000,%00000001,%11111000   
  .db %00111111,%00000000,%00000000,%11111100   
  .db %00111110,%00000111,%11100000,%01111100   
  .db %01111100,%00011111,%11111000,%00111110   
  .db %01111000,%00111111,%11111100,%00011110   
  .db %01111000,%01111111,%11111110,%00011110   
  .db %11110000,%01111100,%00111110,%00001111   
  .db %11110000,%11111000,%00011111,%00001111   
  .db %11110000,%11110000,%00001111,%00001111   
  .db %11110000,%11110000,%00001111,%00001111 

taulu4:
  .db %00000000,%00001111,%11110000,%00000000
  .db %00000000,%01111111,%11111110,%00000000
  .db %00000001,%11111111,%11111111,%10000000   
  .db %00000011,%11111111,%11111111,%11000000   
  .db %00000111,%11111111,%11111111,%11100000   
  .db %00001111,%11111111,%11111111,%11110000   
  .db %00011111,%11111111,%11111111,%11111000   
  .db %00111111,%11111111,%11111111,%11111100   
  .db %00111111,%11111000,%00011111,%11111100   
  .db %01111111,%11100000,%00000111,%11111110   
  .db %01111111,%11000000,%00000011,%11111110   
  .db %01111111,%10000000,%00000001,%11111110   
  .db %11111111,%10000000,%00000001,%11111111   
  .db %11111111,%00000000,%00000000,%11111111   
  .db %11111111,%00000000,%00000000,%11111111   
  .db %11111111,%00000000,%00000000,%11111111     

highscore:
.db 25,3,74,84,76
initials:
.db 64,64,64,0
vopc:

.end
