#include "asm86.h"
#include "ti86asm.inc"
#include "ti86math.inc"
#include "ti86ops.inc"

.org _asm_exec_ram

   CALL  _runindicoff
   CALL  _clrLCD
   CALL  intro
   CALL  init_menu
   CALL  paint_fifteen_picture
   CALL  paint_option
keyloop:
   CALL  GET_KEY
   CP    K_SECOND
   JR    Z, select
   CP    K_ENTER
   JR    Z, select
   CP    K_DOWN
   JP    Z, option_down
   CP    K_UP
   JP    Z, option_up
   JR    keyloop

select:
   LD    A, (option)
   CP    00h
   JP    Z, game
   CP    01h
   JR    Z, option_menu
   CP    02h
   JR    Z, exit

exit:
   CALL  _clrLCD
   RET

option_menu:
   CALL  scroll_option_menu
option_menu_keyloop:
   CALL  GET_KEY
   CP    K_EXIT
   JR    Z, back_from_options
   CP    K_SECOND
   JR    Z, back_from_options
   CP    K_ENTER
   JR    Z, back_from_options
   CP    K_DOWN
   JP    Z, option_option_down
   CP    K_UP
   JP    Z, option_option_up
   CP    K_LEFT
   JR    Z, decrease_option
   CP    K_RIGHT
   JR    Z, increase_option
   JR    option_menu_keyloop

back_from_options:
   LD    HL, $FC00
   LD    DE, option_picture
   LD    BC, 1024d
   LDIR
   CALL  fade_out
   CALL  _clrLCD
   CALL  init_menu
   CALL  paint_fifteen_picture
   CALL  paint_option
   JR    keyloop

increase_option:
   LD    A, (option_option)
   CP    00h
   JR    Z, increase_board
   CP    01h
   JR    Z, increase_speed
   CP    02h
   JR    Z, increase_shuffle

increase_board:
   LD    A, (board_option)
   INC   A
   AND   %00000001
   LD    (board_option), A
   CALL  paint_board_selection
   JR    option_menu_keyloop

increase_speed:
   LD    A, (speed_option)
   CP    02h
   JR    Z, roll_inc_speed
   INC   A
back_from_roll_inc_speed:
   LD    (speed_option), A
   CALL  paint_speed_selection
   JR    option_menu_keyloop
roll_inc_speed:
   LD    A, 00h
   JR    back_from_roll_inc_speed

increase_shuffle:
   LD    A, (shuffle_option)
   CP    02h
   JR    Z, roll_inc_shuffle
   INC   A
back_from_roll_inc_shuffle:
   LD    (shuffle_option), A
   CALL  paint_shuffle_selection
   JR    option_menu_keyloop
roll_inc_shuffle:
   LD    A, 00h
   JR    back_from_roll_inc_shuffle

decrease_option:
   LD    A, (option_option)
   CP    00h
   JR    Z, decrease_board
   CP    01h
   JR    Z, decrease_speed
   CP    02h
   JR    Z, decrease_shuffle

decrease_board:
   LD    A, (board_option)
   DEC   A
   AND   %00000001
   LD    (board_option), A
   CALL  paint_board_selection
   JP    option_menu_keyloop

decrease_speed:
   LD    A, (speed_option)
   CP    00h
   JR    Z, roll_dec_speed
   DEC   A
back_from_roll_dec_speed:
   LD    (speed_option), A
   CALL  paint_speed_selection
   JP    option_menu_keyloop
roll_dec_speed:
   LD    A, 02h
   JR    back_from_roll_dec_speed

decrease_shuffle:
   LD    A, (shuffle_option)
   CP    00h
   JR    Z, roll_dec_shuffle
   DEC   A
back_from_roll_dec_shuffle:
   LD    (shuffle_option), A
   CALL  paint_shuffle_selection
   JP    option_menu_keyloop
roll_dec_shuffle:
   LD    A, 02h
   JR    back_from_roll_dec_shuffle

paint_board_selection:
   LD    A, 8d
   LD    (tempbyte), A
paint_board_selection_scrolloop:
   LD    A, (board_option)
   SLA   A
   LD    HL, board_option_pointers
   LD    D, 00h
   LD    E, A
   ADD   HL, DE
   LD    E, (HL)
   INC   HL
   LD    D, (HL)
   LD    HL, $FC00 + (16d * 16d) + 7d

   LD    C, 13d
paint_board_selection_yloop:
   LD    B, 8d
paint_board_selection_xloop:
   LD    A, (DE)
   CPL
   RRCA
   CPL
   LD    (DE), A

   LD    A, (HL)
   RRA
   LD    (HL), A

   INC   DE
   INC   HL
   DJNZ  paint_board_selection_xloop

   PUSH  DE
   LD    DE, 8d
   ADD   HL, DE
   POP   DE

   DEC   C
   JR    NZ, paint_board_selection_yloop

   CALL  paint_option_pause

   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, paint_board_selection_scrolloop
   RET

paint_speed_selection:
   LD    A, 8d
   LD    (tempbyte), A
paint_speed_selection_scrolloop:
   LD    A, (speed_option)
   SLA   A
   LD    HL, speed_option_pointers
   LD    D, 00h
   LD    E, A
   ADD   HL, DE
   LD    E, (HL)
   INC   HL
   LD    D, (HL)
   LD    HL, $FC00 + (30d * 16d) + 7d

   LD    C, 13d
paint_speed_selection_yloop:
   LD    B, 8d
paint_speed_selection_xloop:
   LD    A, (DE)
   CPL
   RRCA
   CPL
   LD    (DE), A

   LD    A, (HL)
   RRA
   LD    (HL), A

   INC   DE
   INC   HL
   DJNZ  paint_speed_selection_xloop

   PUSH  DE
   LD    DE, 8d
   ADD   HL, DE
   POP   DE

   DEC   C
   JR    NZ, paint_speed_selection_yloop

   CALL  paint_option_pause

   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, paint_speed_selection_scrolloop
   RET

paint_shuffle_selection:
   LD    A, 8d
   LD    (tempbyte), A
paint_shuff_selection_scrolloop:
   LD    A, (shuffle_option)
   SLA   A
   LD    HL, shuffle_option_pointers
   LD    D, 00h
   LD    E, A
   ADD   HL, DE
   LD    E, (HL)
   INC   HL
   LD    D, (HL)
   LD    HL, $FC00 + (44d * 16d) + 7d

   LD    C, 13d
paint_shuffle_selection_yloop:
   LD    B, 8d
paint_shuffle_selection_xloop:
   LD    A, (DE)
   CPL
   RRCA
   CPL
   LD    (DE), A

   LD    A, (HL)
   RRA
   LD    (HL), A

   INC   DE
   INC   HL
   DJNZ  paint_shuffle_selection_xloop

   PUSH  DE
   LD    DE, 8d
   ADD   HL, DE
   POP   DE

   DEC   C
   JR    NZ, paint_shuffle_selection_yloop

   CALL  paint_option_pause

   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, paint_shuff_selection_scrolloop
   RET

option_option_down:
   LD    A, (option_option)
   CP    02h
   JP    Z, option_menu_keyloop
   CALL  paint_option_selection
   LD    A, (option_option)
   INC   A
   LD    (option_option), A
   CALL  paint_option_selection
   JP    option_menu_keyloop

option_option_up:
   LD    A, (option_option)
   CP    00h
   JP    Z, option_menu_keyloop
   CALL  paint_option_selection
   LD    A, (option_option)
   DEC   A
   LD    (option_option), A
   CALL  paint_option_selection
   JP    option_menu_keyloop

scroll_option_menu:
   LD    A, 8d
   LD    (tempbyte), A
scroll_option_menu_loop2:
   LD    HL, $FC00
   LD    DE, option_picture
   LD    BC, 1024d
scroll_option_menu_loop:
   LD    A, (DE)
   RRCA
   LD    (DE), A
   LD    A, (HL)
   RRA
   LD    (HL), A
   INC   HL
   INC   DE

   DEC   BC
   LD    A, B
   OR    C
   CP    00h
   JR    NZ, scroll_option_menu_loop

   CALL  paint_option_pause

   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, scroll_option_menu_loop2

   RET

paint_option_selection:
   LD    A, (option_option)
   CP    00h
   JR    Z, paint_option_selection1
   CP    01h
   JR    Z, paint_option_selection2
   CP    02h
   JR    Z, paint_option_selection3

paint_option_selection1:
   LD    HL, $FC00 + (15d * 16d)
   CALL  paint_option_selection_all
   RET

paint_option_selection2:
   LD    HL, $FC00 + (29d * 16d)
   CALL  paint_option_selection_all
   RET

paint_option_selection3:
   LD    HL, $FC00 + (43d * 16d)
   CALL  paint_option_selection_all
   RET

paint_option_selection_all:
   LD    BC, 15d * 16d
paint_option_selection_all_loop:
   LD    A, (HL)
   CPL
   LD    (HL), A
   INC   HL

   DEC   BC
   LD    A, B
   OR    C
   CP    00h
   JR    NZ, paint_option_selection_all_loop
   RET

option_down:
   LD    A, (option)
   CP    02h
   JP    Z, keyloop
   INC   A
   LD    (option), A
   CALL  paint_option
   JP    keyloop

option_up:
   LD    A, (option)
   CP    00h
   JP    Z, keyloop
   DEC   A
   LD    (option), A
   CALL  paint_option
   JP    keyloop

paint_fifteen_picture:
   LD    HL, 384d
   LD    (tempword2), HL
   LD    DE, fifteen_picture
   LD    (tempword), DE
   
   LD    A, 24d
   LD    (tempbyte), A
paint_fifteen_picture_loop:
   LD    HL, (tempword)
   LD    DE, $FC00
   LD    BC, 16d
   LDIR
   LD    (tempword), HL
   LD    HL, $FC00
   LD    DE, $FC00 + 16d
   LD    BC, (tempword2)
   LDIR
   CALL  sub_tempword2_16
   CALL  paint_option_pause
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, paint_fifteen_picture_loop
   RET

sub_tempword2_16:
   LD    HL, (tempword2)
   LD    DE, 16d
   SBC   HL, DE
   LD    (tempword2), HL
   RET

paint_option:
   LD    A, (option)
   SLA   A
   LD    D, 00h
   LD    E, A
   LD    HL, option_pointers
   ADD   HL, DE
   LD    E, (HL)
   INC   HL
   LD    D, (HL)

   LD    (option_pointer), DE    

   LD    A, 8d
   LD    (tempbyte), A

paint_option_loop2:
   LD    HL, $FC00 + (30d * 16d)          ; DE = data, HL = skrm
   LD    DE, (option_pointer)
   LD    BC, 448d
paint_option_loop:
   LD    A, (DE)
   RRCA
   LD    (DE), A
   LD    A, (HL)
   RRA
   LD    (HL), A
   INC   HL
   INC   DE

   DEC   BC
   LD    A, B
   OR    C
   CP    00h
   JR    NZ, paint_option_loop

   CALL  paint_option_pause

   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, paint_option_loop2

   RET

paint_option_pause:
   LD    B, 15d
paint_option_pause_loop:
   HALT
   DJNZ  paint_option_pause_loop
   RET

paint_congrats:
   LD    HL, $FC01 + (19d * 16d)
   LD    DE, text_congratulations
   LD    C, 20d
paint_congrats_yloop:
   LD    B, 14d
paint_congrats_xloop:
   LD    A, (DE)
   LD    (HL), A
   INC   DE
   INC   HL
   DJNZ  paint_congrats_xloop
   INC   HL
   INC   HL
   DEC   C
   JR    NZ, paint_congrats_yloop
   RET

fade_out:                        ; Now we have arrived to the greatest
   LD    A, 64d                  ; part of this game the splendid effect
   LD    (tempbyte), A              ; called fade_out. If you play the game
fade_out_loop:                   ; you'll notice which effect I'm talking
   LD    HL, $FC00               ; about. I've decided to make two routines
   LD    DE, $FC10               ; inside the fade_out routine. One scrolling
   CALL  fade_up                 ; a collumn up, and one scrolling down.
   LD    HL, $FFF0               ; The routine takes two parameters, one 
   LD    DE, $FFFF               ; where to copy from and one to copy to
   CALL  fade_down               ; Both are stored in HL and DE. The one
   LD    HL, $FC02               ; scrolling up moves from DE -> HL.
   LD    DE, $FC12               ; This is also a little stupid way to solve
   CALL  fade_up                 ; the use of code-lines. See I could use
   LD    HL, $FFEE               ; a loop and increase HL and DE instead
   LD    DE, $FFFD               ; of calling routines 16 times, but I just
   CALL  fade_down               ; shitted in it.
   LD    HL, $FC04
   LD    DE, $FC14
   CALL  fade_up
   LD    HL, $FFEC
   LD    DE, $FFFB
   CALL  fade_down
   LD    HL, $FC06
   LD    DE, $FC16
   CALL  fade_up
   LD    HL, $FFEA
   LD    DE, $FFF9
   CALL  fade_down
   LD    HL, $FC08
   LD    DE, $FC18
   CALL  fade_up
   LD    HL, $FFE8
   LD    DE, $FFF7
   CALL  fade_down
   LD    HL, $FC0A
   LD    DE, $FC1A
   CALL  fade_up
   LD    HL, $FFE6
   LD    DE, $FFF5
   CALL  fade_down
   LD    HL, $FC0C
   LD    DE, $FC1C
   CALL  fade_up
   LD    HL, $FFE4
   LD    DE, $FFF3
   CALL  fade_down
   LD    HL, $FC0E
   LD    DE, $FC1E
   CALL  fade_up
   LD    HL, $FFE2
   LD    DE, $FFF1
   CALL  fade_down
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JP    NZ, fade_out_loop
   RET

;--------------------------------
; ROUTINE SCROLLING A COLLUMN UP
;--------------------------------

fade_up:                         ; This routine takes two parameters, where
   LD    B, 63d                  ; to copy from and where to copy to. From
fade_up_yloop:                   ; is putted in DE and to in HL. Therefore
   LD    A, (DE)                 ; DE is alwasy one screenline (16 bytes)
   LD    (HL), A                 ; higher in memory. I just copy from DE
                                 ; to HL and then jumpes down to nes row
   PUSH  DE                      ; and do the same thing on and on.
   LD    DE, 16d
   ADD   HL, DE
   POP   DE

   EX    DE, HL
   PUSH  DE
   LD    DE, 16d
   ADD   HL, DE
   POP   DE
   EX    DE, HL

   DJNZ  fade_up_yloop
   LD    A, 00h
   LD    (HL), A
   RET

;----------------------------------
; ROUTINE SCROLLING A COLLUMN DOWN
;----------------------------------

fade_down:                       ; Like the routine above, this is working
   LD    B, 63d                  ; on the same way, from and to are stored
fade_down_yloop:                 ; in two variables. Then the routine is
   LD    A, (HL)                 ; ready to roll.
   LD    (DE), A

   PUSH  DE
   LD    DE, 16d
   SBC   HL, DE
   POP   DE

   EX    DE, HL
   PUSH  DE
   LD    DE, 16d
   SBC   HL, DE
   POP   DE
   EX    DE, HL

   DJNZ  fade_down_yloop
   LD    A, 00h
   LD    (DE), A
   RET

init_menu:
   LD    A, 00h
   LD    (option), A
   RET

intro:
   LD    DE, bearsoft            ; by line, therefore I set DE pointing at
   LD    HL, $FC00 + (12d * 16d) ; the picture and HL at screen
   LD    C, 20d                  ; I first loop through the lines down.
intro_yloop:                     ; I copy one line from picture to screen
   LD    B, 16d                  ; jump over one line by increasing both HL
intro_xloop:                     ; and DE by 16d (one line)
   LD    A, (DE)
   LD    (HL), A
   INC   HL
   INC   DE
   DJNZ  intro_xloop

   PUSH  DE                      ; This part increases HL by 16
   LD    DE, 16d                 ; I have to save DE because I'm
   ADD   HL, DE                  ; using it in the addition
   POP   DE                      ; Remember restoring it again.

   PUSH  HL                      ; This part increases DE by 16
   LD    HL, 16d                 ; Now I have to make an exchange
   ADD   HL, DE                  ; because "ADD  DE, HL" doesn,t
   EX    DE, HL                  ; exsist.
   POP   HL

   CALL  intro_pause2                   ; This is the pause between painting
                                 ; lines

   DEC   C                       ; check if the picture is done.
   JR    NZ, intro_yloop

   PUSH  DE                      ; These two routines moves both HL and
   LD    DE, 16d                 ; DE two lines up, ready to start painting
   SBC   HL, DE                  ; lines upwards.
   POP   DE

   PUSH  HL                      ; Again "SBC DE, HL" isn't a valid command
   EX    DE, HL                  ; If I switch HL and DE it will work
   LD    DE, 16d
   SBC   HL, DE
   EX    DE, HL
   POP   HL

   LD    C, 20d                  ; Make the same loop. Since the picture
intro_yloop2:                    ; is 40 lines high, I have to paint 20
   LD    B, 16d                  ; lines in each routine, the one up and
intro_xloop2:                    ; the one down
   LD    A, (DE)
   LD    (HL), A
   INC   HL
   INC   DE
   DJNZ  intro_xloop2

   PUSH  DE                      ; I decrease pointer by 48 (three lines)
   LD    DE, 48d                 ; Then I'll jump over the line I've just
   SBC   HL, DE                  ; painted, the line already painted in the
   POP   DE                      ; routine which went down, and setting 
                                 ; both pointers ready to run.
   PUSH  HL
   EX    DE, HL
   LD    DE, 48d
   SBC   HL, DE
   EX    DE, HL
   POP   HL

   CALL  intro_pause2

   DEC   C                       ; Check if I'm done painting upwards
   LD    A, C                    ; if so is the the case, I'm ready with
   CP    00h                     ; the painting BearSoft routine.
   JR    NZ, intro_yloop2

   LD    B, 00h                  ; Make a pause (3 seconds), between these
intropause:                      ; two routines.
   HALT                          ; This pause will make two HALTs 256 times.
   HALT
   DJNZ  intropause

   CALL  fade_out                ; Call the effect-routine fade_out
   CALL  _clrLCD                 ; Clear screen

   RET

intro_pause2:
   LD    B, 20d
intro_pause2_loop:
   HALT
   DJNZ  intro_pause2_loop
   RET

board_option:
   .db   00h

board_option_pointers:
   .dw   text_numbers
   .dw   text_picture

speed_option:
   .db   01h

speed_option_pointers:
   .dw   text_slow
   .dw   text_normal
   .dw   text_fast

shuffle_option:
   .db   01h

shuffle_option_pointers:
   .dw   text_bad
   .dw   text_normal
   .dw   text_good

tempbyte:
   .db   00h

tempword:
   .dw   0000h

tempword2:
   .dw   0000h

option_pointer:
   .dw   0000h

option:
   .db   00h

option_option:
   .db   00h

option_pointers:
   .dw   text_start
   .dw   text_options
   .dw   text_exit

text_congratulations:
	.db %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111110
	.db %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000010
	.db %10000000, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %11000000, %00000000, %00000000, %00000000, %00000000, %00011011
	.db %10000011, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %11000000, %00000000, %00011000, %00000000, %00000000, %00011011
	.db %10000111, %00100000, %00000000, %00000000, %00000000, %00000000, %00110000, %00000001, %10000000, %00001100, %00010000, %00000000, %00000000, %00110011
	.db %10001110, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000, %00000001, %10000000, %00001100, %00000000, %00000000, %00000000, %00110011
	.db %10011100, %00000111, %10011111, %00001110, %01111100, %00111100, %11111101, %10011001, %10001111, %00111111, %00110011, %11001111, %10001111, %10110011
	.db %10011000, %00001111, %10011111, %00111111, %01111110, %11111110, %11111001, %10011001, %10111111, %10111110, %00110111, %11001111, %10011111, %00110011
	.db %10110000, %00011101, %10111011, %01110110, %11101100, %11001100, %01100011, %00110011, %00110011, %00011000, %01101110, %11011101, %10110000, %01100011
	.db %10110000, %00011001, %10110011, %01100110, %11001101, %10001100, %01100011, %00110011, %01100011, %00011000, %01101100, %11011001, %10011110, %01100011
	.db %10110001, %11011011, %10110011, %01101110, %11000001, %10001100, %01100011, %00110011, %01100011, %00011000, %01101101, %11011001, %10000011, %00000011
	.db %10111111, %10011111, %01100110, %01111101, %10000001, %11111000, %11000011, %11100110, %01111110, %00110000, %11001111, %10110011, %01111110, %01000011
	.db %10011110, %00011110, %01100110, %01111101, %10000011, %11011000, %11000011, %11100110, %11110110, %00110000, %11001111, %00110011, %00111100, %11000011
	.db %10000000, %00000000, %00000000, %00001100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00000000, %00011000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00000001, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00000001, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111
	.db %00111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111

fifteen_picture:
	.db %00000000, %00000000, %00000000, %00000000, %00000111, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00111111, %11110000, %00011111, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00111111, %11111000, %00111111, %11111110, %00000000, %00000000, %00000110, %00001100, %10111011, %10111000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00111111, %11111100, %00111111, %11111111, %00000000, %00000000, %00000100, %11100100, %10101010, %10101000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00011111, %11111000, %00111110, %00011111, %10000000, %00000000, %00000100, %10000100, %10001000, %10101000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000011, %11000000, %00011100, %00000111, %11000000, %00000000, %00000100, %10000100, %10111011, %10111000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11100000, %00000000, %00000011, %11000000, %00000000, %00000100, %10000100, %10101010, %10101000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11100000, %00000000, %00000001, %11100000, %00000000, %00000100, %11100100, %10101010, %10101000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11110000, %00000000, %00000001, %11100000, %00000000, %00000110, %00001101, %10111011, %10111000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11110000, %00000000, %00000000, %11110001, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11110000, %00000111, %00000000, %11110001, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11111000, %00000111, %10000000, %11110001, %11111111, %11111111, %11111111, %11111111, %11111111, %11111100, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %01111000, %00000111, %11000000, %11110000, %00011100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %01111000, %00000111, %11110000, %11111000, %00001110, %00011111, %01110010, %00010000, %10000011, %11100000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %01111100, %00000011, %11111111, %11110000, %01111110, %00111111, %11110111, %00111001, %11001111, %11111000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00111100, %00000011, %11111111, %11110000, %11111110, %00111111, %11110111, %00111001, %11001111, %11111000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00111100, %00000001, %11111111, %11100000, %11111111, %00111000, %01110011, %10011100, %11101110, %00011100, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11111110, %00000001, %11101111, %11000000, %11100111, %00111000, %01110011, %10011100, %11101111, %10000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11111110, %00000000, %11100000, %00000000, %11100011, %10111000, %01110011, %10011100, %11101111, %11110000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11111110, %00000000, %11100000, %00000000, %01110001, %10011100, %00111001, %11001110, %01110111, %01111100, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11111111, %00000000, %01111111, %11111000, %01111001, %11001111, %00111001, %11101111, %01110011, %10000110, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00111111, %00000000, %11111111, %11111110, %00111111, %11001111, %11111001, %11111111, %11110011, %11111110, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00001111, %00000000, %11111111, %11111110, %00011111, %11100011, %11111100, %11111111, %11111001, %11111110, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000111, %00000000, %01111111, %11111110, %00000111, %10000000, %11110000, %01101110, %11110000, %01111100, %00000000, %00000000, %00000000

text_start:
   .db %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00000111, %11111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00001111, %11111111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00011111, %11111111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00111111, %11011111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00111111, %10011111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00111111, %00011111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %01111111, %00111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %01111111, %00111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %01111111, %10000000, %00111111, %11111001, %11111110, %00111111, %11100011, %11111111, %10000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %01111111, %11000000, %00111111, %11111001, %11111110, %00111111, %11110011, %11111111, %10000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %01111111, %11100000, %00111111, %11110001, %11111100, %01111111, %11110011, %11111111, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %01111111, %11110000, %01111111, %11110011, %11111100, %01111101, %11110111, %11111111, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00111111, %11111000, %00001111, %10000011, %11111100, %01111101, %11110000, %11111000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00011111, %11111100, %00001111, %10000111, %10111100, %11111001, %11100000, %11111000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00001111, %11111100, %00011111, %00000111, %10111100, %11111001, %11100001, %11110000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000111, %11111100, %00011111, %00001111, %00111000, %11111111, %11100001, %11110000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %11111100, %00011111, %00001111, %01111001, %11111111, %11000001, %11110000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000011, %11111001, %11111100, %00111110, %00011111, %01111001, %11111111, %10000011, %11100000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000011, %11110001, %11111100, %00111110, %00011110, %01111001, %11111111, %10000011, %11100000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000111, %11110001, %11111100, %00111110, %00111110, %11111011, %11100111, %10000011, %11100000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000111, %11110011, %11111000, %01111100, %00111111, %11111011, %11100111, %10000111, %11000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000111, %11110011, %11111000, %01111100, %01111111, %11110011, %11101111, %10000111, %11000000, %00000000, %00000000, %00000000, %00000000
   .db %00011000, %00000000, %00000000, %00000111, %11100111, %11111000, %01111100, %01111111, %11110111, %11001111, %10000111, %11000000, %00000000, %00000000, %00000000, %00011000
   .db %00011000, %00000000, %00000000, %00000111, %11111111, %11110000, %11111000, %11111111, %11110111, %11001111, %00001111, %10000000, %00000000, %00000000, %00000000, %00011000
   .db %01111110, %00000000, %00000000, %00000111, %11111111, %11100000, %11111000, %11111001, %11110111, %11011111, %00001111, %10000000, %00000000, %00000000, %00000000, %01111110
   .db %00111100, %00000000, %00000000, %00000111, %11111111, %11000000, %11111000, %11111001, %11101111, %10011111, %00001111, %10000000, %00000000, %00000000, %00000000, %00111100
   .db %00011000, %00000000, %00000000, %00000001, %11111111, %00000001, %11110001, %11110011, %11101111, %10111110, %00011111, %00000000, %00000000, %00000000, %00000000, %00011000

text_options:
   .db %00011000, %00000000, %00000000, %00000001, %11111110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00011000
   .db %00111100, %00000000, %00000000, %00000111, %11111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00111100
   .db %01111110, %00000000, %00000000, %00001111, %11111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %01111110
   .db %00011000, %00000000, %00000000, %00011111, %11111111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00011000
   .db %00011000, %00000000, %00000000, %00111111, %11111111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00011000
	.db %00000000, %00000000, %00000000, %00111111, %10011111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %01111111, %00111111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %01111111, %00111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11111111, %00111111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11111110, %00111111, %10111111, %11100111, %11111111, %01111100, %00111111, %10000111, %10001111, %00001111, %11100000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %11111110, %01111111, %00111111, %11110111, %11111111, %01111100, %01111111, %11000111, %10001111, %00111111, %11110000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11111110, %01111111, %01111111, %11110111, %11111110, %11111000, %11111111, %11001111, %10011111, %01111111, %11110000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11111100, %01111111, %01111101, %11110111, %11111110, %11111001, %11110111, %11001111, %10011110, %01111001, %11110000, %00000000, %00000000
	.db %00000000, %00000000, %00000001, %11111100, %11111110, %01111101, %11100001, %11110000, %11111001, %11110111, %11001111, %10011110, %11111001, %11100000, %00000000, %00000000
	.db %00000000, %00000000, %00000011, %11111100, %11111110, %11111001, %11100001, %11110001, %11110011, %11100111, %11011111, %10111110, %11111011, %11100000, %00000000, %00000000
	.db %00000000, %00000000, %00000011, %11111000, %11111110, %11111001, %11100011, %11100001, %11110011, %11101111, %10011111, %10111100, %11111000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000011, %11111001, %11111100, %11111011, %11000011, %11100001, %11110011, %11101111, %10011111, %10111100, %11111110, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000011, %11111001, %11111101, %11111111, %11000011, %11100011, %11100111, %11001111, %10111111, %11111100, %11111111, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000111, %11110001, %11111101, %11111111, %10000111, %11000011, %11100111, %11011111, %00111111, %11111000, %01111111, %10000000, %00000000, %00000000
	.db %00000000, %00000000, %00000111, %11110011, %11111101, %11111111, %00000111, %11000011, %11100111, %11011111, %00111111, %11111000, %00111111, %10000000, %00000000, %00000000
	.db %00000000, %00000000, %00000111, %11110011, %11111011, %11100000, %00000111, %11000111, %11001111, %10011111, %01111111, %11111000, %00011111, %10000000, %00000000, %00000000
	.db %00000000, %00000000, %00001111, %11100011, %11111011, %11100000, %00001111, %10000111, %11001111, %10111110, %01111011, %11110011, %11101111, %10000000, %00000000, %00000000
	.db %00000000, %00000000, %00001111, %11100111, %11110011, %11100000, %00001111, %10000111, %11001111, %10111110, %01111011, %11110011, %11001111, %10000000, %00000000, %00000000
   .db %00011000, %00000000, %00001111, %11100111, %11110111, %11000000, %00001111, %10001111, %10011111, %00111110, %11111011, %11110111, %11001111, %00000000, %00000000, %00011000
   .db %00011000, %00000000, %00001111, %11111111, %11100111, %11000000, %00011111, %00001111, %10011111, %01111100, %11110011, %11100111, %11011111, %00000000, %00000000, %00011000
   .db %01111110, %00000000, %00001111, %11111111, %11000111, %11000000, %00011111, %00001111, %10011111, %11111100, %11110011, %11100111, %11111110, %00000000, %00000000, %01111110
   .db %00111100, %00000000, %00000111, %11111111, %10001111, %10000000, %00011111, %00011111, %00011111, %11111001, %11110011, %11100111, %11111110, %00000000, %00000000, %00111100
   .db %00011000, %00000000, %00000011, %11111110, %00001111, %10000000, %00111110, %00011111, %00001111, %11100001, %11100011, %11000011, %11111000, %00000000, %00000000, %00011000

text_exit:
   .db %00011000, %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00011000
   .db %00111100, %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00111100
   .db %01111110, %00000000, %00000000, %00000000, %00000000, %00000011, %11111111, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %01111110
   .db %00011000, %00000000, %00000000, %00000000, %00000000, %00000011, %11111111, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00011000
   .db %00011000, %00000000, %00000000, %00000000, %00000000, %00000011, %11111111, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00011000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000011, %11111111, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000111, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000111, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000111, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00001111, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00001111, %11110000, %00111110, %01111001, %11110111, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00001111, %11111111, %00111110, %11111001, %11110111, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00011111, %11111111, %00111110, %11110011, %11100111, %11111110, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00011111, %11111111, %00111111, %11100011, %11101111, %11111110, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00011111, %11111110, %00111111, %11100011, %11100001, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00111111, %11111110, %00111111, %11000111, %11000001, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00111111, %11000000, %00111111, %11000111, %11000011, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00111111, %11000000, %01111111, %10000111, %11000011, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111111, %11000000, %01111111, %10001111, %10000011, %11100000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111111, %10000000, %01111111, %10001111, %10000111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111111, %10000000, %11111111, %10001111, %10000111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %10000000, %11111111, %10011111, %00000111, %11000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %11111101, %11111111, %00011111, %00001111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %11111001, %11101111, %00011111, %00001111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %11111011, %11101111, %00111110, %00001111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11111011, %11101111, %00111110, %00011111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11110111, %11011111, %00111110, %00011111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11110111, %11011111, %01111100, %00011111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000

option_picture:
	.db %00000000, %00000011, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00001111, %11000000, %00000000, %00111100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00011111, %11100000, %00000111, %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00011101, %11101111, %11101111, %10111000, %11111000, %11111110, %01111110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00111101, %11011111, %11101111, %11111001, %11111101, %11111110, %11111110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00111101, %11011101, %11101111, %01111011, %10111101, %11011110, %11101110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00111110, %00111011, %11011101, %11101110, %01110011, %10111001, %11011110, %11101110, %01111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11110000
	.db %00111110, %00111011, %11011101, %11001110, %01110111, %10111001, %11011101, %11110000, %01111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11110000
	.db %00110000, %01111011, %10111101, %11011110, %11110111, %01111011, %11011100, %11111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000
   .db %00110000, %01110011, %10111011, %11011100, %11100111, %01111011, %10111100, %01111100, %00001000, %00100000, %00011110, %10010111, %10100101, %11101111, %00000000, %00110000
   .db %00110000, %01110111, %10111011, %10011100, %11100111, %01110011, %10111011, %10011100, %00011000, %00110001, %11010000, %10010100, %10110101, %00001000, %00000000, %00110000
   .db %00110000, %11110111, %01111011, %10011101, %11101111, %01110111, %10111011, %10111000, %00111110, %11111000, %00010000, %11110100, %10101101, %01101110, %00000000, %00110000
   .db %00110000, %01111111, %01111111, %10111111, %11001111, %11100111, %01111011, %11111000, %00011000, %00110001, %11010000, %10010111, %10100101, %00101000, %00000000, %00110000
   .db %00110000, %01111100, %01110111, %00011101, %11000111, %11000111, %01110001, %11110000, %00001000, %00100000, %00011110, %10010100, %10100101, %11101111, %00000000, %00110000
	.db %00110000, %00000000, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000
   .db %11001111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11001111
	.db %11001100, %00001111, %11111111, %11111111, %11111111, %00011111, %11111111, %11111110, %00110011, %11111111, %11111111, %11100011, %11111111, %11111111, %11111111, %11001111
	.db %11001100, %00000111, %11111111, %11111111, %11111111, %00011111, %11111111, %11111110, %00110011, %11111111, %11111111, %11100011, %11111111, %11111111, %11111111, %11001111
	.db %11001100, %01000111, %11111111, %11111111, %11111111, %00011111, %11111111, %11111110, %00110011, %11111111, %11111111, %11100011, %11111111, %11111111, %11111111, %11001111
	.db %11001100, %01000110, %00001110, %00001100, %01011001, %00011111, %11111111, %11111110, %00010010, %00100010, %00100110, %01100010, %01110000, %01100010, %11000001, %11001111
	.db %11001100, %01000100, %00000100, %00000100, %00010000, %00011111, %11111111, %11111110, %00010010, %00100010, %00000000, %00100000, %00100000, %00100000, %10000000, %11001111
	.db %11001100, %00011100, %01000100, %01000100, %00010001, %00011001, %11111111, %11111110, %00010010, %00100010, %00100010, %00100010, %00100010, %00100000, %10001000, %11001111
	.db %11001100, %00000100, %01000100, %01000100, %01110001, %00011001, %11111111, %11111110, %00000010, %00100010, %00100010, %00100010, %00100000, %00100011, %10001111, %11001111
	.db %11001100, %01000100, %01000111, %00000100, %01110001, %00011001, %11111111, %11111110, %01000010, %00100010, %00100010, %00100010, %00100000, %00100011, %11000011, %11001111
	.db %11001100, %01000100, %01000100, %00000100, %01110001, %00011111, %11111111, %11111110, %01000010, %00100010, %00100010, %00100010, %00100011, %11100011, %11100000, %11001111
	.db %11001100, %01000100, %01000100, %01000100, %01110001, %00011111, %11111111, %11111110, %01000010, %00100010, %00100010, %00100010, %00100010, %00100011, %11111000, %11001111
	.db %11001100, %01000100, %01000100, %01000100, %01110001, %00011001, %11111111, %11111110, %01100010, %00100010, %00100010, %00100010, %00100010, %00100011, %10001000, %11001111
	.db %11001100, %00000100, %00000100, %00000100, %01110000, %00011001, %11111111, %11111110, %01100010, %00000010, %00100010, %00100000, %00100000, %00100011, %10000000, %11001111
	.db %11001100, %00001110, %00001110, %01000100, %01111001, %00011001, %11111111, %11111110, %01100011, %00100010, %00100010, %00100010, %01110000, %01100011, %11000001, %11001111
   .db %11001111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11001111
	.db %00110001, %11100000, %00000000, %00000000, %00000000, %01110000, %00000000, %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111, %00110000
	.db %00110011, %11110000, %00000000, %00000000, %00000000, %01110000, %00000000, %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111, %00110000
	.db %00110011, %10110000, %00000000, %00000000, %00000000, %01110000, %00000000, %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111, %00110000
	.db %00110011, %10110111, %01100011, %11100011, %11100011, %01110000, %00000000, %00000000, %00000000, %00011110, %11001111, %10011101, %01110110, %01100011, %11100111, %00110000
	.db %00110011, %10000111, %11110111, %11110111, %11110111, %11110000, %00000000, %00000000, %00000000, %00011110, %11011111, %11011111, %01111111, %11110111, %11110111, %00110000
	.db %00110011, %11000111, %01110111, %01110111, %01110111, %01110011, %00000000, %00000000, %00000000, %00011110, %11011101, %11011111, %01110111, %01110111, %01110111, %00110000
	.db %00110001, %11100111, %01110111, %11110111, %11110111, %01110011, %00000000, %00000000, %00000000, %00011111, %11011101, %11011100, %01110111, %01110111, %01110111, %00110000
	.db %00110000, %01110111, %01110111, %11110111, %11110111, %01110011, %00000000, %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110001, %11110111, %00110000
	.db %00110011, %01110111, %01110111, %00000111, %00000111, %01110000, %00000000, %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110111, %11110111, %00110000
	.db %00110011, %01110111, %01110111, %01110111, %01110111, %01110000, %00000000, %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110111, %01110111, %00110000
	.db %00110011, %01110111, %01110111, %01110111, %01110111, %01110011, %00000000, %00000000, %00000000, %00011001, %11011101, %11011100, %01110111, %01110111, %01110111, %00110000
	.db %00110011, %11110111, %11110111, %11110111, %11110111, %11110011, %00000000, %00000000, %00000000, %00011001, %11011111, %11011100, %01110111, %01110111, %11110111, %00110000
	.db %00110001, %11100111, %01100011, %11100011, %11100011, %01110011, %00000000, %00000000, %00000000, %00011001, %11001111, %10011100, %01110111, %01110011, %01110111, %00110000
	.db %00110000, %00000111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000
	.db %00110001, %11100000, %00000000, %00000011, %10011101, %11000000, %00000000, %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111, %00110000
	.db %00110011, %11110111, %00000000, %00000111, %10111101, %11000000, %00000000, %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111, %00110000
	.db %00110011, %10110111, %00000000, %00000110, %00110001, %11000000, %00000000, %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111, %00110000
	.db %00110011, %10110111, %01100111, %01110111, %10111101, %11001111, %10000000, %00000000, %00000000, %00011110, %11001111, %10011101, %01110110, %01100011, %11100111, %00110000
	.db %00110011, %10000111, %11110111, %01110111, %10111101, %11011111, %11000000, %00000000, %00000000, %00011110, %11011111, %11011111, %01111111, %11110111, %11110111, %00110000
	.db %00110011, %11000111, %01110111, %01110111, %00111001, %11011101, %11001100, %00000000, %00000000, %00011110, %11011101, %11011111, %01110111, %01110111, %01110111, %00110000
	.db %00110001, %11100111, %01110111, %01110111, %00111001, %11011111, %11001100, %00000000, %00000000, %00011111, %11011101, %11011100, %01110111, %01110111, %01110111, %00110000
	.db %00110000, %01110111, %01110111, %01110111, %00111001, %11011111, %11001100, %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110001, %11110111, %00110000
	.db %00110011, %01110111, %01110111, %01110111, %00111001, %11011100, %00000000, %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110111, %11110111, %00110000
	.db %00110011, %01110111, %01110111, %01110111, %00111001, %11011101, %11000000, %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110111, %01110111, %00110000
	.db %00110011, %01110111, %01110111, %01110111, %00111001, %11011101, %11001100, %00000000, %00000000, %00011001, %11011101, %11011100, %01110111, %01110111, %01110111, %00110000
	.db %00110011, %11110111, %01110111, %11110111, %00111001, %11011111, %11001100, %00000000, %00000000, %00011001, %11011111, %11011100, %01110111, %01110111, %11110111, %00110000
	.db %00110001, %11100111, %01110011, %01110111, %00111001, %11001111, %10001100, %00000000, %00000000, %00011001, %11001111, %10011100, %01110111, %01110011, %01110111, %00110000
	.db %00110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000
	.db %00110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000
	.db %00111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11110000
	.db %00111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11110000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000

text_bad:
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111110, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111111, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %00111110, %00110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %01111111, %01111111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111100, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %00011111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %01111111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111111, %01111111, %01111111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %01111110, %00110111, %00110111

text_fast:
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %11100000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %11100000, %00000000, %00001110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10000000, %00000000, %00001110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10000111, %11000111, %11001111
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10001111, %11101111, %11101111
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %11101110, %11101110, %11101110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %11101110, %11101110, %00001110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10000011, %11100111, %10001110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10001111, %11100011, %11101110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10001110, %11100000, %11101110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10001110, %11101110, %11101110
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10001111, %11101111, %11101111
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10000110, %11100111, %11001111

text_good:
   .db %00000000, %00000000, %00000000, %00000000, %00111110, %00000000, %00000000, %00000111
   .db %00000000, %00000000, %00000000, %00000000, %01111111, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %00111110, %00111110, %00110111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %01111111, %01111111, %01111111
	.db %00000000, %00000000, %00000000, %00000000, %01110000, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %01110111, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %01111111, %01111111, %01111111, %01111111
	.db %00000000, %00000000, %00000000, %00000000, %00111011, %00111110, %00111110, %00110111

text_normal:
	.db %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00011100, %11000000, %00000000, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00011110, %11001111, %10011101, %01110110, %01100011, %11100111
	.db %00000000, %00000000, %00011110, %11011111, %11011111, %01111111, %11110111, %11110111
	.db %00000000, %00000000, %00011110, %11011101, %11011111, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00011111, %11011101, %11011100, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110001, %11110111
	.db %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110111, %11110111
	.db %00000000, %00000000, %00011011, %11011101, %11011100, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00011001, %11011101, %11011100, %01110111, %01110111, %01110111
	.db %00000000, %00000000, %00011001, %11011111, %11011100, %01110111, %01110111, %11110111
	.db %00000000, %00000000, %00011001, %11001111, %10011100, %01110111, %01110011, %01110111

text_numbers:
	.db %00000001, %11001100, %00000000, %00000000, %00011100, %00000000, %00000000, %00000000
	.db %00000001, %11001100, %00000000, %00000000, %00011100, %00000000, %00000000, %00000000
	.db %00000001, %11001100, %00000000, %00000000, %00011100, %00000000, %00000000, %00000000
	.db %00000001, %11101101, %11011101, %11011001, %10011101, %10001111, %10011101, %00111110
	.db %00000001, %11101101, %11011101, %11111111, %11011111, %11011111, %11011111, %01111111
	.db %00000001, %11101101, %11011101, %11011101, %11011101, %11011101, %11011111, %01110111
	.db %00000001, %11111101, %11011101, %11011101, %11011101, %11011111, %11011100, %01110000
	.db %00000001, %10111101, %11011101, %11011101, %11011101, %11011111, %11011100, %00111100
	.db %00000001, %10111101, %11011101, %11011101, %11011101, %11011100, %00011100, %00011111
	.db %00000001, %10111101, %11011101, %11011101, %11011101, %11011101, %11011100, %00000111
	.db %00000001, %10011101, %11011101, %11011101, %11011101, %11011101, %11011100, %01110111
	.db %00000001, %10011101, %11111101, %11011101, %11011111, %11011111, %11011100, %01111111
	.db %00000001, %10011100, %11011101, %11011101, %11011101, %10001111, %10011100, %00111110

text_picture:
   .db %00000000, %00000000, %00111110, %01110000, %00000000, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00111111, %01110000, %00000111, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00111011, %00000000, %00000111, %00000000, %00000000, %00000000
   .db %00000000, %00000000, %00111011, %01110011, %11100111, %10111011, %10111010, %01111100
   .db %00000000, %00000000, %00111011, %01110111, %11110111, %10111011, %10111110, %11111110
   .db %00000000, %00000000, %00111011, %01110111, %01110111, %00111011, %10111110, %11101110
   .db %00000000, %00000000, %00111111, %01110111, %01110111, %00111011, %10111000, %11111110
   .db %00000000, %00000000, %00111110, %01110111, %00000111, %00111011, %10111000, %11111110
   .db %00000000, %00000000, %00111000, %01110111, %01110111, %00111011, %10111000, %11100000
   .db %00000000, %00000000, %00111000, %01110111, %01110111, %00111011, %10111000, %11101110
   .db %00000000, %00000000, %00111000, %01110111, %01110111, %00111011, %10111000, %11101110
   .db %00000000, %00000000, %00111000, %01110111, %11100111, %10111111, %10111000, %11111110
   .db %00000000, %00000000, %00111000, %01110011, %11000111, %10011011, %10111000, %01111100

text_slow:
	.db %00000000, %00000000, %00000000, %00000000, %00001111, %00111000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00011111, %10111000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00011101, %10111000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000, %00011101, %10111001, %11110111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00011100, %00111011, %11111111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00011110, %00111011, %10111111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00001111, %00111011, %10111111, %01110111
	.db %00000000, %00000000, %00000000, %00000000, %00000011, %10111011, %10111011, %01010110
	.db %00000000, %00000000, %00000000, %00000000, %00011011, %10111011, %10111011, %01010110
	.db %00000000, %00000000, %00000000, %00000000, %00011011, %10111011, %10111011, %01010110
	.db %00000000, %00000000, %00000000, %00000000, %00011011, %10111011, %10111011, %11011110
	.db %00000000, %00000000, %00000000, %00000000, %00011111, %10111011, %11111011, %11011110
	.db %00000000, %00000000, %00000000, %00000000, %00001111, %00111001, %11110011, %11011110

bearsoft:
	.db %11111111, %11110000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00111111, %11000000, %00000000, %00000000, %00000011, %11111000, %00000000
	.db %11111111, %11111100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %11110000, %00000000, %00000000, %00000111, %11111000, %00000000
	.db %11111111, %11111110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11111000, %00000000, %00000000, %00001111, %11111001, %11111100
	.db %11111111, %11111110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000001, %11111111, %11111000, %00000000, %00000000, %00001111, %11111001, %11111100
	.db %11111111, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011, %11111111, %11111100, %00000000, %00000000, %00001111, %11000001, %11111100
	.db %11111110, %01111111, %00000000, %11111100, %00000000, %00011111, %11000000, %01111111, %00110011, %11111001, %11111100, %00000111, %11110000, %00001111, %11000001, %11111100
	.db %11111110, %01111111, %00000011, %11111111, %00000000, %01111111, %11110000, %01111111, %01110011, %11111001, %11111100, %00001111, %11111100, %00011111, %11111011, %11111111
	.db %11111110, %01111111, %00000111, %11111111, %10000000, %11111111, %11111000, %01111111, %01110011, %11111001, %11111100, %00011111, %11111110, %00011111, %11111011, %11111111
	.db %11111110, %01111111, %00001111, %11111111, %11000001, %11111111, %11111000, %01111111, %11110011, %11111001, %11111100, %00111111, %11111111, %00011111, %11111011, %11111111
	.db %11111110, %01111111, %00011111, %11001111, %11000011, %11111001, %11111100, %01111111, %11110011, %11111110, %00000000, %00111111, %00111111, %10011111, %11111011, %11111111
	.db %11111110, %01111111, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %11110011, %11111111, %00000000, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111111, %11111110, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %11110001, %11111111, %10000000, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111111, %11111110, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %11110001, %11111111, %11100000, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111111, %11110000, %00011111, %11111111, %11100011, %11111001, %11111100, %01111111, %10000000, %11111111, %11110000, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111111, %11111100, %00011111, %11111111, %11100011, %11111001, %11111100, %01111111, %00000000, %01111111, %11111000, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111111, %11111110, %00011111, %11111111, %11100000, %00000111, %11111100, %01111111, %00000000, %00011111, %11111100, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11111111, %11100000, %00011111, %11111100, %01111111, %00000000, %00001111, %11111100, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11000000, %00000000, %11111111, %11111100, %01111111, %00000000, %00000111, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11000000, %00000001, %11111111, %11111100, %01111111, %00000000, %00000001, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11001111, %11100011, %11111101, %11111100, %01111111, %00000011, %11111000, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %00000011, %11111000, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %00000011, %11111000, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %00000011, %11111000, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111110, %01111111, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %00000011, %11111000, %11111110, %01111111, %00111111, %10001111, %11100001, %11111100
	.db %11111111, %11111111, %00011111, %11001111, %11100011, %11111001, %11111100, %01111111, %00000011, %11111111, %11111110, %01111111, %00111111, %00001111, %11100001, %11111100
	.db %11111111, %11111111, %00001111, %11111111, %11000011, %11111111, %11111100, %01111111, %00000001, %11111111, %11111100, %00111111, %11111111, %00001111, %11100001, %11111111
	.db %11111111, %11111110, %00000111, %11111111, %10000011, %11111111, %11111100, %01111111, %00000001, %11111111, %11111100, %00111111, %11111110, %00001111, %11100001, %11111111
	.db %11111111, %11111110, %00000011, %11111111, %00000001, %11111101, %11111100, %01111111, %00000000, %01111111, %11111000, %00011111, %11111100, %00001111, %11100000, %11111111
	.db %11111111, %11111000, %00000000, %11111110, %00000000, %11111001, %11111100, %01111111, %00000000, %00011111, %11000000, %00000111, %11110000, %00001111, %11100000, %01111111
	.db %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
	.db %11000011, %00000000, %00000000, %00000000, %00000110, %00000011, %01110000, %00110110, %00000011, %11000000, %00000000, %00110000, %00000000, %00000000, %00000000, %00000000
   .db %11000000, %00000000, %00000000, %00000000, %00000110, %00000011, %01100000, %00110110, %00000100, %00100000, %00000000, %00000000, %00000000, %00000001, %10000000, %00000000
   .db %11110011, %00111001, %11011110, %00000111, %00011110, %01110011, %01110111, %00110110, %11001011, %11010111, %10110101, %10110111, %10011110, %00111001, %11000011, %11001110
   .db %11011011, %01101101, %11011011, %00001101, %10110110, %11011011, %01101101, %10110110, %11010100, %10010101, %10110101, %10110110, %11011011, %01101101, %10000010, %11011011
	.db %11011011, %01101101, %10011011, %00001101, %10110110, %11011011, %01101101, %10110111, %10010100, %10010110, %00110101, %10110110, %11011011, %01101101, %10000011, %00011011
	.db %11011011, %01101101, %10011011, %00001101, %10110110, %11111011, %01100111, %10110111, %10010100, %10010011, %10011101, %00110110, %11011011, %01111101, %10000001, %11011111
	.db %11011011, %01101101, %10011011, %00001101, %10110110, %11000011, %01101101, %10110110, %11010100, %10100001, %10011101, %00110110, %11011011, %01100001, %10000000, %11011000
	.db %11011011, %01101101, %10011011, %01101101, %10110110, %11011011, %01101101, %10110110, %11001011, %11000110, %10011011, %00110110, %11011011, %01101101, %10011011, %01011011
   .db %11110011, %00111001, %10011011, %01100111, %00011110, %01110011, %01101111, %10110110, %11000100, %00110111, %10011011, %00110111, %10011011, %00111001, %11011011, %11001110
   .db %00000110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011, %11000000, %00000000, %00000110, %00000000, %00000000, %00000000, %00000000

game:
   CALL  init
   CALL  paint_shuffling
   CALL  randomboard
   CALL  _clrLCD
   CALL  paintboard
   CALL  paintcursor
game_keyloop:
   CALL  GET_KEY
   CP    K_SECOND
   JR    Z, game_select
   CP    K_ALPHA
   JR    Z, picture
   CP    K_DOWN
   JP    Z, cursor_down
   CP    K_UP
   JP    Z, cursor_up
   CP    K_LEFT
   JP    Z, cursor_left
   CP    K_RIGHT
   JP    Z, cursor_right
   CP    K_EXIT
   JR    Z, back_from_game
   JR    game_keyloop

back_from_game:
   CALL  fade_out
   CALL  _clrLCD
   CALL  init_menu
   CALL  paint_fifteen_picture
   CALL  paint_option
   JP    keyloop

picture:
   LD    HL, board
   LD    DE, tempboard
   LD    B, 16d

picture_loop:
   LD    A, (HL)
   LD    (DE), A
   INC   HL
   INC   DE
   DJNZ  picture_loop
   CALL  init_board
   CALL  paintboard
picture_keyloop:
   CALL  GET_KEY
   CP    K_ALPHA
   JR    Z, picture_done
   CP    K_EXIT
   JR    Z, picture_done
   JR    picture_keyloop
picture_done:
   LD    HL, tempboard
   LD    DE, board
   LD    B, 16d
picture_loop2:
   LD    A, (HL)
   LD    (DE), A
   INC   HL
   INC   DE
   DJNZ  picture_loop2
   CALL  paintboard
   CALL  paintcursor
   JR    game_keyloop

game_select:
   LD    A, (cursorx)
   LD    B, A
   LD    A, (holex)
   SUB   B
   CP    00h
   JR    Z, vertikal
   LD    A, (cursory)
   LD    B, A
   LD    A, (holey)
   SUB   B
   CP    00h
   JP    NZ, game_keyloop
horisontell:
   LD    A, (cursorx)
   LD    B, A
   LD    A, (holex)
   SUB   B
   CP    1d
   JR    Z, block_right
   CP    -1d
   JR    Z, block_left
   JP    game_keyloop
vertikal:
   LD    A, (cursory)
   LD    B, A
   LD    A, (holey)
   SUB   B
   CP    1d
   JR    Z, block_down
   CP    -1d
   JR    Z, block_up
   JP    game_keyloop

block_up:
   CALL  animate_up
   CALL  move_block_up
   CALL  paintboard
   CALL  paintcursor
   JP    check_finished

block_down:
   CALL  animate_down
   CALL  move_block_down
   CALL  paintboard
   CALL  paintcursor
   JP    check_finished

block_left:
   CALL  animate_left
   CALL  move_block_left
   CALL  paintboard
   CALL  paintcursor
   JP    check_finished

block_right:
   CALL  animate_right
   CALL  move_block_right
   CALL  paintboard
   CALL  paintcursor
   JP    check_finished

animate_up:
   LD    A, 16d
   LD    (tempbyte), A
animate_up_loop4:
   LD    HL, $FC00
   LD    A, (holex)
   SLA   A
   SLA   A
   LD    D, 00h
   LD    E, A
   ADD   HL, DE

   LD    DE, 256d
   SBC   HL, DE
   LD    A, (holey)
   INC   A
   LD    B, A
animate_up_loop:
   ADD   HL, DE
   DJNZ  animate_up_loop

   PUSH  HL
   EX    DE, HL
   POP   HL

   PUSH  DE
   LD    DE, 16d
   ADD   HL, DE
   POP   DE

   LD    C, 31d
animate_up_loop3:
   LD    B, 4d
animate_up_loop2:
   LD    A, (HL)
   LD    (DE), A
   INC   HL
   INC   DE
   DJNZ  animate_up_loop2

   PUSH  DE
   LD    DE, 12d
   ADD   HL, DE
   POP   DE

   EX    DE, HL
   PUSH  DE
   LD    DE, 12d
   ADD   HL, DE
   POP   DE
   EX    DE, HL

   DEC   C
   JR    NZ, animate_up_loop3

   LD    DE, 272d
   SBC   HL, DE
   LD    B, 4d
animate_up_loop5:
   LD    A, (HL)
   CPL
   LD    (HL), A
   INC   HL
   DJNZ  animate_up_loop5

   LD    DE, 252d
   ADD   HL, DE
   LD    B, 4d
animate_up_loop6:
   LD    (HL), $FF
   INC   HL
   DJNZ  animate_up_loop6

   CALL  pause
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, animate_up_loop4
   RET

animate_down:
   LD    A, 16d
   LD    (tempbyte), A
animate_down_loop4:
   LD    HL, $FC00 + (31d * 16d)
   LD    A, (cursorx)
   SLA   A
   SLA   A
   LD    D, 00h
   LD    E, A
   ADD   HL, DE

   LD    DE, 256d
   XOR   A
   SBC   HL, DE
   LD    A, (cursory)
   INC   A
   LD    B, A
animate_down_loop:
   ADD   HL, DE
   DJNZ  animate_down_loop

   PUSH  HL
   POP   DE

   PUSH  DE
   LD    DE, 16d
   XOR   A
   SBC   HL, DE
   POP   DE

   LD    C, 31d
animate_down_loop3:
   LD    B, 4d
animate_down_loop2:
   LD    A, (HL)
   LD    (DE), A
   INC   HL
   INC   DE
   DJNZ  animate_down_loop2

   LD    DE, 4d + 16d
   XOR   A
   SBC   HL, DE

   PUSH  HL
   LD    DE, 16d
   ADD   HL, DE
   EX    DE, HL
   POP   HL

   DEC   C
   JR    NZ, animate_down_loop3

   LD    DE, 16d
   ADD   HL, DE
   LD    B, 4d
animate_down_loop5:
   LD    (HL), $FF
   INC   HL
   DJNZ  animate_down_loop5

   LD    DE, 252d
   ADD   HL, DE
   LD    B, 4d
animate_down_loop6:
   LD    A, (HL)
   CPL
   LD    (HL), A
   INC   HL
   DJNZ  animate_down_loop6

   CALL  pause
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, animate_down_loop4
   RET

animate_left:
   LD    A, 32d
   LD    (tempbyte), A
animate_left_loop3:
   LD    HL, $FC00 + 3d            ; Stter HL p rtt x-lge
   LD    A, (cursorx)
   SLA   A
   SLA   A
   LD    D, 00h
   LD    E, A
   ADD   HL, DE

   LD    DE, 256d                   ; Stter HL p rtt y-lge
   XOR   A
   SBC   HL, DE
   LD    A, (cursory)
   INC   A
   LD    B, A
animate_left_loop:
   ADD   HL, DE
   DJNZ  animate_left_loop

   LD    B, 16d
animate_left_loop2:
   SCF
   RL    (HL)
   DEC   HL
   RL    (HL)
   DEC   HL
   RL    (HL)
   DEC   HL
   RL    (HL)
   CCF
   DEC   HL
   RL    (HL)
   DEC   HL
   RL    (HL)
   DEC   HL
   RL    (HL)
   DEC   HL
   RL    (HL)

   LD    DE, 23d
   ADD   HL, DE

   DJNZ  animate_left_loop2

   CALL  pause
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, animate_left_loop3

   RET

animate_right:
   LD    A, 32d
   LD    (tempbyte), A
animate_right_loop3:
   LD    HL, $FC00                  ; Stter HL p rtt x-lge
   LD    A, (cursorx)
   SLA   A
   SLA   A
   LD    D, 00h
   LD    E, A
   ADD   HL, DE

   LD    DE, 256d                   ; Stter HL p rtt y-lge
   XOR   A
   SBC   HL, DE
   LD    A, (cursory)
   INC   A
   LD    B, A
animate_right_loop:
   ADD   HL, DE
   DJNZ  animate_right_loop

   LD    B, 16d
animate_right_loop2:
   SCF
   RR    (HL)
   INC   HL
   RR    (HL)
   INC   HL
   RR    (HL)
   INC   HL
   RR    (HL)
   CCF
   INC   HL
   RR    (HL)
   INC   HL
   RR    (HL)
   INC   HL
   RR    (HL)
   INC   HL
   RR    (HL)

   LD    DE, 9d
   ADD   HL, DE

   DJNZ  animate_right_loop2

   CALL  pause
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, animate_right_loop3

   RET

pause:
   LD    A, (speed_option)
   LD    HL, speed_pointer
   LD    D, 00h
   LD    E, A
   ADD   HL, DE
   LD    A, (HL)
pause_loop:
   HALT
   DEC   A
   JR    NZ, pause_loop
   RET

check_finished:
   LD    HL, board + 14d
   LD    B, 15
check_finished_loop:
   LD    A, (HL)
   CP    B
   JP    NZ, game_keyloop
   DEC   HL
   DJNZ  check_finished_loop
   CALL  paint_congrats
check_keyloop
   CALL  GET_KEY
   CP    K_ENTER
   JP    Z, back_from_game
   CP    K_SECOND
   JP    Z, back_from_game
   CP    K_EXIT
   JP    Z, back_from_game
   JR    check_keyloop

randomboard:
   LD    A, (shuffle_option)
   LD    D, 00h
   LD    E, A
   LD    HL, shuffle_pointer
   ADD   HL, DE
   LD    A, (HL)
   LD    (tempbyte), A
   LD    A, 03h
   LD    (holex), A
   LD    (holey), A
random_loop:
   CALL  _RANDOM       ;ger slumptal 0 till 1 lagras i op1
   CALL  _OP2SET4
   CALL  _FPMULT       ;mult op2 med op1 resultat i op1
   CALL  _CONVOP1      ;flytta op1 till DE
   LD    A, E
   CP    03h
   JR    Z, move_up
   CP    00h
   JR    Z, move_down
   CP    01h
   JR    Z, move_left
   CP    02h
   JR    Z, move_right
   RET
random_finished:
   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, random_loop
   RET

move_up:
   LD    A, (holey)
   CP    03h
   JR    Z, random_loop
   CALL  move_block_up
   JR    random_finished

move_down:
   LD    A, (holey)
   CP    00h
   JR    Z, random_loop
   CALL  move_block_down
   JR    random_finished

move_left:
   LD    A, (holex)
   CP    03h
   JR    Z, random_loop
   CALL  move_block_left
   JR    random_finished

move_right:
   LD    A, (holex)
   CP    00h
   JR    Z, random_loop
   CALL  move_block_right
   JR    random_finished

move_block_up:
   CALL  set_hl_by_hole

   LD    DE, 4d
   ADD   HL, DE
   LD    B, (HL)
   SBC   HL, DE
   LD    (HL), B
   ADD   HL, DE
   LD    (HL), 00h

   LD    A, (holey)
   INC   A
   LD    (holey), A

   RET

move_block_down:
   CALL  set_hl_by_hole

   LD    DE, 4d
   SBC   HL, DE
   LD    B, (HL)
   ADD   HL, DE
   LD    (HL), B
   SBC   HL, DE
   LD    (HL), 00h

   LD    A, (holey)
   DEC   A
   LD    (holey), A

   RET

move_block_left:
   CALL  set_hl_by_hole

   INC   HL
   LD    B, (HL)
   DEC   HL
   LD    (HL), B
   INC   HL
   LD    (HL), 00h

   LD    A, (holex)
   INC   A
   LD    (holex), A

   RET

move_block_right:
   CALL  set_hl_by_hole

   DEC   HL
   LD    B, (HL)
   INC   HL
   LD    (HL), B
   DEC   HL
   LD    (HL), 00h

   LD    A, (holex)
   DEC   A
   LD    (holex), A

   RET

set_hl_by_hole:             ;USES A, DE, HL
   LD    HL, board
   LD    D, 00h
   LD    A, (holex)
   LD    E, A
   ADD   HL, DE
   LD    D, 00h
   LD    A, (holey)
   LD    E, A
   SLA   E
   SLA   E
   ADD   HL, DE
   RET

paint_shuffling:
   LD    HL, $FC01 + (19d * 16d)
   LD    DE, text_shuffling
   LD    C, 20d
paint_shuffling_yloop:
   LD    B, 14d
paint_shuffling_xloop:
   LD    A, (DE)
   LD    (HL), A
   INC   DE
   INC   HL
   DJNZ  paint_shuffling_xloop
   INC   HL
   INC   HL
   DEC   C
   JR    NZ, paint_shuffling_yloop
   RET

cursor_down:
   LD    A, (cursory)
   CP    03h
   JP    Z, game_keyloop
   INC   A
   LD    (cursory), A
   CALL  paintboard
   CALL  paintcursor
   JP    game_keyloop

cursor_up:
   LD    A, (cursory)
   CP    00h
   JP    Z, game_keyloop
   DEC   A
   LD    (cursory), A
   CALL  paintboard
   CALL  paintcursor
   JP    game_keyloop

cursor_left:
   LD    A, (cursorx)
   CP    00h
   JP    Z, game_keyloop
   DEC   A
   LD    (cursorx), A
   CALL  paintboard
   CALL  paintcursor
   JP    game_keyloop

cursor_right:
   LD    A, (cursorx)
   CP    03h
   JP    Z, game_keyloop
   INC   A
   LD    (cursorx), A
   CALL  paintboard
   CALL  paintcursor
   JP    game_keyloop

paintcursor:
   LD    HL, $FC00
   LD    D, 00h
   LD    A, (cursorx)
   LD    E, A
   SLA   E
   SLA   E
   ADD   HL, DE

   LD    DE, 256d
   SBC   HL, DE
   LD    A, (cursory)
   INC   A
   LD    B, A
paintcursor_loop:
   ADD   HL, DE
   DJNZ  paintcursor_loop

   LD    C, 16d
paintcursor_loop2:
   LD    B, 4d
paintcursor_loop3:
   LD    A, (HL)
   CPL
   LD    (HL), A
   INC   HL
   DJNZ  paintcursor_loop3
   LD    DE, 12d
   ADD   HL, DE
   DEC   C
   JR    NZ, paintcursor_loop2
   RET

paintboard:
   LD    HL, board
   LD    (boardpointer), HL
   LD    HL, $FC00
   LD    (screenpointer), HL
   LD    A, 4d
   LD    (tempbyte2), A
paintboard_pic_yloop:
   LD    A, 4d
   LD    (tempbyte), A
paintboard_pic_xloop:
   CALL  set_hl_to_pic_list
   LD    DE, (boardpointer)
   LD    A, (DE)
   SLA   A
   LD    D, 00h
   LD    E, A
   ADD   HL, DE

   LD    E, (HL)
   INC   HL
   LD    D, (HL)

   LD    HL, (screenpointer)

   LD    C, 16d
paintboard_yloop:
   LD    B, 4d
paintboard_xloop:
   LD    A, (DE)
   LD    (HL), A
   INC   DE
   INC   HL
   DJNZ  paintboard_xloop

   PUSH  DE
   LD    DE, 12d
   ADD   HL, DE
   POP   DE

   DEC   C
   JR    NZ, paintboard_yloop

   CALL  inc_boardpointer
   CALL  inc_screenpointer_x

   LD    A, (tempbyte)
   DEC   A
   LD    (tempbyte), A
   JR    NZ, paintboard_pic_xloop

   CALL  inc_screenpointer_y

   LD    A, (tempbyte2)
   DEC   A
   LD    (tempbyte2), A
   JR    NZ, paintboard_pic_yloop

   RET

set_hl_to_pic_list:
   LD    A, (board_option)
   SLA   A
   LD    D, 00h
   LD    E, A
   LD    HL, picpointers
   ADD   HL, DE
   LD    E, (HL)
   INC   HL
   LD    D, (HL)
   EX    DE, HL
   RET

inc_screenpointer_x:
   LD    HL, (screenpointer)
   LD    DE, 4d
   ADD   HL, DE
   LD    (screenpointer), HL
   RET

inc_screenpointer_y:
   LD    HL, (screenpointer)
   LD    DE, 240d
   ADD   HL, DE
   LD    (screenpointer), HL
   RET

inc_boardpointer:
   LD    HL, (boardpointer)
   INC   HL
   LD    (boardpointer), HL
   RET

init:
   CALL  init_board
   LD    A, 00h
   LD    (cursorx), A
   LD    (cursory), A
   LD    A, 03h
   LD    (holex), A
   LD    (holey), A
   RET

init_board:
   LD    HL, board + 15d
   LD    (HL), 00h
   DEC   HL
   LD    B, 15d
init_loop:
   LD    (HL), B
   DEC   HL
   DJNZ  init_loop
   RET


holex:
   .db   00h

holey:
   .db   00h

cursorx:
   .db   00h

cursory:
   .db   00h

tempbyte2:
   .db   00h

shuffle_pointer:
   .db   30d
   .db   90d
   .db   170d

speed_pointer:
   .db   13d
   .db   6d
   .db   2d

screenpointer:
   .dw   $FC00

boardpointer:
   .dw   board

board:
   .db   01d, 02d, 03d, 04d
   .db   05d, 06d, 07d, 08d
   .db   09d, 10d, 11d, 12d
   .db   13d, 14d, 15d, 00d

tempboard:
   .db   00d, 00d, 00d, 00d
   .db   00d, 00d, 00d, 00d
   .db   00d, 00d, 00d, 00d
   .db   00d, 00d, 00d, 00d

text_shuffling:
	.db %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111110
	.db %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000010
	.db %10000000, %00000000, %00000000, %00011000, %00000000, %00000001, %11000001, %11011100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00111100, %00011100, %00000000, %00000111, %11000111, %11011101, %10000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %01111110, %00111000, %00000000, %00000111, %10000111, %10111011, %10000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %11111110, %00111000, %00000000, %00001110, %00001110, %00111011, %10000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000001, %11000000, %00111000, %00000000, %00001110, %00001110, %00111000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000011, %11111100, %01110111, %01110111, %00011111, %00011111, %01110011, %01110111, %00001111, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000011, %11111100, %01111111, %01110111, %00111111, %00111111, %01110111, %01111111, %00111111, %10000000, %00000000, %00000000, %00000011
	.db %10000000, %00000001, %11111110, %01111111, %01110111, %00111110, %00111110, %01110111, %01111111, %01111111, %10000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00011100, %11111110, %11101110, %00111000, %00111000, %11101110, %11111110, %01110111, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00001100, %00111100, %11101110, %11101110, %00111000, %00111000, %11101110, %11101110, %11100110, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00001111, %11111000, %11101110, %11111110, %00111000, %00111000, %11101110, %11101110, %11111110, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00001111, %11110001, %11011100, %11111100, %01111000, %01111001, %11011100, %11011100, %11111110, %00010000, %00100000, %01000000, %00000011
	.db %10000000, %00000111, %11000001, %11011100, %11111100, %01110000, %01110001, %11011101, %11011100, %11111100, %00110000, %01100000, %11000000, %00000011
	.db %10000000, %00000000, %00000000, %00000000, %00000000, %01110000, %01110000, %00000000, %00000000, %00011100, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000001, %11111000, %00000000, %00000000, %00000000, %00000011
	.db %10000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000011, %11110000, %00000000, %00000000, %00000000, %00000011
	.db %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111000, %00000111, %11111111, %11111111, %11111111, %11111111
	.db %00111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111, %11111111

picpointers:
   .dw   numbers_picpointers
   .dw   picture_picpointers

numbers_picpointers:
   .dw   tom
   .dw   numbers_pic00
   .dw   numbers_pic10
   .dw   numbers_pic20
   .dw   numbers_pic30
   .dw   numbers_pic01
   .dw   numbers_pic11
   .dw   numbers_pic21
   .dw   numbers_pic31
   .dw   numbers_pic02
   .dw   numbers_pic12
   .dw   numbers_pic22
   .dw   numbers_pic32
   .dw   numbers_pic03
   .dw   numbers_pic13
   .dw   numbers_pic23

picture_picpointers:
   .dw   tom
   .dw   picture_pic00
   .dw   picture_pic10
   .dw   picture_pic20
   .dw   picture_pic30
   .dw   picture_pic01
   .dw   picture_pic11
   .dw   picture_pic21
   .dw   picture_pic31
   .dw   picture_pic02
   .dw   picture_pic12
   .dw   picture_pic22
   .dw   picture_pic32
   .dw   picture_pic03
   .dw   picture_pic13
   .dw   picture_pic23

tom:
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
   .db   00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h

numbers_pic00:
	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000000, %01110000, %00000001
	.db %10000000, %00000000, %11100000, %00000001
	.db %10000000, %00000011, %11100000, %00000001
	.db %10000000, %00000011, %11100000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00001111, %11000000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic10:
	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000000, %11111000, %00000001
	.db %10000000, %00000011, %11111100, %00000001
	.db %10000000, %00000111, %11111100, %00000001
	.db %10000000, %00000110, %00011100, %00000001
	.db %10000000, %00000000, %00111000, %00000001
	.db %10000000, %00000000, %11110000, %00000001
	.db %10000000, %00000011, %11000000, %00000001
	.db %10000000, %00000111, %00000000, %00000001
	.db %10000000, %00011100, %00000000, %00000001
	.db %10000000, %00011111, %11100000, %00000001
	.db %10000000, %00111111, %11100000, %00000001
	.db %10000000, %00111111, %11100000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic20:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000000, %11110000, %00000001
	.db %10000000, %00000011, %11111000, %00000001
	.db %10000000, %00000111, %11111000, %00000001
	.db %10000000, %00000110, %00111000, %00000001
	.db %10000000, %00000001, %11110000, %00000001
	.db %10000000, %00000011, %11100000, %00000001
	.db %10000000, %00000011, %11100000, %00000001
	.db %10000000, %00000000, %11100000, %00000001
	.db %10000000, %00011000, %11100000, %00000001
	.db %10000000, %00011111, %11100000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00001111, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic30:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000000, %00110000, %00000001
	.db %10000000, %00000000, %01110000, %00000001
	.db %10000000, %00000000, %11110000, %00000001
	.db %10000000, %00000001, %01110000, %00000001
	.db %10000000, %00000010, %11100000, %00000001
	.db %10000000, %00000100, %11100000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00011111, %11110000, %00000001
	.db %10000000, %00111111, %11100000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic01:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000111, %11110000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00001110, %00000000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00011111, %11100000, %00000001
	.db %10000000, %00011111, %11100000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00110001, %11000000, %00000001
	.db %10000000, %00111111, %10000000, %00000001
	.db %10000000, %00111111, %00000000, %00000001
	.db %10000000, %00011110, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic11:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000000, %00110000, %00000001
	.db %10000000, %00000000, %11100000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00000111, %11100000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00011100, %11100000, %00000001
	.db %10000000, %00011100, %11100000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00001111, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic21:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000111, %11111100, %00000001
	.db %10000000, %00001111, %11111000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00000000, %01100000, %00000001
	.db %10000000, %00000000, %11100000, %00000001
	.db %10000000, %00000001, %11000000, %00000001
	.db %10000000, %00000001, %10000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00000111, %00000000, %00000001
	.db %10000000, %00001110, %00000000, %00000001
	.db %10000000, %00001110, %00000000, %00000001
	.db %10000000, %00011100, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic31:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000011, %11100000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00001110, %01110000, %00000001
	.db %10000000, %00001111, %11100000, %00000001
	.db %10000000, %00001111, %11000000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00011101, %11000000, %00000001
	.db %10000000, %00111001, %11000000, %00000001
	.db %10000000, %00111111, %11000000, %00000001
	.db %10000000, %00111111, %10000000, %00000001
	.db %10000000, %00011110, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic02:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000001, %11100000, %00000001
	.db %10000000, %00000111, %11100000, %00000001
	.db %10000000, %00001111, %11110000, %00000001
	.db %10000000, %00001110, %11110000, %00000001
	.db %10000000, %00011100, %11100000, %00000001
	.db %10000000, %00011111, %11100000, %00000001
	.db %10000000, %00011111, %11000000, %00000001
	.db %10000000, %00001111, %11000000, %00000001
	.db %10000000, %00000011, %10000000, %00000001
	.db %10000000, %00000111, %00000000, %00000001
	.db %10000000, %00011110, %00000000, %00000001
	.db %10000000, %00111000, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic12:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00001110, %00000011, %11000001
	.db %10000000, %00011100, %00000111, %11000001
	.db %10000000, %01111100, %00001111, %11000001
	.db %10000000, %01111100, %00011101, %11000001
	.db %10000000, %00111000, %00111001, %11000001
	.db %10000000, %00111000, %00111001, %11000001
	.db %10000000, %00111000, %00111001, %11000001
	.db %10000000, %01110000, %00110011, %10000001
	.db %10000000, %01110000, %01110011, %10000001
	.db %10000001, %11111000, %01111111, %00000001
	.db %10000011, %11111000, %00111110, %00000001
	.db %10000011, %11111000, %00111100, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic22:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00001110, %00000011, %10000001
	.db %10000000, %00011100, %00000111, %00000001
	.db %10000000, %01111100, %00011111, %00000001
	.db %10000000, %01111100, %00011111, %00000001
	.db %10000000, %00111000, %00001110, %00000001
	.db %10000000, %00111000, %00001110, %00000001
	.db %10000000, %00111000, %00001110, %00000001
	.db %10000000, %01110000, %00011100, %00000001
	.db %10000000, %01110000, %00011100, %00000001
	.db %10000001, %11111000, %01111110, %00000001
	.db %10000011, %11111000, %11111110, %00000001
	.db %10000011, %11111000, %11111110, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic32:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00001110, %00000111, %11000001
	.db %10000000, %00011100, %00011111, %11100001
	.db %10000000, %01111100, %00111111, %11100001
	.db %10000000, %01111100, %00110000, %11100001
	.db %10000000, %00111000, %00000001, %11000001
	.db %10000000, %00111000, %00000111, %10000001
	.db %10000000, %00111000, %00011110, %00000001
	.db %10000000, %01110000, %00111000, %00000001
	.db %10000000, %01110000, %11100000, %00000001
	.db %10000001, %11111000, %11111111, %00000001
	.db %10000011, %11111001, %11111111, %00000001
	.db %10000011, %11111001, %11111111, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic03:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00011100, %00000111, %10000001
	.db %10000000, %00111000, %00011111, %11000001
	.db %10000000, %11111000, %00111111, %11000001
	.db %10000000, %11111000, %00110001, %11000001
	.db %10000000, %01110000, %00001111, %10000001
	.db %10000000, %01110000, %00011111, %00000001
	.db %10000000, %01110000, %00011111, %00000001
	.db %10000000, %11100000, %00000111, %00000001
	.db %10000000, %11100000, %11000111, %00000001
	.db %10000011, %11110000, %11111111, %00000001
	.db %10000111, %11110000, %11111110, %00000001
	.db %10000111, %11110000, %01111000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic13:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00001110, %00000000, %11000001
	.db %10000000, %00011100, %00000001, %11000001
	.db %10000000, %01111100, %00000011, %11000001
	.db %10000000, %01111100, %00000101, %11000001
	.db %10000000, %00111000, %00001011, %10000001
	.db %10000000, %00111000, %00010011, %10000001
	.db %10000000, %00111000, %00111111, %11000001
	.db %10000000, %01110000, %01111111, %11000001
	.db %10000000, %01110000, %11111111, %10000001
	.db %10000001, %11111000, %00000111, %00000001
	.db %10000011, %11111000, %00001110, %00000001
	.db %10000011, %11111000, %00001110, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111
numbers_pic23:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00011100, %00011111, %11000001
	.db %10000000, %00111000, %00111111, %11000001
	.db %10000000, %11111000, %00111111, %11000001
	.db %10000000, %11111000, %00111000, %00000001
	.db %10000000, %01110000, %01111111, %00000001
	.db %10000000, %01110000, %01111111, %10000001
	.db %10000000, %01110000, %01111111, %10000001
	.db %10000000, %11100000, %00000111, %00000001
	.db %10000000, %11100000, %11000111, %00000001
	.db %10000011, %11110000, %11111110, %00000001
	.db %10000111, %11110000, %11111100, %00000001
	.db %10000111, %11110000, %01111000, %00000001
	.db %10000000, %00000000, %00000000, %00000001
	.db %11111111, %11111111, %11111111, %11111111

picture_pic00:

	.db %11111111, %11111111, %11111111, %11111111
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
picture_pic10:

	.db %11111111, %11111111, %11111111, %11111111
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000011, %11111111, %11111100
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
picture_pic20:

	.db %11111111, %11111111, %11111111, %11111111
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00011100, %00000000, %00000000
	.db %00000000, %01111110, %00000000, %00000000
	.db %00000000, %11111111, %10000000, %00000000
	.db %00000000, %11111111, %10000000, %00000000
	.db %10000000, %11111111, %10000000, %00000000
	.db %11110000, %01111110, %00000000, %00000000
	.db %11110000, %00011110, %00011111, %11111000
	.db %11110000, %00000000, %00011111, %11111111
	.db %11100000, %00000000, %00111111, %11111111
picture_pic30:

	.db %11111111, %11111111, %11111111, %11111111
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
picture_pic01:

	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00111111
	.db %10000000, %00000000, %00000000, %01111111
	.db %10000000, %00000000, %00000000, %00111111
	.db %10000000, %00000000, %00000000, %00111111
	.db %10000000, %00000000, %00000000, %00011111
	.db %10000000, %00000000, %00000000, %00011111
	.db %10000000, %00000000, %00000000, %00000111
picture_pic11:

	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11110000
	.db %00000000, %00000111, %11111111, %11110000
	.db %00000000, %00000111, %11111111, %11110000
	.db %00000000, %00001111, %11111111, %11110000
	.db %00000000, %00011111, %11111111, %11100000
	.db %11111111, %11111111, %11111111, %11100000
	.db %11111111, %11111111, %11111111, %11100000
	.db %11111111, %11111111, %11111111, %11111111
	.db %11111111, %11111111, %11111111, %11111111
	.db %11111111, %11111111, %11111111, %11111111
	.db %11111111, %11111111, %11111111, %11111111
	.db %11111111, %11111111, %11111111, %11111111
picture_pic21:

	.db %11100001, %11111110, %00111111, %11111111
	.db %11100001, %11111110, %00111111, %11111111
	.db %11100001, %11111100, %00111111, %11111111
	.db %11000011, %11111100, %01111111, %11111111
	.db %00000011, %11111100, %00000001, %11111111
	.db %00000011, %11111100, %00000001, %11111111
	.db %00000011, %11111000, %00000001, %11111111
	.db %00001111, %11111000, %00000001, %11111111
	.db %00001111, %11111000, %00000011, %11111111
	.db %00001111, %11111000, %00000011, %11111111
	.db %00001111, %11110000, %00000011, %11111111
	.db %10001111, %11110001, %11111111, %11111111
	.db %10011111, %11110001, %11111111, %11111111
	.db %10011111, %11100001, %11111111, %11111111
	.db %00011111, %11100011, %11111111, %11111111
	.db %00011111, %11100011, %11111111, %11111111
picture_pic31:

	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %11100000, %00000000, %00000000, %00000001
	.db %11110000, %00000000, %00000000, %00000001
	.db %11111000, %00000000, %00000000, %00000001
	.db %11111100, %00000000, %00000000, %00000001
	.db %11111110, %00000000, %00000000, %00000001
	.db %11111110, %00000000, %00000000, %00000001
	.db %11111110, %00000000, %00000000, %00000001
picture_pic02:

	.db %10000000, %00000000, %00000000, %00000001
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
picture_pic12:

	.db %11111111, %11111111, %11111111, %11111111
	.db %11111111, %11111111, %11111111, %11111111
	.db %01111111, %11111111, %11111111, %11111100
	.db %00111111, %11111111, %11111111, %11111100
	.db %00111111, %11111111, %11111111, %11111100
	.db %00001111, %11111111, %11111111, %11111100
	.db %00001111, %11111111, %11111111, %11111100
	.db %00000111, %11111111, %11111111, %11111100
	.db %00000111, %11111111, %10011111, %11111000
	.db %00000011, %11111111, %00000011, %11111100
	.db %00000011, %11111100, %00000001, %11111100
	.db %00000001, %11111000, %00000001, %11111100
	.db %00000000, %00000000, %00000000, %11111111
	.db %00000000, %00000000, %00000000, %11111111
	.db %00000000, %00000000, %00000000, %01111111
	.db %00000000, %00000000, %00000000, %01111111
picture_pic22:

	.db %00111111, %11100011, %11111111, %11111111
	.db %00111111, %10000011, %11111111, %11111111
	.db %00111111, %10000011, %11111111, %11111111
	.db %00111111, %10000111, %11111111, %11111111
	.db %01111111, %10000111, %11111111, %11111111
	.db %01111111, %00000111, %11111111, %11111111
	.db %00000000, %00000111, %11111111, %11111111
	.db %00000000, %00000000, %00111111, %11111111
	.db %00000000, %00000000, %01111111, %11111111
	.db %00000000, %00000000, %01111111, %11111110
	.db %00000000, %00000000, %01111111, %11111000
	.db %00000000, %00000001, %11111111, %11000000
	.db %00000000, %00000001, %11111111, %10000000
	.db %10000000, %00000111, %11111111, %00000000
	.db %11111111, %11111111, %11111110, %00000000
	.db %11111111, %11111111, %11110000, %00000000
picture_pic32:

	.db %11111110, %00000000, %00000000, %00000001
	.db %11111110, %00000000, %00000000, %00000001
	.db %11111110, %00000000, %00000000, %00000001
	.db %11111100, %00000000, %00000000, %00000001
	.db %11111100, %00000000, %00000000, %00000001
	.db %11111000, %00000000, %00000000, %00000001
	.db %11111000, %00000000, %00000000, %00000001
	.db %11110000, %00000000, %00000000, %00000001
	.db %11000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
	.db %00000000, %00000000, %00000000, %00000001
picture_pic03:

	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %10000000, %00000000, %00000000, %00000000
	.db %11111111, %11111111, %11111111, %11111111
picture_pic13:

	.db %00000000, %00000000, %00000000, %00011111
	.db %00000000, %00000000, %00000000, %00011111
	.db %00000000, %00000000, %00000000, %00001111
	.db %00000000, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000111
	.db %00000000, %00000000, %00000000, %00000011
	.db %00000000, %00000000, %00000000, %00000011
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %11111111, %11111111, %11111111, %11111111
picture_pic23:

	.db %11111111, %11111111, %11100000, %00000000
	.db %11111111, %11111111, %11000000, %00000000
	.db %11111111, %11111111, %11000000, %00000000
	.db %11111111, %11111111, %10000000, %00000000
	.db %11111111, %11111111, %10000000, %00000000
	.db %11111111, %11111111, %10000000, %00000000
	.db %11111111, %11111110, %00000000, %00000000
	.db %11111111, %11111110, %00000000, %00000000
	.db %11111111, %11111110, %00000000, %00000000
	.db %01111111, %11111110, %00000000, %00000000
	.db %00111111, %11111110, %00000000, %00000000
	.db %00011111, %11111110, %00000000, %00000000
	.db %00001111, %11111111, %10000000, %00000000
	.db %00000000, %11111111, %00000000, %00000000
	.db %00000000, %00000000, %00000000, %00000000
	.db %11111111, %11111111, %11111111, %11111111

.end

