;Drugwars 3.1
;by Jonah Cohen <ComAsYuAre@aol.com>

#include "TI86.inc"

;#define one_day

.org _asm_exec_ram

	nop
	jp start
	.dw $0000
	.dw description

start:
	call _runIndicOff
	call _flushAllMenus
title_screen:
	call _clrLCD
	ld hl,title_pic
	ld de,$fc3c					;first byte to copy
	ld c,202					;number of bytes
DispRLEL:
	ld a,(hl)					;get the next byte
	cp $91					;is it a run?
	jr z,DispRLERun			;then we need to decode the run
	ldi						;copy the byte, and update counters
DispRLEC:
	ld a,c					;check
	or a						;the high byte for 0
	jr nz,DispRLEL				;if not, then we're not done either
	jr title_done				;if it's zero, we're done
DispRLERun:
	inc hl						;move to the run value
	ld a,(hl)					;get the run value
	inc hl						;move to the run count
	push hl					;save source pointer
	ld h,(hl)					;get the run count
	ex de,hl					;swap source and destination pointers
DispRLERunL:
	ld (hl),a					;copy the byte
	inc hl						;increase destination pointer
	dec c					;decrease byte count
	dec d					;decrease run count
	jr nz,DispRLERunL			;if we're not done, then loop
	ex de,hl					;swap pointers back
	pop hl					;recover source pointer
	inc hl						;advance the source pointer
	jr DispRLEC				;check to see if we should loop

title_done:
	ld hl,author
	ld bc,$1228
	ld (_penCol),bc
	call _vputs
	ld hl,title_table
	jp menu

view_highscores:
	call display_highscore
	jp title_screen

display_highscore:
	call _clrWindow
	res 2,(iy+13)				;no scrolling
	ld hl,highscore_table+2
	ld b,8
display_highscore_loop:
	push bc					;maybe unnecessary
	ld a,'9'
	sub b
	call _putc
	ld a,'.'
	call _putc
	push hl
	call _puts
	pop hl
	push hl
	dec hl
	ld a,(hl)
	dec hl
	ld l,(hl)
	ld h,a					;hl=score
	ld a,16
	ld (_curCol),a
	xor a
	call _dispHL
	pop hl
	ld bc,13
	add hl,bc
	pop bc
	djnz display_highscore_loop
	set 2,(iy+13)
	jp getkey

load_game:
	ld a,30
	ld hl,(health)
	cp (hl)
	jr z,new_game				;if died last game, loading is unavailable
	ld hl,day
	inc a						;check for 31
	cp (hl)
	jr z,new_game				;same if we got through all 30 days
	ld a,(visit_cops)
	cp 2
	jp z,no_of_pigs				;check if we're in the middle of a cop attack thingy
	jp normal_day

save_to:
	push de
	call _SetXXXXOP2
	call _OP2TOOP1
	pop de
	jp _MOVFROP1

new_game:					;reset all data
	xor a
	ld (health),a
	ld (guns),a					;set to 0
	ld (location),a
	ld (visit_cops),a
#ifdef one_day
	ld hl,9999
#else
	ld hl,2000
#endif
	ld de,wallet
	call save_to
#ifdef one_day
	ld hl,0
#else
	ld hl,5000
#endif
	ld de,debt
	call save_to
	ld hl,100
	ld de,trenchcoat
	call save_to
	call _ZEROOP1
	ld de,cocaine_amount
	ld a,6
clear_loop:
	call _MOVFROP1			;clear the amounts of all 6 drugs
	dec a
	jr nz,clear_loop
	inc a						;1
	ld (day),a
	jr first_day

_hl:
	jp (hl)

new_day:
	ld hl,day
	inc (hl)
#ifdef one_day
	ld a,2
#else
	ld a,31
#endif
	cp (hl)
	jp z,ending_sequence
	call _clrScrn
	ld hl,subway
	call puts

first_day:
	call load_debt
	ld a,11
	call _SetXXOP2
	xor a
	ld (_OP2+1),a				;1.1 is interest
	rst 28h					;call _FPMULT
	call _INTGR
	ld de,debt
	call _MOVFROP1
	ld hl,new_cocaine
	ld de,cocaine_price
	ld b,6
new_drug_loop:
	;input:
	;		hl=pointer to lower value, then upper value, then multiplier
	;		de=pointer to drug price (for storage)
	;output:
	;		(de) contains new value
	push bc
	push de
	push hl
	call $33			;_ldhlind
	call _SetXXXXOP2
	call _OP2TOOP1
	pop hl
	inc hl
	inc hl
	push hl
	call $33
	call _SetXXXXOP2
	call _RANDINT
	pop hl
	inc hl
	inc hl
	push hl
	call $33
	call _SetXXXXOP2			;now load multiplier
	rst 28h					;multiply
	pop hl
	pop de					;retrieve storage
	push hl					;save hl
	call _MOVFROP1
	pop hl					;retrieve hl
	inc hl
	inc hl						;now points to next data
	pop bc
	djnz new_drug_loop
	ld a,(visit_cops)
	or a
	jr z,finish_new_day			;check if we're supposed to visit the cops
	call _OP1SET0
	call _OP2SET3
	call rand
	or a
	jp z,cops					;visit cops	1/4 of the time

finish_new_day:
	xor a
	ld (visit_cops),a				;clear it
	call _OP1SET0
	ld a,30
	call _SetXXOP2
	call rand
	cp 22					;check if we should use jump table
	jr nc,skip_call
	ld hl,jump_table
	ld d,0
	ld e,a
	sla e						;2 bytes each
	add hl,de
	call $33					;call _ldhlind
	call _hl
skip_call:
	ld a,(location)
	or a						;check bronx
	ld hl,visit_shark_table
	call z,menu_clr				;call it since we're coming back here anyway

normal_day:
	call _clrScrn
	ld hl,trenchcoat
	rst 20h
	ld hl,cocaine_amount
	ld b,6
subtract_loop:
	push bc
	call _MOV10TOOP2
	push hl
	call _FPSUB				;subtract the amount of each drug
	pop hl
	pop bc
	djnz subtract_loop
	ld de,empty_spaces
	call _MOVFROP1
	ld hl,day_string
	call puts
	ld a,(day)
	call _SetXXOP1
	call disp_real
	ld hl,normal_table
	jp menu

display_prices:
	call _clrWindow
	ld hl,cocaine_price				;display the drug prices
	ld b,6
prices_loop:
	call move_and_display
	djnz prices_loop
	ld hl,wallet
	call move_and_display
	call _homeUp
	ld hl,drug_names
	ld bc,$0703
	call move
	call getkey
	jp normal_day

display_trenchcoat:
	call _clrWindow
	ld hl,cocaine_amount				;display the drug amounts
	ld b,6
trenchcoat_loop:
	call move_and_display
	djnz trenchcoat_loop
	ld hl,empty_spaces
	call move_and_display
	call _homeUp
	ld hl,drug_names
	ld bc,$0603
	call move
	ld hl,trenchcoat_space
	call _puts
	call getkey
	jp normal_day

move_and_display:
	push bc
	rst 20h
	push hl
	call _formDisp
	pop hl
	pop bc
	ret

buy:
	ld a,$37			;buy
	jr buy_sell_menu
sell:
	ld a,$b7			;sell
buy_sell_menu:
	ld (buy_or_sell),a
	ld hl,exchange_table
	jp menu_clr

exchange_cocaine:
	ld hl,cocaine_price
	jr where_to_go

exchange_heroin:
	ld hl,heroin_price
	jr where_to_go

exchange_acid:
	ld hl,acid_price
	jr where_to_go

exchange_weed:
	ld hl,weed_price
	jr where_to_go

exchange_speed:
	ld hl,speed_price
	jr where_to_go

exchange_ludes:
	ld hl,ludes_price

where_to_go:
	ld (price),hl					;save location of price
	ld bc,60						;distance from price to amount
	add hl,bc
	ld (amount),hl					;save location of amount
buy_or_sell:
	or a
	jp nc,sell_drugs

buy_drugs:
	call _clrScrn
	call load_wallet
	ld hl,(price)
	call _MOV10TOOP2
	call _FPDIV
	call _INTGR
	ld de,afford						;number of drugs you can afford
	call _MOVFROP1
	ld bc,$0f02
	call disp_real_bc
	ld hl,empty_spaces
	rst 20h						;call _MOV10TOOP1
	ld bc,$0d03
	call disp_real_bc
	call _OP1TOOP3
	ld hl,buy_messages
	call puts
	inc c
	call puts_bc
	call _homeUp
	call get_number
;check_value
	jr nz,buy_drugs
	rst 08h						;save input value
	ld hl,empty_spaces
	rst 20h
	call _FPSUB
	call isPositive
	jr nz,buy_drugs
	call _OP5TOOP2
	ld hl,afford
	rst 20h
	call _FPSUB
	call isPositive
	jr nz,buy_drugs
;input_valid
	ld hl,(price)
	rst 20h
	call _OP5TOOP2
	rst 28h			;call _FPMULT
	call update_cop_flag	;checks cop flag.  also moves OP1 to OP2 and wallet to OP1
	call _FPSUB
	ld de,wallet
	call _MOVFROP1
	ld hl,(amount)
	rst 20h
	call _OP5TOOP2
	rst 30h
	jr save_data

sell_drugs:
	call _clrScrn
	ld hl,sell_message
	call puts
	ld hl,(amount)
	rst 20h
	ld bc,$0902
	call disp_real_bc
	call _homeUp
	ld hl,buy_messages+30		;"how many?"
	call get_number
;check sell value
	jp nz,sell_drugs
	rst 08h
	ld hl,(amount)
	rst 20h
	call _FPSUB
	call isPositive
	jp nz,sell_drugs
;valid sell value
	ld hl,(price)
	rst 20h
	call _OP5TOOP2
	rst 28h			;call _FPMULT
	call update_cop_flag	;checks cop flag.  also moves OP1 to OP2 and wallet to OP1
	rst 30h			;call _FPADD
	ld de,wallet
	call _MOVFROP1
	ld hl,(amount)
	rst 20h
	call _OP5TOOP2
	call _FPSUB
save_data:
	ld de,(amount)
	call _MOVFROP1
	jp normal_day

update_cop_flag:
	call _OP1TOOP6
	ld a,5
	call _SetXXOP1
	call _TENX
	call _OP6TOOP2
	call _FPSUB
	call isPositive
	jr z,no_visit
	ld a,1			;over $100,000 exchanged
	ld (visit_cops),a		;so we should visit cops
no_visit:
	call load_wallet
	jp _OP6TOOP2

loan_shark:
	ld hl,loan_shark_table
	jp menu_clr

repay_borrow_output:
	call _clrScrn
	ld hl,you_owe
	call puts
	call load_debt
	call disp_real
	ld hl,you_have
	call puts
	call load_wallet
	call disp_real
	jp _homeUp

repay:
	call repay_borrow_output
	ld hl,repay_message
	call get_number
	jr nz,repay
	rst 08h					;save in OP2
	call load_debt
	call _FPSUB				;check if greater than debt
	call isPositive
	jr nz,repay
	call load_wallet
	call _OP5TOOP2
	call _FPSUB
	call isPositive
	jr nz,repay
	ld de,wallet
	call _MOVFROP1
	call load_debt
	call _OP5TOOP2
	call _FPSUB
	jr save_debt

borrow:
	call repay_borrow_output
	ld hl,borrow_message
	call get_number
	call isPositive
	jr nz,borrow
	call _OP2SET0
	call _CPOP1OP2
	ret z						;check for 0
	ld hl,5001
	call _SetXXXXOP2
	call _FPSUB
	call isPositive
	jr z,crazy					;check if greater than 3950
	call _OP5TOOP2
	call load_debt
	rst 30h					;_FPADD
	ld hl,30001
	call _SetXXXXOP2
	call _FPSUB
	call isPositive
	jr z,crazy
	call _OP5TOOP2
	call load_wallet
	rst 30h
	ld de,wallet
	call _MOVFROP1
	call _OP5TOOP2
	call load_debt
	rst 30h
save_debt:
	ld de,debt
	jp _MOVFROP1

crazy:
	call _clrWindow
	ld hl,crazy_message
	call _puts
	call _getkey
	jr borrow

jet:
	ld hl,jet_table
	jp menu_clr

bronx:
	xor a
	jr change_local

not_bronx:
	ld a,1

change_local:
	ld (location),a
	jp new_day

special_drug:
	push de
	push bc
	call _SetXXXXOP2
	call _OP2TOOP1
	pop hl
	call _SetXXXXOP2
	call _RANDINT
	pop de
	jp _MOVFROP1

coke_bust:
	call _OP1SET0
	ld hl,50000
	push hl
	call _SetXXXXOP2
	call _RANDINT
	pop hl
	call _SetXXXXOP2
	rst 30h
	rst 30h
	ld de,cocaine_price
	call _MOVFROP1
	ld hl,coke_bust_message
	ld b,3
	jp move_getkey

heroin_outrageous:
	ld hl,25000
	ld bc,60000
	ld de,heroin_price
	call special_drug
	ld hl,heroin_outrageous_message
	ld b,3
	jp move_getkey

heroin_cheap:
	ld hl,500
	ld bc,1500
	ld de,heroin_price
	call special_drug
	ld hl,heroin_cheap_message
	ld b,3
	jp move_getkey

acid_cheap:
	ld hl,400
	ld bc,800
	ld de,acid_price
	call special_drug
	ld hl,acid_cheap_message
	ld b,3
	jp move_getkey

weed_cheap:
	ld hl,60
	ld bc,140
	ld de,weed_price
	call special_drug
	ld hl,weed_cheap_message
	ld b,4
	jp move_getkey

speed_cheap:
	ld hl,20
	ld bc,50
	ld de,speed_price
	call special_drug
	ld hl,speed_cheap_message
	ld b,2
	jr move_getkey

ludes_cheap:
	ld hl,2
	ld bc,8
	ld de,ludes_price
	call special_drug
	ld hl,ludes_cheap_message
	ld b,4
	jr move_getkey

brownies:
	ld hl,weed_amount
	push hl
	rst 20h
	call _OP2SET2
	call _FPSUB
	pop de					;store into de
	call isPositive
	ret nz					;not enough weed
	call _MOVFROP1
	ld hl,brownie_message
	ld b,4
	jr move_getkey

new_trenchcoat:
	ld hl,new_trenchcoat_table
	jp menu_clr

buy_trenchcoat:
	call load_wallet
	ld hl,200
	call _SetXXXXOP2
	call _FPSUB
	call isPositive
	jr nz,cannot_afford
	ld de,wallet
	call _MOVFROP1
	ld hl,trenchcoat
	rst 20h
	ld a,20
	call _SetXXOP2
	rst 30h
	ld de,trenchcoat
	jp _MOVFROP1

cannot_afford:
	ld hl,not_enough_cash
	ld b,2
move_getkey:				;saves a bunch of bytes
	push bc
	push hl
	call second_line
	pop hl
	pop bc
	call move_center
	jp getkey

found_drugs:
	ld a,4
	call _SetXXOP1
	ld a,9
	call _SetXXOP2
	call _RANDINT
	call _OP1TOOP6
	rst 08h
	ld hl,empty_spaces
	rst 20h
	call _FPSUB
	call isPositive
	ret nz
	call _OP1SET0
	call _OP2SET3
	call rand
	ld hl,found_drugs_table
	add a,a
	add a,a
	ld e,a
	ld d,0
	add hl,de
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	call $33
	push bc
	push hl
	rst 20h
	rst 08h
	call _OP6TOOP1
	rst 30h
	pop de
	call _MOVFROP1
	call second_line
	ld hl,found_drugs_message
	call _puts
	ex (sp),hl
	call _puts
	pop hl
	call _puts
	call _newline
	call _puts
	call _OP6TOOP1
	ld bc,$0a01
	call disp_real_bc
	jp getkey

cops:
	ld a,2
	ld (visit_cops),a					;meaning we're in the middle of one of these
	call _OP1SET2
	ld a,5
	call _SetXXOP2
	call rand
	inc a
	ld (number_of_cops),a
	add a,47						;convert to character
	ld (cops_message+20),a			;add to string
	ld b,3
	ld hl,cops_message
	call move_getkey

cops_menu:
	ld hl,cops_table
	jp menu_clr

fight:
	call second_line
	ld a,(guns)
	call _SetXXOP1
	call _OP2SET3
	rst 28h
	ld a,6
	call _SetXXOP2
	rst 30h
	call _OP2SET0
	call rand
	or a
	jr z,missed
	dec a			;cp 1
	jr z,missed
	dec a			;cp 2
	jr z,hit
	dec a
	jr z,hit
	dec a
	jr z,hit
	dec a
	jr z,hit
	jr shot

hit:
	ld hl,health
	ld a,(hl)
	add a,3
	ld (hl),a
	ld hl,running+11
	call puts_center
	call puts_center
	call _newline
	call getkey
	ld hl,been_hit
	jr puts1_check_health

missed:
	ld hl,missed_message

puts1_check_health:
	ld b,1
puts_check_health:
	call move_center
check_health:
	call getkey
	ld a,(health)
	cp 30
	jr z,dead
	ld a,(number_of_cops)
	or a
	jp z,win_fight
	jr cops_menu

shot:
	ld hl,number_of_cops
	dec (hl)
	ld hl,shot_message
	ld b,2
	jr puts_check_health

dead:
	call second_line
	ld a,31
	ld (day),a
	ld hl,killed
	ld b,4
	call move_getkey
	jp highscore_exit

run:
	call second_line
	ld hl,running
	call puts_center
	push hl
	call _op1set1
	ld a,6
	call _SetXXOP2
	call rand
	push af
	call getkey
	call second_line
	pop af
	pop hl
	cp 6
	jr z,escaped
	cp 5
	jr z,escaped
	push af
	ld b,3
	call move_getkey
	pop af
	ld hl,they_missed
	dec a				;cp 1
	jp z,puts1_check_health
	ld a,(health)
	add a,3
	ld (health),a
	ld hl,been_hit
	jp puts1_check_health

escaped:
	ld hl,lost_them
	push af
	call puts_center
	pop af
	cp 5
	jr z,finish_escape
	ld hl,lost_them+36
finish_escape:
	call puts_center
getkey_new_day:
	call getkey
	jp finish_new_day

view_guns:
	call second_line
	ld a,(guns)
	add a,'0'
	ld (you_have_guns+9),a
	ld hl,you_have_guns
	jp puts1_check_health

view_health:
	call second_line
	ld b,4
	ld hl,you_have_health
	call move_center
	ld a,(health)
	call _SetXXOP1
	ld bc,$0c01
	call disp_real_bc
	jp check_health

no_of_pigs:
	call second_line
	ld a,(number_of_cops)
	add a,'0'
	ld (still_cops+10),a
	ld hl,still_cops
	ld b,2
	jp puts_check_health

win_fight:
	call second_line
	ld hl,killed_them_all
	ld b,4
	call move_center
	call _OP1SET2
	ld a,4
	ld (_OP1+1),a		;OP1=20000
	ld hl,50000
	call _SetXXXXOP2
	call _RANDINT
	ld bc,$0d04
	call disp_real_bc
	rst 08h
	call load_wallet
	rst 30h
	ld de,wallet
	call _MOVFROP1
	jp getkey_new_day

buy_gun:
	ld hl,magnum_string
	ld a,e
	cp 40				;2*20.  divide in half (baretta half the time, magnum half the time)
	jr c,copy_string
	ld hl,baretta_string
copy_string:
	ld de,gun_local
	ld bc,8
	ldir					;copy string into table
	ld hl,buy_gun_table
	jp menu_clr

buy_the_gun:
	call load_wallet
	ld hl,500
	call _SetXXXXOP2
	call _FPSUB
	call isPositive
	jp nz,cannot_afford
	ld de,wallet
	call _MOVFROP1
	ld hl,guns
	inc (hl)
	ret

mugged:
	ld a,(guns)
	or a
	ret nz
	call load_wallet
	call _OP2SET3
	rst 28h					;_FPMULT
	ld a,8
	call _SetXXOP2
	call _FPDIV				;effectively multiply by 3/8
	call _INTGR
	ld de,wallet
	call _MOVFROP1
	ld b,2
	ld hl,mugged_message
	jp move_getkey

move:
	;--------------------------------------------------
	;moves down the screen displaying string at hl
	;
	;input:
	;		b=number of strings to display (max=8)
	;		c=column location
	;		hl=pointer to string
	;		_curRow and _curCol point to first location
	;output:
	;		hl=hl+c
	;		_curRow=_curRow+c
	;		_curCol=c
	;		b=0
	;		a=0
	;--------------------------------------------------

	call _puts
	ex de,hl
	ld hl,_curCol
	ld (hl),c
	dec hl
	inc (hl)
	ex de,hl
	djnz move
	ret

puts_center:
	ld b,1			;one line centered

move_center:
	;--------------------------------------------------
	;moves down the screen displaying string at hl centered
	;
	;input:
	;		b=number of strings to display (max=8)
	;		hl=pointer to string
	;		_curRow is on starting column
	;output:
	;		hl=byte after 0
	;		_curRow=_curRow+c
	;		_curCol=0
	;		b=0
	;		a=0
	;--------------------------------------------------

	push bc
	call _strLength
	srl c
	ld a,10
	sub c		;a=start column
	ld (_curCol),a
	call _puts		;display line
	call _newline	;update row
	pop bc
	djnz move_center
	ret

menu_clr:
	push hl
	call _clrScrn
	pop hl

menu:
	;--------------------------------------------------
	;displays a centered, large-font menu
	;
	;input:
	;		must be jumped to
	;		clear the screen if you want it cleared!
	;		hl=pointer to start of table
	;output:
	;		loads table.  goes to whatever label the user chooses
	;
	;table format:
	;		.db 5			;number of lines
	;		.db 2			;number of lines of title
	;		.db "This is the",0	;each of the five lines in the menu
	;		.db "title",0
	;		.db "Item 1",0
	;		.db "Item 2",0
	;		.db "Item 3",0
	;		.dw exit		;label if exit pressed
	;		.dw label1		;label for first menu item
	;		.dw label2		;label for second menu item
	;		.dw label3		;label for third menu item
	;--------------------------------------------------

	call _homeUp
	call _newline
	ld c,(hl)
	inc hl
	ld e,(hl)		;start of first menu item
	ld b,c		;b=# of lines
	inc hl			;start of messages
	call move_center	;display centered menu
	ld a,c
	sub e
	ld c,a
	push hl		;save hl.  points to start of address table
	ld b,1		;first entry
keyloop_update:
	call highlight
keyloop:
	call getkey
	cp K_UP
	jr z,cursor_up
	cp K_DOWN
	jr z,cursor_down
	cp K_ENTER
	jr z,selected
	cp K_SECOND
	jr z,selected
	cp K_EXIT
	jr nz,keyloop
	ld b,0					;offset in table for exit key
 
selected:
	pop hl					;retrieve address of table
	ld d,0
	ld e,b
	sla e						;2 byte labels
	add hl,de
	call $33					;call _ldhlind
	jp (hl)					;go to label

highlight:
	push de
	push bc
	ld a,b
	add a,e
	ld h,a
	ld l,8*16
	call _HTIMESL				;get offset from vide mem
	ld de,$fc01
	add hl,de					;hl=first byte in video mem
	ld c,8					;# of rows
invert_loop:
	ld b,14					;14 bytes across
flip_bits:
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl	
	djnz flip_bits
	inc hl
	inc hl						;skip 2 bytes
	dec c					;row counter
	jr nz,invert_loop
	pop bc
	pop de
	ret

cursor_up:
	call highlight
	dec b
	jr nz,keyloop_update		;check if cursor is already at top
	ld b,c				;bottom
	jr keyloop_update

cursor_down:
	call highlight
	ld a,b
	inc b
	cp c
	jr nz,keyloop_update		;check if at bottom
	ld b,1
	jr keyloop_update

getkey_cursor:
	call _cursorOn
	call getkey
	jp _cursorOff

getkey:
	push hl
	push de
	push bc
	ld bc,44				;apd countdown = 44*256
getkey_loop:
	halt
	call _getcsc
	or a
	jr z,getkey_nokey
	pop bc
	pop de
	pop hl
	cp K_EXIT
return:					;used in tables
	ret
getkey_nokey:
	djnz getkey_loop
	dec c
	jr nz,getkey_loop
	ld a,1
	out (3),a
	halt
	ld a,11
	out (3),a
	jr getkey_loop

get_number:				;input a number in op1
	call _puts
	ld hl,number
	ld (hl),0
input_number:
	call getkey_cursor
	ex de,hl
	ld hl,numbers
	ld bc,10
	cpir
	ex de,hl
	ld de,number
	jr nz,check_other_keys
	ld e,(number+6)&$ff
	call _cphlde
	jr z,input_number
	ld a,c
	add a,'0'
	ld (hl),a
	inc hl
	call _putc
	jr input_number
check_other_keys:
	cp K_DEL
	jr nz,check_exit_pressed
	call _cphlde
	jr z,input_number
	dec hl
	push hl
	ld hl,_curCol
	dec (hl)
	ld a,' '
	call _putmap
	pop hl
	jr input_number
check_exit_pressed:
	cp K_EXIT
	jr nz,check_num_entered
	xor a
	ld (number),a
	jr tabulate_number
check_num_entered:
	cp K_SECOND
	jr z,number_entered
	cp K_ENTER
	jr nz,input_number
number_entered:
	call _cphlde
	jr z,input_number
	ld (hl),0
tabulate_number:
	call _ZEROOP1
	ld hl,number
add_digits:
	ld a,(hl)
	or a
	jr z,got_number
	push hl
	push af
	ld a,10
	call _SetXXOP2
	rst 28h				;multiply by 10
	pop af
	sub '0'
	call _SetXXOP2
	rst 30h				;add new digit
	pop hl
	inc hl
	jr add_digits
got_number:
	call _OP1TOOP5		;save for storage

isPositive:					;sets z flag if OP1 isn't negative
	ld a,(_OP1)
	bit 7,a
	ret

load_wallet:				;used a million or so times, so we save 1 byte each time
	ld hl,wallet
	rst 20h
	ret

load_debt:					;used almost as frequently
	ld hl,debt
	rst 20h
	ret

rand:
	call _RANDINT
	jp _CONVOP1

disp_real_bc:
	ld (_curRow),bc
disp_real:
	ld a,21
	call _formReal
	ld hl,_OP3
	jr jp_puts

puts:
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
puts_bc:
	ld (_curRow),bc
jp_puts:
	jp _puts

second_line:
	call _clrWindow
	jp _newline			;cursor at start of second line

add_value:
	push de
	call _MOV10TOOP2
	ex (sp),hl				;hl=price, amount is pushed
	rst 20h
	push hl				;push price
	rst 28h
	rst 08h
	ld hl,wallet
	push hl
	rst 20h
	rst 30h
	pop de				;de=wallet
	call _MOVFROP1
	pop de				;retrieve price
	pop hl				;retrieve amount
	ret

ending_sequence:
	call _clrWindow
	ld hl,debt
	rst 20h
	call _OP2SET0
	call _CPOP1OP2
	jr z,repaid_shark
	ld hl,never_repaid_message
	ld b,4
	call move_getkey
	jp highscore_exit
repaid_shark:
	ld hl,cocaine_amount
	ld de,cocaine_price
	ld b,6
add_values:
	push bc
	call add_value
	pop bc
	djnz add_values
	ld hl,game_over
	ld b,3
	call move_center
	ld a,5
	call _SetXXOP1
	call _TENX
	rst 08h
	call load_wallet
	call _FPDIV
	call _INTGR
#ifdef one_day
	ld a,50
	call _SetXXOP1
#endif
	ld bc,$0e02
	call disp_real_bc
	ld de,_OP3
	ld hl,0
add_highscore:
	ld a,(de)
	inc de
	sub '0'
	jr c,done_highscore
	add hl,hl
	ld b,h
	ld c,l
	add hl,hl
	add hl,hl
	add hl,bc					;*10
	ld c,a
	ld b,0
	add hl,bc
	jr add_highscore
done_highscore:
	ex de,hl
	ld hl,highscore_table-13
	ld b,8
search_highscores:
	push bc
	ld bc,13
	add hl,bc
	push hl
	call $33
	sbc hl,de
	pop hl
	pop bc
	jr c,new_highscore
	djnz search_highscores
no_highscore:
	call getkey
	jp highscore_exit
new_highscore:
	ld (hl),e
	inc hl
	ld (hl),d
	dec b
	jr z,last_highscore
	dec hl
	ex de,hl
	ld hl,cocaine_price-14
	push hl
	or a
	sbc hl,de
	ex (sp),hl
	pop bc
	ld de,cocaine_price-1
	lddr
	inc hl
last_highscore:
	inc hl
	push hl
	call _newline
	call _newline
	ld hl,got_highscore
	call _puts
	pop hl
	xor a
	ld (hl),a
	ld (num_letters),a
	set shiftAlpha,(iy+shiftFlags)
get_name:
	call getkey_cursor
	ex de,hl
	ld hl,letters
	ld bc,26
	cpir
	ex de,hl
	jr nz,check_other_letter_keys
	ld a,c
	add a,'A'
	bit shiftLwrAlph,(iy+shiftFlags)
	jr z,insert_letter
	add a,'a'-'A'
insert_letter:
	ld b,a
	ld a,0
num_letters = $-1
	cp 10
	jr z,get_name
	inc a
	ld (num_letters),a
	ld a,b
	ld (hl),a
	inc hl
	call _putc
	jr get_name
check_other_letter_keys:
	cp K_ALPHA
	jr nz,check_space
	ld a,(iy+shiftFlags)
	xor %00100000				;toggle upper/lower
	ld (iy+shiftFlags),a
	jr get_name
check_space:
	cp K_SIGN
	jr nz,check_delete
	ld a,' '
	jr insert_letter
check_delete:
	cp K_DEL
	jr nz,check_name_entered
	ld a,(num_letters)
	or a
	jr z,get_name
	dec a
	ld (num_letters),a
	dec hl
	push hl
	ld hl,_curCol
	dec (hl)
	ld a,' '
	call _putmap
	pop hl
	jr get_name
check_name_entered:
	cp K_ENTER
	jr nz,get_name
	ld (hl),0
	res shiftAlpha,(iy+shiftFlags)
highscore_exit:
	call display_highscore

exit:
	ld hl,_asapvar
	rst 20h				;copy to OP1
	rst 10h				;_findsym
	xor a
	ld hl,highscore_table-_asm_exec_ram+4		;offset
	add hl,de				;hl=pointer to data in original prog
	adc a,b				;in case we overlapped
	call _SET_ABS_DEST_ADDR
	xor a					;no absolute addressing now
	ld hl,highscore_table		;get data from here
	call _SET_ABS_SRC_ADDR
	ld hl,260				;number of bytes to save
	call _SET_MM_NUM_BYTES
	call _MM_LDIR			;copy data
quit:
	res 4,(iy+9)			;no on interrupt
	jp _clrWindow

jump_table:				;random events each day
	.dw coke_bust
	.dw coke_bust
	.dw coke_bust
	.dw heroin_outrageous
	.dw heroin_cheap
	.dw acid_cheap
	.dw weed_cheap
	.dw speed_cheap
	.dw ludes_cheap
	.dw brownies
	.dw brownies
	.dw brownies
	.dw brownies
	.dw new_trenchcoat
	.dw new_trenchcoat
	.dw new_trenchcoat
	.dw found_drugs
	.dw mugged
	.dw buy_gun
	.dw buy_gun
	.dw buy_gun
	.dw buy_gun

;menu tables

title_table:
	.db 6
	.db 3
	.db 0
	.db 0
	.db 0					;3 blank lines for title
	.db "Start new game",0
	.db "Resume game",0
	.db "View highscores",0
	.dw exit
	.dw new_game
	.dw load_game
	.dw view_highscores

visit_shark_table:
	.db 5
	.db 3
	.db "Do you want to visit",0
	.db "the loan shark?",0
	.db 0
	.db "Yeah",0
	.db "No way",0
	.dw return
	.dw loan_shark
	.dw return

loan_shark_table:
	.db 5
	.db 2
	.db "What'll it be?",0
	.db 0
	.db "Repay",0
	.db "Borrow",0
	.db "Nevermind!",0
	.dw return
	.dw repay
	.dw borrow
	.dw return

normal_table:
	.db 5
	.db 0
	.db "Prices",0
	.db "Trenchcoat",0
	.db "Buy drugs",0
	.db "Sell drugs",0
	.db "Jet",0
	.dw exit
	.dw display_prices
	.dw display_trenchcoat
	.dw buy
	.dw sell
	.dw jet

exchange_table:
	.db 6
	.db 0
	.db "Cocaine",0
	.db "Heroin",0
	.db "Acid",0
	.db "Weed",0
	.db "Speed",0
	.db "Ludes",0
	.dw normal_day
	.dw exchange_cocaine
	.dw exchange_heroin
	.dw exchange_acid
	.dw exchange_weed
	.dw exchange_speed
	.dw exchange_ludes

jet_table:
	.db 6
	.db 0
	.db "Bronx",0
	.db "Ghetto",0
	.db "Central Park",0
	.db "Manhattan",0
	.db "Coney Island",0
	.db "Brooklyn",0
	.dw normal_day
	.dw bronx
	.dw not_bronx
	.dw not_bronx
	.dw not_bronx
	.dw not_bronx
	.dw not_bronx

new_trenchcoat_table:
	.db 6
	.db 4
	.db "Will you buy a new",0
	.db "trenchcoat with more",0
	.db "pockets for $200?",0
	.db 0
	.db "Sure",0
	.db "No way",0
	.dw return
	.dw buy_trenchcoat
	.dw return

cops_table:
	.db 5
	.db 0
	.db "Fight",0
	.db "Run",0
	.db "View Guns",0
	.db "View Health",0
	.db "No. of Pigs",0
	.dw exit
	.dw fight
	.dw run
	.dw view_guns
	.dw view_health
	.dw no_of_pigs

buy_gun_table:
	.db 5
	.db 3
	.db "Will you pay $500",0
gun_local = $+6
	.db "for a         ",0
	.db 0
	.db "Sure",0
	.db "No way",0
	.dw return
	.dw buy_the_gun
	.dw return

;strings
description:		.db "Drugwars 3.1 "
author:			.db "by Jonah Cohen",0
subway:			.db 3,6,"subway...",0
day_string:		.db 0,15,"Day ",0
drug_names:
				.db "  Cocaine:",0
				.db "Heroin:",0
				.db "  Acid:",0
				.db "  Weed:",0
				.db " Speed:",0
				.db " Ludes:",0
				.db "Wallet:",0
trenchcoat_space:	.db " Empty:",0
buy_messages:
				.db 2,0
				.db "You can afford",0
				.db "You can hold",0
				.db "How many?",0
sell_message:		.db 2,0,"You have",0
you_owe:			.db 2,0,"You owe $",0
you_have:			.db 3,0,"You have $",0
repay_message:	.db "Repay $",0
borrow_message:	.db "Borrow $",0
crazy_message:
				.db "You think he's crazy,"
				.db "man?!",0
coke_bust_message:
				.db "Cops made a big",0
				.db "coke bust!  Prices",0
				.db "are outrageous!",0
heroin_outrageous_message:
				.db "Addicts are buying",0
				.db "heroin at outrageous",0
				.db "prices!",0
heroin_cheap_message:
				.db "Pigs are selling",0
				.db "cheap heroin from",0
				.db "last week's raid!",0
acid_cheap_message:
				.db "The market has been",0
				.db "flooded with cheap",0
				.db "homemade acid!",0
weed_cheap_message:
				.db "Colombian freighter",0
				.db "dusted the coast",0
				.db "guard! Weed prices",0
				.db "have bottomed out!",0
speed_cheap_message:
				.db "Rival dealers are",0
				.db "selling cheap speed!",0
ludes_cheap_message:
				.db "Rival drug dealers",0
				.db "raided a pharmacy",0
				.db "and are selling",0
				.db "CHEAP LUDES !!!",0
brownie_message:
				.db "Your mama made some",0
				.db "brownies and used",0
				.db "your weed!",0
				.db "They were great!",0
not_enough_cash:
				.db "You don't have",0
				.db "enough cash.",0
found_drugs_message:
				.db "You found   units of   ",0
				.db " on a dead",0
				.db " dude in the subway!",0
cocaine:			.db "cocaine",0
heroin:			.db " heroin",0
acid:				.db " acid",0
weed:			.db " weed",0
found_drugs_table:
				.dw cocaine,cocaine_amount
				.dw heroin,heroin_amount
				.dw acid,acid_amount
				.dw weed,weed_amount
cops_message:
				.db "Officer Hardass and",0
				.db "  of his deputies",0
				.db "are after you!",0
missed_message:	.db "  You missed them!",0
shot_message:
				.db "You killed one of",0
				.db "them!",0
killed:
				.db "You were killed by",0
				.db "Officer Hardass!",0,0
				.db "What a loser!",0
running:
				.db "Running...",0
				.db "They're firing at",0
				.db "you!",0,0
they_missed:		.db "They missed!",0
been_hit:			.db "You've been hit!",0
lost_them:
				.db "You lost them in a",0
				.db "vacant building!",0
				.db "sewer!",0
you_have_guns:		.db "You have   guns.",0
you_have_health:
				.db "You have   /30",0
				.db "health.",0,0
				.db "30/30 = Death",0
still_cops:
 				.db "There are   pigs",0
				.db " chasing after you!",0
killed_them_all:
				.db "You killed them all!",0,0
				.db "On Hardass's corpse,",0
				.db "you find $    .",0
magnum_string:		.db "Magnum? "
baretta_string:		.db "Baretta?"
mugged_message:
				.db "You were mugged on",0
				.db "the subway!",0
never_repaid_message:
				.db "You never repaid the",0
				.db "loan shark!",0,0
				.db "Score = 0",0
game_over:
				.db "Game Over",0,0
				.db "Score = ",0
got_highscore:
				.db "  Congratulations!   "
				.db "You got a highscore! "
				.db "Name:",0

;title screen
title_pic:
 .db $F0,$00,$C0,$00,$00,$03,$F0,$91,$00,$08,$03,$F8,$03
 .db $C0,$00,$00,$07,$F8,$91,$00,$08,$03,$BC,$07,$C0,$00,$00,$06,$1C
 .db $6E,$73,$1F,$30,$C6,$7C,$37,$3C,$00,$1C,$01,$C0,$00,$00,$06,$1C
 .db $7E,$E7,$3F,$B1,$CE,$6E,$3F,$7E,$00,$78,$01,$80,$00,$00,$0E,$1C
 .db $F6,$E7,$73,$BB,$CC,$0E,$7B,$60,$01,$F0,$03,$80,$00,$00,$0E,$1C
 .db $E0,$C6,$61,$9B,$DC,$7E,$70,$78,$01,$F8,$03,$80,$00,$00,$0C,$38
 .db $C1,$C6,$61,$9E,$F8,$EE,$60,$3C,$00,$38,$03,$91,$00,$03,$1C,$70
 .db $C1,$CE,$63,$9E,$79,$CE,$60,$0C,$00,$39,$87,$91,$00,$03,$1F,$F1
 .db $C1,$FE,$7F,$1C,$71,$9C,$E1,$DC,$07,$F3,$9F,$C0,$00,$00,$1F,$C1
 .db $C0,$EE,$3F,$18,$61,$FC,$E0,$F8,$07,$E3,$9F,$C0,$91,$00,$06,$07
 .db $91,$00,$0F,$EE,$91,$00,$0F,$7C

numbers:			.db K_9,K_8,K_7,K_6,K_5,K_4,K_3,K_2,K_1,K_0
letters:			.db $19,$21,$0a,$12,$1a,$22,$0b,$13,$1b
				.db $23,$2b,$0c,$14,$1c,$24,$2c,$0d,$15
				.db $1d,$25,$2d,$0e,$16,$1e,$26,$2e

;used for new prices
new_cocaine:		.dw 15000,30000,1
new_heroin:		.dw 5000,14000,1
new_acid:			.dw 10,45,100
new_weed:		.dw 30,90,10
new_speed:		.dw 7,25,10
new_ludes:		.dw 1,6,10

;data
highscore_table:
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0
				.dw 0 \ .db "__________",0

cocaine_price:		.db $00,$05,$FC,$30,$00,$00,$00,$00,$00,$00
heroin_price:		.db $00,$04,$FC,$15,$00,$00,$00,$00,$00,$00
acid_price:			.db $00,$03,$FC,$40,$00,$00,$00,$00,$00,$00
weed_price:		.db $00,$02,$FC,$70,$00,$00,$00,$00,$00,$00
speed_price:		.db $00,$02,$FC,$20,$00,$00,$00,$00,$00,$00
ludes_price:		.db $00,$01,$FC,$50,$00,$00,$00,$00,$00,$00

cocaine_amount:	.db $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00
heroin_amount:		.db $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00
acid_amount:		.db $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00
weed_amount:		.db $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00
speed_amount:		.db $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00
ludes_amount:		.db $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00

trenchcoat:		.db $00,$02,$FC,$10,$00,$00,$00,$00,$00,$00			;begins equal to 100
wallet:			.db $00,$03,$FC,$20,$00,$00,$00,$00,$00,$00			;wallet value $2000
debt:				.db $00,$03,$FC,$50,$00,$00,$00,$00,$00,$00			;debt value $5000

day:				.db 31										;forces a new game if they try to load
location:			.db 0
health:			.db 0
guns:			.db 0
visit_cops:			.db 0											;whether to visit cops or not
number_of_cops:	.db 0

;temporary data
price				=	$8100			;2 bytes
amount			=	price+2			;2 bytes
afford				=	amount+2			;10 bytes
empty_spaces		=	afford+10			;10 bytes - empty spaces in trenchcoat
number			=	empty_spaces+10	;8 bytes - inputted number in string form

.end
