#include "ti86asm.inc"


board	=	_textShadow
ThinkMem	=	$8200


width = _textShadow+60
height = _textShadow+61
Coords = _textShadow+62
OldCoords = _textShadow+64
Mode = _textShadow+66
Player = _textShadow+67
Order = _textShadow+68
Flag = _textShadow+69
Exist01Flag = _textShadow+70
Exist3Flag = _textShadow+71
NumOfS = _textShadow+72
NumOfFS = _textShadow+73
Points = _textShadow+74

.org _asm_exec_ram

	nop
	jp ProgStart
	.dw 0
	.dw ShellTitle

ShellTitle:
	.db "Dots v1.0 - TCPA",0

ProgStart:
	call _flushallmenus
	call _runindicoff
FirstBegin:
	call _clrScrn
	res appTextSave,(iy+appflags)
	ld hl,_textShadow
	ld d,h
	ld e,l
	inc de
	ld (hl),0
	ld bc,80
	ldir
	ld a,5
	ld (width),a
	ld (height),a
	ld hl,$0600
	ld (_curRow),hl
	ld hl,Text
	call _puts
	ld bc,8*256+44
	ld (_penCol),bc
	call _vputs
	ld bc,14*256+41
	ld (_penCol),bc
	call _vputs
	ld bc,22*256+5
	ld (_penCol),bc
	call _vputs
	ld bc,22*256+71
	ld (_penCol),bc
	call _vputs	
	ld bc,51*256+27
	ld (_penCol),bc
	call _vputs
	ld bc,57*256+32
	ld (_penCol),bc
	call _vputs
	ld bc,32*256+2
	ld (_penCol),bc
	call _vputs
	ld bc,40*256+48
	ld (_penCol),bc
	call _vputs
	call DispHW
	xor a
	ld (Order),a
	ld a,$60
	ld (_@label),a
	call Invert
StartLoop:
	call _getky
	cp K_LEFT
	jr z,ChangeInvert
	cp K_RIGHT
	jr z,ChangeInvert
	cp K_SECOND
	jr z,ChangeSize
	cp K_DOWN
	jr z,ChangeSize
	cp K_ENTER
	jr z,Begin
	cp K_EXIT
	jp z,Quit
	jr StartLoop

ChangeInvert:
	call Invert
	ld a,(_@label)
	cp $60
	jr z,SkipInvert
	ld a,$60
ReturnInvert:
	ld (_@label),a
	call Invert
	ld a,(Mode)
	xor 1
	ld (Mode),a
	jr StartLoop
SkipInvert:
	ld a,$68
	jr ReturnInvert

ChangeSize:
	call InvertOther
ChangeLoop:
	call _getky
	ld hl,width
	cp K_LEFT
	jr z,DecreaseWidth
	cp K_RIGHT
	jr z,IncreaseWidth
	inc hl
	cp K_UP
	jr z,IncreaseHeight
	cp K_DOWN
	jr z,DecreaseHeight
	cp K_ENTER
	jr z,Begin
	cp K_SECOND
	jr z,Begin
	cp K_EXIT
	jp z,Quit
	jr ChangeLoop

IncreaseWidth:
	ld a,(hl)
	cp 9
	jr z,ChangeLoop
	inc a
	jr SizeCommon

DecreaseWidth:
DecreaseHeight:
	ld a,(hl)
	cp 3
	jr z,ChangeLoop
	dec a
SizeCommon:
	ld (hl),a
	call DispHW
	jr ChangeLoop

IncreaseHeight:
	ld a,(hl)
	cp 6
	jr z,ChangeLoop
	inc a
	jr SizeCommon

Begin:
	call _clrLCD
	call DrawDots
	ld hl,0
	ld (Coords),hl
	ld (OldCoords),hl
	xor a
	ld (Flag),a
	inc a
	ld (Player),a
	ld bc,$0101
	ld de,marker
	call PutSprite
	call UpdateMenu


MainLoop:
	ld hl,(Coords)
	ld (OldCoords),hl
	ld a,(Mode)
	or a
	jr z,GetInput
	ld a,(Order)
	ld b,a
	ld a,(Player)
	cp b
	jp z,CalcsTurn
GetInput:
	call _getky
	dec a
	jr z,MoveDown
	dec a
	jr z,MoveLeft
	dec a
	jr z,MoveRight
	dec a
	jr z,MoveUp
	cp K_EXIT-4
	jp z,FirstBegin			;Quit
	cp K_SECOND-4
	jr z,DrawLineMode
	jr GetInput

MoveDown:
	ld a,(height)
	ld b,a
	ld a,(Coords+1)
	inc a
	cp b
	jr z,GetInput
	ld (Coords+1),a
	jp PutMarker

MoveLeft:
	ld a,(Coords)
	or a
	jr z,GetInput
	dec a
	ld (Coords),a
	jp PutMarker

MoveRight:
	ld a,(width)
	ld b,a
	ld a,(Coords)
	inc a
	cp b
	jr z,GetInput
	ld (Coords),a
	jp PutMarker

MoveUp:
	ld a,(Coords+1)
	or a
	jr z,GetInput
	dec a
	ld (Coords+1),a
	jp PutMarker

DrawLineMode:
	call PutPen
DLMKLoop:
	call _getky
	dec a
	jr z,DrawDown
	dec a
	jr z,DrawLeft
	dec a
	jr z,DrawRight
	dec a
	jr z,DrawUp
	cp K_EXIT-4
	jp z,FirstBegin				;Quit
	cp K_SECOND-4
	jr nz,DLMKLoop

EndDrawMode2:
	call PutPen
	jp MainLoop	;GetInput

DrawDown:
	call CalcAddr
	bit 0,(hl)
	jr nz,DLMKLoop
	set 0,(hl)
	ld a,(Coords+1)	;y
	inc a
	ld b,a
	ld a,(height)
	cp b
	jp z,DrawDLine
	add hl,de
	set 1,(hl)
	jp DrawDLine

DrawLeft:
	call CalcAddr
	bit 3,(hl)
	jr nz,DLMKLoop
	set 3,(hl)
	ld a,(Coords)	;x
	or a
	jp z,DrawLLine
	dec hl
	set 2,(hl)
	jp DrawLLine

DrawRight:
	call CalcAddr
	bit 2,(hl)
	jr nz,DLMKLoop
	set 2,(hl)
	ld a,(Coords)	;x
	inc a
	ld b,a
	ld a,(width)
	cp b
	jp z,DrawRLine
	inc hl
	set 3,(hl)
	jp DrawRLine

DrawUp:
	call CalcAddr
	bit 1,(hl)
	jr nz,DLMKLoop
	set 1,(hl)
	ld a,(Coords+1)	;y
	or a
	jp z,DrawULine
	and a
	sbc hl,de
	set 0,(hl)
	jp DrawULine


DrawDLine:
	call CalculateLine
	add hl,de
CommonUD:
	ld a,255
	ld (hl),a
	jp EndDrawMode

DrawLLine:
	call CalculateLine
CommonLR:
	ld de,16
	ld b,7
DrawLLLoop:
	ld a,%10000000
	add hl,de
	xor (hl)
	ld (hl),a
	djnz DrawLLLoop
	jp EndDrawMode

DrawRLine:
	call CalculateLine
	inc hl
	jr CommonLR

DrawULine:
	call CalculateLine
	jr CommonUD

CalculateLine:			;Makes hl point to the square in videomem
	ld hl,$FC71-128
	ld de,128
	ld bc,(Coords)
	inc b
CLLoop:
	add hl,de
	djnz CLLoop
	add hl,bc
	ret

Invert:
	ld hl,$FC00+(16*25)
_@label = $-2
	ld de,8
	ld c,7
InvLoop2:
	ld b,8
InvLoop1:
	ld a,(hl)
	xor 255
	ld (hl),a
	inc hl
	djnz InvLoop1
	add hl,de
	dec c
	jr nz,InvLoop2
	ret

InvertOther:
	ld hl,$FC00+(16*32)
	ld de,11
	ld c,7
InvLoop4:
	ld b,5
InvLoop3:
	ld a,(hl)
	xor 255
	ld (hl),a
	inc hl
	djnz InvLoop3
	add hl,de
	dec c
	jr nz,InvLoop4
	ret


CalcAddr:			;makes hl point to the square pointed to by the coords
	ld bc,(Coords)	;c=x b=y
	ld hl,board		;y=coords+1
	ld a,(width)
	ld e,a
	ld d,0
	and a
	sbc hl,de
	inc b
CALoop:
	add hl,de
	djnz CALoop
	add hl,bc
	ret

DrawDots:
	ld hl,$FC71
	ld a,(height)
	inc a
	ld b,a
DDLoop1:
	push bc
	ld a,(width)
	ld c,a
	inc a
	ld b,a
	ld a,15
	sub c
	ld e,a
	ld d,0
	ld a,%10000000
DDLoop2:
	ld (hl),a
	inc hl
	djnz DDLoop2
	add hl,de
	ld de,112
	add hl,de
	pop bc
	djnz DDLoop1
	ret

Quit:
	set appTextSave,(iy+appflags)
	call _clrScrn
	jp _homeup


CalcsTurn:
	xor a
	ld (Exist3Flag),a
	ld (Exist01Flag),a
	call NumberOfSquares
	ld (NumOfS),a
	ld b,a
	ld hl,board		;Coords
					;y=coords+1
QuestFor013:
	ld a,(hl)
	and %00001111
	or a
	jp z,Set01Flag2
	call CheckFor3
	call CheckFor1
	inc hl
	djnz QuestFor013

SkipTheRest1:
	ld de,$0000		;d=y e=x
	ld c,d
	ld hl,ThinkMem
	push hl
	ld a,(NumOfS)
	ld b,a
	ld hl,board
WriteCoords:
	ld a,(Exist3Flag)
	or a
	jr nz,WeHaveA3
	ld a,(Exist01Flag)
	or a
	jr nz,WeHaveA0Or1
	ld a,(hl)
	and %00001111
	cp %00001100
	jp z,WriteCoord
	cp %00001010
	jp z,WriteCoord
	cp %00000110
	jp z,WriteCoord
	cp %00001001
	jp z,WriteCoord
	cp %00000101
	jp z,WriteCoord
	cp %00000011
	jp z,WriteCoord
	call IncreaseCoord
	djnz WriteCoords
	jp CoordsAreWritten

WeHaveA0Or1:	
	ld a,(hl)
	and %00001111
	or a
	jp z,WriteCoord
	cp %00000001
	jp z,WriteCoord
	cp %00000010
	jp z,WriteCoord
	cp %00000100
	jp z,WriteCoord
	cp %00001000
	jp z,WriteCoord
	call IncreaseCoord
	djnz WriteCoords
	jp CoordsAreWritten

WeHaveA3:
	ld a,(hl)
	and %00001111
	cp %00001110
	jp z,WriteCoord
	cp %00001101
	jp z,WriteCoord
	cp %00001011
	jp z,WriteCoord
	cp %00000111
	jp z,WriteCoord
	call IncreaseCoord
	djnz WriteCoords




CoordsAreWritten:
	call Delay
	pop hl				;EndOfThinkMem
	ld bc,ThinkMem
	and a
	sbc hl,bc
	ld a,l
	or a
	jp z,_jforcecmdnochar
	sra a
	call Random
	add a,a
	ld hl,ThinkMem
	ld c,a
	ld b,0
	add hl,bc
	ld a,(hl)
	ld (Coords),a
	inc hl
	ld a,(hl)
	ld (Coords+1),a

	ld bc,(OldCoords)
	ld de,marker
	inc b
	inc c
	call PutSprite
	ld bc,(Coords)
	ld de,marker
	inc b
	inc c
	call PutSprite

	ld hl,(Coords)
	ld (OldCoords),hl

	call PutPen
	call Delay

GetLRUD:
	ld a,4
	call Random
	or a
	jr z,TestLeft
	cp 1
	jr z,TestRight
	cp 2
	jr z,TestUp
	;jr TestDown

TestDown:
	call CalcAddr
	bit 0,(hl)
	jr nz,GetLRUD
	set 0,(hl)
	ld a,(Coords+1)	;y
	inc a
	ld b,a
	ld a,(height)
	cp b
	jp z,DrawDLine
	add hl,de
	set 1,(hl)
	jp DrawDLine

TestLeft:
	call CalcAddr
	bit 3,(hl)
	jr nz,GetLRUD
	set 3,(hl)
	ld a,(Coords)	;x
	or a
	jp z,DrawLLine
	dec hl
	set 2,(hl)
	jp DrawLLine

TestRight:
	call CalcAddr
	bit 2,(hl)
	jr nz,GetLRUD
	set 2,(hl)
	ld a,(Coords)	;x
	inc a
	ld b,a
	ld a,(width)
	cp b
	jp z,DrawRLine
	inc hl
	set 3,(hl)
	jp DrawRLine

TestUp:
	call CalcAddr
	bit 1,(hl)
	jr nz,GetLRUD
	set 1,(hl)
	ld a,(Coords+1)	;y
	or a
	jp z,DrawULine
	and a
	sbc hl,de
	set 0,(hl)
	jp DrawULine


	

Random:                ; Creates a random number 0 <= x < A
	ld b,a
	ld a,r
	add a,a
	ld hl,0
	ld d,0
	ld e,a
RMul:
	add hl,de
	djnz RMul
	ld a,h
	ret







WriteCoord:
	pop hl
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl
	push hl
	push bc
	ld b,0
	ld hl,board
	add hl,bc
	pop bc
	call IncreaseCoord
	dec b
	jp nz,WriteCoords
	jp CoordsAreWritten

IncreaseCoord:
	inc c
	inc hl
	ld a,(width)
	dec a
	cp e
	jr z,NextLineOfS
	inc e
	ret
NextLineOfS:
	inc d
	ld e,0
	ret

CheckFor1:
	cp %00000001
	jr z,Set01Flag
	cp %00000010
	jr z,Set01Flag
	cp %00000100
	jr z,Set01Flag
	cp %00001000
	ret nz
Set01Flag:
	pop de			;Remove call
Set01Flag2:
	ld a,1
	ld (Exist01Flag),a
	inc hl
	dec b
	jp nz,QuestFor013
	jp SkipTheRest1

CheckFor3:
	cp %00001110
	jr z,Set3Flag
	cp %00001101
	jr z,Set3Flag
	cp %00001011
	jr z,Set3Flag
	cp %00000111
	ret nz
Set3Flag:
	ld a,1
	ld (Exist3Flag),a
	pop hl				;Remove the call
	jp SkipTheRest1




NumberOfSquares:
	ld a,(width)
	ld b,a
	ld a,(height)
	ld c,a
	xor a
NOSLoop:
	add a,c
	djnz NOSLoop
	ret



EndDrawMode:
	call NumberOfSquares
	ld b,a
	ld hl,board
CheckForFullLoop:
	ld a,(hl)
	bit 7,a
	jr nz,SkipSomething
	and %00001111
	cp %00001111
	call z,FullSquare
SkipSomething:
	inc hl
	djnz CheckForFullLoop
	call UpdateMenu
	jp EndDrawMode2

FullSquare:
	push bc
	push hl
	set 7,a
	ld (hl),a
	ld bc,_textShadow
	ld de,0
	and a
	sbc hl,bc
	ld a,(width)
	ld c,a
	ld a,l
FullSquareCalc:
	cp c
	jr c,TakeItEasy
	inc d				;y
	sub c
	jr FullSquareCalc
TakeItEasy:
	inc e			;x
	dec a
	jr nz,TakeItEasy

	ld b,d
	ld c,e
	inc b
	inc c
	ld de,circle
	ld a,(Player)
	or a
	jr nz,LoadCross
Return:
	call PutSprite
	ld hl,Points
	ld a,(Player)
	ld c,a
	ld b,0
	add hl,bc
	inc (hl)
	ld a,1
	ld (Flag),a
	call NumberOfSquares
	ld b,a
	ld a,(NumOfFS)
	inc a
	ld (NumOfFS),a
	cp b
	jr z,FullBoard
	pop hl
	pop bc
	ret

LoadCross:
	ld de,cross
	jr Return

FullBoard:
	pop hl
	pop hl
	pop hl
	call UpdateMenu
	call BlackBar
	call PutPen
	ld a,(Points)
	ld b,a
	ld a,(Points+1)
	cp b
	jr z,ItsADraw
	jr c,FirstWins
SecondWins:
	ld a,(Mode)			;0=human vs. human 1=human vs. calc
	or a
	jr nz,YouWin
	ld hl,Win2txt
	jr DisplayWintxt
YouWin
	ld hl,YouWintxt
	jr DisplayWintxt
ItsADraw:
	ld hl,Drawtxt
	jr DisplayWintxt
FirstWins:
	ld a,(Mode)
	or a
	jr nz,CalcWin
	ld hl,Win1txt
	jr DisplayWintxt
CalcWin:
	ld hl,CalcWintxt

DisplayWintxt:
	ld bc,$0403
	ld (_curRow),bc
	set textInverse,(iy+textflags)
	call _puts
	res textInverse,(iy+textflags)
	call _getkey
	jp FirstBegin

BlackBar:
	ld hl,$FC00+(16*23)
	ld a,255
	ld b,160
BBLoop:
	ld (hl),a
	inc hl
	djnz BBLoop
	ret

UpdateMenu:
	ld a,(Flag)
	or a
	jr nz,SkipSwitch
	ld a,(Player)
	xor 1
	ld (Player),a
SkipSwitch:
	xor a
	ld (Flag),a
	ld a,(Player)
	or a
	jr nz,SkipInvert1
	set textInverse,(iy+textflags)
SkipInvert1:
	ld hl,0*256+90
	ld (_penCol),hl
	ld hl,Player1txt
	call _vputs
	res textInverse,(iy+textflags)
	ld a,(Player)
	or a
	jr z,SkipInvert2
	set textInverse,(iy+textflags)
SkipInvert2:
	ld bc,0*256+110
	ld (_penCol),bc
	call _vputs
	res textInverse,(iy+textflags)
	ld hl,10*256+90
	ld (_penCol),hl
	ld a,(Points)
	call DispA
	ld hl,10*256+110
	ld (_penCol),hl
	ld a,(Points+1)
	jp DispA
	
DispHW:
	ld hl,$0804
	ld (_curRow),hl
	ld a,(width)
	add a,'0'
	call _putc
	ld hl,Times
	call _puts
	ld a,(height)
	add a,'0'
	jp _putc



DispA:                                  ;Routine to Display A [By: Matthew Shepcar]
 ld l,a                                 ;Loads a into l
 ld h,0                                 ;0 into H
DispHL:                                 ;Displays HL [By: Matthew Shepcar]
 xor a                                  ;Loads 0 into A
 ld de,-1                               ;Loads -1 into DE
 ld (_curRow),de                        ;Loads de into CurRow
 call 4A33h                             ;Calls 4A33h
 dec hl                                 ;Decrease it
 jp _vputs                              ;Put on screen and return


Delay:
	ld b,$90
DelayLoop:
	halt
	djnz DelayLoop
	ret

PutMarker:
	ld bc,(OldCoords)
	ld de,marker
	inc b
	inc c
	call PutSprite
	ld bc,(Coords)
	ld de,marker
	inc b
	inc c
	call PutSprite
	jp MainLoop

PutPen:
	ld b,7
	ld c,14
	ld de,pen
	jp PutSprite

; de = sprite
; b,c = y,x

PutSprite:
	push de
	ld hl,$FC00-128
	inc b
	ld de,128
PSLoop:
	add hl,de
	djnz PSLoop
	add hl,bc
	pop de
	ld b,8
PSLoop2:
	push bc
	ld bc,16
	ld a,(de)
	xor (hl)
	ld (hl),a
	inc de
	add hl,bc
	pop bc
	djnz PSLoop2
	ret


Player1txt:
	.db " P 1",0
Player2txt:
	.db " P 2",0

Text:
	.db "Dots v1.0",0
TCPA:
	.db "a TCPA game",0
Web:
	.db "tcpa.calc.org",0

Human:
	.db "Human vs. Human",0
TI86:
	.db "Human vs. TI-86",0

Author:
	.db "Made by Andreas Finne",0
Mail:
	.db "andreas@calc.org",0

Sizetxt:
	.db "Board size:",0

Arrowtxt:
	.db 207,5,"               ",6,7,0

Times:
	.db " x ",0

Win1txt:
	.db "Player 1 wins",0
Win2txt:
	.db "Player 2 wins",0
CalcWintxt:
	.db "The calc wins",0
YouWintxt:
	.db "   You win   ",0
Drawtxt:
	.db " It's a draw ",0

cross:
	.db %00000000
	.db %00100010
	.db %00010100
	.db %00001000
	.db %00010100
	.db %00100010
	.db %00000000
	.db %00000000

circle:
	.db %00000000
	.db %00011100
	.db %00100010
	.db %00100010
	.db %00100010
	.db %00011100
	.db %00000000
	.db %00000000

marker:
	.db %00000000
	.db %00000000
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00000000
	.db %00000000
	.db %00000000

pen:
	.db %00001100
	.db %00010010
	.db %00100001
	.db %01000001
	.db %10000010
	.db %10000100
	.db %11001000
	.db %11110000

.end
