;==================================
; Dodger by Cullen Sauls
; My second ASM game =)
; Last Updated: 2-12-99
; Webpage: http://freeweb.pdq.net/sauls1/
;	(Visit my webpage to get the most recent version of all my games/programs!)
; E-Mail: sauls1@pdq.net
; ICQ: 11130342
;
; IMPORTANT: This game was made by ME! You are allowed to take pieces of it, but you are NOT allowed
;            to make changes and distribute a modified source. Any and all changes should be for PERSONAL
;			 USE. If you find a better way of doing soemthing, tell me what and I'll try it out and give 
;			 your credit if it works.
;==================================
#include "ti86asm.inc"					;Standard Include File
;
.org _asm_exec_ram						;every program starts with this
;
;--- Commentation For Shell ---
	nop									;identifier for comment/icon
	jp StartProgram
	.dw 1								;note this is version 1 of the table
;										;0 means just a comment
	.dw title							;pointer to title
	.dw icon							;pointer to icon
;---
StartProgram:
	call _runindicoff					;turn off that damn busy indicator!
	call _flushallmenus					;close all open menus
	call _clrLCD						;clear the screen
	ld de,$fc00							;start drawing at top-left of screen
	ld hl,TitleScreen					;load TitleScreen address into HL
	ld bc,496							;496 bytes to copy
	ldir								;draw TitleScreen
	ld hl,TitleScreenTxt				;load TitleScreenTxt address into HL
	ld de,$202E							;set pen cursor to (46,32)
	ld (_penCol),de						;"
	call _vputs							;display first line of TitleScreenTxt
	ld de,$0005							;set cursor to (5,0)
	ld (_curRow),de						;"
	call _puts							;display second line of TitleScreenTxt
	ld de,$3A0C							;set pen cursor to (12,58)
	ld (_penCol),de						;"
	call _vputs							;display last line of TitleScreenTxt
	call _getkey						;wait until a key is pressed
;
Start:
	call _clrLCD						;clear the screen
	ld hl,$0000							;HL = 0
	ld (YourScore),hl					;YourScore = 0
	xor a								;A = 0
	ld (YourSpeed),a					;YourSpeed = 0
	ld (Count1),a						;Count1 = 0
	ld (Count2),a						;Count2 = 0
	set 3,(IY+05)						;set text to white-on-black
	ld hl,$0001							;set cursor to (1,0)
	ld (_curRow),hl						;"
	ld hl,SpeedChoose					;load SpeedChoose address into HL
	call _puts							;display the SpeedChoose string
	ld bc,$0300							;set coords to put sprite to (0,3)
	ld de,UpSprite						;load Car sprite addressn into DE
	call PutSprite						;show it!	
	ld bc,$0301							;set coords to put sprite to (1,3)
	ld de,DownSprite					;load car sprite address into DE
	call PutSprite						;show it!	
	res 3,(IY+05)						;set text back to black-on-white
	ld hl,$3A29							;set pen cursor to (41,58)
	ld (_penCol),hl						;"
	ld hl,HiScrStr						;load HiScrStr address into HL
	call _vputs							;display the HiScrStr string
	ld hl,$3A61							;set pen cursor to (97,58)
	ld (_penCol),hl						;"
	ld hl,(HighScore)					;load the number stored at HighScore into HL
	ld b,5								;B = 5 (going to print the number with 5 digits)
	call DM_HL_Deci						;call the routine that displays the number HL holds
	set 3,(IY+05)						;set text to white-on-black
	call DispSpace						;call routine that displays a space
;
ChooseYourSpeed:
	ld hl,$0905							;set cursor to (5,9)
	ld (_curRow),hl						;"
	ld a,(YourSpeed)					;load YourSpeed into a
	ld b,2								;B = 2 (going to print the number with 2 digits)
	call DispA							;call the routine that displays the number stored in A
	call _getky							;read keypresses
	cp K_EXIT							;was EXIT pressed?
	jp z,End							;if so, go to End
	cp K_DOWN							;was DOWN pressed?
	call z,IncreaseSpeed				;if so, call the routine that increases speed
	cp K_UP								;was UP pressed?
	call z,DecreaseSpeed				;if so, call the routine that decreases speed
	cp K_ENTER							;was ENTER pressed?
	jr z,Setup							;if so, go to Setup and start the game
	cp K_SECOND							;was SECOND pressed?
	jr z,Setup							;if so, go to Setup and start the game
	jr ChooseYourSpeed					;if none-of-the-above, repeat the process
;
Setup:
	res 3,(IY+05)						;set text to black-on-white
	ld a,4								;A = 4
	ld (YouX),a							;YouX = 4
	ld a,3								;A = 3
	ld (YouY),a							;YouY = 3
	ld hl,GameScreen					;load GameScreen address into HL
	call DrawMap						;draw the tile map stored at HL (GameScreen)
	ld hl,$0E00							;set cursor to (0,14)
	ld (_curRow),hl						;"
	ld hl,Dodger						;load Dodger address into HL
	call _puts							;display the string pointed to by HL
	ld hl,$0E02							;set cursor to (2,14)
	ld (_curRow),hl						;"
	ld hl,Score							;load Score address into HL
	call _puts							;display the string pointed to by HL
	ld hl,$0E04							;set cursor to (4,14)
	ld (_curRow),hl						;"
	ld hl,Speed							;load Speed address into HL
	call _puts							;display the string pointed to by HL
BeforeGameStuff:
	ld hl,$1003							;set cursor to (3,1)
	ld (_curRow),hl						;"
	ld a,(YourScore)					;load YourScore into A
	ld b,3								;B = 3 (going to print the number with 3 digits)
	call DispA							;call routine that displays the number stored in A
	ld hl,$1105							;set cursor to (5,17)
	ld (_curRow),hl						;"
	ld a,(YourSpeed)					;load YourSpeed into A
	ld b,2								;B = 2 (going to print the number with 2 digits)
	call DispA							;call routine that displays the number stored in A
	call GetRandNums					;call routine that gets what laser to use and where it goes
;
GameLoop:
	call DispYou						;call routine to display You sprite
	call _getky							;read keypresses
	cp K_EXIT							;was EXIT pressed?
	jp z,End							;if so, go to End
	cp K_DEL							;was DELETE pressed?
	jp z,Start							;if so, go to Start
	cp K_MORE							;was MORE pressed
	call z,PauseForMore					;if so, call pause routine
	cp K_UP								;was UP pressed?
	call z,MoveUp						;if so, call routine to move you up
	cp K_DOWN							;was DOWN pressed?
	call z,MoveDown						;if so, call routine to move you down
	cp K_LEFT							;was LEFT pressed?
	call z,MoveLeft						;if so, call routine to move you left
	cp K_RIGHT							;was RIGHT pressed?
	call z,MoveRight					;if so, call routine to move you right
;
	call PutLasers						;call routine to display the lasers
	call CheckDeath						;call routine to check if you are dead
;
	halt								;slow game
	halt								;"
	halt								;"
	halt								;"
	halt								;"
	ld a,(YourSpeed)					;load YourSpeed into A
	ld b,a								;B = A
	inc b								;B = B + 1
	ld a,(Count2)						;load Count2 into A
	cp b								;see if Count2 = YourSpeed
	call z,ChangeLaserPos				;if equal, call routine to change laser position
;
	ld hl,Count2						;increment the number stored in Count2
	inc (hl)							;"
	jp GameLoop							;go to GameLoop and repeat the above process
;
;==================================
; SubRoutines
;==================================
;
IncreaseSpeed:
	ld hl,YourSpeed						;decrease the number stored at YourSpeed (remember, lower number means faster)
	dec (hl)							;"
	ld a,(YourSpeed)					;load YourSpeed into A
	cp $ff								;see if you went below 0
	jr nz,DispSpace						;if not, go to DispSpace
	ld (hl),20							;if so, set YourSpeed to 20
	jr DispSpace						;go to DispSpace
;
DecreaseSpeed:
	ld hl,YourSpeed						;increase number stored at YourSpeed (remember, higher number means slower)
	inc (hl)							;"
	ld a,(YourSpeed)					;load YourSpeed into A
	cp 21								;see if you went over 20
	jr nz,DispSpace						;if not, go to DispSpace
	ld (hl),0							;if so, set YourSpeed to 0
;
DispSpace:
	ld hl,$0A05							;set cursor to (5,10)
	ld (_curRow),hl						;"
	ld a,' '							;load a space into A
	call _putc							;put the space
	ret									;return
;
End:
	res 3,(IY+05)						;set text back to black-on-white
	call _clrLCD						;clear the screen
	call _homeup						;set cursor to top-left corner
	ret									;return to TI OS or shell
;
AddScore:
	pop hl								;used so that it returns correctly
	ld hl,YourScore						;increment the number stored at YourScore
	inc (hl)							;"
	ld hl,Count1						;increment the number stored at Count1
 	inc (hl)							;"
	ld a,(hl)							;load Count1 into A
	cp 10								;see if it is 10
	jp nz,BeforeGameStuff				;if not, go to BeforeGameStuff
	xor a								;A = 0
	ld (Count1),a						;make Count1 = 0
	ld a,(YourSpeed)					;load YourSpeed into A
	or a								;see if it's 0
	jp z,BeforeGameStuff				;if so, we dont want to go lower
	dec a								;A = A - 1
	ld (YourSpeed),a					;store new speed into YourSpeed
	jp BeforeGameStuff					;go to BeforeGameStuff
;
GetRandNums:
	call GetLaser						;call routine to get which laser to put
	dec a								;does A = 1?
	jr z,GetFirstNum					;if so, go to GetFirstNum
	dec a								;does A = 2?
	jr z,GetSecNum						;if so, go to GetSecNum
	dec a								;does A = 3?
	jr z,GetThirdNum					;if so, go to GetThirdNum
	jr GetFourNum						;go to GetFourNum if none-of-the-above
;
GetFirstNum:
	call GetRand						;call random routine
	ld (LaserY),a						;load the random number into LaserY
	ld a,1								;A = 1
	ld (LaserX),a						;store 1 into LaserX
	ret									;return
;
GetSecNum:
	call GetRand						;call random routine
	ld (LaserY),a						;load the random number into LaserY
	ld a,8								;A = 8
	ld (LaserX),a						;store 8 into LaserX
	ret									;return
;
GetThirdNum:
	call GetRand2						;call random routine
	ld (LaserX),a						;load the random number into LaserX
	ld a,1								;A = 1
	ld (LaserY),a						;store 1 into LaserY
	ret									;return
;
GetFourNum:
	call GetRand2						;call random routine
	ld (LaserX),a						;load the random number into LaserX
	ld a,6								;A = 6
	ld (LaserY),a						;store 6 into Lasery
	ret									;return
;
PauseForMore:
	ld hl,$0E07							;set cursor to (7,14)
	ld (_curRow),hl						;"
	ld hl,Pause 						;load Pause address into HL
	call _puts							;display the string pointed to by HL (Pause)
	call _getky							;read keypresses
	cp K_MORE							;was MORE pressed?
	jr nz,PauseForMore					;if not, repeat the loop
	ld hl,$0E07							;set cursor to (7,14)
	ld (_curRow),hl						;"
	ld hl,Blank							;load Blank address into HL
	call _puts							;display the string pointed to by HL (Blank)
	ret									;return
;
MoveUp:
	call EraseYou						;call routine to display Erase sprite
	ld a,(YouY)							;load YouY into A
	dec a								;A = A - 1
	jr z,$+8							;if A = 0, jump 6 bytes ahead
	ld (YouY),a							;store new YouY number
	call DispYou						;call routine to display You sprite
	xor a								;A = 0
	ret									;return
;
MoveDown:
	call EraseYou						;call routine to display Erase sprite
	ld a,(YouY)							;load YouY into A
	inc a								;A = A + 1
	cp 7								;does A = 7?
	jr z,$+8							;if so, jump 6 bytes ahead
	ld (YouY),a							;store new YouY number
	call DispYou						;call routine to display You sprite
	xor a								;A = 0
	ret									;return
;
MoveLeft:
	call EraseYou						;call routine to display Erase sprite
	ld a,(YouX)							;load YouX into A
	dec a								;A = A - 1
	jr z,$+8							;if A = 0, jump 6 bytes ahead
	ld (YouX),a							;store new YouX number
	call DispYou						;call routine to display You sprite
	xor a								;A = 0
	ret									;return
;
MoveRight:
	call EraseYou						;call routine to display Erase sprite
	ld a,(YouX)							;load YouX into A
	inc a								;A = A + 1
	cp 9								;does A = 9
	jr z,$+8							;if so, jump 6 bytes ahead
	ld (YouX),a							;store new YouX number
	call DispYou						;call routine to display You sprite
	xor a								;A = 0
	ret									;return
EraseYou:
	ld a,(YouY)							;set coords for Erase sprite to (YouY,YouX)
	ld b,a								;"
	ld a,(YouX)							;"
	ld c,a								;"
	ld de,Erase							;load Erase sprite into DE
	call PutSprite						;show it!
	ret									;return
DispYou:
	ld a,(YouY)							;set coords for You sprite to (YouY,YouX)
	ld b,a								;"
	ld a,(YouX)							;"
	ld c,a								;"
	ld de,You							;load You sprite into DE
	call PutSprite						;show it!
	ret									;return
;
PutLasers:
	ld a,(Laser)						;load Laser into A
	dec a								;A = A - 1
	call z,PutLaser1					;if A was 1, call PutLaser1
	dec a								;A = A - 1
	call z,PutLaser1					;if A was 2, call PutLaser1
	dec a								;A = A - 1
	call z,PutLaser2					;if A was 3, call PutLaser2
	dec a								;A = A - 1
	call z,PutLaser2					;if A was 4, call PutLaser2
	ret									;return
;
PutLaser1:
	ld a,(LaserY)						;set coords for LaserLeftRight sprite to (LaserY, LaserX)
	ld b,a								;"
	ld a,(LaserX)						;"
	ld c,a								;"
	ld de,LaserLeftRight				;load LaserLeftRight sprite address into DE
	call PutSprite						;show it!
	ret									;return
;
PutLaser2:
	ld a,(LaserY)						;set coords for LaserUpDown sprite to (LaserY, LaserX)
	ld b,a								;"
	ld a,(LaserX)						;"
	ld c,a								;"
	ld de,LaserUpDown					;load LaserUpDown sprite address into DE
	call PutSprite						;show it!
	ret									;return
;
CheckDeath:
	ld a,(YouX)							;load YouX into A
	ld b,a								;B = A
	ld a,(LaserX)						;load LaserX into A
	cp b								;does A = B?
	ret nz								;if not, return
	ld a,(YouY)							;load YouY into A
	ld b,a								;B = A
	ld a,(LaserY)						;load LaserY into A
	cp b								;does A = B?
	ret nz								;if not, return
	pop hl								;if so, pop hl to clean stack
;
IsDead:
	call _clrLCD						;Clear The LCD
	ld a,(YouY)							;set coords for Explode1 sprite to (YouY, YouX)
	ld b,a								;"
	ld a,(YouX)							;"
	ld c,a								;"
	ld de,Explode1						;load Explode1 sprite address into DE
	call PutSprite						;show it!
	call ExplodeHalts					;call routine to slow calc
	ld a,(YouY)							;set coords for Explode2 sprite to (YouY, YouX)
	ld b,a								;"
	ld a,(YouX)							;"
	ld c,a								;"
	ld de,Explode2						;load Explode2 sprite address into DE
	call PutSprite						;show it!
	call ExplodeHalts					;call routine to slow calc
	ld a,(YouY)							;set coords for Explode3 sprite to (YouY, YouX)
	ld b,a								;"
	ld a,(YouX)							;"
	ld c,a								;"
	ld de,Explode3						;load Explode3 sprite address into DE
	call PutSprite						;show it!
	call ExplodeHalts					;call routine to slow calc
	call _clrLCD						;clear the screen
	ld hl,$0000							;set cursor coords to (0,0)
	ld (_curRow),hl						;"
	ld hl,YouDied						;load string YouDied address into HL
	call _puts							;display the string pointed to by HL (YouDied)
	ld hl,$151F							;set pen cursor to (31,21)
	ld (_penCol),hl						;"
	ld hl,FinalScore					;load string FinalScore address into HL
	call _vputs							;display the string pointed to by HL (FinalScore)
	ld hl,$154D							;set pen cursor to (77,21)
	ld (_penCol),hl						;"
	ld hl,(YourScore)					;load YourScore into HL
	ld b,5								;B = 5 (going to print number with 5 digits
	call DM_HL_Deci						;call routine to display HL in decimal format
	ld hl,$0004							;set cursor coords to (4,0)
	ld (_curRow),hl						;"
	ld hl,PlayAgain						;load string PlayAgain address into HL
	call _puts							;display the string pointed to by HL (PlayAgain)
	ld hl,(HighScore)					;load HighScore into HL
	ld de,(YourScore)					;load YourScore into DE
	call _cphlde						;is DE > HL?
	jr nc,NotHighScore					;if not, go to NotHighScore
	jr NewHighScore						;go to NewHighScore
;
ExplodeHalts:
	ld b,50								;B = 50
EHLoop:
	halt								;slow calc
	djnz EHLoop							;repeat until B = 0
	ret									;return
;
NewHighScore:
	set 3,(IY+05)						;set text to white-on-black
	ld hl,$0000							;set cursor coords to (0,0)
	ld (_curRow),hl						;"
	ld hl,NewHigh						;load NewHigh string address into HL
	call _puts							;display the string pointed to by HL (NewHigh)
	res 3,(IY+05)						;set text to black-on-white
	ld hl,(YourScore)					;load YourScore into HL
	ld (HighScore),hl					;save it as the new HighScore
	call SaveHigh						;call routine to save the high score
;
NotHighScore:
WaitForAnswer:
	call _getky							;Read Key Presses
	cp K_F1								;Was F1 Pressed?
	jp z,Start							;If So, Play Game Again
	cp K_F2								;Was F2 Pressed?
	jr nz,WaitForAnswer					;If Neither 1 Or 2 Was Pressed, Go To WaitForAnswer
	jp End								;go to End
;	
ChangeLaserPos:
	xor a								;A = 0
	ld (Count2),a						;load A into Count2
	ld a,(LaserY)						;set coords for Erase sprite to (LaserY, LaserX)
	ld b,a								;"
	ld a,(LaserX)						;"
	ld c,a								;"
	ld de,Erase							;load Erase sprite into DE
	call PutSprite						;show it!
	ld a,(Laser)						;load Laser into A
	dec a								;A = A - 1
	jr z,Change1						;if A was 1, go to Charge1
	dec a								;A = A - 1
	jr z,Change2						;if A was 2, go to Charge2
	dec a								;A = A - 1
	jr z,Change3						;if A was 3, go to Charge3
	dec a								;A = A - 1
	jr z,Change4						;if A was 4, go to Charge4
;
Change1:
	ld a,(LaserX)						;load LaserX into A
	cp 8								;does A = 8?
	jp z,AddScore						;if so, go to AddScore
	inc a								;A = A + 1
	ld (LaserX),a						;store new LaserX number
	ret									;return
;
Change2:
	ld a,(LaserX)						;load LaserX into A
	dec a								;A = A - 1
	jp z,AddScore						;if A = 0, go to AddScore
	ld (LaserX),a						;store new LaserX number
	ret									;return
;
Change3:
	ld a,(LaserY)						;load LaserY into A
	cp 6								;does A = 6?
	jp z,AddScore						;if so, go to AddScore
	inc a								;A = A + 1
	ld (LaserY),a						;store new LaserY number
	ret									;return
;
Change4:
	ld a,(LaserY)						;load LaserY into A
	dec a								;A = A - 1
	jp z,AddScore						;if A = 0, go to AddScore
	ld (LaserY),a						;store new LaserY number
	ret									;return
;
GetLaser:								;Ahmed El-Helw's random routine
	call    _random						;I'm not sure how it works :)
	ld      a,5							;"
	call    _setXXop2					;"
	call    _FPMULT						;"
	call    _convop1					;"
	ld      a,e							;"
	or a								;does A = 0?
	jr z,GetLaser						;if so, repeat routine
	ld (Laser),a						;store random number into Laser
	ret									;return
;
GetRand:                                 ;Ahmed El-Helw's random routine
	call    _random						;I'm not sure how it works :)
	ld      a,5							;"
	call    _setXXop2					;"
	call    _FPMULT						;"
	call    _convop1					;"
	ld      a,e							;"
	or a								;does A = 0?
	jr z,GetRand						;if so, repeat the routine
	ret									;return
;
GetRand2:								;Ahmed El-Helw's random routine
	call    _random						;I'm not sure how it works :)
	ld      a,5							;"
	call    _setXXop2					;"
	call    _FPMULT						;"
	call    _convop1					;"
	ld      a,e							;"
	or a								;does A = 0?
	jr z,GetRand2						;if so, repeat the routine
	ret									;return
;
;--- display routines weren't written by me, so they arent commented ---;
;
DM_HL_Deci:
	ld de,String+5
	xor a
	ld (de),a
RepUnp:
	dec de
	call _divHLby10
	add a,48
	ld (de),a
	djnz RepUnp
	ex de,hl
	jp _vputs
DispA:
	ld h,0
	ld l,a
DispHL:
	ld de,String+5
	xor a
	ld (de),a
RepUnp2:
	dec de
	call _divHLby10
	add a,48
	ld (de),a
	djnz RepUnp2
	ex de,hl
	jp _puts
;
SaveHigh:
	ld hl,ProgName						; All this stuff is to make sure the hiscore table
	rst 20h								; and resume stuff are stored in the variable
	rst 10h
	ex de,hl							; HL -> start of variable
	ld a,b
	ld de,HighScore-$D748+4				; DE = relative offset to stuff to store (-4)
	add hl,de
	adc a,0								; Next block if necessary
	ld de,HighScore						; DE = start of bytes to copy
	ld b,2								; 2 bytes to copy
RepCopy:
	push af
	push hl
	call $46C3
	ld a,(de)							; Read
	ld (hl),a							; And save it in the real variable
	pop hl
	pop af
	call $4637
	inc de
	djnz RepCopy
	ret
;
;==================================
; DrawMap -- Draws An 8x16 Tilemap  [Assembly Coder's Zenith]
; Input: HL = Pointer To Tilemap To Draw
; Total: 34b/91529t (Including Ret And Entire GridPutSprite)
;==================================
DrawMap:
	ld de,$0000            				 ;Start Drawing At (0, 0)
DrawMapL:
	push hl                				 ;Save Map Pointer
	ld l,(hl)              				 ;Get The Current Tile
	ld h,0                 				 ;Clear The Upper Byte
	add hl,hl              				 ;Multiply By 8 (* 2)
	add hl,hl             				 ;* 4
	add hl,hl            				 ;* 8
	ld bc,Sprites        				 ;Load The Start Of The Sprites
	add hl,bc            				 ;Add Togehter To Get Correct Sprite
	push de              				 ;Save Sprite Draw Location
	call GridPutSprite   				 ;Draw The Sprite
	pop de               				 ;Restore Sprite Draw Location
	pop hl               				 ;Restore Map Pointer
	inc hl               				 ;Go To Next Tile
	inc e                				 ;Move Location To The Right
	bit 4,e              				 ;If The 5th Bit (E = 16), We're Done
	jr z,DrawMapL        				 ;Only Jump If The Row Isn't Complete
	ld e,0               				 ;Draw At The Left Again
	inc d                				 ;Move Location Down A Row
	bit 3,d              				 ;Check If It's Done (E = 8)
	ret nz               				 ;Return If We're Done
	jr DrawMapL          				 ;Jump Back To The Top Of The Loop
;
;==================================
; GridPutSprite: [Routine By Dan Eble]
; Puts An Aligned Sprite At (E, D), Where HL -> Sprite
;==================================
; IN : D  = y (0-7 Inclusive)
;      E  = x (0-15 Inclusive)
;      HL -> Sprite
;
; OUT: AF, BC, DE, HL, IX Modified
; Current Total : 28b/567t (Not Counting Ret)
;==================================
GridPutSprite:
	push hl
	pop ix								 ;IX -> Sprite
	srl d          						 ;DE = 128y+x (16 Bytes/Row, 8 Rows)
	rra
	and $80
	or e           						 ;Add x Offset (Remember x <= 15)
	ld e,a
	ld hl,$fc00            				 ;HL -> Video Ram
	add hl,de            				 ;HL -> Video Ram + Offset
	ld b,8               				 ;Initialize Loop Counter
	ld de,$10            				 ;Initialize Line Increment
GPS_Loop:
	ld a,(ix+0)    						 ;Get Byte From Sprite
	ld (hl),a      						 ;Put Byte On Screen
	inc ix         						 ;Move To Next Byte In Sprite
	add hl,de     						 ;Move To Next Line On Screen
	djnz GPS_Loop
	ret
;
;==================================
; Put Sprite
;==================================
PutSprite:
	 push de     						 ;** We Need To Save DE
	 ld hl,$fb80 						 ;Point To The First Byte In Video Memory - 128 Bytes
	 inc b       						 ;B=B+1
	 ld de,$80   						 ;Number Of Bytes Per Line
YCoord:
	 add hl,de
	 djnz YCoord
	 add hl,bc 			  				 ;Now HL Points To VID_MEM + OFFSET
	 pop de   			   				 ;** Now DE Still Points To Pprite
	 ld b,8      		  				 ; Repeat 8 Times
CopySprite:
	 push bc      	   					 ;Save The Counter
	 ld a,(de)    	   					 ;Get One Byte Of Sprite
	 ld (hl),a     	  					 ;Copy It To Video Mem
	 inc de      	   					 ;Point To Next Byte Of Sprite
	 ld bc,16     	   					 ;"
	 add hl,bc       					 ;Offset Vid Mem By 16 Bytes (Go Next Line Down)
	 pop bc          					 ;Get The Counter Back
	 djnz CopySprite 	 				 ;Do The Loop
	 ret             					 ;End Of The Routine
;
;==================================
; Data For Game Screen
;==================================
GameScreen:
	 .db $05,$03,$03,$03,$03,$03,$03,$03,$03,$06,$00,$00,$00,$00,$00,$00
	 .db $01,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00,$00,$00
	 .db $01,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00,$00,$00
	 .db $01,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00,$00,$00
	 .db $01,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00,$00,$00
	 .db $01,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00,$00,$00
	 .db $01,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00,$00,$00
	 .db $07,$04,$04,$04,$04,$04,$04,$04,$04,$08,$00,$00,$00,$00,$00,$00

;==================================
; Strings
;==================================
TitleScreenTxt:
	.db "Version    1.2",0
	.db "   By Cullen Sauls   "
	.db "   sauls1@pdq.net    ",0
	.db "http://freeweb.pdq.net/sauls1",0
SpeedChoose:
	.db "Choose your speed    "
	.db "(0 is fastest, use   "
	.db "   arrows to change) ",0
HiScrStr:
	.db "High Score:",0
Dodger:
	.db "Dodger",0
Score:
	.db "Score",0
Speed:
	.db "Speed",0
Pause:
	.db "Paused",0
Blank:
	.db "      ",0
NewHigh:
	.db "  Congratulations!!  "
	.db "  A New High Score!  ",0
YouDied:
	.db "      You  Died      ",0
FinalScore:
	.db "Final Score:",0
PlayAgain:
	.db "     Play Again?     "
	.db "       F1: Yes       "
	.db "       F2: No        ",0
;
;==================================
; Variables
;==================================
String	  					= $C126		; 6 BYTE ;Needed For Saving HighScore
YourSpeed:					.db		0	;Variable For Your Speed
YouX:                       .db		0
YouY:                       .db		0
Laser:						.db		0
LaserX:						.db		0
LaserY:						.db		0
Count1:						.db 	0
Count2:						.db 	0
YourScore:         			.dw		0                   ;Variable For Score
HighScore:
	.dw	0
ProgName:
	.db $12,6,"Dodger"
;
;==================================
; Data For Shell Comments
;==================================
title:
	.db "DODGER version 1.2 by Cullen Sauls",0
icon:
	.db 10,2				;this is the height, then the width (in bytes)
;then a bitmap
	.db %11111111, %11111111
	.db %10000000, %00000001
	.db %10001000, %01111001
	.db %10010100, %00000001
	.db %10001000, %01111001
	.db %10011100, %01111001
	.db %10001000, %00000001
	.db %10010100, %01111001
	.db %10000000, %00000001
	.db %11111111, %11111111
;
;=================================
; Title Screen Pic
;=================================
TitleScreen:
  .db 0,%00011111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111000,0
  .db 0,%00011111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111000,0
  .db 0,%00011000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00011000,0
  .db 0,%00011011,%11111111,%11000000,%01111111,%11000011,%11111111,%11000000,%01111111,%11111110,%00011111,%11111111,%11011111,%11111110,%00011000,0
  .db 0,%00011011,%11111111,%11100000,%11111111,%11100011,%11111111,%11100000,%11111111,%11111111,%00011111,%11111111,%11011111,%11111111,%00011000,0
  .db 0,%00011011,%11111111,%11110001,%11111111,%11110011,%11111111,%11110001,%11111111,%11111111,%10011111,%11111111,%11011111,%11111111,%10011000,0
  .db 0,%00011011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111111,%11011111,%11111111,%11011111,%11111111,%11011000,0
  .db 0,%00011011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111111,%11011111,%11111111,%11011111,%11111111,%11011000,0
  .db 0,%00011000,%00000000,%11111000,%00000000,%11111000,%00000000,%11111000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000111,%11011000,0
  .db 0,%00011000,%00000000,%11111000,%00000000,%11111000,%00000000,%11111000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000111,%11011000,0
  .db 0,%00011000,%00000000,%11111000,%00000000,%11111000,%00000000,%11111000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000000,%00011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000000,%00011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111111,%11011111,%11111000,%00011111,%11111111,%10011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111111,%11011111,%11111000,%00011111,%11111111,%00011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111111,%11011111,%11111000,%00011111,%11111110,%00011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111111,%11011111,%11111000,%00011111,%11111111,%00011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111111,%11011111,%11111000,%00011111,%11111111,%10011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000111,%11011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000111,%11011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000111,%11011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000111,%11011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11100000,%11111011,%11100000,%11111011,%11100000,%11111011,%11100000,%00000111,%11011111,%00000000,%00011111,%00000111,%11011000,0
  .db 0,%00011011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111111,%11011111,%11111111,%11011111,%00000111,%11011000,0
  .db 0,%00011011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111011,%11111111,%11111111,%11011111,%11111111,%11011111,%00000111,%11011000,0
  .db 0,%00011011,%11111111,%11110001,%11111111,%11110011,%11111111,%11110001,%11111111,%11111111,%11011111,%11111111,%11011111,%00000111,%11011000,0
  .db 0,%00011011,%11111111,%11100000,%11111111,%11100011,%11111111,%11100000,%11111111,%11111111,%11011111,%11111111,%11011111,%00000111,%11011000,0
  .db 0,%00011011,%11111111,%11000000,%01111111,%11000011,%11111111,%11000000,%01111111,%11111111,%11011111,%11111111,%11011111,%00000111,%11011000,0
  .db 0,%00011000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00011000,0
  .db 0,%00011111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111000,0
  .db 0,%00011111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111000,0
;
;==================================
; Sprites  (For Game Screen)
;==================================
Sprites:
Sprite0:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
Sprite1:
	.db %11111100
	.db %10000110
	.db %10000100
	.db %10000111
	.db %10000111
	.db %10000100
	.db %10000110
	.db %11111100
Sprite2:
	.db %00111111
	.db %01100001
	.db %00100001
	.db %11100001
	.db %11100001
	.db %00100001
	.db %01100001
	.db %00111111
Sprite3:
	.db %11111111
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %11111111
	.db %01011010
	.db %00011000
Sprite4:
	.db %00011000
	.db %01011010
	.db %11111111
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %11111111
Sprite5:
	.db %11111111
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101010
	.db %11111100
Sprite6:
	.db %11111111
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %01010101
	.db %00111111
Sprite7:
	.db %11111100
	.db %10101010
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %11111111
Sprite8:
	.db %00111111
	.db %01010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11111111
;
;==================================
; Sprites  (For Game)
;==================================
UpSprite:
	.db %11111111
	.db %11111011
	.db %11111101
	.db %11100110
	.db %11000011
	.db %10000001
	.db %11000011
	.db %11111111
DownSprite:
	.db %11111111
	.db %11000011
	.db %10000001
	.db %11000011
	.db %01100111
	.db %10111111
	.db %11011111
	.db %11111111	
Erase:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
LaserUpDown:
	.db %01011010
	.db %01011010
	.db %01011010
	.db %01011010
	.db %01011010
	.db %01011010
	.db %01011010
	.db %01011010
LaserLeftRight:
	.db %00000000
	.db %11111111
	.db %00000000
	.db %11111111
	.db %11111111
	.db %00000000
	.db %11111111
	.db %00000000
You:
	.db %00011000
	.db %00100100
	.db %00100100
	.db %00011000
	.db %01111110
	.db %00011000
	.db %00111100
	.db %01100110
Explode1:
	.db %01000010
	.db %00101100
	.db %00110100
	.db %01101110
	.db %01110110
	.db %00101100
	.db %00110100
	.db %01000010
Explode2:
	.db %00010100
	.db %01000000
	.db %00101000
	.db %00000010
	.db %01010001
	.db %00000100
	.db %10010010
	.db %01000100
Explode3:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01011010
	.db %11111111
.end
;
;********** THAT'S IT!!!!! **********