;		Dying Eyes
;
;  "tired disguised oblivion...is everything i do"
;
; "in the company of pseudo-suns...
;	happy birthday to me"
;
; "i think i've reached that point...
;      where giving up and going on..are both the same dead end to me
;   both the same old song"
;
; "goodbye my little moon...i'd rather look at Saturn"
;
; Innovated by Alex Highsmith
;
;     TO DO: TOWER. END OF GAME
;

#include "ti86asm.inc"
#include "data.inc"	;Symbol Table

TEXT_MEM3 = _plotSScreen
TEXT_MEM32 = _plotSScreen+200

TempLine = TEXT_MEM3+1
PicCoor = TEXT_MEM3+20
offset = TEXT_MEM3+22
NASR_Status = TEXT_MEM3+23
KURAICOUNTER = TEXT_MEM3+24
ENEMYCOUNTER1 = TEXT_MEM3+25
OK = TEXT_MEM3+27
BKX = TEXT_MEM3+61
BKY = TEXT_MEM3+62
WHICHENEMY = TEXT_MEM3+30
NUMBEROFENEMIES = TEXT_MEM3+31
ENEMYHP1 = TEXT_MEM3+32
ENEMYHP2 = TEXT_MEM3+34
ENEMYHP3 = TEXT_MEM3+36
ENEMYST1 = TEXT_MEM3+38
ENEMYST2 = TEXT_MEM3+40
ENEMYST3 = TEXT_MEM3+42
ENEMYSPEED1 = TEXT_MEM3+44
ENEMYSPEED2 = TEXT_MEM3+46
ENEMYSPEED3 = TEXT_MEM3+48
ENEMYCOUNTER2 = TEXT_MEM3+49
DUMMY1 = TEXT_MEM3+51
DUMMY2 = TEXT_MEM3+52
ENEMYBACK1 = TEXT_MEM3+55
ENEMYBACK2 = TEXT_MEM3+57
ENEMYBACK3 = TEXT_MEM3+59
Save = TEXT_MEM3+63
COUNTER = TEXT_MEM3+65
MAXDEFENSE = TEXT_MEM3+66
REGENCHECK = TEXT_MEM3
XPGAINED = TEXT_MEM32+70
ENEMYDFD1 = TEXT_MEM32+64
ENEMYDFD2 = TEXT_MEM32+66
ENEMYDFD3 = TEXT_MEM32+68	

MAPVAR = TEXT_MEM32+60
STRENGTHMAX = TEXT_MEM32+78
BUILDUP = TEXT_MEM32+74
RELIFE = TEXT_MEM32+75
DEFENSEMAX = TEXT_MEM32+76
LEADERCHECK = TEXT_MEM32+80

;;Save VARS

TOLEVEL = TEXT_MEM32+82
HP = TEXT_MEM32+84 
MP = TEXT_MEM32+86
XP = TEXT_MEM32+88
GOLD = TEXT_MEM32+90
MAXHP = TEXT_MEM32+92
STRENGTH = TEXT_MEM32+94
KURAILEVEL = TEXT_MEM32+96
MAXMP = TEXT_MEM32+98
SPEED = TEXT_MEM32+100
INTELLIGENCE = TEXT_MEM32+102
WEAPON = TEXT_MEM32+104
DEFENSE = TEXT_MEM32+106
DUNGEONCHECK = TEXT_MEM32+108

SCENARIO = TEXT_MEM3+108
ENEMYCOUNTER3 = TEXT_MEM3+109
DOUBLE = TEXT_MEM32+110

BMPLOC = TEXT_MEM3+68 
MAPINDEX = TEXT_MEM3+70 
MAPSTART = TEXT_MEM3+72 
VIDINDEX = TEXT_MEM3+74 
WHEREAT = TEXT_MEM3+76 
STANDING = TEXT_MEM3+78 
COUNT = TEXT_MEM3+90
X = TEXT_MEM3+91 
Y = TEXT_MEM3+92 
OLDX = TEXT_MEM3+84 
OLDWHERE = TEXT_MEM3+86




.org _asm_exec_ram

	nop
	jp ProgStart
.dw 0
.dw Title

Title:
.db "Dying Eyes",0

ProgStart:
	call _flushallmenus
	call _runindicoff
	ld hl,DataName-1
	rst 20h
	rst 10h
	jp c,_jforcecmdnochar
	ld a,b
	ex de,hl
	call _ahl_plus_2_pg3
	call _set_abs_src_addr
	ld a,1
	ld hl,$0100
	call _set_abs_dest_addr
	xor a
	ld hl,$2C30
	call _set_mm_num_bytes
	call _mm_ldir
	call _ram_page_1

	 ld a,1
	 ld (NASR_Status),a    ;set to display pic   
LOADGAME:
	call DEADORLIVEMAN
	ld (hl),0
	call DRAWWALLS
	ld bc,$2325
	ld hl,Logo
	call NASRWARP	
	ld hl,NewGame	
	ld de,$0E05
	call DISPSTRING
	ld hl,SaveGame
	ld de,$0705
	call DISPSTRING	
LOADLOOP2:
	call _getky
    cp K_2
	jr z,LOADGAME2       
	cp K_3
	jr z,NEWGAME
    cp K_EXIT
	RET Z
	cp K_1
    jr nz,LOADLOOP2
LOADGAME1:
	ld hl,SaveSSI
	ld (DUMMY1),hl
    LD hl,SAVERAM
	ld de,scenario1
	jr LOADIT
LOADGAME2:	
	ld hl,SaveSSI2
	ld (DUMMY1),hl
    LD hl,SAVERAM2
	ld de,scenario2
LOADIT:
	push de
	LD DE,TOLEVEL
    LD BC,28
    LDIR
	ld hl,Loaded
	ld de,$2F22
	call DISPSTRING

	ld hl,(DUMMY1)
	ld de,WhichSpells
 	ld bc,24
 	ldir

	pop de
	ex de,hl
	ld a,(hl)
	ld (SCENARIO),a	
	call WaitKey
	call ERASESCREEN
	ld a,(DUNGEONCHECK)
	cp 8
	jp z,TOTOWN2
	jp FROMLOAD
NEWGAME:
	ld de,Chests
	ld hl,MAP2
	call CHESTINIT
	ld hl,MAP3
	ld de,Chests2
	call CHESTINIT

INITSLOTS:
	 ld hl,ZeroSet
	 ld de,WhichSpells
 	 ld bc,24
 	 ldir
	xor a
	ld (DOUBLE),a
	ld (COUNTER),a
	ld (SCENARIO),a
	ld (LEADERCHECK),a	
	inc a
	ld (KURAILEVEL),a
	ld (DUNGEONCHECK),a

	ld hl,0	
	ld (MAXHP),hl
	ld (TOLEVEL),hl
	ld (MAXMP),hl
	ld (STRENGTH),hl
	ld (INTELLIGENCE),hl
	ld (SPEED),hl
	ld (XP),hl
	ld (GOLD),hl

	ld hl,5
	ld (DEFENSE),hl
	ld (WEAPON),hl
	call DRAWWALLS
	ld hl,172
	call LEVELUP
	call ERASESCREEN
	call INVERTSCREEN
	set 3,(IY+05)
	ld de,$1720
	ld hl,Awakened
	call DISPSTRING3
	ld de,KuraiText1
	ld bc,KuraiText2
	ld hl,KuraiText3
	call KURAITALKS
START:
        	LD DE,29
        	LD HL,$001D
	jp MAP2PLACER


UPDATEMOVE:			; SET (X) TO NEW X,Y COORD
	LD (WHEREAT),HL		; SET HL TO POINT TO TOP-LEFT CORNER 
DRAWMAP:			; (X) AND (WHEREAT) SHOULD STILL BE UNCHANGED
	call REFRESHMAP
	LD A,(HL)
        	LD HL,(X)
	LD (OLDX),HL
	LD HL,(WHEREAT)
	LD (OLDWHERE),HL
	ld a,(COUNTER)
	inc a
	ld (COUNTER),a
	cp 20
	jp z,INITBATTLE
KEYLOOP:
    call _getky
	CP G_2nd
    jp z,STATUSSCREEN
	CP G_LEFT
	JR Z,LEFT
    CP G_RIGHT
	JR Z,RIGHT
    CP G_UP
	jr z,UP
    CP G_MODE
    ret z
    CP G_DOWN
	JR NZ,KEYLOOP
DOWN:
	LD HL,(STANDING)
    LD DE,36
	ADD HL,DE
	LD A,(HL)
	cp 3
	jr nc,SOMETHING
	LD A,(Y)
	INC A
	LD (Y),A
	LD HL,(WHEREAT)
    LD DE,36
	ADD HL,DE
	jr UPDATEMOVE

LEFT:
	LD HL,(STANDING)
	LD DE,$FFFF
	ADD HL,DE
	LD A,(HL)
	cp 3
	jr nc,SOMETHING
	LD A,(X)
	DEC A
	LD (X),A
	LD HL,(WHEREAT)
	LD DE,$FFFF
	ADD HL,DE
	jr UPDATEMOVE

RIGHT:
	LD HL,(STANDING)
	inc hl
	LD A,(HL)
	cp 3
	jr nc,SOMETHING
	LD A,(X)
	INC A
	LD (X),A
	LD HL,(WHEREAT)
	inc hl
	jp UPDATEMOVE

UP:
	LD HL,(STANDING)
    LD DE,$FFDC
	ADD HL,DE
	LD A,(HL)
	CP 3
	JR NC,SOMETHING
    LD A,(Y)
	DEC A
	LD (Y),A
	LD HL,(WHEREAT)
    LD DE,$FFDC
	ADD HL,DE
	jp UPDATEMOVE
SOMETHING:
	ld a,(hl)
    CP 7
    jp z,KEYLOOP
	CP 6
	jp z,TOWN
	CP 5
	jp z,CASTLEORMAN
	cp 4
	jp z,CAVEORELSE
STAIRS:
	ld bc,(X)
	ld a,(DUNGEONCHECK)
	or a
	jp z,TOWER
	cp 4
	jp z,FAITHCAVE
	cp 7
	jp z,BANDITSTAIRS
	cp -1
	jp z,LASTSTAIRS
	cp -2
	jp z,FAITHCAVE2 ; you get the faith armor
	cp 8
	jp nc,INTOWN
	ld a,b
	cp $0C
	jr z,STAIRSOUT1
	cp $03
	jr z,STAIRS2
	or a
	jr z,STAIRSOUT2
	cp $04
	jr z,STAIRSD1
	cp $0D
	jr z,STAIRSD2
	cp $0F
	jr z,STAIRSD3
	cp $07
	jr z,STAIRSD5
	cp $0B
	jr z,STAIRSD6
	cp $08
	jr z,STAIRSD7
STAIRS1:
	ld bc,$0316  ;; Y,X
	jr CONTINUEST
STAIRS2:
	ld a,(SCENARIO)
	or a
	call z,TALK1
	ld bc,$0206  ;; Y,X
	jr CONTINUEST
STAIRSOUT1:
	ld a,(DUNGEONCHECK)
	cp 3
	jr z,STAIRSD4
	ld a,(SCENARIO)
	cp 1
	jp z,LEADER1
    LD HL,$0C18
    LD DE,456          
JUMPTOMAP:
	jp RETURNTOMAP2
STAIRSOUT2:
    LD HL,$0812
    LD DE,306             
	jr JUMPTOMAP
STAIRSD1:
	ld bc,$0D16
	jr CONTINUEST
STAIRSD2:
	ld bc,$0412
	jr CONTINUEST
STAIRSD3:
	ld bc,$0C0C
	jr CONTINUEST
STAIRSD4:
	ld bc,$0F17
	jr CONTINUEST
STAIRSD5:
	ld bc,$0B11  
	jr CONTINUEST
STAIRSD7:
	ld a,(SCENARIO)
	cp 4
	jr c,LOCKED
	jp z,LEADER3
STAIRSOUT3: ;; goes to other side
        	LD HL,$0810
        	LD DE,304
	jp RETURNTOMAP3
STAIRSD6:
	ld bc,$070C 
CONTINUEST:
	LD (X),bc
	push bc
	ld hl,0
LOOPOF36:
	ld de,36
	add hl,de	
	djnz LOOPOF36
	pop bc
	ld b,0
	add hl,bc		
	ex de,hl	
FROMPLACE:
	push de
	LD HL,BITMAPS2
	LD (BMPLOC),HL
	LD HL,(MAPVAR)
	LD (MAPSTART),HL
	pop de
	ADD HL,DE
	jp UPDATEMOVE	
LOCKED:
	call DRAWWALLS
	ld de,$1C1E
	ld hl,Locked
	call DISPSTRING	
	jp RETFROMSTATS

FAITHCAVE:
        	ld a,b
	cp $0E
	jr z,STAIRSOUT4
	cp $04
	jr z,STAIRSE2
	cp $02
	jr z,STAIRSE3
	cp $0B
	jr z,STAIRSE4
	cp $09
	jr z,STAIRSE5
	cp $03
	jr z,STAIRSE6
	cp $05
	jr z,STAIRSE7
	cp $13
	jr z,STAIRSE9
	cp $14
	jr z,STAIRSE10
	cp $01
	jr z,STAIRSE11
	cp $0C
	jr z,STAIRSE12
	or a
	jr z,STAIRSE13
	;; stairs 8 have the same coord as stairs1, so it is within staire1:
STAIRSE1:
	LD bc,$0400
	jr CONTINUEST
STAIRSE2:
	ld a,c
	cp $1F
	jr z,STAIRSE8
	LD bc,$0700
	jr CONTINUEST
STAIRSE3:
	LD bc,$0B08
CONTINUEST2: ;;to save bytes
	jr CONTINUEST
STAIRSE4:
	LD bc,$0200
	jr CONTINUEST2
STAIRSE5:
	LD bc,$0307
	jr CONTINUEST2
STAIRSE6:
	LD bc,$0907
	jr CONTINUEST2
STAIRSE7:
	LD bc,$041F
	jr CONTINUEST2
STAIRSE8:
	ld bc,$0506
	jr CONTINUEST2
STAIRSE9:
	ld bc,$0117
	jr CONTINUEST2
STAIRSE10:
	ld bc,$0C04
	jr CONTINUEST2
STAIRSE11:
	ld bc,$131D
	jr CONTINUEST2
STAIRSE12:
	ld bc,$141D
	jr CONTINUEST2
STAIRSE13:
	ld a,(SCENARIO)
	cp 6
	jp z,LEADER4
STAIRSOUT4: ;; leads out of faith cave
	LD HL,$0202
        	LD DE,74
RETURNTOMAP3C: 	;;to save bytes
	jp RETURNTOMAP3

BANDITSTAIRS:
	ld a,b
	cp $0F
	jr z,STAIRSF1
	cp $08
	jr z,STAIRSF2
	cp $13
	jr z,STAIRSOUT5
	cp $06
	jr z,STAIRSF5
	cp $0D
	jr z,STAIRSF6
	cp $0A
	jr z,STAIRSF7	
	cp $01
	jr z,STAIRSOUT6
STAIRSF4:
	ld a,c
	cp $1F
	jr z,STAIRSF8
	ld bc,$0F16
	jr CONTINUEST2
STAIRSF1:
	ld a,c
	cp $16
	jr z,STAIRSF3
	ld bc,$0813
	jr CONTINUEST2
STAIRSF2:
	ld bc,$0F09
	jr CONTINUEST2
STAIRSF6:
	ld bc,$0616
	jr CONTINUEST2
STAIRSF5:
	ld bc,$0D0F
CONTINUEST3:;; to save bytes
	jr CONTINUEST2
STAIRSF8:
	ld bc,$0A15
	jr CONTINUEST3
STAIRSF3:
	ld bc,$0012
	LD (X),bc
	ld de,18
FROMPLACE2: ;; to save bytes
	jp FROMPLACE

STAIRSOUT6:
	ld a,(SCENARIO)
	cp 8
	jp z,LEADER5
STAIRSOUT5: ;; leads out of BANDITCASTLE
	LD HL,$0BFF
        	LD DE,395
	jr RETURNTOMAP3C
STAIRSF7:
	ld bc,$FF1F
	LD (X),bc
	ld de,-5
	jr FROMPLACE2	

LASTSTAIRS:
	ld a,b
	cp $12
	jp z,STAIRSL15
	cp $04
	jp z,STAIRSL16
	cp $09
	jr z,STAIRSL1
	cp $0E
	jr z,STAIRSL2
	cp $13
	jr z,STAIRSL3
	cp $06
	jr z,STAIRSL4
	cp $01
	jr z,STAIRSL5
	cp $05
	jp z,STAIRSL6
	cp $07
	jp z,STAIRSL7
	cp $08
	jp z,STAIRSL8
	cp $14
	jp z,STAIRSL9
	cp $03
	jp z,STAIRSL10
	cp $0F
	jp z,STAIRSL11
	cp $0D
	jp z,STAIRSL12
	cp $0C
	jp z,STAIRSL13
	cp $02
	jp z,STAIRSL14
STAIRSOUT7:
        	LD HL,$0418
        	LD DE,168             
	jp JUMPTOMAP	
STAIRSL1:
	ld a,c
	cp $01
	jr z,STAIRSL1LEFT
	cp $11
	jr z,STAIRSL1RIGHT
	cp $1E
	jr z,STAIRSL1RIGHTER
	jr STAIRSOUT7
STAIRSL1RIGHT:
	ld bc,$091E
	jr CONTINUEST4
STAIRSL1LEFT:
	ld bc,$0E04
	jr CONTINUEST4
STAIRSL1RIGHTER:
	ld bc,$0911
	jr CONTINUEST4
STAIRSL2:
	ld bc,$0901
	jr CONTINUEST4
STAIRSL3:
	ld a,c
	cp $09
	jr z,STAIRSL3DOWN
	cp $15
	jr z,STAIRSL3SWITCH
	ld bc,$0605
CONTINUEST4:
	jp CONTINUEST
STAIRSL3DOWN:
	ld bc,$0117
	jr CONTINUEST4
STAIRSL4:
	ld bc,$1300
	jr CONTINUEST4
STAIRSL5:
	ld a,c
	cp $17
	jr z,STAIRSL5RIGHT
	cp $16
	jr z,STAIRSL5LEFT
	cp $09
	jr z,STAIRS5UP
	jp LEADER7 ;; last battle
STAIRS5UP:
	ld bc,$0717
	jr CONTINUEST4
STAIRSL5LEFT:	
	ld bc,$050D
	jr CONTINUEST4
STAIRSL5RIGHT:
	ld bc,$1309
	jr CONTINUEST4
STAIRSL6:
	ld bc,$0116
	jr CONTINUEST4
STAIRSL7:
	ld bc,$0109
	jr CONTINUEST4
STAIRSL8:
	ld bc,$140E
	jr CONTINUEST4
STAIRSL9:
	ld bc,$0816
	jr CONTINUEST4
STAIRSL10:
	ld bc,$0F1F
	jr CONTINUEST4
STAIRSL11:
	ld bc,$031D
	jr CONTINUEST4
STAIRSL12:
	ld bc,$0C17
	jr CONTINUEST4
STAIRSL13:
	ld bc,$0D1F
	jr CONTINUEST4
STAIRSL14:
	ld bc,$1315
	jr CONTINUEST4
STAIRSL3SWITCH:
	ld bc,$021B
	jr CONTINUEST4
STAIRSL15:
	ld bc,$0411
	jr CONTINUEST4
STAIRSL16:
	ld bc,$1211
	jr CONTINUEST4
	

FAITHCAVE2: ;; where you get the faith armor
        	LD HL,$0020
        	LD DE,32
	jp JUMPTOMAP	

REFRESHMAP:
	LD HL,(WHEREAT)
	LD (MAPINDEX),HL
      LD DE,$fc02+1
	LD (VIDINDEX),DE
	LD B,5
TOP5LOOP:
	PUSH BC
	LD HL,(MAPINDEX)		; PUT TYPE IN A, MOVE TO NEXT MAP BYTE
	LD A,(HL)
	INC HL
	LD (MAPINDEX),HL
	SLA A				; 2
	SLA A				; 4
	SLA A				; 8
	SLA A				; 16
	SLA A				; 32
	LD E,A
	LD D,0
	LD HL,(BMPLOC)
	ADD HL,DE
	LD DE,16
	ADD HL,DE
	LD DE,(VIDINDEX)
	LD BC,$0802
      call SMALLBMP
	LD HL,(VIDINDEX)
	INC HL
	INC HL
	LD (VIDINDEX),HL
	POP BC
	DJNZ TOP5LOOP
	LD HL,(MAPINDEX)
      LD DE,31
	ADD HL,DE
	LD (MAPINDEX),HL

      LD DE,$fc02+129
	LD (VIDINDEX),DE
	LD B,3
MID5:
	PUSH BC
	LD B,5
MID5LOOP:
	PUSH BC
	LD HL,(MAPINDEX)		; PUT TYPE IN A, MOVE TO NEXT MAP BYTE
	LD A,(HL)
	INC HL
	LD (MAPINDEX),HL
	SLA A				; 2
	SLA A				; 4
	SLA A				; 8
	SLA A				; 16
	SLA A				; 32
	LD E,A
	LD D,0
	LD HL,(BMPLOC)
	ADD HL,DE
	LD DE,(VIDINDEX)
	LD BC,$1002
        	call SMALLBMP

	LD HL,(VIDINDEX)
	INC HL
	INC HL
	LD (VIDINDEX),HL
	POP BC
	DJNZ MID5LOOP

	LD HL,(VIDINDEX)
      LD DE,246 ;182
	ADD HL,DE
	LD (VIDINDEX),HL
	LD HL,(MAPINDEX)
      LD DE,31
	ADD HL,DE
	LD (MAPINDEX),HL
	POP BC
	DJNZ MID5


Bottom11:
      LD DE,$fc02+129+(16*16*3)
	LD (VIDINDEX),DE
	LD B,5
Bot5LOOP:
	PUSH BC
	LD HL,(MAPINDEX)		; PUT TYPE IN A, MOVE TO NEXT MAP BYTE
	LD A,(HL)
	INC HL
	LD (MAPINDEX),HL
	SLA A				; 2
	SLA A				; 4
	SLA A				; 8
	SLA A				; 16
	SLA A				; 32
	LD E,A
	LD D,0
	LD HL,(BMPLOC)
	ADD HL,DE
	LD DE,(VIDINDEX)
	LD BC,$0802
      call SMALLBMP

	LD HL,(VIDINDEX)
	INC HL
	INC HL
	LD (VIDINDEX),HL
	POP BC
	DJNZ Bot5LOOP


	LD HL,PLAYER
        	LD DE,$fc02+389
	LD BC,$1002
        	call SMALLBMP
	call CR_GRBCopy
	LD HL,(WHEREAT)
        	LD DE,74
	ADD HL,DE
	LD (STANDING),HL
	ret

SMALLBMP:                     ; HL=SRC
      PUSH AF
	XOR A			; DE=DEST
	LD (COUNT),A		; B=LENGTH
VERTLOOP:			; C=WIDTH
	PUSH BC
	LD B,0
	LDIR
	POP BC
	LD A,C
	NEG
	AND $F
      ;SUB 4
VERTINCDELOOP:
	DEC A
	INC DE
	OR A
	JR NZ,VERTINCDELOOP
	LD A,(COUNT)
	INC A
	LD (COUNT),A
	CP B
	JR NZ,VERTLOOP
      POP AF
	ret

;---------Battle Engine------------;

INITBATTLE:
	ld a,(DUNGEONCHECK)
	cp -1
	jr z,RESTARTBATTLE
	cp 8
	jp nc,KEYLOOP
RESTARTBATTLE:
	call SetupModule
	xor a
	call _exec_assembly
	jr CheckResult

LEADER1:
	call SetupModule
	ld a,1
	call _exec_assembly
	jr CheckResult

LEADER2:
	call SetupModule
	ld a,2
	call _exec_assembly
	jr CheckResult

LEADER3:
	call SetupModule
	ld a,3
	call _exec_assembly
	jr CheckResult

LEADER4:
	call SetupModule
	ld a,4
	call _exec_assembly
	jr CheckResult

LEADER5:
	call SetupModule
	ld a,5
	call _exec_assembly
	jr CheckResult

LEADER6:
	call SetupModule
	ld a,6
	call _exec_assembly
	jr CheckResult

LEADER7:
	call SetupModule
	ld a,7
	call _exec_assembly
	jr CheckResult

GIMPMAN:
	call SetupModule
	ld a,8
	call _exec_assembly
	jr CheckResult

LEADER1TOWN:
	call SetupModule
	ld a,9
	call _exec_assembly
	jr CheckResult

LEVELUP:
	call SetupModule
	ld a,10
	call _exec_assembly
	ret

CheckResult:
	cp 1
	jp z,DRAWMAP
	;cp K_ENTER
	;ret z						;Quit
	ret
	ret

SaveStatusofString:
	ld hl,_asapvar
	rst 20h
	rst 10h
	ld a,b
	ld hl,SaveSSI-_asm_exec_ram+4
	add hl,de
	adc a,0
	call _set_abs_dest_addr
	xor a
	ld hl,SaveSSI
	call _set_abs_src_addr
	ld hl,106
	call _set_mm_num_bytes
	call _mm_ldir
	jp _ram_page_1

SetupModule:
	set 2,(iy+31)
	ld hl,BattleEngine-1
	rst 20h
	rst 10h
	jp c,_jforcecmdnochar
	ret




BattleEngine:	.db 6,"battle"





INTOWN:
	ld a,(DUNGEONCHECK)
	cp 9
	jr z,TOWN1
	cp 10
	jr z,CAVEOLDMAN
TOWN2:
        	LD HL,$0808
        	LD DE,296
	jr RETURNTOMAP3
CAVEOLDMAN:
        	LD HL,$1002
        	LD DE,578
	jr RETURNTOMAP3
TOWN1:
        	LD HL,$0F15
        	LD DE,561
RETURNTOMAP2:
	xor a
	jr RETURNTOMAP
RETURNTOMAP3:
	ld a,5
RETURNTOMAP:
	ld (DUNGEONCHECK),a
	push de	
	LD (X),HL
	ld (COUNTER),a
	LD HL,BITMAPS
	LD (BMPLOC),HL
	LD HL,MAP
	LD (MAPSTART),HL
	pop de
	ADD HL,DE
	jp UPDATEMOVE
TOWER:
	ld a,(SCENARIO)
	cp 9
	jr nc,INTOTHETOWER
	ld de,$1C04
	ld hl,force
	call DISPSTRING	
	jp RETFROMSTATS
INTOTHETOWER:
	ld hl,MAP4
	ld de,597
	add hl,de
	ld (hl),7
	call DRAWWALLS
	ld de,$1C14
	ld hl,last
	call DISPSTRING3
	call ERASESCREEN
	LD DE,369
	ld hl,$0A09
MAP4PLACER:
        	ld a,-1
MAP4PLACER2:
	ld (DUNGEONCHECK),a
	ld bc,MAP4
	ld (MAPVAR),bc
	push de
	LD (X),HL
	LD HL,BITMAPS2
	LD (BMPLOC),HL
	LD HL,MAP4
	LD (MAPSTART),HL
	pop de
	ADD HL,DE
	jp UPDATEMOVE
TOWN:
	ld a,(DUNGEONCHECK)
	cp 5
	jr z,TOTOWN2
	or a
	jr nz,TREASURECHEST
FROMLOAD:
	ld a,9
	ld (DUNGEONCHECK),a
	ld a,(SCENARIO)
	cp 2
	jr nz,MANDEAD
	jr MANALIVE
TOTOWN2:
	ld a,8
	ld (DUNGEONCHECK),a
MANALIVE:
	call DEADORLIVEMAN
	ld (hl),5
	jr MANALIVESTILL
MANDEAD:
	call DEADORLIVEMAN
	ld (hl),0
MANALIVESTILL:
	xor a
	ld (LEADERCHECK),a
        	LD DE,700
	ld hl,$1310
	jr MAP2PLACER
MAP2PLACER2:
	ld (DUNGEONCHECK),a
MAP2PLACER:
	ld bc,MAP2
	ld (MAPVAR),bc
	push de
	LD (X),HL
	LD HL,BITMAPS2
	LD (BMPLOC),HL
	LD HL,MAP2
	LD (MAPSTART),HL
	pop de
	ADD HL,DE
	jp UPDATEMOVE

DEADORLIVEMAN:
	ld hl,MAP2
	ld de,814
	add hl,de
	RET

TREASURECHEST:
	call DRAWWALLS
	ld hl,YouFind
	ld de,$1820
	call DISPSTRING
	ld a,(DUNGEONCHECK)
	cp -2
	jr nz,RANDTREASURE
FAITHARMOR:
	ld hl,faitharmor
	ld de,$1E20
	call DISPSTRING3
	ld a,10
	ld (SCENARIO),a
	jp LEADER6
RANDTREASURE:
  ld a,r
  srl a
  and 3   
	cp 1
	jr z,FGOLD
	or a
	jr z,FITEM
FSCROLL
	ld hl,scroll
	ld de,$1E20
	call DISPSTRING
	call ADD30LOOP
	ld de,(XP)
	add hl,de
	ld (XP),hl
	jr ITSFOUND
FITEM:
	ld hl,WhichItems
	push hl
	ld a,(hl)
	inc a
	ld (hl),a
	ld hl,MedKit
	ld de,$1E20
	call DISPSTRING
  ld a,r
  srl a
  and 3   
  or a
  jr z,ITSFOUNDPOP
	pop hl
	inc hl
	ld a,(hl)
	inc a
	ld (hl),a
	ld hl,MagKit
	ld de,$2420
	call DISPSTRING
	jr ITSFOUND
FGOLD:
	call ADD30LOOP
	ld de,(GOLD)
	add hl,de
	ld (GOLD),hl
	ld hl,somegold
	ld de,$1E20
	call DISPSTRING
	jr ITSFOUND
ITSFOUNDPOP:
	pop hl
ITSFOUND:

	ld bc,(X)
	push bc
	ld hl,0
LOOPOF362:
	ld de,36
	add hl,de	
	djnz LOOPOF362
	pop bc
	ld b,0
	add hl,bc		
	ld de,73
	add hl,de
	ex de,hl	
	push de
	ld hl,(MAPVAR)
	pop de
	add hl,de
	ld (hl),0
RETFROMSTATS:
	call WaitKey
RETFROMSTATS2:
	call ERASESCREEN
	ld hl,(WHEREAT)
	jp  UPDATEMOVE
STATUSSCREEN:
	call DELAY
	ld hl,StatusScreen
	ld bc,$3C3C
	call NASRWARP	
	ld bc,$0540
	ld (BKX),bc
	call DRAWWIDE
STATLOOP:
 	ld a,$3E
 	out (1),a
 	in a,(1)
	bit 7,a
	jp z,RETFROMSTATS2
	bit 5,a ; 2ND
 	jr z,STATPRESS
 	bit 0,a
 	jr z,STATDOWN
	bit 3,a
	jr nz,STATLOOP
STATUP:	
	call DELAY
	call DRAWWIDE
	ld a,(BKY)
	cp $05
	jr nz,CONTUP
	ld bc,$1740
	ld (BKX),bc
	call DRAWWIDE
	jr STATLOOP
CONTUP:
	ld a,(BKY)
	sub 6
	ld (BKY),a
	call DRAWWIDE
	jr STATLOOP	
STATDOWN:
	call DELAY
	call DRAWWIDE
	ld a,(BKY)
	cp $17
	jr nz,CONTDOWN
	ld bc,$0540
	ld (BKX),bc
	call DRAWWIDE
	jr STATLOOP
CONTDOWN:
	ld a,(BKY)
	add a,6
	ld (BKY),a
	call DRAWWIDE
	jr STATLOOP

STATPRESS:
      call DELAY
	ld a,(BKY)
	cp $11
	jp z,SEARCHFOR
	call DRAWWALLS
	ld hl,KuraiPortrait
	ld bc,$3C24
	call NASRWARP	
	ld a,(BKY)
	cp $17
	jp z,HEALING
	cp $0B
	jp z,ITEMS
STATS:
	ld hl,Stats
	ld de,$0306
	call DISPSTRING
	ld hl,Level
	ld de,$0C14
	call DISPSTRING
	ld a,(KURAILEVEL)
	ld l,a
	ld h,0
	ld de,$0C22
	call DISPHL
	ld bc,$333C
        	ld hl,Logo ;; displays kurai
        	call NASRWARP

	call DISPLAYSTATS
	call DRAWSTATS2
	ld hl,(HP)	
	ld de,$1222
	call DISPHL
	ld hl,(MP)	
	ld de,$1822
	call DISPHL
	ld hl,xp
	ld de,$3017
	call DISPSTRING
	ld hl,(XP)	
	ld de,$3022
	call DISPHL
	ld hl,(GOLD)	
	ld de,$3622
	call DISPHL
	ld hl,gold
	ld de,$360F
	call DISPSTRING3 ;; only so i dont have to add call WaitKey
	call DRAWWALLS
	ld hl,KuraiPortrait
	ld bc,$3C24
	call NASRWARP	
	ld bc,$333C
        	ld hl,Logo ;; displays kurai
        	call NASRWARP
	
	ld hl,WeaponShop
	ld de,$120C
	call DISPSTRING
	ld hl,ArmorShop
	ld de,$1809
	call DISPSTRING

	ld hl,(WEAPON)	
	ld de,$1222
	call DISPHL
	ld hl,(DEFENSE)	
	ld de,$1822
	call DISPHL

	ld hl,MedKit
	ld de,$1E0F
	call DISPSTRING
	ld hl,MagKit
	ld de,$240D
	call DISPSTRING

	ld hl,WhichItems
	ld a,(hl)
	ld l,a
	ld h,0
	ld de,$1E22
	call DISPHL
	ld hl,WhichItems
	inc hl
	ld a,(hl)
	ld l,a
	ld h,0
	ld de,$2422
	call DISPHL
	jp RETFROMSTATS

SEARCHFOR:
	ld hl,YouFind
	ld de,$060B
	call DISPSTRING
	call DELAY3	
	call DELAY3	
	ld a,(DUNGEONCHECK)
	or a
	jr nz,NOCHECKPLACE
CHECKPLACE:
	ld a,(SCENARIO)
	cp 9
	jr c,NOCHECKPLACE
	cp 10
	jr z,NOCHEST
	call CHESTPLACER
	ld (hl),6
	jr YESCHEST
NOCHEST:
	call CHESTPLACER
	ld (hl),0
YESCHEST:
	ld hl,(X)	
	ld de,$0020
	and a
	sbc hl,de
	jr nz,FINDNOTHING
	call DRAWWALLS
	ld de,$1C1E
	ld hl,acave
	call DISPSTRING3
	call ERASESCREEN
	LD DE,711
	ld bc,$131B
	ld a,-2
	jp MAP4PLACER2	
NOCHECKPLACE:
	ld a,(SCENARIO)
	cp 3
	jr z,DUNGEON1SEARCH	
	cp 8
	jr nc,BANDITSEARCH
FINDNOTHING:
	ld hl,Search
	ld de,$0C0B
	call DISPSTRING
RETFROMSTATS9:
	jp RETFROMSTATS
BANDITSEARCH:
	ld a,(DUNGEONCHECK)
	cp -1
	jr z,LASTSEARCH
	ld hl,(X)	
	ld de,$1002
	and a
	sbc hl,de
	jr nz,FINDNOTHING
	ld hl,aswitch
	ld de,$0C0B
	call DISPSTRING
	ld hl,MAP3
	ld de,653
	add hl,de
	ld (hl),0
	jr RETFROMSTATS9		
LASTSEARCH:
	ld hl,(X)	
	ld de,$0E14
	and a
	sbc hl,de
	jr nz,FINDNOTHING
	ld hl,aswitch
	ld de,$0C0B
	call DISPSTRING
	ld hl,MAP4
	ld de,597
	add hl,de
	ld (hl),0
	jr RETFROMSTATS9		
DUNGEON1SEARCH:
	ld hl,(X)	
	ld de,$051C
	and a
	sbc hl,de
	jr nz,FINDNOTHING
	ld hl,thekey
	ld de,$0C0B
	call DISPSTRING3
	call DRAWWALLS
	ld hl,corpse
	ld de,$1C13
	call DISPSTRING3
	ld hl,mykey
	ld de,$2415
	call DISPSTRING3
	ld a,4
	ld (SCENARIO),a
	jp LEADER2
ITEMS:
	ld hl,ItemMenu
	ld de,$0505
	call DISPSTRING	
	ld hl,DELtoExit
	ld de,$3410
	call DISPSTRING
	call ITEMHEALS
RETITEM:
	call ITEMHEALS2
	ld hl,WhichItems
	push hl
USEITEMLOOP:
	call _getky
             cp G_1
             jr z,USEMEDKIT
             cp G_DEL
             jp z,ENDHEAL
             cp G_2
             jr nz,USEITEMLOOP
USEMAGKIT:
	pop hl
	inc hl
	ld a,(hl)
	or a
	jr z,RETITEM
	dec a
	ld (hl),a
	ld de,40
	call OVERMAXMP
	jr RETITEM
USEMEDKIT:
	pop hl
	ld a,(hl)
	or a
	jr z,RETITEM
	dec a
	ld (hl),a
	ld de,90
	call OVERMAXHP
	jr RETITEM	
HEALING:
	call ITEMHEALS
	call YESNO
	ld hl,willcost
	ld de,$2005
	call DISPSTRING	
REHEAL:
            	LD de,$1822
            	ld hl,BlankText
            	call DISPSTRING
            	LD de,$2016
            	ld hl,BlankText
            	call DISPSTRING
DIDNTHEAL:
	ld de,(HP)
	ld hl,(MAXHP)
	and a
	sbc hl,de
	srl h
	rr l
	srl h
	rr l
	push hl
	ld de,$2016
	call DISPHL
	call ITEMHEALS2
HEALINGLOOP:

	call _getky
             cp G_1
	jr z,USEHEAL          
             cp G_DEL
	jr z,ENDHEAL
             cp G_2
	jr nz,HEALINGLOOP
ENDHEAL:
	pop hl
	jp  RETFROMSTATS2
USEHEAL:
	pop hl
	ex de,hl
	ld hl,(MP)
	and a
	sbc hl,de
	jr c,DIDNTHEAL
	ld (MP),hl
	ld hl,(MAXHP)	
	ld (HP),hl
	jr REHEAL
ITEMHEALS:
	ld hl,HPstr
	ld de,$1217
	call DISPSTRING
	ld hl,MPstr
	ld de,$1815
	call DISPSTRING
ITEMHEALS2:
	ld hl,(HP)	
	ld de,$1222
	call DISPHL
	ld hl,(MP)	
	ld de,$1822
	jp DISPHL
DRAWWIDE:
	ld a,$40
	ld (BKX),a
	ld hl,WIDECURSOR
	call drawit
	ld a,(BKX)
	add a,8		
	ld (BKX),a
	ld hl,WIDECURSOR
	call drawit
	ld a,(BKX)
	add a,8		
	ld (BKX),a
	ld hl,WIDECURSOR
	jp drawit
	

CAVEORELSE:
	ld a,(DUNGEONCHECK)
	cp 5
	jr z,OTHERSIDE
	or a
	jp nz,KEYLOOP
SIDE1:
	ld de,13
	ld hl,$000D
	ld a,3
	jp MAP2PLACER2
OTHERSIDE:
	ld bc,(X)
	ld a,b
	cp 8
	jr z,OTHERSIDECAVE
	cp 2
	jr z,OTHERCAVE
OLDMANCAVE:
	LD DE,699
	ld hl,$130F
        	ld a,10
MAP3PLACER:
	ld (DUNGEONCHECK),a
	ld bc,MAP3
	ld (MAPVAR),bc
	push de
	LD (X),HL
	LD HL,BITMAPS2
	LD (BMPLOC),HL
	LD HL,MAP3
	LD (MAPSTART),HL
	pop de
	ADD HL,DE
	jp UPDATEMOVE
OTHERCAVE:
	ld a,(SCENARIO)
	cp 6
	jp c,LOCKED
	LD DE,504
	ld hl,$0E00
        	ld a,4
	jr MAP3PLACER

OTHERSIDECAVE:
	ld de,305
	ld hl,$080B
	ld a,3
	jr MAP2PLACER23
CASTLE:
	ld a,(DUNGEONCHECK)
	cp 5
	jr z,BANDITCASTLE
	LD DE,438
        	LD HL,$0C06
	ld a,1	
MAP2PLACER23: ;;to save bytes
	jp MAP2PLACER2
BANDITCASTLE:
	ld hl,MAP3
	ld de,653
	add hl,de
	ld (hl),7
	call DRAWWALLS
	ld de,$1C10
	ld hl,BanditCastle
	call DISPSTRING3
	call ERASESCREEN
	LD DE,688
        	LD HL,$1304
	ld a,7	
	jr MAP3PLACER
ITEMSHOP:
	ld hl,ItemShop
	call DISPSTRING
	ld hl,ItemMenu
	ld de,$0E0A
	call DISPSTRING	
	ld hl,ItemStore
	ld de,$150A
	call DISPSTRING	
FROMISHOP2:
	push hl
FROMISHOP:	
	ld hl,(GOLD)	
	ld de,$3622
	call DISPHL
	pop hl
	ld hl,WhichItems
	push hl	
ISHOPLOOP:
	call _getky
	cp G_1
	jr z,BUYMED
	cp G_2
	jr z,BUYMAG
	cp G_DEL
	jp z,ENDHEAL
	cp G_3
	jr nz,ISHOPLOOP
BUYBOMB:
	pop hl
	inc hl
	inc hl
	jr ISHOPCONT
BUYMAG:
	pop hl
	inc hl
	jr ISHOPCONT
BUYMED:
	pop hl
ISHOPCONT:
	push hl
	ld hl,(GOLD)
	ld de,30
	and a
	sbc hl,de
	jr c,FROMISHOP
	ld (GOLD),hl
	pop hl
	ld a,(hl)
	inc a
	ld (hl),a

	ld hl,ThankYou
	ld de,$2D17
	call DISPSTRING
	call DELAY3
	ld hl,BlankText
	ld de,$2D17
	call DISPSTRING
	ld hl,BlankText
	ld de,$2D24
	call DISPSTRING
	ld hl,BlankText
	ld de,$3621
	call DISPSTRING
	jr FROMISHOP2
CASTLEORMAN:
	ld a,(DUNGEONCHECK)
	cp 8
	jp c,CASTLE	

	call DRAWWALLS
	ld hl,gold
	ld de,$360F
	call DISPSTRING
	ld hl,(GOLD)	
	ld de,$3622
	call DISPHL
	call DELEXIT
	ld de,$0505
	ld bc,(X)
	ld a,c
	cp 12 
	jp z,ITEMSHOP
	cp 18
	jp z,INN
	cp 14
	jp z,ARMORSHOP
	cp 19
	jp z,DEADMAN
WEAPONSHOP:
	ld hl,WeaponShop
	call DISPSTRING
	call DISPWPNSET1
	ld hl,180
	ld de,$0E40
	call DISPHL
	ld hl,700
	ld de,$1440
	call DISPHL
	ld hl,3400
	ld de,$1A40
	call DISPHL
	ld hl,8000
	ld de,$2040
	call DISPHL
	ld hl,12000
	ld de,$2640
	call DISPHL
WPNLOOP:
	call _getky
	cp G_2
	jr z,WPN2
	cp G_3
	jr z,WPN3
	cp G_4
	jr z,WPN4
	cp G_5
	jr z,WPN5
	cp G_DEL
	jp z,RETFROMSTATS2
	cp G_1
	jr nz,WPNLOOP
WPN1:
	ld de,180
	ld bc,15
	jr WPNDONE
WPN2:
	ld de,700
	ld bc,45
	jr WPNDONE
WPN3:
	ld de,3400
	ld bc,90
	jr WPNDONE
WPN4:
	ld de,8000
	ld bc,120
	jr WPNDONE
WPN5:
	ld de,12000
	ld bc,220
WPNDONE:
	ld hl,(GOLD)
	and a
	sbc hl,de
	jr c,WPNLOOP
	ld (GOLD),hl
	ld (WEAPON),bc
	jp THANKYOU
ARMORSHOP:
	ld hl,ArmorShop
	call DISPSTRING
	call DISPWPNSET1
	ld hl,220
	ld de,$0E40
	call DISPHL
	ld hl,700
	ld de,$1440
	call DISPHL
	ld hl,2500
	ld de,$1A40
	call DISPHL
	ld hl,5666
	ld de,$2040
	call DISPHL
	ld hl,9999
	ld de,$2640
	call DISPHL
ARMRLOOP:
	call _getky
	cp G_2
	jr z,ARM2
	cp G_3
	jr z,ARM3
	cp G_4
	jr z,ARM4
	cp G_5
	jr z,ARM5
	cp G_DEL
	jp z,RETFROMSTATS2
	cp G_1
	jr nz,ARMRLOOP
ARM1:
	ld de,220
	ld bc,20
	jr ARMRDONE
ARM2:
	ld de,700
	ld bc,41
	jr ARMRDONE
ARM3:
	ld de,2500
	ld bc,65
	jr ARMRDONE
ARM4:
	ld de,5666
	ld bc,91
	jr ARMRDONE
ARM5:
	ld de,9999
	ld bc,120
ARMRDONE:
	ld hl,(GOLD)
	and a
	sbc hl,de
	jr c,ARMRLOOP
	ld (GOLD),hl
	ld (DEFENSE),bc
	jp THANKYOU

OLDMAN:  ;; in the cave, aligned with inn, 
	call DRAWWALLS
	ld a,(SCENARIO)
	cp 6
	jr nc,NOTHINGMANSAYS
	ld de,$1004
	ld hl,OldManText1
	call DISPSTRING	
	ld de,$1604
	ld hl,OldManText2
	call DISPSTRING	
	ld de,$1D04
	ld hl,OldManText3
	call DISPSTRING	
	ld de,$2404
	ld hl,thekey
	call DISPSTRING	
	call TALK8
	call TALK9
	ld a,6
	ld (SCENARIO),a
NOSCENADD:
	jp RETFROMSTATS2

NOTHINGMANSAYS:
	ld de,$1C10
	ld hl,saysnothing
	call DISPSTRING3
	jr NOSCENADD
INN:
	ld a,(DUNGEONCHECK)
	cp 10
	jr z,OLDMAN
	ld hl,Inn
	ld de,$1213
	call DISPSTRING
	ld hl,OneNight
	ld de,$1A13
	call DISPSTRING
	call ADD20LOOP
	ld (DUMMY1),hl
	ld de,$1A35
	call DISPHL
	call YESNO
INNLOOP:
	call _getky
             cp G_2
             jr z,SAVENOINN
	cp G_DEL
	jr z,SAVENOINN       
             cp G_1
	jr nz,INNLOOP
YESINN:	
	ld de,(DUMMY1)
	ld hl,(GOLD)
	and a
	sbc hl,de
	jr c,INNLOOP
	ld (GOLD),hl
	ld b,40
INNFLASHLOOP:
	push bc
	call INVERTSCREEN
	pop bc
	djnz INNFLASHLOOP
	ld hl,Restored
	ld de,$2620
	call DISPSTRING
	ld hl,(MAXHP)
	ld de,(MAXMP)
	ld (HP),hl
	ld (MP),de	

SAVENOINN:		
	call DRAWWALLS
	ld hl,SaveGame
	ld de,$0505
	call DISPSTRING	
	call DELEXIT
SAVELOOP:
	call _getky
             cp G_2
	jr z,SAVEGAME2       
	cp G_DEL
	jp z,RETFROMSTATS2
             cp G_1
             jr nz,SAVELOOP
SAVEGAME1:
	ld hl,SaveSSI
	ld (DUMMY1),hl
        	LD DE,SAVERAM
	ld hl,scenario1
	jr SAVEGAME
SAVEGAME2:	
	ld hl,SaveSSI2
	ld (DUMMY1),hl
        	LD DE,SAVERAM2
	ld hl,scenario2
SAVEGAME:
	push hl
        	LD HL,TOLEVEL
        	LD BC,28
        	LDIR
	ld de,(DUMMY1)
	ld hl,WhichSpells
 	ld bc,24
 	ldir
	pop hl
	ld a,(SCENARIO)
	ld (hl),a
	ld hl,Saved
	ld de,$2120
	call DISPSTRING
	call SaveStatusofString
	jr THANX
ADD20LOOP:
	ld de,20
	jr READDLOOP
ADD30LOOP:
	ld de,30
READDLOOP:
	ld a,(KURAILEVEL)
	ld b,a
	ld hl,0
ADDINLOOP:
	add hl,de
	djnz ADDINLOOP
	ret
DISPWPNSET1:
	ld hl,willcost
	ld de,$0540
	call DISPSTRING
	ld hl,WAset1
	ld de,$0E0A
	call DISPSTRING	
	ld hl,WAset2
	ld de,$140A
	call DISPSTRING	
	ld hl,WAset3
	ld de,$1A0A
	call DISPSTRING	
	ld hl,WAset4
	ld de,$200A
	call DISPSTRING	
	ld hl,WAset5
	ld de,$260A
	jp DISPSTRING	
THANKYOU:
	ld hl,ThankYou
	ld de,$2D17
	call DISPSTRING
THANX:
	jp  RETFROMSTATS	
DEADMAN:
	call DRAWWALLS
	ld de,$0D0B
	ld a,(SCENARIO)
	cp 5
	jp nc,MAN2
	ld hl,ManText1
	call DISPSTRING	
	ld de,$140B
	ld hl,ManText2
	call DISPSTRING	
	ld de,$1B0B
	ld hl,ManText3
	call DISPSTRING	
	ld de,$220B
	ld hl,ManText4
	call DISPSTRING	
	ld de,$290B
	ld hl,ManText5
	call DISPSTRING3
	call DRAWWALLS
	ld de,$1C09
	ld hl,ManText6
	call DISPSTRING3
	call YESNO
	ld de,$1114
	ld hl,ManText7
	call DISPSTRING	
	call DEADORLIVEMAN
	ld (hl),0
	ld a,1	
	ld (NUMBEROFENEMIES),a
	ld a,3	
	ld (SCENARIO),a
KILLMANLOOP:
	call _getky
             cp G_1
             jp z,GIMPMAN
             cp G_2
	jr nz,KILLMANLOOP
FLEEMAN:
	ld de,$260A
	ld hl,ManText8
	call DISPSTRING3
	call ERASESCREEN
	jp  LEADER1TOWN ;; yay! you get to fight an xtech soldier! =)))
ABOUTSWITCH:
	ld de,$1A07
	ld hl,manswitch
	call DISPSTRING	
	ld de,$2107
	ld hl,BanditCastle
	call DISPSTRING
	jp RETFROMSTATS
MAN2:
	ld a,(SCENARIO)
	cp 9
	jp nc,NOTHINGMANSAYS
	cp 8
	jr nc,ABOUTSWITCH
	ld hl,ManText9
	call DISPSTRING	
	ld de,$0D0B
	ld hl,ManText10
	call DISPSTRING	
	ld de,$140B
	ld hl,ManText11
	call DISPSTRING	
	ld de,$1B0B
	ld hl,ManText12
	call DISPSTRING	
	ld de,$220B
	ld hl,ManText14
	call DISPSTRING	
	call TALK6
	call DRAWWALLS
	ld de,$140B
	ld hl,ManText16
	call DISPSTRING	
	ld de,$1B0B
	ld hl,ManText17
	call DISPSTRING	
	call TALK7
	call DRAWWALLS
	ld de,$140B
	ld hl,ManText18
	call DISPSTRING	
	ld de,$1B0B
	ld hl,ManText20
	call DISPSTRING	
	ld de,$220B
	ld hl,ManText21
	call DISPSTRING3
	call DRAWWALLS
	ld de,$140B
	ld hl,ManText23
	call DISPSTRING	
	ld de,$1B0B
	ld hl,ManText25
	call DISPSTRING	
	ld de,$220B
	ld hl,ManText26
	call DISPSTRING
	jp RETFROMSTATS



TALK6:
	ld bc,KuraiText17
	ld de,KuraiText16
	jp KURAITALKSWO32
TALK8:
	ld bc,KuraiText22
	ld de,KuraiText21
	jp KURAITALKSWO32
TALK9:
	ld bc,KuraiText24
	ld de,KuraiText23
	jp KURAITALKSWO3
TALK7:
	ld bc,KuraiText20
	ld de,KuraiText19
	jp KURAITALKSWO32
TALK1:
	ld a,1
	ld (SCENARIO),a
	ld de,KuraiText4
	ld bc,KuraiText5
	ld hl,KuraiText6
	jp KURAITALKS


CHESTINIT:
	ld (MAPVAR),hl
	ld b,6
	ex de,hl
INITCHESTS:
	push hl
	call _ldhlind     ;; puts (hl) into hl
	ld de,(MAPVAR)
	add hl,de
	ld (hl),6
	pop hl
	inc hl
	inc hl
	djnz INITCHESTS
	RET

DataName:
	.db 4,"data"

data = TEXT_MEM3+120

;_getky equates

G_NONE    = $00 ; NO KEY
G_TAN     = $16 ; TAN
G_XTO     = $28 ; x,T,theta|
G_DOWN    = $01 ; DOWN
G_VARS    = $17 ; VARS
G_ON      = $29 ; ON
G_LEFT    = $02 ; LEFT
G_PERIODE = $19 ; .
G_STO     = $2A ; STO>
G_RIGTH   = $03 ; RIGHT
G_RIGHT   = $03 ; RIGHT
G_2       = $1A ; 2
G_LN      = $2B ; LN
G_UP      = $04 ; UP
G_5       = $1B ; 5
G_LOG     = $2C ; LOG
G_ENTER   = $09 ; ENTER
G_8       = $1C ; 8
G_SQR     = $2D ; X^2
G_PLUS    = $0A ; +
G_LPARAN  = $1D ; (
G_INVERSE = $2E ; X^-1
G_MINUS   = $0B ; -
G_COS     = $1E ; COS
G_MATH    = $2F ; MATH
G_TIMES   = $0C ; *
G_PRGM    = $1F ; PRGM
G_ALPHA   = $30 ; ALPHA
G_DIV     = $0D ; /
G_STAT    = $20 ; STAT
G_GRAPH   = $31 ; GRAPH
G_POWER   = $0E ; ^
G_0       = $21 ; 0
G_TRACE   = $32 ; TRACE
G_CLEAR   = $0F ; CLEAR
G_1       = $22 ; 1
G_ZOOM    = $33 ; ZOOM
G_NEG     = $11 ; (-)
G_4       = $23 ; 4
G_WINDOW  = $34 ; WINDOW
G_3       = $12 ; 3
G_7       = $24 ; 7
G_YEDIT   = $35 ; Y=
G_6       = $13 ; 6
G_COMMA   = $25 ; ,
G_2nd     = $36 ; 2nd
G_9       = $14 ; 9
G_SIN     = $26 ; SIN
G_MODE    = $37 ; MODE
G_RPARAN  = $15 ; )
G_MATRIX  = $27 ; MATRIX
G_DEL     = $38 ; DEL


SaveSSI:
	.dw 0,0,0,0,0,0,0,0,0,0,0,0
	;;Spell Skill Item
SaveSSI2:
	.dw 0,0,0,0,0,0,0,0,0,0,0,0
	;;Spell Skill Item
SAVERAM:
	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0
		;; just my little cheat.. =) will be set back to ZERO.
scenario1:
	.db 0 ;; will be reset to ZERO...my cheat again =]
SAVERAM2:
	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0
scenario2:
	.db 0


.end
